"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteService = exports.ListServices = exports.CreateService = exports.SERVICE_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var v1_1 = require("kubernetes-models/v1");
var common_1 = require("../common");
var SERVICE_TEMPLATE = function (args) {
    return new v1_1.Service({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
        },
        spec: {
            ports: [
                {
                    name: "8080-tcp",
                    protocol: "TCP",
                    port: 8080,
                    targetPort: 8080,
                },
            ],
            selector: {
                app: args.resourceName,
                deploymentconfig: args.resourceName,
            },
        },
    }).toJSON();
};
exports.SERVICE_TEMPLATE = SERVICE_TEMPLATE;
var CreateService = (function (_super) {
    __extends(CreateService, _super);
    function CreateService(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateService.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateService.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.SERVICE_TEMPLATE)(__assign({}, this.args)));
    };
    CreateService.prototype.endpoint = function () {
        return "/api/".concat(v1_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services");
    };
    return CreateService;
}(ResourceFetch_1.ResourceFetch));
exports.CreateService = CreateService;
var ListServices = (function (_super) {
    __extends(ListServices, _super);
    function ListServices() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ListServices.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    ListServices.prototype.endpoint = function () {
        return "/api/".concat(v1_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services");
    };
    return ListServices;
}(ResourceFetch_1.ResourceFetch));
exports.ListServices = ListServices;
var DeleteService = (function (_super) {
    __extends(DeleteService, _super);
    function DeleteService(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteService.prototype.body = function () {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    };
    DeleteService.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteService.prototype.endpoint = function () {
        return "/api/".concat(v1_1.Service.apiVersion, "/namespaces/").concat(this.args.namespace, "/services/").concat(this.args.resourceName);
    };
    return DeleteService;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteService = DeleteService;
//# sourceMappingURL=Service.js.map