export const sourceHandler = (source) => {
    var _a, _b;
    const reactReg = /import React, {[^}]*}.*(?=["']react['"]).*/gim;
    const patternflyReg = /import {[^}]*}.*(?=['"]@patternfly\/react-core['"]).*/gim;
    const regexvalueReact = new RegExp(reactReg);
    const reactImport = regexvalueReact.exec(source);
    const reg = /\{([^)]+)\}/;
    if (!reactImport) {
        return;
    }
    const reactElements = (_a = reg.exec(reactImport[0])) === null || _a === void 0 ? void 0 : _a[1];
    const regexvaluePat = new RegExp(patternflyReg);
    const patternflyImport = regexvaluePat.exec(source);
    if (!patternflyImport) {
        return;
    }
    const patternflyElements = (_b = reg.exec(patternflyImport[0])) === null || _b === void 0 ? void 0 : _b[1];
    const trimmedSource = source.split(reactReg).join("").trim().split(patternflyReg).join("").trim();
    const formName = trimmedSource.split(":")[0].split("const ")[1];
    return { reactElements: reactElements, patternflyElements: patternflyElements, formName, trimmedSource };
};
//# sourceMappingURL=utils.js.map