import * as React from "react";
export class ErrorBoundary extends React.Component {
    constructor(props) {
        super(props);
        this.state = { hasError: false };
    }
    reset() {
        var _a, _b;
        (_b = (_a = this.props).setError) === null || _b === void 0 ? void 0 : _b.call(_a, null);
        this.setState({ hasError: false });
    }
    componentDidCatch(error, errorInfo) {
        var _a, _b;
        (_b = (_a = this.props).setError) === null || _b === void 0 ? void 0 : _b.call(_a, error);
        console.error(error);
    }
    render() {
        if (this.state.hasError) {
            return this.props.error;
        }
        return this.props.children;
    }
    static getDerivedStateFromError(error) {
        return { hasError: true };
    }
}
export default ErrorBoundary;
//# sourceMappingURL=ErrorBoundary.js.map