"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidationRegistry = exports.ValidationEntry = void 0;
var ValidationStore_1 = require("./ValidationStore");
var ValidationEntry = (function () {
    function ValidationEntry(level, message) {
        this.level = level;
        this.message = message;
    }
    return ValidationEntry;
}());
exports.ValidationEntry = ValidationEntry;
var ValidationRegistry = (function () {
    function ValidationRegistry() {
        var _this = this;
        this.store = new ValidationStore_1.ValidationStore();
        this.set = function (path, entry) {
            _this.store.set(path, entry);
        };
        this.get = function (path) {
            return _this.store.get(path);
        };
        this.clear = function (path) {
            _this.store.clear(path);
        };
    }
    return ValidationRegistry;
}());
exports.ValidationRegistry = ValidationRegistry;
//# sourceMappingURL=ValidationRegistry.js.map