"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var atoms_1 = require("../atoms");
require("./OutputFieldRow.scss");
var atoms_2 = require("../../EditorCore/atoms");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var OutputFieldRow = function (props) {
    var modelIndex = props.modelIndex, outputFieldIndex = props.outputFieldIndex, outputField = props.outputField, onEditOutputField = props.onEditOutputField, onDeleteOutputField = props.onDeleteOutputField;
    var _a = (0, react_1.useMemo)(function () {
        return {
            name: outputField === null || outputField === void 0 ? void 0 : outputField.name,
            dataType: outputField === null || outputField === void 0 ? void 0 : outputField.dataType,
            optype: outputField === null || outputField === void 0 ? void 0 : outputField.optype,
            targetField: outputField === null || outputField === void 0 ? void 0 : outputField.targetField,
            feature: outputField === null || outputField === void 0 ? void 0 : outputField.feature,
            value: outputField === null || outputField === void 0 ? void 0 : outputField.value,
            rank: outputField === null || outputField === void 0 ? void 0 : outputField.rank,
            rankOrder: outputField === null || outputField === void 0 ? void 0 : outputField.rankOrder,
            segmentId: outputField === null || outputField === void 0 ? void 0 : outputField.segmentId,
            isFinalResult: outputField === null || outputField === void 0 ? void 0 : outputField.isFinalResult,
        };
    }, [outputField]), name = _a.name, dataType = _a.dataType, optype = _a.optype, targetField = _a.targetField, feature = _a.feature, value = _a.value, rank = _a.rank, rankOrder = _a.rankOrder, segmentId = _a.segmentId, isFinalResult = _a.isFinalResult;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).build()); }, [outputFieldIndex, modelIndex, outputField]);
    var targetFieldValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build());
    }, [outputFieldIndex, modelIndex, outputField]);
    var handleEdit = function (event) {
        event.preventDefault();
        event.stopPropagation();
        onEditOutputField();
    };
    return ((0, jsx_runtime_1.jsx)("section", __assign({ id: "output-field-n".concat(outputFieldIndex), "data-testid": "output-field-n".concat(outputFieldIndex), className: "editable-item__inner", onClick: function (event) { return handleEdit(event); }, onKeyDown: function (event) {
            if (event.key === "Enter") {
                handleEdit(event);
            }
        }, "data-ouia-component-type": "output-field", tabIndex: 0 }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, style: { height: "100%" } }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(atoms_2.ValidationIndicator, { validations: validations }) }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ "data-ouia-component-type": "output-field-name" }, { children: (0, jsx_runtime_1.jsx)("strong", { children: name }) })), (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, __assign({ isFilled: true }, { children: [(0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ color: "blue", className: "output-item__type-label" }, { children: dataType })), (0, jsx_runtime_1.jsx)(atoms_1.OutputLabels, { optype: optype, targetField: targetField, targetFieldValidation: targetFieldValidation, feature: feature, value: value, rank: rank, rankOrder: rankOrder, segmentId: segmentId, isFinalResult: isFinalResult })] })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(atoms_1.OutputFieldRowAction, { index: outputFieldIndex, onDelete: onDeleteOutputField, "data-ouia-component-type": "output-field-delete" }) })] })) })));
};
exports.default = OutputFieldRow;
//# sourceMappingURL=OutputFieldRow.js.map