"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertFromDataField = exports.convertToDataField = exports.convertPMML2DD = void 0;
var DataDictionaryContainer_1 = require("./DataDictionaryContainer/DataDictionaryContainer");
var convertPMML2DD = function (PMMLDataDictionary) {
    if (PMMLDataDictionary === undefined) {
        return [];
    }
    else {
        return PMMLDataDictionary.DataField.filter(function (item) { return item.dataType !== undefined; }).map(function (item) {
            return (0, exports.convertFromDataField)(item);
        });
    }
};
exports.convertPMML2DD = convertPMML2DD;
var convertToDataField = function (item) {
    var convertedField = {
        name: item.name,
        dataType: item.type,
        optype: item.optype,
    };
    convertedField.displayName = item.displayName;
    if (item.isCyclic !== undefined) {
        convertedField.isCyclic = item.isCyclic ? "1" : "0";
    }
    if (item.missingValue) {
        convertedField.Value = convertedField.Value || [];
        convertedField.Value.push({
            property: "missing",
            value: item.missingValue,
        });
    }
    if (item.invalidValue) {
        convertedField.Value = convertedField.Value || [];
        convertedField.Value.push({
            property: "invalid",
            value: item.invalidValue,
        });
    }
    if (item.constraints) {
        if (item.constraints.type === DataDictionaryContainer_1.ConstraintType.RANGE && item.constraints.value.length > 0) {
            convertedField.Interval = item.constraints.value.map(function (range) {
                var _a, _b;
                var interval = {
                    closure: "".concat(((_a = range === null || range === void 0 ? void 0 : range.start) === null || _a === void 0 ? void 0 : _a.included) ? "closed" : "open").concat(((_b = range === null || range === void 0 ? void 0 : range.end) === null || _b === void 0 ? void 0 : _b.included) ? "Closed" : "Open"),
                };
                if (range.start && range.start.value) {
                    interval.leftMargin = Number(range.start.value);
                }
                if (range.end && range.end.value) {
                    interval.rightMargin = Number(range.end.value);
                }
                return interval;
            });
        }
        if (item.constraints.type === DataDictionaryContainer_1.ConstraintType.ENUMERATION && item.constraints.value.length > 0) {
            convertedField.Value = (convertedField.Value || []).concat(item.constraints.value.map(function (value) {
                return { value: value };
            }));
        }
    }
    return convertedField;
};
exports.convertToDataField = convertToDataField;
var convertFromDataField = function (item) {
    var type;
    if (item.dataType === "string" ||
        item.dataType === "integer" ||
        item.dataType === "float" ||
        item.dataType === "double" ||
        item.dataType === "boolean") {
        type = item.dataType;
    }
    else {
        type = "string";
    }
    var convertedField = {
        name: item.name,
        type: type,
        optype: item.optype,
    };
    if (item.displayName) {
        convertedField.displayName = item.displayName;
    }
    if (item.isCyclic !== undefined) {
        convertedField.isCyclic = item.isCyclic === "1";
    }
    if (item.Value) {
        item.Value.forEach(function (value) {
            if (value.property === "missing") {
                convertedField.missingValue = value.value;
            }
            if (value.property === "invalid") {
                convertedField.invalidValue = value.value;
            }
            if (value.property === "valid" || value.property === undefined) {
                convertedField.constraints = convertedField.constraints || {
                    type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                    value: [],
                };
                convertedField.constraints.value.push(value.value);
            }
        });
    }
    if (item.Interval && item.Interval.length > 0) {
        convertedField.constraints = {
            type: DataDictionaryContainer_1.ConstraintType.RANGE,
            value: item.Interval.map(function (interval) {
                var _a, _b, _c, _d;
                return {
                    start: {
                        value: (_b = (_a = interval.leftMargin) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "",
                        included: interval.closure.startsWith("closed"),
                    },
                    end: {
                        value: (_d = (_c = interval.rightMargin) === null || _c === void 0 ? void 0 : _c.toString()) !== null && _d !== void 0 ? _d : "",
                        included: interval.closure.endsWith("Closed"),
                    },
                };
            }),
        };
    }
    return convertedField;
};
exports.convertFromDataField = convertFromDataField;
//# sourceMappingURL=dataDictionaryUtils.js.map