"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var selenium_webdriver_1 = require("selenium-webdriver");
var chrome_1 = require("selenium-webdriver/chrome");
var fs_1 = require("fs");
var ErrorProcessor_1 = require("./ErrorProcessor");
var path_1 = require("path");
var Driver = (function () {
    function Driver() {
    }
    Driver.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var chromeExtensionPath, CHROME_DIR, chromeOptions, LOGS_DIR, chromeServiceBuilder, driver;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        chromeExtensionPath = process.env.UNZIPPED_CHROME_EXTENSION_PATH
                            ? (0, path_1.resolve)(process.env.UNZIPPED_CHROME_EXTENSION_PATH)
                            : (0, path_1.resolve)("dist");
                        if (!(0, fs_1.existsSync)(chromeExtensionPath)) {
                            throw new Error("Please set UNZIPPED_CHROME_EXTENSION_PATH variable to unzipped Chrome extension directory. " +
                                "For example: export UNZIPPED_CHROME_EXTENSION_PATH=/path/to/dist. " +
                                "Directory " +
                                chromeExtensionPath +
                                " does not exist.");
                        }
                        CHROME_DIR = (0, path_1.resolve)("dist-tests-e2e", "chrome_data");
                        if (!(0, fs_1.existsSync)(CHROME_DIR)) {
                            (0, fs_1.mkdirSync)(CHROME_DIR, { recursive: true });
                        }
                        chromeOptions = new chrome_1.Options();
                        chromeOptions.addArguments("--user-data-dir=" + CHROME_DIR, "--load-extension=" + chromeExtensionPath, "--enable-features=UnexpireFlagsM118", "--allow-insecure-localhost", "--disable-web-security", "--remote-allow-origins=*", "--disable-gpu");
                        LOGS_DIR = (0, path_1.resolve)("dist-tests-e2e", "logs");
                        if (!(0, fs_1.existsSync)(LOGS_DIR)) {
                            (0, fs_1.mkdirSync)(LOGS_DIR, { recursive: true });
                        }
                        chromeServiceBuilder = new chrome_1.ServiceBuilder();
                        chromeServiceBuilder.loggingTo(LOGS_DIR + "/chromedriver.log").enableVerboseLogging();
                        return [4, new selenium_webdriver_1.Builder()
                                .withCapabilities(selenium_webdriver_1.Capabilities.chrome())
                                .setChromeService(chromeServiceBuilder)
                                .forBrowser(selenium_webdriver_1.Browser.CHROME)
                                .setChromeOptions(chromeOptions)
                                .build()];
                    case 1:
                        driver = _a.sent();
                        return [4, ErrorProcessor_1.default.run(function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, driver.manage().window().maximize()];
                                    case 1: return [2, _a.sent()];
                                }
                            }); }); }, "Error while maximizing browser window.")];
                    case 2:
                        _a.sent();
                        return [2, driver];
                }
            });
        });
    };
    Driver.openUrl = function (driver, url) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, ErrorProcessor_1.default.run(function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4, driver.get(url)];
                                case 1: return [2, _a.sent()];
                            }
                        }); }); }, "Error while opening url: " + url)];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    Driver.quit = function (driver) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, ErrorProcessor_1.default.run(function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4, driver.quit()];
                                case 1: return [2, _a.sent()];
                            }
                        }); }); }, "Error while quiting driver.")];
                    case 1: return [2, _a.sent()];
                }
            });
        });
    };
    return Driver;
}());
exports.default = Driver;
//# sourceMappingURL=Driver.js.map