import { BpmnEditorChannelApi } from "../api";
import { EditorFactory, EditorInitArgs, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { BpmnEditor } from "./BpmnEditor";
import { DmnLanguageServiceExposedInteropApi } from "./exposedInteropApi/DmnLanguageServiceExposedInteropApi";
export interface CustomWindow extends Window {
    envelope: {
        dmnLanguageService: DmnLanguageServiceExposedInteropApi;
    };
}
export declare class BpmnEditorFactory implements EditorFactory<BpmnEditor, BpmnEditorChannelApi> {
    private readonly gwtEditorEnvelopeConfig;
    constructor(gwtEditorEnvelopeConfig: {
        shouldLoadResourcesDynamically: boolean;
    });
    createEditor(ctx: KogitoEditorEnvelopeContextType<BpmnEditorChannelApi>, initArgs: EditorInitArgs): Promise<BpmnEditor>;
}
//# sourceMappingURL=BpmnEditorFactory.d.ts.map