import * as React from "react";
import { useCallback, useMemo, useState } from "react";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
import wrapField from "./wrapField";
function isSelectOptionObject(toBeDetermined) {
    return typeof toBeDetermined === "object" && !Array.isArray(toBeDetermined) && toBeDetermined !== null;
}
function SelectInputsField(props) {
    const [expanded, setExpanded] = useState(false);
    const [selected, setSelected] = useState(() => {
        if (props.value === undefined) {
            return [];
        }
        if (props.value === null) {
            return "null";
        }
        if (Array.isArray(props.value)) {
            return [...props.value];
        }
        return props.value;
    });
    const parseSelection = useCallback((selection, fieldType) => {
        if (selection === null) {
            return `${selection}`;
        }
        const parsedSelection = isSelectOptionObject(selection) ? selection.toString() : selection;
        if (fieldType !== Array) {
            return parsedSelection !== "" ? `${parsedSelection}` : "";
        }
        if (Array.isArray(selected)) {
            if (selected.includes(`${parsedSelection}`)) {
                return selected.filter((s) => s !== `${parsedSelection}`);
            }
            return [`${parsedSelection}`, ...selected];
        }
        return [];
    }, [selected]);
    const handleSelect = useCallback((event, selection) => {
        if (selection === props.placeholder) {
            props.onChange(undefined);
            setSelected([]);
        }
        else {
            if (selection === "null") {
                props.onChange(null);
                setSelected("null");
            }
            else {
                const selectedItems = parseSelection(selection, props.fieldType);
                const onChanged = selection === null
                    ? null
                    : typeof selection === "number"
                        ? Array.isArray(selectedItems)
                            ? selectedItems.map((item) => JSON.parse(item))
                            : JSON.parse(selectedItems)
                        : selectedItems;
                props.onChange(onChanged);
                setSelected(selectedItems);
            }
        }
        setExpanded(false);
    }, [parseSelection, props]);
    const selectOptions = useMemo(() => {
        var _a;
        const options = [];
        if (props.placeholder) {
            options.push(React.createElement(SelectOption, { key: `placeholder ${props.allowedValues.length}`, isPlaceholder: true, value: props.placeholder }));
        }
        (_a = props.allowedValues) === null || _a === void 0 ? void 0 : _a.forEach((value) => options.push(React.createElement(SelectOption, { key: value, value: value }, props.transform ? props.transform(value) : `${value}`)));
        return options;
    }, [props]);
    return wrapField(props, React.createElement("div", { "data-testid": "select-inputs-field", id: props.id },
        React.createElement(Select, { isDisabled: props.disabled, id: props.id, variant: props.fieldType === Array ? SelectVariant.typeaheadMulti : SelectVariant.single, name: props.name, placeholderText: props.placeholder, isOpen: expanded, selections: selected, onToggle: (isExpanded) => setExpanded(isExpanded), onSelect: handleSelect, menuAppendTo: props.menuAppendTo, direction: props.direction }, selectOptions)));
}
export default SelectInputsField;
//# sourceMappingURL=SelectInputsField.js.map