"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DmnLanguageService = void 0;
var DmnDocumentData_1 = require("./DmnDocumentData");
var DmnDecision_1 = require("./DmnDecision");
var path = require("path");
var dmn_marshaller_1 = require("@kie-tools/dmn-marshaller");
var meta_1 = require("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/meta");
var Dmn15Spec_1 = require("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec");
var uuid_1 = require("uuid");
var INPUT_DATA = "inputData";
var XML_MIME = "text/xml";
var DECISION_NAME_ATTRIBUTE = "name";
var NAMESPACE = "namespace";
var DMN_NAME = "name";
var DECISION = "decision";
var DEFINITIONS = "definitions";
var generateUuid = function () {
    return "_".concat((0, uuid_1.v4)()).toLocaleUpperCase();
};
var EMPTY_DMN = function () { return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<definitions\n  xmlns=\"".concat(meta_1.ns.get(""), "\"\n  expressionLanguage=\"").concat(Dmn15Spec_1.DMN15_SPEC.expressionLanguage.default, "\"\n  namespace=\"https://kie.org/dmn/").concat(generateUuid(), "\"\n  id=\"").concat(generateUuid(), "\"\n  name=\"DMN").concat(generateUuid(), "\">\n</definitions>"); };
var DmnLanguageService = (function () {
    function DmnLanguageService(args) {
        this.args = args;
        this.parser = new DOMParser();
        this.inputDataRegEx = new RegExp("([a-z]*:)?(".concat(INPUT_DATA, ")"));
        this.decisionsTagRegExp = new RegExp("([a-z]*:)?(".concat(DECISION, ")"));
        this.definitionsTagRegExp = new RegExp("([a-z]*:)?(".concat(DEFINITIONS, ")"));
    }
    DmnLanguageService.prototype.buildImportIndexModel = function (normalizedPosixPathRelativeToTheWorkspaceRoot) {
        return __awaiter(this, void 0, void 0, function () {
            var xml;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.getModelXml({ normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot })];
                    case 1:
                        xml = _a.sent();
                        return [2, {
                                definitions: (0, dmn_marshaller_1.getMarshaller)(xml, { upgradeTo: "latest" }).parser.parse().definitions,
                                xml: xml,
                            }];
                }
            });
        });
    };
    DmnLanguageService.prototype.recusivelyPopulateImportIndex = function (normalizedPosixPathRelativeToTheWorkspaceRoot, importIndex, parents, depth) {
        var _a, _b, _c, _d, _e, _f;
        return __awaiter(this, void 0, void 0, function () {
            var model, _g, _h, _j, _k, hierarchy, basedir, _l, _m, i, locationUri, p, parents_1, parents_1_1, parent_1, parentHierarchy, _o, _p, i_1, parents_2, parents_2_1, parent_2, e_1_1;
            var e_1, _q, e_2, _r, e_3, _s, e_4, _t;
            return __generator(this, function (_u) {
                switch (_u.label) {
                    case 0:
                        if (depth === 0) {
                            return [2];
                        }
                        if (!((_a = importIndex.models.get(normalizedPosixPathRelativeToTheWorkspaceRoot)) !== null && _a !== void 0)) return [3, 1];
                        _g = _a;
                        return [3, 3];
                    case 1:
                        _j = (_h = importIndex.models)
                            .set;
                        _k = [normalizedPosixPathRelativeToTheWorkspaceRoot];
                        return [4, this.buildImportIndexModel(normalizedPosixPathRelativeToTheWorkspaceRoot)];
                    case 2:
                        _g = _j.apply(_h, _k.concat([_u.sent()]))
                            .get(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        _u.label = 3;
                    case 3:
                        model = _g;
                        hierarchy = (_b = importIndex.hierarchy.get(normalizedPosixPathRelativeToTheWorkspaceRoot)) !== null && _b !== void 0 ? _b : importIndex.hierarchy
                            .set(normalizedPosixPathRelativeToTheWorkspaceRoot, { immediate: new Set(), deep: new Set() })
                            .get(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        basedir = path.dirname(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        _u.label = 4;
                    case 4:
                        _u.trys.push([4, 9, 10, 11]);
                        _l = __values((_c = model.definitions.import) !== null && _c !== void 0 ? _c : []), _m = _l.next();
                        _u.label = 5;
                    case 5:
                        if (!!_m.done) return [3, 8];
                        i = _m.value;
                        locationUri = i["@_locationURI"];
                        if (!locationUri) {
                            console.warn("Ignoring import with namespace '".concat(i["@_namespace"], "' because it doesn't have a locationURI."));
                            return [3, 7];
                        }
                        p = path.posix.join(basedir, path.posix.normalize(locationUri));
                        if (hierarchy.immediate.has(p)) {
                            try {
                                for (parents_1 = (e_2 = void 0, __values(parents)), parents_1_1 = parents_1.next(); !parents_1_1.done; parents_1_1 = parents_1.next()) {
                                    parent_1 = parents_1_1.value;
                                    parentHierarchy = importIndex.hierarchy.get(parent_1);
                                    parentHierarchy === null || parentHierarchy === void 0 ? void 0 : parentHierarchy.deep.add(p);
                                    try {
                                        for (_o = (e_3 = void 0, __values((_e = (_d = importIndex.hierarchy.get(p)) === null || _d === void 0 ? void 0 : _d.deep) !== null && _e !== void 0 ? _e : [])), _p = _o.next(); !_p.done; _p = _o.next()) {
                                            i_1 = _p.value;
                                            parentHierarchy === null || parentHierarchy === void 0 ? void 0 : parentHierarchy.deep.add(i_1);
                                        }
                                    }
                                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                                    finally {
                                        try {
                                            if (_p && !_p.done && (_s = _o.return)) _s.call(_o);
                                        }
                                        finally { if (e_3) throw e_3.error; }
                                    }
                                }
                            }
                            catch (e_2_1) { e_2 = { error: e_2_1 }; }
                            finally {
                                try {
                                    if (parents_1_1 && !parents_1_1.done && (_r = parents_1.return)) _r.call(parents_1);
                                }
                                finally { if (e_2) throw e_2.error; }
                            }
                            return [3, 7];
                        }
                        hierarchy.immediate.add(p);
                        hierarchy.deep.add(p);
                        try {
                            for (parents_2 = (e_4 = void 0, __values(parents)), parents_2_1 = parents_2.next(); !parents_2_1.done; parents_2_1 = parents_2.next()) {
                                parent_2 = parents_2_1.value;
                                (_f = importIndex.hierarchy.get(parent_2)) === null || _f === void 0 ? void 0 : _f.deep.add(p);
                            }
                        }
                        catch (e_4_1) { e_4 = { error: e_4_1 }; }
                        finally {
                            try {
                                if (parents_2_1 && !parents_2_1.done && (_t = parents_2.return)) _t.call(parents_2);
                            }
                            finally { if (e_4) throw e_4.error; }
                        }
                        parents.push(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        return [4, this.recusivelyPopulateImportIndex(p, importIndex, parents, depth - 1)];
                    case 6:
                        _u.sent();
                        parents.pop();
                        _u.label = 7;
                    case 7:
                        _m = _l.next();
                        return [3, 5];
                    case 8: return [3, 11];
                    case 9:
                        e_1_1 = _u.sent();
                        e_1 = { error: e_1_1 };
                        return [3, 11];
                    case 10:
                        try {
                            if (_m && !_m.done && (_q = _l.return)) _q.call(_l);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7];
                    case 11: return [2];
                }
            });
        });
    };
    DmnLanguageService.prototype.buildImportIndex = function (resources, depth) {
        if (depth === void 0) { depth = -1; }
        return __awaiter(this, void 0, void 0, function () {
            var importIndex, resources_1, resources_1_1, r, e_5_1, error_1;
            var e_5, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _b.trys.push([0, 9, , 10]);
                        importIndex = {
                            hierarchy: new Map(),
                            models: new Map(resources.map(function (r) { return [
                                r.normalizedPosixPathRelativeToTheWorkspaceRoot,
                                {
                                    xml: r.content,
                                    definitions: (0, dmn_marshaller_1.getMarshaller)(r.content || EMPTY_DMN(), { upgradeTo: "latest" }).parser.parse().definitions,
                                },
                            ]; })),
                        };
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 6, 7, 8]);
                        resources_1 = __values(resources), resources_1_1 = resources_1.next();
                        _b.label = 2;
                    case 2:
                        if (!!resources_1_1.done) return [3, 5];
                        r = resources_1_1.value;
                        return [4, this.recusivelyPopulateImportIndex(r.normalizedPosixPathRelativeToTheWorkspaceRoot, importIndex, [], depth)];
                    case 3:
                        _b.sent();
                        _b.label = 4;
                    case 4:
                        resources_1_1 = resources_1.next();
                        return [3, 2];
                    case 5: return [3, 8];
                    case 6:
                        e_5_1 = _b.sent();
                        e_5 = { error: e_5_1 };
                        return [3, 8];
                    case 7:
                        try {
                            if (resources_1_1 && !resources_1_1.done && (_a = resources_1.return)) _a.call(resources_1);
                        }
                        finally { if (e_5) throw e_5.error; }
                        return [7];
                    case 8: return [2, importIndex];
                    case 9:
                        error_1 = _b.sent();
                        throw new Error("\nDMN LANGUAGE SERVICE - buildImportIndex: Error while getting imported models from model resources.\nTried to use the following model resources: ".concat(JSON.stringify(resources), "\nError details: ").concat(error_1));
                    case 10: return [2];
                }
            });
        });
    };
    DmnLanguageService.prototype.getPathFromNodeId = function (resources, nodeId) {
        var e_6, _a, e_7, _b;
        var _c, _d, _e;
        try {
            for (var resources_2 = __values(resources), resources_2_1 = resources_2.next(); !resources_2_1.done; resources_2_1 = resources_2.next()) {
                var resourceContent = resources_2_1.value;
                var xmlContent = this.parser.parseFromString((_c = resourceContent.content) !== null && _c !== void 0 ? _c : "", XML_MIME);
                var inputDataTag = this.inputDataRegEx.exec((_d = resourceContent.content) !== null && _d !== void 0 ? _d : "");
                var inputs = xmlContent.getElementsByTagName((_e = inputDataTag === null || inputDataTag === void 0 ? void 0 : inputDataTag[0]) !== null && _e !== void 0 ? _e : INPUT_DATA);
                try {
                    for (var _f = (e_7 = void 0, __values(Array.from(inputs))), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var input = _g.value;
                        if (input.id === nodeId) {
                            return resourceContent.normalizedPosixPathRelativeToTheWorkspaceRoot;
                        }
                    }
                }
                catch (e_7_1) { e_7 = { error: e_7_1 }; }
                finally {
                    try {
                        if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                    }
                    finally { if (e_7) throw e_7.error; }
                }
            }
        }
        catch (e_6_1) { e_6 = { error: e_6_1 }; }
        finally {
            try {
                if (resources_2_1 && !resources_2_1.done && (_a = resources_2.return)) _a.call(resources_2);
            }
            finally { if (e_6) throw e_6.error; }
        }
        return "";
    };
    DmnLanguageService.prototype.getDmnDocumentData = function (xml) {
        var xmlContent = this.parser.parseFromString(xml, XML_MIME);
        var definitionsTag = this.definitionsTagRegExp.exec(xml);
        var definitions = xmlContent.getElementsByTagName(definitionsTag ? definitionsTag[0] : DEFINITIONS);
        var definition = definitions[0];
        var namespace = definition.getAttribute(NAMESPACE);
        var dmnModelName = definition.getAttribute(DMN_NAME);
        var dmnDecisions = this.decisionsTagRegExp.exec(xml);
        var dmnDecisionsContent = xmlContent.getElementsByTagName(dmnDecisions ? dmnDecisions[0] : DECISION);
        var decisions = Array.from(dmnDecisionsContent)
            .map(function (decision) { return decision.getAttribute(DECISION_NAME_ATTRIBUTE); })
            .flatMap(function (decisionName) { return (decisionName ? [new DmnDecision_1.DmnDecision(decisionName)] : []); });
        return new DmnDocumentData_1.DmnDocumentData(namespace !== null && namespace !== void 0 ? namespace : "", dmnModelName !== null && dmnModelName !== void 0 ? dmnModelName : "", decisions);
    };
    DmnLanguageService.prototype.getSpecVersion = function (xml) {
        if (xml === "") {
            return;
        }
        try {
            return (0, dmn_marshaller_1.getMarshaller)(xml).originalVersion;
        }
        catch (error) {
            return;
        }
    };
    return DmnLanguageService;
}());
exports.DmnLanguageService = DmnLanguageService;
//# sourceMappingURL=DmnLanguageService.js.map