import React from "react";
import _ from "lodash";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStateSecondaryActions, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { convertActionsToButton } from "@kie-tools/runtime-tools-components/dist/utils";
const EmptyTaskForm = ({ userTask, formSchema, enabled, submit, ouiaId, ouiaSafe, }) => {
    const canTransition = () => {
        return !userTask.completed && !_.isEmpty(formSchema.phases);
    };
    const buildFormActions = () => {
        return formSchema.phases.map((phase) => {
            return {
                name: phase,
                execute: () => {
                    submit(phase);
                },
            };
        });
    };
    const actions = canTransition() ? (React.createElement(EmptyStateSecondaryActions, null, convertActionsToButton(buildFormActions(), enabled))) : null;
    return (React.createElement(Bullseye, Object.assign({}, componentOuiaProps(ouiaId, "empty-task-form", ouiaSafe)),
        React.createElement(EmptyState, { variant: "large" },
            React.createElement(EmptyStateIcon, { icon: InfoCircleIcon, color: "var(--pf-global--info-color--100)" }),
            React.createElement(Title, { headingLevel: "h4", size: "lg" }, "Cannot show task form"),
            React.createElement(EmptyStateBody, null,
                React.createElement("p", null,
                    "Task",
                    " ",
                    React.createElement("b", null,
                        userTask.referenceName,
                        " (",
                        userTask.id.substring(0, 5),
                        ")"),
                    "\u00A0doesn't have a form to show. This usually means that it doesn't require data to be filled by the user."),
                canTransition() && (React.createElement(React.Fragment, null,
                    React.createElement("br", null),
                    React.createElement("p", null, "You can still use the actions bellow to move the task to the next phase.")))),
            actions)));
};
export default EmptyTaskForm;
//# sourceMappingURL=EmptyTaskForm.js.map