import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import React from "react";
import ReactJson from "react-json-view";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import "../styles.css";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessVariables = ({ displayLabel, displaySuccess, ouiaId, ouiaSafe, setDisplayLabel, setUpdateJson, updateJson, processInstance, }) => {
    const handleVariablesChange = (e) => {
        setUpdateJson(Object.assign(Object.assign({}, updateJson), e.updated_src));
        setDisplayLabel(true);
    };
    const checkProcessStatus = processInstance.state === ProcessInstanceState.Completed || processInstance.state === ProcessInstanceState.Aborted
        ? false
        : handleVariablesChange;
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "process-variables", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Variables"),
            displayLabel && (React.createElement(Label, { color: "orange", icon: React.createElement(InfoCircleIcon, null) },
                " ",
                "Changes are not saved yet")),
            React.createElement(Label, { color: "green", icon: React.createElement(InfoCircleIcon, null), className: displaySuccess
                    ? "kogito-process-details--variables__label-fadeIn"
                    : "kogito-process-details--variables__label-fadeOut" },
                " ",
                "Changes are saved")),
        React.createElement(CardBody, null,
            React.createElement(TextContent, null,
                React.createElement("div", null,
                    React.createElement(ReactJson, { src: updateJson, name: false, onEdit: checkProcessStatus, onAdd: checkProcessStatus, onDelete: checkProcessStatus }))))));
};
export default React.memo(ProcessVariables);
//# sourceMappingURL=ProcessVariables.js.map