import { JobsManagementChannelApi, JobsManagementDriver } from "../api";
import { Job, JobStatus, BulkCancel, JobOperationResult, JobsSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export declare class JobsManagementChannelApiImpl implements JobsManagementChannelApi {
    private readonly driver;
    constructor(driver: JobsManagementDriver);
    jobList__initialLoad(filter: JobStatus[], orderBy: JobsSortBy): Promise<void>;
    jobList__applyFilter(filter: JobStatus[]): Promise<void>;
    jobList__bulkCancel(jobsToBeActioned: Job[]): Promise<BulkCancel>;
    jobList_cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobOperationResult>;
    jobList_rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    jobList_sortBy(orderBy: JobsSortBy): Promise<void>;
    jobList__query(offset: number, limit: number): Promise<Job[]>;
}
//# sourceMappingURL=JobsManagementChannelApiImpl.d.ts.map