"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.executeOnSaveHook = void 0;
var vscode = require("vscode");
function executeOnSaveHook(fileType) {
    if (!fileType) {
        return;
    }
    var hookId = "kogito.".concat(fileType, ".runOnSave");
    var hook = vscode.workspace.getConfiguration().get(hookId, "");
    if (hook) {
        vscode.commands.executeCommand(hook);
    }
}
exports.executeOnSaveHook = executeOnSaveHook;
//# sourceMappingURL=onSaveHook.js.map