"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParserHelper = void 0;
var antlr4_1 = require("antlr4");
var FEEL_1_1Parser_1 = require("./generated-parser/FEEL_1_1Parser");
var VariableSymbol_1 = require("./VariableSymbol");
var ScopeImpl_1 = require("./ScopeImpl");
var NameQueue_1 = require("./NameQueue");
var FeelVariable_1 = require("../FeelVariable");
var Scopes_1 = require("./Scopes");
var ReservedWords_1 = require("../ReservedWords");
var FeelSyntacticSymbolNature_1 = require("../FeelSyntacticSymbolNature");
var MapBackedType_1 = require("./MapBackedType");
var FunctionSymbol_1 = require("./FunctionSymbol");
var ParserHelper = (function () {
    function ParserHelper() {
        this.dynamicResolution = 0;
        this.scopes = new Scopes_1.Scopes();
        this.currentName = new NameQueue_1.NameQueue();
        this.currentName.push("<local>");
        this.currentScope = this.scopes.getGlobalScope();
        this._variables = new Array();
        this._availableSymbols = new Array();
    }
    Object.defineProperty(ParserHelper.prototype, "availableSymbols", {
        get: function () {
            return this._availableSymbols;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ParserHelper.prototype, "variables", {
        get: function () {
            return this._variables;
        },
        enumerable: false,
        configurable: true
    });
    ParserHelper.prototype.pushScope = function (type, allowDynamicVariables) {
        this.currentScope = new ScopeImpl_1.ScopeImpl(this.currentName.peek(), this.currentScope, type, allowDynamicVariables);
    };
    ParserHelper.prototype.popScope = function () {
        var _a, _b;
        this.currentScope = (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getParentScope();
        if ((_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.allowDynamicVariables) {
            this.currentScope = this.currentScope.getParentScope();
        }
    };
    ParserHelper.prototype.enableDynamicResolution = function () {
        this.dynamicResolution++;
    };
    ParserHelper.prototype.disableDynamicResolution = function () {
        if (this.dynamicResolution > 0) {
            this.dynamicResolution--;
        }
    };
    ParserHelper.prototype.isFeatDMN12EnhancedForLoopEnabled = function () {
        return true;
    };
    ParserHelper.prototype.startVariable = function (t) {
        var _a;
        (_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.start(t.text);
    };
    ParserHelper.prototype.popName = function () {
        this.currentName.pop();
    };
    ParserHelper.prototype.pushName = function (ctx) {
        if (ctx instanceof antlr4_1.ParserRuleContext) {
            this.currentName.push(this.getName(ctx));
        }
        else {
            this.currentName.push(ctx);
        }
    };
    ParserHelper.prototype.getName = function (ctx) {
        var key = this.getOriginalText(ctx);
        if (ctx instanceof FEEL_1_1Parser_1.KeyStringContext) {
            return key;
        }
        return key;
    };
    ParserHelper.prototype.defineVariable = function (variable, type, variableType, variableSource, allowDynamicVariables) {
        var _a, _b, _c;
        var variableSymbol = new VariableSymbol_1.VariableSymbol(variable instanceof antlr4_1.ParserRuleContext ? this.getName(variable) : variable, type, variableType, variableSource, allowDynamicVariables);
        if (variableSymbol.getId()) {
            this.availableSymbols.push({
                name: (_a = variableSymbol.getId()) !== null && _a !== void 0 ? _a : "",
                type: (_b = type === null || type === void 0 ? void 0 : type.name) !== null && _b !== void 0 ? _b : "undefined-type",
            });
        }
        (_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.define(variableSymbol);
    };
    ParserHelper.prototype.dismissScope = function () {
        var _a;
        if (((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.getType()) != null && this.currentScope.getType() === undefined) {
            this.disableDynamicResolution();
        }
        this.popScope();
    };
    ParserHelper.prototype.recoverScope = function (name) {
        var e_1, _a;
        var _b, _c, _d;
        if (!name) {
            return;
        }
        var scopeName = name.replaceAll("\n", "");
        var s = (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.getChildScopes().get(scopeName);
        if (s != null) {
            this.currentScope = s;
        }
        else {
            var resolved = (_c = this.currentScope) === null || _c === void 0 ? void 0 : _c.resolve(scopeName);
            var scopeType = resolved === null || resolved === void 0 ? void 0 : resolved.getType();
            if (resolved != null && scopeType instanceof MapBackedType_1.MapBackedType) {
                this.pushScope(scopeType);
                try {
                    for (var _e = __values(scopeType.properties), _f = _e.next(); !_f.done; _f = _e.next()) {
                        var f = _f.value;
                        (_d = this.currentScope) === null || _d === void 0 ? void 0 : _d.define(new VariableSymbol_1.VariableSymbol(f[0], f[1]));
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            else {
                this.pushScope();
            }
        }
    };
    ParserHelper.prototype.followUp = function (token, isPredict) {
        var _a, _b;
        var dynamicResolutionResult = this.isDynamicResolution();
        var follow = dynamicResolutionResult || ((_a = this.currentScope) === null || _a === void 0 ? void 0 : _a.followUp(token.text, isPredict));
        if (dynamicResolutionResult && !isPredict) {
            (_b = this.currentScope) === null || _b === void 0 ? void 0 : _b.followUp(token.text, isPredict);
        }
        return follow !== null && follow !== void 0 ? follow : false;
    };
    ParserHelper.prototype.isDynamicResolution = function () {
        return this.dynamicResolution > 0;
    };
    ParserHelper.prototype.validateVariable = function (_n1, qn, name) {
        var e_2, _a;
        var _b, _c, _d, _e, _f, _g, _h;
        var start = _n1.start.start;
        var end = (_c = (_b = _n1.stop) === null || _b === void 0 ? void 0 : _b.stop) !== null && _c !== void 0 ? _c : 0;
        var length = end - start + 1;
        var startLine = _n1.start.line - 1;
        var endLine = ((_d = _n1.stop) === null || _d === void 0 ? void 0 : _d.line) !== undefined ? _n1.stop.line - 1 : startLine;
        var variableName = name.replaceAll("\n", "");
        if ((_e = this.currentScope) === null || _e === void 0 ? void 0 : _e.getChildScopes().has(variableName)) {
            this.variables.push(new FeelVariable_1.FeelVariable(start, length, startLine, endLine, FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.GlobalVariable, variableName));
        }
        else {
            var symbol = (_f = this.currentScope) === null || _f === void 0 ? void 0 : _f.resolve(variableName);
            if (symbol) {
                if (symbol instanceof VariableSymbol_1.VariableSymbol) {
                    var scopeSymbols = [];
                    if (symbol.getType() instanceof MapBackedType_1.MapBackedType) {
                        var map = symbol.getType();
                        try {
                            for (var _j = __values(map.properties), _k = _j.next(); !_k.done; _k = _j.next()) {
                                var _l = __read(_k.value, 2), key = _l[0], value = _l[1];
                                scopeSymbols.push({
                                    name: key,
                                    type: (_g = value.typeRef) !== null && _g !== void 0 ? _g : value.name,
                                });
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_k && !_k.done && (_a = _j.return)) _a.call(_j);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                    if (symbol.allowDynamicVariables) {
                        this.pushScope(undefined, true);
                    }
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, startLine, endLine, (_h = symbol.symbolType) !== null && _h !== void 0 ? _h : FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.GlobalVariable, variableName, scopeSymbols));
                }
                else if (!(symbol instanceof FunctionSymbol_1.FunctionSymbol)) {
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, startLine, endLine, FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.GlobalVariable, variableName));
                }
            }
            else {
                if (!ReservedWords_1.ReservedWords.FeelFunctions.has(variableName) && !ReservedWords_1.ReservedWords.FeelKeywords.has(variableName)) {
                    this.variables.push(new FeelVariable_1.FeelVariable(start, length, startLine, endLine, FeelSyntacticSymbolNature_1.FeelSyntacticSymbolNature.Unknown, variableName));
                }
            }
        }
    };
    ParserHelper.prototype.getOriginalText = function (ctx) {
        var _a, _b;
        var a = ctx.start.start;
        var b = (_b = (_a = ctx.stop) === null || _a === void 0 ? void 0 : _a.stop) !== null && _b !== void 0 ? _b : 0;
        return ctx.start.getInputStream().getText(a, b);
    };
    ParserHelper.prototype.fphEnd = function (count) {
        return count;
    };
    ParserHelper.prototype.fphStart = function (_n1, param2) {
        return 0;
    };
    return ParserHelper;
}());
exports.ParserHelper = ParserHelper;
//# sourceMappingURL=ParserHelper.js.map