/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class Collect
extends SingleRel {
    protected Collect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType) {
        super(cluster, traitSet, input);
        this.rowType = Objects.requireNonNull(rowType, "rowType");
        SqlTypeName collectionType = Collect.getCollectionType(rowType);
        switch (collectionType) {
            case ARRAY: 
            case MAP: 
            case MULTISET: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not a collection type " + (Object)((Object)collectionType));
            }
        }
    }

    @Deprecated
    public Collect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, String fieldName) {
        this(cluster, traitSet, input, Collect.deriveRowType(cluster.getTypeFactory(), SqlTypeName.MULTISET, fieldName, input.getRowType()));
    }

    public Collect(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), Collect.deriveRowType(input.getCluster().getTypeFactory(), SqlTypeName.MULTISET, Objects.requireNonNull(input.getString("field"), "field"), input.getInput().getRowType()));
    }

    public static Collect create(RelNode input, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE);
        return new Collect(cluster, traitSet, input, rowType);
    }

    @Deprecated
    public static Collect create(RelNode input, SqlTypeName collectionType, String fieldName) {
        return Collect.create(input, Collect.deriveRowType(input.getCluster().getTypeFactory(), collectionType, fieldName, input.getRowType()));
    }

    public static Collect create(RelNode input, SqlKind sqlKind, String fieldName) {
        RelDataType rowType;
        SqlTypeName collectionType = Collect.getCollectionType(sqlKind);
        switch (sqlKind) {
            case ARRAY_QUERY_CONSTRUCTOR: 
            case MAP_QUERY_CONSTRUCTOR: 
            case MULTISET_QUERY_CONSTRUCTOR: {
                rowType = Collect.deriveRowType(input.getCluster().getTypeFactory(), collectionType, fieldName, SqlTypeUtil.deriveCollectionQueryComponentType(collectionType, input.getRowType()));
                break;
            }
            default: {
                rowType = Collect.deriveRowType(input.getCluster().getTypeFactory(), collectionType, fieldName, input.getRowType());
            }
        }
        return Collect.create(input, rowType);
    }

    protected final RelDataType rowType() {
        return Objects.requireNonNull(this.rowType, "rowType");
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Collect.sole(inputs));
    }

    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new Collect(this.getCluster(), traitSet, input, this.rowType());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("field", this.getFieldName());
    }

    public String getFieldName() {
        return ((RelDataTypeField)Iterables.getOnlyElement(this.rowType().getFieldList())).getName();
    }

    public SqlTypeName getCollectionType() {
        return Collect.getCollectionType(this.rowType());
    }

    private static SqlTypeName getCollectionType(RelDataType rowType) {
        return ((RelDataTypeField)Iterables.getOnlyElement(rowType.getFieldList())).getType().getSqlTypeName();
    }

    private static SqlTypeName getCollectionType(SqlKind sqlKind) {
        switch (sqlKind) {
            case ARRAY_QUERY_CONSTRUCTOR: 
            case ARRAY_VALUE_CONSTRUCTOR: {
                return SqlTypeName.ARRAY;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: {
                return SqlTypeName.MULTISET;
            }
            case MAP_QUERY_CONSTRUCTOR: 
            case MAP_VALUE_CONSTRUCTOR: {
                return SqlTypeName.MAP;
            }
        }
        throw new IllegalArgumentException("not a collection kind " + (Object)((Object)sqlKind));
    }

    @Override
    protected RelDataType deriveRowType() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static RelDataType deriveCollectRowType(SingleRel rel, String fieldName) {
        RelDataType inputType = rel.getInput().getRowType();
        assert (inputType.isStruct());
        return Collect.deriveRowType(rel.getCluster().getTypeFactory(), SqlTypeName.MULTISET, fieldName, inputType);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, SqlTypeName collectionType, String fieldName, RelDataType elementType) {
        RelDataType type1;
        switch (collectionType) {
            case ARRAY: {
                type1 = SqlTypeUtil.createArrayType(typeFactory, elementType, false);
                break;
            }
            case MULTISET: {
                type1 = SqlTypeUtil.createMultisetType(typeFactory, elementType, false);
                break;
            }
            case MAP: {
                type1 = SqlTypeUtil.createMapTypeFromRecord(typeFactory, elementType);
                break;
            }
            default: {
                throw new AssertionError((Object)collectionType);
            }
        }
        return typeFactory.createTypeWithNullability(typeFactory.builder().add(fieldName, type1).build(), false);
    }
}

