/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity.codec.v1;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite.raft.jraft.util.Bits;

public final class V1Decoder
implements LogEntryDecoder {
    public static final V1Decoder INSTANCE = new V1Decoder();

    private V1Decoder() {
    }

    @Override
    public LogEntry decode(byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        if (content[0] != -72) {
            return null;
        }
        LogEntry log = new LogEntry();
        this.decode(log, content);
        return log;
    }

    private void decode(LogEntry log, byte[] content) {
        Reader reader = new Reader(content);
        reader.pos = 1;
        int typeNumber = (int)reader.readLong();
        EnumOutter.EntryType type = Objects.requireNonNull(EnumOutter.EntryType.forNumber(typeNumber));
        log.setType(type);
        long index = reader.readLong();
        long term = reader.readLong();
        log.setId(new LogId(index, term));
        long checksum = Bits.getLongLittleEndian(content, reader.pos);
        log.setChecksum(checksum);
        int pos = reader.pos + 8;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            reader.pos = pos;
            int peerCount = (int)reader.readLong();
            pos = reader.pos;
            if (peerCount > 0) {
                ArrayList<PeerId> peers = new ArrayList<PeerId>(peerCount);
                pos = V1Decoder.readNodesList(reader, pos, content, peerCount, peers);
                log.setPeers(peers);
            }
            reader.pos = pos;
            int oldPeerCount = (int)reader.readLong();
            pos = reader.pos;
            if (oldPeerCount > 0) {
                ArrayList<PeerId> oldPeers = new ArrayList<PeerId>(oldPeerCount);
                pos = V1Decoder.readNodesList(reader, pos, content, oldPeerCount, oldPeers);
                log.setOldPeers(oldPeers);
            }
            reader.pos = pos;
            int learnersCount = (int)reader.readLong();
            pos = reader.pos;
            if (learnersCount > 0) {
                ArrayList<PeerId> learners = new ArrayList<PeerId>(learnersCount);
                pos = V1Decoder.readNodesList(reader, pos, content, learnersCount, learners);
                log.setLearners(learners);
            }
            reader.pos = pos;
            int oldLearnersCount = (int)reader.readLong();
            pos = reader.pos;
            if (oldLearnersCount > 0) {
                ArrayList<PeerId> oldLearners = new ArrayList<PeerId>(oldLearnersCount);
                pos = V1Decoder.readNodesList(reader, pos, content, oldLearnersCount, oldLearners);
                log.setOldLearners(oldLearners);
            }
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && content.length > pos) {
            int len = content.length - pos;
            ByteBuffer data = ByteBuffer.wrap(content, pos, len).slice();
            log.setData(data);
        }
    }

    private static int readNodesList(Reader reader, int pos, byte[] content, int count, List<PeerId> nodes) {
        for (int i = 0; i < count; ++i) {
            short len = Bits.getShortLittleEndian(content, pos);
            String consistentId = AsciiStringUtil.unsafeDecode(content, pos += 2, len);
            reader.pos = pos += len;
            int idx = (int)reader.readLong();
            int priority = (int)(reader.readLong() - 1L);
            pos = reader.pos;
            nodes.add(new PeerId(consistentId, idx, priority));
        }
        return pos;
    }

    private static class Reader {
        private final byte[] content;
        int pos;

        private Reader(byte[] content) {
            this.content = content;
        }

        long readLong() {
            long val = 0L;
            int shift = 0;
            while (true) {
                byte b = this.content[this.pos];
                ++this.pos;
                val |= ((long)b & 0x7FL) << shift;
                if ((b & 0x80) == 0) {
                    return val;
                }
                shift += 7;
            }
        }
    }
}

