/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferHeader;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.util.Preconditions;

class PartitionedFileReader {
    private final ByteBuffer headerBuf;
    private final ByteBuffer indexEntryBuf;
    private final PartitionedFile partitionedFile;
    private final int targetSubpartition;
    private final FileChannel dataFileChannel;
    private final FileChannel indexFileChannel;
    private int nextRegionToRead;
    private long nextOffsetToRead;
    private long currentRegionRemainingBytes;

    PartitionedFileReader(PartitionedFile partitionedFile, int targetSubpartition, FileChannel dataFileChannel, FileChannel indexFileChannel, ByteBuffer headerBuffer, ByteBuffer indexEntryBuffer) {
        Preconditions.checkArgument((boolean)((FileChannel)Preconditions.checkNotNull((Object)dataFileChannel)).isOpen(), (Object)"Data file channel must be opened.");
        Preconditions.checkArgument((boolean)((FileChannel)Preconditions.checkNotNull((Object)indexFileChannel)).isOpen(), (Object)"Index file channel must be opened.");
        this.partitionedFile = (PartitionedFile)Preconditions.checkNotNull((Object)partitionedFile);
        this.targetSubpartition = targetSubpartition;
        this.dataFileChannel = dataFileChannel;
        this.indexFileChannel = indexFileChannel;
        this.headerBuf = headerBuffer;
        this.indexEntryBuf = indexEntryBuffer;
    }

    private void moveToNextReadableRegion(ByteBuffer indexEntryBuf) throws IOException {
        while (this.currentRegionRemainingBytes <= 0L && this.nextRegionToRead < this.partitionedFile.getNumRegions()) {
            this.partitionedFile.getIndexEntry(this.indexFileChannel, indexEntryBuf, this.nextRegionToRead, this.targetSubpartition);
            this.nextOffsetToRead = indexEntryBuf.getLong();
            this.currentRegionRemainingBytes = indexEntryBuf.getLong();
            ++this.nextRegionToRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readCurrentRegion(Queue<MemorySegment> freeSegments, BufferRecycler recycler, Consumer<Buffer> consumer) throws IOException {
        if (this.currentRegionRemainingBytes == 0L) {
            return false;
        }
        Preconditions.checkArgument((!freeSegments.isEmpty() ? 1 : 0) != 0, (Object)"No buffer available for data reading.");
        this.dataFileChannel.position(this.nextOffsetToRead);
        BufferAndHeader partialBuffer = new BufferAndHeader(null, null);
        try {
            while (!freeSegments.isEmpty() && this.currentRegionRemainingBytes > 0L) {
                MemorySegment segment = freeSegments.poll();
                int numBytes = (int)Math.min((long)segment.size(), this.currentRegionRemainingBytes);
                ByteBuffer byteBuffer = segment.wrap(0, numBytes);
                try {
                    BufferReaderWriterUtil.readByteBufferFully(this.dataFileChannel, byteBuffer);
                    byteBuffer.flip();
                    this.currentRegionRemainingBytes -= (long)byteBuffer.remaining();
                    this.nextOffsetToRead += (long)byteBuffer.remaining();
                }
                catch (Throwable throwable) {
                    freeSegments.add(segment);
                    throw throwable;
                }
                NetworkBuffer buffer = new NetworkBuffer(segment, recycler);
                buffer.setSize(byteBuffer.remaining());
                try {
                    partialBuffer = this.processBuffer(byteBuffer, buffer, partialBuffer, consumer);
                }
                catch (Throwable throwable) {
                    partialBuffer = new BufferAndHeader(null, null);
                    throw throwable;
                }
                finally {
                    buffer.recycleBuffer();
                }
            }
        }
        finally {
            if (this.headerBuf.position() > 0) {
                this.nextOffsetToRead -= (long)this.headerBuf.position();
                this.currentRegionRemainingBytes += (long)this.headerBuf.position();
                this.headerBuf.clear();
            }
            if (partialBuffer.header != null) {
                this.nextOffsetToRead -= 8L;
                this.currentRegionRemainingBytes += 8L;
            }
            if (partialBuffer.buffer != null) {
                this.nextOffsetToRead -= (long)partialBuffer.buffer.readableBytes();
                this.currentRegionRemainingBytes += (long)partialBuffer.buffer.readableBytes();
                partialBuffer.buffer.recycleBuffer();
            }
        }
        return this.hasRemaining();
    }

    boolean hasRemaining() throws IOException {
        this.moveToNextReadableRegion(this.indexEntryBuf);
        return this.currentRegionRemainingBytes > 0L;
    }

    void initRegionIndex(ByteBuffer initIndexEntryBuffer) throws IOException {
        this.moveToNextReadableRegion(initIndexEntryBuffer);
    }

    long getPriority() {
        return this.nextOffsetToRead;
    }

    private BufferAndHeader processBuffer(ByteBuffer byteBuffer, Buffer buffer, BufferAndHeader partialBuffer, Consumer<Buffer> consumer) {
        BufferHeader header = partialBuffer.header;
        CompositeBuffer targetBuffer = partialBuffer.buffer;
        while (byteBuffer.hasRemaining() && (header != null || (header = this.parseBufferHeader(byteBuffer)) != null)) {
            if (targetBuffer != null) {
                buffer.retainBuffer();
                int position = byteBuffer.position() + targetBuffer.missingLength();
                targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), targetBuffer.missingLength()));
                byteBuffer.position(position);
            } else {
                if (byteBuffer.remaining() < header.getLength()) {
                    if (!byteBuffer.hasRemaining()) break;
                    buffer.retainBuffer();
                    targetBuffer = new CompositeBuffer(header);
                    targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), byteBuffer.remaining()));
                    break;
                }
                buffer.retainBuffer();
                targetBuffer = new CompositeBuffer(header);
                targetBuffer.addPartialBuffer(buffer.readOnlySlice(byteBuffer.position(), header.getLength()));
                byteBuffer.position(byteBuffer.position() + header.getLength());
            }
            header = null;
            consumer.accept(targetBuffer);
            targetBuffer = null;
        }
        return new BufferAndHeader(targetBuffer, header);
    }

    private BufferHeader parseBufferHeader(ByteBuffer buffer) {
        BufferHeader header = null;
        if (this.headerBuf.position() > 0) {
            while (this.headerBuf.hasRemaining()) {
                this.headerBuf.put(buffer.get());
            }
            this.headerBuf.flip();
            header = BufferReaderWriterUtil.parseBufferHeader(this.headerBuf);
            this.headerBuf.clear();
        }
        if (header == null && buffer.remaining() < 8) {
            this.headerBuf.put(buffer);
        } else if (header == null) {
            header = BufferReaderWriterUtil.parseBufferHeader(buffer);
        }
        return header;
    }

    private static class BufferAndHeader {
        private final CompositeBuffer buffer;
        private final BufferHeader header;

        BufferAndHeader(CompositeBuffer buffer, BufferHeader header) {
            this.buffer = buffer;
            this.header = header;
        }
    }
}

