/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.vaccess.DialogCache;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ResourceListDetailsPane;
import com.ibm.as400.vaccess.ResourceListPane;
import com.ibm.as400.vaccess.ResourceListPropertiesPane;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.ResourceProperties;
import com.ibm.as400.vaccess.ResourcePropertiesPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class ResourceListPopupMenuAdapter
extends MouseAdapter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String ACTION_PROPERTIES_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String ACTION_LIST_PROPERTIES_ = ResourceLoader.getText("ACTION_LIST_PROPERTIES");
    private DialogCache dialogCache_ = new DialogCache();
    private ErrorEventSupport errorEventSupport_;
    private ResourceProperties resourceProperties_;
    private ResourceList resourceList_;
    private Object target_;

    public ResourceListPopupMenuAdapter(Object target, ResourceList resourceList, ResourceProperties resourceProperties, ErrorEventSupport errorEventSupport) {
        this.target_ = target;
        this.resourceList_ = resourceList;
        this.resourceProperties_ = resourceProperties;
        this.errorEventSupport_ = errorEventSupport;
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopupMenu(event.getComponent(), event.getPoint());
        }
    }

    public void setResourceProperties(ResourceProperties resourceProperties) {
        this.resourceProperties_ = resourceProperties;
    }

    public void setResourceList(ResourceList resourceList) {
        this.resourceList_ = resourceList;
    }

    private void showPopupMenu(Component component, Point point) {
        Resource resource = null;
        if (this.target_ instanceof ResourceListPane) {
            resource = ((ResourceListPane)this.target_).getResourceAtPoint(point);
        } else if (this.target_ instanceof ResourceListDetailsPane) {
            resource = ((ResourceListDetailsPane)this.target_).getResourceAtPoint(point);
        } else {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        boolean showPopup = false;
        if (resource != null) {
            JMenuItem propertiesMenuItem = new JMenuItem(ACTION_PROPERTIES_);
            final Resource resource2 = resource;
            propertiesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JDialog dialog = ResourceListPopupMenuAdapter.this.dialogCache_.resolveDialog(resource2);
                    if (dialog == null) {
                        dialog = new ResourcePropertiesPane(resource2, ResourceListPopupMenuAdapter.this.resourceProperties_, ResourceListPopupMenuAdapter.this.errorEventSupport_);
                        ResourceListPopupMenuAdapter.this.dialogCache_.addDialog(resource2, dialog);
                        dialog.show();
                    }
                }
            });
            menu.add(propertiesMenuItem);
            showPopup = true;
        }
        if (this.resourceList_ != null) {
            JMenuItem listPropertiesMenuItem = new JMenuItem(ACTION_LIST_PROPERTIES_);
            listPropertiesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JDialog dialog = ResourceListPopupMenuAdapter.this.dialogCache_.resolveDialog(ResourceListPopupMenuAdapter.this.resourceList_);
                    if (dialog == null) {
                        dialog = new ResourceListPropertiesPane(ResourceListPopupMenuAdapter.this.resourceList_, ResourceListPopupMenuAdapter.this.errorEventSupport_);
                        ResourceListPopupMenuAdapter.this.dialogCache_.addDialog(ResourceListPopupMenuAdapter.this.resourceList_, dialog);
                        dialog.show();
                    }
                }
            });
            if (showPopup) {
                menu.addSeparator();
            }
            menu.add(listPropertiesMenuItem);
            showPopup = true;
        }
        if (showPopup) {
            menu.show(component, point.x, point.y);
        }
    }
}

