/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.AbstractMethodFilter;

class ExcludeMethodFilter
extends AbstractMethodFilter {
    ExcludeMethodFilter(String ... patterns) {
        super(patterns);
    }

    public FilterResult apply(TestDescriptor descriptor) {
        String methodName = this.getFullyQualifiedMethodNameFromDescriptor(descriptor);
        return this.findMatchingPattern(methodName).map(pattern -> FilterResult.excluded((String)this.formatExclusionReason(methodName, (Pattern)pattern))).orElseGet(() -> FilterResult.included((String)this.formatInclusionReason(methodName)));
    }

    private String formatInclusionReason(String methodName) {
        return String.format("Method name [%s] does not match any excluded pattern: %s", methodName, this.patternDescription);
    }

    private String formatExclusionReason(String methodName, Pattern pattern) {
        return String.format("Method name [%s] matches excluded pattern: '%s'", methodName, pattern);
    }

    public String toString() {
        return String.format("%s that excludes method names that match one of the following regular expressions: %s", this.getClass().getSimpleName(), this.patternDescription);
    }
}

