/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.spring.boot.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.SinkRunner;
import org.apache.flume.Source;
import org.apache.flume.SourceRunner;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.conf.Configurables;

public abstract class AbstractFlumeConfiguration {
    protected <T extends Channel> T configureChannel(String name, Class<T> clazz, Map<String, String> params) {
        Channel channel;
        try {
            channel = (Channel)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create channel " + name, (Throwable)ex);
        }
        channel.setName(name);
        Configurables.configure((Object)channel, (Context)AbstractFlumeConfiguration.createContext(params));
        return (T)channel;
    }

    protected <T extends Source> SourceRunner configureSource(String name, Class<T> clazz, ChannelSelector selector, Map<String, String> params) {
        Source source;
        try {
            source = (Source)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create source " + name, (Throwable)ex);
        }
        source.setName(name);
        Configurables.configure((Object)source, (Context)AbstractFlumeConfiguration.createContext(params));
        source.setChannelProcessor(new ChannelProcessor(selector));
        return SourceRunner.forSource((Source)source);
    }

    protected <T extends Source> SourceRunner configureSource(T source, ChannelSelector selector, Map<String, String> params) {
        source.setChannelProcessor(new ChannelProcessor(selector));
        return SourceRunner.forSource(source);
    }

    protected <T extends SinkProcessor> T configureSinkProcessor(Map<String, String> params, Class<T> clazz, List<Sink> sinks) {
        SinkProcessor processor;
        try {
            processor = (SinkProcessor)clazz.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create SinkProcessor of type: " + clazz.getName(), (Throwable)ex);
        }
        processor.setSinks(sinks);
        Configurables.configure((Object)processor, (Context)AbstractFlumeConfiguration.createContext(params));
        return (T)processor;
    }

    protected SinkRunner createSinkRunner(SinkProcessor sinkProcessor) {
        SinkRunner runner = new SinkRunner(sinkProcessor);
        runner.setSink(sinkProcessor);
        return runner;
    }

    protected <T extends Sink> Sink configureSink(String name, Class<T> sinkClazz, Channel channel, Map<String, String> params) {
        Sink sink;
        try {
            sink = (Sink)sinkClazz.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create sink " + name, (Throwable)ex);
        }
        sink.setName(name);
        Configurables.configure((Object)sink, (Context)AbstractFlumeConfiguration.createContext(params));
        sink.setChannel(channel);
        return sink;
    }

    protected ChannelSelector createChannelSelector(Class<? extends ChannelSelector> clazz, Map<String, String> params) {
        ChannelSelector selector;
        try {
            selector = clazz.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create channel selector " + clazz.getName(), (Throwable)ex);
        }
        Configurables.configure((Object)selector, (Context)AbstractFlumeConfiguration.createContext(params));
        return selector;
    }

    @SafeVarargs
    protected final <T> List<T> listOf(T ... items) {
        return Arrays.asList(items);
    }

    private static Context createContext(Map<String, String> map) {
        return map != null ? new Context(map) : new Context();
    }
}

