/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.dialogs;

import org.apache.directory.server.config.beans.MavibotIndexBean;
import org.apache.directory.studio.apacheds.configuration.dialogs.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MavibotIndexDialog
extends Dialog {
    private MavibotIndexBean index;
    private boolean dirty = false;
    private Text attributeIdText;

    public MavibotIndexDialog(MavibotIndexBean index) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.index = index;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("MavibotIndexDialog.IndexedAttributeDialog"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label attributeIdLabel = new Label(composite, 0);
        attributeIdLabel.setText(Messages.getString("MavibotIndexDialog.AttributeID"));
        this.attributeIdText = new Text(composite, 2048);
        this.attributeIdText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initFromInput();
        this.addListeners();
        return composite;
    }

    private void initFromInput() {
        String attributeId = this.index.getIndexAttributeId();
        this.attributeIdText.setText(attributeId == null ? "" : attributeId);
    }

    private void addListeners() {
        this.attributeIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavibotIndexDialog.this.dirty = true;
            }
        });
    }

    protected void okPressed() {
        this.index.setIndexAttributeId(this.attributeIdText.getText());
        super.okPressed();
    }

    public MavibotIndexBean getIndex() {
        return this.index;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

