/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Array;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;

public final class CompactTupleSketch<S extends Summary>
extends TupleSketch<S> {
    private static final byte serialVersionWithSummaryClassNameUID = 1;
    private static final byte serialVersionUIDLegacy = 2;
    private static final byte serialVersionUID = 3;
    private static final short defaultSeedHash = -27700;
    private final long[] hashArr_;
    private S[] summaryArr_;

    CompactTupleSketch(long[] hashArr, S[] summaryArr, long thetaLong, boolean empty) {
        super(thetaLong, empty, null);
        this.thetaLong_ = thetaLong;
        this.empty_ = empty;
        this.hashArr_ = hashArr;
        this.summaryArr_ = summaryArr;
    }

    CompactTupleSketch(MemorySegment seg, SummaryDeserializer<S> deserializer) {
        super(Long.MAX_VALUE, true, null);
        int offset = 0;
        byte preambleLongs = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
        byte version = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
        byte familyId = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
        SerializerDeserializer.validateFamily(familyId, preambleLongs);
        if (version > 3) {
            throw new SketchesArgumentException("Unsupported serial version. Expected: 3 or lower, actual: " + version);
        }
        SerializerDeserializer.validateType(seg.get(ValueLayout.JAVA_BYTE, (long)offset++), SerializerDeserializer.SketchType.CompactTupleSketch);
        if (version <= 2) {
            boolean hasEntries;
            boolean isThetaIncluded;
            byte flags;
            this.empty_ = ((flags = seg.get(ValueLayout.JAVA_BYTE, (long)offset++)) & 1 << FlagsLegacy.IS_EMPTY.ordinal()) > 0;
            boolean bl = isThetaIncluded = (flags & 1 << FlagsLegacy.IS_THETA_INCLUDED.ordinal()) > 0;
            if (isThetaIncluded) {
                this.thetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                offset += 8;
            } else {
                this.thetaLong_ = Long.MAX_VALUE;
            }
            boolean bl2 = hasEntries = (flags & 1 << FlagsLegacy.HAS_ENTRIES.ordinal()) > 0;
            if (hasEntries) {
                int i;
                byte classNameLength = 0;
                if (version == 1) {
                    classNameLength = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
                }
                int count = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)offset);
                offset += 4;
                if (version == 1) {
                    offset += classNameLength;
                }
                this.hashArr_ = new long[count];
                for (i = 0; i < count; ++i) {
                    this.hashArr_[i] = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                    offset += 8;
                }
                for (i = 0; i < count; ++i) {
                    offset += this.readSummary(seg, offset, i, count, deserializer);
                }
            } else {
                this.hashArr_ = new long[0];
                this.summaryArr_ = null;
            }
        } else {
            int n = ++offset;
            ++offset;
            byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)n);
            offset += 2;
            this.empty_ = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
            this.thetaLong_ = Long.MAX_VALUE;
            int count = 0;
            if (!this.empty_) {
                if (preambleLongs == 1) {
                    count = 1;
                } else {
                    count = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)offset);
                    offset += 4;
                    offset += 4;
                    if (preambleLongs > 2) {
                        this.thetaLong_ = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                        offset += 8;
                    }
                }
            }
            this.hashArr_ = new long[count];
            for (int i = 0; i < count; ++i) {
                this.hashArr_[i] = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                offset += 8;
                offset += this.readSummary(seg, offset, i, count, deserializer);
            }
        }
    }

    private int readSummary(MemorySegment seg, int offset, int i, int count, SummaryDeserializer<S> deserializer) {
        MemorySegment segRegion = seg.asSlice((long)offset, seg.byteSize() - (long)offset);
        DeserializeResult<S> result = deserializer.heapifySummary(segRegion);
        Summary summary = (Summary)result.getObject();
        Class<?> summaryType = ((Summary)result.getObject()).getClass();
        if (this.summaryArr_ == null) {
            this.summaryArr_ = (Summary[])Array.newInstance(summaryType, count);
        }
        this.summaryArr_[i] = summary;
        return result.getSize();
    }

    @Override
    public CompactTupleSketch<S> compact() {
        return this;
    }

    long[] getHashArr() {
        return this.hashArr_;
    }

    S[] getSummaryArr() {
        return this.summaryArr_;
    }

    @Override
    public int getRetainedEntries() {
        return this.hashArr_ == null ? 0 : this.hashArr_.length;
    }

    @Override
    public int getCountLessThanThetaLong(long thetaLong) {
        return HashOperations.count(this.hashArr_, thetaLong);
    }

    @Override
    public byte[] toByteArray() {
        boolean isSingleItem;
        int count = this.getRetainedEntries();
        boolean bl = isSingleItem = count == 1 && !this.isEstimationMode();
        int preambleLongs = this.isEmpty() || isSingleItem ? 1 : (this.isEstimationMode() ? 3 : 2);
        int summariesSizeBytes = 0;
        byte[][] summariesBytes = new byte[count][];
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                summariesBytes[i] = this.summaryArr_[i].toByteArray();
                summariesSizeBytes += summariesBytes[i].length;
            }
        }
        int sizeBytes = 8 * preambleLongs + 8 * count + summariesSizeBytes;
        byte[] bytes = new byte[sizeBytes];
        int offset = 0;
        bytes[offset++] = (byte)preambleLongs;
        bytes[offset++] = 3;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.CompactTupleSketch.ordinal();
        int n = ++offset;
        bytes[n] = (byte)(1 << Flags.IS_COMPACT.ordinal() | 1 << Flags.IS_READ_ONLY.ordinal() | (this.isEmpty() ? 1 << Flags.IS_EMPTY.ordinal() : 0));
        ByteArrayUtil.putShortLE(bytes, ++offset, (short)-27700);
        offset += 2;
        if (!this.isEmpty() && !isSingleItem) {
            ByteArrayUtil.putIntLE(bytes, offset, count);
            offset += 4;
            offset += 4;
            if (this.isEstimationMode()) {
                ByteArrayUtil.putLongLE(bytes, offset, this.thetaLong_);
                offset += 8;
            }
        }
        for (int i = 0; i < count; ++i) {
            ByteArrayUtil.putLongLE(bytes, offset, this.hashArr_[i]);
            System.arraycopy(summariesBytes[i], 0, bytes, offset += 8, summariesBytes[i].length);
            offset += summariesBytes[i].length;
        }
        return bytes;
    }

    @Override
    public TupleSketchIterator<S> iterator() {
        return new TupleSketchIterator(this.hashArr_, this.summaryArr_);
    }

    private static enum FlagsLegacy {
        IS_BIG_ENDIAN,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }

    private static enum Flags {
        IS_RESERVED,
        IS_READ_ONLY,
        IS_EMPTY,
        IS_COMPACT,
        IS_ORDERED;

    }
}

