/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;

final class QuantilesDoublesUnionImpl
extends QuantilesDoublesUnion {
    int maxK_;
    UpdatableQuantilesDoublesSketch gadget_ = null;

    private QuantilesDoublesUnionImpl(int maxK) {
        this.maxK_ = maxK;
    }

    static QuantilesDoublesUnionImpl heapInstance(int maxK) {
        return new QuantilesDoublesUnionImpl(maxK);
    }

    static QuantilesDoublesUnionImpl directInstance(int maxK, MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(dstSeg);
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.newInstance(maxK, dstSeg, mSegReq);
        QuantilesDoublesUnionImpl union = new QuantilesDoublesUnionImpl(maxK);
        union.maxK_ = maxK;
        union.gadget_ = sketch;
        return union;
    }

    static QuantilesDoublesUnionImpl heapifyInstance(QuantilesDoublesSketch sketch) {
        Objects.requireNonNull(sketch);
        int k = sketch.getK();
        QuantilesDoublesUnionImpl union = new QuantilesDoublesUnionImpl(k);
        union.maxK_ = k;
        union.gadget_ = DoublesUtil.copyToHeap(sketch);
        return union;
    }

    static QuantilesDoublesUnionImpl heapifyInstance(MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg);
        HeapUpdateDoublesSketch sketch = HeapUpdateDoublesSketch.heapifyInstance(srcSeg);
        QuantilesDoublesUnionImpl union = new QuantilesDoublesUnionImpl(sketch.getK());
        union.gadget_ = sketch;
        return union;
    }

    static QuantilesDoublesUnionImpl wrapInstance(MemorySegment srcSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(srcSeg);
        if (srcSeg.isReadOnly()) {
            throw new SketchesReadOnlyException("Cannot create a Union with a Read Only MemorySegment.");
        }
        DirectUpdateDoublesSketch sketch = DirectUpdateDoublesSketch.wrapInstance(srcSeg, mSegReq);
        QuantilesDoublesUnionImpl union = new QuantilesDoublesUnionImpl(sketch.getK());
        union.gadget_ = sketch;
        return union;
    }

    @Override
    public void union(QuantilesDoublesSketch sketchIn) {
        Objects.requireNonNull(sketchIn);
        this.gadget_ = QuantilesDoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, sketchIn);
        this.gadget_.doublesSV = null;
    }

    @Override
    public void union(MemorySegment seg) {
        Objects.requireNonNull(seg);
        this.gadget_ = ClassicUtil.checkIsMemorySegmentCompact(seg) ? QuantilesDoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, QuantilesDoublesSketch.wrap(seg)) : QuantilesDoublesUnionImpl.updateLogic(this.maxK_, this.gadget_, QuantilesDoublesSketch.writableWrap(seg, null));
        this.gadget_.doublesSV = null;
    }

    @Override
    public void update(double dataItem) {
        if (this.gadget_ == null) {
            this.gadget_ = HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        this.gadget_.update(dataItem);
        this.gadget_.doublesSV = null;
    }

    @Override
    public byte[] toByteArray() {
        if (this.gadget_ == null) {
            return QuantilesDoublesSketch.builder().setK(this.maxK_).build().toByteArray();
        }
        return this.gadget_.toByteArray();
    }

    @Override
    public UpdatableQuantilesDoublesSketch getResult() {
        if (this.gadget_ == null) {
            return HeapUpdateDoublesSketch.newInstance(this.maxK_);
        }
        return DoublesUtil.copyToHeap(this.gadget_);
    }

    @Override
    public UpdatableQuantilesDoublesSketch getResult(MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        long segCapBytes = dstSeg.byteSize();
        if (this.gadget_ == null) {
            if (segCapBytes < (long)QuantilesDoublesSketch.getUpdatableStorageBytes(0, 0L)) {
                throw new SketchesArgumentException("Insufficient capacity for result: " + segCapBytes);
            }
            return DirectUpdateDoublesSketch.newInstance(this.maxK_, dstSeg, mSegReq);
        }
        this.gadget_.putIntoMemorySegment(dstSeg, false);
        return DirectUpdateDoublesSketch.wrapInstance(dstSeg, mSegReq);
    }

    @Override
    public UpdatableQuantilesDoublesSketch getResultAndReset() {
        if (this.gadget_ == null) {
            return null;
        }
        UpdatableQuantilesDoublesSketch ds = this.gadget_.getSketchAndReset();
        this.gadget_ = null;
        return ds;
    }

    @Override
    public void reset() {
        this.gadget_.reset();
    }

    @Override
    public boolean hasMemorySegment() {
        return this.gadget_ != null && this.gadget_.hasMemorySegment();
    }

    @Override
    public boolean isOffHeap() {
        return this.gadget_ != null && this.gadget_.isOffHeap();
    }

    @Override
    public boolean isEmpty() {
        return this.gadget_ == null || this.gadget_.isEmpty();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this.gadget_ == null ? false : this.gadget_.isSameResource(that);
    }

    @Override
    public int getMaxK() {
        return this.maxK_;
    }

    @Override
    public int getEffectiveK() {
        return this.gadget_ != null ? this.gadget_.getK() : this.maxK_;
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    @Override
    public String toString(boolean sketchSummary, boolean dataDetail) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        int maxK = this.getMaxK();
        String kStr = String.format("%,d", maxK);
        sb.append(Util.LS).append("### Quantiles ").append(thisSimpleName).append(Util.LS);
        sb.append("   maxK                         : ").append(kStr);
        if (this.gadget_ == null) {
            sb.append(HeapUpdateDoublesSketch.newInstance(this.maxK_).toString());
            return sb.toString();
        }
        sb.append(this.gadget_.toString(sketchSummary, dataDetail));
        return sb.toString();
    }

    static UpdatableQuantilesDoublesSketch updateLogic(int myMaxK, UpdatableQuantilesDoublesSketch myQS, QuantilesDoublesSketch other) {
        int sw1;
        int n = myQS == null ? 0 : (sw1 = myQS.isEmpty() ? 4 : 8);
        int n2 = other == null ? 0 : (other.isEmpty() ? 1 : 2);
        int outCase = 0;
        switch (sw1 |= n2) {
            case 0: {
                outCase = 0;
                break;
            }
            case 1: {
                outCase = 4;
                break;
            }
            case 2: {
                outCase = 2;
                break;
            }
            case 4: {
                outCase = 1;
                break;
            }
            case 5: {
                outCase = 1;
                break;
            }
            case 6: {
                outCase = 3;
                break;
            }
            case 8: {
                outCase = 1;
                break;
            }
            case 9: {
                outCase = 1;
                break;
            }
            case 10: {
                outCase = 3;
                break;
            }
        }
        UpdatableQuantilesDoublesSketch ret = null;
        switch (outCase) {
            case 0: {
                break;
            }
            case 1: {
                ret = myQS;
                break;
            }
            case 2: {
                assert (other != null);
                if (!other.isEstimationMode()) {
                    ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other, false);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                ret = myMaxK < other.getK() ? other.downSampleInternal(other, myMaxK, null, null) : DoublesUtil.copyToHeap(other);
                break;
            }
            case 3: {
                assert (other != null);
                assert (myQS != null);
                if (!other.isEstimationMode()) {
                    ret = myQS;
                    DoublesSketchAccessor otherAccessor = DoublesSketchAccessor.wrap(other, false);
                    for (int i = 0; i < otherAccessor.numItems(); ++i) {
                        ret.update(otherAccessor.get(i));
                    }
                    break;
                }
                if (myQS.getK() <= other.getK()) {
                    DoublesMergeImpl.mergeInto(other, myQS);
                    ret = myQS;
                    break;
                }
                if (myQS.isEmpty()) {
                    if (myQS.hasMemorySegment()) {
                        MemorySegment seg = myQS.getMemorySegment();
                        other.putIntoMemorySegment(seg, false);
                        ret = DirectUpdateDoublesSketch.wrapInstance(seg, null);
                        break;
                    }
                    ret = DoublesUtil.copyToHeap(other);
                    break;
                }
                UpdatableQuantilesDoublesSketch tmp = QuantilesDoublesSketch.builder().setK(other.getK()).build();
                DoublesMergeImpl.downSamplingMergeInto(myQS, tmp);
                ret = myQS.hasMemorySegment() ? QuantilesDoublesSketch.builder().setK(other.getK()).build(myQS.getMemorySegment()) : QuantilesDoublesSketch.builder().setK(other.getK()).build();
                DoublesMergeImpl.mergeInto(tmp, ret);
                DoublesMergeImpl.mergeInto(other, ret);
                break;
            }
            case 4: {
                ret = HeapUpdateDoublesSketch.newInstance(myMaxK);
                break;
            }
        }
        return ret;
    }
}

