/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleAnotB;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleAnotBTest {
    private static final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;
    private final Results results = new Results();

    private static void threeMethodsWithTheta(TupleAnotB<DoubleSummary> aNotB, TupleSketch<DoubleSummary> skA, TupleSketch<DoubleSummary> skB, ThetaSketch skThetaB, Results results) {
        CompactTupleSketch result;
        if (skA != null) {
            try {
                aNotB.setA(skA);
                aNotB.notB(skB);
                result = aNotB.getResult(true);
                results.check((CompactTupleSketch<DoubleSummary>)result);
            }
            catch (SketchesArgumentException sketchesArgumentException) {
                // empty catch block
            }
        }
        if (skA == null || skB == null) {
            try {
                result = TupleAnotB.aNotB(skA, skB);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            result = TupleAnotB.aNotB(skA, skB);
            results.check((CompactTupleSketch<DoubleSummary>)result);
        }
        if (skA == null || skThetaB == null) {
            try {
                result = TupleAnotB.aNotB(skA, (ThetaSketch)skThetaB);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            result = TupleAnotB.aNotB(skA, (ThetaSketch)skThetaB);
            results.check((CompactTupleSketch<DoubleSummary>)result);
        }
        if (skA == null) {
            try {
                aNotB.setA(skA);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            aNotB.setA(skA);
            aNotB.notB(skB);
            result = aNotB.getResult(true);
            results.check((CompactTupleSketch<DoubleSummary>)result);
        }
        if (skA == null) {
            try {
                aNotB.setA(skA);
                Assert.fail();
            }
            catch (SketchesArgumentException sketchesArgumentException) {}
        } else {
            aNotB.setA(skA);
            aNotB.notB(skThetaB);
            result = aNotB.getResult(false);
            results.check((CompactTupleSketch<DoubleSummary>)result);
            result = aNotB.getResult(true);
            results.check((CompactTupleSketch<DoubleSummary>)result);
        }
    }

    private static UpdatableTupleSketch<Double, DoubleSummary> buildUpdatableTuple() {
        return new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(mode)).build();
    }

    private static UpdatableThetaSketch buildUpdateTheta() {
        return new UpdatableThetaSketchBuilder().build();
    }

    @Test
    public void aNotBNullEmptyCombinations() {
        TupleAnotB aNotB = new TupleAnotB();
        CompactTupleSketch result = aNotB.getResult(true);
        this.results.set(0, true, 0.0, 0.0, 0.0).check((CompactTupleSketch<DoubleSummary>)result);
        UpdatableTupleSketch<Double, DoubleSummary> sketch = AdoubleAnotBTest.buildUpdatableTuple();
        UpdatableThetaSketch skTheta = AdoubleAnotBTest.buildUpdateTheta();
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, null, null, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketch, null, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, null, sketch, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketch, sketch, null, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, null, null, (ThetaSketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketch, null, (ThetaSketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, null, sketch, (ThetaSketch)skTheta, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketch, sketch, (ThetaSketch)skTheta, this.results);
    }

    @Test
    public void aNotBCheckDoubleSetAs() {
        UpdatableTupleSketch<Double, DoubleSummary> skA = AdoubleAnotBTest.buildUpdatableTuple();
        skA.update(1L, (Object)1.0);
        skA.update(2L, (Object)1.0);
        UpdatableTupleSketch<Double, DoubleSummary> skA2 = AdoubleAnotBTest.buildUpdatableTuple();
        TupleAnotB aNotB = new TupleAnotB();
        aNotB.setA(skA);
        Assert.assertEquals((boolean)aNotB.getResult(false).isEmpty(), (boolean)false);
        aNotB.setA(skA2);
        Assert.assertEquals((boolean)aNotB.getResult(false).isEmpty(), (boolean)true);
    }

    @Test
    public void aNotBEmptyExact() {
        UpdatableTupleSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        UpdatableTupleSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        sketchB.update(1L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        UpdatableThetaSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        skThetaB.update(1L);
        skThetaB.update(2L);
        TupleAnotB aNotB = new TupleAnotB();
        this.results.set(0, true, 0.0, 0.0, 0.0);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketchA, sketchB, (ThetaSketch)skThetaB, this.results);
    }

    @Test
    public void aNotBExactEmpty() {
        UpdatableTupleSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableTupleSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        UpdatableThetaSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        TupleAnotB aNotB = new TupleAnotB();
        this.results.set(2, false, 2.0, 0.0, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketchA, sketchB, (ThetaSketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, (TupleSketch<DoubleSummary>)sketchA.compact(), (TupleSketch<DoubleSummary>)sketchB.compact(), (ThetaSketch)skThetaB.compact(), this.results);
    }

    @Test
    public void aNotBExactOverlap() {
        UpdatableTupleSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        sketchA.update(1L, (Object)1.0);
        sketchA.update(1L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        sketchA.update(2L, (Object)1.0);
        UpdatableTupleSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        sketchB.update(2L, (Object)1.0);
        sketchB.update(2L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        sketchB.update(3L, (Object)1.0);
        UpdatableThetaSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        skThetaB.update(2L);
        skThetaB.update(3L);
        TupleAnotB aNotB = new TupleAnotB();
        this.results.set(1, false, 1.0, 0.0, 2.0);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketchA, sketchB, (ThetaSketch)skThetaB, this.results);
    }

    @Test
    public void aNotBEstimationOverlap() {
        UpdatableTupleSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 8192; ++i) {
            sketchA.update((long)i, (Object)1.0);
        }
        UpdatableTupleSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 4096; ++i) {
            sketchB.update((long)i, (Object)1.0);
        }
        UpdatableThetaSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        for (int i = 0; i < 4096; ++i) {
            skThetaB.update((long)i);
        }
        TupleAnotB aNotB = new TupleAnotB();
        this.results.set(2123, false, 4096.0, 0.03, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketchA, sketchB, (ThetaSketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, (TupleSketch<DoubleSummary>)sketchA.compact(), (TupleSketch<DoubleSummary>)sketchB.compact(), (ThetaSketch)skThetaB.compact(), this.results);
    }

    @Test
    public void aNotBEstimationOverlapLargeB() {
        UpdatableTupleSketch<Double, DoubleSummary> sketchA = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 10000; ++i) {
            sketchA.update((long)i, (Object)1.0);
        }
        UpdatableTupleSketch<Double, DoubleSummary> sketchB = AdoubleAnotBTest.buildUpdatableTuple();
        for (int i = 0; i < 100000; ++i) {
            sketchB.update((long)(i + 8000), (Object)1.0);
        }
        UpdatableThetaSketch skThetaB = AdoubleAnotBTest.buildUpdateTheta();
        for (int i = 0; i < 100000; ++i) {
            skThetaB.update((long)(i + 8000));
        }
        int expected = 8000;
        TupleAnotB aNotB = new TupleAnotB();
        this.results.set(376, false, 8000.0, 0.1, 1.0);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, sketchA, sketchB, (ThetaSketch)skThetaB, this.results);
        AdoubleAnotBTest.threeMethodsWithTheta((TupleAnotB<DoubleSummary>)aNotB, (TupleSketch<DoubleSummary>)sketchA.compact(), (TupleSketch<DoubleSummary>)sketchB.compact(), (ThetaSketch)skThetaB.compact(), this.results);
    }

    private static class Results {
        private int retEnt = 0;
        private boolean empty = true;
        private double expect = 0.0;
        private double tol = 0.0;
        private double sum = 0.0;

        Results() {
        }

        Results set(int retEnt, boolean empty, double expect, double tol, double sum) {
            this.retEnt = retEnt;
            this.empty = empty;
            this.expect = expect;
            this.tol = tol;
            this.sum = sum;
            return this;
        }

        void check(CompactTupleSketch<DoubleSummary> result) {
            Assert.assertEquals((int)result.getRetainedEntries(), (int)this.retEnt);
            Assert.assertEquals((boolean)result.isEmpty(), (boolean)this.empty);
            if (result.getTheta() < 1.0) {
                double est = result.getEstimate();
                Assert.assertEquals((double)est, (double)this.expect, (double)(this.expect * this.tol));
                Assert.assertTrue((result.getUpperBound(1) > est ? 1 : 0) != 0);
                Assert.assertTrue((result.getLowerBound(1) <= est ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((double)result.getEstimate(), (double)this.expect, (double)0.0);
                Assert.assertEquals((double)result.getUpperBound(1), (double)this.expect, (double)0.0);
                Assert.assertEquals((double)result.getLowerBound(1), (double)this.expect, (double)0.0);
            }
            TupleSketchIterator it = result.iterator();
            while (it.next()) {
                Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)this.sum);
            }
        }
    }
}

