/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.NegateOp$;
import org.apache.daffodil.runtime1.dpath.RecipeOpWithSubRecipes;
import org.apache.daffodil.runtime1.infoset.DataValue;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.TopScope$;

public class NegateOp
extends RecipeOpWithSubRecipes
implements Product {
    private final CompiledDPath recipe;

    public static NegateOp apply(CompiledDPath compiledDPath) {
        return NegateOp$.MODULE$.apply(compiledDPath);
    }

    public static NegateOp fromProduct(Product product) {
        return NegateOp$.MODULE$.fromProduct(product);
    }

    public static NegateOp unapply(NegateOp negateOp) {
        return NegateOp$.MODULE$.unapply(negateOp);
    }

    public NegateOp(CompiledDPath recipe) {
        this.recipe = recipe;
        super((scala.collection.immutable.Seq<CompiledDPath>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CompiledDPath[]{recipe}));
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -662921103, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NegateOp)) return false;
        NegateOp negateOp = (NegateOp)object;
        CompiledDPath compiledDPath = this.recipe();
        CompiledDPath compiledDPath2 = negateOp.recipe();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        if (!negateOp.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof NegateOp;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "NegateOp";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipe";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath recipe() {
        return this.recipe;
    }

    @Override
    public void run(DState dstate) {
        DataValue dataValue;
        this.recipe().run(dstate);
        Object object = dstate.currentValue();
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(object);
        if (object2 instanceof Integer) {
            Integer i = (Integer)object2;
            dataValue = new DataValue((BigInteger)((Object)DataValue$.MODULE$.toDataValue(Predef$.MODULE$.Integer2int(i) * -1)));
        } else if (object2 instanceof Long) {
            Long l = (Long)object2;
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(Predef$.MODULE$.Long2long(l) * -1L));
        } else if (object2 instanceof Double) {
            Double d = (Double)object2;
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(Predef$.MODULE$.Double2double(d) * -1.0));
        } else if (object2 instanceof BigInteger) {
            BigInteger bi = (BigInteger)object2;
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(bi.negate()));
        } else if (object2 instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object2;
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(bd.negate()));
        } else {
            Object object3 = dstate.currentValue();
            throw Assert$.MODULE$.invariantFailed("not a number: " + DataValue$.MODULE$.toString$extension(object3));
        }
        DataValue dataValue2 = dataValue;
        BigInteger value = dataValue2 == null ? null : dataValue2.v();
        dstate.setCurrentValue(value);
    }

    @Override
    public Node toXML() {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)this.recipe().toXML());
        return new Elem(null, "Negate", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    public NegateOp copy(CompiledDPath recipe) {
        return new NegateOp(recipe);
    }

    public CompiledDPath copy$default$1() {
        return this.recipe();
    }

    public CompiledDPath _1() {
        return this.recipe();
    }
}

