/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.blueprint;

import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.blueprint.AbstractBPBeanDefinitionParser;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http_undertow.blueprint.UndertowHTTPServerEngineFactoryHolder;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.w3c.dom.Element;

public class UndertowServerEngineFactoryParser
extends AbstractBPBeanDefinitionParser {
    public static final String UNDERTOW_TRANSPORT = "http://cxf.apache.org/transports/http-undertow/configuration";
    public static final String UNDERTOW_THREADING = "http://cxf.apache.org/configuration/parameterized-types";

    public static String getIdOrName(Element elem) {
        StringTokenizer st;
        String names;
        String id = elem.getAttribute("id");
        if ((null == id || "".equals(id)) && null != (names = elem.getAttribute("name")) && (st = new StringTokenizer(names, ",")).countTokens() > 0) {
            id = st.nextToken();
        }
        return id;
    }

    public Metadata parse(Element element, ParserContext context) {
        MutableBeanMetadata ef = (MutableBeanMetadata)context.createMetadata(MutableBeanMetadata.class);
        if (!StringUtils.isEmpty((String)UndertowServerEngineFactoryParser.getIdOrName(element))) {
            ef.setId(UndertowServerEngineFactoryParser.getIdOrName(element));
        } else {
            ef.setId("undertow.engine.factory-holder-" + UUID.randomUUID().toString());
        }
        ef.setRuntimeClass(UndertowHTTPServerEngineFactoryHolder.class);
        try {
            String xmlString = StaxUtils.toString((Element)element);
            ef.addProperty("parsedElement", (Metadata)UndertowServerEngineFactoryParser.createValue((ParserContext)context, (String)xmlString));
            ef.setInitMethod("init");
            ef.setActivation(1);
            ef.setDestroyMethod("destroy");
            List engines = DOMUtils.getChildrenWithName((Element)element, (String)UNDERTOW_TRANSPORT, (String)"engine");
            ef.addProperty("handlersMap", this.parseEngineHandlers(engines, (ComponentMetadata)ef, context));
            return ef;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    protected Metadata parseEngineHandlers(List<Element> engines, ComponentMetadata enclosingComponent, ParserContext context) {
        MutableMapMetadata map = (MutableMapMetadata)context.createMetadata(MutableMapMetadata.class);
        map.setKeyType("java.lang.String");
        map.setValueType("java.util.List");
        for (Element engine : engines) {
            String port = engine.getAttribute("port");
            ValueMetadata keyValue = UndertowServerEngineFactoryParser.createValue((ParserContext)context, (String)port);
            Element handlers = DOMUtils.getFirstChildWithName((Element)engine, (String)UNDERTOW_TRANSPORT, (String)"handlers");
            if (handlers == null) continue;
            Metadata valValue = this.parseListData(context, enclosingComponent, handlers);
            map.addEntry((NonNullMetadata)keyValue, valValue);
        }
        return map;
    }
}

