/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.url.UrlFileProvider;
import org.apache.commons.vfs2.util.NHttpFileServer;

public class UrlProviderHttpTestCase
extends AbstractProviderTestConfig {
    private static NHttpFileServer server;
    private static final String TEST_URI = "test.http.uri";
    private static String connectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        server = NHttpFileServer.start(0, new File(VfsTestUtils.getTestDirectory()), 5000L);
        connectionUri = UrlProviderHttpTestCase.getLocalHostUriString("http", server.getPort());
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new UrlProviderHttpTestCase()){

            @Override
            protected void setUp() throws Exception {
                if (UrlProviderHttpTestCase.getSystemTestUriOverride() == null) {
                    UrlProviderHttpTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                UrlProviderHttpTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    public static void tearDownClass() throws InterruptedException {
        if (server != null) {
            server.shutdown(5000L, TimeUnit.SECONDS);
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = UrlProviderHttpTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = connectionUri;
        }
        return manager.resolveFile(uri);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("http", (FileProvider)new UrlFileProvider());
    }
}

