/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.interpol;

import java.io.File;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.interpol.ExprLookup;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.junit.Assert;
import org.junit.Test;

public class TestExprLookup {
    private static File TEST_FILE = ConfigurationAssert.getTestFile("test.xml");
    private static String PATTERN1 = "String.replace(Util.message, 'Hello', 'Goodbye') + System.getProperty('user.name')";
    private static String PATTERN2 = "'$[element] ' + String.trimToEmpty('$[space.description]')";

    @Test
    public void testLookup() throws Exception {
        ConsoleAppender app = new ConsoleAppender((Layout)new SimpleLayout());
        Log log = LogFactory.getLog((String)"TestLogger");
        Logger logger = ((Log4JLogger)log).getLogger();
        logger.addAppender((Appender)app);
        logger.setLevel(Level.DEBUG);
        logger.setAdditivity(false);
        ExprLookup.Variables vars = new ExprLookup.Variables();
        vars.add((Object)new ExprLookup.Variable("String", StringUtils.class));
        vars.add((Object)new ExprLookup.Variable("Util", (Object)new Utility("Hello")));
        vars.add((Object)new ExprLookup.Variable("System", (Object)"Class:java.lang.System"));
        XMLConfiguration config = new XMLConfiguration(TEST_FILE);
        config.setLogger(log);
        ExprLookup lookup = new ExprLookup(vars);
        lookup.setConfiguration((AbstractConfiguration)config);
        String str = lookup.lookup(PATTERN1);
        Assert.assertTrue((boolean)str.startsWith("Goodbye"));
        str = lookup.lookup(PATTERN2);
        Assert.assertTrue((String)("Incorrect value: " + str), (boolean)str.equals("value Some text"));
        logger.removeAppender((Appender)app);
    }

    public static class Utility {
        String message;

        public Utility(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }

        public String str(String str) {
            return str;
        }
    }
}

