/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableListTest<E>
extends AbstractListTest<E> {
    protected UnmodifiableList<E> list;
    protected ArrayList<E> array;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public boolean isSetSupported() {
        return false;
    }

    @Override
    public UnmodifiableList<E> makeFullCollection() {
        ArrayList list = new ArrayList(Arrays.asList(this.getFullElements()));
        return new UnmodifiableList(list);
    }

    @Override
    public UnmodifiableList<E> makeObject() {
        return new UnmodifiableList(new ArrayList());
    }

    protected void setupList() {
        this.list = this.makeFullCollection();
        this.array = new ArrayList();
        this.array.add(1);
    }

    @Test
    public void testDecorateFactory() {
        UnmodifiableList<E> list = this.makeObject();
        Assertions.assertSame(list, (Object)UnmodifiableList.unmodifiableList(list));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableList.unmodifiableList(null));
    }

    @Test
    public void testUnmodifiable() {
        this.setupList();
        this.verifyUnmodifiable((List<E>)this.list);
        this.verifyUnmodifiable(this.list.subList(0, 2));
    }

    @Test
    public void testUnmodifiableIterator() {
        this.setupList();
        Iterator iterator = this.list.iterator();
        iterator.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> iterator.remove(), (String)"Expecting UnsupportedOperationException.");
    }

    protected void verifyUnmodifiable(List<E> list) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.add(0, 0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.add(0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.addAll(0, this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.addAll(this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.remove(0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.remove((Object)0));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.removeAll(this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.retainAll(this.array));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.set(0, 0));
    }
}

