/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.axis2.databinding;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

import java.io.Serializable;

/*
 * ADBBean - Axis Data Binding Bean. This will be implemented by all the beans that are being generated by
 * Axis2 data binding framework
 */

public interface ADBBean extends Serializable {
    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException;

    public void serialize(final QName parentQName,
                          XMLStreamWriter xmlWriter)
            throws XMLStreamException, ADBException;

    public void serialize(final QName parentQName,
                          XMLStreamWriter xmlWriter,
                          boolean serializeType)
            throws XMLStreamException, ADBException;

    /**
     * There will be a self factory in every generated data bound class XXX:
     * public static XXX read (XMLStreamReader);
     */
}
