/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.tfile;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationHtmlBlock;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletImpl;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class TFileAggregatedLogsBlock
extends LogAggregationHtmlBlock {
    private final Configuration conf;
    private Path remoteRootLogDir;
    private String remoteRootLogDirSuffix;

    @Inject
    public TFileAggregatedLogsBlock(View.ViewContext ctx, Configuration conf, Path remoteRootLogDir, String remoteRootLogDirSuffix) {
        super(ctx);
        this.conf = conf;
        this.remoteRootLogDir = remoteRootLogDir;
        this.remoteRootLogDirSuffix = remoteRootLogDirSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void render(HtmlBlock.Block html) {
        RemoteIterator<FileStatus> nodeFiles;
        LogAggregationHtmlBlock.BlockParameters params = this.verifyAndParseParameters(html);
        if (params == null) {
            return;
        }
        try {
            nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, params.getAppId(), params.getAppOwner(), this.remoteRootLogDir, this.remoteRootLogDirSuffix);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            html.h1("No logs available for container " + params.getContainerId().toString());
            return;
        }
        NodeId nodeId = params.getNodeId();
        String logEntity = params.getLogEntity();
        ApplicationId appId = params.getAppId();
        ContainerId containerId = params.getContainerId();
        long start = params.getStartIndex();
        long end = params.getEndIndex();
        long startTime = params.getStartTime();
        long endTime = params.getEndTime();
        boolean foundLog = false;
        String desiredLogType = this.$("log.type");
        try {
            while (nodeFiles.hasNext()) {
                AggregatedLogFormat.LogReader reader = null;
                try {
                    long logUploadedTime;
                    FileStatus thisNodeFile = nodeFiles.next();
                    if (thisNodeFile.getPath().getName().equals(params.getAppId() + ".har")) {
                        Path p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                        nodeFiles = HarFs.get(p.toUri(), this.conf).listStatusIterator(p);
                        continue;
                    }
                    if (!thisNodeFile.getPath().getName().contains(LogAggregationUtils.getNodeString(nodeId)) || thisNodeFile.getPath().getName().endsWith(".tmp") || (logUploadedTime = thisNodeFile.getModificationTime()) < startTime || logUploadedTime > endTime) continue;
                    reader = new AggregatedLogFormat.LogReader(this.conf, thisNodeFile.getPath());
                    String owner = null;
                    Map<ApplicationAccessType, String> appAcls = null;
                    try {
                        owner = reader.getApplicationOwner();
                        appAcls = reader.getApplicationAcls();
                    }
                    catch (IOException e) {
                        LOG.error("Error getting logs for " + logEntity, e);
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                    String remoteUser = this.request().getRemoteUser();
                    if (!this.checkAcls(this.conf, appId, owner, appAcls, remoteUser)) {
                        ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"User [" + remoteUser + "] is not authorized to view the logs for " + logEntity + " in log file [" + thisNodeFile.getPath().getName() + "]"}))).__();
                        LOG.error("User [" + remoteUser + "] is not authorized to view the logs for " + logEntity);
                        continue;
                    }
                    AggregatedLogFormat.ContainerLogsReader logReader = reader.getContainerLogsReader(containerId);
                    if (logReader == null) continue;
                    foundLog = this.readContainerLogs(html, logReader, start, end, desiredLogType, logUploadedTime, startTime, endTime);
                }
                catch (IOException ex) {
                    LOG.error("Error getting logs for " + logEntity, ex);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            if (foundLog) return;
            if (desiredLogType.isEmpty()) {
                html.h1("No logs available for container " + containerId.toString());
                return;
            }
            html.h1("Unable to locate '" + desiredLogType + "' log for container " + containerId.toString());
            return;
        }
        catch (IOException e) {
            ((HamletImpl.EImp)((Object)((Hamlet.H1)html.h1()).__(new Object[]{"Error getting logs for " + logEntity}))).__();
            LOG.error("Error getting logs for " + logEntity, e);
        }
    }

    private boolean readContainerLogs(HtmlBlock.Block html, AggregatedLogFormat.ContainerLogsReader logReader, long startIndex, long endIndex, String desiredLogType, long logUpLoadTime, long startTime, long endTime) throws IOException {
        int bufferSize = 65536;
        byte[] cbuf = new byte[bufferSize];
        boolean foundLog = false;
        String logType = logReader.nextLog();
        while (logType != null) {
            if (desiredLogType == null || desiredLogType.isEmpty() || desiredLogType.equals(logType)) {
                long logLength = logReader.getCurrentLogLength();
                if (foundLog) {
                    ((HamletImpl.EImp)((Object)((Hamlet.PRE)html.pre()).__(new Object[]{"\n\n"}))).__();
                }
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Type: " + logType}))).__();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Upload Time: " + Times.format(logUpLoadTime)}))).__();
                ((HamletImpl.EImp)((Object)((Hamlet.P)html.p()).__(new Object[]{"Log Length: " + Long.toString(logLength)}))).__();
                long[] range = this.checkParseRange(html, startIndex, endIndex, startTime, endTime, logLength, logType);
                this.processContainerLog(html, range, logReader, bufferSize, cbuf);
                foundLog = true;
            }
            logType = logReader.nextLog();
        }
        return foundLog;
    }
}

