/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationResourceUsageReportPBImpl
extends ApplicationResourceUsageReport {
    YarnProtos.ApplicationResourceUsageReportProto proto = YarnProtos.ApplicationResourceUsageReportProto.getDefaultInstance();
    YarnProtos.ApplicationResourceUsageReportProto.Builder builder = null;
    boolean viaProto = false;
    Resource usedResources;
    Resource reservedResources;
    Resource neededResources;
    private Map<String, Long> resourceSecondsMap;
    private Map<String, Long> preemptedResourceSecondsMap;

    public ApplicationResourceUsageReportPBImpl() {
        this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder();
    }

    public ApplicationResourceUsageReportPBImpl(YarnProtos.ApplicationResourceUsageReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
        this.getResourceSecondsMap();
        this.getPreemptedResourceSecondsMap();
    }

    public synchronized YarnProtos.ApplicationResourceUsageReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationResourceUsageReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.usedResources != null) {
            this.builder.setUsedResources(this.convertToProtoFormat(this.usedResources));
        }
        if (this.reservedResources != null) {
            this.builder.setReservedResources(this.convertToProtoFormat(this.reservedResources));
        }
        if (this.neededResources != null) {
            this.builder.setNeededResources(this.convertToProtoFormat(this.neededResources));
        }
        this.builder.clearApplicationResourceUsageMap();
        this.builder.clearApplicationPreemptedResourceUsageMap();
        if (this.preemptedResourceSecondsMap != null && !this.preemptedResourceSecondsMap.isEmpty()) {
            this.builder.addAllApplicationPreemptedResourceUsageMap(ProtoUtils.convertMapToStringLongMapProtoList(this.preemptedResourceSecondsMap));
        }
        if (this.resourceSecondsMap != null && !this.resourceSecondsMap.isEmpty()) {
            this.builder.addAllApplicationResourceUsageMap(ProtoUtils.convertMapToStringLongMapProtoList(this.resourceSecondsMap));
        }
        this.builder.setMemorySeconds(this.getMemorySeconds());
        this.builder.setVcoreSeconds(this.getVcoreSeconds());
        this.builder.setPreemptedMemorySeconds(this.getPreemptedMemorySeconds());
        this.builder.setPreemptedVcoreSeconds(this.getPreemptedVcoreSeconds());
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized int getNumUsedContainers() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumUsedContainers();
    }

    @Override
    public synchronized void setNumUsedContainers(int num_containers) {
        this.maybeInitBuilder();
        this.builder.setNumUsedContainers(num_containers);
    }

    @Override
    public synchronized int getNumReservedContainers() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumReservedContainers();
    }

    @Override
    public synchronized void setNumReservedContainers(int num_reserved_containers) {
        this.maybeInitBuilder();
        this.builder.setNumReservedContainers(num_reserved_containers);
    }

    @Override
    public synchronized Resource getUsedResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.usedResources != null) {
            return this.usedResources;
        }
        if (!p.hasUsedResources()) {
            return null;
        }
        this.usedResources = this.convertFromProtoFormat(p.getUsedResources());
        return this.usedResources;
    }

    @Override
    public synchronized void setUsedResources(Resource resources) {
        this.maybeInitBuilder();
        if (resources == null) {
            this.builder.clearUsedResources();
        }
        this.usedResources = resources;
    }

    @Override
    public synchronized Resource getReservedResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.reservedResources != null) {
            return this.reservedResources;
        }
        if (!p.hasReservedResources()) {
            return null;
        }
        this.reservedResources = this.convertFromProtoFormat(p.getReservedResources());
        return this.reservedResources;
    }

    @Override
    public synchronized void setReservedResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearReservedResources();
        }
        this.reservedResources = reserved_resources;
    }

    @Override
    public synchronized Resource getNeededResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.neededResources != null) {
            return this.neededResources;
        }
        if (!p.hasNeededResources()) {
            return null;
        }
        this.neededResources = this.convertFromProtoFormat(p.getNeededResources());
        return this.neededResources;
    }

    @Override
    public synchronized void setNeededResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearNeededResources();
        }
        this.neededResources = reserved_resources;
    }

    @Override
    public synchronized void setMemorySeconds(long memory_seconds) {
        this.getResourceSecondsMap().put(ResourceInformation.MEMORY_MB.getName(), memory_seconds);
    }

    @Override
    public synchronized long getMemorySeconds() {
        Map<String, Long> tmp = this.getResourceSecondsMap();
        if (tmp.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            return tmp.get(ResourceInformation.MEMORY_MB.getName());
        }
        return 0L;
    }

    @Override
    public synchronized void setVcoreSeconds(long vcore_seconds) {
        this.getResourceSecondsMap().put(ResourceInformation.VCORES.getName(), vcore_seconds);
    }

    @Override
    public synchronized long getVcoreSeconds() {
        Map<String, Long> tmp = this.getResourceSecondsMap();
        if (tmp.containsKey(ResourceInformation.VCORES.getName())) {
            return tmp.get(ResourceInformation.VCORES.getName());
        }
        return 0L;
    }

    @Override
    public synchronized void setPreemptedMemorySeconds(long preemptedMemorySeconds) {
        this.getPreemptedResourceSecondsMap().put(ResourceInformation.MEMORY_MB.getName(), preemptedMemorySeconds);
    }

    @Override
    public synchronized long getPreemptedMemorySeconds() {
        Map<String, Long> tmp = this.getPreemptedResourceSecondsMap();
        if (tmp.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            return tmp.get(ResourceInformation.MEMORY_MB.getName());
        }
        return 0L;
    }

    @Override
    public synchronized void setPreemptedVcoreSeconds(long vcoreSeconds) {
        this.getPreemptedResourceSecondsMap().put(ResourceInformation.VCORES.getName(), vcoreSeconds);
    }

    @Override
    public synchronized long getPreemptedVcoreSeconds() {
        Map<String, Long> tmp = this.getPreemptedResourceSecondsMap();
        if (tmp.containsKey(ResourceInformation.VCORES.getName())) {
            return tmp.get(ResourceInformation.VCORES.getName());
        }
        return 0L;
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat(t);
    }

    @Override
    public synchronized float getQueueUsagePercentage() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getQueueUsagePercentage();
    }

    @Override
    public synchronized void setQueueUsagePercentage(float queueUsagePerc) {
        this.maybeInitBuilder();
        this.builder.setQueueUsagePercentage(queueUsagePerc);
    }

    @Override
    public synchronized float getClusterUsagePercentage() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getClusterUsagePercentage();
    }

    @Override
    public synchronized void setClusterUsagePercentage(float clusterUsagePerc) {
        this.maybeInitBuilder();
        this.builder.setClusterUsagePercentage(clusterUsagePerc);
    }

    @Override
    public synchronized void setResourceSecondsMap(Map<String, Long> resourceSecondsMap) {
        this.resourceSecondsMap = resourceSecondsMap;
        if (resourceSecondsMap == null) {
            return;
        }
        if (!resourceSecondsMap.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            this.setMemorySeconds(0L);
        }
        if (!resourceSecondsMap.containsKey(ResourceInformation.VCORES.getName())) {
            this.setVcoreSeconds(0L);
        }
    }

    @Override
    public synchronized Map<String, Long> getResourceSecondsMap() {
        if (this.resourceSecondsMap != null) {
            return this.resourceSecondsMap;
        }
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.resourceSecondsMap = ProtoUtils.convertStringLongMapProtoListToMap(p.getApplicationResourceUsageMapList());
        if (!this.resourceSecondsMap.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            this.setMemorySeconds(p.getMemorySeconds());
        }
        if (!this.resourceSecondsMap.containsKey(ResourceInformation.VCORES.getName())) {
            this.setVcoreSeconds(p.getVcoreSeconds());
        }
        this.setMemorySeconds(p.getMemorySeconds());
        this.setVcoreSeconds(p.getVcoreSeconds());
        return this.resourceSecondsMap;
    }

    @Override
    public synchronized void setPreemptedResourceSecondsMap(Map<String, Long> preemptedResourceSecondsMap) {
        this.preemptedResourceSecondsMap = preemptedResourceSecondsMap;
        if (preemptedResourceSecondsMap == null) {
            return;
        }
        if (!preemptedResourceSecondsMap.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            this.setPreemptedMemorySeconds(0L);
        }
        if (!preemptedResourceSecondsMap.containsKey(ResourceInformation.VCORES.getName())) {
            this.setPreemptedVcoreSeconds(0L);
        }
    }

    @Override
    public synchronized Map<String, Long> getPreemptedResourceSecondsMap() {
        if (this.preemptedResourceSecondsMap != null) {
            return this.preemptedResourceSecondsMap;
        }
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.preemptedResourceSecondsMap = ProtoUtils.convertStringLongMapProtoListToMap(p.getApplicationPreemptedResourceUsageMapList());
        if (!this.preemptedResourceSecondsMap.containsKey(ResourceInformation.MEMORY_MB.getName())) {
            this.setPreemptedMemorySeconds(p.getPreemptedMemorySeconds());
        }
        if (!this.preemptedResourceSecondsMap.containsKey(ResourceInformation.VCORES.getName())) {
            this.setPreemptedVcoreSeconds(p.getPreemptedVcoreSeconds());
        }
        this.setPreemptedMemorySeconds(p.getPreemptedMemorySeconds());
        this.setPreemptedVcoreSeconds(p.getPreemptedVcoreSeconds());
        return this.preemptedResourceSecondsMap;
    }
}

