/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.vault.config.ConditionalOnAuthentication;
import org.springframework.cloud.vault.config.DefaultWebClientFactory;
import org.springframework.cloud.vault.config.VaultAutoConfiguration;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultReactiveConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ReactiveSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.ReactiveVaultEndpointProvider;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.client.WebClientBuilder;
import org.springframework.vault.client.WebClientCustomizer;
import org.springframework.vault.client.WebClientFactory;
import org.springframework.vault.core.ReactiveVaultOperations;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.netty.http.client.HttpClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="${spring.cloud.vault.reactive.enabled:true}")
@ConditionalOnClass(value={Flux.class, WebClient.class, ReactiveVaultOperations.class, HttpClient.class})
@EnableConfigurationProperties(value={VaultProperties.class})
@AutoConfigureBefore(value={VaultAutoConfiguration.class})
public class VaultReactiveAutoConfiguration
implements InitializingBean {
    @Nullable
    private final ConfigurableApplicationContext applicationContext;
    private final VaultProperties vaultProperties;
    private final VaultReactiveConfiguration configuration;
    @Nullable
    private final ReactiveVaultEndpointProvider reactiveEndpointProvider;
    @Nullable
    private final VaultEndpointProvider endpointProvider;
    private final List<WebClientCustomizer> customizers;

    @Deprecated
    public VaultReactiveAutoConfiguration(VaultProperties vaultProperties, ObjectProvider<ReactiveVaultEndpointProvider> reactiveEndpointProvider, ObjectProvider<VaultEndpointProvider> endpointProvider, ObjectProvider<List<WebClientCustomizer>> webClientCustomizers) {
        this(null, vaultProperties, reactiveEndpointProvider, endpointProvider, webClientCustomizers);
    }

    @Autowired
    public VaultReactiveAutoConfiguration(@Nullable ConfigurableApplicationContext applicationContext, VaultProperties vaultProperties, ObjectProvider<ReactiveVaultEndpointProvider> reactiveEndpointProvider, ObjectProvider<VaultEndpointProvider> endpointProvider, ObjectProvider<List<WebClientCustomizer>> webClientCustomizers) {
        this.applicationContext = applicationContext;
        this.vaultProperties = vaultProperties;
        this.configuration = new VaultReactiveConfiguration(vaultProperties);
        this.reactiveEndpointProvider = (ReactiveVaultEndpointProvider)reactiveEndpointProvider.getIfAvailable();
        this.endpointProvider = this.reactiveEndpointProvider == null ? (VaultEndpointProvider)endpointProvider.getIfAvailable(() -> SimpleVaultEndpointProvider.of((VaultEndpoint)new VaultConfiguration(vaultProperties).createVaultEndpoint())) : null;
        this.customizers = new ArrayList<WebClientCustomizer>((Collection)webClientCustomizers.getIfAvailable(Collections::emptyList));
        AnnotationAwareOrderComparator.sort(this.customizers);
    }

    protected WebClientBuilder webClientBuilder(ClientHttpConnector connector) {
        if (this.reactiveEndpointProvider != null) {
            return this.configuration.createWebClientBuilder(connector, this.reactiveEndpointProvider, this.customizers);
        }
        if (this.endpointProvider != null) {
            return this.configuration.createWebClientBuilder(connector, this.endpointProvider, this.customizers);
        }
        throw new IllegalStateException("Cannot create WebClientBuilder as neither ReactiveEndpointProvider nor EndpointProvider configured");
    }

    @Bean
    @ConditionalOnMissingBean
    public ClientHttpConnectorWrapper clientHttpConnectorWrapper() {
        return new ClientHttpConnectorWrapper(this.createConnector(this.vaultProperties));
    }

    public void afterPropertiesSet() {
    }

    protected ClientHttpConnector createConnector(VaultProperties vaultProperties) {
        return new VaultReactiveConfiguration(vaultProperties).createClientHttpConnector();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClientFactory vaultWebClientFactory() {
        ClientHttpConnector connector = this.getClientHttpConnector();
        return new DefaultWebClientFactory(connector, this::webClientBuilder);
    }

    protected ClientHttpConnector getClientHttpConnector() {
        if (this.applicationContext != null) {
            return ((ClientHttpConnectorWrapper)this.applicationContext.getBean(ClientHttpConnectorWrapper.class)).getConnector();
        }
        return this.createConnector(this.vaultProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveVaultOperations.class})
    public ReactiveVaultTemplate reactiveVaultTemplate(ObjectProvider<ReactiveSessionManager> sessionManager) {
        WebClientBuilder webClientBuilder = this.webClientBuilder(this.getClientHttpConnector());
        if (this.vaultProperties.getAuthentication() == VaultProperties.AuthenticationMethod.NONE) {
            return new ReactiveVaultTemplate(webClientBuilder);
        }
        return new ReactiveVaultTemplate(webClientBuilder, (VaultTokenSupplier)sessionManager.getObject());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAuthentication
    public ReactiveSessionManager reactiveVaultSessionManager(BeanFactory beanFactory, ObjectFactory<VaultAutoConfiguration.TaskSchedulerWrapper> asyncTaskExecutorFactory, WebClientFactory webClientFactory) {
        VaultTokenSupplier vaultTokenSupplier = (VaultTokenSupplier)beanFactory.getBean("vaultTokenSupplier", VaultTokenSupplier.class);
        return this.configuration.createReactiveSessionManager(vaultTokenSupplier, () -> ((VaultAutoConfiguration.TaskSchedulerWrapper)asyncTaskExecutorFactory.getObject()).getTaskScheduler(), webClientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAuthentication
    public SessionManager vaultSessionManager(ReactiveSessionManager sessionManager) {
        return this.configuration.createSessionManager(sessionManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"vaultTokenSupplier"})
    @ConditionalOnAuthentication
    public VaultTokenSupplier vaultTokenSupplier(ListableBeanFactory beanFactory, WebClientFactory webClientFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        return this.configuration.createVaultTokenSupplier(webClientFactory, () -> (AuthenticationStepsFactory)beanFactory.getBeanProvider(AuthenticationStepsFactory.class, false).getIfAvailable(), () -> (ClientAuthentication)beanFactory.getBeanProvider(ClientAuthentication.class, false).getIfAvailable());
    }

    public static class ClientHttpConnectorWrapper
    implements InitializingBean,
    DisposableBean {
        private final ClientHttpConnector connector;

        public ClientHttpConnectorWrapper(ClientHttpConnector connector) {
            this.connector = connector;
        }

        public void destroy() throws Exception {
            if (this.connector instanceof DisposableBean) {
                ((DisposableBean)this.connector).destroy();
            }
        }

        public void afterPropertiesSet() throws Exception {
            if (this.connector instanceof InitializingBean) {
                ((InitializingBean)this.connector).afterPropertiesSet();
            }
        }

        public ClientHttpConnector getConnector() {
            return this.connector;
        }
    }
}

