/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public interface NameRegister {
    public void register(InetAddress var1, String var2, NameType var3);

    public boolean checkName(InetAddress var1, String var2, NameType var3);

    public String incrementName(InetAddress var1, String var2, NameType var3);

    public static class Factory {
        private static volatile NameRegister _register;

        public static void setRegistry(NameRegister register) throws IllegalStateException {
            if (_register != null) {
                throw new IllegalStateException("The register can only be set once.");
            }
            if (register != null) {
                _register = register;
            }
        }

        public static NameRegister getRegistry() {
            if (_register == null) {
                _register = new UniqueNamePerInterface();
            }
            return _register;
        }
    }

    public static class UniqueNameAcrossInterface
    extends BaseRegister {
        @Override
        public void register(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: 
                case SERVICE: {
                    break;
                }
            }
        }

        @Override
        public boolean checkName(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: {
                    return false;
                }
                case SERVICE: {
                    return false;
                }
            }
            return false;
        }

        @Override
        public String incrementName(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: {
                    return this.incrementNameWithDash(name);
                }
                case SERVICE: {
                    return this.incrementNameWithParentesis(name);
                }
            }
            return name;
        }
    }

    public static class UniqueNamePerInterface
    extends BaseRegister {
        private final ConcurrentMap<InetAddress, String> _hostNames = new ConcurrentHashMap<InetAddress, String>();
        private final ConcurrentMap<InetAddress, Set<String>> _serviceNames = new ConcurrentHashMap<InetAddress, Set<String>>();

        @Override
        public void register(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: 
                case SERVICE: {
                    break;
                }
            }
        }

        @Override
        public boolean checkName(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: {
                    String hostname = (String)this._hostNames.get(networkInterface);
                    return hostname != null && hostname.equals(name);
                }
                case SERVICE: {
                    Set names = (Set)this._serviceNames.get(networkInterface);
                    return names != null && names.contains(name);
                }
            }
            return false;
        }

        @Override
        public String incrementName(InetAddress networkInterface, String name, NameType type) {
            switch (type) {
                case HOST: {
                    return this.incrementNameWithDash(name);
                }
                case SERVICE: {
                    return this.incrementNameWithParentesis(name);
                }
            }
            return name;
        }
    }

    public static abstract class BaseRegister
    implements NameRegister {
        protected String incrementNameWithDash(String name) {
            int hostNameCount;
            StringBuilder givenName = new StringBuilder(name.length() + 5);
            int plocal = name.indexOf(".local.");
            int punder = name.lastIndexOf(45);
            if (punder < 0) {
                hostNameCount = 1;
                givenName.append(name, 0, plocal);
            } else {
                try {
                    int value = Integer.parseInt(name.substring(punder + 1, plocal));
                    hostNameCount = value + 1;
                    givenName.append(name, 0, punder);
                }
                catch (Exception e) {
                    hostNameCount = 1;
                    givenName.append(name, 0, plocal);
                }
            }
            givenName.append('-');
            givenName.append(hostNameCount);
            givenName.append(".local.");
            return givenName.toString();
        }

        protected String incrementNameWithParentesis(String name) {
            StringBuilder givenName = new StringBuilder(name.length() + 5);
            int l = name.lastIndexOf(40);
            int r = name.lastIndexOf(41);
            if (l >= 0 && l < r) {
                try {
                    givenName.append(name, 0, l);
                    givenName.append('(');
                    givenName.append(Integer.parseInt(name.substring(l + 1, r)) + 1);
                    givenName.append(')');
                }
                catch (NumberFormatException e) {
                    givenName.setLength(0);
                    givenName.append(name);
                    givenName.append(" (2)");
                }
            } else {
                givenName.append(name);
                givenName.append(" (2)");
            }
            return givenName.toString();
        }
    }

    public static enum NameType {
        HOST,
        SERVICE;

    }
}

