"      NAME	Crystal Reports Engine External Interface
       AUTHOR	david@lucida.com
       URL	
       FUNCTION	Allows access to the CrystalReports (v5.0 Professional) dll from VisualWorks 2.5.1
       ST-VERSIONS	VisualWorks 2.5
       PREREQUISITES	DLLCConnect, 32 Bit windows platform, CrystalReports Professional Edition v5.0 or greater
       CONFLICTS	(none known)
       DISTRIBUTION	world
       VERSION	2.0
       DATE	03-Jun-97crystal
				David Brown
"!


ExternalInterface subclass: #LucidaCrystalReportsEngineInterface
	includeFiles: 'luccrpe.h'
	includeDirectories: ''
	libraryFiles: 'crpe32.dll '
	libraryDirectories: 'c:\winnt\system32 '
	generateMethods: ''
	beVirtual: false
	optimizationLevel: #full
	instanceVariableNames: 'showDialogs waitForJobCompletion '
	classVariableNames: 'ShowDialogs WaitForJobCompletion '
	poolDictionaries: 'LucidaCrystalReportsEngineInterfaceDictionary '
	category: 'LucidaCrystalReportsEngine'!


Object subclass: #LucidaCrystalJob
	instanceVariableNames: 'handle interface outputOption '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!



Object subclass: #LucidaCrystalJobInfo
	instanceVariableNames: 'infoStructure statusString '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


Object subclass: #LucidaCrystalJobOutputOption
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


LucidaCrystalJobOutputOption subclass: #LucidaCrystalExportRequestOptions
	instanceVariableNames: 'optionsStructure '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


LucidaCrystalJobOutputOption subclass: #LucidaCrystalJobExportOption
	instanceVariableNames: 'optionsStructure formatStructure destinationStructure '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!



LucidaCrystalJobExportOption subclass: #LucidaCrystalExportToHTML
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


LucidaCrystalJobExportOption subclass: #LucidaCrystalExportToRTF
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


LucidaCrystalJobExportOption subclass: #LucidaCrystalExportToWKS3
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!


LucidaCrystalJobExportOption subclass: #LucidaCrystalExportToXLS5
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'LucidaCrystalReportsEngine'!



!LucidaCrystalExportRequestOptions class methodsFor: 'constants'!

optionDisplayString
	" ^	<String>"
	"Return a description that would help a user select this option"

	^ 'User dialogs to request information'! !

!LucidaCrystalExportRequestOptions methodsFor: 'accessing'!

optionsStructure
	" ^	<CPointer> to PEExportOptions"

	^ self myOptionsStructure! !

!LucidaCrystalExportRequestOptions methodsFor: 'actions'!

prepareJob: aJob
	"aJob	<LucidaCrystalPrintJob>
		^	aJob"
	"Prepare the job to be printed using my format"

	aJob interface requestExportOptionsForJob: aJob.
	aJob interface prepareJobForExport: aJob.! !

!LucidaCrystalExportRequestOptions methodsFor: 'constants'!

requiresDestinationFileString
	" ^	<Boolean>"
	"Return true if I require a filename for my destination"

	^ false! !

!LucidaCrystalExportRequestOptions methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.	
	self myOptionsStructure: aJob interface __PEExportOptions gcMalloc.
	self myOptionsStructure 
		memberAt:#StructSize put: aJob interface PE_SIZEOF_EXPORT_OPTIONS.! !

!LucidaCrystalExportRequestOptions methodsFor: 'private - accessing'!

myOptionsStructure
	" ^ 	<CPointer>"
	"PRIVATE  read accessor for optionsStructure"

	^ optionsStructure!

myOptionsStructure: anOptionsStructure
	" anOptionsStructure	<CPointer>
	        ^ 			self"
	"PRIVATE write accessor for optionsStructure"

	optionsStructure := anOptionsStructure! !

!LucidaCrystalExportToHTML class methodsFor: 'constants'!

optionDisplayString
	" ^	<String>"
	"Return a description that would help a user select this option"

	^ 'Export to HTML 3.0 file'! !

!LucidaCrystalExportToHTML methodsFor: 'acessing'!

fileString: filename
	"filename		<String>
		^			self "

	self myFormatStructure memberAt:#fileName put:  filename gcCopyToHeap.
	self myDestinationStructure memberAt:#fileName put:  filename gcCopyToHeap.! !

!LucidaCrystalExportToHTML methodsFor: 'constants'!

destinationDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2ddisk'!

formatDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2fhtml'!

requiresDestinationFileString
	" ^	<Boolean>"
	"Return true if I require a filename for my destination"

	^ true! !

!LucidaCrystalExportToHTML methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.
	self myOptionsStructure	
		memberAt: #formatType put: aJob interface UXFHTML3Type ;
		memberAt: #destinationType put: aJob interface UXDDiskType.

	self myFormatStructure: aJob interface UXFHTML3Options gcMalloc.
	self myFormatStructure 
		memberAt:#structSize put: aJob interface UXFHTML3OptionsSize.
	self myOptionsStructure memberAt: #formatOptions put: self myFormatStructure.

	self myDestinationStructure: aJob interface __UXDDiskOptions gcMalloc.
	self myDestinationStructure 
		memberAt:#structSize put: aJob interface UXDDiskOptionsSize.
	self myOptionsStructure memberAt: #destinationOptions put: self myDestinationStructure.! !

!LucidaCrystalExportToRTF class methodsFor: 'constants'!

optionDisplayString
	" ^	<String>"
	"Return a description that would help a user select this option"

	^ 'Export to Rich Text Format (RTF) file'! !

!LucidaCrystalExportToRTF methodsFor: 'acessing'!

fileString: filename
	"filename		<String>
		^			self "

	self myDestinationStructure memberAt:#fileName put:  filename gcCopyToHeap.! !

!LucidaCrystalExportToRTF methodsFor: 'constants'!

defaultLinesPerPage
	" ^	<Integer>"
	"Return the default number of lines per page"

	^ 24!

destinationDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2ddisk'!

formatDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2frtf'!

requiresDestinationFileString
	" ^	<Boolean>"
	"Return true if I require a filename for my destination"

	^ true! !

!LucidaCrystalExportToRTF methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.
	self myOptionsStructure	
		memberAt: #formatType put: aJob interface UXFRichTextFormatType ;
		memberAt: #destinationType put: aJob interface UXDDiskType.

	self myDestinationStructure: aJob interface UXDDiskOptions gcMalloc.
	self myDestinationStructure 
		memberAt:#structSize put: aJob interface UXDDiskOptionsSize.
	self myOptionsStructure memberAt: #destinationOptions put: self myDestinationStructure.! !

!LucidaCrystalExportToWKS3 class methodsFor: 'constants'!

optionDisplayString
	" ^	<String>"
	"Return a description that would help a user select this option"

	^ 'Export to Lotus 1-2-3 v3 file'! !

!LucidaCrystalExportToWKS3 methodsFor: 'acessing'!

fileString: filename
	"filename		<String>
		^			self "

	self myDestinationStructure memberAt:#fileName put:  filename gcCopyToHeap.! !

!LucidaCrystalExportToWKS3 methodsFor: 'constants'!

destinationDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2ddisk'!

formatDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2fwks'!

requiresDestinationFileString
	" ^	<Boolean>"
	"Return true if I require a filename for my destination"

	^ true! !

!LucidaCrystalExportToWKS3 methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.
	self myOptionsStructure	
		memberAt: #formatType put: aJob interface UXFLotusWk3Type ;
		memberAt: #destinationType put: aJob interface UXDDiskType.

	self myDestinationStructure: aJob interface UXDDiskOptions gcMalloc.
	self myDestinationStructure 
		memberAt:#structSize put: aJob interface UXDDiskOptionsSize.
	self myOptionsStructure memberAt: #destinationOptions put: self myDestinationStructure.! !

!LucidaCrystalExportToXLS5 class methodsFor: 'acessing'!

optionDisplayString
	" ^	<String>"
	"Return a description that would help a user select this option"

	^ 'Export to Excel v5 file'! !

!LucidaCrystalExportToXLS5 methodsFor: 'acessing'!

fileString: filename
	"filename		<String>
		^			self "

	self myDestinationStructure memberAt:#fileName put:  filename gcCopyToHeap.! !

!LucidaCrystalExportToXLS5 methodsFor: 'constants'!

destinationDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2ddisk'!

formatDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ 'u2fxls'!

requiresDestinationFileString
	" ^	<Boolean>"
	"Return true if I require a filename for my destination"

	^ true! !

!LucidaCrystalExportToXLS5 methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.
	self myOptionsStructure	
		memberAt: #formatType put: aJob interface UXFXls5Type ;
		memberAt: #destinationType put: aJob interface UXDDiskType.

	self myDestinationStructure: aJob interface UXDDiskOptions gcMalloc.
	self myDestinationStructure 
		memberAt:#structSize put: aJob interface UXDDiskOptionsSize.
	self myOptionsStructure memberAt: #destinationOptions put: self myDestinationStructure.! !

!LucidaCrystalJob class methodsFor: 'instance creation'!

createWithHandle: aHandle forInterface: anInterface
	" aHandle		<Integer>
	  anInterface	<LucidaCrystalReportsEngineInterface>
		^			<self>"
	"Return an instance of myself with the given handle."

	^ (self new initialize) 
		initializeHandle: aHandle; 
		initializeInterface: anInterface;
		yourself.! !

!LucidaCrystalJob methodsFor: 'accessing'!

cancel
	" ^	self "
	"Cancels this job in progress.  This does not shut down the engine"

	self interface cancelJob: self.!

close
	" ^	self "
	"Close this job.  This does not shut down the engine"

	self interface closeJob: self.!

errorText
	" ^	<String> "
	"Return the text of the last error related to this job."

	^ self myInterface getErrorTextForJob: self!

handle
	" ^ 	<Integer>"
	"Public read accessor for handle"

	^ self myHandle!

interface
	" ^	<LucidaCrystalReportsEngineInterface>"
	"Return my primative interface."

	^ self myInterface!

outputOption
	" ^ 	<LucidaCrystalPrintJobExportOption>"
	"Public read accessor for outputOption"

	^ self myOutputOption!

outputOption: anOption
	" anOption	<LucidaCrystalPrintJobExportOption>
		^		self "
	"Public write accessor for outputOption"

	self myOutputOption: anOption!

serverName: server databaseName: database userId: user password: password
	" server		<String>
	  database	<String>
	  user		<String>
	  password	<String>
		^		self "
	"Set the logon parameteLucida for this job."
	^ self interface
		setLogonParameterForJob: self
		serverName: server 
		databaseName: database 
		userId: user 
		password: password!

status
	" ^	<LucidaCrystalJobInfo> "
	"Return a status object for this job."

	^ self interface statusOfJob: self.! !

!LucidaCrystalJob methodsFor: 'actions'!

execute
	" ^	self "

	self outputOption prepareJob: self.
	self interface startJob: self.! !

!LucidaCrystalJob methodsFor: 'initialize-release'!

initialize
	" ^       self"
	"Initialize my state"

	super initialize.
	self  myHandle: 0.!

initializeHandle: aHandle
	" aHandle	<Integer>
		^       	self"
	"Initialize my state"

	self  myHandle: aHandle.!

initializeInterface: anInterface
	" anInterface	<LucidaCrystalReportsInterface>
		^       		self"
	"Initialize my state"

	self  myInterface: anInterface.! !

!LucidaCrystalJob methodsFor: 'private - accessing'!

myHandle
	" ^ 	<Integer>"
	"PRIVATE  read accessor for handle"

	^ handle!

myHandle: aHandle
	" aHandle	<Integer>
	        ^ 	self"
	"PRIVATE write accessor for handle"

	handle := aHandle!

myInterface
	" ^ 	<LucidaCrystalReportsEngineInterface>"
	"PRIVATE  read accessor for interface"

	^ interface!

myInterface: anInterface
	" anInterface	<LucidaCrystalReportsEngineInterface>
	        ^ 		self"
	"PRIVATE write accessor for interface"

	interface := anInterface!

myOutputOption
	" ^ 	<LucidaCrystalPrintJobExportOption>"
	"PRIVATE  read accessor for outputOption"

	^ outputOption!

myOutputOption: anOutputOption
	" anOutputOption	<LucidaCrystalPrintJobExportOption>
	        ^ 		self"
	"PRIVATE write accessor for outputOption"

	outputOption := anOutputOption! !

!LucidaCrystalJobExportOption class methodsFor: 'instance creation'!

createForJob: aJob
	" aJob			<LucidaCrystalPrintJob>
		^			<self>"

	^ (self new initialize)
		initializeJob: aJob;
		yourself! !

!LucidaCrystalJobExportOption methodsFor: 'accessing'!

optionsStructure
	" ^	<CPointer> to PEExportOptions"

	^ self myOptionsStructure! !

!LucidaCrystalJobExportOption methodsFor: 'actions'!

prepareJob: aJob
	"aJob	<LucidaCrystalJob>
		^	aJob"
	"Prepare the job to be printed using my format"

	^ aJob interface prepareJobForExport: aJob! !

!LucidaCrystalJobExportOption methodsFor: 'constants'!

destinationDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ self subclassResponsibility!

formatDllName
	" ^	<String>"
	"Return the name of the dll required for this export option."

	^ self subclassResponsibility! !

!LucidaCrystalJobExportOption methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	super initializeJob: aJob.	
	self myOptionsStructure: aJob interface __PEExportOptions gcMalloc.
	self myOptionsStructure 
		memberAt:#StructSize put: aJob interface PE_SIZEOF_EXPORT_OPTIONS.
	aJob interface 
		copyString: self formatDllName 
		intoPointer: (self myOptionsStructure refMemberAt: #formatDLLName)
		maximumBytes: 64
		encoding: #default.
	aJob interface 
		copyString: self destinationDllName 
		intoPointer: (self myOptionsStructure refMemberAt: #destinationDLLName)
		maximumBytes: 64
		encoding: #default.! !

!LucidaCrystalJobExportOption methodsFor: 'private - accessing'!

myDestinationStructure
	" ^ 	<CPointer>"
	"PRIVATE  read accessor for destinationStructure"

	^ destinationStructure!

myDestinationStructure: aDestinationStructure
	" aDestinationStructure	<CPointer>
	        ^ 				self"
	"PRIVATE write accessor for destinationStructure"

	destinationStructure := aDestinationStructure!

myFormatStructure
	" ^ 	<CPointer>"
	"PRIVATE  read accessor for formatStructure"

	^ formatStructure!

myFormatStructure: aFormatStructure
	" aFormatStructure	<CPointer>
	        ^ 			self"
	"PRIVATE write accessor for formatStructure"

	formatStructure := aFormatStructure!

myOptionsStructure
	" ^ 	<CPointer>"
	"PRIVATE  read accessor for optionsStructure"

	^ optionsStructure!

myOptionsStructure: anOptionsStructure
	" anOptionsStructure	<CPointer>
	        ^ 			self"
	"PRIVATE write accessor for optionsStructure"

	optionsStructure := anOptionsStructure! !

!LucidaCrystalJobInfo class methodsFor: 'instance creation'!

createWithInfoStructure: aStructure andStatus: status
	" ^	<self>"

	^ (self new initialize)
		initializeInfoStructure: aStructure andStatus: status;
		yourself! !

!LucidaCrystalJobInfo methodsFor: 'accessing'!

firstPage
	" ^	<Integer>"
	"Return the number of page that is the first in the series - usually 1"

	^ self myInfoStructure memberAt: #StartPageN!

inProgress
	" ^	<Boolean>"
	"Return true if the job is still running."

	^ (self myInfoStructure memberAt: #printEnded) == 1!

lastAvailablePage
	" ^	<Integer>"
	"Return the number of page that is the last complete page so far."

	^ self myInfoStructure memberAt: #LatestPageN!

recordsOutput
	" ^	<Integer>"
	"Return the number of records that have been output to the output media."

	^ self myInfoStructure memberAt: #NumRecordsPrinted!

recordsProcessed
	" ^	<Integer>"
	"Return the number of records processed so far."

	^ self myInfoStructure memberAt: #NumRecordsRead!

recordsSelected
	" ^	<Integer>"
	"Return the number of records that have been selected for inclusion in the report."

	^ self myInfoStructure memberAt: #NumRecordsSelected!

statusString
	" ^ 	<String>"
	"Public read accessor for statusString"

	^ self myStatusString! !

!LucidaCrystalJobInfo methodsFor: 'initialize-release'!

initialize
	" ^       self"
	"Initialize my state"

	super initialize.
	self  myStatusString: 'No information available'.!

initializeInfoStructure: aStructure andStatus: status
	" aStructure		<CPointer> to PEJobInfo
	  status			<String>
		^       self"
	"Initialize my state"

	self  myInfoStructure: aStructure.
	self  myStatusString: status.! !

!LucidaCrystalJobInfo methodsFor: 'private - accessing'!

myInfoStructure
	" ^ 	<CPointer>"
	"PRIVATE  read accessor for infoStructure"

	^ infoStructure!

myInfoStructure: anInfoStructure
	" anInfoStructure	<CPointer>
	        ^ 			self"
	"PRIVATE write accessor for infoStructure"

	infoStructure := anInfoStructure!

myStatusString
	" ^ 	<String>"
	"PRIVATE  read accessor for statusString"

	^ statusString!

myStatusString: aStatusString
	" aStatusString	<String>
	        ^ 		self"
	"PRIVATE write accessor for statusString"

	statusString := aStatusString! !

!LucidaCrystalJobOutputOption class methodsFor: 'instance creation'!

createForJob: aJob
	" aJob			<LucidaCrystalPrintJob>
		^			<self>"

	^ (super new initialize)
		initializeJob: aJob;
		yourself! !

!LucidaCrystalJobOutputOption methodsFor: 'actions'!

prepareJob: aJob
	"aJob	<LucidaCrystalPrintJob>
		^	aJob"
	"Prepare the job to be output"

	^ self subclassResponsibility! !

!LucidaCrystalJobOutputOption methodsFor: 'initialize - release'!

initializeJob: aJob
	" aJob		<LucidaCrystalPrintJob>
		^		self "

	aJob outputOption: self.! !


!LucidaCrystalReportsEngineInterface class methodsFor: 'accessing'!

doNotShowDialogs
	" ^ 	<Boolean>"
	" LucidaCrystalReportsEngineInterface doNotShowDialogs"
	"Set the system to disable local progress dialogs"

	^ self myShowDialogs: false!

doNotWaitForJobCompletion
	" ^ 	self"
	"Set the default so that start job requests will NOT wait for completion before returning."

	^ self myWaitForJobCompletion: false!

doShowDialogs
	" ^ 	self"
	" LucidaCrystalReportsEngineInterface showDialogs"
	"Set the system to enable local progress dialogs"

	^ self myShowDialogs: true!

doWaitForJobCompletion
	" ^ 	self"
	"Set the default so that start job requests will wait for completion before returning."

	^ self myWaitForJobCompletion: true!

shouldShowDialogs
	" ^ 	<Boolean>"
	" LucidaCrystalReportsEngineInterface shouldShowDialogs"
	"Public read accessor for ShowDialogs.  If true, the engine will display progress dialogs on the running machine."

	^ self myShowDialogs!

shouldWaitForJobCompletion
	" ^ 	<Boolean>"
	"Return true if start job requests should wait until the job is completed before returning."

	^ self myWaitForJobCompletion! !

!LucidaCrystalReportsEngineInterface class methodsFor: 'examples'!

exampleExportToExcel5

	"LucidaCrystalReportsEngineInterface exampleExportToExcel5"
	| interface job outputOption  |

	interface := self new.
	interface 
		startEngine;
		doWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportToXLS5 createForJob: job.
	outputOption fileString: 'test.xls'.
	job execute.
	job close.
	interface stopEngine.!

exampleExportToHTML

	"LucidaCrystalReportsEngineInterface exampleExportToHTML"
	| interface job outputOption  |

	interface := self new.
	interface 
		startEngine;
		doWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportToHTML createForJob: job.
	outputOption fileString: 'test.html'.
	job execute.
	job close.
	interface stopEngine.!

exampleExportToLotus3

	"LucidaCrystalReportsEngineInterface exampleExportToLotus3"
	| interface job outputOption  |

	interface := self new.
	interface 
		startEngine;
		doWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportToWKS3 createForJob: job.
	outputOption fileString: 'test.wk3'.
	job execute.
	job close.
	interface stopEngine.!

exampleExportToRTF

	"LucidaCrystalReportsEngineInterface exampleExportToRTF"
	| interface job outputOption  |

	interface := self new.
	interface 
		startEngine;
		doWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportToRTF createForJob: job.
	outputOption fileString: 'test.rtf'.
	job execute.
	job close.
	interface stopEngine.!

exampleQueryStatus

	"LucidaCrystalReportsEngineInterface exampleQueryStatus"
	| interface job outputOption status |

	interface := self new.
	interface 
		startEngine;
		doNotWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportToHTML createForJob: job.
	outputOption htmlFileString: 'test.html'.
	job execute.
	status := job status.
	[ job status inProgress] whileTrue.
	job close.
	interface stopEngine.
	^ status!

exampleRequestFromUser

	"LucidaCrystalReportsEngineInterface exampleRequestFromUser"
	| interface job outputOption  |

	interface := self new.
	interface 
		startEngine;
		doWaitForJobCompletion.
	job := interface openJobForReport: '.\report files\test.rpt'.
	outputOption := LucidaCrystalExportRequestOptions createForJob: job.
	job interface showDialogs.	"In case default is not to"
	job execute.
	job close.
	interface stopEngine.! !

!LucidaCrystalReportsEngineInterface class methodsFor: 'initialize-release'!

initialize
	" ^       self"
	"Initialize my state"

	self  myShowDialogs: true.
	self  myWaitForJobCompletion: true.!

installOn: platformArray
	"This method is called when the image is restarted."

	super installOn: platformArray.
	((platformArray at: 1) = #win32) 
		ifTrue: [ 
			"Crystal uses a pragma directive 'pack (1)' which implies single byte alignment on
			 its data structures.  The PP CScanner ignores the pragma.  We must compensate by
			 adjusting the alignment of our data structures"

			| target |
			target := self new.
			target PELogOnInfo typeDo: CStructureLayout dosLayout.	
			target PEExportOptions typeDo: CStructureLayout dosLayout.
			target UXDDiskOptions typeDo: CStructureLayout dosLayout.
			target UXFHTML3Options typeDo: CStructureLayout dosLayout.
			target PEJobInfo typeDo: CStructureLayout dosLayout.

			].! !

!LucidaCrystalReportsEngineInterface class methodsFor: 'instance creation'!

new
	" ^	<self>"

	^ super new initialize! !

!LucidaCrystalReportsEngineInterface class methodsFor: 'private - accessing'!

myShowDialogs
	" ^ 	<Boolean>"
	"PRIVATE  read accessor for ShowDialogs"

	^ ShowDialogs!

myShowDialogs: aShowDialogs
	" aShowDialogs	<Boolean>
	        ^ 		self"
	"PRIVATE write accessor for ShowDialogs"

	ShowDialogs := aShowDialogs!

myWaitForJobCompletion
	" ^ 	<Boolean>"
	"PRIVATE  read accessor for WaitForJobCompletion"

	^ WaitForJobCompletion!

myWaitForJobCompletion: aWaitForJobCompletion
	" aWaitForJobCompletion	<Boolean>
	        ^ 				self"
	"PRIVATE write accessor for WaitForJobCompletion"

	WaitForJobCompletion := aWaitForJobCompletion! !

!LucidaCrystalReportsEngineInterface methodsFor: 'accessing'!

doNotShowDialogs
	"  ^ 		self"
	"Disable progress dialogs."

	self myShowDialogs: false!

doNotWaitForJobCompletion
	" ^ 	self"
	"Override the default for this interface so that it will NOT wait until jobs are complete before returning."

	self myWaitForJobCompletion: false!

doShowDialogs
	" ^ 	<Boolean>"
	"Enable progress dialogs on local machine."

	^ self myShowDialogs: true!

doWaitForJobCompletion
	" ^ 	self"
	"Override the default for this interface so that it will wait until jobs are complete before returning."

	self myWaitForJobCompletion: true!

shouldShowDialogs
	" ^ 	<Boolean>"
	"Public read accessor for showDialogs"

	^ self myShowDialogs!

shouldWaitForJobCompletion
	" ^ 	<Boolean>"
	"Public read accessor for waitForJobCompletion"

	^ self myWaitForJobCompletion! !

!LucidaCrystalReportsEngineInterface methodsFor: 'constants'!

jobClass
	" ^		<Class>"
	"Return the class used to represent print jobs"

	^ LucidaCrystalJob!

jobInfoClass
	" ^		<Class>"
	"Return the class used to represent the status of jobs"

	^ LucidaCrystalJobInfo! !

!LucidaCrystalReportsEngineInterface methodsFor: 'defines'!

PE_JOBCANCELLED
	<C: #define PE_JOBCANCELLED 5
	>!

PE_JOBCOMPLETED
	<C: #define PE_JOBCOMPLETED 3
	>!

PE_JOBFAILED
	<C: #define PE_JOBFAILED 4
	>!

PE_JOBHALTED
	<C: #define PE_JOBHALTED 6
	>!

PE_JOBINPROGRESS
	<C: #define PE_JOBINPROGRESS 2
	>!

PE_JOBNOTSTARTED
	<C: #define PE_JOBNOTSTARTED 1
	>!

PE_SIZEOF_EXPORT_OPTIONS
	<C: #define PE_SIZEOF_EXPORT_OPTIONS (sizeof(PEExportOptions))
	>!

PE_SIZEOF_JOB_INFO
	<C: #define PE_SIZEOF_JOB_INFO (sizeof(PEJobInfo))
	>!

PE_SIZEOF_LOGON_INFO
	<C: #define PE_SIZEOF_LOGON_INFO (sizeof(PELogOnInfo))
	>!

UXDDiskOptionsSize
	<C: #define UXDDiskOptionsSize (sizeof(UXDDiskOptions))
	>!

UXDDiskType
	<C: #define UXDDiskType 0
	>!

UXFHTML3OptionsSize
	<C: #define UXFHTML3OptionsSize (sizeof(UXFHTML3Options))
	>!

UXFHTML3Type
	<C: #define UXFHTML3Type 0
	>!

UXFLotusWk1Type
	<C: #define UXFLotusWk1Type 1
	>!

UXFLotusWk3Type
	<C: #define UXFLotusWk3Type 2
	>!

UXFLotusWksType
	<C: #define UXFLotusWksType 0
	>!

UXFRichTextFormatType
	<C: #define UXFRichTextFormatType 0
	>!

UXFXls2Type
	<C: #define UXFXls2Type 0
	>!

UXFXls3Type
	<C: #define UXFXls3Type 1
	>!

UXFXls4Type
	<C: #define UXFXls4Type 2
	>!

UXFXls5Type
	<C: #define UXFXls5Type 3
	>!

__LINE__
	<C: #define __LINE__ 0
	>!

__STDC__
	<C: #define __STDC__ 1
	>! !

!LucidaCrystalReportsEngineInterface methodsFor: 'engine initialize - release'!

canStopEngine
	" ^		<Boolean> "
	"Return false if there are currently active print jobs"

	
	^ self PECanCloseEngine == 1!

startEngine
	" ^		<Boolean>"
	"Initialize the system"

	| result |
	result := self PEOpenEngine.
	^ result == 1
		ifTrue: [ true ]
		ifFalse: [
			self error: 'The Crystal Reports engine failed to initialize'.
			false
			]!

stopEngine
	" ^		self "
	"Stop the system"

	self canStopEngine
		ifFalse: [ ^ self error: 'Cannot stop engine due to active jobs' ].
	self PECloseEngine.! !

!LucidaCrystalReportsEngineInterface methodsFor: 'error handling'!

getErrorText
	" 	^		<String>"
	"Return the last error text."
	
	^ self privateGetErrorTextForJobHandle: 0.!

getErrorTextForJob: aJob
	" aJob		<LucidaCrystalJob>
		^		<String>"
	"Return the last error text for the given job"
	
	^ self privateGetErrorTextForJobHandle: aJob handle.! !

!LucidaCrystalReportsEngineInterface methodsFor: 'initialize-release'!

initialize
	" ^       self"
	"Initialize my state"

	super initialize.
	self  myShowDialogs: self class shouldShowDialogs.
	self  myWaitForJobCompletion: self class shouldWaitForJobCompletion.! !

!LucidaCrystalReportsEngineInterface methodsFor: 'job preparation'!

cancelJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob"
	"Cancels the given job in progress."

	self PECancelPrintJob: aJob handle.
	^ aJob!

closeJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob"
	"Closes the given job."

	self PEClosePrintJob: aJob handle.
	^ aJob!

discardSavedDataForJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob"
	"If data has been saved with this report, disacard it so that it is forced to retrieve fresh data from the source."
	| result |
	result := self PEDiscardSavedData: aJob handle.
	result == 0
		ifTrue: [
 			self error: (self getErrorTextForJob: aJob).
			].
	^ aJob!

openJobForReport: reportFilePath
	" ^		<LucidaCrystalJob>"
	"Open a new job."

	^ self jobClass createWithHandle: (self PEOpenPrintJob: reportFilePath) forInterface: self!

prepareJobForExport: aJob
	"aJob		<LucidaCrystalJob>
	 anOption	<LucidaCrystalJobOutputOption>
		^		aJob"
	| result |
	result := self PEExportTo: aJob handle with: aJob outputOption optionsStructure.
	result == 0
		ifTrue: [
			self error: (self getErrorTextForJob: aJob).
			].
	^ aJob!

requestExportOptionsForJob: aJob
	" aJob		<LucidaCrystalExportRequestOptions>
		^		aJob "
	"This will open a local dialog interface to request user input."

	| result |
	aJob interface shouldShowDialogs
		ifFalse: [
			^ self error: 'The Crystal Reports Engine Interface is not set to allow local dialog windows'.
			].
	result := aJob interface PEGetExportOptions: aJob handle with: aJob outputOption optionsStructure.
	result ==0
		ifTrue: [
			self error: (self getErrorTextForJob: aJob).
			].
	^ aJob!

setLogonParameterForJob: aJob serverName: server databaseName: database userId: user password: password
	" aJob		<LucidaCrystalJob>
	  server		<String>
	  database	<String>
	  user		<String>
	  password	<String>
		^		aJob "

	| result infoStructure |
	[
		infoStructure := self PELogOnInfo malloc.
		infoStructure 
			memberAt:#StructSize
			put: self PE_SIZEOF_LOGON_INFO.
		self 
			copyString: server 
			intoPointer: (infoStructure refMemberAt: #ServerName)
			maximumBytes: 128
			encoding: #default.
		self 
			copyString: database 
			intoPointer: (infoStructure refMemberAt: #DatabaseName)
			maximumBytes: 128
			encoding: #default.
		self 
			copyString: user 
			intoPointer: (infoStructure refMemberAt: #UserID)
			maximumBytes: 128
			encoding: #default.
		self 
			copyString: password 
			intoPointer: (infoStructure refMemberAt: #Password)
			maximumBytes: 128
			encoding: #default.

		result := self 
			PESetNthTableLogOnInfo: aJob handle
			with: 0 
			with: infoStructure 
			with: 1.
	] valueNowOrOnUnwindDo: [
		infoStructure free.
		].
	result == 0
		ifTrue: [
			self error: (self getErrorTextForJob: aJob).
			].
	^ aJob!

startJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob "

	| result |
	result := self 
		PEEnableProgressDialog: aJob handle 
		with: (self shouldShowDialogs ifTrue: [1] ifFalse: [0]).		
	result = 1
		ifTrue: [
			result := self PEStartPrintJob: aJob handle with: (self shouldWaitForJobCompletion ifTrue: [1] ifFalse: [0]).
			].
	result == 1
		ifFalse: [
			^ self error: (self getErrorTextForJob: aJob).
			].
	^ aJob!

statusOfJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob"
	"Return a string that indicates the status of the given job."
	| result buffer statusString |
	buffer := self PEJobInfo gcMalloc.  "Needs gcMalloc because the job will continue to reference it"
	result := self PEGetJobStatus: aJob handle with: buffer.
	statusString :=
		result == -1
			ifTrue: [ self getErrorText.  "Engine or job not started sucessfully"]
			ifFalse: [
				result == self PE_JOBNOTSTARTED
					ifTrue: [ 'Job not started' ]
					ifFalse: [
						result == self PE_JOBINPROGRESS
							ifTrue: [ 'Job is in progress ...' ]
							ifFalse: [
								result == self PE_JOBCOMPLETED
									ifTrue: [ 'Job completed' ]
									ifFalse: [
										result == self PE_JOBFAILED
											ifTrue: [ 'Job failed' ]
											ifFalse: [
												result == self PE_JOBCANCELLED
												ifTrue: [ 'Job cancelled' ]
												ifFalse: [
													result == self PE_JOBHALTED
														ifTrue: [ 'Job halted' ]
														ifFalse: [ 'Status unknown' 
															]]]]]]].
			
	^ self jobInfoClass createWithInfoStructure: buffer andStatus: statusString! !

!LucidaCrystalReportsEngineInterface methodsFor: 'output to printer'!

printReport: reportPath
	" reportPath		<String>
		^				self "

	| result |
	result := self
		PEPrintReport: reportPath 
		with: 1			"toDefaultPrinter" 
		with: 0			"toWindow" 
		with: ''			"title" 
		with: 0			"left" 
		with: 0			"top" 
		with: 0			"width" 
		with: 0			"height" 
		with: 0			"style" 
		with: 0.			"parentWindow"

	result == 0
		ifFalse: [
			self error: self getErrorText
			].! !

!LucidaCrystalReportsEngineInterface methodsFor: 'output to window'!

closeDisplayWindowForJob: aJob
	" aJob	<LucidaCrystalJob>
		^	aJob"
	"Closes the display window for the given job."

	self PECloseWindow:  aJob handle.
	^ aJob!

viewReport: reportPath
	" reportPath		<String>
		^				self "

	| result |
	result := self
		PEPrintReport: reportPath 
		with: 0								"toDefaultPrinter" 
		with: 1								"toWindow" 
		with: 'Report - ', reportPath			"title" 
		with: 10								"left" 
		with: 10								"top" 
		with: 800							"width" 
		with: 500							"height" 
		with: 0								"style" 
		with: 0.								"parentWindow"

	result == 0
		ifFalse: [
			self error: self getErrorText
			].! !

!LucidaCrystalReportsEngineInterface methodsFor: 'private'!

copyString: sourceString intoPointer: aPointer maximumBytes: maxBytes encoding: encoding
	" sourceString			<CharacterArray>
	  aPointer			<CPointer>
	  maxBytes			<Integer>   (includes null terminator)
		^			aPointer"

	| size bytes null |
	bytes := sourceString asByteArrayEncoding: encoding.
	null := (ByteString new: 1) asByteArrayEncoding: encoding.
	size := bytes size min: (maxBytes - null size).
	aPointer
		copyAt: 0
		from: bytes
		size: size
		startingAt: 1.
	aPointer
		copyAt: size
		from: null
		size: null size
		startingAt: 1.
	^aPointer!

privateGetErrorTextForJobHandle: aHandle
	" aHandle	<Integer>
		^		<String>"
	"Return the last error text for the given job id, 0 for no job"
	
	| code pTextHandle pBuffer pBufferLength result resultSize resultString |
	code := self PEGetErrorCode: aHandle.
	code = 536
		ifTrue: [^ 'Logon parameters are incorrect.'  ].				
	[
		pTextHandle := CIntegerType unsignedLong malloc.
		pBufferLength := CIntegerType int malloc.
		self PEGetErrorText: aHandle with: pTextHandle with: pBufferLength.
		resultSize := pBufferLength contents.
		pBuffer := (String new: resultSize) copyToHeap.
		result := self PEGetHandleString: pTextHandle contents with: pBuffer with: pBufferLength contents.
		result == 0
			ifTrue: [ ^ 'Error could not be successfully queried from Report Engine' ].
		resultString := (String new: resultSize -1).
		pBuffer copyAt: 0 to: resultString size: resultSize - 1 startingAt: 1.
		] valueNowOrOnUnwindDo: [
			pTextHandle free.
			pBufferLength free.
			pBuffer free.
			].
	^ resultString, ' (code ', code printString, ')'.! !

!LucidaCrystalReportsEngineInterface methodsFor: 'private - accessing'!

myShowDialogs
	" ^ 	<Boolean>"
	"PRIVATE  read accessor for showDialogs"

	^ showDialogs!

myShowDialogs: aShowDialogs
	" aShowDialogs	<Boolean>
	        ^ 		self"
	"PRIVATE write accessor for showDialogs"

	showDialogs := aShowDialogs!

myWaitForJobCompletion
	" ^ 	<Boolean>"
	"PRIVATE  read accessor for waitForJobCompletion"

	^ waitForJobCompletion!

myWaitForJobCompletion: aWaitForJobCompletion
	" aWaitForJobCompletion	<Boolean>
	        ^ 				self"
	"PRIVATE write accessor for waitForJobCompletion"

	waitForJobCompletion := aWaitForJobCompletion! !

!LucidaCrystalReportsEngineInterface methodsFor: 'procedures'!

PECancelPrintJob: printJob
	<C: void PECancelPrintJob(short printJob)>
	^self externalAccessFailed!

PECanCloseEngine
	<C: unsigned char PECanCloseEngine(void)>
	^self externalAccessFailed!

PECloseEngine
	<C: void PECloseEngine(void)>
	^self externalAccessFailed!

PEClosePrintJob: printJob
	<C: char PEClosePrintJob(short printJob)>
	^self externalAccessFailed!

PECloseWindow: printJob
	<C: void PECloseWindow(short printJob)>
	^self externalAccessFailed!

PEDiscardSavedData: printJob
	<C: unsigned char PEDiscardSavedData(short printJob)>
	^self externalAccessFailed!

PEEnableProgressDialog: printJob with: enable
	<C: unsigned char PEEnableProgressDialog(short printJob, unsigned char enable)>
	^self externalAccessFailed!

PEExportTo: printJob with: options
	<C: char PEExportTo(short printJob, PEExportOptions _far * options)>
	^self externalAccessFailed!

PEGetErrorCode: printJob
	<C: short PEGetErrorCode(short printJob)>
	^self externalAccessFailed!

PEGetErrorText: printJob with: textHandle with: textLength
	<C: char PEGetErrorText(short printJob, unsigned long _far * textHandle, short _far * textLength)>
	^self externalAccessFailed!

PEGetExportOptions: printJob with: options
	<C: char PEGetExportOptions(short printJob, PEExportOptions _far * options)>
	^self externalAccessFailed!

PEGetHandleString: textHandle with: buffer with: bufferLength
	<C: char PEGetHandleString(unsigned long textHandle, char _far * buffer, short bufferLength)>
	^self externalAccessFailed!

PEGetJobStatus: printJob with: jobInfo
	<C: short PEGetJobStatus(short printJob, PEJobInfo _far * jobInfo)>
	^self externalAccessFailed!

PEOpenEngine
	<C: char PEOpenEngine(void)>
	^self externalAccessFailed!

PEOpenPrintJob: reportFilePath
	<C: short PEOpenPrintJob(char _far * reportFilePath)>
	^self externalAccessFailed!

PEPrintReport: reportFilePath with: toDefaultPrinter with: toWindow with: title with: left with: top with: width with: height with: style with: parentWindow
	<C: short PEPrintReport(char _far * reportFilePath, char toDefaultPrinter, char toWindow, char _far * title, int left, int top, int width, int height, unsigned long style, unsigned long parentWindow)>
	^self externalAccessFailed!

PESetNthTableLogOnInfo: printJob with: tableN with: logOnInfo with: propagateAcrossTables
	<C: unsigned char PESetNthTableLogOnInfo(short printJob, short tableN, PELogOnInfo _far * logOnInfo, unsigned char propagateAcrossTables)>
	^self externalAccessFailed!

PEStartPrintJob: printJob with: waitUntilDone
	<C: char PEStartPrintJob(short printJob, char waitUntilDone)>
	^self externalAccessFailed! !

!LucidaCrystalReportsEngineInterface methodsFor: 'structs'!

__PEExportOptions
	<C: struct __PEExportOptions {
			unsigned short StructSize;
			char formatDLLName[64];
			unsigned long formatType;
			void _far * formatOptions;
			char destinationDLLName[64];
			unsigned long destinationType;
			void _far * destinationOptions;
			unsigned short nFormatOptionsBytes, nDestinationOptionsBytes;
		}>!

__PEJobInfo
	<C: struct __PEJobInfo {
			unsigned short StructSize;
			unsigned long NumRecordsRead, NumRecordsSelected, NumRecordsPrinted;
			unsigned short DisplayPageN, LatestPageN, StartPageN;
			unsigned char printEnded;
		}>!

__PELogOnInfo
	<C: struct __PELogOnInfo {
			unsigned short StructSize;
			char ServerName[128];
			char DatabaseName[128];
			char UserID[128];
			char Password[128];
		}>!

__UXDDiskOptions
	<C: struct __UXDDiskOptions {
			unsigned short structSize;
			char _far * fileName;
		}>!

__UXFHTML3Options
	<C: struct __UXFHTML3Options {
			unsigned short structSize;
			char _far * fileName;
		}>! !

!LucidaCrystalReportsEngineInterface methodsFor: 'types'!

PEExportOptions
	<C: typedef struct __PEExportOptions PEExportOptions>!

PEJobInfo
	<C: typedef struct __PEJobInfo PEJobInfo>!

PELogOnInfo
	<C: typedef struct __PELogOnInfo PELogOnInfo>!

UXDDiskOptions
	<C: typedef struct __UXDDiskOptions UXDDiskOptions>!

UXFHTML3Options
	<C: typedef struct __UXFHTML3Options UXFHTML3Options>! !

LucidaCrystalReportsEngineInterface initialize!
