"==============================================
This is AAF installation script. File it in. See install_how_to.txt.
The script expects files to be placed as described there.
=============================================="
| fakeCategoryName path |

path := Dialog
	requestFileName: 'Enter AAF installation path\(i.e. /usr/local/vw31/image)' withCRs
	default: (Filename defaultDirectory) asString.
path isEmpty ifTrue: [^self].

"Declare global variables for purposes of examples and debugging."
	#(A B C D E F) do: [:each | Smalltalk at: each put: nil].

(Parcel parcelNames includes: 'RefactoringBrowser')
ifFalse:[
	(Dialog confirm: 'Refactoring Browser not found in your image. Parcel it in (download it from st-www.cs.uiuc.edu),\and file in install.st again.\\Continue anyway?' withCRs)
	ifFalse:[Dialog warn: 'AAF installation aborted.'. ^self]
].


[
	(Parcel parcelNames includes:'Goodies-Auto Loader')
	ifFalse: [Parcel loadParcelFrom:
		(Filename fromComponents: (Array with: path with: 'aaf-parcels' with: 'Goodies-AutoLoader.pcl'))
	]
]
	on:Error
	do: [:e | (Dialog confirm: 'AAF installation error - Goodies-AutoLoader.pcl not found. \\Continue anyway?' withCRs) ifFalse:[Dialog warn: 'AAF installation aborted.'. ^self].
		e return].

#(
	'BOSS'
	'SysDeps'
	'WorkspaceOrganizer'
	'TabControl'
	'UIMenuEditor'
	'Programming Hacks'
	'UIPainter'
	'EditKeys'
	'ColorEditing'
	'BrowserChangeSetEditing'
"	 'AT Support'
	 'AT Tools' "
) do: [:each | Parcel ensureLoadedParcel: each withVersion: ''].


#(

"standard parcels"

	'CELanguagesSupport.pcl'
	'CodeAdditions-Is.pcl'
	'CodeAdditions-InstanceInitialization.pcl'
	'CodeAdditions-UniqueIDGenerator.pcl'
	'CodeAdditions.pcl'
	'CodeAdditions-IfNilOrEmpty.pcl'
	'CodeAdditions-CollectionDeepCopy.pcl'

	'CodeAdditions-BetterHalting.pcl'
	'CodeAdditions-Stripping.pcl'
	'CodeAdditions-UpdateRequests.pcl'
	'CodeAdditions-CollectionConcatenating.pcl'
	'CodeAdditions-Watching.pcl'
	'CodeAdditions-AsClass.pcl'
	'CodeAdditions-ValuePolymorphism.pcl'
	'CodeAdditions-NiceReleasingModel.pcl'
	'NonAAFCommonGUIs.pcl'

	'Goodies-AutoWindowIcon.pcl'
	'Goodies-SourceFileHistory.pcl'
	'Goodies-MethodPreviousVersion.pcl'
	'Goodies-InheritedVariables.pcl'
	'Goodies-KeyboadMapping.pcl'
	'ListDialogs.pcl'
	'Goodies-BrowserHistory.pcl'
	'Goodies-PerformanceFeelPolicy.pcl'
	'Goodies-EnvironmentEnhancements.pcl'
	'ObjectMemoryNotifier.pcl'
	'Timers.pcl'
	'ApplicationSaver.pcl'
	'PopupApplicationFramework.pcl'
	'Goodies-PopupNotepad.pcl'
	'Goodies-PopupWorkspace.pcl'
	'Goodies-PopupBrowsers.pcl'
	'Goodies-Exiter.pcl'
	'Goodies-CommandTool.pcl'
	'EmergencyActions.pcl'
	'Goodies-AggressiveCodeSaver.pcl'
	'Goodies-ModifiedRefactoringBrowserFormatting.pcl'

	'OrderedSet.pcl'
	'DebugUtilities.pcl'
	'DecisionTable.pcl'
	'DeferredActions.pcl'
	'CodeAdditions-BehaviorEvaluating.pcl'

	'Indirections.pcl'
	'CodeAdditions-LittleUtilities.pcl'

	'ObjectPrinter.pcl'
	'ObjectComparer.pcl'
	'CodeAdditions-ValueModelDeepCopying.pcl'


	'AAF-Prerequisites.pcl'
	'AAF-Adaptors.pcl'
	'AdvancedSelectionInList.pcl'
	'AAF.pcl'

	'ExtensiblePrintConverter.pcl' "is used by HBName and HBAddress"

	'VisualEditing.pcl' "uses HBName and HBAddress in examples"
	'Goodies-ClassCommenter.pcl'

	'AAF-CommonGUIs.pcl'
	'AAF-Rules.pcl'
	'AAF-Rules-Visualization.pcl'
	'AAF-VisualToolsSupport.pcl'


	'Goodies-PropertiesAccessGenerator.pcl'

) do: [:each |
	Transcript crtab; show: each.
		[
			Parcel loadParcelFrom: (Filename fromComponents: (Array with: path with: 'aaf-parcels' with: each))]
				on:Error
				do: [:e | (Dialog confirm: 'File ', each, ' not found. Continue anyway?' withCRs) ifFalse:[Dialog warn: 'AAF installation is NOT complete.'. ^self].
				e return
		]
].


#(
	'DayMonthDate.pcl' "is used by HBCalendar"
	'HBName.pcl'
	'HBAddress.pcl'
	'AAF-ExampleApplications.pcl'
) do: [:each |
	Transcript crtab; show: each.
		[
		Parcel loadParcelFrom:(Filename fromComponents: ((Array new: 4)
			at: 1 put: path;
			at: 2 put: 'aaf-parcels';
			at: 3 put: 'examples';
			at: 4 put: each;
			yourself))
		]
		on:Error
		do: [:e | (Dialog confirm: 'File ', each, ' (AAF usage example) not found. Continue anyway?' withCRs) ifFalse:[Dialog warn: 'AAF examples not installed.'. ^self].
		  e return
		]
].



"order class categories "
fakeCategoryName := #'h5c-6hk7-rd8-tn'.
Smalltalk organization addCategory: fakeCategoryName.

#(
#'ICC-TabControl'
#'ICC-TabControlDemo'
#'--------------------'
#'Tools-Support'
#'Application Saver'
#'List Dialogs'
#'Little Utilities'
#'UIFeels-Performance'
#'Goodies-Support and small goodies'
#'Goodies-Browser History'
#'Goodies-Popup Applications'
#'Goodies-Exiter'
#'Goodies-CommandTool'

#EAF
#'EAF-Domain Adaptor Examples'
#'EAF-Extended Application Model Examples'
#'Debug Utilities'
#'Decision Table'
#'Deferred Actions'
#'Indirection-Utils'
#'Indirection-Base'
#'Class Commenter'
#'Visual Editing'
#'UIApplications-New'
#'Non AAF Common GUIs'
#'AAF Common GUIs'
#'AAF-Selection In List'
#'----------------------'
#'AAF-Domain Models'
#'AAF-Application Models'
#'AAF-Adaptors'
#'AAF-Visual-Processing'
#'AAF-Visual-Updates'
#'AAF-Support'
#'AAF-Builders'
#'AAF-On Screen Location'
#'AAF-Prerequisites'
#'-----------------------'
#'AR-Rule Support'
#'AR-Rule Support UI'
#'AR-Support'
#'AR-Update Info'
#'AR-Log Entries'
#'AR-Adaptors'
#'------------------------'
#'Common for AM & DM'
#'DM Definer'
#'DM Definer-Specs'
#'DM Definer-Specs-Conformity'
#'DM Definer-Specs-Aspects'
#'DM Definer-Specs-Aspect'
#'DM Definer-Specs-Aspects-Refactoring'
#'DM Definer-Specs-Recomputers'
#'-------------------------'
#'AM Definer'
#'AM Definer-Specs'
#'--------------------------'
#'New Applications'
#'Example Applications'

) do: [:c | Smalltalk organization addCategory: c before: fakeCategoryName].
Smalltalk organization removeCategory: fakeCategoryName.


"Make the 'Default' change set really the default one"
NamedChangeSet newChanges: (NamedChangeSet lookup: #Default).

"Clear all changes"
NamedChangeSet noChanges.

"Load Motd - must be loaded as the last parcel that displayes a window, because if any window ir open after loading Motd, the Motd window closes automatically"

(Smalltalk at: #AutoLoaderOther) default release.
(Smalltalk at: #AAFSoundDomainModel) allSubclassesDo: [:class | class initializeApplicableRuleGuardClasses].

"Parcels that you may load on request:
 	'ExtendedApplicationFramework.pcl'
	'ExtendedApplicationFramework-Examples.pcl'

"

"load MOTD (must be the last statement)"
Parcel loadParcelFrom: (Filename fromComponents: (Array with: path with:'aaf-parcels' with: 'Goodies-Motd.pcl')).
