'From VisualWorks, Release 3.0 of February 5, 1998 on October 16, 1998 at 5:34:46 pm'!


Object subclass: #LintRule
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!

LintRule comment:
'LintRule is an abstract class that represents some check on the code.

Subclasses must implement the following messages:
	accessing
		problemCount
			"returns the number of problems this rule found"
	private
		viewResults
			"opens an interface to view the problems"
	testing
		isEmpty
			"did this rule find any problems"

Instance Variables:
	name	<String>	the display name of the rule'!


!LintRule methodsFor: 'initialize-release'!

initialize!

resetResult! !

!LintRule methodsFor: 'accessing'!

checkClass: aSmalllintContext!

checkMethod: aSmalllintContext!

name
	^name!

name: aString 
	name := aString!

openEditor
	| rules |
	rules := self failedRules.
	rules isEmpty ifTrue: [^self].
	rules size == 1 ifTrue: [^rules first viewResults].
	SmalllintResultEditor openOn: self label: name!

problemCount
	^self subclassResponsibility!

run
	^Smalllint runRule: self!

runOnEnvironment: anEnvironment 
	^Smalllint runRule: self onEnvironment: anEnvironment! !

!LintRule methodsFor: 'printing'!

displayName
	| nameStream |
	nameStream := WriteStream on: (String new: 64).
	nameStream nextPutAll: self name;
		nextPutAll: ' ['.
	self problemCount printOn: nameStream.
	nameStream nextPut: $].
	^nameStream contents!

printOn: aStream 
	name isNil
		ifTrue: [super printOn: aStream]
		ifFalse: [aStream nextPutAll: name]! !

!LintRule methodsFor: 'testing'!

hasConflicts
	^false!

isComposite
	^false!

isEmpty
	self subclassResponsibility! !

!LintRule methodsFor: 'private'!

failedRules
	^self isEmpty
		ifTrue: [#()]
		ifFalse: [Array with: self]!

viewResults
	self subclassResponsibility! !

LintRule class
	instanceVariableNames: ''!



!LintRule class methodsFor: 'instance creation'!

new
	^super new initialize! !


!BrowserCodeTool methodsFor: 'refactorings'!

rewriteCode
	RewriteRuleEditor rewrite: self selectedText! !

ClassSelectorNavigator subclass: #MultiNavigator
	instanceVariableNames: 'environmentList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

MultiNavigator comment:
'MultiNavigator is the special environment for MultiEnvironment. It''s basically a hack for the "Method defined in all subclasses, but not in superclass" lint rule.

Instance Variables:
	environmentList	<SelectionInList on: String>	the different environments we can browse'!


!MultiNavigator methodsFor: 'initialize-release'!

initialize
	super initialize.
	self environmentList selectionIndexHolder onChangeSend: #changedEnvironment to: self! !

!MultiNavigator methodsFor: 'aspects'!

environmentList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^environmentList isNil
		ifTrue:
			[environmentList := SelectionInList new]
		ifFalse:
			[environmentList]! !

!MultiNavigator methodsFor: 'changing'!

changedEnvironment
	self protocolHolder value: nil.
	self environment selectEnvironment: self environmentList selection.
	self setState: NavigatorState new updateClasses: true.
	self changed: #category with: self category! !

!MultiNavigator methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	self environmentList list: (self environment environments asList sortWith: [:a :b | a displayString < b displayString]; yourself).
	super postBuildWith: aBuilder! !

!MultiNavigator methodsFor: 'accessing-browser'!

spec: verticalBoolean 
	| spec |
	spec := verticalBoolean
				ifTrue: [self class verticalWindowSpec]
				ifFalse: [self class windowSpec].
	self categoryList list: Smalltalk organization categories asList.
	^spec! !

MultiNavigator class
	instanceVariableNames: ''!



!MultiNavigator class methodsFor: 'interface specs'!

verticalWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 357 443 572 852 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 -1 0.333333 ) 
					#name: #environmentList 
					#flags: 15 
					#model: #environmentList ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.333333 -2 1 26 0.333333 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 28 0.333333 -2 1 -25 0.666666 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -22 0.666666 0 0.5 -3 0.666666 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -22 0.666666 -22 1 -3 0.666666 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.666666 -2 1 26 0.666666 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 28 0.666666 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 0.666666 -2 1 -1 0.666666 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 -23 0.666666 -2 1 -3 0.666666 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 314 332 902 483 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.333333 -2 1 ) 
					#name: #environmentList 
					#flags: 15 
					#model: #environmentList ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 1 0.333333 2 0 -1 0.666666 27 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 1 0.333333 29 0 -1 0.666666 -25 1 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0.333333 -22 1 0 0.5 -3 1 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -22 1 -22 0.666666 -3 1 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 1 0.666666 2 0 -2 1 27 0 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 1 0.666666 29 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0.333333 -23 1 -1 0.666666 -2 1 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 0.666666 -23 1 -2 0.666666 -3 1 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )! !

LintRule subclass: #TransformationRule
	instanceVariableNames: 'rewriteRule builder class '
	classVariableNames: 'RecursiveSelfRule '
	poolDictionaries: ''
	category: 'Refactory-Lint'!

TransformationRule comment:
'TransformationRule is a LintRule that transforms code using rewrite rules.

Instance Variables:
	builder	<RefactoryBuilder>	the changes we''ve made
	class	<Behavior>	the class we''re looking at currently (only needed so we don''t have to pass the class around)
	rewriteRule	<ParseTreeRewriter>	the rule we''re replacing the code with

Class Variables:
	RecursiveSelfRule	<ParseTreeSearcher>	a rule that checks our rewrites so we don''t make directly recursive methods (e.g., "foo ^self foo")

'!


!TransformationRule methodsFor: 'initialize-release'!

rewriteUsing: searchReplacer 
	rewriteRule := searchReplacer.
	self resetResult! !

!TransformationRule methodsFor: 'accessing'!

checkMethod: aSmalllintContext 
	class := aSmalllintContext selectedClass.
	(rewriteRule executeTree: aSmalllintContext parseTree)
		ifTrue: [(self class recursiveSelfRule executeTree: rewriteRule tree initialAnswer: false)
				ifFalse: [builder
						compile: rewriteRule tree printString
						in: class
						classified: aSmalllintContext protocol]]!

problemCount
	^builder problemCount!

resetResult
	builder := RefactoryBuilder named: 'Some transformations'! !

!TransformationRule methodsFor: 'testing'!

hasConflicts
	^true!

isEmpty
	^builder changes isEmpty! !

!TransformationRule methodsFor: 'rules'!

superSends
	| rule |
	rule := ParseTreeRewriter new.
	rule 
		replace: 'super `@message: ``@args'
		with: 'self `@message: ``@args'
		when: 
			[:aNode | 
			(class withAllSubclasses 
				detect: [:each | each includesSelector: aNode selector]
				ifNone: [nil]) isNil].
	self rewriteUsing: rule! !

!TransformationRule methodsFor: 'private'!

viewResults
	"I reset the result so that we don't fill up memory with methods to compile in the builder."

	builder inspect.
	self resetResult! !

TransformationRule class
	instanceVariableNames: ''!



!TransformationRule class methodsFor: 'accessing'!

initializeRecursiveSelfRule
	RecursiveSelfRule := ParseTreeSearcher new.
	RecursiveSelfRule 
		matchesAnyMethodOf: 
			#('`@methodName: `@args | `@temps | self `@methodName: `@args1' 
			'`@methodName: `@args | `@temps | ^self `@methodName: `@args1')
		do: [:aNode :answer | true].
	^RecursiveSelfRule!

recursiveSelfRule
	^RecursiveSelfRule isNil 
		ifTrue: [self initializeRecursiveSelfRule]
		ifFalse: [RecursiveSelfRule]! !

!TransformationRule class methodsFor: 'instance creation'!

rewrite: stringArrays methods: aBoolean name: aName 
	| rewriteRule |
	rewriteRule := ParseTreeRewriter new.
	stringArrays do: 
			[:each | 
			aBoolean 
				ifTrue: [rewriteRule replaceMethod: each first with: each last]
				ifFalse: [rewriteRule replace: each first with: each last]].
	^(self new)
		name: aName;
		rewriteUsing: rewriteRule;
		yourself! !

!TransformationRule class methodsFor: 'transformations'!

assignmentInIfTrue
	^self rewrite: #(
			#('``@Boolean ifTrue: [`variable := ``@true] ifFalse: [`variable := ``@false]'
			"->"
			'`variable := ``@Boolean ifTrue: [``@true] ifFalse: [``@false]')
			#('``@Boolean ifFalse: [`variable := ``@true] ifTrue: [`variable := ``@false]'
			"->"
			'`variable := ``@Boolean ifFalse: [``@true] ifTrue: [``@false]'))
		methods: false
		name: 'Move variable assignment outside of single statement ifTrue:ifFalse: blocks'!

atIfAbsent
	^self rewrite: #(
			#('``@dictionary at: ``@key 
					ifAbsent: [| `@temps | 
							``@.Statements1.
							``@dictionary at: ``@key put: ``@object.
							``@.Statements2.
							``@object]'
			"->"
			'``@dictionary at: ``@key
					ifAbsentPut: [| `@temps |
							``@.Statements1.
							``@.Statements2.
							``@object]')
			#('``@dictionary at: ``@key
					ifAbsent: [| `@temps |
							``@.Statements.
							``@dictionary at: ``@key put: ``@object]'
			"->"
			'``@dictionary at: ``@key
					ifAbsentPut: [| `@temps |
							``@.Statements.
							``@object]'))
		methods: false
		name: 'at:ifAbsent: -> at:ifAbsentPut:'!

betweenAnd
	^self rewrite: #(
			#('``@a >= ``@b and: [``@a <= ``@c]' "->" '``@a between: ``@b and: ``@c')
			#('``@a >= ``@b & (``@a <= ``@c)' "->" '``@a between: ``@b and: ``@c')
			#('``@b <= ``@a and: [``@a <= ``@c]' "->" '``@a between: ``@b and: ``@c')
			#('``@b <= ``@a & (``@a <= ``@c)' "->" '``@a between: ``@b and: ``@c')
			#('``@a <= ``@c and: [``@a >= ``@b]' "->" '``@a between: ``@b and: ``@c')
			#('``@a <= ``@c & (``@a >= ``@b)' "->" '``@a between: ``@b and: ``@c')
			#('``@c >= ``@a and: [``@a >= ``@b]' "->" '``@a between: ``@b and: ``@c')
			#('``@c >= ``@a & (``@a >= ``@b)' "->" '``@a between: ``@b and: ``@c')
			#('``@a >= ``@b and: [``@c >= ``@a]' "->" '``@a between: ``@b and: ``@c')
			#('``@a >= ``@b & (``@c >= ``@a)' "->" '``@a between: ``@b and: ``@c')
			#('``@b <= ``@a and: [``@c >= ``@a]' "->" '``@a between: ``@b and: ``@c')
			#('``@b <= ``@a & (``@c >= ``@a)' "->" '``@a between: ``@b and: ``@c')
			#('``@a <= ``@c and: [``@b <= ``@a]' "->" '``@a between: ``@b and: ``@c')
			#('``@a <= ``@c & (``@b <= ``@a)' "->" '``@a between: ``@b and: ``@c')
			#('``@c >= ``@a and: [``@b <= ``@a]' "->" '``@a between: ``@b and: ``@c')
			#('``@c >= ``@a & (``@b <= ``@a)' "->" '``@a between: ``@b and: ``@c'))
		methods: false
		name: '"a >= b and: [a <= c]" -> "a between: b and: c"'!

cascadedNextPutAlls
	^self
		rewrite: #(
			#('``@rcvr nextPutAll: ``@object1 , ``@object2'
					"->"
				'``@rcvr nextPutAll: ``@object1; nextPutAll: ``@object2')
			#('``@rcvr show: ``@object1 , ``@object2'
					"->"
				'``@rcvr show: ``@object1; show: ``@object2'))
		methods: false
		name: 'Use cascaded nextPutAll:''s instead of #, in #nextPutAll:'!

detectIfNone
	^self rewrite: #(
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) isNil'
				"->"	'(``@collection contains: [:`each | | `@temps | ``@.Statements]) not')
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) = nil'
				"->"	'(``@collection contains: [:`each | | `@temps | ``@.Statements]) not')
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) == nil'
				"->"	'(``@collection contains: [:`each | | `@temps | ``@.Statements]) not')
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) notNil'
				"->"	'``@collection contains: [:`each | | `@temps | ``@.Statements]')
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) ~= nil'
				"->"	'``@collection contains: [:`each | | `@temps | ``@.Statements]')
			#('(``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [nil]) ~~ nil'
				"->"	'``@collection contains: [:`each | | `@temps | ``@.Statements]'))
		methods: false
		name: 'detect:ifNone: -> contains:'!

equalNil
	^self
		rewrite: #(
			#('``@object = nil'	"->"	'``@object isNil') 
			#('``@object == nil'	"->"	'``@object isNil') 
			#('``@object ~= nil'	"->"	'``@object notNil') 
			#('``@object ~~ nil'	"->"	'``@object notNil'))
		methods: false
		name: '= nil -> isNil AND ~= nil -> notNil'!

guardClause
	^self
		rewrite: #(
			#('`@methodName: `@args 
					| `@temps | 
					`@.Statements. 
					`@condition ifTrue: [| `@trueTemps | `.Statement1. `.Statement2. `@.Statements1]'
			"->"
			'`@methodName: `@args
					| `@temps `@trueTemps |
					`@.Statements.
					`@condition ifFalse: [^self].
					`.Statement1.
					`.Statement2.
					`@.Statements1') 
			#('`@methodName: `@args 
					| `@temps | 
					`@.Statements. 
					`@condition ifFalse: [| `@falseTemps | `.Statement1. `.Statement2. `@.Statements1]'
			"->"
			'`@methodName: `@args
					| `@temps `@falseTemps |
					`@.Statements.
					`@condition ifTrue: [^self].
					`.Statement1.
					`.Statement2.
					`@.Statements1'))
		methods: true
		name: 'Eliminate guarding clauses'!

minMax
	^self rewrite: #(
			#('``@a < ``@b ifTrue: [``@a] ifFalse: [``@b]'	"->"	'``@a min: ``@b')
			#('``@a <= ``@b ifTrue: [``@a] ifFalse: [``@b]'	"->"	'``@a min: ``@b')
			#('``@a > ``@b ifTrue: [``@a] ifFalse: [``@b]'	"->"	'``@a max: ``@b')
			#('``@a >= ``@b ifTrue: [``@a] ifFalse: [``@b]'	"->"	'``@a max: ``@b')
			#('``@a < ``@b ifTrue: [``@b] ifFalse: [``@a]'	"->"	'``@a max: ``@b')
			#('``@a <= ``@b ifTrue: [``@b] ifFalse: [``@a]'	"->"	'``@a max: ``@b')
			#('``@a > ``@b ifTrue: [``@b] ifFalse: [``@a]'	"->"	'``@a min: ``@b')
			#('``@a >= ``@b ifTrue: [``@b] ifFalse: [``@a]'	"->"	'``@a min: ``@b')
			#('`a < ``@b ifTrue: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('`a <= ``@b ifTrue: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('`a < ``@b ifFalse: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('`a <= ``@b ifFalse: [`a := ``@b]'			"->"	'`a := `a min: ``@b')
			#('`a > ``@b ifTrue: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('`a >= ``@b ifTrue: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('`a > ``@b ifFalse: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('`a >= ``@b ifFalse: [`a := ``@b]'			"->"	'`a := `a max: ``@b')
			#('``@b < `a ifTrue: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('``@b <= `a ifTrue: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('``@b < `a ifFalse: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('``@b <= `a ifFalse: [`a := ``@b]'			"->"	'`a := `a max: ``@b')
			#('``@b > `a ifTrue: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('``@b >= `a ifTrue: [`a := ``@b]'				"->"	'`a := `a max: ``@b')
			#('``@b > `a ifFalse: [`a := ``@b]'				"->"	'`a := `a min: ``@b')
			#('``@b >= `a ifFalse: [`a := ``@b]'			"->"	'`a := `a min: ``@b'))
		methods: false
		name: 'Rewrite ifTrue:ifFalse: using min:/max:'!

notElimination
	^self
		rewrite: #(
			#('``@object not not'	"->"	'``@object') 
			#('``@object not ifTrue: ``@block' 	"->"	'``@object ifFalse: ``@block') 
			#('``@object not ifFalse: ``@block'	"->"	'``@object ifTrue: ``@block') 
			#('``@collection select: [:`each | | `@temps | ``@.Statements. ``@object not]'
				"->"	'``@collection reject: [:`each | | `@temps | ``@.Statements. ``@object]')
			#('``@collection reject: [:`each | | `@temps | ``@.Statements. ``@object not]'
				"->"	'``@collection select: [:`each | | `@temps | ``@.Statements. ``@object]')
			#('[| `@temps | ``@.Statements. ``@object not] whileTrue: ``@block'
				"->"	'[| `@temps | ``@.Statements. ``@object] whileFalse: ``@block')
			#('[| `@temps | ``@.Statements. ``@object not] whileFalse: ``@block'
				"->"	'[| `@temps | ``@.Statements. ``@object] whileTrue: ``@block')
			#('[| `@temps | ``@.Statements. ``@object not] whileTrue'
				"->"	'[| `@temps | ``@.Statements. ``@object] whileFalse')
			#('[| `@temps | ``@.Statements. ``@object not] whileFalse'
				"->"	'[| `@temps | ``@.Statements. ``@object] whileTrue')
			#('(``@a <= ``@b) not' "->" '``@a > ``@b')
			#('(``@a < ``@b) not' "->" '``@a >= ``@b')
			#('(``@a = ``@b) not' "->" '``@a ~= ``@b')
			#('(``@a == ``@b) not' "->" '``@a ~~ ``@b')
			#('(``@a ~= ``@b) not' "->" '``@a = ``@b')
			#('(``@a ~~ ``@b) not' "->" '``@a == ``@b')
			#('(``@a >= ``@b) not' "->" '``@a < ``@b')
			#('(``@a > ``@b) not' "->" '``@a <= ``@b'))			
		methods: false
		name: 'Eliminate unnecessary not''s'!

showWhileBlocks
	^self
		rewrite: #(
			#('``@cursor showWhile: [| `@temps | ``@.Statements. `var := ``@object]'
				"->"	'`var := ``@cursor showWhile: [| `@temps | ``@.Statements. ``@object]') 
			#('``@cursor showWhile: [| `@temps | ``@.Statements. ^``@object]'
				"->"	'^``@cursor showWhile: [| `@temps | ``@.Statements. ``@object]'))
		methods: false
		name: 'Move assignment out of showWhile: blocks'!

superSends
	^(self new)
		name: 'Rewrite super messages to self messages when both refer to same method';
		superSends;
		yourself!

unwindBlocks
	^self
		rewrite: #(
			#('[| `@temps | ``@.Statements. `var := ``@object] valueNowOrOnUnwindDo: ``@block'
				"->"	'`var := [| `@temps | ``@.Statements. ``@object] valueNowOrOnUnwindDo: ``@block') 
			#('[| `@temps | ``@.Statements. ^``@object] valueNowOrOnUnwindDo: ``@block'
				"->"	'^[| `@temps | ``@.Statements. ``@object] valueNowOrOnUnwindDo: ``@block') 
			#('[| `@temps | ``@.Statements. `var := ``@object] valueOnUnwindDo: ``@block'
				"->"	'`var := [| `@temps | ``@.Statements. ``@object] valueOnUnwindDo: ``@block') 
			#('[| `@temps | ``@.Statements. ^``@object] valueOnUnwindDo: ``@block'
				"->"	'^[| `@temps | ``@.Statements. ``@object] valueOnUnwindDo: ``@block'))
		methods: false
		name: 'Move assignment out of valueNowOrUnwindDo: blocks'! !


!RefactoringBrowser methodsFor: 'actions'!

openRewriter
	RewriteRuleEditor rewrite: ''! !


!BrowserEnvironment methodsFor: 'accessing'!

problemCount
	^self numberSelectors! !

RestrictedEnvironment subclass: #ParseTreeEnvironment
	instanceVariableNames: 'matcher '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!ParseTreeEnvironment methodsFor: 'initialize-release'!

matcher: aParseTreeSearcher
	matcher := aParseTreeSearcher! !

!ParseTreeEnvironment methodsFor: 'accessing'!

selectionIntervalFor: aString 
	| parseTree node |
	matcher isNil ifTrue: [^super selectionIntervalFor: aString].
	parseTree := BRParser parseMethod: aString
				onError: [:error :position | ^super selectionIntervalFor: aString].
	node := matcher executeTree: parseTree initialAnswer: nil.
	^node isNil 
		ifTrue: [super selectionIntervalFor: aString]
		ifFalse: [node sourceInterval]! !

ParseTreeEnvironment class
	instanceVariableNames: ''!


Object subclass: #SmalllintContext
	instanceVariableNames: 'class selector parseTree literals literalSemaphore literalProcess selectors compiledMethod selfMessages superMessages messages '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!SmalllintContext methodsFor: 'initialize-release'!

initialize
	self computeLiterals!

release
	literalProcess notNil ifTrue: [literalProcess terminate].
	super release! !

!SmalllintContext methodsFor: 'accessing'!

compiledMethod
	^compiledMethod notNil
		ifTrue: [compiledMethod]
		ifFalse: [compiledMethod := class compiledMethodAt: selector]!

instVarNames
	^self selectedClass allInstVarNames!

literals
	literalSemaphore isNil
		ifTrue: 
			[literals isNil ifTrue: 
					[self computeLiterals.
					literalSemaphore wait]]
		ifFalse: [literalSemaphore wait].
	^literals!

messages
	messages isNil ifTrue: [self computeMessages].
	^messages!

parseTree
	^parseTree isNil
		ifTrue: [parseTree := self buildParseTree]
		ifFalse: [parseTree]!

protocol
	^self selectedClass whichCategoryIncludesSelector: self selector!

protocols
	^Array with: self protocol!

selectedClass
	^class!

selectedClass: anObject 
	class := anObject.
	self selector: nil!

selector
	^selector!

selector: anObject 
	selector := anObject.
	parseTree := compiledMethod := selfMessages := superMessages := messages := nil!

selectors
	literalSemaphore isNil
		ifTrue: 
			[selectors isNil ifTrue: 
					[self computeLiterals.
					literalSemaphore wait]]
		ifFalse: [literalSemaphore wait].
	^selectors!

selfMessages
	selfMessages isNil ifTrue: [self computeMessages].
	^selfMessages!

superMessages
	superMessages isNil ifTrue: [self computeMessages].
	^superMessages! !

!SmalllintContext methodsFor: 'testing'!

implements: aSelector 
	^self selectors includes: aSelector!

isAbstract: aClass 
	^(aClass isMeta or: 
			[(self literals includes: aClass name)
				or: [self literals includes: (Smalltalk associationAt: aClass name)]])
		not!

uses: anObject 
	^self literals includes: anObject! !

!SmalllintContext methodsFor: 'private'!

addLiteralsFor: aCompiledMethod 
	aCompiledMethod withAllBlockMethodsDo: 
			[:each | 
			each literalsDo: [:literal | self checkLiteral: literal]]!

buildParseTree
	| tree |
	tree := self selectedClass parseTreeFor: self selector.
	tree isNil ifTrue: [^BRParser parseMethod: 'method'].
	^tree!

checkLiteral: aLiteral 
	(aLiteral isSymbol or: [aLiteral isVariableBinding])
		ifTrue: [literals add: aLiteral]
		ifFalse: 
			[aLiteral class == Array
				ifTrue: [aLiteral do: [:each | self checkLiteral: each]]]!

computeLiterals
	literalSemaphore := Semaphore new.
	literalProcess := [self primitiveComputeLiterals] fork!

computeLiteralsForClass: aClass 
	(selectors addAll: aClass selectors) do: 
			[:sel | 
			self computeLiteralsForSelector: sel in: aClass.
			Processor yield]!

computeLiteralsForSelector: aSelector in: aClass 
	| method |
	method := aClass compiledMethodAt: aSelector ifAbsent: [nil].
	method isNil ifTrue: [^self].
	self addLiteralsFor: method!

computeMessages
	| searcher |
	selfMessages := Set new.
	superMessages := Set new.
	messages := Set new.
	searcher := ParseTreeSearcher new.
	searcher
		matches: 'self `@message: ``@args'
			do: [:aNode :answer | selfMessages add: aNode selector];
		matches: 'super `@message: ``@args'
			do: [:aNode :answer | superMessages add: aNode selector];
		matches: '``@receiver `@message: ``@args'
			do: [:aNode :answer | messages add: aNode selector].
	searcher executeTree: self parseTree initialAnswer: nil!

primitiveComputeLiterals
	| semaphore |
	literals := IdentitySet new: 25000.
	literals addAll: self specialSelectors.
	selectors := IdentitySet new.
	Smalltalk allBehaviorsDo: [:aClass | self computeLiteralsForClass: aClass].
	semaphore := literalSemaphore.
	literalSemaphore := nil.
	self signalProcesses: semaphore.
	^literalProcess := nil!

signalProcesses: aSemaphore 
	aSemaphore isNil ifTrue: [^self].
	[aSemaphore isEmpty] whileFalse: [aSemaphore signal]!

specialSelectors
	^(OpcodePool at: #SpecialSelectorDictionary) keys! !

SmalllintContext class
	instanceVariableNames: ''!



!SmalllintContext class methodsFor: 'instance creation'!

new
	^super new initialize!

newNoCache
	^self basicNew! !

BrowserApplicationModel subclass: #Smalllint
	instanceVariableNames: 'checker percentDone checkerProcess environmentEditor menuHolder context '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!Smalllint methodsFor: 'initialize-release'!

initialize
	super initialize.
	self checker onChangeSend: #changedChecker to: self.
	percentDone := 0.0 asValue!

release
	self abort.
	context release.
	super release! !

!Smalllint methodsFor: 'accessing'!

currentRule
	^self checker value!

environmentEditor
	environmentEditor isNil
		ifTrue: 
			[environmentEditor := EnvironmentEditor new.
			environmentEditor environment: ClassEnvironment new].
	^environmentEditor!

percentDone: aValue
	self percentDone value: aValue! !

!Smalllint methodsFor: 'actions'!

abort
	checkerProcess isNil ifTrue: [^self].
	checkerProcess terminate.
	checkerProcess := nil.
	self resetButtons.
	self percentDone: 0.0!

clearFilters
	BasicLintRule filterDictionary: Dictionary new!

emptyCache
	context release.
	context := SmalllintContext new.

	"We must set the current menu choice to nil before setting the menu -- bug in the MenuButtonView 
	update:..."
	self checker value: nil.
	menuHolder value: self computeMenu!

loadFilters
	| file fileStream |
	file := self request: 'Enter name of  ignores file:'
				initialAnswer: 'Smalllint.ig'.
	file isEmpty ifTrue: [^self].
	fileStream := file asFilename readStream.
	[self class compilerClass evaluate: fileStream contents] 
		valueNowOrOnUnwindDo: [fileStream close]!

run
	checkerProcess notNil ifTrue: [^self].
	self disableAll: #(#run #checker #emptyCache #results).
	self enable: #abort.
	checkerProcess := [[self runChecker]
				valueNowOrOnUnwindDo: 
					[self enableAll: #(#run #checker #emptyCache).
					(self checker value isNil or: [self checker value isEmpty])
						ifFalse: [self enable: #results].
					self disable: #abort.
					checkerProcess := nil]] fork!

runNoInterface
	checkerProcess notNil ifTrue: [^self].
	self disableAll: #(#run #emptyCache #results).
	self enable: #abort.
	checkerProcess := 
			[[self runChecker] valueNowOrOnUnwindDo: 
					[checkerProcess := nil.
					self closeRequest]]
					fork!

saveFilters
	| file fileStream |
	file := self request: 'Enter the file to save ignores to:'
				initialAnswer: 'Smalllint.ig'.
	file isEmpty ifTrue: [^self].
	fileStream := file asFilename writeStream.
	[BasicLintRule storeFiltersOn: fileStream] 
		valueNowOrOnUnwindDo: [fileStream close]!

viewResults
	self currentRule openEditor! !

!Smalllint methodsFor: 'aspects'!

checker
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^checker isNil
		ifTrue:
			[checker := nil asValue]
		ifFalse:
			[checker]!

percentDone
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^percentDone isNil
		ifTrue:
			[percentDone := 0 asValue]
		ifFalse:
			[percentDone]! !

!Smalllint methodsFor: 'menu'!

checkerMenu
	menuHolder isNil ifTrue: [menuHolder := self computeMenu asValue].
	^menuHolder!

filterMenu
	| menu |
	menu := Menu new.
	menu
		addItem: ((MenuItem labeled: '&Load Filters from File...') value: #loadFilters);
		addItem: ((MenuItem labeled: '&Save Filters to File...') value: #saveFilters);
		addItem: ((MenuItem labeled: '&Clear Filters') value: #clearFilters).
	^menu!

menu
	| menu |
	menu := Menu new.
	menu
		addItem: ((MenuItem labeled: 'Ca&tegory') 
					submenu: environmentEditor categoryMenu);
		addItem: ((MenuItem labeled: '&Class') submenu: environmentEditor classMenu);
		addItem: ((MenuItem labeled: '&Filters') submenu: self filterMenu).
	^menu! !

!Smalllint methodsFor: 'events'!

noticeOfWindowClose: aWidget 
	self release.
	super noticeOfWindowClose: aWidget! !

!Smalllint methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	context := (builder componentAt: #checker) isNil
				ifTrue: [SmalllintContext newNoCache]
				ifFalse: [SmalllintContext new]! !

!Smalllint methodsFor: 'private'!

changedChecker
	(checker value isKindOf: LintRule) & checkerProcess isNil 
		ifTrue: 
			[checker value isEmpty 
				ifTrue: [self disable: #results]
				ifFalse: [self enable: #results].
			self enable: #run]
		ifFalse: [self disableAll: #(#run #results)].
	percentDone value: 0!

computeMenu
	| mb |
	mb := MenuBuilder new.
	self menuFor: CompositeLintRule allRules builder: mb.
	^mb menu!

menuFor: aCompositeLintRule builder: aMenuBuilder 
	aCompositeLintRule hasConflicts
		ifFalse: 
			[aMenuBuilder add: aCompositeLintRule name , ' - Run all' -> aCompositeLintRule.
			aMenuBuilder line].
	aCompositeLintRule rules do: [:each | each isComposite
			ifTrue: 
				[aMenuBuilder beginSubMenuLabeled: each name.
				self menuFor: each builder: aMenuBuilder.
				aMenuBuilder endSubMenu]
			ifFalse: [aMenuBuilder add: each name -> each]]!

resetButtons
	self enableAll: #(#run #emptyCache).
	(self currentRule isNil or: [self currentRule isEmpty])
		ifTrue: [self disable: #results]
		ifFalse: [self enable: #results].
	self disable: #abort.
	checkerProcess := nil!

runChecker
	| size currentChecker i environment |
	environment := environmentEditor selectedEnvironment.
	environment isEmpty ifTrue: 
			[^Dialog
				warn: 'You haven''t selected any classes.<n>All selected items will have a check by them.'
						expandMacros].
	currentChecker := self currentRule.
	currentChecker resetResult.
	self percentDone: 0.
	i := 0.0.
	size := environment numberSelectors.
	environment classesDo: 
			[:aClass | 
			context selectedClass: aClass.
			(environment definesClass: aClass)
				ifTrue: [currentChecker checkClass: context].
			(environment selectorsForClass: aClass) do: 
					[:each | 
					context selector: each.
					currentChecker checkMethod: context.
					i := i + 1.
					self percentDone: i / size.
					Processor yield]].
	self percentDone: 1.
	currentChecker isEmpty ifTrue: [Dialog warn: 'Nobody'].
	currentChecker openEditor! !

Smalllint class
	instanceVariableNames: ''!



!Smalllint class methodsFor: 'accessing'!

runAllChecks
	"self runAllChecks"

	self runRule: CompositeLintRule allRules!

runRule: aRule 
	| dialog |
	dialog := ClassSelectionDialog new.
	dialog open ifFalse: [^self].
	self runRule: aRule onEnvironment: dialog selectedEnvironment!

runRule: rule onEnvironment: environment 
	| lint |
	lint := self new.
	lint openInterface: #abortWindowSpec.
	lint environmentEditor environment: environment.
	lint checker value: rule.
	lint runNoInterface! !

!Smalllint class methodsFor: 'interface specs'!

abortWindowSpec
	"UIPainter new openOnClass: self andSelector: #abortWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Smalllint' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 517 401 799 504 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ProgressWidgetSpec 
					#layout: #(#LayoutFrame 5 0 30 0 -5 1 -35 1 ) 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setForegroundColor: #(#ColorValue #blue ) ) 
					#model: #percentDone 
					#direction: #horizontal 
					#position: #topLeft 
					#area: true 
					#reverse: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -30 0.5 -30 1 30 0.5 -2 1 ) 
					#name: #abort 
					#flags: 40 
					#model: #abort 
					#label: 'Abort' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 5 0 0.5 0 ) 
					#label: 'Running rule...' ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Smalllint' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 450 315 992 541 ) 
			#flags: 4 
			#menu: #menu ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#MenuButtonSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.666666 30 0 ) 
					#name: #checker 
					#model: #checker 
					#menu: #checkerMenu ) 
				#(#ProgressWidgetSpec 
					#layout: #(#LayoutFrame 2 0.666666 2 0 -1 1 30 0 ) 
					#isOpaque: true 
					#colors: 
					#(#LookPreferences 
						#setForegroundColor: #(#ColorValue #blue ) ) 
					#model: #percentDone 
					#direction: #horizontal 
					#position: #topLeft 
					#area: true 
					#reverse: false ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 62 0 0 1 0 1 ) 
					#name: #environmentEditor 
					#majorKey: #EnvironmentEditor 
					#minorKey: #classWindowSpec 
					#clientKey: #environmentEditor ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -45 0.2 32 0 45 0.2 60 0 ) 
					#name: #run 
					#flags: 40 
					#model: #run 
					#label: 'Run' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -45 0.4 32 0 45 0.4 60 0 ) 
					#name: #abort 
					#flags: 40 
					#model: #abort 
					#label: 'Abort' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -45 0.8 32 0 45 0.8 60 0 ) 
					#name: #emptyCache 
					#model: #emptyCache 
					#label: 'Empty cache' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -45 0.6 32 0 45 0.6 60 0 ) 
					#name: #results 
					#flags: 40 
					#model: #viewResults 
					#label: 'Results' ) ) ) )! !

LintRule subclass: #CompositeLintRule
	instanceVariableNames: 'rules '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!

CompositeLintRule comment:
'CompositeLintRule groups LintRules into a single rule (composite pattern).

Instance Variables:
	rules	<Collection of: LintRule>	the rules that make up the composite

'!


!CompositeLintRule methodsFor: 'initialize-release'!

resetResult
	rules do: [:each | each resetResult]!

rules: aCollection
	rules := aCollection! !

!CompositeLintRule methodsFor: 'accessing'!

checkClass: aSmalllintContext 
	rules do: 
			[:each | 
			each checkClass: aSmalllintContext.
			Processor yield]!

checkMethod: aSmalllintContext 
	rules do: 
			[:each | 
			each checkMethod: aSmalllintContext.
			Processor yield]!

failedRules
	^rules inject: OrderedCollection new into: [:oc :each | oc addAll: each failedRules; yourself]!

problemCount
	^rules inject: 0 into: [:count :each | count + each problemCount]!

rules
	^rules! !

!CompositeLintRule methodsFor: 'testing'!

hasConflicts
	^(rules detect: [:each | each hasConflicts] ifNone: [nil]) notNil!

isComposite
	^true!

isEmpty
	^(rules detect: [:each | each isEmpty not] ifNone: [nil]) isNil! !

!CompositeLintRule methodsFor: 'private'!

viewResults
	rules do: [:each | each viewResults]! !

CompositeLintRule class
	instanceVariableNames: ''!



!CompositeLintRule class methodsFor: 'instance creation'!

allRules
	^self ruleFor: self protocol: 'all checks'!

ruleFor: aClass protocol: aProtocol 
	| allRules |
	allRules := aClass withAllSubclasses inject: OrderedCollection new
				into: 
					[:sum :each | 
					sum
						addAll: ((BrowserEnvironment new selectorsFor: aProtocol asSymbol
									in: each class) collect: [:selector | each perform: selector]);
						yourself].
	^self rules: (allRules asSortedCollection: [:a :b | a name < b name])
		name: ((aProtocol asString copy)
				at: 1 put: aProtocol first asUppercase;
				yourself)!

rules: aCollection 
	^self new rules: aCollection!

rules: aCollection name: aString 
	^(self new) rules: aCollection;
		name: aString;
		yourself! !

!CompositeLintRule class methodsFor: 'all checks'!

lintChecks
	^self rules: (BasicLintRule protocols
				collect: [:each | self ruleFor: BasicLintRule protocol: each])
		name: 'Lint checks'!

transformations
	^self ruleFor: TransformationRule protocol: 'transformations'! !


BrowserApplicationModel subclass: #SmalllintResultEditor
	instanceVariableNames: 'label results resultsList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!SmalllintResultEditor methodsFor: 'initialize-release'!

label: aLabel 
	label := aLabel!

rule: aCompositeLintRule 
	results := self flattenResults: aCompositeLintRule! !

!SmalllintResultEditor methodsFor: 'aspects'!

resultsList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^resultsList isNil
		ifTrue:
			[resultsList := SelectionInList new]
		ifFalse:
			[resultsList]! !

!SmalllintResultEditor methodsFor: 'changing'!

changedResult
	(self selectedResult isNil or: [self selectedResult isComposite])
		ifTrue: [self disableAll: #(#openResult #remove)]
		ifFalse: [self enableAll: #(#openResult #remove)]! !

!SmalllintResultEditor methodsFor: 'actions'!

openResult
	self selectedResult openEditor!

remove
	results := self removeCurrentResultFrom: results.
	self resultsList list: results asList.
	self changedResult! !

!SmalllintResultEditor methodsFor: 'events'!

noticeOfWindowClose: aWindow 
	self release.
	super noticeOfWindowClose: aWindow! !

!SmalllintResultEditor methodsFor: 'interface opening'!

postBuildResultsList
	| block specWrapper |
	specWrapper := builder componentAt: #resultsList.
	specWrapper isNil ifTrue: [^self].
	block := 
			[:view :index | 
			| each name |
			each := view sequence at: index.
			name := each displayName asText.
			each isComposite ifTrue: [name := name allBold].
			Label with: name
				attributes: view textStyle
				offset: ((self indentionLevelFor: each at: index) * 10) @ 0].
	(specWrapper widget) visualBlock: (self createVisualBlockFrom: block);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: block)!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	self resultsList list: results asList.
	self postBuildResultsList!

postOpenWith: aBuilder 
	super postOpenWith: aBuilder.
	label notNil ifTrue: [self setLabel: 'Smalllint Results -- ' , label].
	self changedResult! !

!SmalllintResultEditor methodsFor: 'private'!

flattenResults: aCompositeLintRule 
	| flattenedResults |
	flattenedResults := OrderedCollection new.
	aCompositeLintRule rules do: 
			[:each | 
			each isEmpty ifFalse: 
					[each isComposite
						ifTrue: 
							[flattenedResults add: each;
								addAll: (self flattenResults: each)]
						ifFalse: [flattenedResults add: each]]].
	^flattenedResults!

indentionLevelFor: aRule at: anIndex 
	| current level |
	current := aRule.
	level := 0.
	anIndex to: 1
		by: -1
		do: 
			[:i | 
			| each |
			each := results at: i.
			(each isComposite and: [each rules includes: current]) ifTrue: 
					[current := each.
					level := level + 1]].
	^level!

removeCurrentResultFrom: displayedResults 
	| currentResult last newList |
	currentResult := self selectedResult.
	displayedResults remove: currentResult ifAbsent: [].
	newList := displayedResults copy.
	last := nil.
	displayedResults reverseDo: 
			[:each | 
			(each isComposite and: [(each rules includes: last) not])
				ifTrue: [newList remove: each ifAbsent: []]
				ifFalse: [last := each]].
	^newList!

selectedResult
	^self resultsList selection! !

SmalllintResultEditor class
	instanceVariableNames: ''!



!SmalllintResultEditor class methodsFor: 'interface opening'!

openOn: aCompositeLintRule 
	^self openOn: aCompositeLintRule label: nil!

openOn: aCompositeLintRule label: aLabel 
	aCompositeLintRule isEmpty ifTrue: [Dialog warn: 'Nobody'].
	(self new) rule: aCompositeLintRule;
		label: aLabel;
		open! !

!SmalllintResultEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Smalllint Results' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 630 548 1203 803 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 -39 1 ) 
					#name: #resultsList 
					#model: #resultsList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedResult ) 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -35 0.333333 -35 1 35 0.333333 -5 1 ) 
					#name: #openResult 
					#flags: 40 
					#model: #openResult 
					#label: 'Open...' 
					#isDefault: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -35 0.666666 -35 1 35 0.666666 -5 1 ) 
					#name: #remove 
					#model: #remove 
					#label: 'Remove' ) ) ) )! !


!RefactoryBuilder methodsFor: 'accessing'!

problemCount
	^self changesSize! !

LimitedEnvironment subclass: #MultiEnvironment
	instanceVariableNames: 'environmentDictionaries '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

MultiEnvironment comment:
'MultiEnvironment is a special environment for the "Method defined in all subclasses, but not in superclass" lint rule. It''s basically a hack to get a browser to display the results.

Instance Variables:
	environmentDictionaries	<Dictionary key: String value: BrowserEnvironment>	the individual results from each failure. Each value stores the methods that are defined in the subclasses'!


!MultiEnvironment methodsFor: 'initialize-release'!

initialize
	super initialize.
	environmentDictionaries := Dictionary new.
	environment := RestrictedEnvironment new! !

!MultiEnvironment methodsFor: 'accessing'!

environments
	^environmentDictionaries keys!

navigatorClass
	^MultiNavigator!

problemCount
	^environmentDictionaries size!

selectEnvironment: aValue 
	environment := environmentDictionaries at: aValue
				ifAbsent: [RestrictedEnvironment new]! !

!MultiEnvironment methodsFor: 'adding'!

addClass: aClass into: aValue 
	(environmentDictionaries at: aValue
		ifAbsentPut: [RestrictedEnvironment new]) addClass: aClass!

addClass: aClass selector: aSymbol into: aValue 
	(environmentDictionaries at: aValue
		ifAbsentPut: [RestrictedEnvironment new]) addClass: aClass selector: aSymbol! !

!MultiEnvironment methodsFor: 'removing'!

removeClass: aClass into: aValue 
	(environmentDictionaries at: aValue ifAbsent: [RestrictedEnvironment new]) 
		removeClass: aClass!

removeClass: aClass selector: aSelector into: aValue 
	(environmentDictionaries at: aValue
		ifAbsentPut: [RestrictedEnvironment new]) removeClass: aClass
			selector: aSelector! !

!MultiEnvironment methodsFor: 'testing'!

isEmpty
	^environmentDictionaries isEmpty! !

MultiEnvironment class
	instanceVariableNames: ''!


BrowserApplicationModel subclass: #UnreferencedVariables
	instanceVariableNames: 'classVarList instVarList classList label spec classVars instVars '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!UnreferencedVariables methodsFor: 'initialize-release'!

initialize
	super initialize.
	classList := SelectionInList new.
	classVarList := SelectionInList new.
	instVarList := SelectionInList new.
	instVars := Dictionary new.
	classVars := Dictionary new.
	classList selectionIndexHolder onChangeSend: #changedClass to: self.
	classVarList selectionIndexHolder onChangeSend: #changedClassVar to: self.
	instVarList selectionIndexHolder onChangeSend: #changedInstVar to: self!

spec: aSymbol 
	spec := aSymbol! !

!UnreferencedVariables methodsFor: 'accessing'!

addClassVar: aName for: aClass 
	(classVars at: aClass ifAbsentPut: [Set new]) add: aName!

addInstVar: aName for: aClass 
	(instVars at: aClass ifAbsentPut: [Set new]) add: aName!

classVarCount
	^classVars inject: 0 into: [:count :each | count + each size]!

editor
	^self!

instVarCount
	^instVars inject: 0 into: [:count :each | count + each size]!

label
	^label!

label: anObject
	^label := anObject!

openEditor
	self isEmpty ifFalse: [self editor openInterface: (spec isNil
				ifTrue: [#windowSpec]
				ifFalse: [spec])]!

preferredSpec
	^spec isNil
		ifTrue: [super preferredSpec]
		ifFalse: [spec]!

problemCount
	^self instVarCount + self classVarCount! !

!UnreferencedVariables methodsFor: 'testing'!

isEmpty
	^classVars isEmpty & instVars isEmpty! !

!UnreferencedVariables methodsFor: 'actions'!

browseInstVarRefs
	RefactoringBrowser
		openOnEnvironment: (BrowserEnvironment new instVarRefsTo: self instVarList selection
				in: self classList selection)!

pullUpInstVar
	self handleError: 
			[(PullUpInstanceVariableRefactoring variable: self instVarList selection
				class: self classList selection) execute]!

removeAllVariables
	self removeAllClassVariables;
		removeAllInstanceVariables;
		removeVariablesForSelectedClass!

removeClassVar
	| class variable |
	class := classList selection.
	variable := classVarList selection.
	self handleError: 
			[(RemoveClassVariableRefactoring variable: variable class: class) execute].
	(classVars at: class ifAbsent: [#()]) remove: variable ifAbsent: [].
	(classVars at: class ifAbsent: [#()]) isEmpty
		ifTrue: [classVars removeKey: class].
	self classVarList list remove: variable.
	self changedClass!

removeInstVar
	| class variable |
	class := classList selection.
	variable := instVarList selection.
	self handleError: 
			[(RemoveInstanceVariableRefactoring variable: variable class: class) execute].
	(instVars at: class ifAbsent: [#()]) remove: variable ifAbsent: [].
	(instVars at: class ifAbsent: [#()]) isEmpty
		ifTrue: [instVars removeKey: class].
	self instVarList list remove: variable.
	self changedClass! !

!UnreferencedVariables methodsFor: 'updating'!

changedClass
	classList selection isNil
		ifTrue: [self disable: #removeAllVariables]
		ifFalse: [self enable: #removeAllVariables].
	self instVarList list: (self variablesIn: instVars).
	self classVarList list: (self variablesIn: classVars)!

changedClassVar
	classVarList selection isNil
		ifTrue: [self disable: #removeClassVar]
		ifFalse: [self enable: #removeClassVar]!

changedInstVar
	instVarList selection isNil
		ifTrue: [self disableAll: #(#removeInstVar #browseInstVarRefs #pullUpInstVar)]
		ifFalse: [self enableAll: #(#removeInstVar #browseInstVarRefs #pullUpInstVar)]! !

!UnreferencedVariables methodsFor: 'aspects'!

classList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^classList isNil
		ifTrue:
			[classList := SelectionInList new]
		ifFalse:
			[classList]!

classVarList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^classVarList isNil
		ifTrue:
			[classVarList := SelectionInList new]
		ifFalse:
			[classVarList]!

instVarList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^instVarList isNil
		ifTrue:
			[instVarList := SelectionInList new]
		ifFalse:
			[instVarList]! !

!UnreferencedVariables methodsFor: 'copying'!

copyEmpty
	^self copy initialize! !

!UnreferencedVariables methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	| classes |
	super postBuildWith: aBuilder.
	classes := Set withAll: instVars keys.
	classes addAll: classVars keys.
	self classList
		list: (List withAll: (classes asSortedCollection: [:a :b | a name < b name]))!

postOpenWith: aBuilder 
	super postOpenWith: aBuilder.
	self setLabel: label! !

!UnreferencedVariables methodsFor: 'private'!

removeAllClassVariables
	| class |
	class := self classList selection.
	classVarList list do: 
			[:each | 
			self handleError: 
					[(RemoveClassVariableRefactoring variable: each class: class) execute]]!

removeAllInstanceVariables
	| class |
	class := self classList selection.
	instVarList list do: 
			[:each | 
			self handleError: 
					[(RemoveInstanceVariableRefactoring variable: each class: class) execute]]!

removeVariablesForSelectedClass
	| class |
	class := self classList selection.
	classVars removeKey: class ifAbsent: [].
	instVars removeKey: class ifAbsent: [].
	self classList list remove: class ifAbsent: [].
	self changedClass!

variablesIn: aDictionary 
	| class |
	class := self classList selection.
	^class isNil
		ifTrue: [#()]
		ifFalse: [(aDictionary at: class ifAbsent: [#()]) asSortedCollection]! !

UnreferencedVariables class
	instanceVariableNames: ''!



!UnreferencedVariables class methodsFor: 'instance creation'!

pullUpInstVar
	^self new spec: #pullUpInstVarSpec!

references
	^self new spec: #notReadAndWrittenSpec!

unreferenced
	^self new spec: #windowSpec! !

!UnreferencedVariables class methodsFor: 'interface specs'!

notReadAndWrittenSpec
	"UIPainter new openOnClass: self andSelector: #notReadAndWrittenSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Variables not read AND written' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 311 258 896 497 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 25 0 -3 0.5 -2 1 ) 
					#name: #classList 
					#model: #classList ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0.5 25 0 -2 1 -33 1 ) 
					#name: #instVarList 
					#model: #instVarList ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame -1 0.5 0 0 1 0.5 0 1 ) 
					#orientation: #vertical ) 
				#(#LabelSpec 
					#layout: #(#Point 2 2 ) 
					#label: 'Class:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 2 0.5 2 0 ) 
					#label: 'Instance Variables:' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -31 1 -2 1 -3 1 ) 
					#name: #browseInstVarRefs 
					#model: #browseInstVarRefs 
					#label: 'Browse references...' 
					#defaultable: true ) ) ) )!

pullUpInstVarSpec
	"UIPainter new openOnClass: self andSelector: #pullUpInstVarSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Instance variables defined in all subclasses' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 244 223 829 462 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 25 0 -3 0.5 -2 1 ) 
					#name: #classList 
					#model: #classList ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0.5 25 0 -2 1 -33 1 ) 
					#name: #instVarList 
					#model: #instVarList ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame -1 0.5 0 0 1 0.5 0 1 ) 
					#orientation: #vertical ) 
				#(#LabelSpec 
					#layout: #(#Point 2 2 ) 
					#label: 'Class:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 2 0.5 2 0 ) 
					#label: 'Instance Variables:' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -31 1 -2 1 -3 1 ) 
					#name: #pullUpInstVar 
					#model: #pullUpInstVar 
					#label: 'Pull up variable' 
					#defaultable: true ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Unreferenced variables' 
			#bounds: #(#Rectangle 196 168 789 648 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 25 0 -3 0.5 -32 1 ) 
					#name: #classList 
					#model: #classList ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0.5 25 0 -2 1 -33 0.5 ) 
					#name: #instVarList 
					#model: #instVarList ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0.5 25 0.5 -2 1 -32 1 ) 
					#name: #classVarList 
					#model: #classVarList ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame -1 0.5 0 0 1 0.5 0 1 ) 
					#orientation: #vertical ) 
				#(#LabelSpec 
					#layout: #(#Point 2 2 ) 
					#label: 'Class:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 2 0.5 2 0 ) 
					#label: 'Instance Variables:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 2 0.5 2 0.5 ) 
					#label: 'Class Variables:' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 2 0 -30 1 -3 0.5 -2 1 ) 
					#name: #removeAllVariables 
					#model: #removeAllVariables 
					#label: 'Remove unreferenced variables' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -31 0.5 -2 1 -3 0.5 ) 
					#name: #removeInstVar 
					#model: #removeInstVar 
					#label: 'Remove variable' 
					#defaultable: true ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0.5 -1 0.5 0 1 1 0.5 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -30 1 -2 1 -2 1 ) 
					#name: #removeClassVar 
					#model: #removeClassVar 
					#label: 'Remove variable' 
					#defaultable: true ) ) ) )! !

LintRule subclass: #BasicLintRule
	instanceVariableNames: 'result openSymbol '
	classVariableNames: 'FilterDictionary '
	poolDictionaries: ''
	category: 'Refactory-Lint'!

BasicLintRule comment:
'BasicLintRule represents a check on the code.

Instance Variables:
	classBlock	<BlockClosure>	a block that is evaluated for each class that is checked
	methodBlock	<BlockClosure>	a block that is evaluated for each method checked
	result	<Object>	some object that represents the results found (it must understand openEditor, isEmpty, problemCount, and copyEmpty). Most of the time, this is a BrowserEnvironment object.

'!


!BasicLintRule methodsFor: 'initialize-release'!

initialize
	super initialize.
	openSymbol := #openWithFilters.
	self resultClass: self defaultResultClass!

openUsing: aSymbol 
	openSymbol := aSymbol!

resetResult
	result := result copyEmpty.
	result label: name!

result: aResult 
	result := aResult copyEmpty!

resultClass: aClass 
	result := aClass new! !

!BasicLintRule methodsFor: 'accessing'!

filteredResult
	^(result 
		& (self class filterDictionary at: self name
				ifAbsent: [RestrictedEnvironment new]) copy 
				not)
		label: result label;
		yourself!

problemCount
	^self result problemCount!

result
	^(self class filterDictionary includesKey: self name) 
		ifTrue: [self filteredResult]
		ifFalse: [result]! !

!BasicLintRule methodsFor: 'testing'!

isEmpty
	^self result isEmpty! !

!BasicLintRule methodsFor: 'private'!

defaultResultClass
	^RestrictedEnvironment!

openWithFilters
	| browser navigator menuItem |
	browser := self filteredResult openEditor.
	navigator := browser navigator.
	menuItem := MenuItem labeled: 'add filter for class'.
	menuItem value: 
			[(BasicLintRule filterFor: self name) addClass: navigator selectedClass.
			navigator environment andedEnvironment environment 
				addClass: navigator selectedClass.
			navigator updateCategoryList].
	navigator classMenu value addItemGroup: (Array with: menuItem).
	menuItem := MenuItem labeled: 'add filter for selector'.
	menuItem value: 
			[(BasicLintRule filterFor: self name) addClass: navigator selectedClass
				selector: navigator selector.
			navigator environment andedEnvironment environment 
				addClass: navigator selectedClass
				selector: navigator selector.
			navigator updateCategoryList].
	navigator selectorMenu value addItemGroup: (Array with: menuItem).
	navigator updateClassMenu.
	navigator updateSelectorMenu.
	^browser!

openWithoutFilters
	^self result openEditor!

viewResults
	^self perform: openSymbol! !

BasicLintRule class
	instanceVariableNames: ''!



!BasicLintRule class methodsFor: 'storing'!

storeFiltersOn: aStream 
	aStream
		nextPut: $(;
		nextPutAll: self name;
		nextPutAll: ' filterDictionary: (Dictionary new'.
	self filterDictionary keysAndValuesDo: 
			[:key :value | 
			aStream nextPutAll: ' at: '.
			key storeOn: aStream.
			aStream nextPutAll: ' put: '.
			value storeOn: aStream.
			aStream
				nextPutAll: ';';
				cr].
	aStream
		tab;
		nextPutAll: 'yourself))'! !

!BasicLintRule class methodsFor: 'accessing'!

addFilter: anEnvironment for: aString 
	self filterDictionary at: aString put: anEnvironment copy!

filterDictionary
	^FilterDictionary isNil 
		ifTrue: [FilterDictionary := Dictionary new]
		ifFalse: [FilterDictionary]!

filterDictionary: aDictionary 
	FilterDictionary := aDictionary!

filterFor: aName 
	^self filterDictionary at: aName ifAbsentPut: [RestrictedEnvironment new]!

protocols
	^#('bugs' 'possible bugs' 'unnecessary code' 'intention revealing' 'miscellaneous')! !

BasicLintRule subclass: #ParseTreeLintRule
	instanceVariableNames: 'matcher '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!ParseTreeLintRule methodsFor: 'initialize-release'!

matcher: aParseTreeMatcher
	matcher := aParseTreeMatcher!

resetResult
	result := ParseTreeEnvironment new.
	result
		label: self name;
		matcher: matcher! !

!ParseTreeLintRule methodsFor: 'accessing'!

checkMethod: aSmalllintContext 
	(matcher executeTree: aSmalllintContext parseTree initialAnswer: nil) notNil
		ifTrue: 
			[result addClass: aSmalllintContext selectedClass
				selector: aSmalllintContext selector]! !

!ParseTreeLintRule methodsFor: 'private'!

defaultResultClass
	^ParseTreeEnvironment! !

ParseTreeLintRule class
	instanceVariableNames: ''!



!ParseTreeLintRule class methodsFor: 'miscellaneous'!

assignmentInBlock
	^self createParseTreeRule: #(
			'`@cursor showWhile: [| `@temps | `@.Statements1. `var := `@object]' 
			'`@cursor showWhile: [| `@temps | `@.Statements1. ^`@object]' 
			'[| `@temps | `@.Statements. `var := `@object] valueNowOrOnUnwindDo: `@block' 
			'[| `@temps | `@.Statements. ^`@object] valueNowOrOnUnwindDo: `@block' 
			'[| `@temps | `@.Statements. `var := `@object] valueOnUnwindDo: `@block' 
			'[| `@temps | `@.Statements. ^`@object] valueOnUnwindDo: `@block' 
			'[| `@temps | `@.Statements. `var := `@object] ensure: `@block' 
			'[| `@temps | `@.Statements. ^`@object] ensure: `@block' 
			'[| `@temps | `@.Statements. `var := `@object] ifCurtailed: `@block' 
			'[| `@temps | `@.Statements. ^`@object] ifCurtailed: `@block' ) 
		name: 'Unnecessary assignment or return in block'!

ifTrueBlocks
	| detector matcher |
	detector := self new.
	detector name: 'Non-blocks in ifTrue:/ifFalse: messages'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: 
			#('``@condition ifTrue: ``@block' '``@condition ifFalse: ``@block' 
			'``@condition ifTrue: ``@block1 ifFalse: ``@block2'
			'``@condition ifFalse: ``@block1 ifTrue: ``@block2')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[(aNode arguments detect: [:each | each isBlock not] ifNone: [nil]) notNil 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

precedence
	| detector matcher |
	detector := self new.
	detector name: 'Inspect instances of "A + B * C" might be "A + (B * C)"'.
	matcher := ParseTreeSearcher new.
	matcher matchesAnyOf: #('``@A + ``@B * ``@C' '``@A - ``@B * ``@C')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: [aNode receiver hasParentheses ifTrue: [nil] ifFalse: [aNode]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

stringConcatenation
	| detector matcher concatenationMatcher |
	detector := self new.
	detector name: 'String concatenation instead of streams'.
	matcher := ParseTreeSearcher new.
	concatenationMatcher := ParseTreeSearcher new.
	concatenationMatcher matches: '`@receiver , `@argument'
		do: [:aNode :answer | true].
	matcher 
		matchesAnyOf: 
			#('``@collection do: [:`each | | `@temps | ``@.Statements]' 
			'``@collection do: [:`each | | `@temps | ``@.Statements] separatedBy: [| `@temps1 | ``@.Statements1]' 
			'``@number to: ``@endNumber do: [:`i | | `@temps | ``@.Statements]' 
			'``@collection detect: [:`each | | `@temps | ``@.Statements]' 
			'``@collection detect: [:`each | | `@temps | ``@.Statements] ifNone: [| `@temps1 | ``@.Statements1]' 
			'``@collection select: [:`each | | `@temps | ``@.Statements]' 
			'``@collection inject: ``@value into: [:`each | | `@temps | ``@.Statements]')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[(aNode arguments detect: 
							[:each | 
							each isBlock 
								and: [concatenationMatcher executeTree: each initialAnswer: false]]
						ifNone: [nil]) notNil 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

yourselfNotUsed
	| detector addSearcher |
	detector := self new.
	detector name: 'Doesn''t use the result of a yourself message'.
	addSearcher := ParseTreeSearcher new.
	addSearcher matches: '`@object yourself'
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: [aNode isUsed ifTrue: [nil] ifFalse: [aNode]]
				ifFalse: [answer]].
	detector matcher: addSearcher.
	^detector! !

!ParseTreeLintRule class methodsFor: 'possible bugs'!

equalNotUsed
	| detector matcher |
	detector := self new.
	detector name: 'Doesn''t use the result of a =, ~=, etc.'.
	matcher := ParseTreeSearcher new.
	matcher matchesAnyOf: #('``@rcv `msg: ``@arg')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[(aNode isUsed 
						or: [(#(#= #== #~= #~~ #< #> #<= #>=) includes: aNode selector) not]) 
							ifTrue: [nil]
							ifFalse: [aNode]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

fileBlocks
	^self createParseTreeRule: 
				#('[| `@temps | 
					`var := `@object.  
					`@.statements] 
							valueNowOrOnUnwindDo: 
								[`var `@messages: `@args]' 
				'[| `@temps | 
					`var := `@object.  
					`@.statements] 
							valueOnUnwindDo: 
								[`var `@messages: `@args]'
				'[| `@temps | 
					`var := `@object.  
					`@.statements] 
							ensure: 
								[`var `@messages: `@args]' 
				'[| `@temps | 
					`var := `@object.  
					`@.statements] 
							ifCurtailed: 
								[`var `@messages: `@args]') 
		name: 'Assignment inside unwind blocks should be outside.'!

missingYourself
	| detector matcher |
	detector := self new.
	detector name: 'Possible missing "; yourself"'.
	matcher := ParseTreeSearcher new.
	matcher matches: '``@xobject `@messages: ``@args'
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[(aNode parent isCascade 
						and: [aNode isDirectlyUsed and: [aNode selector ~~ #yourself]]) 
							ifTrue: [aNode]
							ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

modifiesCollection
	| detector matcher |
	detector := self new.
	detector name: 'Modifies collection while iterating over it'.
	matcher := (ParseTreeSearcher new)
				matchesAnyOf: 
						#('`@object do: [:`each | | `@temps | ``@.Statements]' 
						'`@object collect: [:`each | | `@temps | ``@.Statements]' 
						'`@object select: [:`each | | `@temps | ``@.Statements]' 
						'`@object reject: [:`each | | `@temps | ``@.Statements]' 
						'`@object inject: `@value into: [:`sum :`each | | `@temps | ``@.Statements]')
					do: 
						[:aNode :answer | 
						answer isNil 
							ifTrue: 
								[(self modifiesTree: aNode receiver in: aNode arguments last) 
									ifTrue: [aNode]
									ifFalse: [nil]]
							ifFalse: [answer]];
				yourself.
	detector matcher: matcher.
	^detector!

returnsIfTrue
	^self createParseTreeRule: 
				#('^`@condition ifTrue: [| `@temps | `@.statements]' 
				'^`@condition ifFalse: [| `@temps | `@.statements]') 
		name: 'Returns value of ifTrue:/ifFalse: without ifFalse:/ifTrue: block'!

threeElementPoint
	| detector matcher |
	detector := self new.
	detector name: 'Possible three element point (e.g., x @ y + q @ r)'.
	matcher := (ParseTreeSearcher new)
				matches: '``@x @ ``@y'
					do: 
						[:aNode :answer | 
						answer isNil 
							ifTrue: 
								[| current |
								current := aNode parent.
								
								[current isNil or: 
										[current isMessage 
											and: [current selector == #@ or: [current selector isInfix not]]]] 
										whileFalse: [current := current parent].
								(current isNil or: [current isMessage and: [current selector isInfix not]]) 
									ifTrue: [nil]
									ifFalse: [aNode]]
							ifFalse: [answer]];
				yourself.
	detector matcher: matcher.
	^detector!

usesAdd
	| detector matcher |
	detector := self new.
	detector name: 'Uses the result of an add: message'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: #('``@object add: ``@object1' '``@object addAll: ``@object1')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: [aNode isDirectlyUsed ifTrue: [aNode] ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector! !

!ParseTreeLintRule class methodsFor: 'intention revealing'!

assignmentInIfTrue
	^self createParseTreeRule: 
			#('`@boolean 
					ifTrue: [| `@temps1 | `@.Statements1. `var := `@object1] 
					ifFalse: [| `@temps2 | `@.Statements2. `var := `@object2]' 
			'`@boolean 
					ifFalse: [| `@temps1 | `@.Statements1. `var := `@object1] 
					ifTrue: [| `@temps2 | `@.Statements2. `var := `@object2]') 
		name: 'Assignment to same variable and end of ifTrue:ifFalse: blocks'!

atIfAbsent
	^self createParseTreeRule: 
				#('`@object 
						at: `@atArg 
						ifAbsent: [| `@temps | `@.Statements. `@object at: `@atArg put: `@putArg]' 
				'`@object 
						at: `@atArg 
						ifAbsent: [| `@temps | 
								`@.Statements. 
								`@object at: `@atArg put: `@putArg. 
								`@.xStatements1. 
								`@putArg]') 
		name: 'Uses at:ifAbsent: instead of at:ifAbsentPut:'!

collectionMessagesToExternalObject
	| detector matcher |
	detector := self new.
	detector name: 'Sends add:/remove: to external collection'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: (#(#add: #remove: #addAll: #removeAll:) collect: 
					[:each | 
					('(`@Object `@message: `@args) <1s> `@Arg' expandMacrosWith: each) 
						asString])
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[((aNode receiver selector copyFrom: 1
						to: (aNode receiver selector size min: 2)) ~= 'as' 
						and: 
							[| receiver |
							receiver := aNode receiver receiver.
							receiver isVariable not or: 
									[((#('self' 'super') includes: receiver name) 
										or: [Smalltalk includesKey: receiver name asSymbol]) not]]) 
							ifTrue: [aNode]
							ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

collectionProtocol
	^self createParseTreeRule: 
			#('`@collection do: [:`each | | `@temps | `@.Statements1. `@object add: `@arg. `@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifTrue: [| `@blockTemps | 
							`@.BlockStatements1. 
							`@object add: `each. 
							`@.BlockStatements2]. 
					`@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifFalse: [| `@blockTemps | 
							`@.BlockStatements1. 
							`@object add: `each. 
							`@.BlockStatements2]. 
					`@.Statements2]') 
		name: 'Uses do: instead of collect: or select:''s'!

collectSelectNotUsed
	| detector matcher |
	detector := self new.
	detector name: 'Doesn''t use the result of a collect:/select:'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: #('``@collection select: ``@block' '``@collection collect: ``@block' '``@collection reject: ``@block')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: [aNode isUsed ifTrue: [nil] ifFalse: [aNode]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

consistencyCheck
	^self createParseTreeRule: 
				#('`@object size == 0' 
				'`@object size = 0' 
				'`@object size > 0' 
				'`@object size >= 1' 
				'`@object == nil' 
				'`@object = nil'
				'`@collection at: 1'
				'`@collection at: `@collection size') 
		name: 'Uses "size = 0", "= nil",  or "at: 1" instead of "isEmpty",  "isNil", or "first"'!

contains
	^self createParseTreeRule: 
			#('(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) isNil' 
			'(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) notNil' 
			'(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) = nil' 
			'(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) == nil' 
			'(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) ~= nil' 
			'(`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [nil]) ~~ nil' 
			'`@object detect: [:`each | | `@temps| `@.Statements] ifNone: [| `@temps1 | `@.Statements2. ^`@anything]') 
		name: 'Uses detect:ifNone: instead of contains:'!

detectContains
	^self createParseTreeRule: 
			#('`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifFalse: [| `@BlockTemps | `@.BlockStatements1. ^`each]. 
					`@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifTrue: [| `@BlockTemps | `@.BlockStatements1.  ^`each]. 
					`@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifFalse: [| `@BlockTemps | `@.BlockStatements1. ^true]. 
					`@.Statements2]' 
			'`@Collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifTrue: [| `@BlockTemps | `@.BlockStatements1.  ^true]. 
					`@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifFalse: [| `@BlockTemps | `@.BlockStatements1. ^false]. 
					`@.Statements2]' 
			'`@collection do: [:`each | | `@temps | 
					`@.Statements1. 
					`@condition ifTrue: [| `@BlockTemps | `@.BlockStatements1.  ^false]. 
					`@.Statements2]') 
		name: 'Uses do: instead of contains: or detect:''s'!

guardingClause
	| detector matcher |
	detector := self new.
	detector name: 'Guarding clauses'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyMethodOf: 	
			#('`@MethodName: `@args 
					| `@temps | 
					`@.Statements. 
					`@condition ifTrue: [| `@BlockTemps | `.Statement1. `.Statement2. `@.BStatements]' 
			'`@MethodName: `@args 
					| `@temps | 
					`@.Statements. 
					`@condition ifFalse: [| `@BlockTemps | `.Statement1. `.Statement2. `@.BStatements]')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[aNode body statements last]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

ifTrueReturns
	| detector matcher |
	detector := self new.
	detector name: 'ifTrue:/ifFalse: returns instead of and:/or:''s'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: 
			#('| `@temps | ``@.Statements. ``@object ifTrue: [^``@value1]. ^``@value2' 
			'| `@temps | ``@.Statements. ``@object ifFalse: [^``@value1]. ^``@value2')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[| node |
					node := (aNode statements at: aNode statements size - 1) arguments first 
								body statements 
								last value.	"``@value1"
					((node isLiteral and: [#(true false) includes: node value]) or: 
							[node := aNode statements last value.
							node isLiteral and: [#(true false) includes: node value]]) 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

literalArrayCharacters
	| detector matcher |
	detector := self new.
	detector name: 'Literal array contains only characters'.
	matcher := ParseTreeSearcher new.
	matcher matches: '`#literal'
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[(aNode value class == Array and: [self isArrayOfCharacters: aNode value]) 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

minMax
	| detector matcher |
	detector := self new.
	detector name: 'Uses ifTrue:/ifFalse: instead of min: or max:'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: #('(`x `message: `@y) `ifTrue: [`x := `@y]' '(`@x `message: `@y) `ifTrue: [`@x] `ifFalse: [`@y]' '(`@x `message: `@y) `ifTrue: [`v := `@x] `ifFalse: [`v := `@y]')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[((#(#ifTrue: #ifFalse: #ifTrue:ifFalse: #ifFalse:ifTrue:) 
						includes: aNode selector) 
							and: [#(#< #<= #> #>=) includes: aNode receiver selector]) 
							ifTrue: [aNode]
							ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

searchingLiteral
	| detector matcher |
	detector := self new.
	detector name: 'Uses or''s instead of a searching literal'.
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyOf: #('``@object = `#literal or: [``@expression]' 
						'``@object == `#literal or: [``@expression]' 
						'`#literal = ``@object or: [``@expression]' 
						'`#literal == ``@object or: [``@expression]' 
						'``@expression | ``@object = `#literal' 
						'``@expression | ``@object == `#literal' 
						'``@expression | `#literal = ``@object' 
						'``@expression | `#literal == ``@object')
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[| expression |
					expression := aNode receiver receiver isLiteral 
								ifTrue: [aNode receiver arguments first]
								ifFalse: [aNode receiver receiver].
					(self isSearchingLiteralExpression: aNode for: expression) 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

sizeCheck
	^self createParseTreeRule: (#(#do: #collect: #reject: #select:) collect: 
					[:each | 
					'`@object size > 0 ifTrue: [`@object ' , each
						, ' [:`each | | `@temps | `@.Statements1]. `@.Statements2]'])
				, (#(#do: #collect: #reject: #select:) collect: 
							[:each | 
							'`@object isEmpty ifFalse: [`@object ' , each
								, ' [:`each | | `@temps | `@.Statements1]. `@.Statements2]'])
		name: 'Unnecessary size check'!

toDo
	| detector matcher |
	detector := self new.
	detector name: 'Uses to:do: instead of do:, with:do: or timesRepeat:'.
	matcher := ParseTreeSearcher new.
	matcher 
		matches: '1 to: ``@object size do: [:`each | | `@temps | `@.Statements]'
		do: 
			[:aNode :answer | 
			answer isNil 
				ifTrue: 
					[| varName variableMatcher |
					varName := aNode arguments last arguments first.	"`each"
					variableMatcher := ParseTreeSearcher new.
					variableMatcher matchesTree: varName
						do: [:node :ans | ans and: [node parent isMessage and: [node parent selector == #at:]]].
					(variableMatcher executeTree: aNode arguments last body initialAnswer: true) 
						ifTrue: [aNode]
						ifFalse: [nil]]
				ifFalse: [answer]].
	detector matcher: matcher.
	^detector!

whileTrue
	^self createParseTreeRule: 
			#('| `@temps | 
				`@.Statements1. 
				[`index <= `@stop] 
					whileTrue: 
						[| `@blockTemps | 
						`@.BlockStmts1. 
						`index := `index + 1].
				`@.Statements2' 
			'| `@temps | 
				`@.Statements1. 
				[`index < `@stop] 
					whileTrue: 
						[| `@blockTemps | 
						`@.BlockStmts1. 
						`index := `index + 1].
				`@.Statements2'
			'| `@temps | 
				`@.Statements1. 
				[`index >= `@stop] 
					whileTrue: 
						[| `@blockTemps | 
						`@.BlockStmts1. 
						`index := `index - 1].
				`@.Statements2' 
			'| `@temps | 
				`@.Statements1. 
				[`index > `@stop] 
					whileTrue: 
						[| `@blockTemps | 
						`@.BlockStmts1. 
						`index := `index - 1].
				`@.Statements2') 
		name: 'Uses whileTrue: instead of to:do:'! !

!ParseTreeLintRule class methodsFor: 'unnecessary code'!

endTrueFalse
	| detector matcher |
	detector := self new.
	detector 
		name: 'Check for same statements at end of ifTrue:ifFalse: blocks'.
	matcher := (ParseTreeSearcher new)
				matchesAnyOf: 	
					#('`@object 
								ifTrue: [| `@temps1 | `@.Statements1. `.Statement] 
								ifFalse: [| `@temps2 | `@.Statements2. `.Statement]' 
						'`@object 
								ifTrue: [| `@temps1 | `.Statement. `@.Statements1] 
								ifFalse: [| `@temps2 | `.Statement. `@.Statements2]' 
						'`@object 
								ifFalse: [| `@temps1 | `@.Statements1. `.Statement] 
								ifTrue: [| `@temps2 | `@.Statements2. `.Statement]' 
						'`@object 
								ifFalse: [| `@temps1 | `.Statement. `@.Statements1] 
								ifTrue: [| `@temps2 | `.Statement. `@.Statement2]') 
					do: 
						[:aNode :answer | 
						answer isNil 
							ifTrue: 
								[| node |
								node := aNode arguments first body statements last.
								(node isVariable and: [node = aNode arguments last body statements last]) 
									ifTrue: [nil]
									ifFalse: [aNode]]
							ifFalse: [answer]];
				yourself.
	detector matcher: matcher.
	^detector!

equalsTrue
	| detector matcher |
	detector := self new.
	detector name: 'Unnecessary "= true"'.
	matcher := (ParseTreeSearcher new)
				matchesAnyOf: #('true' 'false')
					do: 
						[:aNode :answer | 
						answer isNil 
							ifTrue: 
								[(aNode parent isMessage 
									and: [#(#= #== #~= #~~) includes: aNode parent selector]) 
										ifTrue: [aNode]
										ifFalse: [nil]]
							ifFalse: [answer]];
				yourself.
	detector matcher: matcher.
	^detector!

extraBlock
	| detector matcher |
	detector := self new.
	detector name: 'Block immediately evaluated'.
	matcher := (ParseTreeSearcher new)
				matchesAnyOf: (#('value' 'value: `@value' 'value: `@value1 value: `@value2' 'value: `@value1 value: `value2 value: `@value3' 'valueWithArguments: `@values') 
							collect: [:each | '[:`@params | | `@temps | `@.statements] ' , each])
					do: 
						[:aNode :answer | 
						answer isNil 
							ifTrue: [aNode parent isCascade ifTrue: [nil] ifFalse: [aNode]]
							ifFalse: [answer]];
				yourself.
	detector matcher: matcher.
	^detector! !

!ParseTreeLintRule class methodsFor: 'instance creation'!

createParseTreeRule: codeStrings method: aBoolean name: aName 
	^(self new)
		name: aName;
		matcher: (self createMatcherFor: codeStrings method: aBoolean);
		yourself!

createParseTreeRule: codeStrings name: aName 
	^self 
		createParseTreeRule: codeStrings
		method: false
		name: aName! !

!ParseTreeLintRule class methodsFor: 'private'!

createMatcherFor: codeStrings method: aBoolean 
	| matcher |
	matcher := ParseTreeSearcher new.
	aBoolean 
		ifTrue: [matcher matchesAnyMethodOf: codeStrings do: [:aNode :answer | aNode]]
		ifFalse: [matcher matchesAnyOf: codeStrings do: [:aNode :answer | aNode]].
	^matcher!

isArrayOfCharacters: anArray 
	anArray isEmpty ifTrue: [^false].
	1 to: anArray size
		do: [:each | (anArray at: each) class == Character ifFalse: [^false]].
	^true!

isSearchingLiteralExpression: aSearchingNode for: anObjectNode 
	aSearchingNode isSequence 
		ifTrue: 
			[^aSearchingNode statements size == 1 and: 
					[self isSearchingLiteralExpression: aSearchingNode statements first
						for: anObjectNode]].
	aSearchingNode isMessage ifFalse: [^false].
	(#(#= #==) includes: aSearchingNode selector) 
		ifTrue: 
			[^(aSearchingNode receiver = anObjectNode 
				and: [aSearchingNode arguments first isLiteral]) or: 
						[aSearchingNode arguments first = anObjectNode 
							and: [aSearchingNode receiver isLiteral]]].
	(#(#| #or:) includes: aSearchingNode selector) ifFalse: [^false].
	^(self isSearchingLiteralExpression: aSearchingNode receiver
		for: anObjectNode) and: 
				[self 
					isSearchingLiteralExpression: (aSearchingNode arguments first isBlock 
							ifTrue: [aSearchingNode arguments first body statements last]
							ifFalse: [aSearchingNode arguments first])
					for: anObjectNode]!

modifiesTree: aCollectionTree in: aParseTree 
	| notifier args |
	notifier := ParseTreeSearcher new.
	args := Array with: (BRVariableNode named: '`@object').
	notifier 
		matchesAnyTreeOf: (#(#add: #addAll: #remove: #removeAll:) collect: 
					[:each | 
					BRMessageNode 
						receiver: aCollectionTree
						selector: each
						arguments: args])
		do: [:aNode :answer | true].
	^notifier executeTree: aParseTree initialAnswer: false! !

!ParseTreeLintRule class methodsFor: 'bugs'!

booleanPrecedence
	^self createParseTreeRule: 
			#('`@object1 | `@object2 = `@object3'
			'`@object1 | `@object2 == `@object3'
			'`@object1 & `@object2 = `@object3'
			'`@object1 & `@object2 == `@object3'
			'`@object1 | `@object2 ~= `@object3'
			'`@object1 | `@object2 ~~ `@object3'
			'`@object1 & `@object2 ~= `@object3'
			'`@object1 & `@object2 ~~ `@object3')
		name: 'Uses A | B = C instead of A | (B = C)'! !

BasicLintRule subclass: #BlockLintRule
	instanceVariableNames: 'classBlock methodBlock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!BlockLintRule methodsFor: 'initialize-release'!

classBlock: aBlock
	classBlock := aBlock!

initialize
	super initialize.
	classBlock := [:context :aResult | ].
	methodBlock := [:context :aResult | ]!

methodBlock: aBlock
	methodBlock := aBlock! !

!BlockLintRule methodsFor: 'accessing'!

checkClass: aSmalllintContext 
	^classBlock value: aSmalllintContext value: result!

checkMethod: aSmalllintContext 
	^methodBlock value: aSmalllintContext value: result! !

BlockLintRule class
	instanceVariableNames: ''!



!BlockLintRule class methodsFor: 'possible bugs'!

abstractClass
	| detector subclassResponsibilitySymbol |
	detector := self new.
	detector name: 'References an abstract class'.
	detector resultClass: ClassEnvironment.
	subclassResponsibilitySymbol := 'subclassResponsibility' asSymbol.
	detector classBlock: 
			[:context :result | 
			(context selectedClass whichSelectorsReferTo: subclassResponsibilitySymbol)
				isEmpty ifFalse: 
						[(context
							uses: (Smalltalk associationAt: context selectedClass name ifAbsent: [nil]))
								ifTrue: [result addClass: context selectedClass]]].
	^detector!

addRemoveDependents
	| detector |
	detector := self new.
	detector resultClass: ClassEnvironment.
	detector name: 'Number of addDependent: messages > removeDependent:'.
	detector classBlock: 
			[:context :result | 
			| count |
			count := 0.
			((Set
				withAll: (context selectedClass whichSelectorsReferTo: #addDependent:))
					addAll: (context selectedClass whichSelectorsReferTo: #removeDependent:);
				yourself) do: 
					[:sel | 
					(context selectedClass compiledMethodAt: sel) messagesDo: 
							[:each | 
							each == #addDependent: ifTrue: [count := count + 1].
							each == #removeDependent: ifTrue: [count := count - 1]]].
			count > 0 ifTrue: [result addClass: context selectedClass]].
	^detector!

classInstVarNotInitialized
	| detector |
	detector := self new.
	detector name: 'Has class instance variables but no initialize method'.
	detector resultClass: ClassEnvironment.
	detector classBlock: 
		[:context :result | 
		| definesVar class |
		context selectedClass isMeta
			ifTrue: 
				[class := context selectedClass.
				definesVar := false.
				[definesVar or: [class isNil or: [class isMeta not]]]
					whileFalse: 
						[definesVar := class instVarNames isEmpty not.
						class := class superclass].
				(definesVar and: [(context selectedClass includesSelector: #initialize) not])
					ifTrue: [result addClass: context selectedClass]]].
	^detector!

collectionCopyEmpty
	| detector |
	detector := self new.
	detector
		name: 'Subclass of collection that has instance variable but doesn''t define copyEmpty'.
	detector resultClass: ClassEnvironment.
	detector classBlock: 
			[:context :result | 
			(context selectedClass isVariable 
					and: [(context selectedClass includesSelector: #copyEmpty:) not 
						and: [context selectedClass instVarNames isEmpty not
							and: [context selectedClass inheritsFrom: Collection]]])
				ifTrue: [result addClass: context selectedClass]].
	^detector!

definesEqualNotHash
	| detector |
	detector := self new.
	detector name: 'Defines = but not hash'.
	detector resultClass: ClassEnvironment.
	detector classBlock: 
			[:context :result | 
			((context selectedClass includesSelector: #=)
				and: [(context selectedClass includesSelector: #hash) not])
				ifTrue: [result addClass: context selectedClass]].
	^detector!

returnsBooleanAndOther
	| detector matcher |
	detector := self new.
	detector name: 'Returns a boolean and non boolean'.
	matcher := ParseTreeSearcher new.
	matcher matches: '^``@xObject'
		do: 
			[:aNode :answer | 
			answer
				add: aNode value;
				yourself].
	detector methodBlock: 
			[:context :result | 
			| hasBool hasSelf |
			hasBool := false.
			hasSelf := context parseTree lastIsReturn not.
			(matcher executeTree: context parseTree initialAnswer: Set new) do: 
					[:each | 
					hasBool := hasBool or: 
									[(each isLiteral and: [#(true false) includes: each value]) 
										or: [each isMessage and: [#(#and: #or:) includes: each selector]]].
					hasSelf := hasSelf or: 
									[(each isVariable and: [each name = 'self']) 
										or: [each isLiteral and: [(#(true false) includes: each value) not]]]].
			hasSelf & hasBool 
				ifTrue: [result addClass: context selectedClass selector: context selector]].
	^detector!

sendsDifferentSuper
	| detector |
	detector := self new.
	detector name: 'Sends different super message'.
	detector methodBlock: 
			[:context :result | 
			| message |
			(message := context superMessages detect: [:each | each ~= context selector]
						ifNone: [nil]) notNil ifTrue: 
					[result addSearchString: message.
					result addClass: context selectedClass selector: context selector]].
	^detector!

superSends
	| detector |
	detector := self new.
	detector name: 'Missing super sends'.
	detector methodBlock: 
			[:context :result | 
			(context selectedClass isMeta not
				and: [self superMessages includes: context selector]) ifTrue: 
						[(context selectedClass superclass notNil
							and: [context selectedClass superclass canUnderstand: context selector])
								ifTrue: 
									[(context superMessages includes: context selector)
										ifFalse: [result addClass: context selectedClass selector: context selector]]]].
	^detector!

tempsReadBeforeWritten
	| detector |
	detector := self new.
	detector name: 'Temporaries read before written'.
	detector methodBlock: 
			[:context :result | 
			(BRReadBeforeWrittenTester variablesReadBeforeWrittenIn: context parseTree) 
				do: 
					[:each | 
					result addClass: context selectedClass selector: context selector.
					result addSearchString: each]].
	^detector!

tempVarOverridesInstVar
	| detector matcher vars varName |
	detector := self new.
	detector name: 'Instance variable overridden by temporary variable'.
	matcher := (ParseTreeSearcher new)
				matchesArgument: '`xxxvar'
					do: 
						[:aNode :answer | 
						answer or: 
								[varName := aNode name.
								vars includes: varName]];
				yourself.
	detector methodBlock: 
			[:context :result | 
			vars := context instVarNames.
			(matcher executeTree: context parseTree initialAnswer: false) 
				ifTrue: 
					[result addClass: context selectedClass selector: context selector.
					result addSearchString: varName]].
	^detector! !

!BlockLintRule class methodsFor: 'miscellaneous'!

badMessage
	| detector badMessages |
	detector := self new.
	detector name: 'Sends "questionable" message'.
	badMessages := self badSelectors.
	detector classBlock: 
			[:context :result | 
			| selectors |
			selectors := badMessages inject: Set new
						into: 
							[:set :each | 
							set addAll: (context selectedClass whichSelectorsReferTo: each);
								yourself].
			selectors do: [:each | result addClass: context selectedClass selector: each].
			selectors isEmpty ifFalse: [result searchStrings: badMessages]].
	^detector!

classNameInSelector
	| detector |
	detector := self new.
	detector name: 'Redundant class name in selector'.
	detector methodBlock: 
			[:context :result | 
			(context selectedClass isMeta and: 
					[(context selector
						indexOfSubCollection: context selectedClass soleInstance name
						startingAt: 1) > 0])
				ifTrue: [result addClass: context selectedClass selector: context selector]].
	^detector!

fullBlocks
	| detector |
	detector := self new.
	detector name: 'Method with full blocks'.
	detector methodBlock: 
			[:context :result | 
			context compiledMethod withAllBlockMethodsDo: 
					[:method | 
					method needsHybridFrame
						ifTrue: [result addClass: context selectedClass selector: context selector]]].
	^detector!

instVarInSubclasses
	| detector |
	detector := self new.
	detector
		name: 'Instance variables defined in all subclasses';
		result: UnreferencedVariables pullUpInstVar;
		openUsing: #openWithoutFilters.
	detector classBlock: 
			[:context :result | 
			| subs |
			subs := context selectedClass subclasses.
			subs size > 1 
				ifTrue: 
					[| sels |
					sels := Bag new.
					subs do: [:each | sels addAll: each instVarNames].
					sels asSet do: 
							[:val | 
							| count |
							count := sels occurrencesOf: val.
							count == subs size 
								ifTrue: [result addInstVar: val for: context selectedClass]]]].
	^detector!

longMethods
	| detector matcher |
	detector := self new.
	detector name: 'Long methods'.
	matcher := ParseTreeSearcher new.
	matcher matches: '`.Stmt'
		do: 
			[:aNode :answer | 
			(aNode children inject: answer
				into: [:sum :each | matcher executeTree: each initialAnswer: sum]) + 1].
	detector methodBlock: 
			[:context :result | 
			(matcher executeTree: context parseTree initialAnswer: 0) 
				>= self longMethodSize 
					ifTrue: [result addClass: context selectedClass selector: context selector]].
	^detector!

refersToClass
	| detector |
	detector := self new.
	detector name: 'Refers to class name instead of "self class"'.
	detector classBlock: 
			[:context :result | 
			| sels className |
			className := (context selectedClass isMeta
						ifTrue: [context selectedClass soleInstance]
						ifFalse: [context selectedClass]) name.
			sels := context selectedClass
						whichSelectorsReferTo: (Smalltalk associationAt: className).
			sels do: [:each | result addClass: context selectedClass selector: each].
			sels isEmpty ifFalse: [result addSearchString: className]].
	^detector!

utilityMethods
	| detector |
	detector := self new.
	detector name: 'Utility methods'.
	detector methodBlock: 
			[:context :result | 
			(context selectedClass isMeta | (context selector numArgs == 0) or: 
					[(context protocols detect: 
							[:each | 
							(self utilityProtocols detect: [:protocol | protocol match: each]
								ifNone: [nil]) notNil]
						ifNone: [nil]) notNil]) 
				ifFalse: 
					[(self subclassOf: context selectedClass overrides: context selector) 
						ifFalse: 
							[(context superMessages isEmpty and: [context selfMessages isEmpty]) 
								ifTrue: 
									[(context selectedClass allInstVarNames 
										, context selectedClass allClassVarNames asArray , #('self') 
										detect: [:each | context parseTree references: each]
										ifNone: [nil]) isNil 
										ifTrue: [result addClass: context selectedClass selector: context selector]]]]].
	^detector!

variableAssignedLiteral
	| detector |
	detector := self new.
	detector
		name: 'Variable is only assigned a single literal value';
		result: UnreferencedVariables references;
		openUsing: #openWithoutFilters.
	detector classBlock: 
			[:context :result | 
			| allSubclasses |
			allSubclasses := context selectedClass withAllSubclasses.
			context selectedClass instVarNames do: 
					[:each | 
					| defClass selector |
					(allSubclasses inject: 0
						into: 
							[:sum :class | 
							| sels |
							sels := class whichSelectorsWrite: each.
							sels size == 1 
								ifTrue: 
									[selector := sels asArray first.
									defClass := class].
							sum + sels size]) 
							== 1 
							ifTrue: 
								[| tree searcher |
								searcher := ParseTreeSearcher new.
								searcher matches: each , ' := ``@object'
									do: [:aNode :answer | answer isNil and: [aNode value isLiteral]].
								tree := defClass parseTreeFor: selector.
								tree notNil 
									ifTrue: 
										[(searcher executeTree: tree initialAnswer: nil) == true 
											ifTrue: [result addInstVar: each for: context selectedClass]]]]].
	^detector! !

!BlockLintRule class methodsFor: 'private'!

badSelectors
	^#(#become: #isKindOf: #changeClassToThatOf: #respondsTo: #isMemberOf: #performMethod: #performMethod:arguments: #performMethod:with: #performMethod:with:with: #performMethod:with:with:with: #allOwners #allOwnersWeakly: #firstOwner #instVarAt: #instVarAt:put: #nextInstance #nextObject #ownerAfter: #primBecome:  #halt)!

classShouldNotOverride
	^#(#== #class)!

longMethodSize
	^10!

metaclassShouldNotOverride
	^#(#name #comment)!

subclassOf: aClass overrides: aSelector 
	^(aClass subclasses detect: 
			[:each | 
			(each includesSelector: aSelector)
				or: [self subclassOf: each overrides: aSelector]]
		ifNone: [nil]) notNil!

superMessages
	^#(#release #postCopy #postBuildWith: #preBuildWith: #postOpenWith: #noticeOfWindowClose: #initialize)!

utilityProtocols
	"If a method is defined in one of these protocols, then don't check if its a utility method."

	^#('*utilit*')! !

!BlockLintRule class methodsFor: 'unnecessary code'!

classNotReferenced
	| detector |
	detector := self new.
	detector name: 'Class not referenced'.
	detector resultClass: ClassEnvironment.
	detector classBlock: 
			[:context :result | 
			(context selectedClass isMeta
				or: [context selectedClass subclasses isEmpty not])
					ifFalse: 
						[| assoc |
						assoc := Smalltalk associationAt: context selectedClass name.
						((context uses: assoc) or: [context uses: context selectedClass name])
							ifFalse: 
								[result addClass: context selectedClass;
									addClass: context selectedClass class]]].
	^detector!

equivalentSuperclassMethods
	| detector |
	detector := self new.
	detector name: 'Methods equivalently defined in superclass'.
	detector methodBlock: 
			[:context :result | 
			context selectedClass superclass notNil ifTrue: 
					[(context selectedClass superclass canUnderstand: context selector)
						ifTrue: 
							[(((context selectedClass superclass
								whichClassIncludesSelector: context selector)
									compiledMethodAt: context selector)
									equivalentTo: context compiledMethod)
									ifTrue: [result addClass: context selectedClass selector: context selector]]]].
	^detector!

implementedNotSent
	| detector |
	detector := self new.
	detector name: 'Methods implemented but not sent'.
	detector methodBlock: 
			[:context :result | 
			(context uses: context selector)
				ifFalse: [result addClass: context selectedClass selector: context selector]].
	^detector!

justSendsSuper
	| detector matcher |
	detector := self new.
	detector name: 'Method just sends super message'.
	matcher := ParseTreeSearcher justSendsSuper.
	detector methodBlock: 
			[:context :result | 
			(context parseTree isPrimitive not 
				and: [matcher executeMethod: context parseTree initialAnswer: false]) 
					ifTrue: [result addClass: context selectedClass selector: context selector]].
	^detector!

onlyReadOrWritten
	| detector |
	detector := self new.
	detector
		name: 'Instance variables not read AND written';
		result: UnreferencedVariables references;
		openUsing: #openWithoutFilters.
	detector classBlock: 
			[:context :result | 
			| allSubclasses |
			allSubclasses := context selectedClass withAllSubclasses.
			context selectedClass instVarNames do: 
					[:each | 
					| isRead isWritten |
					isRead := false.
					isWritten := false.
					allSubclasses detect: 
							[:class | 
							isRead ifFalse: [isRead := (class whichSelectorsRead: each) isEmpty not].
							isWritten 
								ifFalse: [isWritten := (class whichSelectorsWrite: each) isEmpty not].
							isRead & isWritten]
						ifNone: [result addInstVar: each for: context selectedClass]]].
	^detector!

unreferencedVariables
	| detector |
	detector := self new.
	detector
		name: 'Variables not referenced';
		result: UnreferencedVariables unreferenced;
		openUsing: #openWithoutFilters.
	detector classBlock: 
			[:context :result | 
			| allSubclasses |
			allSubclasses := context selectedClass withAllSubclasses.
			context selectedClass instVarNames do: 
					[:each | 
					allSubclasses 
						detect: [:class | (class whichSelectorsAccess: each) isEmpty not]
						ifNone: [result addInstVar: each for: context selectedClass]].
			context selectedClass isMeta 
				ifFalse: 
					[context selectedClass classPool associationsDo: 
							[:each | 
							(context uses: each) 
								ifFalse: [result addClassVar: each key for: context selectedClass]]]].
	^detector!

variableReferencedOnce
	| detector |
	detector := self new.
	detector
		name: 'Variable referenced in only one method and always assigned first'.
	detector classBlock: 
			[:context :result | 
			| allSubclasses |
			allSubclasses := context selectedClass withAllSubclasses.
			context selectedClass instVarNames do: 
					[:each | 
					| defClass selector |
					(allSubclasses inject: 0
						into: 
							[:sum :class | 
							| sels |
							sels := class whichSelectorsAccess: each.
							sels size == 1 ifTrue: 
									[selector := sels asArray first.
									defClass := class].
							sum + sels size])
							== 1 ifTrue: 
								[| tree |
								tree := defClass parseTreeFor: selector.
								tree notNil ifTrue: 
										[(BRReadBeforeWrittenTester readBeforeWritten: (Array with: each) in: tree)
											isEmpty ifTrue: 
													[result addClass: defClass selector: selector.
													result addSearchString: each]]]]].
	^detector! !

!BlockLintRule class methodsFor: 'intention revealing'!

missingSubclassResponsibility
	| detector |
	detector := self new.
	detector
		name: 'Method defined in all subclasses, but not in superclass';
		resultClass: MultiEnvironment;
		openUsing: #openWithoutFilters.
	detector classBlock: 
			[:context :result | 
			| subs |
			subs := context selectedClass subclasses.
			subs size > 1 & context selectedClass isMeta not 
				ifTrue: 
					[| sels |
					sels := Bag new.
					subs do: [:each | sels addAll: each selectors].
					sels asSet do: 
							[:each | 
							((sels occurrencesOf: each) == subs size 
								and: [(context selectedClass canUnderstand: each) not]) 
									ifTrue: 
										[| envName |
										envName := context selectedClass name , '>>' , each.
										subs do: 
												[:subClass | 
												result 
													addClass: subClass
													selector: each
													into: envName]]]]].
	^detector! !

!BlockLintRule class methodsFor: 'bugs'!

overridesSpecialMessage
	| detector |
	detector := self new.
	detector name: 'Overrides a "special" message'.
	detector resultClass: ClassEnvironment.
	detector classBlock: 
			[:context :result | 
			((context selectedClass isMeta
				ifTrue: [self metaclassShouldNotOverride]
				ifFalse: [self classShouldNotOverride]) detect: 
						[:each | 
						context selectedClass superclass notNil and: 
								[(context selectedClass superclass canUnderstand: each)
									and: [context selectedClass includesSelector: each]]]
					ifNone: [nil]) notNil ifTrue: [result addClass: context selectedClass]].
	^detector!

sentNotImplemented
	| detector |
	detector := self new.
	detector name: 'Messages sent but not implemented'.
	detector methodBlock: 
			[:context :result | 
			| message |
			message := context messages detect: [:each | (context implements: each) not]
						ifNone: [nil].
			message isNil ifTrue: 
					[message := context superMessages detect: 
									[:each | 
									context selectedClass superclass isNil
										or: [(context selectedClass superclass canUnderstand: each) not]]
								ifNone: [nil].
					message isNil ifTrue: 
							[message := context selfMessages
										detect: [:each | (context selectedClass canUnderstand: each) not]
										ifNone: [nil]]].
			message notNil ifTrue: 
					[result addSearchString: message.
					result addClass: context selectedClass selector: context selector]].
	^detector!

subclassResponsibilityNotDefined
	| detector subclassResponsibilitySymbol |
	detector := self new.
	detector name: 'Subclass responsibility not defined'.
	subclassResponsibilitySymbol := 'subclassResponsibility' asSymbol.
	detector classBlock: 
			[:context :result | 
			(context selectedClass whichSelectorsReferTo: subclassResponsibilitySymbol)
				do: 
					[:each | 
					(context selectedClass withAllSubclasses detect: 
							[:class | 
							class subclasses isEmpty
								and: [(class whichClassIncludesSelector: each) == context selectedClass]]
						ifNone: [nil]) notNil
						ifTrue: [result addClass: context selectedClass selector: each]]].
	^detector!

undeclaredReference
	| detector |
	detector := self new.
	detector name: 'References an undeclared variable'.
	detector methodBlock: 
			[:context :result | 
			| undeclared |
			undeclared := Undeclared associations detect: 
							[:each | 
							(context uses: each)
								and: [context compiledMethod refersToLiteral: each]]
						ifNone: [nil].
			undeclared notNil ifTrue: 
					[result addSearchString: undeclared key.
					result addClass: context selectedClass selector: context selector]].
	^detector!

usesTrue
	| detector trueBinding falseBinding |
	detector := self new.
	trueBinding := Smalltalk associationAt: #True.
	falseBinding := Smalltalk associationAt: #False.
	detector name: 'Uses True/False instead of true/false'.
	detector methodBlock: 
			[:context :result | 
			| method |
			method := context compiledMethod.
			((method refersToLiteral: trueBinding)
				or: [method refersToLiteral: falseBinding]) ifTrue: 
						[result addClass: context selectedClass selector: context selector.
						result searchStrings: #('True' 'False')]].
	^detector!

variableNotDefined
	| detector |
	detector := self new.
	detector name: 'Variable used, but not defined anywhere'.
	detector methodBlock: 
			[:context :result | 
			context compiledMethod withAllBlockMethodsDo: 
					[:each | 
					each literalsDo: 
							[:lit | 
							lit isVariableBinding ifTrue: 
									[((Smalltalk associationAt: lit key ifAbsent: [nil]) == lit
										or: [(Undeclared associationAt: lit key ifAbsent: [nil]) == lit])
										ifFalse: 
											[(context selectedClass fullBindingFor: lit key) == lit ifFalse: 
													[result addClass: context selectedClass selector: context selector.
													result addSearchString: lit key]]]]]].
	^detector! !


!ClassEnvironment methodsFor: 'accessing'!

problemCount
	^self numberClasses! !

BrowserApplicationModel subclass: #RewriteRuleEditor
	instanceVariableNames: 'newCode originalCode environment method '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Lint'!



!RewriteRuleEditor methodsFor: 'initialize-release'!

environment: anEnvironment 
	environment := ClassEnvironment onEnvironment: anEnvironment.
	anEnvironment classesDo: [:each | environment addClass: each]!

initialize
	super initialize.
	environment := ClassEnvironment new!

rewrite: aString 
	self originalCode value: aString asText.
	self open! !

!RewriteRuleEditor methodsFor: 'accessing'!

isMethod
	^self method value!

replaceText
	^newCode value asString!

searchText
	^originalCode value asString! !

!RewriteRuleEditor methodsFor: 'actions'!

find
	(self verify: #originalCode) ifFalse: [^self].
	(ParseTreeLintRule 
		createParseTreeRule: (Array with: self searchText)
		method: self isMethod
		name: 'Search for: ' , self searchText) runOnEnvironment: environment!

replace
	((self verify: #originalCode) and: [self verify: #newCode]) ifFalse: [^self].
	(TransformationRule
		rewrite: (Array with: (Array with: self searchText with: self replaceText))
		methods: self isMethod
		name: self searchText , ' -> ' , self replaceText)
			runOnEnvironment: environment!

selectMethods
	| environmentEditor |
	environmentEditor := ClassSelectionDialog onEnvironment: environment.
	environmentEditor open
		ifTrue: [environment := environmentEditor selectedEnvironment]!

verify: aSymbol 
	| widget symbol controller |
	widget := builder componentAt: aSymbol.
	widget isNil ifTrue: [^false].
	controller := widget widget controller.
	symbol := self isMethod
				ifTrue: [#parseRewriteMethod:onError:]
				ifFalse: [#parseRewriteExpression:onError:].
	BRParser
		perform: symbol
		with: controller text
		with: 
			[:aString :position | 
			controller insertAndSelect: aString , ' ->' at: position.
			^false].
	^true! !

!RewriteRuleEditor methodsFor: 'aspects'!

method
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^method isNil
		ifTrue:
			[method := false asValue]
		ifFalse:
			[method]!

newCode
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^newCode isNil
		ifTrue:
			[newCode := String new asValue]
		ifFalse:
			[newCode]!

originalCode
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^originalCode isNil
		ifTrue:
			[originalCode := String new asValue]
		ifFalse:
			[originalCode]! !

RewriteRuleEditor class
	instanceVariableNames: ''!



!RewriteRuleEditor class methodsFor: 'instance creation'!

rewrite: aString 
	^(self new) rewrite: aString;
		yourself! !

!RewriteRuleEditor class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Rewrite Rule Editor' 
			#bounds: #(#Rectangle 313 355 834 730 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 2 0 25 0 -95 1 -1 0.5 ) 
					#name: #originalCode 
					#model: #originalCode ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 2 0 25 0.5 -95 1 -2 1 ) 
					#name: #newCode 
					#model: #newCode ) 
				#(#CheckBoxSpec 
					#layout: #(#LayoutOrigin -93 1 25 0.5 ) 
					#name: #method 
					#model: #method 
					#label: 'Method' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -93 1 -103 1 -2 1 -73 1 ) 
					#name: #selectMethods 
					#model: #selectMethods 
					#label: 'Methods...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -93 1 -68 1 -2 1 -38 1 ) 
					#name: #find 
					#model: #find 
					#label: 'Search...' ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -93 1 -33 1 -2 1 -2 1 ) 
					#name: #replace 
					#model: #replace
					#label: 'Replace...' ) 
				#(#LabelSpec 
					#layout: #(#Point 2 2 ) 
					#label: 'Search for:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 2 0 0 0.5 ) 
					#label: 'Replace with:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -93 1 25 0 ) 
					#label: '` = meta var' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -93 1 50 0 ) 
					#label: '@ = list' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -93 1 75 0 ) 
					#label: '` = recurse into' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -93 1 100 0 ) 
					#label: '. = statement' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin -93 1 125 0 ) 
					#label: '# = literal' ) ) ) )! !


!CompiledCode methodsFor: 'RefactoringBrowser'!

messagesDo: aBlock 
	self
		withAllBlockMethodsDo: 
			[:meth | 
			| scanner selector |
			scanner := InstructionStream on: meth.
			scanner
				scanFor: 
					[:byte | 
					selector := scanner peekForSelector.
					selector == nil ifFalse: [aBlock value: selector].
					false]]! !


