'From VisualWorks, Release 3.0 of February 5, 1998 on October 14, 1998 at 7:31:21 pm'!


Object subclass: #Refactoring
	instanceVariableNames: 'changes undoChanges '
	classVariableNames: 'PreconditionErrorSignal PreconditionWarningSignal '
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!Refactoring methodsFor: 'initialize-release'!

initialize
	changes := RefactoryBuilder named: self class name.
	undoChanges := RefactoryBuilder named: self class name! !

!Refactoring methodsFor: 'performing'!

changes
	^changes!

checkPreconditions
	| conds block | 
	conds := self preconditions.
	conds check ifFalse: 
			[block := conds errorBlock.
			block notNil
				ifTrue: [self refactoringError: conds errorString with: block]
				ifFalse: [self refactoringError: conds errorString]]!

execute
	(RefactoringManager instance)
		ignoreChangesWhile: [self primitiveExecute];
		addRefactoring: self!

performChange: aRefactoryChange 
	changes addChange: aRefactoryChange.
	undoChanges addChangeFirst: aRefactoryChange execute!

performChange: aRefactoryChange withLabel: aString 
	changes addChange: aRefactoryChange.
	undoChanges addChangeFirst: (aRefactoryChange executeWithMessage: aString)!

performComponentRefactoring: aRefactoring 
	aRefactoring primitiveExecute.
	changes addChange: aRefactoring changes.
	undoChanges addChangeFirst: aRefactoring undoChanges!

performRefactoring
	self subclassResponsibility!

preconditions
	self subclassResponsibility!

reparentClasses: behaviorCollection to: newClass 
	| builder |
	builder := RefactoryBuilder named: 'Reparent classes'.
	behaviorCollection do: 
			[:aClass | 
			builder 
				defineClass: (self replaceClassNameIn: aClass definition to: newClass name)].
	self performChange: builder withLabel: 'Reparenting all subclasses'!

replaceClassNameIn: definitionString to: aSymbol 
	| parseTree |
	parseTree := BRParser parseExpression: definitionString.
	parseTree receiver: (BRVariableNode named: aSymbol).
	^parseTree formattedCode!

undo
	^self error: 'Not implemented yet'!

undoChanges
	^undoChanges! !

!Refactoring methodsFor: 'testing'!

canReferenceVariable: aString in: aClass 
	(self whichClass: aClass defines: aString) notNil ifTrue: [^true].
	(self whichClass: aClass definesClassVariable: aString) notNil 
		ifTrue: [^true].
	(Smalltalk includesKey: aString asSymbol) ifTrue: [^true].
	^(self poolVariableNamesFor: aClass) includes: aString!

includesSelector: aSelector in: aClass 
	"Returns a boolean indicating whether or not the complete method-scope of 
	this class (all sub and superclasses) defines a method named 
	aSymbol."

	(aClass canUnderstand: aSelector) ifTrue: [^true].
	^(aClass allSubclasses detect: [:each | each includesSelector: aSelector]
		ifNone: [nil]) notNil!

isAbstract: aClass 
	^Condition isAbstract: aClass!

subclassOf: aClass redefines: aSelector 
	"Return true, if one of your subclasses redefines the method with name, aMethod"

	aClass
		allSubclassesDo: [:each | (each includesSelector: aSelector) ifTrue: [^true]].
	^false! !

!Refactoring methodsFor: 'utilities'!

allImplementorsOf: aSelector 
	"Answer a collection of all the classes that implement the message 
	aSelector."

	| aCollection |
	aCollection := OrderedCollection new.
	Cursor wait showWhile: 
			[Smalltalk allBehaviorsDo: 
					[:class | 
					(class includesSelector: aSelector) ifTrue: [aCollection add: class]]].
	^aCollection!

allSubtreeVarsIn: aClass includes: aVarName 
	^Condition allSubtreeVarsIn: aClass includes: aVarName!

associationForClassVariable: aName in: aClass ifAbsent: aBlock 
	^aClass classPool associationAt: aName asSymbol
		ifAbsent: [aClass classPool associationAt: aName asString ifAbsent: aBlock]!

checkInstVarName: aName in: aClass 
	^Condition checkInstVarName: aName in: aClass!

checkMethodName: aName in: aClass 
	^Condition checkMethodName: aName in: aClass!

confirm: aString 
	^Dialog confirm: aString!

poolVariableNamesFor: aClass
	| pools |
	pools := Set new.
	aClass withAllSuperclasses do: 
			[:each | 
			each sharedPools
				do: [:pool | pools addAll: (pool keys collect: [:name | name asString])]].
	^pools!

request: aString
	^Dialog request: aString!

safeMethodNameFor: aClass basedOn: aString 
	"Creates an unused method name containing aString"

	| baseString newString hasParam i |
	baseString := aString copy.
	baseString at: 1 put: baseString first asLowercase.
	newString := baseString.
	hasParam := newString last = $:.
	hasParam 
		ifTrue: [baseString := newString copyFrom: 1 to: newString size - 1].
	i := 0.
	[self includesSelector: newString asSymbol in: aClass] whileTrue: 
			[i := i + 1.
			newString := baseString , i printString 
						, (hasParam ifTrue: [':'] ifFalse: [''])].
	^newString!

whichClass: aClass defines: anInstVarName 
	| currentClass |
	currentClass := aClass.
	[currentClass isNil] whileFalse: 
			[(currentClass instVarNames includes: anInstVarName) ifTrue: [^currentClass].
			currentClass := currentClass superclass].
	^nil!

whichClass: aClass definesClassVariable: aClassVarName 
	| currentClass classVarString |
	classVarString := aClassVarName asString.
	currentClass := aClass.
	[currentClass isNil] whileFalse: 
			[((currentClass classVarNames collect: [:each | each asString])
				includes: classVarString) ifTrue: [^currentClass].
			currentClass := currentClass superclass].
	^nil!

whichVariableNode: aParseTree inInterval: anInterval name: aName 
	| matcher block |
	matcher := ParseTreeSearcher new.
	block := 
			[:aNode :answer | 
			(aNode intersectsInterval: anInterval) ifTrue: [aNode] ifFalse: [answer]].
	matcher
		matches: aName do: block;
		matchesArgument: aName do: block.
	^matcher executeTree: aParseTree initialAnswer: nil! !

!Refactoring methodsFor: 'support'!

checkClass: aClass selector: aSelector using: aMatcher 
	| parseTree |
	parseTree := aClass parseTreeFor: aSelector.
	parseTree notNil ifTrue: [aMatcher executeTree: parseTree].
	^aMatcher answer!

convertAllClassesSelect: aBlock using: searchReplacer notifying: changeBuilder 
	"Perform a search and replace all classes using the tree matcher, searchReplacer.
	Search only the selectors that aBlock returns for a given class. Write the changes to the
	changeBuilder."

	Smalltalk allBehaviorsDo: 
			[:aClass | 
			(aBlock value: aClass) do: 
					[:selector | 
					self convertMethod: selector
						for: aClass
						using: searchReplacer
						notifying: changeBuilder]]!

convertClasses: classSet select: aBlock using: searchReplacer notifying: changeBuilder
	"Perform a search and replace on the classes, classSet, using the tree matcher, searchReplacer.
	Search only the selectors that aBlock returns for a given class. Write the changes to the
	changeBuilder."

	classSet do: [:aClass | (aBlock value: aClass)
			do: [:selector | "Convert each method"
				self
					convertMethod: selector
					for: aClass
					using: searchReplacer
					notifying: changeBuilder]]!

convertClasses: classSet select: aBlock using: searchReplacer notifying: changeBuilder message: aString
	"Perform a search and replace on the classes, classSet, using the tree matcher, searchReplacer.
	Search only the selectors that aBlock returns for a given class. Write the changes to the
	changeBuilder. Display aString in a percent done box updating it after each class has been searched."

	| tally count controller model |
	model := 0 asValue.
	tally := classSet inject: 0 into: [:val :each | val + (aBlock value: each) size].
	count := 0.0.

	"First open the percent done window"
	controller := ProgressWidgetView progressOpenOn: model label: aString.

	[model value: 0.
	classSet do: [:aClass | (aBlock value: aClass)
			do:
				[:selector |

				"Convert each method, and then update the percent done window."
				self
					convertMethod: selector
					for: aClass
					using: searchReplacer
					notifying: changeBuilder.

				count := count + 1.
				model value: count / tally]]]

		valueNowOrOnUnwindDo: [

			"All done, just need to close the window now"
			controller closeAndUnschedule]!

convertMethod: selector for: aClass using: searchReplacer notifying: changeBuilder 
	"Convert the parse tree for selector using the searchReplacer. If a
	change is made then compile it into the changeBuilder."

	| parseTree |
	parseTree := aClass parseTreeFor: selector.
	parseTree isNil ifTrue: [^self].
	(searchReplacer executeTree: parseTree) ifTrue: 
			[changeBuilder compile: searchReplacer tree printString
				in: aClass
				classified: (aClass whichCategoryIncludesSelector: selector)]!

usesAssignmentOf: varName in: aClass classVariable: isClassVar 
	| matcher literal definingClass |
	matcher := ParseTreeSearcher new.
	matcher
		answer: false;
		matches: varName , ' := ``@object'
			do: [:aNode :answer | answer or: [aNode isUsed]].
	isClassVar 
		ifTrue: 
			[literal := self 
						associationForClassVariable: varName
						in: aClass
						ifAbsent: [self refactoringError: 'Could not find class variable name']].
	definingClass := isClassVar 
				ifTrue: 
					[aClass isMeta ifTrue: [aClass soleInstance] ifFalse: [aClass]]
				ifFalse: [aClass].
	^(definingClass withAllSubclasses 
		, (isClassVar ifTrue: [definingClass class withAllSubclasses] ifFalse: [#()]) 
			detect: 
				[:each | 
				((isClassVar 
					ifTrue: [each whichSelectorsReferTo: literal]
					ifFalse: [each whichSelectorsWrite: varName]) detect: 
							[:sel | 
							self 
								checkClass: each
								selector: sel
								using: matcher]
						ifNone: [nil]) notNil]
			ifNone: [nil]) notNil! !

!Refactoring methodsFor: 'private'!

onError: aBlock do: errorBlock 
	^self class preconditionSignal handle: 
			[:ex | 
			errorBlock value.
			ex returnWith: nil]
		do: aBlock!

primitiveExecute
	self checkPreconditions.
	^self performRefactoring!

refactoringError: aString 
	PreconditionErrorSignal raiseErrorString: aString!

refactoringError: aString with: aBlock 
	PreconditionErrorSignal raiseWith: aBlock errorString: aString!

refactoringWarning: aString
	PreconditionWarningSignal raiseRequestErrorString: aString!

variableNamesFor: aClass 
	| variableNames |
	variableNames := aClass allInstVarNames asSet.
	variableNames
		addAll: (aClass allClassVarNames collect: [:each | each asString]).
	^variableNames!

writeLogFor: aClass 
	SourceFileManager default logChange: aClass definition! !

Refactoring class
	instanceVariableNames: ''!



!Refactoring class methodsFor: 'accessing signal'!

preconditionErrorSignal
	^PreconditionErrorSignal!

preconditionSignal
	^SignalCollection with: PreconditionErrorSignal with: PreconditionWarningSignal!

preconditionWarningSignal
	^PreconditionWarningSignal! !

!Refactoring class methodsFor: 'class initialization'!

initialize
	"Refactoring initialize"

	PreconditionWarningSignal := (Signal genericSignal newSignal) notifierString: 'Refactoring Warning -';
				nameClass: self message: #preconditionWarningSignal;
				yourself.
	PreconditionErrorSignal := (PreconditionWarningSignal newSignal) notifierString: 'Refactoring Error -';
				nameClass: self message: #preconditionErrorSignal;
				yourself! !

!Refactoring class methodsFor: 'instance creation'!

new
	^(super new) initialize;
		yourself! !

Refactoring subclass: #ClassRefactoring
	instanceVariableNames: 'className '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ClassRefactoring methodsFor: 'initialize-release'!

className: aName
	className := aName! !

!ClassRefactoring methodsFor: 'performing'!

lookupClass
	^Smalltalk at: className asSymbol
		ifAbsent: 
			[self refactoringError: 'Could not find class in Smalltalk dictionary']! !

ClassRefactoring class
	instanceVariableNames: ''!



!ClassRefactoring class methodsFor: 'instance creation'!

className: aName
	^self new className: aName! !

BrowserDialog subclass: #MethodNameDialog
	instanceVariableNames: 'argumentList selector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!MethodNameDialog methodsFor: 'initialize-release'!

arguments: aCollection
	self argumentList list: aCollection asList!

initialize
	super initialize.
	self argumentList selectionIndexHolder onChangeSend: #changedSelection to: self!

methodName: aSelector
	self selector value: aSelector!

release
	super release.
	self argumentList selectionIndexHolder retractInterestsFor: self! !

!MethodNameDialog methodsFor: 'accessing'!

arguments
	^argumentList list!

methodName
	^selector value!

methodPattern
	| stream |
	stream := String new writeStream.
	self selector value numArgs > 0
		ifTrue: 
			[self selector value keywords with: self argumentList list
				do: 
					[:keyword :arg | 
					stream nextPutAll: keyword;
						nextPut: $ ;
						nextPutAll: arg;
						nextPut: $ ]]
		ifFalse: [stream nextPutAll: self selector value].
	^stream contents! !

!MethodNameDialog methodsFor: 'actions'!

down
	| index |
	index := self argumentList selectionIndex.
	self argumentList list swap: index with: index + 1.
	self argumentList selectionIndex: index + 1!

up
	| index |
	index := self argumentList selectionIndex.
	self argumentList list swap: index with: index - 1.
	self argumentList selectionIndex: index - 1! !

!MethodNameDialog methodsFor: 'changing'!

changedSelection
	| index |
	index := self argumentList selectionIndex.
	index > 1 ifTrue: [self enable: #up] ifFalse: [self disable: #up].
	index < self argumentList list size & (index > 0)
		ifTrue: [self enable: #down]
		ifFalse: [self disable: #down].
	self changedSelector!

changedSelector
	((Condition checkMethodName: self selector value in: self class)
		and: [self selector value numArgs == self argumentList list size])
		ifTrue: 
			[self enable: #ok.
			self printSelector]
		ifFalse: 
			[self disable: #ok.
			self printNoSelector]! !

!MethodNameDialog methodsFor: 'aspects'!

argumentList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^argumentList isNil
		ifTrue:
			[argumentList := SelectionInList new]
		ifFalse:
			[argumentList]!

selector
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^selector isNil
		ifTrue:
			[selector := nil asValue]
		ifFalse:
			[selector]! !

!MethodNameDialog methodsFor: 'interface opening'!

postBuildWith: aBuilder
	super postBuildWith: aBuilder.
	self changedSelection! !

!MethodNameDialog methodsFor: 'private'!

methodLabel: aString
	| component |
	component := builder componentAt: #methodPattern.
	component notNil ifTrue: [component labelString: aString]!

printNoSelector
	self methodLabel: ''!

printSelector
	self methodLabel: self methodPattern! !

MethodNameDialog class
	instanceVariableNames: ''!



!MethodNameDialog class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Method name' 
			#bounds: #(#Rectangle 385 297 673 513 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -5 1 30 0 ) 
					#name: #selector 
					#model: #selector 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector ) 
					#type: #symbol ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 35 0 -55 1 145 0 ) 
					#name: #argumentList 
					#model: #argumentList ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 35 0 -5 1 75 0 ) 
					#name: #up 
					#isOpaque: true 
					#model: #up 
					#label: #upImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 105 0 -5 1 145 0 ) 
					#name: #down 
					#isOpaque: true 
					#model: #down 
					#label: #downImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 180 0 0.5 0 ) 
					#name: #ok 
					#model: #accept 
					#label: 'OK' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 180 0 0.5 0 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutFrame 5 0 150 0 -5 1 175 0 ) 
					#name: #methodPattern 
					#label: 'No method name' ) ) ) )! !

!MethodNameDialog class methodsFor: 'instance creation'!

methodNameFor: arguments 
	| dialog |
	dialog := self new.
	dialog arguments: arguments.
	^dialog!

methodNameFor: arguments initial: aSelector
	| dialog |
	dialog := self new.
	dialog arguments: arguments.
	dialog methodName: aSelector.
	^dialog! !


!BrowserApplicationModel methodsFor: 'accessing'!

performChange: aRefactoringChange 
	RefactoringManager instance ignoreChangesWhile: 
			[RefactoringManager instance addUndo: aRefactoringChange execute]!

performChange: aRefactoringChange withMessage: aString 
	RefactoringManager instance ignoreChangesWhile: 
			[RefactoringManager instance 
				addUndo: (aRefactoringChange executeWithMessage: aString)]! !

Refactoring subclass: #VariableRefactoring
	instanceVariableNames: 'class varName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!VariableRefactoring methodsFor: 'initialize-release'!

variable: aVarName class: aClass
	class := aClass.
	varName := aVarName! !

VariableRefactoring class
	instanceVariableNames: ''!



!VariableRefactoring class methodsFor: 'instance creation'!

variable: aVarName class: aClass
	^self new variable: aVarName class: aClass! !

VariableRefactoring subclass: #PushDownClassVariableRefactoring
	instanceVariableNames: 'destinationClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PushDownClassVariableRefactoring methodsFor: 'performing'!

findDestinationClass
	| classVarName literal |
	classVarName := varName asSymbol.
	literal := self associationForClassVariable: classVarName
				in: class
				ifAbsent: [self refactoringError: 'Could not perform refactoring'].
	class withAllSubclasses do: 
			[:each | 
			((each whichSelectorsReferTo: literal) isEmpty
				and: [(each class whichSelectorsReferTo: literal) isEmpty]) ifFalse: 
						[destinationClass isNil
							ifTrue: [destinationClass := each]
							ifFalse: 
								[(each inheritsFrom: destinationClass) ifFalse: 
										[(destinationClass inheritsFrom: each)
											ifTrue: [destinationClass := each]
											ifFalse: 
												[self
													refactoringError: ('Multiple subclasses reference <1s><n>Browse references?'
															expandMacrosWith: varName)
													with: [(BrowserEnvironment new referencesTo: literal in: class) openEditor]]]]]].
	destinationClass = class ifTrue: 
			[self
				refactoringError: ('<1p> has references to <2s><n>Browse references?' expandMacrosWith: class
						with: varName)
				with: [(BrowserEnvironment new referencesTo: literal in: class) openEditor]].
	^destinationClass!

performRefactoring
	| value builder |
	builder := RefactoryBuilder named: 'Push down class variable'.
	value := (self 
				associationForClassVariable: varName
				in: class
				ifAbsent: [self refactoringError: 'Could not perform refactoring']) value.
	builder removeClassVariable: varName from: class.
	destinationClass isNil ifTrue: [^self performChange: builder].
	builder addClassVariable: varName to: destinationClass.
	self performChange: builder withLabel: 'Compiling changes'.
	(self 
		associationForClassVariable: varName
		in: destinationClass
		ifAbsent: [nil -> nil]) value: value!

preconditions
	"Preconditions are that only one subclass refers to the class variable."

	^Condition withBlock: 
			[self findDestinationClass.
			true]! !

PushDownClassVariableRefactoring class
	instanceVariableNames: ''!


VariableRefactoring subclass: #ProtectInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ProtectInstanceVariableRefactoring methodsFor: 'performing'!

findGetterSetterMethods
	| matcher |
	matcher := ParseTreeSearcher new.
	matcher
		answer: Set new;
		matchesAnyMethodOf: (Array 
					with: '`method ^' , varName
					with: ('`method: `arg <1s> := `arg' expandMacrosWith: varName)
					with: ('`method: `arg ^<1s> := `arg' expandMacrosWith: varName))
			do: 
				[:aNode :answer | 
				(self subclassOf: class redefines: aNode selector) 
					ifFalse: [answer add: aNode selector].
				answer].
	(class whichSelectorsAccess: varName) do: 
			[:each | 
			self 
				checkClass: class
				selector: each
				using: matcher].
	^matcher answer!

inline: aSelector 
	self onError: 
			[self performComponentRefactoring: (InlineAllSendersRefactoring 
						sendersOf: aSelector
						in: class)]
		do: []!

performRefactoring
	self findGetterSetterMethods do: [:each | self inline: each]!

preconditions
	^(Condition isClass: class)
		& (Condition definesInstVar: varName in: class)! !

ProtectInstanceVariableRefactoring class
	instanceVariableNames: ''!


VariableRefactoring subclass: #AbstractInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AbstractInstanceVariableRefactoring methodsFor: 'performing'!

performRefactoring
	"Removes all direct references to anInstVar in this class, creating
	reference methods if necessary."

	| getterMethod setterMethod builder replacer ref |
	builder := RefactoryBuilder named: 'Abstract variable'.
	ref := CreateAccessorsForVariableRefactoring 
				variable: varName
				class: class
				classVariable: false.
	self performComponentRefactoring: ref.
	getterMethod := ref getterMethod.
	setterMethod := ref setterMethod.

	"Convert all references to the variable to its getter and setter method"
	replacer := ParseTreeRewriter 
				variable: varName
				getter: getterMethod
				setter: setterMethod.
	self 
		convertClasses: class withAllSubclasses
		select: 
			[:aClass | 
			(aClass whichSelectorsAccess: varName) reject: 
					[:each | 
					aClass == class and: [each == getterMethod or: [each == setterMethod]]]]
		using: replacer
		notifying: builder
		message: 'Abstracting references to ' , varName.
	self performChange: builder withLabel: 'Compiling sources'!

preconditions
	^(Condition isClass: class)
		& (Condition definesInstVar: varName in: class)! !

AbstractInstanceVariableRefactoring class
	instanceVariableNames: ''!


VariableRefactoring subclass: #RemoveClassVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RemoveClassVariableRefactoring methodsFor: 'performing'!

performRefactoring
	self 
		performChange: (RemoveClassVariableChange remove: varName from: class)!

preconditions
	^(Condition isClass: class) & (Condition isMetaclass: class) not
		& (Condition withBlock: 
					[| literal block |
					literal := self associationForClassVariable: varName
								in: class
								ifAbsent: 
									[self refactoringError: varName , ' is not defined by ' , class name].
					block := 
							[:each | 
							(each whichSelectorsReferTo: literal) isEmpty ifFalse: 
									[self
										refactoringError: ('<1s> is referenced.<n>Browse references?' expandMacrosWith: varName)
										with: [(BrowserEnvironment new referencesTo: literal in: class) openEditor]]].
					class withAllSubclasses do: block.
					class class withAllSubclasses do: block.
					true])! !

RemoveClassVariableRefactoring class
	instanceVariableNames: ''!



!ParseTreeRewriter class methodsFor: 'instance creation'!

valueHolderForVariable: aVarName holderMethod: aSelector 
	| rewriteRule valueHolderString |
	rewriteRule := self new.
	valueHolderString := 'self ' , aSelector , ' value'.
	rewriteRule
		replace: aVarName , ' := ``@object' with: valueHolderString , ': ``@object';
		replace: aVarName with: valueHolderString.
	^rewriteRule! !

Object subclass: #RefactoryChange
	instanceVariableNames: 'name '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!

RefactoryChange comment:
'RefactoryChange is an abstract class that represent some change to a class or method. They are used in combination with RefactoryBuilders to give transaction-like behavior.

Subclasses must implement the following messages:
	accessing
		doIt

Instance Variables:
	class	<Behavior>	the class that is to be changed'!


!RefactoryChange methodsFor: 'performing-changes'!

execute
	^self executeNotifying: []!

executeWithMessage: aString 
	| tally controller model done |
	model := 0 asValue.
	done := 0.
	tally := self changesSize.
	controller := aString isNil 
				ifTrue: [nil]
				ifFalse: [ProgressWidgetView progressOpenOn: model label: aString].
	model value: 0.
	^
	[self executeNotifying: 
			[done := done + 1.
			model value: done asFloat / tally]] 
			valueNowOrOnUnwindDo: 
				[controller notNil ifTrue: [controller closeAndUnschedule]]! !

!RefactoryChange methodsFor: 'initialize-release'!

initialize!

name: aString
	name := aString! !

!RefactoryChange methodsFor: 'accessing'!

changes
	^Array with: self!

changesSize
	^1!

name
	^name isNil ifTrue: [self changeString] ifFalse: [name]!

renameChangesForClass: aClassName to: newClassName 
	"We're in the middle of performing a rename operation. If we stored 
	the class name, we need to change the class name to the new 
	name to perform the compiles."

	self subclassResponsibility! !

!RefactoryChange methodsFor: 'private'!

executeNotifying: aBlock 
	self subclassResponsibility!

flattenedChanges
	| changes |
	changes := OrderedCollection new.
	self flattenOnto: changes.
	^changes!

flattenOnto: aCollection 
	aCollection add: self! !

!RefactoryChange methodsFor: 'user interface'!

inspect
	^((RefactoryBuilder new)
		changes: (Array with: self);
		yourself) inspect! !

!RefactoryChange methodsFor: 'printing'!

changeString
	^self class name!

displayString
	^name isNil ifTrue: [self changeString] ifFalse: [name]! !

RefactoryChange class
	instanceVariableNames: ''!



!RefactoryChange class methodsFor: 'instance creation'!

new
	^super new initialize! !

ClassRefactoring subclass: #AddClassRefactoring
	instanceVariableNames: 'category superclass subclasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AddClassRefactoring methodsFor: 'initialize-release'!

addClass: aName superclass: aClass subclasses: aCollection category: aSymbol
	self className: aName.
	superclass := aClass.
	subclasses := aCollection.
	category := aSymbol! !

!AddClassRefactoring methodsFor: 'performing'!

performRefactoring
	| newClass |
	self performChange: (AddClassChange 
				definition: ('<1p> subclass: #<2s> instanceVariableNames: '''' classVariableNames: '''' poolDictionaries: '''' category: <3p>' 
						expandMacrosWith: superclass
						with: className
						with: category)).
	newClass := Smalltalk at: className asSymbol.
	self reparentClasses: subclasses to: newClass!

preconditions
	| cond |
	cond := (Condition isClass: superclass)
				& ((Condition isMetaclass: superclass)
						errorMacro: 'Superclass must not be a metaclass') not.
	cond := subclasses inject: cond
				into: 
					[:sub :each | 
					sub & (Condition isClass: each)
						& ((Condition isMetaclass: each)
								errorMacro: 'Subclass must <1?not :>be a metaclass') not
						& (Condition isImmediateSubclass: each of: superclass)].
	^cond & (Condition isValidClassName: className)
		& (Condition isGlobal: className) not
		& (Condition isSymbol: category)
		& ((Condition withBlock: [category isEmpty not])
				errorMacro: 'Invalid category name')! !

AddClassRefactoring class
	instanceVariableNames: ''!



!AddClassRefactoring class methodsFor: 'instance creation'!

addClass: aName superclass: aClass subclasses: aCollection category: aSymbol
	^self new
		addClass: aName
		superclass: aClass
		subclasses: aCollection
		category: aSymbol! !

Object subclass: #RefactoryTyper
	instanceVariableNames: 'class variableTypes bestGuesses variableMessages bindings backpointers methodName selectorLookup '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RefactoryTyper methodsFor: 'initialize-release'!

initialize
	class := Object.
	variableTypes := Dictionary new.
	variableMessages := Dictionary new.
	selectorLookup := IdentityDictionary new.
	variableTypes := Dictionary new.
	bestGuesses := Dictionary new! !

!RefactoryTyper methodsFor: 'accessing'!

guessTypesFor: anInstVarName 
	^bestGuesses at: anInstVarName ifAbsent: [self typesFor: anInstVarName]!

guessTypesFor: anInstVarName in: aClass 
	class == aClass ifFalse: [self runOn: aClass].
	^bestGuesses at: anInstVarName
		ifAbsent: [self typesFor: anInstVarName in: aClass]!

runOn: aClass 
	variableTypes := Dictionary new.
	variableMessages := Dictionary new.
	variableTypes := Dictionary new.
	bestGuesses := Dictionary new.
	class := aClass.
	aClass instVarNames isEmpty ifTrue: [^self].
	self selectedClass: aClass;
		computeEquivalenceClassesForMethodsAndVars;
		computeMessagesSentToVariables;
		computeTypes;
		refineTypesByLookingAtAssignments!

selectedClass: aClass
	class := aClass!

typesFor: anInstVarName 
	^variableTypes at: anInstVarName ifAbsent: [Set new]!

typesFor: anInstVarName in: aClass 
	class == aClass ifFalse: [self runOn: aClass].
	^variableTypes at: anInstVarName ifAbsent: [Set new]! !

!RefactoryTyper methodsFor: 'assignments'!

guessTypeFromAssignment: aNode 
	| type set newType |
	aNode value isAssignment 
		ifTrue: 
			[^self guessTypeFromAssignment: (BRAssignmentNode variable: aNode variable
						value: aNode value value)].
	aNode value isBlock ifTrue: [type := [] class].
	aNode value isLiteral 
		ifTrue: 
			[aNode value value isNil ifTrue: [^self].
			type := self typeFor: aNode value value].
	aNode value isMessage 
		ifTrue: 
			[aNode value receiver isVariable 
				ifTrue: 
					[type := Smalltalk at: aNode value receiver name asSymbol ifAbsent: [nil].
					type isBehavior ifFalse: [type := nil]].
			(aNode value selector == #asValue 
				and: [Smalltalk includesKey: #ValueHolder]) 
					ifTrue: [type := Smalltalk at: #ValueHolder].
			(#(#and: #or: #= #== #~= #~~ #<= #< #~~ #> #>=) 
				includes: aNode value selector) ifTrue: [type := Boolean]].
	type isNil ifTrue: [^self].
	set := variableTypes at: aNode variable name.
	newType := set detect: [:each | type includesBehavior: each] ifNone: [nil].
	newType isNil ifTrue: [^self].
	newType == Object ifTrue: [newType := type].
	(bestGuesses at: aNode variable name ifAbsentPut: [Set new]) add: newType!

refineTypesByLookingAtAssignments
	| searcher needsSearch |
	needsSearch := false.
	searcher := ParseTreeSearcher new.
	variableTypes keysAndValuesDo: 
			[:key :value | 
			(key first == $-) 
				ifFalse: 
					[needsSearch := true.
					searcher matches: key , ' := ``@object'
						do: [:aNode :answer | self guessTypeFromAssignment: aNode]]].
	needsSearch ifTrue: [self executeSearch: searcher]!

typeFor: anObject 
	'' class == anObject class ifTrue: [^String].
	^(#(true false) includes: anObject) 
		ifTrue: [Boolean]
		ifFalse: [anObject class]! !

!RefactoryTyper methodsFor: 'computing types'!

computeTypes
	variableMessages
		keysAndValuesDo: [:key :value | variableTypes at: key put: (self findTypeFor: value)]!

findTypeFor: selectorCollection 
	^selectorCollection inject: self rootClasses
		into: 
			[:classes :each | 
			self refineTypes: classes
				with: (selectorLookup at: each ifAbsentPut: [self implementorsOf: each])]!

implementorsOf: aSelector 
	| classes |
	classes := OrderedCollection new.
	self rootClasses do: 
			[:each | 
			self implementorsOf: aSelector
				in: each
				storeIn: classes].
	^classes!

implementorsOf: aSelector in: aClass storeIn: classes 
	(aClass includesSelector: aSelector) ifTrue: 
			[classes add: aClass.
			^self].
	aClass subclasses do: 
			[:each | 
			self implementorsOf: aSelector
				in: each
				storeIn: classes]!

refineTypes: aClassCollection with: anotherClassCollection 
	| classSet |
	classSet := Set new.
	aClassCollection do: 
			[:each | 
			anotherClassCollection do: 
					[:cls | 
					(cls includesBehavior: each)
						ifTrue: [classSet add: cls]
						ifFalse: [(each includesBehavior: cls) ifTrue: [classSet add: each]]]].
	^classSet! !

!RefactoryTyper methodsFor: 'equivalence classes'!

computeEquivalenceClassesForMethodsAndVars
	| searcher |
	bindings := Set new.
	backpointers := Dictionary new.
	class instVarNames 
		do: [:each | backpointers at: each put: (bindings add: (Set with: each))].
	class withAllSubclasses do: 
			[:sub | 
			sub selectors 
				do: [:each | backpointers at: each put: (bindings add: (Set with: each))]].
	searcher := ParseTreeSearcher new.
	searcher matches: '^``@object'
		do: [:aNode :answer | self processNode: aNode value].
	self executeSearch: searcher!

merge: aName 
	| set1 set2 |
	set1 := backpointers at: methodName ifAbsent: [nil].
	set2 := backpointers at: aName ifAbsent: [nil].
	(set1 isNil or: [set2 isNil or: [set1 == set2]])
		ifTrue: [^self].
	set1 addAll: set2.
	set2 do: [:each | backpointers at: each put: set1].
	bindings remove: set2!

processNode: aNode 
	(aNode isVariable and: [class instVarNames includes: aNode name])
		ifTrue: [^self merge: aNode name].
	(aNode isMessage
		and: [aNode receiver isVariable and: [aNode receiver name = 'self']])
			ifTrue: [^self merge: aNode selector].
	aNode isAssignment ifTrue: 
			[self processNode: aNode value;
				processNode: aNode variable].
	(aNode isMessage and: 
			[#(#ifTrue: #ifFalse: #ifTrue:ifFalse: #ifFalse:ifTrue:)
				includes: aNode selector])
		ifTrue: 
			[aNode arguments do: 
					[:each | 
					each isBlock ifTrue: 
							[each body statements isEmpty
								ifFalse: [self processNode: each body statements last]]]]! !

!RefactoryTyper methodsFor: 'printing'!

collectionNameFor: aString 
	^'-<1s>-' expandMacrosWith: aString!

printOn: aStream 
	aStream nextPutAll: class name;
		cr.
	class instVarNames do: 
			[:each | 
			aStream tab;
				nextPutAll: each;
				tab;
				nextPut: $<.
			self printTypeFor: each on: aStream.
			aStream nextPut: $>;
				cr]!

printType: aClass for: aString on: aStream 
	| name colTypes |
	colTypes := #().
	name := self collectionNameFor: aString.
	(aClass includesBehavior: Collection) 
		ifTrue: [colTypes := self guessTypesFor: name].
	colTypes isEmpty ifFalse: [aStream nextPut: $(].
	aClass printOn: aStream.
	colTypes isEmpty 
		ifFalse: 
			[aStream nextPutAll: ' of: '.
			colTypes size > 1 ifTrue: [aStream nextPut: $(].
			self printTypeFor: name on: aStream.
			colTypes size > 1 ifTrue: [aStream nextPut: $)]].
	colTypes isEmpty ifFalse: [aStream nextPut: $)]!

printTypeFor: aString on: aStream 
	| types |
	types := (self guessTypesFor: aString) 
				asSortedCollection: [:a :b | a name < b name].
	1 to: types size
		do: 
			[:i | 
			i == 1 ifFalse: [aStream nextPutAll: ' | '].
			self 
				printType: (types at: i)
				for: aString
				on: aStream]! !

!RefactoryTyper methodsFor: 'private'!

executeSearch: searcher
	class withAllSubclasses do: [:each |
		each selectors do: [:sel | | parseTree |
			methodName := sel.
			parseTree := each parseTreeFor: sel.
			parseTree notNil ifTrue: [searcher executeTree: (parseTree)]]]!

rootClasses
	^Class rootsOfTheWorld! !

!RefactoryTyper methodsFor: 'selectors'!

computeMessagesSentToVariables
	| searcher |
	variableMessages := Dictionary new.
	class instVarNames do: [:each | variableMessages at: each put: Set new].
	searcher := ParseTreeSearcher new.
	class instVarNames do: 
			[:each | 
			| block |
			block := 
					[:aNode :answer | 
					(variableMessages at: each ifAbsentPut: [Set new]) add: aNode selector.
					self processCollectionMessagesFor: each in: aNode].
			searcher matches: each , ' `@messageName: ``@args' do: block.
			(backpointers at: each) do: 
					[:sel | 
					sel isSymbol 
						ifTrue: 
							[searcher 
								matches: ('(self <1s>) `@messageName: ``@args' 
										expandMacrosWith: (ParseTreeSearcher buildSelectorString: sel)) asString
								do: block]]].
	searcher answer: variableMessages.
	self executeSearch: searcher! !

!RefactoryTyper methodsFor: 'selectors-collections'!

processCollectionFor: key messagesTo: aName in: aBlock 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: aName , ' `@message: ``@args'
		do: 
			[:aNode :answer | 
			self processCollectionMessagesFor: key in: aNode.
			answer
				add: aNode selector;
				yourself].
	searcher executeTree: aBlock
		initialAnswer: (variableMessages at: (self collectionNameFor: key)
				ifAbsentPut: [Set new])!

processCollectionMessagesFor: variableName in: aParseTree 
	| parent block |
	aParseTree isMessage ifFalse: [^self].
	(#(#first #at: #last) includes: aParseTree selector) 
		ifTrue: 
			[parent := aParseTree parent.
			(parent notNil and: [parent isMessage]) ifFalse: [^self].
			aParseTree == parent receiver ifFalse: [^self].
			(variableMessages at: (self collectionNameFor: variableName)
				ifAbsentPut: [Set new]) add: parent selector.
			self processCollectionMessagesFor: (self collectionNameFor: variableName)
				in: parent].
	(#(#do: #do:separatedBy: #collect: #reject: #select: #detect: #detect:ifNone:) 
		includes: aParseTree selector) 
			ifTrue: 
				[block := aParseTree arguments first.
				block isBlock ifFalse: [^self].
				self 
					processCollectionFor: variableName
					messagesTo: block arguments first name
					in: block].
	#inject:into: == aParseTree selector 
		ifTrue: 
			[block := aParseTree arguments last.
			block isBlock ifFalse: [^self].
			self 
				processCollectionFor: variableName
				messagesTo: block arguments last name
				in: block]! !

RefactoryTyper class
	instanceVariableNames: ''!



!RefactoryTyper class methodsFor: 'accessing'!

typesFor: variableName in: aParseTree 
	| searcher messages |
	searcher := ParseTreeSearcher new.
	searcher matches: variableName , ' `@message: ``@args'
		do: 
			[:aNode :answer | 
			answer
				add: aNode selector;
				yourself].
	messages := searcher executeTree: aParseTree initialAnswer: Set new.
	^self new findTypeFor: messages! !

!RefactoryTyper class methodsFor: 'instance creation'!

new
	^(super new) initialize;
		yourself! !


!Behavior methodsFor: 'RefactoringBrowser'!

whichClassDefinesClassVar: aString 
	^self whichClassSatisfies: 
			[:aClass | 
			(aClass classVarNames collect: [:each | each asString]) 
				includes: aString asString]!

whichClassDefinesInstVar: aString 
	^self whichClassSatisfies: [:aClass | aClass instVarNames includes: aString]!

whichClassSatisfies: aBlock 
	(aBlock value: self) ifTrue: [^self].
	^superclass isNil 
		ifTrue: [nil]
		ifFalse: [superclass whichClassSatisfies: aBlock]! !

RefactoryChange subclass: #RefactoryBuilder
	instanceVariableNames: 'changes '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!

RefactoryBuilder comment:
'RefactoryBuilder represents a series of changes (RefactoryChange) that need to be performed. It provides transaction-like behavior by defering all changes until it is told to commit them (#doIt).

Instance Variables:
	changes	<SequenceableCollection of: RefactoryChange>	the changes that need to be performed'!


!RefactoryBuilder methodsFor: 'initialize-release'!

initialize
	super initialize.
	changes := OrderedCollection new! !

!RefactoryBuilder methodsFor: 'refactory-changes'!

addClassVariable: variableName to: aClass 
	changes add: (AddClassVariableChange add: variableName to: aClass)!

addInstanceVariable: variableName to: aClass 
	changes add: (AddInstanceVariableChange add: variableName to: aClass)!

addPool: aPoolVariable to: aClass 
	changes add: (AddPoolVariableChange add: aPoolVariable to: aClass)!

compile: source in: class 
	changes add: (AddMethodChange compile: source in: class)!

compile: source in: class classified: aProtocol 
	changes add: (AddMethodChange 
				compile: source
				in: class
				classified: aProtocol)!

defineClass: aString 
	changes add: (AddClassChange definition: aString)!

removeClass: aClass 
	changes add: (RemoveClassChange removeClassName: aClass)!

removeClassVariable: variableName from: aClass 
	changes add: (RemoveClassVariableChange remove: variableName from: aClass)!

removeInstanceVariable: variableName from: aClass 
	changes 
		add: (RemoveInstanceVariableChange remove: variableName from: aClass)!

removeMethod: aSelector from: aClass 
	changes add: (RemoveMethodChange remove: aSelector from: aClass)!

renameClass: class to: newName 
	changes add: (RenameClassChange rename: class name to: newName)! !

!RefactoryBuilder methodsFor: 'printing'!

displayString
	^super displayString asText allBold!

printOn: aStream 
	aStream nextPutAll: name! !

!RefactoryBuilder methodsFor: 'user interface'!

inspect
	RefactoryBuilderInspector openOn: self! !

!RefactoryBuilder methodsFor: 'private-inspector accessing'!

changes
	^changes!

changes: aCollection 
	changes := aCollection!

removeChange: aChange 
	changes remove: aChange ifAbsent: []! !

!RefactoryBuilder methodsFor: 'accessing'!

addChange: aRefactoryChange
	changes add: aRefactoryChange!

addChangeFirst: aRefactoryChange
	changes addFirst: aRefactoryChange!

changesSize
	^changes inject: 0 into: [:sum :each | sum + each changesSize]!

renameChangesForClass: aClassName to: newClassName 
	^(self copy)
		changes: (self changes 
					collect: [:each | each renameChangesForClass: aClassName to: newClassName]);
		yourself! !

!RefactoryBuilder methodsFor: 'private'!

executeNotifying: aBlock 
	| undos undo |
	undos := changes collect: [:each | each executeNotifying: aBlock].
	undo := self copy.
	undo changes: undos reverse.
	^undo!

flattenOnto: aCollection 
	changes do: [:each | each flattenOnto: aCollection]! !

!RefactoryBuilder methodsFor: 'comparing'!

= aRefactoryBuilder 
	self class = aRefactoryBuilder class ifFalse: [^false].
	changes size = aRefactoryBuilder size ifFalse: [^false].
	1 to: changes size
		do: [:i | (changes at: i) = (aRefactoryBuilder changes at: i) ifFalse: [^false]].
	^true!

hash
	^changes size! !

!RefactoryBuilder methodsFor: 'copying'!

postCopy
	super postCopy.
	changes := changes collect: [:each | each copy]! !

RefactoryBuilder class
	instanceVariableNames: ''!



!RefactoryBuilder class methodsFor: 'instance creation'!

named: aString 
	^(self new)
		name: aString;
		yourself! !

Refactoring subclass: #MethodRefactoring
	instanceVariableNames: 'class '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!MethodRefactoring methodsFor: 'private'!

buildSelectorString: aSelector 
	aSelector numArgs = 0 ifTrue: [^aSelector].
	^self buildSelectorString: aSelector
		withPermuteMap: (1 to: aSelector numArgs)!

buildSelectorString: aSelector withPermuteMap: anIntegerCollection 
	| stream keywords |
	aSelector numArgs == 0 ifTrue: [^aSelector asString].
	stream := WriteStream on: String new.
	keywords := aSelector keywords.
	1 to: keywords size
		do: 
			[:i | 
			stream
				nextPutAll: (keywords at: i);
				nextPutAll: ' ``@arg';
				nextPutAll: (anIntegerCollection at: i) printString;
				nextPut: $ ].
	^stream contents! !

MethodRefactoring class
	instanceVariableNames: ''!


MethodRefactoring subclass: #InlineMethodRefactoring
	instanceVariableNames: 'sourceInterval inlineParseTree sourceParseTree sourceSelector sourceMessage inlineClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!InlineMethodRefactoring methodsFor: 'initialize-release'!

inline: anInterval inMethod: aSelector forClass: aClass 
	sourceSelector := aSelector.
	class := aClass.
	sourceInterval := anInterval! !

!InlineMethodRefactoring methodsFor: 'performing'!

addSelfReturn
	inlineParseTree addSelfReturn!

addTemporary: sourceNode assignedTo: replacementNode 
	| newName |
	newName := self renameConflictingTemporary: sourceNode name.
	(inlineParseTree body)
		addTemporaryNamed: newName;
		addNodeFirst: (BRAssignmentNode variable: (BRVariableNode named: newName)
					value: replacementNode)!

checkSuperMessages
	self inlineClass = class ifTrue: [^self].
	self inlineClass superclass isNil ifTrue: [^self].
	inlineParseTree superMessages do: 
			[:each | 
			(self inlineClass superclass whichClassIncludesSelector: each) 
				= (class superclass whichClassIncludesSelector: each) 
					ifFalse: 
						[self 
							refactoringError: ('Cannot inline method since it sends a super message <1s> that is overriden' 
									expandMacrosWith: each)]]!

compileMethod
	self 
		performChange: (AddMethodChange compile: sourceParseTree formattedCode
				in: class)!

findSelectedMessage
	sourceParseTree := class parseTreeFor: sourceSelector.
	sourceParseTree isNil 
		ifTrue: [self refactoringError: 'Could not parse sources'].
	sourceMessage := sourceParseTree whichNodeIsContainedBy: sourceInterval.
	sourceMessage isNil 
		ifTrue: 
			[self 
				refactoringError: 'The selection doesn''t appear to be a message send'].
	sourceMessage isCascade 
		ifTrue: [sourceMessage := sourceMessage messages last].
	sourceMessage isMessage 
		ifFalse: 
			[self 
				refactoringError: 'The selection doesn''t appear to be a message send'].
	(sourceMessage receiver isVariable 
		and: [#('self' 'super') includes: sourceMessage receiver name]) 
			ifFalse: [self refactoringError: 'Cannot inline non-self messages']!

inlineClass
	^inlineClass isNil 
		ifTrue: 
			[inlineClass := (sourceMessage receiver name = 'super' 
						ifTrue: [class superclass]
						ifFalse: [class]) whichClassIncludesSelector: self inlineSelector]
		ifFalse: [inlineClass]!

inlineSelector
	sourceMessage isNil ifTrue: [self findSelectedMessage].
	^sourceMessage selector!

inlineSourceReplacing: aParseTree 
	| statements nodeUnderSequence |
	statements := inlineParseTree body statements.
	(statements size > 1 and: [aParseTree isEvaluatedFirst not]) 
		ifTrue: 
			[self refactoringWarning: 'To inline this method, we need to move some of its statements before the original message send.<n>This could change the order of execution, which can change the behavior.<n>Do you want to proceed?' 
						expandMacros].
	nodeUnderSequence := aParseTree.
	[nodeUnderSequence parent isSequence] 
		whileFalse: [nodeUnderSequence := nodeUnderSequence parent].
	(nodeUnderSequence parent)
		addNodes: (statements copyFrom: 1 to: (statements size - 1 max: 0))
			before: nodeUnderSequence;
		addTemporariesNamed: inlineParseTree body temporaryNames.
	aParseTree parent replaceNode: aParseTree
		withNode: (statements isEmpty 
				ifTrue: [BRVariableNode named: 'self']
				ifFalse: [statements last])!

insertInlinedMethod
	| node |
	node := sourceMessage.
	self moveComments.
	node parent isCascade 
		ifTrue: 
			[self rewriteCascadedMessage.
			node := node parent].
	node parent isReturn 
		ifTrue: [node := node parent]
		ifFalse: [self removeReturns].
	self replaceArguments.
	self inlineSourceReplacing: node.
	sourceParseTree removeDeadCode.
	self removeEmptyIfTrues.
	self removeImmediateBlocks!

isPrimitive
	^inlineParseTree isPrimitive!

moveComments
	inlineParseTree nodesDo: 
			[:each | 
			each 
				comments: (each comments collect: 
							[:anInterval | 
							| start stop source |
							source := sourceParseTree source.
							start := source size + 1.
							source := source 
										, (inlineParseTree source copyFrom: anInterval first to: anInterval last).
							stop := source size.
							sourceParseTree source: source.
							start to: stop])]!

normalizeIfTrues
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter
		replace: '| `@temps | ``@.s1. ``@boolean ifTrue: [| `@t1 | ``@.Stmts1. ^`@r1]. ``@.s2. ^``@r2'
			with: '| `@temps | ``@.s1. ``@boolean ifTrue: [| `@t1 | ``@.Stmts1. ^`@r1] ifFalse: [``@.s2. ^``@r2]';
		replace: '| `@temps | ``@.s1. ``@boolean ifFalse: [| `@t1 | ``@.Stmts1. ^`@r1]. ``@.s2. ^``@r2'
			with: '| `@temps | ``@.s1. ``@boolean ifTrue: [``@.s2. ^``@r2] ifFalse: [| `@t1 | ``@.Stmts1. ^`@r1]'.
	[rewriter executeTree: inlineParseTree] 
		whileTrue: [inlineParseTree := rewriter tree]!

normalizeReturns
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter
		replace: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ^``@r1] ifFalse: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ``@r1] ifFalse: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ^``@r1] ifTrue: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ``@r1] ifTrue: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ``@r1] ifFalse: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ``@r1] ifFalse: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ``@r1] ifTrue: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ``@r1] ifTrue: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ^``@r1] ifFalse: [| `@t2 | `@.Stmts2. ``@r2]'
			with: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ``@r1] ifFalse: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ^``@r1] ifTrue: [| `@t2 | `@.Stmts2. ``@r2]'
			with: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ``@r1] ifTrue: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '``@boolean ifTrue: [| `@t1 | `@.Stmts1. ^``@r1] ifFalse: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifTrue: [| `@t1 | `@.Stmts1. ``@r1] ifFalse: [| `@t2 | `@.Stmts2. ``@r2]';
		replace: '``@boolean ifFalse: [| `@t1 | `@.Stmts1. ^``@r1] ifTrue: [| `@t2 | `@.Stmts2. ^``@r2]'
			with: '^``@boolean ifFalse: [| `@t1 | `@.Stmts1. ``@r1] ifTrue: [| `@t2 | `@.Stmts2. ``@r2]'.
	[rewriter executeTree: inlineParseTree] 
		whileTrue: [inlineParseTree := rewriter tree]!

parseInlineMethod
	self inlineClass isNil 
		ifTrue: 
			[self 
				refactoringError: ('<1p> or its superclasses don''t contain method <2s>' 
						expandMacrosWith: class
						with: self inlineSelector)].
	inlineParseTree := self inlineClass parseTreeFor: self inlineSelector.
	inlineParseTree isNil 
		ifTrue: [self refactoringError: 'Could not parse sources'].
	inlineParseTree lastIsReturn ifFalse: [inlineParseTree addSelfReturn]!

performRefactoring
	self renameConflictingTemporaries.
	self insertInlinedMethod.
	self compileMethod!

preconditions
	^(Condition definesSelector: sourceSelector in: class) 
		& (Condition withBlock: 
					[self findSelectedMessage.
					self isOverridden 
						ifTrue: 
							[self 
								refactoringWarning: ('<1p>>><2s> is overriden. Do you want to inline it anyway?' 
										expandMacrosWith: self inlineClass
										with: self inlineSelector)].
					self parseInlineMethod.
					self isPrimitive 
						ifTrue: [self refactoringError: 'Cannot inline primitives'].
					self checkSuperMessages.
					self rewriteInlinedTree.
					(sourceMessage parent isReturn or: [self hasMultipleReturns not]) 
						ifFalse: 
							[self 
								refactoringError: 'Cannot inline method since it contains multiple returns that cannot be rewritten'].
					true])!

removeEmptyIfTrues
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter
		replace: '``@boolean ifTrue: [] ifFalse: [| `@temps | ``@.Stmts]'
			with: '``@boolean ifFalse: [|`@temps | ``@.Stmts]';
		replace: '``@boolean ifFalse: [] ifTrue: [| `@temps | ``@.Stmts]'
			with: '``@boolean ifTrue: [|`@temps | ``@.Stmts]';
		replace: '``@boolean ifTrue: [| `@temps | ``@.Stmts] ifFalse: []'
			with: '``@boolean ifTrue: [|`@temps | ``@.Stmts]';
		replace: '``@boolean ifFalse: [| `@temps | ``@.Stmts] ifTrue: []'
			with: '``@boolean ifFalse: [|`@temps | ``@.Stmts]'.
	(rewriter executeTree: sourceParseTree) 
		ifTrue: [sourceParseTree := rewriter tree]!

removeImmediateBlocks
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter 
		replace: '[``.object] value'
		with: '``.object'
		when: [:aNode | aNode parent isCascade not].
	rewriter 
		replace: '| `@temps | ``@.Stmts1. [| `@bTemps | ``@.bStmts] value. ``@.Stmts2'
		with: '| `@temps `@bTemps | ``@.Stmts1. ``@.bStmts. ``@.Stmts2'.
	(rewriter executeTree: sourceParseTree) 
		ifTrue: [sourceParseTree := rewriter tree]!

removeReturns
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter replace: '^``@object' with: '``@object'.
	(rewriter executeTree: inlineParseTree) 
		ifTrue: [inlineParseTree := rewriter tree]!

renameConflictingTemporaries
	inlineParseTree allDefinedVariables 
		do: [:each | self renameConflictingTemporary: each]!

renameConflictingTemporary: aName 
	| allNames newName index seqNode |
	allNames := (Set new)
				addAll: inlineParseTree body allDefinedVariables;
				yourself.
	allNames remove: aName ifAbsent: [].
	seqNode := sourceMessage.
	[seqNode isSequence] 
		whileFalse: [seqNode := seqNode parent].
	allNames addAll: seqNode allDefinedVariables.	"Add those variables defined in blocks. This might cause a few 
													variables to be renamed that don't need to be, but this should be safe."
	newName := aName.
	index := 0.
	
	[(sourceMessage whoDefines: newName) notNil or: 
			[(self allSubtreeVarsIn: class includes: newName) 
				or: [allNames includes: newName]]] 
			whileTrue: 
				[index := index + 1.
				newName := aName , index printString].
	newName = aName ifFalse: [self renameTemporary: aName to: newName].
	^newName!

renameTemporary: oldName to: newName 
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter
		replace: oldName with: newName;
		replaceArgument: oldName with: newName.
	(rewriter executeTree: inlineParseTree) 
		ifTrue: [inlineParseTree := rewriter tree]!

replaceArgument: sourceNode with: replacementNode 
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter replaceTree: sourceNode withTree: replacementNode.
	(rewriter executeTree: inlineParseTree body) 
		ifTrue: [inlineParseTree body: rewriter tree]!

replaceArguments
	sourceMessage arguments reverse with: inlineParseTree arguments reverse
		do: 
			[:replacement :source | 
			(replacement isImmediate or: 
					[self 
						confirm: ('Do you want to inline "<1s>"? If not, it will be assigned as a temporary.' 
								expandMacrosWith: replacement formattedCode)]) 
				ifTrue: [self replaceArgument: source with: replacement]
				ifFalse: [self addTemporary: source assignedTo: replacement]]!

rewriteCascadedMessage
	| index messages |
	messages := sourceMessage parent messages.
	index := (1 to: messages size) 
				detect: [:i | sourceMessage == (messages at: i)]
				ifNone: [0].
	inlineParseTree body addNodesFirst: (messages copyFrom: 1 to: index - 1).
	self removeReturns.
	inlineParseTree body 
		addNodes: (messages copyFrom: index + 1 to: messages size).
	inlineParseTree addReturn!

rewriteInlinedTree
	sourceMessage parent isReturn 
		ifTrue: 
			[(sourceParseTree isLast: sourceMessage parent) 
				ifFalse: [self addSelfReturn]]
		ifFalse: 
			[self
				writeGuardClauses;
				normalizeIfTrues;
				normalizeReturns;
				addSelfReturn]!

writeGuardClauses
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter
		replaceMethod: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [| `@t1 | `@.Stmts1. ^`@r1]. `@.s2. ^`@r2'
			with: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [| `@t1 | `@.Stmts1. ^`@r1] ifFalse: [`@.s2. ^`@r2]';
		replaceMethod: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifFalse: [| `@t1 | `@.Stmts1. ^`@r1]. `@.s2. ^`@r2'
			with: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [`@.s2. ^`@r2] ifFalse: [| `@t1 | `@.Stmts1. ^`@r1]';
		replaceMethod: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [| `@t1 | `@.Stmts1. ^`@r1]. `@.s2'
			with: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [| `@t1 | `@.Stmts1. ^`@r1] ifFalse: [`@.s2. ^self]';
		replaceMethod: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifFalse: [| `@t1 | `@.Stmts1. ^`@r1]. `@.s2'
			with: '`@methodName: `@args | `@temps | `@.s1. `@boolean ifTrue: [`@.s2. ^self] ifFalse: [| `@t1 | `@.Stmts1. ^`@r1]'.
	[rewriter executeTree: inlineParseTree] 
		whileTrue: [inlineParseTree := rewriter tree]! !

!InlineMethodRefactoring methodsFor: 'testing'!

hasMultipleReturns
	"Do we have multiple returns? If the last statement isn't a return, then we have an implicit return of self."

	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: '^``@object'
		do: 
			[:aNode :hasAReturn | 
			hasAReturn ifTrue: [^true].
			true].
	searcher executeTree: inlineParseTree
		initialAnswer: inlineParseTree lastIsReturn not.
	^false!

isOverridden
	^(class allSubclasses 
		detect: [:each | each includesSelector: self inlineSelector]
		ifNone: [nil]) notNil! !

InlineMethodRefactoring class
	instanceVariableNames: ''!



!InlineMethodRefactoring class methodsFor: 'instance creation'!

inline: anInterval inMethod: aSelector forClass: aClass 
	^self new 
		inline: anInterval
		inMethod: aSelector
		forClass: aClass! !

MethodRefactoring subclass: #PushUpMethodRefactoring
	instanceVariableNames: 'removeDuplicates selectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PushUpMethodRefactoring methodsFor: 'initialize-release'!

pushUp: selectorCollection from: aClass 
	class := aClass.
	selectors := selectorCollection.
	removeDuplicates := false! !

!PushUpMethodRefactoring methodsFor: 'performing'!

checkBackReferencesTo: aSelector 
	| definingClass pushUpMethod |
	definingClass := class superclass whichClassIncludesSelector: aSelector.
	definingClass isNil ifTrue: [^self].
	pushUpMethod := class compiledMethodAt: aSelector.
	class superclass allSubclasses do: 
			[:each | 
			each selectors do: 
					[:sel | 
					| method |
					method := each compiledMethodAt: sel.
					((method superMessages includes: aSelector)
						and: [definingClass == (each whichClassIncludesSelector: aSelector)])
							ifTrue: 
								[removeDuplicates := true.
								(aSelector == sel and: [method equivalentTo: pushUpMethod]) ifFalse: 
										[self
											refactoringError: ('Cannot push up <1s> since it would override the method defined in <2p>'
													expandMacrosWith: aSelector
													with: definingClass)]]]]!

checkClassVars
	selectors do: [:each | self checkClassVarsFor: each]!

checkClassVarsFor: aSelector 
	| method |
	method := class compiledMethodAt: aSelector.
	class classPool associationsDo: 
			[:each | 
			(method refersToLiteral: each) ifTrue: 
					[self
						refactoringError: ('<1p> refers to <2s> which is defined in <3p>' expandMacrosWith: aSelector
								with: each key
								with: class)]]!

checkInstVars
	selectors do: [:each | self checkInstVarsFor: each]!

checkInstVarsFor: aSelector 
	class instVarNames do: 
			[:each | 
			((class whichSelectorsAccess: each) includes: aSelector) ifTrue: 
					[self
						refactoringError: ('<1p> refers to <2s> which is defined in <3p>' expandMacrosWith: aSelector
								with: each
								with: class)]]!

checkSuperclass
	| overrideSelectors |
	overrideSelectors := selectors select: [:each | class superclass canUnderstand: each].
	overrideSelectors := overrideSelectors reject: 
					[:each | 
					| pushUpMethod definingClass |
					definingClass := class superclass whichClassIncludesSelector: each.
					pushUpMethod := class compiledMethodAt: each.
					(definingClass compiledMethodAt: each) equivalentTo: pushUpMethod].
	overrideSelectors isEmpty ifTrue: [^self].
	(self isAbstract: class superclass) ifFalse: 
			[self refactoringError: ('Non-abstract class <2p> already defines <1p>'
						expandMacrosWith: overrideSelectors asArray first
						with: class superclass)].
	overrideSelectors do: [:each | self checkBackReferencesTo: each]!

checkSuperMessages
	selectors do: 
			[:each | 
			| method |
			method := class compiledMethodAt: each.
			(method superMessages
				detect: [:sup | class superclass includesSelector: sup]
				ifNone: [nil]) notNil ifTrue: 
					[self
						refactoringError: ('Cannot push up <1s> since it sends a super message that is defined in the superclass.'
								expandMacrosWith: each)]]!

copyDownMethod: aSelector using: builder 
	| oldProtocol oldSource superclassDefiner subclasses |
	superclassDefiner := class superclass whichClassIncludesSelector: aSelector.
	superclassDefiner isNil ifTrue: [^self].
	oldSource := superclassDefiner sourceCodeAt: aSelector.
	oldSource isNil ifTrue: 
			[self refactoringError: ('Source code for <1s> superclass method not available'
						expandMacrosWith: aSelector)].
	oldProtocol := superclassDefiner whichCategoryIncludesSelector: aSelector.
	subclasses := class superclass subclasses
				reject: [:each | each includesSelector: aSelector].
	subclasses isEmpty ifTrue: [^self].
	((superclassDefiner compiledMethodAt: aSelector) superMessages
		detect: [:each | superclassDefiner includesSelector: each]
		ifNone: [nil]) notNil ifTrue: 
			[self refactoringError: ('Cannot push up <1s> since we must copy down the superclass method in <2p><n>to the other subclasses, and the superclass method sends a super message which is overriden.'
						expandMacrosWith: aSelector
						with: superclassDefiner)].
	self refactoringWarning: 'Do you want to copy down the superclass method to the classes that don''t define '
				, aSelector.
	subclasses do: 
			[:each | 
			builder compile: oldSource
				in: each
				classified: oldProtocol]!

copyDownMethodsUsing: builder 
	selectors do: [:each | self copyDownMethod: each using: builder]!

performRefactoring
	| builder |
	builder := RefactoryBuilder named: 'Push up methods'.
	self copyDownMethodsUsing: builder.
	selectors do: [:each | self pushUp: each using: builder].
	self performChange: builder.
	builder := RefactoryBuilder named: 'Remove pushed up methods'.
	selectors do: [:each | builder removeMethod: each from: class].
	self performChange: builder.
	selectors do: [:each | self removeDuplicatesOf: each]!

preconditions
	^(selectors
		inject: (Condition isClass: class) & (Condition hasSuperclass: class)
		into: [:cond :each | cond & (Condition definesSelector: each in: class)])
			& (Condition withBlock: 
						[self checkInstVars.
						self checkClassVars.
						self checkSuperclass.
						self checkSuperMessages.
						true])!

pushUp: aSelector using: builder 
	| method source |
	method := class compiledMethodAt: aSelector.
	source := method getSource.
	source isNil
		ifTrue: [self refactoringError: 'Source for method not available'].
	builder compile: source
		in: class superclass
		classified: (class whichCategoryIncludesSelector: aSelector)!

removeDuplicatesOf: aSelector 
	| method builder |
	method := class superclass compiledMethodAt: aSelector.
	builder := RefactoryBuilder named: 'Remove duplicate methods'.
	class superclass allSubclassesDo: 
			[:each | 
			((each includesSelector: aSelector) and: 
					[((each compiledMethodAt: aSelector) equivalentTo: method) and: 
							[(each superclass whichClassIncludesSelector: aSelector) 
								== class superclass]]) 
				ifTrue: 
					[removeDuplicates 
						ifFalse: 
							[removeDuplicates := true.
							self 
								refactoringWarning: 'Do you want to remove duplicate subclass methods?'].
					builder removeMethod: aSelector from: each]].
	self performChange: builder! !

PushUpMethodRefactoring class
	instanceVariableNames: ''!



!PushUpMethodRefactoring class methodsFor: 'instance creation'!

pushUp: selectorCollection from: aClass 
	^self new pushUp: selectorCollection from: aClass! !

MethodRefactoring subclass: #ExtractToTemporaryRefactoring
	instanceVariableNames: 'sourceInterval selector newVariableName sourceTree '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ExtractToTemporaryRefactoring methodsFor: 'performing'!

checkVariableName
	(class whichClassDefinesInstVar: newVariableName) notNil 
		ifTrue: 
			[self refactoringError: ('<1p> defines an instance variable named <2s>' 
						expandMacrosWith: class
						with: newVariableName)].
	(class whichClassDefinesClassVar: newVariableName) notNil 
		ifTrue: 
			[self refactoringError: ('<1p> defines a class variabled named <2s>' 
						expandMacrosWith: class
						with: newVariableName)].
	(self parseTree allDefinedVariables includes: newVariableName) 
		ifTrue: 
			[self refactoringError: ('<1s> is already a temporary variable name' 
						expandMacrosWith: newVariableName)]!

compileNewMethod
	self 
		performChange: (AddMethodChange compile: sourceTree formattedCode in: class)!

constructAssignmentFrom: aNode 
	| valueNode |
	valueNode := BRVariableNode named: newVariableName.
	^BRAssignmentNode variable: valueNode value: aNode!

insertTemporary
	| node statementNode |
	node := sourceTree whichNodeIsContainedBy: sourceInterval.
	(node notNil and: [node isValue]) 
		ifFalse: [self refactoringError: 'Cannot assign to non-value nodes'].
	statementNode := node statementNode.
	node replaceWith: (BRVariableNode named: newVariableName).
	(statementNode parent)
		addNode: (self constructAssignmentFrom: node)
			before: (node == statementNode 
					ifTrue: [BRVariableNode named: newVariableName]
					ifFalse: [statementNode]);
		addTemporaryNamed: newVariableName!

parseTree
	sourceTree isNil 
		ifTrue: 
			[sourceTree := class parseTreeFor: selector.
			sourceTree isNil ifTrue: [self refactoringError: 'Could not parse method']].
	^sourceTree!

performRefactoring
	self parseTree.
	self insertTemporary.
	self compileNewMethod!

preconditions
	^(Condition definesSelector: selector in: class) 
		& (Condition isValidInstVarName: newVariableName for: class) 
			& (Condition withBlock: 
						[self verifySelectedInterval.
						self checkVariableName.
						true])!

selectedSource
	| source |
	source := class sourceCodeAt: selector.
	source isNil ifTrue: [self refactoringError: 'Couldn''t find sources'].
	((sourceInterval first between: 1 and: source size) 
		and: [sourceInterval last between: 1 and: source size]) 
			ifFalse: [self refactoringError: 'Invalid interval'].
	^source copyFrom: sourceInterval first to: sourceInterval last!

verifySelectedInterval
	| selectedParseTree selectedSources |
	selectedSources := self selectedSource.
	selectedParseTree := BRParser parseExpression: selectedSources
				onError: [:message :position | self refactoringError: 'Invalid selection'].
	selectedParseTree isSequence 
		ifTrue: [self refactoringError: 'Cannot assign temp to multiple statements']! !

!ExtractToTemporaryRefactoring methodsFor: 'initialize-release'!

extract: anInterval to: aString from: aSelector in: aClass 
	class := aClass.
	selector := aSelector.
	sourceInterval := anInterval.
	newVariableName := aString! !

ExtractToTemporaryRefactoring class
	instanceVariableNames: ''!



!ExtractToTemporaryRefactoring class methodsFor: 'instance creation'!

extract: anInterval to: aString from: aSelector in: aClass 
	^self new 
		extract: anInterval
		to: aString
		from: aSelector
		in: aClass! !

MethodRefactoring subclass: #InlineAllSendersRefactoring
	instanceVariableNames: 'selector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!InlineAllSendersRefactoring methodsFor: 'initialize-release'!

sendersOf: aSelector in: aClass
	class := aClass.
	selector := aSelector! !

!InlineAllSendersRefactoring methodsFor: 'performing'!

performRefactoring
	| numberReplaced numberNotReplaced |
	numberReplaced := numberNotReplaced := 0.
	class withAllSubclasses do: 
			[:each | 
			each selectors do: 
					[:sel | 
					| node replaced |
					replaced := true.
					[replaced and: [(node := self selfSendIn: (each parseTreeFor: sel)) notNil]] 
						whileTrue: 
							[self onError: 
									[self performComponentRefactoring: (InlineMethodRefactoring 
												inline: node sourceInterval
												inMethod: sel
												forClass: each).
									numberReplaced := numberReplaced + 1]
								do: 
									[numberNotReplaced := numberNotReplaced + 1.
									replaced := false]]]].
	self removeMethod.
	numberReplaced = 0 
		ifTrue: [self refactoringError: 'Could not inline any senders'].
	numberNotReplaced = 0 ifTrue: [^self].
	self 
		refactoringError: 'Could not perform inlining in ' 
				, numberNotReplaced printString , ' methods'!

preconditions
	^(Condition canUnderstand: selector in: class)!

removeMethod
	self onError: 
			[self performComponentRefactoring: (RemoveMethodRefactoring 
						removeMethods: (Array with: selector)
						from: class)]
		do: []!

selfSendIn: aTree 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: 'self ' , (self buildSelectorString: selector)
		do: [:aNode :answer | ^aNode].
	^searcher executeTree: aTree initialAnswer: nil! !

InlineAllSendersRefactoring class
	instanceVariableNames: ''!



!InlineAllSendersRefactoring class methodsFor: 'instance creation'!

sendersOf: aSelector in: aClass 
	^self new sendersOf: aSelector in: aClass! !

MethodRefactoring subclass: #AddMethodRefactoring
	instanceVariableNames: 'protocols source '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AddMethodRefactoring methodsFor: 'initialize-release'!

addMethod: aString toClass: aClass inProtocols: protocolList 
	class := aClass.
	source := aString.
	protocols := protocolList! !

!AddMethodRefactoring methodsFor: 'performing'!

performRefactoring
	self performChange: (AddMethodChange 
				compile: source
				in: class
				classified: protocols)!

preconditions
	| selector method |
	method := BRParser parseMethod: source
				onError: 
					[:string :position | 
					^Condition 
						withBlock: [self refactoringError: 'The sources could not be parsed']].
	selector := method selector.
	selector isNil ifTrue: [self refactoringError: 'Invalid source.'].
	^(Condition canUnderstand: selector in: class) not! !

AddMethodRefactoring class
	instanceVariableNames: ''!



!AddMethodRefactoring class methodsFor: 'instance creation'!

addMethod: aString toClass: aClass inProtocols: protocolList 
	^self new addMethod: aString
		toClass: aClass
		inProtocols: protocolList! !

MethodRefactoring subclass: #TempToInstVarRefactoring
	instanceVariableNames: 'selector tempVar '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!TempToInstVarRefactoring methodsFor: 'initialize-release'!

class: aClass selector: aSelector variable: aVariableName 
	class := aClass.
	selector := aSelector.
	tempVar := aVariableName! !

!TempToInstVarRefactoring methodsFor: 'performing'!

checkForValidTemporaryVariable
	| parseTree |
	parseTree := class parseTreeFor: selector.
	(parseTree allTemporaryVariables includes: tempVar) 
		ifFalse: 
			[self refactoringError: tempVar , ' isn''t a valid temporary variable name'].
	(parseTree allArgumentVariables includes: tempVar) 
		ifTrue: [self refactoringError: tempVar , ' is a block parameter'].
	(BRReadBeforeWrittenTester readBeforeWritten: (Array with: tempVar)
		in: parseTree) isEmpty 
		ifFalse: 
			[self refactoringWarning: ('<1s> is read before it is written.<n>Proceed anyway?' 
						expandMacrosWith: tempVar)]!

performRefactoring
	| parseTree matcher changeBuilder |
	changeBuilder := RefactoryBuilder 
				named: 'Convert temporary to instance variable'.
	parseTree := class parseTreeFor: selector.
	changeBuilder addInstanceVariable: tempVar to: class.
	(matcher := ParseTreeRewriter removeTemporaryNamed: tempVar) 
		executeTree: parseTree.
	changeBuilder compile: matcher tree printString in: class.
	self performChange: changeBuilder!

preconditions
	^(Condition isClass: class) 
		& (Condition definesSelector: selector in: class)
		& (Condition hierarchyOf: class definesVar: tempVar asString) not
		& (Condition withBlock: 
					[self checkForValidTemporaryVariable.
					true])! !

TempToInstVarRefactoring class
	instanceVariableNames: ''!



!TempToInstVarRefactoring class methodsFor: 'instance creation'!

class: aClass selector: aSelector variable: aVariableName 
	^self new 
		class: aClass
		selector: aSelector
		variable: aVariableName! !

MethodRefactoring subclass: #MoveMethodRefactoring
	instanceVariableNames: 'selector variable moveToClasses parseTree hasOnlySelfReturns selfVariableName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!MoveMethodRefactoring methodsFor: 'initialize-release'!

selector: aSymbol class: aClass variable: aVariableName 
	selector := aSymbol.
	class := aClass.
	variable := aVariableName! !

!MoveMethodRefactoring methodsFor: 'performing'!

abstractVariables
	self performComponentRefactoring: self abstractVariablesRefactoring.
	parseTree := self abstractVariablesRefactoring parseTree!

abstractVariablesRefactoring
	^AbstractVariablesRefactoring 
		abstractVariablesIn: parseTree
		from: class
		toAll: moveToClasses
		ignoring: variable!

addSelfReturn
	self hasOnlySelfReturns ifTrue: [^self].
	parseTree addSelfReturn!

checkAssignmentsToVariable
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: variable , ' := `@object' do: [:aNode :answer | true].
	(searcher executeTree: parseTree initialAnswer: false) 
		ifTrue: 
			[self refactoringError: ('Cannot move the method into <1s> since it is assigned' 
						expandMacrosWith: variable)]!

checkForSuperReferences
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: 'super `@message: `@args' do: [:aNode :answer | true].
	(searcher executeTree: parseTree initialAnswer: false) 
		ifTrue: 
			[self refactoringError: 'Cannot move the method since it has a super message send.']!

checkTemporaryVariableNames
	| varNames |
	varNames := parseTree allDefinedVariables.
	selfVariableName notNil ifTrue: [varNames add: selfVariableName].
	varNames do: 
			[:name | 
			moveToClasses do: 
					[:each | 
					(self canReferenceVariable: name in: each) 
						ifTrue: 
							[self refactoringError: ('<1p> already defines a variable called <2s>' 
										expandMacrosWith: each
										with: name)]]]!

compileDelagatorMethod
	| statementNode delegatorNode tree |
	delegatorNode := BRMessageNode 
				receiver: (BRVariableNode named: variable)
				selectorParts: parseTree selectorParts
				arguments: (parseTree argumentNames collect: 
							[:each | 
							BRVariableNode 
								named: (each = selfVariableName ifTrue: ['self'] ifFalse: [each])]).
	self hasOnlySelfReturns 
		ifFalse: [delegatorNode := BRReturnNode value: delegatorNode].
	statementNode := BRSequenceNode temporaries: #()
				statements: (Array with: delegatorNode).
	(tree := class parseTreeFor: selector) body: statementNode.
	self 
		performChange: (AddMethodChange compile: tree formattedCode in: class)!

compileNewMethods
	| builder |
	builder := RefactoryBuilder named: 'Moved methods'.
	moveToClasses do: 
			[:each | 
			builder 
				compile: parseTree formattedCode
				in: each
				classified: (BrowserEnvironment new whichProtocolIncludes: selector
						in: class)].
	self performChange: builder!

getArgumentNameForSelf
	self needsToReplaceSelfReferences ifFalse: [^self].
	
	[selfVariableName := self 
				request: 'Enter name for argument to refer to "self" in extracted method'.
	(self checkInstVarName: selfVariableName in: class) 
		ifFalse: 
			[self 
				refactoringWarning: 'The variable name is not a valid Smalltalk temporary variable name<n>Try again?' 
						expandMacros.
			selfVariableName := nil].
	self verifyTemporaryVariableDoesNotOverride 
		ifFalse: 
			[self 
				refactoringWarning: 'The variable is already defined in one of the classes you''re moving the method to.<n>Try another?' 
						expandMacros.
			selfVariableName := nil].
	selfVariableName isNil] 
			whileTrue: []!

getClassesForInstVar
	| definingClass typer types |
	definingClass := self whichClass: class defines: variable.
	typer := RefactoryTyper new runOn: definingClass.
	types := typer typesFor: variable.
	types isEmpty ifTrue: [types := OrderedCollection with: Object].
	moveToClasses := VariableTypeDialog 
				chooseClassesFromList: types
				initialSelections: (typer guessTypesFor: variable)
				cancel: [self refactoringError: 'Method not moved']!

getClassesForTempVar
	| types |
	types := RefactoryTyper typesFor: variable in: parseTree.
	types isEmpty ifTrue: [types := OrderedCollection with: Object].
	moveToClasses := VariableTypeDialog 
				chooseClassesFromList: types
				initialSelections: types
				cancel: [self refactoringError: 'Method not moved']!

getClassesToMoveTo
	self isMovingToArgument
		ifTrue: [self getClassesForTempVar]
		ifFalse: 
			[self isMovingToInstVar
				ifTrue: [self getClassesForInstVar]
				ifFalse: [self getClassForGlobalOrClassVar]].
	moveToClasses isEmpty
		ifTrue: [self refactoringError: 'No classes selected, method not moved.']!

getClassForGlobalOrClassVar
	| definingClass type |
	definingClass := self whichClass: class definesClassVariable: variable.
	type := definingClass isNil
				ifTrue: [(Smalltalk at: variable asSymbol ifAbsent: [Object basicNew]) class]
				ifFalse: 
					[(self associationForClassVariable: variable
						in: definingClass
						ifAbsent: [nil -> Object basicNew]) value class].
	moveToClasses := VariableTypeDialog chooseClassesFromList: (Array with: type)
				initialSelections: (Array with: type)
				cancel: [self refactoringError: 'Method not moved']!

getNewMethodName
	| newSelector dialog parameters alreadyDefined last |
	parameters := parseTree argumentNames asOrderedCollection.
	parameters remove: variable ifAbsent: [].
	self needsToReplaceSelfReferences 
		ifTrue: [parameters add: selfVariableName].
	last := selector.
	
	[dialog := MethodNameDialog methodNameFor: parameters initial: last.
	dialog open ifFalse: [self refactoringError: 'Did not move method'].
	last := newSelector := dialog methodName.
	parameters := dialog arguments.
	(self checkMethodName: newSelector in: class) 
		ifFalse: 
			[self refactoringWarning: newSelector , ' is not a valid selector name.'.
			newSelector := nil].
	alreadyDefined := moveToClasses 
				detect: [:each | self includesSelector: newSelector in: each]
				ifNone: [nil].
	alreadyDefined notNil 
		ifTrue: 
			[self refactoringWarning: ('<1s> is already defined by <2p> or a super/subclass<n>Try another?' 
						expandMacrosWith: newSelector
						with: alreadyDefined).
			newSelector := nil].
	newSelector isNil] 
			whileTrue: [].
	parseTree
		arguments: (parameters collect: [:each | BRVariableNode named: each]) 
					asArray;
		selector: newSelector!

hasOnlySelfReturns
	^hasOnlySelfReturns isNil 
		ifTrue: 
			[| searcher |
			searcher := ParseTreeSearcher new.
			searcher
				matches: '^self' do: [:aNode :answer | answer];
				matches: '^`@object' do: [:aNode :answer | false].
			hasOnlySelfReturns := searcher executeTree: parseTree initialAnswer: true]
		ifFalse: [hasOnlySelfReturns]!

hasSelfReferences
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: 'self' do: [:aNode :answer | true].
	self hasOnlySelfReturns 
		ifTrue: [searcher matches: '^self' do: [:aNode :answer | answer]].
	^searcher executeTree: parseTree initialAnswer: false!

isMovingToArgument
	^(parseTree arguments collect: [:each | each name]) includes: variable!

isMovingToInstVar
	^self isMovingToArgument not
		and: [(self whichClass: class defines: variable) notNil]!

needsToReplaceSelfReferences
	^self hasSelfReferences 
		or: [self abstractVariablesRefactoring hasVariablesToAbstract]!

performRefactoring
	self abstractVariables.
	self addSelfReturn.
	self replaceSelfReferences.
	self replaceVariableReferences.
	self compileNewMethods.
	self compileDelagatorMethod!

preconditions
	^(Condition definesSelector: selector in: class) 
		& (Condition withBlock: 
					[self buildParseTree.
					self checkForSuperReferences.
					self checkAssignmentsToVariable.
					self getClassesToMoveTo.
					self getArgumentNameForSelf.
					self checkTemporaryVariableNames.
					self getNewMethodName.
					true])!

replaceSelfReferences
	| replacer |
	replacer := ParseTreeRewriter new.
	replacer replace: 'self' with: selfVariableName.
	self hasOnlySelfReturns ifTrue: [replacer replace: '^self' with: '^self'].
	replacer executeTree: parseTree.
	parseTree := replacer tree!

replaceVariableReferences
	| replacer |
	replacer := ParseTreeRewriter new.
	replacer replace: variable with: 'self'.
	replacer executeTree: parseTree.
	parseTree := replacer tree!

verifyTemporaryVariableDoesNotOverride
	(parseTree allDefinedVariables includes: selfVariableName) ifTrue: [^false].
	moveToClasses do: 
			[:each | 
			((self variableNamesFor: each) includes: selfVariableName) ifTrue: [^false]].
	^true! !

!MoveMethodRefactoring methodsFor: 'private'!

buildParseTree
	parseTree := class parseTreeFor: selector.
	parseTree isNil ifTrue: [self refactoringError: 'Could not parse method']! !

MoveMethodRefactoring class
	instanceVariableNames: ''!



!MoveMethodRefactoring class methodsFor: 'instance creation'!

selector: aSymbol class: aClass variable: aVariableName 
	^self new selector: aSymbol
		class: aClass
		variable: aVariableName! !

MethodRefactoring subclass: #InlineTemporaryRefactoring
	instanceVariableNames: 'sourceInterval selector sourceTree assignmentNode definingNode '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!InlineTemporaryRefactoring methodsFor: 'initialize-release'!

inline: anInterval from: aSelector in: aClass 
	class := aClass.
	selector := aSelector.
	sourceInterval := anInterval! !

!InlineTemporaryRefactoring methodsFor: 'performing'!

compileMethod
	self 
		performChange: (AddMethodChange compile: sourceTree formattedCode in: class)!

hasOnlyOneAssignment
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: assignmentNode variable name , ' := ``@object'
		do: [:aNode :answer | answer + 1].
	^(searcher executeTree: definingNode initialAnswer: 0) == 1!

isWrittenBeforeRead
	^(BRReadBeforeWrittenTester 
		readBeforeWritten: (Array with: assignmentNode variable name)
		in: definingNode) isEmpty!

performRefactoring
	self replaceAssignment.
	self replaceReferences.
	self compileMethod!

preconditions
	^(Condition definesSelector: selector in: class) 
		& (Condition withBlock: 
					[self verifySelectedInterval.
					true])!

replaceAssignment
	assignmentNode parent isSequence 
		ifTrue: [assignmentNode parent removeNode: assignmentNode]
		ifFalse: [assignmentNode replaceWith: assignmentNode value]!

replaceReferences
	| rewriter |
	rewriter := ParseTreeRewriter new.
	rewriter replaceTree: assignmentNode variable
		withTree: assignmentNode value.
	definingNode removeTemporaryNamed: assignmentNode variable name.
	rewriter executeTree: definingNode!

verifySelectedInterval
	sourceTree := class parseTreeFor: selector.
	sourceTree isNil ifTrue: [self refactoringError: 'Could not parse source'].
	assignmentNode := sourceTree whichNodeIsContainedBy: sourceInterval.
	assignmentNode isAssignment 
		ifFalse: 
			[self refactoringError: 'The selected node is not an assignment statement'].
	definingNode := assignmentNode whoDefines: assignmentNode variable name.
	self hasOnlyOneAssignment 
		ifFalse: 
			[self refactoringError: 'There are multiple assignments to the variable'].
	self isWrittenBeforeRead 
		ifFalse: 
			[self 
				refactoringError: 'The variable is possible read before it is assigned']! !

InlineTemporaryRefactoring class
	instanceVariableNames: ''!



!InlineTemporaryRefactoring class methodsFor: 'instance creation'!

inline: anInterval from: aSelector in: aClass 
	^self new 
		inline: anInterval
		from: aSelector
		in: aClass! !

MethodRefactoring subclass: #RenameTempRefactoring
	instanceVariableNames: 'selector interval oldName newName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RenameTempRefactoring methodsFor: 'initialize-release'!

class: aClass selector: aSelector interval: anInterval newName: aString 
	class := aClass.
	selector := aSelector.
	interval := anInterval.
	newName := aString! !

!RenameTempRefactoring methodsFor: 'performing'!

performRefactoring
	| parseTree node |
	parseTree := class parseTreeFor: selector.
	node := self whichNodeDefines: parseTree.
	(node isNil or: [node isVariable not]) 
		ifTrue: [self refactoringError: oldName , ' isn''t a valid variable'].
	node name = oldName ifFalse: [self refactoringError: 'Invalid selection'].
	node := node whoDefines: oldName.
	node isNil 
		ifTrue: [self refactoringError: oldName , ' isn''t defined by the method'].
	self renameNode: node.
	self 
		performChange: (AddMethodChange compile: parseTree formattedCode in: class)!

preconditions
	^(Condition isClass: class)
		& (Condition definesSelector: selector in: class)
		& (Condition isValidInstVarName: newName for: class)
		& (Condition definesInstVar: newName in: class) not
		& (Condition definesClassVar: newName in: class) not
		& (Condition withBlock: 
					[| methodSource |
					interval first > interval last
						ifTrue: [self refactoringError: 'Invalid variable name'].
					methodSource := class sourceCodeAt: selector.
					methodSource size >= interval last
						ifFalse: [self refactoringError: 'Invalid range for variable'].
					oldName := methodSource copyFrom: interval first to: interval last.
					true])!

renameNode: aParseTree 
	(aParseTree whoDefines: newName) notNil 
		ifTrue: [self refactoringError: newName , ' is already defined'].
	(aParseTree allDefinedVariables includes: newName) 
		ifTrue: [self refactoringError: newName , ' is already defined'].
	(ParseTreeRewriter rename: oldName to: newName) executeTree: aParseTree!

whichNodeDefines: aParseTree 
	^self
		whichVariableNode: aParseTree
		inInterval: interval
		name: oldName! !

RenameTempRefactoring class
	instanceVariableNames: ''!



!RenameTempRefactoring class methodsFor: 'instance creation'!

renameTemporaryFrom: anInterval to: newName in: aClass selector: aSelector 
	^self new
		class: aClass
		selector: aSelector
		interval: anInterval
		newName: newName! !

BrowserDialog subclass: #VariableTypeDialog
	instanceVariableNames: 'classNameHolder classList '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!VariableTypeDialog methodsFor: 'initialize-release'!

chooseClassesFromList: aCollection initialSelections: selectedItems 
	self classList list: aCollection asList.
	self classList selections: selectedItems! !

!VariableTypeDialog methodsFor: 'actions'!

addClassToList
	| class |
	class := self getClassForName.
	(class isBehavior and: [(self classList list includes: class) not])
		ifTrue: [self classList list add: class]! !

!VariableTypeDialog methodsFor: 'aspects'!

classList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^classList isNil
		ifTrue:
			[classList := MultiSelectionInList new]
		ifFalse:
			[classList]!

classNameHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^classNameHolder isNil
		ifTrue:
			[classNameHolder := String new asValue]
		ifFalse:
			[classNameHolder]! !

!VariableTypeDialog methodsFor: 'private'!

getClassForName
	| name class |
	name := self classNameHolder value asSymbol.
	class := Smalltalk at: name ifAbsent: [nil].
	class isNil ifTrue: 
			[(name asString copyFrom: (name size - 5 max: 1) to: name size) = ' class'
				ifTrue: 
					[class := Smalltalk at: (name copyFrom: 1 to: name size - 6) asSymbol ifAbsent: [nil].
					class notNil ifTrue: [class := class class]]].
	^class! !

VariableTypeDialog class
	instanceVariableNames: ''!



!VariableTypeDialog class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Select variable type' 
			#bounds: #(#Rectangle 904 358 1223 655 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 30 0 -5 1 -100 1 ) 
					#name: #classList 
					#model: #classList 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 -70 1 -65 1 -40 1 ) 
					#name: #classNameHolder 
					#model: #classNameHolder ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 -98 1 0 1 -96 1 ) ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 -37 1 0 1 -35 1 ) ) 
				#(#LabelSpec 
					#layout: #(#Point 5 2 ) 
					#label: 'Select classes to move to:' ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -3 1 0.5 1 ) 
					#name: #accept 
					#model: #accept 
					#label: 'OK' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -3 1 0.5 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin -5 1 -40 1 1 1 ) 
					#name: #addClassToList 
					#model: #addClassToList 
					#label: 'Add' 
					#defaultable: true ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0 -95 1 ) 
					#label: 'Add class to list:' ) ) ) )! !

!VariableTypeDialog class methodsFor: 'querying'!

chooseClassesFromList: aCollection initialSelections: selectedItems cancel: cancelBlock 
	| dialog |
	dialog := self new.
	dialog chooseClassesFromList: aCollection initialSelections: selectedItems.
	^dialog open ifTrue: [dialog classList selections] ifFalse: [cancelBlock value]! !

VariableRefactoring subclass: #CreateAccessorsForVariableRefactoring
	instanceVariableNames: 'getterMethod setterMethod classVariable needsReturn '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!CreateAccessorsForVariableRefactoring methodsFor: 'initialize-release'!

classVariable: aBoolean 
	classVariable := aBoolean! !

!CreateAccessorsForVariableRefactoring methodsFor: 'performing'!

defineGetterMethodUsing: aBuilder 
	| selector definingClass |
	definingClass := self definingClass.
	selector := (self safeMethodNameFor: definingClass basedOn: varName asString) asSymbol.
	aBuilder
		compile: ('<1s><n><t>^<2s>' expandMacrosWith: selector with: varName)
		in: definingClass
		classified: #accessing.
	^selector!

defineSetterMethodUsing: aBuilder 
	| selector definingClass string |
	definingClass := self definingClass.
	string := self needsReturnForSetter
				ifTrue: ['<1s> anObject<n><t>^<2s> := anObject']
				ifFalse: ['<1s> anObject<n><t><2s> := anObject'].
	selector := (self safeMethodNameFor: definingClass basedOn: varName asString , ':')
				asSymbol.
	aBuilder compile: (string expandMacrosWith: selector with: varName)
		in: definingClass
		classified: #accessing.
	^selector!

definingClass
	^classVariable
		ifTrue: [class class]
		ifFalse: [class]!

findGetterMethod
	| definingClass matcher |
	definingClass := self definingClass.
	matcher := ParseTreeSearcher getterMethod: varName.
	^self possibleGetterSelectors detect: 
			[:each | 
			(self checkClass: definingClass
				selector: each
				using: matcher) notNil
				and: [(self subclassOf: definingClass redefines: each) not]]
		ifNone: [nil]!

findSetterMethod
	| definingClass matcher |
	definingClass := self definingClass.
	matcher := self needsReturnForSetter
				ifTrue: [ParseTreeSearcher returnSetterMethod: varName]
				ifFalse: [ParseTreeSearcher setterMethod: varName].
	^self possibleSetterSelectors detect: 
			[:each | 
			(self checkClass: definingClass
				selector: each
				using: matcher) notNil
				and: [(self subclassOf: definingClass redefines: each) not]]
		ifNone: [nil]!

getterMethod
	^getterMethod!

needsReturnForSetter
	needsReturn isNil ifTrue: 
			[needsReturn := self usesAssignmentOf: varName
						in: class
						classVariable: classVariable].
	^needsReturn!

performRefactoring
	| builder |
	builder := RefactoryBuilder named: 'Create accessors'.
	getterMethod := self findGetterMethod.
	setterMethod := self findSetterMethod.
	getterMethod isNil 
		ifTrue: [getterMethod := self defineGetterMethodUsing: builder].
	setterMethod isNil 
		ifTrue: [setterMethod := self defineSetterMethodUsing: builder].
	self performChange: builder!

possibleGetterSelectors
	^(classVariable
		ifTrue: [self definingClass whichSelectorsReferTo: self variableAssociation]
		ifFalse: [self definingClass whichSelectorsRead: varName])
			select: [:each | each numArgs == 0]!

possibleSetterSelectors
	^(self writersFor: self definingClass)
		select: [:each | each numArgs == 1]!

preconditions
	^(Condition isClass: class)
		& (classVariable
				ifTrue: [Condition definesClassVar: varName in: class]
				ifFalse: [Condition definesInstVar: varName in: class])!

setterMethod
	^setterMethod!

variableAssociation
	^self associationForClassVariable: varName
		in: class
		ifAbsent: [self refactoringError: 'Variable not found']!

writersFor: aClass 
	^classVariable
		ifTrue: [aClass whichSelectorsReferTo: self variableAssociation]
		ifFalse: [aClass whichSelectorsWrite: varName]! !

CreateAccessorsForVariableRefactoring class
	instanceVariableNames: ''!



!CreateAccessorsForVariableRefactoring class methodsFor: 'instance creation'!

variable: aVarName class: aClass classVariable: aBoolean 
	^(self variable: aVarName class: aClass)
		classVariable: aBoolean; yourself! !

ClassRefactoring subclass: #RenameClassRefactoring
	instanceVariableNames: 'newName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RenameClassRefactoring methodsFor: 'initialize-release'!

className: aName newName: aNewName
	className := aName.
	newName := aNewName! !

!RenameClassRefactoring methodsFor: 'performing'!

performRefactoring
	| classAssociation replacer changeBuilder |
	classAssociation := Smalltalk associationAt: className.
	changeBuilder := RenameClassChange rename: className to: newName.
	replacer := (ParseTreeRewriter replaceLiteral: className with: newName)
				replace: className with: newName;
				replaceArgument: newName
					withValueFrom: 
						[:aNode | 
						self 
							refactoringError: newName , ' already exists within the reference scope'].

	"Change all sources to refer to the new class name, we need to search for any occurrence 
	of the old class name"
	self 
		convertAllClassesSelect: 
			[:aClass | 
			| selectors |
			selectors := (aClass whichSelectorsReferTo: classAssociation) asSet.
			selectors addAll: (aClass whichSelectorsReferTo: className).
			selectors isEmpty 
				ifFalse: 
					[(self allSubtreeVarsIn: aClass includes: newName asString) 
						ifTrue: 
							[self 
								refactoringError: 'Cannot rename class since a variable is defined with that name']].
			selectors]
		using: replacer
		notifying: changeBuilder.
	self performChange: changeBuilder withLabel: 'Compiling changes'!

preconditions
	| aClass |
	aClass := Smalltalk at: className asSymbol ifAbsent: [nil].
	^(Condition isClass: aClass)
		& ((Condition isMetaclass: aClass)
				errorMacro: 'Cannot rename a meta class') not
		& (Condition isValidClassName: newName)
		& (Condition isGlobal: newName) not! !

RenameClassRefactoring class
	instanceVariableNames: ''!



!RenameClassRefactoring class methodsFor: 'instance creation'!

rename: aClass to: aNewName
	^self new className: aClass name newName: aNewName! !

BrowserApplicationModel subclass: #RefactoryBuilderInspector
	instanceVariableNames: 'changes changeDescription refactoryBuilder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!

RefactoryBuilderInspector comment:
'RefactoryBuilderInspector is a special inspector for a RefactoryBuilder.

Instance Variables:
	changeDescription	<ValueHolder on: String>	the description of the change selected at the top
	changes	<SelectionInList on: RefactoryChange>	the list of changes at the top of the window
	refactoryBuilder	<RefactoryBuilder>	the object we''re inspecting'!


!RefactoryBuilderInspector methodsFor: 'initialize-release'!

inspect: aRefactoryBuilder 
	refactoryBuilder := aRefactoryBuilder.
	self open.
	self changes list: (List withAll: refactoryBuilder changes)! !

!RefactoryBuilderInspector methodsFor: 'actions'!

executeAll
	self performChange: refactoryBuilder withMessage: 'Compiling changes'!

executeChange
	self performChange: self changes selection!

removeChange
	refactoryBuilder removeChange: self changes selection.
	self changes list remove: self changes selection.
	self changedChange!

removeClass
	| class |
	class := self changes selection changeClass.
	self changes list copy do: 
			[:each | 
			each changeClass == class ifTrue: 
					[refactoryBuilder removeChange: each.
					self changes list remove: each]].
	self changedChange! !

!RefactoryBuilderInspector methodsFor: 'changing'!

changedChange
	| change |
	change := self changes selection.
	changeDescription
		value: (change isNil ifTrue: [''] ifFalse: [change printString])! !

!RefactoryBuilderInspector methodsFor: 'menu'!

changesMenu
	^[self changes selection isNil
		ifTrue: [self disableMenu: self class changesMenu except: #('execute all')]
		ifFalse: [self class changesMenu]]! !

!RefactoryBuilderInspector methodsFor: 'aspects'!

changeDescription
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^changeDescription isNil
		ifTrue:
			[changeDescription := String new asValue]
		ifFalse:
			[changeDescription]!

changes
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^changes isNil
		ifTrue:
			[changes := SelectionInList new]
		ifFalse:
			[changes]! !

RefactoryBuilderInspector class
	instanceVariableNames: ''!



!RefactoryBuilderInspector class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'RefactoryBuilder' 
			#bounds: #(#Rectangle 313 304 921 755 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 -1 0.333333 ) 
					#name: #changes 
					#model: #changes 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedChange ) 
					#menu: #changesMenu ) 
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 2 0 1 0.333333 -2 1 -2 1 ) 
					#name: #changeDescription 
					#model: #changeDescription 
					#isReadOnly: true ) ) ) )! !

!RefactoryBuilderInspector class methodsFor: 'interface opening'!

openOn: aRefactoryBuilder 
	self new inspect: aRefactoryBuilder! !

!RefactoryBuilderInspector class methodsFor: 'resources'!

changesMenu
	"MenuEditor new openOnClass: self andSelector: #changesMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'execute' 
				#value: #executeChange ) 
			#(#MenuItem 
				#rawLabel: 'execute all' 
				#value: #executeAll ) 
			#(#MenuItem 
				#rawLabel: 'remove' 
				#value: #removeChange ) 
			#(#MenuItem 
				#rawLabel: 'remove class' 
				#value: #removeClass ) ) #(2 2 ) nil ) decodeAsLiteralArray! !

VariableRefactoring subclass: #ValueHolderRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ValueHolderRefactoring methodsFor: 'performing'!

defineHolderMethodUsing: aBuilder 
	| methodName |
	methodName := self safeMethodNameFor: class basedOn: varName , 'Holder'.
	aBuilder
		compile: ('<1s><n><t>^<2s> isNil<n><t><t>ifTrue:<n><t><t><t>[<2s> := nil asValue]<n><t><t>ifFalse:<n><t><t><t>[<2s>]'
				expandMacrosWith: methodName
				with: varName)
		in: class
		classified: #aspects.
	^methodName asSymbol!

performRefactoring
	"Removes all direct references to anInstVar in this class, creating
	reference methods if necessary."

	| selector builder replacer |
	builder := RefactoryBuilder named: 'Convert instance variable into a value holder'.
	selector := self defineHolderMethodUsing: builder.

	"Convert all references to the variable to its getter and setter method"
	replacer := ParseTreeRewriter valueHolderForVariable: varName
				holderMethod: selector.
	self 
		convertClasses: class withAllSubclasses
		select: 
			[:aClass | 
			(aClass whichSelectorsAccess: varName) 
				reject: [:each | aClass == class and: [each == selector]]]
		using: replacer
		notifying: builder
		message: 'Converting ' , varName , ' to a value holder'.
	self performChange: builder withLabel: 'Compiling sources'!

preconditions
	^(Condition definesInstVar: varName in: class)
		& ((Condition withBlock: [self
					usesAssignmentOf: varName
					in: class
					classVariable: false])
				errorMacro: 'This refactoring currently works only if the value of a variable assignment is not used.') not! !

ValueHolderRefactoring class
	instanceVariableNames: ''!


MethodRefactoring subclass: #MoveVariableDefinitionRefactoring
	instanceVariableNames: 'selector interval name parseTree blockNodes definingNode '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!MoveVariableDefinitionRefactoring methodsFor: 'initialize-release'!

class: aClass selector: aSelector interval: anInterval 
	interval := anInterval.
	class := aClass.
	selector := aSelector! !

!MoveVariableDefinitionRefactoring methodsFor: 'performing'!

checkNodes: sequenceNodes 
	(sequenceNodes detect: 
			[:each | 
			(BRReadBeforeWrittenTester readBeforeWritten: (Array with: name) in: each)
				isEmpty not]
		ifNone: [nil]) notNil ifTrue: [^false].
	sequenceNodes do: 
			[:each | 
			(self usesDirectly: each body)
				ifTrue: [blockNodes add: each]
				ifFalse: 
					[(self checkNodes: (self subblocksIn: each body))
						ifFalse: [blockNodes add: each]]].
	^true!

checkParseTree
	| node |
	blockNodes := OrderedCollection new.
	node := self whichVariableNode: parseTree
				inInterval: interval
				name: name.
	node isNil
		ifTrue: [self refactoringError: 'Unable to locate node in parse tree'].
	definingNode := node whoDefines: name.
	definingNode isNil
		ifTrue: [self refactoringError: 'Cannot locate variable definition'].
	definingNode isSequence
		ifFalse: [self refactoringError: 'Variable is an argument'].
	(self usesDirectly: definingNode)
		ifTrue: [self refactoringError: 'Variable already bound tightly as possible'].
	(self checkNodes: (self subblocksIn: definingNode))
		ifFalse: [self refactoringError: 'Variable is possibly read before written']!

performRefactoring
	definingNode removeTemporaryNamed: name.
	blockNodes do: [:each | each body addTemporaryNamed: name].
	self 
		performChange: (AddMethodChange compile: parseTree formattedCode in: class)!

preconditions
	^(Condition isClass: class) 
		& (Condition definesSelector: selector in: class)
		& (Condition withBlock: 
					[| methodSource |
					interval first <= interval last
						ifFalse: [self refactoringError: 'Invalid variable name'].
					methodSource := class sourceCodeAt: selector.
					methodSource size >= interval last
						ifFalse: [self refactoringError: 'Invalid range for variable'].
					name := methodSource copyFrom: interval first to: interval last.
					(self checkInstVarName: name in: class) ifFalse: 
							[self refactoringError: name , ' does not seem to be a valid variable name.'].
					parseTree := class parseTreeFor: selector.
					self checkParseTree.
					true])!

subblocksIn: aParseTree 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: '[:`@blockTemps | | `@temps | `@.Statements]'
		do: 
			[:aNode :answer | 
			(aNode references: name)
				ifTrue: [answer add: aNode].
			answer].
	^searcher executeTree: aParseTree initialAnswer: OrderedCollection new!

usesDirectly: aParseTree 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher
		matches: '[:`@args | | `@temps | `@.Statements]'
			do: [:aNode :answer | answer];
		matches: name do: [:aNode :answer | true].
	^searcher executeTree: aParseTree initialAnswer: false! !

MoveVariableDefinitionRefactoring class
	instanceVariableNames: ''!



!MoveVariableDefinitionRefactoring class methodsFor: 'instance creation'!

bindTight: anInterval in: aClass selector: aSelector 
	^self new
		class: aClass
		selector: aSelector
		interval: anInterval! !

Object subclass: #RefactoringManager
	instanceVariableNames: 'refactorings undo redo isPerformingRefactoring '
	classVariableNames: 'Instance UndoSize '
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RefactoringManager methodsFor: 'private'!

clearUndoRedoList
	undo := OrderedCollection new.
	redo := OrderedCollection new! !

!RefactoringManager methodsFor: 'updating'!

update: anAspectSymbol with: aParameter from: aSender 
	| changeType |
	(aSender == ChangeSet and: [isPerformingRefactoring not]) ifFalse: [^self].
	anAspectSymbol == #reorganizeClass: ifTrue: [^self].
	changeType := (anAspectSymbol isString 
				ifTrue: [anAspectSymbol asString]
				ifFalse: ['class']) asLowercase.
	(changeType indexOfSubCollection: 'class' startingAt: 1) 
		+ (changeType indexOfSubCollection: 'selector' startingAt: 1) > 0 
		ifTrue: [self clearUndoRedoList]! !

!RefactoringManager methodsFor: 'initialize-release'!

initialize
	refactorings := Bag new.
	ChangeSet addDependent: self.
	undo := OrderedCollection new.
	redo := OrderedCollection new.
	isPerformingRefactoring := false!

release
	super release.
	ChangeSet removeDependent: self! !

!RefactoringManager methodsFor: 'testing'!

hasRedoableOperations
	^redo isEmpty not!

hasUndoableOperations
	^undo isEmpty not! !

!RefactoringManager methodsFor: 'public access'!

addRefactoring: aRefactoring
	self addUndo: aRefactoring undoChanges.
	refactorings add: aRefactoring class name!

addUndo: aRefactoringChange 
	undo add: aRefactoringChange.
	undo size > UndoSize ifTrue: [undo removeFirst].
	redo := OrderedCollection new!

ignoreChangesWhile: aBlock 
	isPerformingRefactoring ifTrue: [^aBlock value].
	isPerformingRefactoring := true.
	aBlock valueNowOrOnUnwindDo: [isPerformingRefactoring := false]!

redoChange
	^redo last!

redoOperation
	redo isEmpty ifTrue: [^self].
	self ignoreChangesWhile: 
			[| change |
			change := redo removeLast.
			undo add: (change executeWithMessage: 'Undoing ' , change name)]!

undoChange
	^undo last!

undoOperation
	undo isEmpty ifTrue: [^self].
	self ignoreChangesWhile: 
			[| change |
			change := undo removeLast.
			redo add: (change executeWithMessage: 'Undoing ' , change name)]! !

!RefactoringManager methodsFor: 'printing'!

printOn: aStream 
	aStream nextPutAll: '#		Refactoring';
		cr;
		nextPutAll: '---		-----------------------------------------------';
		cr.
	refactorings asSet asSortedCollection do: 
			[:name | 
			aStream nextPutAll: (refactorings occurrencesOf: name) printString;
				nextPutAll: '		';
				nextPutAll: name;
				cr]! !

RefactoringManager class
	instanceVariableNames: ''!



!RefactoringManager class methodsFor: 'class initialization'!

initialize
	self nuke.
	UndoSize := 5! !

!RefactoringManager class methodsFor: 'instance creation'!

instance
	Instance isNil
		ifTrue:
			[Instance := self basicNew.
			Instance initialize].
	^Instance!

new
	^self shouldNotImplement! !

!RefactoringManager class methodsFor: 'public access'!

nuke
	Instance notNil ifTrue: [Instance release].
	Instance := nil! !

VariableRefactoring subclass: #RemoveInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RemoveInstanceVariableRefactoring methodsFor: 'performing'!

performRefactoring
	self 
		performChange: (RemoveInstanceVariableChange remove: varName from: class)!

preconditions
	^(Condition definesInstVar: varName asString in: class)
		& ((Condition hierarchyOf: class referencesInstVar: varName)
				errorMacro: ('<1s> is referenced.<n>Browse references?' expandMacrosWith: varName);
				errorBlock: 
						[(BrowserEnvironment new instVarRefsTo: varName in: class) openEditor];
				yourself) not! !

RemoveInstanceVariableRefactoring class
	instanceVariableNames: ''!


VariableRefactoring subclass: #RestoringVariableRefactoring
	instanceVariableNames: 'instances values '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RestoringVariableRefactoring methodsFor: 'initialize-release'!

initialize
	super initialize.
	instances := OrderedCollection new.
	values := OrderedCollection new! !

!RestoringVariableRefactoring methodsFor: 'performing'!

addInstancesAndValuesFor: aClass 
	| index newInstances |
	index := aClass allInstVarNames indexOf: varName ifAbsent: [^self].
	newInstances := aClass allInstances.
	instances addAll: newInstances.
	newInstances do: [:each | values add: (each instVarAt: index)].
	aClass subclasses do: [:each | self addInstancesAndValuesFor: each]!

newVariableName
	^varName!

resetValues
	1 to: instances size
		do: 
			[:i | 
			| index each |
			each := instances at: i.
			index := each class allInstVarNames indexOf: self newVariableName ifAbsent: [0].
			index == 0 ifFalse: [each instVarAt: index put: (values at: i)]]! !

RestoringVariableRefactoring class
	instanceVariableNames: ''!


RestoringVariableRefactoring subclass: #PushDownInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PushDownInstanceVariableRefactoring methodsFor: 'performing'!

performRefactoring
	| builder |
	self addInstancesAndValuesFor: class.
	builder := RefactoryBuilder named: 'Push down instance variable'.
	builder removeInstanceVariable: varName from: class.
	class subclasses do: 
			[:each | 
			(each withAllSubclasses 
				detect: [:aClass | (aClass whichSelectorsAccess: varName) isEmpty not]
				ifNone: [nil]) notNil 
				ifTrue: [builder addInstanceVariable: varName to: each]].
	self performChange: builder withLabel: 'Compiling sources'.
	self resetValues!

preconditions
	^(Condition definesInstVar: varName in: class)
		& ((Condition referencesInstVar: varName in: class)
				errorMacro: ('<1s> is referenced.<n>Browse references?' expandMacrosWith: varName);
				errorBlock: 
						[(BrowserEnvironment new instVarRefsTo: varName in: class) openEditor];
				yourself) not! !

PushDownInstanceVariableRefactoring class
	instanceVariableNames: ''!


RestoringVariableRefactoring subclass: #RenameInstanceVariableRefactoring
	instanceVariableNames: 'newName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RenameInstanceVariableRefactoring methodsFor: 'initialize-release'!

rename: aVarName to: aName in: aClass
	self variable: aVarName class: aClass.
	newName := aName! !

!RenameInstanceVariableRefactoring methodsFor: 'performing'!

newVariableName
	^newName!

performRefactoring
	| changeBuilder replacer |
	self addInstancesAndValuesFor: class.
	changeBuilder := RefactoryBuilder named: 'Rename instance variable'.

	"Add the new variable name. Don't delete the old one until we change all of the sources."
	changeBuilder addInstanceVariable: newName to: class.
	replacer := ParseTreeRewriter 
				rename: varName
				to: newName
				handler: 
					[self 
						refactoringError: ('<1s> is already defined as a method or block temporary <n> variable in this class or one of its subclasses' 
								expandMacrosWith: newName)].

	"Convert the instance variable name"
	self 
		convertClasses: class withAllSubclasses
		select: [:aClass | aClass whichSelectorsAccess: varName]
		using: replacer
		notifying: changeBuilder
		message: 'Changing instance variable name from: ' , varName , ' to: ' 
				, newName.

	"Remove the old variable name, and then compile the changes"
	changeBuilder removeInstanceVariable: varName from: class.
	self performChange: changeBuilder withLabel: 'Compiling changes'.
	self resetValues!

preconditions
	^(Condition isValidInstVarName: newName for: class)
		& (Condition definesInstVar: varName in: class) 
		& (Condition hierarchyOf: class definesVar: newName) not 
		& (Condition isGlobal: newName) not! !

RenameInstanceVariableRefactoring class
	instanceVariableNames: ''!



!RenameInstanceVariableRefactoring class methodsFor: 'instance creation'!

rename: aVarName to: aName in: aClass
	^self new
		rename: aVarName
		to: aName
		in: aClass! !

RefactoryChange subclass: #RefactoryClassChange
	instanceVariableNames: 'className isMeta '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RefactoryClassChange methodsFor: 'private'!

executeNotifying: aBlock 
	| undo |
	undo := self asUndoOperation.
	undo name: self name.
	self primitiveExecute.
	aBlock value.
	^undo!

isMeta
	^isMeta!

primitiveExecute
	^self subclassResponsibility! !

!RefactoryClassChange methodsFor: 'comparing'!

= aRefactoryClassChange 
	self class = aRefactoryClassChange class ifFalse: [^false].
	^className = aRefactoryClassChange changeClassName 
		and: [isMeta = aRefactoryClassChange isMeta]!

hash
	^self changeClassName hash! !

!RefactoryClassChange methodsFor: 'accessing'!

changeClass
	| class |
	class := Smalltalk at: self changeClassName ifAbsent: [^nil].
	^isMeta ifTrue: [class class] ifFalse: [class]!

changeClass: aBehavior 
	isMeta := aBehavior isMeta.
	className := isMeta 
				ifTrue: [aBehavior soleInstance name]
				ifFalse: [aBehavior name]!

changeClassName
	^className!

changeClassName: aSymbol 
	className := aSymbol.
	isMeta isNil ifTrue: [isMeta := false]!

methodSourceFor: aSymbol 
	(self changeClass includesSelector: aSymbol) ifFalse: [^nil].
	^self changeClass sourceCodeAt: aSymbol!

renameChangesForClass: aClassName to: newClassName 
	self changeClassName == aClassName 
		ifTrue: 
			[^(self copy)
				changeClassName: newClassName;
				yourself].
	^self! !

!RefactoryClassChange methodsFor: 'printing'!

changeString
	^self displayClassName!

displayClassName
	^isMeta 
		ifTrue: [self changeClassName , ' class']
		ifFalse: [self changeClassName asString]!

printOn: aStream
	aStream nextPutAll: self displayString! !

!RefactoryClassChange methodsFor: 'converting'!

asUndoOperation
	^self subclassResponsibility! !

RefactoryClassChange class
	instanceVariableNames: ''!


RefactoryClassChange subclass: #RemoveMethodChange
	instanceVariableNames: 'selector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RemoveMethodChange methodsFor: 'converting'!

asUndoOperation
	^AddMethodChange compile: (self methodSourceFor: selector)
		in: self changeClass! !

!RemoveMethodChange methodsFor: 'private'!

primitiveExecute
	^self changeClass removeSelector: selector!

selector
	^selector! !

!RemoveMethodChange methodsFor: 'initialize-release'!

selector: aSymbol 
	selector := aSymbol! !

!RemoveMethodChange methodsFor: 'printing'!

changeString
	^'Remove method, #<1s>, from: <2s>' expandMacrosWith: selector
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' removeSelector: ';
		nextPutAll: selector;
		nextPut: $!!! !

!RemoveMethodChange methodsFor: 'comparing'!

= aRemoveMethodChange 
	super = aRemoveMethodChange ifFalse: [^false].
	^selector = aRemoveMethodChange selector!

hash
	^selector hash! !

RemoveMethodChange class
	instanceVariableNames: ''!



!RemoveMethodChange class methodsFor: 'instance creation'!

remove: aSymbol from: aClass 
	^(self new)
		changeClass: aClass;
		selector: aSymbol;
		yourself! !

RefactoryClassChange subclass: #AddClassChange
	instanceVariableNames: 'definition '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!AddClassChange methodsFor: 'initialize-release'!

definition: aString 
	definition := aString!

initialize
	super initialize.
	isMeta := false! !

!AddClassChange methodsFor: 'converting'!

asUndoOperation
	| class |
	class := Smalltalk at: self changeClassName ifAbsent: [nil].
	^class isBehavior 
		ifTrue: [AddClassChange definition: class definition]
		ifFalse: [RemoveClassChange removeClassName: self changeClassName]! !

!AddClassChange methodsFor: 'private'!

controller
	^nil!

definingSuperclass
	^self class!

definition
	^definition!

primitiveExecute
	^self definingSuperclass subclassDefinerClass 
		evaluate: definition
		notifying: self controller
		logged: true! !

!AddClassChange methodsFor: 'printing'!

changeString
	^'Define ' , self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: definition;
		nextPut: $!!! !

!AddClassChange methodsFor: 'accessing'!

changeClassName
	className isNil 
		ifTrue: 
			[| parseTree |
			parseTree := BRParser parseExpression: definition
						onError: [:str :pos | ^#'Unknown Class'].
			parseTree isMessage ifFalse: [^#'Unknown Class'].
			parseTree arguments first isLiteral ifFalse: [^#'Unknown Class'].
			parseTree arguments first value isSymbol ifFalse: [^#'Unknown Class'].
			className := parseTree arguments first value].
	^className! !

!AddClassChange methodsFor: 'comparing'!

= anAddClassChange 
	self class = anAddClassChange class ifFalse: [^false].
	^definition = anAddClassChange definition!

hash
	^definition hash! !

AddClassChange class
	instanceVariableNames: ''!



!AddClassChange class methodsFor: 'instance creation'!

definition: aString 
	^self new definition: aString! !

VariableRefactoring subclass: #PullUpClassVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PullUpClassVariableRefactoring methodsFor: 'performing'!

performRefactoring
	| classVarName value subclass builder |
	builder := RefactoryBuilder named: 'Pull up class variable'.
	classVarName := varName asSymbol.
	subclass := self subclassDefiningVariable.
	value := (self 
				associationForClassVariable: classVarName
				in: subclass
				ifAbsent: [self refactoringError: 'Could not perform refactoring']) value.
	builder removeClassVariable: varName from: subclass.
	builder addClassVariable: varName to: class.
	self performChange: builder withLabel: 'Compiling changes'.
	(self 
		associationForClassVariable: classVarName
		in: class
		ifAbsent: [nil -> nil]) value: value!

preconditions
	^(Condition isMetaclass: class) not!

subclassDefiningVariable
	| subclasses |
	subclasses := class allSubclasses select: 
					[:each | 
					(each classVarNames detect: [:cvar | cvar asString = varName asString]
						ifNone: [nil]) notNil].
	subclasses isEmpty
		ifTrue: [self refactoringError: 'Could not find a class defining ' , varName].
	subclasses size > 1
		ifTrue: [self refactoringError: 'Multiple subclasses define ' , varName].
	^subclasses asArray first! !

PullUpClassVariableRefactoring class
	instanceVariableNames: ''!


Refactoring subclass: #AbstractVariablesRefactoring
	instanceVariableNames: 'tree fromClass instVarReaders instVarWriters classVarReaders classVarWriters pools toClasses ignore '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AbstractVariablesRefactoring methodsFor: 'initialize-release'!

abstractVariablesIn: aBRProgramNode from: fromBehavior toAll: behaviorCollection ignoring: aVariableName
	tree := aBRProgramNode.
	fromClass := fromBehavior.
	toClasses := behaviorCollection.
	ignore := aVariableName.
	self computeVariablesToAbstract.
	self computePoolsToMove! !

!AbstractVariablesRefactoring methodsFor: 'accessing'!

parseTree
	^tree! !

!AbstractVariablesRefactoring methodsFor: 'performing'!

abstractClassVariable: aString 
	| refactoring rewriter nonMetaClass |
	nonMetaClass := fromClass isMeta 
				ifTrue: [fromClass soleInstance]
				ifFalse: [fromClass].
	refactoring := CreateAccessorsForVariableRefactoring 
				variable: aString
				class: nonMetaClass
				classVariable: true.
	self performComponentRefactoring: refactoring.
	rewriter := ParseTreeRewriter new.
	fromClass isMeta 
		ifTrue: 
			[rewriter
				replace: aString , ' := ``@object'
					with: ('self <1s> ``@object' expandMacrosWith: refactoring setterMethod);
				replace: aString with: 'self ' , refactoring getterMethod]
		ifFalse: 
			[rewriter
				replace: aString , ' := ``@object'
					with: ('self class <1s> ``@object' 
							expandMacrosWith: refactoring setterMethod);
				replace: aString with: 'self class ' , refactoring getterMethod].
	(rewriter executeTree: tree) ifTrue: [tree := rewriter tree]!

abstractClassVariables
	| variables |
	classVarReaders isEmpty & classVarWriters isEmpty ifTrue: [^self].
	variables := Set new.
	variables
		addAll: classVarReaders;
		addAll: classVarWriters.
	variables do: [:each | self abstractClassVariable: each]!

abstractInstanceVariable: aString 
	| refactoring rewriter |
	refactoring := CreateAccessorsForVariableRefactoring 
				variable: aString
				class: fromClass
				classVariable: false.
	self performComponentRefactoring: refactoring.
	rewriter := ParseTreeRewriter new.
	rewriter
		replace: aString , ' := ``@object'
			with: ('self <1s> ``@object' expandMacrosWith: refactoring setterMethod);
		replace: aString with: 'self ' , refactoring getterMethod.
	(rewriter executeTree: tree) ifTrue: [tree := rewriter tree]!

abstractInstanceVariables
	| variables |
	instVarReaders isEmpty & instVarWriters isEmpty ifTrue: [^self].
	variables := Set new.
	variables
		addAll: instVarReaders;
		addAll: instVarWriters.
	variables do: [:each | self abstractInstanceVariable: each]!

classVariableNames
	| nonMetaClass |
	nonMetaClass := fromClass isMeta 
				ifTrue: [fromClass soleInstance]
				ifFalse: [fromClass].
	^(nonMetaClass allClassVarNames collect: [:each | each asString]) asSet!

computePoolsToMove
	| poolVariables searcher |
	poolVariables := self poolVariableNamesFor: fromClass.
	pools := Set new.
	searcher := ParseTreeSearcher new.
	searcher matches: '`var'
		do: 
			[:aNode :answer | 
			| varName pool |
			varName := aNode name.
			(aNode whoDefines: varName) isNil 
				ifTrue: 
					[(poolVariables includes: varName) 
						ifTrue: 
							[pool := self whichPoolDefines: varName.
							pool notNil ifTrue: [pools add: pool]]]].
	searcher executeTree: tree!

computeVariablesToAbstract
	| searcher |
	instVarReaders := Set new.
	instVarWriters := Set new.
	classVarReaders := Set new.
	classVarWriters := Set new.
	searcher := ParseTreeSearcher new.
	searcher
		matches: '`var := ``@anything'
			do: [:aNode :answer | self processAssignmentNode: aNode];
		matches: '`var' do: [:aNode :answer | self processReferenceNode: aNode].
	searcher executeTree: tree.
	self removeDefinedClassVariables!

doesClass: aClass includePool: aPoolDictionary 
	^aClass sharedPools includes: aPoolDictionary!

instanceVariableNames
	^fromClass allInstVarNames asSet!

movePool: aPoolDictionary toClass: aClass 
	| nonMetaClass |
	nonMetaClass := aClass isMeta 
				ifTrue: [aClass soleInstance]
				ifFalse: [aClass].
	(self doesClass: nonMetaClass includePool: aPoolDictionary) 
		ifFalse: 
			[self performChange: (AddPoolVariableChange 
						add: (Smalltalk keyAtValue: aPoolDictionary)
						to: nonMetaClass)]!

movePoolVariables
	pools 
		do: [:poolDict | toClasses do: [:each | self movePool: poolDict toClass: each]]!

performRefactoring
	self hasVariablesToAbstract 
		ifTrue: 
			[self 
				refactoringWarning: 'This method has direct variable references which<n>will need to be converted to getter/setters.' 
						expandMacros].
	self hasPoolsToMove 
		ifTrue: 
			[self 
				refactoringWarning: 'This method contains references to pools<n>which may need to be moved.' 
						expandMacros].
	self abstractInstanceVariables.
	self abstractClassVariables.
	self movePoolVariables!

poolVariableNamesIn: aPoolDictionary 
	^aPoolDictionary keys collect: [:name | name asString]!

preconditions
	^Condition empty!

processAssignmentNode: aNode 
	| varName |
	varName := aNode variable name.
	ignore = varName ifTrue: [^self].
	(aNode whoDefines: varName) notNil ifTrue: [^self].
	(self instanceVariableNames includes: varName) 
		ifTrue: [instVarWriters add: varName].
	(self classVariableNames includes: varName) 
		ifTrue: [classVarWriters add: varName]!

processReferenceNode: aNode 
	| varName |
	varName := aNode name.
	ignore = varName ifTrue: [^self].
	(aNode whoDefines: varName) notNil ifTrue: [^self].
	(self instanceVariableNames includes: varName) 
		ifTrue: [instVarReaders add: varName].
	(self classVariableNames includes: varName) 
		ifTrue: [classVarReaders add: varName]!

removeDefinedClassVariables
	| selectionBlock nonMetaClass |
	nonMetaClass := fromClass isMeta 
				ifTrue: [fromClass soleInstance]
				ifFalse: [fromClass].
	selectionBlock := 
			[:varName | 
			(toClasses detect: 
					[:each | 
					((each isMeta ifTrue: [each soleInstance] ifFalse: [each]) 
						includesBehavior: (self whichClass: nonMetaClass
								definesClassVariable: varName)) 
							not]
				ifNone: [nil]) notNil].
	classVarReaders := classVarReaders select: selectionBlock.
	classVarWriters := classVarWriters select: selectionBlock!

whichPoolDefines: varName 
	| currentClass |
	ignore = varName ifTrue: [^nil].
	currentClass := fromClass.
	[currentClass isNil] whileFalse: 
			[currentClass sharedPools 
				do: [:each | ((self poolVariableNamesIn: each) includes: varName) ifTrue: [^each]].
			currentClass := currentClass superclass].
	^nil! !

!AbstractVariablesRefactoring methodsFor: 'testing'!

hasPoolsToMove
	^pools isEmpty not!

hasVariablesToAbstract
	^(instVarReaders isEmpty 
		& instVarWriters isEmpty 
		& classVarReaders isEmpty 
		& classVarWriters isEmpty) 
		not! !

AbstractVariablesRefactoring class
	instanceVariableNames: ''!



!AbstractVariablesRefactoring class methodsFor: 'instance creation'!

abstractVariablesIn: aBRProgramNode from: fromBehavior toAll: behaviorCollection 
	^self 
		abstractVariablesIn: aBRProgramNode
		from: fromBehavior
		toAll: behaviorCollection
		ignoring: nil!

abstractVariablesIn: aBRProgramNode from: fromBehavior toAll: behaviorCollection ignoring: aVariableName 
	^self new 
		abstractVariablesIn: aBRProgramNode
		from: fromBehavior
		toAll: behaviorCollection
		ignoring: aVariableName! !

VariableRefactoring subclass: #AddClassVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AddClassVariableRefactoring methodsFor: 'performing'!

performRefactoring
	self performChange: (AddClassVariableChange add: varName to: class)!

preconditions
	^(Condition isClass: class) & (Condition isMetaclass: class) not 
		& (Condition isValidClassVarName: varName for: class) 
			& (Condition hierarchyOf: class definesVar: varName asString) not 
			& (Condition isGlobal: varName) not! !

AddClassVariableRefactoring class
	instanceVariableNames: ''!


Object subclass: #AbstractCondition
	instanceVariableNames: 'errorMacro '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Conditions'!

AbstractCondition comment:
'AbstractCondition is an abstract class. It represents a precondition that is used whenever a Refactoring is performed. All preconditions must evaluate successfully in order for the Refactoring to be performed.

Instance Variables:
	errorMacro	<String>	the error string that is used when the condition fails'!


!AbstractCondition methodsFor: 'checking'!

check
	self subclassResponsibility! !

!AbstractCondition methodsFor: 'logical operations'!

& aCondition
	^ConjunctiveCondition new left: self right: aCondition!

not
	^NegationCondition on: self!

| aCondition 
	"(A | B) = (A not & B not) not"

	^(self not & aCondition not) not! !

!AbstractCondition methodsFor: 'accessing'!

errorBlock
	^self errorBlockFor: false!

errorString
	^self errorStringFor: false! !

!AbstractCondition methodsFor: 'private'!

errorBlockFor: aBoolean 
	^nil!

errorMacro
	^errorMacro isNil
		ifTrue: ['unknown']
		ifFalse: [errorMacro]!

errorMacro: aString 
	errorMacro := aString!

errorStringFor: aBoolean
	^self errorMacro expandMacrosWith: aBoolean! !

AbstractCondition class
	instanceVariableNames: ''!


AbstractCondition subclass: #NegationCondition
	instanceVariableNames: 'condition '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Conditions'!

NegationCondition comment:
'NegationCondition represents negating another condition.

Instance Variables:
	condition	<AbstractCondition>	the condition that is to be negated'!


!NegationCondition methodsFor: 'initialize-release'!

condition: aCondition 
	condition := aCondition.
	self errorMacro: condition errorMacro! !

!NegationCondition methodsFor: 'checking'!

check
	^condition check not! !

!NegationCondition methodsFor: 'printing'!

printOn: aStream 
	aStream nextPutAll: 'NOT ';
		print: condition! !

!NegationCondition methodsFor: 'private'!

errorBlockFor: aBoolean 
	^condition errorBlockFor: aBoolean not!

errorStringFor: aBoolean 
	^condition errorStringFor: aBoolean not! !

NegationCondition class
	instanceVariableNames: ''!



!NegationCondition class methodsFor: 'instance creation'!

on: aCondition
	^self new condition: aCondition! !

AbstractCondition subclass: #Condition
	instanceVariableNames: 'block type errorBlock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Conditions'!

Condition comment:
'Condition represents a condition that must be true for a refactoring to be performed.

Instance Variables:
	block	<Block>	this is the block that gets evaluated to check the condition
	errorBlock	<Block | nil>	if not nil, this is a block that if the condition fails, will produce some means of browsing the failure (such as opening a browser on the failures)
	type	<Array>		This array holds a symbol identifying the type of condition this is along
						with its parameters. Right now this is pretty useless, other than for printing,
						but in the future, we hope to be able to use this to assert postconditions of
						refactorings.'!


!Condition methodsFor: 'initialize-release'!

errorBlock: anObject
	errorBlock := anObject!

type: aSymbol block: aBlock errorString: aString 
	type := aSymbol.
	block := aBlock.
	self errorMacro: aString!

withBlock: aBlock 
	block := aBlock.
	type := #(#generic)! !

!Condition methodsFor: 'accessing'!

errorBlockFor: aBoolean
	^errorBlock! !

!Condition methodsFor: 'checking'!

check
	^block value! !

!Condition methodsFor: 'printing'!

printOn: aStream 
	type printOn: aStream! !

Condition class
	instanceVariableNames: ''!



!Condition class methodsFor: 'instance creation'!

canUnderstand: aSelector in: aClass
	^self new
		type: (Array with: #understandsSelector with: aClass with: aSelector)
		block: [aClass canUnderstand: aSelector]
		errorString: aClass printString , ' <1?:does not >understand<1?s:> ' , aSelector printString!

definesClassVar: aString in: aClass
	^self new
		type: (Array with: #definesClassVar with: aClass with: aString)
		block: [(aClass allClassVarNames collect: [:each | each asString])
				includes: aString asString]
		errorString: aClass printString , ' <1?:does not >define<1?s:> class variable ' , aString!

definesInstVar: aString in: aClass
	^self new
		type: (Array with: #definesInstVar with: aClass with: aString)
		block: [aClass allInstVarNames includes: aString]
		errorString: aClass printString , ' <1?:does not >define<1?s:> instance variable ' , aString!

definesSelector: aSelector in: aClass
	^self new
		type: (Array with: #definesSelector with: aClass with: aSelector)
		block: [aClass includesSelector: aSelector]
		errorString: aClass printString , ' <1?:does not >define<1?s:> ' , aSelector printString!

empty
	"Returns an empty condition"

	^self new 
		type: (Array with: #empty)
		block: [true]
		errorString: 'Empty'!

hasSubclasses: aClass
	^self new
		type: (Array with: #hasSubclasses with: aClass)
		block: [aClass subclasses isEmpty not]
		errorString: aClass printString , ' has <1?:no >subclasses'!

hasSuperclass: aClass 
	^self new type: (Array with: #hasSuperclass with: aClass)
		block: [aClass superclass isNil not]
		errorString: aClass printString , ' has <1?a:no> superclass'!

hierarchyOf: aClass canUnderstand: aSelector
	^self new
		type: (Array with: #hierarchyUnderstandsSelector with: aClass with: aSelector)
		block: [aClass withAllSubclasses contains: [:each | each canUnderstand: aSelector]]
		errorString: aClass printString , ' <1?or a subclass:and all subclasses do not> understand<1?s:> ' , aSelector printString!

hierarchyOf: aClass definesVar: aString
	^self new
		type: (Array with: #hierarchyDefinesInstVar with: aClass with: aString)
		block: [self allSubtreeVarsIn: aClass includes: aString]
		errorString: aClass printString , ' or one of its subclasses <1?:does not >define<1?s:> instance variable ' , aString!

hierarchyOf: aClass referencesInstVar: aString
	^self new
		type: (Array with: #hierarchyReferencesInstVar with: aClass with: aString)
		block: [aClass withAllSubclasses contains: [:each | (each whichSelectorsAccess: aString) isEmpty not]]
		errorString: aClass printString , ' or subclass <1?:does not >reference<1?s:> instance variable ' , aString!

isAbstractClass: aClass
	^self new
		type: (Array with: #IsAbstractClass with: aClass)
		block: [self isAbstract: aClass]
		errorString: aClass printString , ' is <1?:not >an abstract class'!

isClass: anObject
	^self new
		type: (Array with: #IsClass with: anObject)
		block: [anObject isBehavior]
		errorString: anObject printString , ' is <1?:not >a behavior'!

isEmptyClass: anObject 
	^self new type: (Array with: #IsEmptyClass with: anObject)
		block: 
			[anObject classVarNames isEmpty
				and: [anObject instVarNames isEmpty and: [anObject selectors isEmpty]]]
		errorString: anObject printString , ' is <1?:not > empty'!

isGlobal: aString
	^self new
		type: (Array with: #isGlobal with: aString)
		block: [Smalltalk includesKey: aString asSymbol]
		errorString: aString , ' is <1?:not >a class or global variable'!

isImmediateSubclass: subclass of: superClass
	^self new
		type: (Array with: #immediateSubclass with: superClass with: subclass)
		block: [subclass superclass = superClass]
		errorString: subclass printString , ' is <1?:not >an immediate subclass of ' , superClass printString!

isMetaclass: anObject 
	^self new type: (Array with: #IsMetaclass with: anObject)
		block: [anObject isMeta]
		errorString: anObject printString , ' is <1?:not >a metaclass'!

isSymbol: aString
	^self new
		type: (Array with: #isSymbol with: aString)
		block: [aString isSymbol]
		errorString: aString , ' is <1?:not >a symbol'!

isValidClassName: aString
	^self new
		type: (Array with: #validClassName with: aString)
		block: [self validClassName: aString]
		errorString: aString , ' is <1?:not >a valid class name'!

isValidClassVarName: aString for: aClass
	^self new
		type: (Array with: #validClassVarName with: aString with: aClass)
		block: [self checkClassVarName: aString in: aClass]
		errorString: aString , ' is <1?:not >a valid class variable name'!

isValidInstVarName: aString for: aClass
	^self new
		type: (Array with: #validInstVarName with: aString with: aClass)
		block: [self checkInstVarName: aString in: aClass]
		errorString: aString , ' is <1?:not >a valid instance variable name'!

isValidMethodName: aString for: aClass
	^self new
		type: (Array with: #validMethodName with: aString with: aClass)
		block: [self checkMethodName: aString in: aClass]
		errorString: aString printString , ' is <1?:not >a valid method name'!

referencesInstVar: aString in: aClass 
	^self new
		type: (Array with: #referencesInstVar with: aClass with: aString)
		block: [(aClass whichSelectorsAccess: aString) isEmpty not]
		errorString: aClass printString , ' <1?:does not >reference<1?s:> instance variable ' , aString!

subclassesOf: aClass referToSelector: aSelector
	^self new
		type: (Array with: #subclassReferences with: aClass with: aSelector)
		block: [aClass subclasses contains: [:each | each selectors contains: [:sel | (each compiledMethodAt: sel) superMessages includes: aSelector]]]
		errorString: '<1?:no:a> subclass of ' , aClass printString , ' refers to ' , aSelector printString!

withBlock: aBlock
	^self new withBlock: aBlock!

withBlock: aBlock errorString: aString 
	^self new type: #unknown
		block: aBlock
		errorString: aString! !

!Condition class methodsFor: 'utilities'!

allSubtreeVarsIn: aClass includes: aVarName
	"Returns true if aVarName is already defined in the hierarchy."

	(aClass allInstVarNames includes: aVarName)
		ifTrue: [^true].
	((aClass allClassVarNames collect: [:each | each asString])
		includes: aVarName)
		ifTrue: [^true].
	aClass
		allSubclassesDo:
			[:class |
			(class instVarNames includes: aVarName)
				ifTrue: [^true].
			((class classVarNames collect: [:each | each asString])
				includes: aVarName)
				ifTrue: [^true]].
	^false!

checkClassVarName: aName in: aClass 
	| string |
	aName isString ifFalse: [^false].
	string := aName asString.
	(self reservedNames includes: string) ifTrue: [^false].
	string isEmpty ifTrue: [^false].
	string first isUppercase ifFalse: [^false].
	^BRScanner isVariable: string!

checkInstVarName: aName in: aClass 
	| string |
	aName isString ifFalse: [^false].
	string := aName asString.
	string isEmpty ifTrue: [^false].
	(self reservedNames includes: string)
		ifTrue: [^false].
	string first isUppercase ifTrue: [^false].
	^BRScanner isVariable: string!

checkMethodName: aName in: aClass 
	^aName isString and: [BRScanner isSelector: aName]!

checkSubclassResponsibilityFor: aClass 
	| matcher |
	matcher := ParseTreeSearcher new.
	matcher 
		matchesAnyMethodOf: 
			#('`@keywords: `@args self subclassResponsibility' 
			'`@keywords: `@args ^self subclassResponsibility' 
			'`@keywords: `@args super subclassResponsibility' 
			'`@keywords: `@args ^super subclassResponsibility')
		do: [:aNode :answer | true].
	matcher answer: false.
	^((aClass whichSelectorsReferTo: 'subclassResponsibility' asSymbol) 
		detect: 
			[:each | 
			| parseTree |
			parseTree := aClass parseTreeFor: each.
			parseTree notNil and: [matcher executeTree: parseTree]]
		ifNone: [nil]) notNil!

isAbstract: aClass 
	| assoc |
	aClass isMeta ifTrue: [^false].
	assoc := Smalltalk associationAt: aClass name ifAbsent: [^false].
	(self checkSubclassResponsibilityFor: aClass) ifTrue: [^true].
	Smalltalk allBehaviorsDo: 
			[:each | 
			(each whichSelectorsReferTo: assoc) isEmpty ifFalse: [^false].
			(each whichSelectorsReferTo: aClass name) isEmpty ifFalse: [^false]].
	^true!

reservedNames
	^#('self' 'true' 'false' 'nil' 'thisContext' 'super')!

validClassName: aString 
	"Class names and class variable names have the same restrictions"

	^self checkClassVarName: aString in: self! !

MethodRefactoring subclass: #RemoveMethodRefactoring
	instanceVariableNames: 'selectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RemoveMethodRefactoring methodsFor: 'initialize-release'!

removeMethods: selectorCollection from: aClass 
	class := aClass.
	selectors := selectorCollection! !

!RemoveMethodRefactoring methodsFor: 'performing'!

checkSuperMethods
	| superMessages nonSupers |
	nonSupers := OrderedCollection new.
	superMessages := OrderedCollection new.
	(selectors reject: [:each | self justSendsSuper: each]) do: 
			[:each | 
			(self superclassEquivalentlyDefines: each)
				ifTrue: 
					[(class compiledMethodAt: each) superMessages isEmpty
						ifFalse: [superMessages add: each]]
				ifFalse: [nonSupers add: each]].
	nonSupers isEmpty & superMessages isEmpty ifTrue: [^self].
	Smalltalk allBehaviorsDo: 
			[:aBehavior | 
			aBehavior selectors do: 
					[:sel | 
					| method |
					(nonSupers includes: sel) ifFalse: 
							[(aBehavior == class and: [selectors includes: sel]) ifFalse: 
									[method := aBehavior compiledMethodAt: sel.
									nonSupers do: 
											[:lit | 
											(method refersToLiteral: lit) ifTrue: 
													[self
														refactoringError: ('Possible call to <2s> in <1p><n>Browse references?'
																expandMacrosWith: aBehavior
																with: lit)
														with: [(BrowserEnvironment new referencesTo: lit) openEditor]]].
									superMessages copy do: 
											[:lit | 
											(method refersToLiteral: lit) ifTrue: 
													[self
														refactoringWarning: ('Although <1s> is equivalent to a superclass method,<n>it contains a super send so it might modify behavior.'
																expandMacrosWith: lit).
													superMessages remove: lit]]]]]]!

justSendsSuper: aSelector 
	| matcher parseTree superclass |
	matcher := ParseTreeSearcher justSendsSuper.
	parseTree := class parseTreeFor: aSelector.
	(matcher executeTree: parseTree initialAnswer: false) ifFalse: [^false].
	parseTree lastIsReturn ifTrue: [^true].
	superclass := class superclass whichClassIncludesSelector: aSelector.
	superclass isNil ifTrue: [^true].	"Since there isn't a superclass that implements the message, we can 
								 delete it since it would be an error anyway."
	parseTree := superclass parseTreeFor: aSelector.
	matcher := ParseTreeSearcher new.
	matcher matches: '^``@object'
		do: 
			[:aNode :answer | 
			answer
				add: aNode value;
				yourself].
	matcher executeTree: parseTree initialAnswer: Set new.
	^(matcher answer 
		detect: [:each | (each isVariable and: [each name = 'self']) not]
		ifNone: [nil]) isNil!

performRefactoring
	| builder |
	builder := RefactoryBuilder named: 'Remove methods'.
	selectors do: [:each | builder removeMethod: each from: class].
	self performChange: builder!

preconditions
	^(selectors inject: (Condition isClass: class)
		into: [:cond :each | cond & (Condition definesSelector: each in: class)])
			& (Condition withBlock: 
						[self checkSuperMethods.
						true])!

superclassEquivalentlyDefines: aSelector 
	| behavior |
	class superclass isNil ifTrue: [^false].
	behavior := class superclass whichClassIncludesSelector: aSelector.
	behavior isNil ifTrue: [^false].
	^(behavior compiledMethodAt: aSelector)
		equivalentTo: (class compiledMethodAt: aSelector)! !

RemoveMethodRefactoring class
	instanceVariableNames: ''!



!RemoveMethodRefactoring class methodsFor: 'instance creation'!

removeMethods: selectorCollection from: aClass
	^self new removeMethods: selectorCollection from: aClass! !

RefactoryClassChange subclass: #RemoveClassChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RemoveClassChange methodsFor: 'private'!

primitiveExecute
	self changeClass removeFromSystem! !

!RemoveClassChange methodsFor: 'converting'!

asUndoOperation
	| classChanges |
	classChanges := RefactoryBuilder new.
	self changeClass withAllSubclasses do: 
			[:each | 
			classChanges defineClass: each definition.
			each class instVarNames 
				do: [:varName | classChanges addInstanceVariable: varName to: each class].
			each selectors 
				do: [:selector | classChanges compile: (each sourceCodeAt: selector) in: each].
			each class selectors 
				do: [:selector | classChanges compile: (each class sourceCodeAt: selector) in: each class]].
	^classChanges! !

!RemoveClassChange methodsFor: 'printing'!

changeString
	^'Remove class ', self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' removeFromSystem';
		nextPut: $!!! !

RemoveClassChange class
	instanceVariableNames: ''!



!RemoveClassChange class methodsFor: 'instance creation'!

remove: aClass 
	^self new changeClass: aClass!

removeClassName: aSymbol 
	^self new changeClassName: aSymbol! !

VariableRefactoring subclass: #RenameClassVariableRefactoring
	instanceVariableNames: 'newName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RenameClassVariableRefactoring methodsFor: 'performing'!

performRefactoring
	| changeBuilder replacer literal subclasses value |
	changeBuilder := RefactoryBuilder named: 'Rename class variable'.

	"Add the new variable name. Don't delete the old one until we change all of the sources."
	changeBuilder addClassVariable: newName asSymbol to: class.
	replacer := ParseTreeRewriter 
				rename: varName
				to: newName
				handler: 
					[self 
						refactoringError: ('<1s> is already defined as a method or block temporary <n> variable in this class or one of its subclasses' 
								expandMacrosWith: newName)].
	literal := self 
				associationForClassVariable: varName
				in: class
				ifAbsent: [self refactoringError: 'Couldn''t find variable definition'].
	value := literal value.
	subclasses := class withAllSubclasses asSet.
	subclasses addAll: class class withAllSubclasses.

	"Convert the class variable name"
	self 
		convertClasses: subclasses
		select: [:aClass | aClass whichSelectorsReferTo: literal]
		using: replacer
		notifying: changeBuilder
		message: 'Changing instance variable name from: ' , varName , ' to: ' 
				, newName.

	"Remove the old variable name, and then compile the changes"
	changeBuilder removeClassVariable: varName from: class.
	self performChange: changeBuilder withLabel: 'Compiling changes'.

	"Assign the old value"
	(self 
		associationForClassVariable: newName
		in: class
		ifAbsent: [newName -> nil]) value: value!

preconditions
	^(Condition isValidClassVarName: newName asString for: class)
		& (Condition definesClassVar: varName asString in: class)
		& (Condition hierarchyOf: class definesVar: newName asString) not
		& (Condition isGlobal: newName asString) not! !

!RenameClassVariableRefactoring methodsFor: 'initialize-release'!

rename: aVarName to: aName in: aClass
	self variable: aVarName class: aClass.
	newName := aName! !

RenameClassVariableRefactoring class
	instanceVariableNames: ''!



!RenameClassVariableRefactoring class methodsFor: 'instance creation'!

rename: aVarName to: aName in: aClass
	^self new
		rename: aVarName
		to: aName
		in: aClass! !

VariableRefactoring subclass: #AddInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AddInstanceVariableRefactoring methodsFor: 'performing'!

performRefactoring
	self performChange: (AddInstanceVariableChange add: varName to: class)!

preconditions
	^(Condition isValidInstVarName: varName for: class)
		& (Condition hierarchyOf: class definesVar: varName) not
		& (Condition isGlobal: varName) not! !

AddInstanceVariableRefactoring class
	instanceVariableNames: ''!


MethodRefactoring subclass: #ChangeMethodNameRefactoring
	instanceVariableNames: 'newSelector oldSelector permutation '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ChangeMethodNameRefactoring methodsFor: 'initialize-release'!

renameMethod: aSelector in: aClass to: newSel permuation: aMap 
	oldSelector := aSelector asSymbol.
	newSelector := newSel asSymbol.
	class := aClass.
	permutation := aMap! !

!ChangeMethodNameRefactoring methodsFor: 'accessing'!

newSelector
	^newSelector! !

!ChangeMethodNameRefactoring methodsFor: 'testing'!

hasPermutedArguments
	oldSelector numArgs = newSelector numArgs ifFalse: [^true].
	1 to: oldSelector numArgs
		do: [:i | (permutation at: i) = i ifFalse: [^true]].
	^false! !

!ChangeMethodNameRefactoring methodsFor: 'performing'!

myConditions
	^self subclassResponsibility!

performRefactoring
	| imps builder |
	imps := self allImplementorsOf: oldSelector.
	self renameImplementors: imps.
	self renameMessageSends.
	self renameSymbols.
	oldSelector == newSelector ifTrue: [^self].
	builder := RefactoryBuilder named: 'Remove methods'.
	imps do: [:cls | builder removeMethod: oldSelector from: cls].
	self performChange: builder!

preconditions
	"This refactoring only preserves behavior if all implementors are renamed."

	| imps conditions |
	imps := self allImplementorsOf: oldSelector.
	conditions := self myConditions 
				& (Condition definesSelector: oldSelector in: class) 
				& (Condition isValidMethodName: newSelector for: class).
	conditions := imps inject: conditions
				into: 
					[:condition :each | 
					condition & (Condition hierarchyOf: each canUnderstand: newSelector) not].
	^conditions 
		& (Condition withBlock: 
					[imps size > 1 
						ifTrue: 
							[self refactoringWarning: ('This will modify all <1p> implementors.' 
										expandMacrosWith: imps size)].
					true])!

renameImplementors: imps 
	| builder |
	builder := RefactoryBuilder named: 'Rename implementors'.
	imps do: 
			[:cls | 
			| parseTree |
			parseTree := cls parseTreeFor: oldSelector.
			parseTree isNil 
				ifTrue: [self refactoringError: 'Could not parse source code.'].
			self modifyImplementorParseTree: parseTree in: cls.
			builder 
				compile: parseTree formattedCode
				in: cls
				classified: (cls whichCategoryIncludesSelector: oldSelector)].
	self performChange: builder withLabel: 'Compiling renamed methods'!

renameMessageSends
	| replacer builder |
	builder := RefactoryBuilder named: 'Rename message sends'.
	replacer := self parseTreeRewriter.
	self 
		convertAllClassesSelect: [:aClass | aClass whichSelectorsReferTo: oldSelector]
		using: replacer
		notifying: builder.
	self performChange: builder withLabel: 'Renaming message sends'!

renameSymbols! !

!ChangeMethodNameRefactoring methodsFor: 'private'!

modifyImplementorParseTree: parseTree in: aClass 
	| oldArgs |
	oldArgs := parseTree arguments.
	parseTree arguments: (permutation collect: [:each | oldArgs at: each]).
	parseTree selector: newSelector!

parseTreeRewriter
	| rewriteRule oldString newString |
	rewriteRule := ParseTreeRewriter new.
	oldString := self buildSelectorString: oldSelector.
	newString := self buildSelectorString: newSelector
				withPermuteMap: permutation.
	rewriteRule replace: '``@object ' , oldString
		with: '``@object ' , newString.
	^rewriteRule! !

ChangeMethodNameRefactoring class
	instanceVariableNames: ''!


ChangeMethodNameRefactoring subclass: #RenameMethodRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RenameMethodRefactoring methodsFor: 'performing'!

myConditions
	^Condition withBlock: [oldSelector numArgs = newSelector numArgs]
		errorString: newSelector printString 
				, ' doesn''t have the correct number of arguments.'!

preconditions
	| newCondition |
	newCondition := (Condition withBlock: [newSelector = oldSelector]
				errorString: 'The selectors are <1?:not >equivalent') & (Condition 
							withBlock: [permutation asArray ~= (1 to: oldSelector numArgs) asArray]
							errorString: 'The arguments are <1?:not >permuted').
	^newCondition | super preconditions!

renameSymbols
	| replacer builder |
	self hasPermutedArguments ifTrue: [^self].
	builder := RefactoryBuilder named: 'Rename symbol references'.
	replacer := ParseTreeRewriter replaceLiteral: oldSelector with: newSelector.
	self 
		convertAllClassesSelect: [:aClass | aClass whichSelectorsReferTo: oldSelector]
		using: replacer
		notifying: builder.
	self performChange: builder withLabel: 'Renaming symbols'! !

RenameMethodRefactoring class
	instanceVariableNames: ''!



!RenameMethodRefactoring class methodsFor: 'instance creation'!

renameMethod: aSelector in: aClass to: newSelector permuation: aMap 
	^self new renameMethod: aSelector
		in: aClass
		to: newSelector
		permuation: aMap! !

ChangeMethodNameRefactoring subclass: #AddParameterRefactoring
	instanceVariableNames: 'initializer senders '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AddParameterRefactoring methodsFor: 'initialize-release'!

addParameterToMethod: aSelector in: aClass newSelector: newSel initializer: init 
	self 
		renameMethod: aSelector
		in: aClass
		to: newSel
		permuation: (1 to: newSel numArgs).
	initializer := init! !

!AddParameterRefactoring methodsFor: 'performing'!

checkSendersAccessTo: name 
	| violatorClass |
	(#('self' 'super') includes: name) ifTrue: [^self].
	violatorClass := self senders 
				detect: [:each | (self canReferenceVariable: name in: each) not]
				ifNone: [nil].
	violatorClass notNil 
		ifTrue: 
			[self refactoringError: ('<1s> doesn''t appear to be defined in <2p>' 
						expandMacrosWith: name
						with: violatorClass)]!

checkVariableReferencesIn: aParseTree 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: '`var'
		do: 
			[:aNode :answer | 
			| name |
			name := aNode name.
			(aNode whoDefines: name) isNil ifTrue: [self checkSendersAccessTo: name]].
	searcher executeTree: aParseTree!

myConditions
	^Condition withBlock: 
			[oldSelector numArgs + 1 = newSelector numArgs 
				ifFalse: 
					[self 
						refactoringError: newSelector printString , ' doesn''t have the proper number of arguments.'].
			self verifyInitializationExpression.
			true]!

verifyInitializationExpression
	| tree |
	tree := BRParser parseExpression: initializer
				onError: 
					[:msg :index | 
					self refactoringError: 'Illegal initialization code because:.' , msg].
	tree isValue 
		ifFalse: 
			[self refactoringError: 'The initialization code cannot be a return node or a list of statements'].
	self checkVariableReferencesIn: tree! !

!AddParameterRefactoring methodsFor: 'private'!

allTemporaryVariables
	| imps |
	imps := self allImplementorsOf: oldSelector.
	^imps inject: Set new
		into: 
			[:set :each | 
			| parseTree |
			parseTree := each parseTreeFor: oldSelector.
			parseTree notNil ifTrue: [set addAll: parseTree allDefinedVariables].
			set]!

modifyImplementorParseTree: parseTree in: aClass 
	| name newArg |
	name := self safeVariableNameBasedOn: 'anObject'.
	newArg := BRVariableNode named: name.
	parseTree arguments: parseTree arguments , (Array with: newArg).
	super modifyImplementorParseTree: parseTree in: aClass!

newSelectorString
	| stream keywords |
	stream := WriteStream on: String new.
	keywords := newSelector keywords.
	1 to: keywords size
		do: 
			[:i | 
			stream nextPutAll: (keywords at: i).
			i == keywords size 
				ifTrue: 
					[stream
						nextPut: $(;
						nextPutAll: initializer;
						nextPut: $)]
				ifFalse: 
					[stream
						nextPutAll: ' ``@arg';
						nextPutAll: i printString].
			stream nextPut: $ ].
	^stream contents!

parseTreeRewriter
	| rewriteRule oldString newString |
	rewriteRule := ParseTreeRewriter new.
	oldString := self buildSelectorString: oldSelector.
	newString := self newSelectorString.
	rewriteRule replace: '``@object ' , oldString
		with: '``@object ' , newString.
	^rewriteRule!

safeVariableNameBasedOn: aString 
	"Creates an unused variable name containing aString"

	| baseString newString i imps allTempVars |
	allTempVars := self allTemporaryVariables.
	baseString := aString copy.
	baseString at: 1 put: baseString first asLowercase.
	newString := baseString.
	imps := self allImplementorsOf: oldSelector.
	i := 0.
	
	[(allTempVars includes: newString) or: 
			[(imps detect: [:each | (self whichClass: each defines: newString) notNil]
				ifNone: [nil]) notNil]] 
			whileTrue: 
				[i := i + 1.
				newString := baseString , i printString].
	^newString!

senders
	senders isNil 
		ifTrue: 
			[senders := OrderedCollection new.
			BrowserEnvironment new classesDo: 
					[:each | 
					(each whichSelectorsReferTo: oldSelector) isEmpty 
						ifFalse: [senders add: each]]].
	^senders! !

AddParameterRefactoring class
	instanceVariableNames: ''!



!AddParameterRefactoring class methodsFor: 'instance creation'!

addParameterToMethod: aSelector in: aClass newSelector: newSelector initializer: init 
	^self new addParameterToMethod: aSelector
		in: aClass
		newSelector: newSelector
		initializer: init! !

ChangeMethodNameRefactoring subclass: #RemoveParameterRefactoring
	instanceVariableNames: 'parameterIndex argument '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RemoveParameterRefactoring methodsFor: 'initialize-release'!

removeParameter: aString in: aClass selector: aSelector 
	oldSelector := aSelector.
	class := aClass.
	argument := aString! !

!RemoveParameterRefactoring methodsFor: 'private'!

computeNewSelector
	| keywords stream |
	oldSelector numArgs == 0 
		ifTrue: [self refactoringError: 'This method contains no arguments'].
	oldSelector isInfix 
		ifTrue: [self refactoringError: 'Cannot remove parameters of infix selectors'].
	keywords := oldSelector keywords asOrderedCollection.
	keywords size = 1 ifTrue: [^(keywords first copyWithout: $:) asSymbol].
	keywords removeAtIndex: parameterIndex.
	stream := WriteStream on: ''.
	keywords do: [:each | stream nextPutAll: each].
	^stream contents asSymbol! !

!RemoveParameterRefactoring methodsFor: 'performing'!

getNewSelector
	| tree |
	(class includesSelector: oldSelector)
		ifFalse: [self refactoringError: 'Method doesn''t exist'].
	tree := class parseTreeFor: oldSelector.
	tree isNil ifTrue: [self refactoringError: 'Cannot parse sources'].
	parameterIndex := tree argumentNames indexOf: argument ifAbsent: [self refactoringError: 'Select a parameter!!!!'].
	permutation := (1 to: oldSelector numArgs)
				copyWithout: parameterIndex.
	newSelector := self computeNewSelector!

hasReferencesToTemporaryIn: each 
	| tree |
	tree := each parseTreeFor: oldSelector.
	tree isNil ifTrue: [self refactoringError: 'Cannot parse sources.'].
	^tree references: (tree argumentNames at: parameterIndex)!

myConditions
	| imps |
	imps := self allImplementorsOf: oldSelector.
	self getNewSelector.
	^imps inject: (Condition definesSelector: oldSelector in: class)
		into: 
			[:cond :each | 
			cond & (Condition withBlock: [(self hasReferencesToTemporaryIn: each) not]
						errorString: 'This argument is still referenced in atleast one implementor!!!!')]! !

RemoveParameterRefactoring class
	instanceVariableNames: ''!



!RemoveParameterRefactoring class methodsFor: 'instance creation'!

removeParameter: aString in: aClass selector: aSelector
	^self new removeParameter: aString in: aClass selector: aSelector! !

RemoveParameterRefactoring subclass: #InlineParameterRefactoring
	instanceVariableNames: 'expressions '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!InlineParameterRefactoring methodsFor: 'private'!

allExpressionsToInline
	| coll |
	coll := OrderedCollection new.
	BrowserEnvironment new classesDo: 
			[:aClass | 
			(aClass whichSelectorsReferTo: oldSelector) do: 
					[:sel | 
					| tree |
					tree := aClass parseTreeFor: sel.
					tree notNil ifTrue: [coll addAll: (self expressionsToInlineFrom: tree)]]].
	^coll asSet asOrderedCollection!

expressionsToInlineFrom: aTree 
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher matches: '``@obj ' , (self buildSelectorString: oldSelector)
		do: 
			[:aNode :answer | 
			answer
				add: (aNode arguments at: parameterIndex);
				yourself].
	^searcher executeTree: aTree initialAnswer: OrderedCollection new! !

!InlineParameterRefactoring methodsFor: 'performing'!

modifyImplementorParseTree: parseTree in: aClass 
	| node assignment |
	node := (parseTree arguments at: parameterIndex) copy.
	parseTree body addTemporaryNamed: node name.
	assignment := BRAssignmentNode variable: node copy value: expressions first.
	parseTree body addNodeFirst: assignment.
	super modifyImplementorParseTree: parseTree in: aClass!

myConditions
	self getNewSelector.
	expressions := self allExpressionsToInline.
	^(Condition definesSelector: oldSelector in: class) 
		& ((Condition withBlock: [expressions isEmpty not]) 
				errorMacro: 'No callers. Use Remove Method instead.') 
			& ((Condition withBlock: [expressions size = 1]) 
					errorMacro: 'All values passed as this argument must be identical.') 
			& ((Condition withBlock: [expressions first isLiteral]) 
					errorMacro: 'All values passed must be literal.')! !

!InlineParameterRefactoring methodsFor: 'initialize-release'!

inlineParameter: aString in: aClass selector: aSelector
	oldSelector := aSelector.
	class := aClass.
	argument := aString! !

InlineParameterRefactoring class
	instanceVariableNames: ''!



!InlineParameterRefactoring class methodsFor: 'instance creation'!

inlineParameter: aString in: aClass selector: aSelector 
	^self new 
		inlineParameter: aString
		in: aClass
		selector: aSelector! !

VariableRefactoring subclass: #AbstractClassVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!AbstractClassVariableRefactoring methodsFor: 'performing'!

performRefactoring
	"Removes all direct references to aClassVar in this class and
	metaclass, creating reference methods if necessary."

	| classVar aLiteral builder getterMethod setterMethod replacer ref |
	classVar := varName asString.
	aLiteral := self 
				associationForClassVariable: varName
				in: class
				ifAbsent: [self refactoringError: 'Variable not found'].
	builder := RefactoryBuilder named: 'Abstract variable'.
	ref := CreateAccessorsForVariableRefactoring 
				variable: classVar
				class: class
				classVariable: true.
	self performComponentRefactoring: ref.

	"Search for the getter and setter methods"
	getterMethod := ref getterMethod.
	setterMethod := ref setterMethod.

	"Convert all references to the variable to its getter and setter method"
	replacer := ParseTreeRewriter 
				classVariable: varName
				getter: getterMethod
				setter: setterMethod.
	self 
		convertClasses: class withAllSubclasses
		select: [:aClass | aClass whichSelectorsReferTo: aLiteral]
		using: replacer
		notifying: builder
		message: 'Abstracting references to ' , varName , ' (instance)'.
	replacer := ParseTreeRewriter 
				variable: varName
				getter: getterMethod
				setter: setterMethod.
	self 
		convertClasses: class class withAllSubclasses
		select: 
			[:aClass | 
			(aClass whichSelectorsReferTo: aLiteral) reject: 
					[:each | 
					aClass == class class 
						and: [each == getterMethod or: [each == setterMethod]]]]
		using: replacer
		notifying: builder
		message: 'Abstracting references to ' , varName , ' (class)'.
	self performChange: builder withLabel: 'Compiling sources'!

preconditions
	^(Condition isClass: class)
		& (Condition isMetaclass: class) not
		& (Condition definesClassVar: varName in: class)
		& ((Condition withBlock: [(#(#Object #Behavior #ClassDescription #Class) includes: class name) not])
			errorMacro: 'This refactoring does not work for Object, Behavior, ClassDescription, or Class')! !

AbstractClassVariableRefactoring class
	instanceVariableNames: ''!


MethodRefactoring subclass: #PushDownMethodRefactoring
	instanceVariableNames: 'selectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PushDownMethodRefactoring methodsFor: 'initialize-release'!

pushDown: selectorCollection from: aClass 
	class := aClass.
	selectors := selectorCollection! !

!PushDownMethodRefactoring methodsFor: 'performing'!

performRefactoring
	| builder |
	builder := RefactoryBuilder named: 'Push down method'.
	selectors do: [:each | self pushDown: each using: builder].
	self performChange: builder.
	builder := RefactoryBuilder named: 'Remove pushed down methods'.
	selectors do: [:each | builder removeMethod: each from: class].
	self performChange: builder!

preconditions
	| condition |
	condition := selectors inject: (Condition isClass: class)
				into: 
					[:cond :each | 
					cond & (Condition definesSelector: each in: class)
						& (Condition subclassesOf: class referToSelector: each) not].
	^condition & (Condition isAbstractClass: class)!

pushDown: aSelector using: builder 
	| code protocol |
	code := class sourceCodeAt: aSelector.
	protocol := class whichCategoryIncludesSelector: aSelector.
	class subclasses do: 
			[:each | 
			(each includesSelector: aSelector) ifFalse: 
					[builder compile: code
						in: each
						classified: protocol]]! !

PushDownMethodRefactoring class
	instanceVariableNames: ''!



!PushDownMethodRefactoring class methodsFor: 'instance creation'!

pushDown: selectorCollection from: aClass 
	^self new pushDown: selectorCollection from: aClass! !

RefactoryBuilder subclass: #RenameClassChange
	instanceVariableNames: 'oldName newName '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RenameClassChange methodsFor: 'initialize-release'!

rename: oldString to: newString 
	oldName := oldString.
	newName := newString! !

!RenameClassChange methodsFor: 'accessing'!

changeClass
	^Smalltalk at: oldName asSymbol ifAbsent: [Smalltalk at: newName asSymbol]!

renameChangesForClass: aClassName to: newClassName 
	| change |
	change := super renameChangesForClass: aClassName to: newClassName.
	oldName asSymbol == aClassName 
		ifTrue: [change rename: newClassName to: newName].
	^change! !

!RenameClassChange methodsFor: 'private'!

executeNotifying: aBlock 
	| undos |
	self changeClass rename: newName.
	undos := changes collect: 
					[:each | 
					(each renameChangesForClass: oldName asSymbol to: newName asSymbol) 
						executeNotifying: aBlock].
	^(self copy)
		changes: undos reverse;
		rename: newName to: oldName;
		yourself!

flattenOnto: aCollection 
	aCollection 
		add: (self copy changes: (changes inject: OrderedCollection new
						into: 
							[:sum :each | 
							each flattenOnto: sum.
							sum]))!

newName
	^newName!

oldName
	^oldName! !

!RenameClassChange methodsFor: 'comparing'!

= aRenameClassChange 
	super = aRenameClassChange ifFalse: [^false].
	^oldName = aRenameClassChange oldName 
		and: [newName = aRenameClassChange newName]! !

RenameClassChange class
	instanceVariableNames: ''!



!RenameClassChange class methodsFor: 'instance creation'!

rename: oldString to: newString 
	^(self new)
		rename: oldString to: newString;
		yourself! !

Refactoring subclass: #RemoveClassRefactoring
	instanceVariableNames: 'classNames '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!RemoveClassRefactoring methodsFor: 'initialize-release'!

classNames: aClassNameCollection 
	classNames := aClassNameCollection! !

!RemoveClassRefactoring methodsFor: 'performing'!

hasReferencesTo: aSymbol 
	| literal |
	literal := Smalltalk associationAt: aSymbol.
	BrowserEnvironment new classesDo: 
			[:each | 
			(classNames 
				includes: (each isMeta ifTrue: [each soleInstance] ifFalse: [each]) name) 
					ifFalse: 
						[(each whichSelectorsReferTo: literal) isEmpty ifFalse: [^true].
						(each whichSelectorsReferTo: aSymbol) isEmpty ifFalse: [^true]]].
	^false!

performRefactoring
	self reparentSubclasses.
	self removeClasses!

preconditions
	^classNames inject: Condition empty
		into: 
			[:sum :each | 
			| aClass |
			aClass := Smalltalk at: each asSymbol ifAbsent: [nil].
			sum 
				& ((Condition isClass: aClass) 
						& ((Condition isMetaclass: aClass) 
								errorMacro: 'Cannot remove just the metaclass') not 
							& ((Condition withBlock: [(self hasReferencesTo: each asSymbol) not])
									errorMacro: each , ' is referenced.<n>Browse references?';
									errorBlock: 
											[(BrowserEnvironment new 
												referencesTo: (Smalltalk associationAt: each ifAbsent: [nil])) openEditor];
									yourself) 
							& ((Condition hasSubclasses: aClass) not 
									| ((Condition isEmptyClass: aClass) 
											& ((Condition withBlock: [aClass superclass notNil])
													errorMacro: 'Cannot remove top level class<n>when it has subclasses';
													yourself))))]!

removeClasses
	| builder |
	builder := RefactoryBuilder named: 'Remove classes'.
	classNames do: [:each | builder removeClass: each].
	self performChange: builder withLabel: 'Removing classes'!

reparentSubclasses
	classNames do: 
			[:each | 
			| class |
			class := Smalltalk at: each asSymbol.
			self reparentClasses: class subclasses to: class superclass]! !

RemoveClassRefactoring class
	instanceVariableNames: ''!



!RemoveClassRefactoring class methodsFor: 'instance creation'!

className: aSymbol
	^self classNames: (Array with: aSymbol)!

classNames: aClassNameCollection 
	^self new classNames: aClassNameCollection! !

MethodRefactoring subclass: #ExtractMethodRefactoring
	instanceVariableNames: 'selector extractionInterval extractedParseTree modifiedParseTree parameters needsReturn '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ExtractMethodRefactoring methodsFor: 'initialize-release'!

extract: anInterval from: aSelector in: aClass 
	class := aClass.
	selector := aSelector.
	extractionInterval := anInterval! !

!ExtractMethodRefactoring methodsFor: 'performing'!

checkAssignments: assigned 
	| node outsideVars removeAssigned |
	removeAssigned := assigned copy.
	node := self placeholderNode.
	outsideVars := assigned 
				select: [:each | (node whoDefines: each) references: each].
	outsideVars size == 1 
		ifTrue: [self checkSingleAssignment: outsideVars asArray first].
	outsideVars size > 1 
		ifTrue: 
			[self refactoringError: 'Cannot extract assignment without all references.'].
	removeAssigned removeAll: outsideVars.
	(BRReadBeforeWrittenTester readBeforeWritten: removeAssigned
		in: extractedParseTree) isEmpty 
		ifFalse: 
			[self refactoringError: 'Cannot extract assignment if read before written.'].
	removeAssigned 
		do: [:each | (node whoDefines: each) removeTemporaryNamed: each].
	self createTemporariesInExtractedMethodFor: assigned!

checkReturn
	needsReturn := self placeholderNode isUsed.
	extractedParseTree containsReturn ifFalse: [^self].
	extractedParseTree lastIsReturn ifTrue: [^self].
	(modifiedParseTree isLast: self placeholderNode) 
		ifFalse: 
			[self refactoringError: 'Couldn''t extract code since it contains a return.'].
	self checkSelfReturns!

checkSelfReturns
	| searcher |
	searcher := ParseTreeSearcher new.
	searcher
		matches: '^self' do: [:aNode :answer | answer];
		matches: '^`@anything' do: [:aNode :answer | true].
	(searcher executeTree: extractedParseTree initialAnswer: false) 
		ifTrue: [self placeholderNode asReturn]!

checkSingleAssignment: varName 
	((BRReadBeforeWrittenTester readBeforeWritten: (Array with: varName)
		in: extractedParseTree) isEmpty 
		not or: [extractedParseTree containsReturn]) 
		ifTrue: 
			[self refactoringError: 'Cannot extract assignments to temporaries without all references'].
	extractedParseTree 
		addNode: (BRReturnNode value: (BRVariableNode named: varName)).
	modifiedParseTree := ParseTreeRewriter 
				replace: self methodDelimiter
				with: varName , ' := ' , self methodDelimiter
				in: modifiedParseTree!

checkSpecialExtractions
	| node |
	node := self placeholderNode parent.
	node isNil ifTrue: [^self].
	(node isAssignment and: [node variable = self placeholderNode]) ifTrue: 
			[self refactoringError: 'Cannot extract left hand side of an assignment'].
	node isCascade ifTrue: 
			[self refactoringError: 'Cannot extract first message of a cascaded message']!

checkTemporaries
	| temps accesses assigned |
	temps := self remainingTemporaries.
	accesses := temps select: [:each | extractedParseTree references: each].
	assigned := accesses select: [:each | extractedParseTree assigns: each].
	assigned isEmpty ifFalse: [self checkAssignments: assigned].
	^parameters := (accesses asOrderedCollection)
				removeAll: assigned;
				yourself!

createTemporariesInExtractedMethodFor: assigned 
	assigned do: [:each | extractedParseTree body addTemporaryNamed: each]!

existingSelector
	"Try to find an existing method instead of creating a new one"

	^class allSelectors detect: [:each | self isMethodEquivalentTo: each]
		ifNone: [nil]!

extractMethod
	| parseTree isSequence extractCode subtree newCode |
	extractCode := self getExtractedSource.
	extractedParseTree := BRParser parseExpression: extractCode
				onError: [:string :pos | self refactoringError: 'Invalid source to extract'].
	extractedParseTree isNil 
		ifTrue: [self refactoringError: 'Invalid source to extract'].
	(extractedParseTree isSequence 
		and: [extractedParseTree temporaries isEmpty not]) 
			ifTrue: 
				[self 
					refactoringError: 'Do not select the temporary variables.<n>These are automatically extracted as needed' 
							expandMacros].
	(extractedParseTree isSequence 
		and: [extractedParseTree statements isEmpty]) 
			ifTrue: [self refactoringError: 'Select some code to extract'].
	isSequence := extractedParseTree isSequence 
				or: [extractedParseTree isReturn].
	extractedParseTree := BRMethodNode 
				selector: #value
				arguments: #()
				body: (extractedParseTree isSequence 
						ifTrue: [extractedParseTree]
						ifFalse: 
							[BRSequenceNode temporaries: #()
								statements: (OrderedCollection with: extractedParseTree)]).
	extractedParseTree source: extractCode.
	parseTree := class parseTreeFor: selector.
	parseTree isNil 
		ifTrue: [self refactoringError: 'Could not parse ' , selector printString].
	subtree := isSequence 
				ifTrue: [ParseTreeSearcher treeMatchingStatements: extractCode in: parseTree]
				ifFalse: [ParseTreeSearcher treeMatching: extractCode in: parseTree].
	subtree isNil 
		ifTrue: [self refactoringError: 'Could not extract code from method'].
	newCode := self methodDelimiter.
	isSequence 
		ifTrue: 
			[| stmts |
			stmts := extractedParseTree body statements.
			stmts isEmpty 
				ifFalse: 
					[stmts last isAssignment 
						ifTrue: 
							[| name |
							name := stmts last variable name.
							(self 
								confirm: ('Do you want to extract the assignment of <1s><n>at the end of selection?' 
										expandMacrosWith: name)) 
									ifFalse: 
										[newCode := '<1s> := <2s>' expandMacrosWith: name with: newCode.
										stmts at: stmts size put: stmts last value]]]].
	modifiedParseTree := isSequence 
				ifTrue: 
					[ParseTreeRewriter 
						replaceStatements: subtree formattedCode
						with: newCode
						in: parseTree
						onInterval: extractionInterval]
				ifFalse: 
					[ParseTreeRewriter 
						replace: subtree formattedCode
						with: newCode
						in: parseTree
						onInterval: extractionInterval]!

getExtractedSource
	| source |
	source := class sourceCodeAt: selector.
	((extractionInterval first between: 1 and: source size) 
		and: [extractionInterval last between: 1 and: source size]) 
			ifFalse: [self refactoringError: 'Invalid interval'].
	^source copyFrom: extractionInterval first to: extractionInterval last!

getNewMethodName
	| newSelector dialog |
	
	[dialog := MethodNameDialog methodNameFor: parameters.
	dialog open ifFalse: [self refactoringError: 'Did not extract code'].
	newSelector := dialog methodName.
	(self checkMethodName: newSelector in: class) 
		ifFalse: 
			[self refactoringWarning: newSelector , ' is not a valid selector name.'.
			newSelector := nil].
	(self includesSelector: newSelector asSymbol in: class) 
		ifTrue: 
			[(self confirm: ('<1s> is already defined in the <2p> hierarchy.<n>Extracting it to an existing selector may change behavior.<n>Do you wish to use <1s> anyway?' 
						expandMacrosWith: newSelector
						with: class)) 
					ifFalse: [newSelector := nil]].
	newSelector isNil] 
			whileTrue: [].
	parameters := dialog arguments asOrderedCollection.
	^newSelector asSymbol!

isMethodEquivalentTo: aSelector 
	| tree dictionary definingClass |
	selector == aSelector ifTrue: [^false].
	aSelector numArgs ~~ parameters size ifTrue: [^false].
	(self subclassOf: class redefines: aSelector) ifTrue: [^false].
	definingClass := class whichClassIncludesSelector: aSelector.
	tree := definingClass parseTreeFor: aSelector.
	tree isNil ifTrue: [^false].
	(tree body equalTo: extractedParseTree body
		exceptForVariables: (tree arguments collect: [:each | each name])) 
			ifFalse: [^false].
	(definingClass = class or: 
			[(tree superMessages detect: 
					[:each | 
					(class superclass whichClassIncludesSelector: aSelector) 
						~= (definingClass superclass whichClassIncludesSelector: each)]
				ifNone: [nil]) isNil]) 
		ifFalse: [^false].
	(self confirm: 'Use existing method ' , aSelector 
				, ' instead of creating new method?') 
		ifFalse: [^false].
	dictionary := Dictionary new.
	tree body equalTo: extractedParseTree body withMapping: dictionary.
	parameters := tree arguments collect: 
					[:each | 
					dictionary at: each name
						ifAbsent: 
							[self 
								refactoringError: 'An internal error occured, please report this error.']].
	^true!

methodDelimiter
	^'#''place.holder.for.method'''!

nameNewMethod: aSymbol 
	| args newSend |
	args := parameters collect: [:parm | BRVariableNode named: parm].
	extractedParseTree arguments: args asArray.
	extractedParseTree selector: aSymbol.
	aSymbol numArgs = 0 
		ifTrue: 
			[modifiedParseTree := ParseTreeRewriter 
						replace: self methodDelimiter
						with: 'self ' , aSymbol asString
						in: modifiedParseTree.
			^self].
	newSend := WriteStream on: ''.
	aSymbol keywords with: parameters
		do: 
			[:key :arg | 
			newSend
				nextPutAll: key asString;
				nextPut: $ ;
				nextPutAll: arg asString;
				nextPut: $ ].
	modifiedParseTree := ParseTreeRewriter 
				replace: self methodDelimiter
				with: 'self ' , newSend contents
				in: modifiedParseTree!

performRefactoring
	| builder existingSelector |
	existingSelector := self existingSelector.
	self nameNewMethod: (existingSelector isNil 
				ifTrue: [self getNewMethodName]
				ifFalse: [existingSelector]).
	builder := RefactoryBuilder named: 'Extract method refactoring'.
	existingSelector isNil 
		ifTrue: 
			[builder 
				compile: extractedParseTree formattedCode
				in: class
				classified: (class whichCategoryIncludesSelector: selector)].
	builder compile: modifiedParseTree formattedCode in: class.
	self performChange: builder!

placeholderNode
	| node |
	node := ParseTreeSearcher treeMatching: self methodDelimiter
				in: modifiedParseTree.
	node isNil ifTrue: [self refactoringError: 'Cannot extract code'].
	^node!

preconditions
	^(Condition definesSelector: selector in: class) 
		& (Condition withBlock: 
					[self extractMethod.
					self checkSpecialExtractions.
					self checkReturn.
					needsReturn ifTrue: [extractedParseTree addReturn].
					self checkTemporaries.
					true])!

remainingTemporaries
	| temps |
	temps := modifiedParseTree allDefinedVariables asSet.
	extractedParseTree allDefinedVariables 
		do: [:each | temps remove: each ifAbsent: []].
	^temps! !

ExtractMethodRefactoring class
	instanceVariableNames: ''!



!ExtractMethodRefactoring class methodsFor: 'instance creation'!

extract: anInterval from: aSelector in: aClass 
	^self new
		extract: anInterval
		from: aSelector
		in: aClass! !


!CompiledCode methodsFor: 'RefactoringBrowser'!

superMessages
	"Answer a Set of all the super message selectors sent by this method."

	| scanner selectorSet |
	selectorSet := Set new.
	self withAllBlockMethodsDo: 
			[:meth | 
			scanner := InstructionStream on: meth.
			scanner scanFor: 
					[:byte | 
					byte == OpXSuper ifTrue: 
							[selectorSet
								add: (meth literalAt: ((meth byteAt: scanner pc + 1) bitAnd: 31) + 1)].
					byte == OpXXSuper
						ifTrue: [selectorSet add: (meth literalAt: (meth byteAt: scanner pc + 2) + 1)].
					false]].
	^selectorSet! !

RestoringVariableRefactoring subclass: #PullUpInstanceVariableRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!PullUpInstanceVariableRefactoring methodsFor: 'performing'!

performRefactoring
	| builder |
	builder := RefactoryBuilder named: 'Pull up instance variable'.
	class allSubclasses do: 
			[:each | 
			(each instVarNames includes: varName) 
				ifTrue: 
					[self addInstancesAndValuesFor: each.
					builder removeInstanceVariable: varName from: each]].
	builder addInstanceVariable: varName to: class.
	self performChange: builder withLabel: 'Compiling sources'.
	self resetValues!

preconditions
	^Condition withBlock: 
			[(class subclasses
				contains: [:each | (each instVarNames includes: varName) not]) ifTrue: 
						[self
							refactoringWarning: 'Not all subclasses have an instance variable named ' , varName , '.'].
			true]! !

PullUpInstanceVariableRefactoring class
	instanceVariableNames: ''!


ClassRefactoring subclass: #ChildrenToSiblingsRefactoring
	instanceVariableNames: 'parent subclasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!ChildrenToSiblingsRefactoring methodsFor: 'initialize-release'!

name: aClassName class: aClass subclasses: subclassCollection
	className := aClassName.
	parent := aClass.
	subclasses := subclassCollection! !

!ChildrenToSiblingsRefactoring methodsFor: 'performing'!

addSuperclass
	self performComponentRefactoring: (AddClassRefactoring 
				addClass: className
				superclass: parent superclass
				subclasses: (Array with: parent)
				category: (BrowserEnvironment new whichCategoryIncludes: parent name))!

changeIsKindOfRefs
	| replacer builder association |
	builder := RefactoryBuilder named: 'Convert isKindOf: references'.
	replacer := ParseTreeRewriter new.
	replacer replace: '``@object isKindOf: ' , parent name
		with: '``@object isKindOf: ' , className.
	association := Smalltalk associationAt: parent name
				ifAbsent: [self refactoringError: 'Could not locate class'].
	self 
		convertAllClassesSelect: [:aClass | aClass whichSelectorsReferTo: association]
		using: replacer
		notifying: builder.
	self performChange: builder withLabel: 'Renaming isKindOf: references'!

performRefactoring
	self addSuperclass.
	self pushUpVars.
	self pushUpMethods.
	self changeIsKindOfRefs.
	self reparentClasses: subclasses to: self lookupClass!

preconditions
	^subclasses
		inject: (Condition isClass: parent)
				& ((Condition isMetaclass: parent)
						errorMacro: 'Superclass must not be a metaclass') not
				& (Condition isClass: parent superclass)
				& (Condition isValidClassName: className)
				& (Condition isGlobal: className) not
		into: 
			[:sub :each | 
			sub & (Condition isClass: each)
				& ((Condition isMetaclass: each)
						errorMacro: 'Subclass must <1?not :>be a metaclass') not
				& (Condition isImmediateSubclass: each of: parent)]!

pushUpMethods
	self pushUpMethodsFrom: parent.
	self pushUpMethodsFrom: parent class!

pushUpVars
	self pullUpInstVars.
	self pullUpClassInstVars.
	self pullUpClassVars.
	self pullUpPoolVars! !

!ChildrenToSiblingsRefactoring methodsFor: 'private-methods'!

computeSubclassSupersOf: aClass 
	| selectors |
	selectors := Set new.
	aClass subclasses do: 
			[:each | 
			each selectors
				do: [:sel | selectors addAll: (each compiledMethodAt: sel) superMessages]].
	^selectors!

createSubclassResponsibilityFor: aSelector in: aClass using: aBuilder 
	| source |
	(aClass superclass canUnderstand: aSelector) ifTrue: [^self].
	source := self subclassResponsibilityFor: aSelector in: aClass.
	source isNil ifTrue: [^self].
	aBuilder compile: source
		in: aClass superclass
		classified: (BrowserEnvironment new whichProtocolIncludes: aSelector in: aClass)!

pushUp: aSelector in: aClass using: aBuilder 
	| source |
	source := aClass sourceCodeAt: aSelector.
	source isNil ifFalse: 
			[aBuilder compile: source
				in: aClass superclass
				classified: (BrowserEnvironment new whichProtocolIncludes: aSelector in: aClass)]!

pushUpMethodsFrom: aClass 
	| selectorsToPushUp builder |
	builder := RefactoryBuilder named: 'Push up methods'.
	selectorsToPushUp := self selectorsToPushUpFrom: aClass.
	aClass selectors do: 
			[:each | 
			(selectorsToPushUp includes: each) 
				ifTrue: 
					[self 
						pushUp: each
						in: aClass
						using: builder]
				ifFalse: 
					[self 
						createSubclassResponsibilityFor: each
						in: aClass
						using: builder]].
	selectorsToPushUp do: [:each | builder removeMethod: each from: aClass].
	self performChange: builder!

selectorsToPushUpFrom: aClass 
	| superSelectors |
	superSelectors := self computeSubclassSupersOf: aClass.
	^aClass selectors select: 
			[:each | 
			(superSelectors includes: each) or: [self shouldPushUp: each from: aClass]]!

shouldPushUp: aSelector from: aClass 
	^(aClass subclasses detect: [:each | (each includesSelector: aSelector) not]
		ifNone: [nil]) notNil!

subclassResponsibilityFor: aSelector in: aClass 
	| methodNode position source |
	source := aClass sourceCodeAt: aSelector.
	methodNode := BRParser parseMethod: source onError: [:err :pos | ^nil].
	position := methodNode arguments isEmpty
				ifTrue: [methodNode selectorParts last stop]
				ifFalse: [methodNode arguments last stop].
	^'<1s><n><t>self subclassResponsibility'
		expandMacrosWith: (source copyFrom: 1 to: position)! !

!ChildrenToSiblingsRefactoring methodsFor: 'private-variables'!

pullUpClassInstVars
	| newSuperclass |
	newSuperclass := self lookupClass class.
	parent class instVarNames do: 
			[:each | 
			self performComponentRefactoring: (PullUpInstanceVariableRefactoring 
						variable: each
						class: newSuperclass)]!

pullUpClassVars
	| newSuperclass |
	newSuperclass := self lookupClass.
	parent classVarNames do: 
			[:each | 
			self 
				performComponentRefactoring: (PullUpClassVariableRefactoring variable: each
						class: newSuperclass)]!

pullUpInstVars
	| newSuperclass |
	newSuperclass := self lookupClass.
	parent instVarNames do: 
			[:each | 
			self performComponentRefactoring: (PullUpInstanceVariableRefactoring 
						variable: each
						class: newSuperclass)]!

pullUpPoolVars
	"Don't remove the pool variables from the subclass since they might be referenced there."

	| newSuperclass builder |
	newSuperclass := self lookupClass.
	builder := RefactoryBuilder named: 'Pull up pool variables'.
	parent sharedPools 
		do: [:each | builder addPool: (Smalltalk keyAtValue: each) to: newSuperclass].
	self performChange: builder! !

ChildrenToSiblingsRefactoring class
	instanceVariableNames: ''!



!ChildrenToSiblingsRefactoring class methodsFor: 'instance creation'!

name: aClassName class: aClass subclasses: subclassCollection 
	^self new name: aClassName
		class: aClass
		subclasses: subclassCollection! !


!CompiledMethod methodsFor: 'RefactoringBrowser'!

equivalentTo: aCompiledMethod 
	^self = aCompiledMethod or: [self class == aCompiledMethod class and: [self numArgs == aCompiledMethod numArgs
				and: 
					[| selfParseTree methodParseTree |
					selfParseTree := mclass decompilerClass new
								decompile: (mclass defaultSelectorForMethod: self)
								in: mclass
								method: self.
					methodParseTree := aCompiledMethod mclass decompilerClass new
								decompile: (aCompiledMethod mclass defaultSelectorForMethod: aCompiledMethod)
								in: aCompiledMethod mclass
								method: aCompiledMethod.
					selfParseTree = methodParseTree]]]! !

RefactoryClassChange subclass: #RefactoryVariableChange
	instanceVariableNames: 'variable '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RefactoryVariableChange methodsFor: 'initialize-release'!

class: aBehavior variable: aString 
	self changeClass: aBehavior.
	variable := aString! !

!RefactoryVariableChange methodsFor: 'private'!

variable
	^variable! !

!RefactoryVariableChange methodsFor: 'comparing'!

= aRefactoryVariableChange 
	^super = aRefactoryVariableChange 
		and: [variable = aRefactoryVariableChange variable]!

hash
	^self class hash bitXor: variable hash! !

RefactoryVariableChange class
	instanceVariableNames: ''!



!RefactoryVariableChange class methodsFor: 'instance creation'!

add: aVariable to: aBehavior 
	"This should only be called on the Add*Change subclasses, 
	but is here so we don't need to copy it to all subclasses"

	^self new class: aBehavior variable: aVariable!

remove: aVariable from: aBehavior 
	"This should only be called on the Remove*Change subclasses, 
	but is here so we don't need to copy it to all subclasses"

	^self new class: aBehavior variable: aVariable! !

RefactoryVariableChange subclass: #RemoveInstanceVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RemoveInstanceVariableChange methodsFor: 'private'!

primitiveExecute
	self changeClass removeInstVarName: variable! !

!RemoveInstanceVariableChange methodsFor: 'converting'!

asUndoOperation
	^AddInstanceVariableChange add: variable to: self changeClass! !

!RemoveInstanceVariableChange methodsFor: 'printing'!

changeString
	^'Remove instance variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' removeInstVarNamed: ';
		nextPutAll: variable;
		nextPut: $!!! !

RemoveInstanceVariableChange class
	instanceVariableNames: ''!


RefactoryVariableChange subclass: #AddClassVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!AddClassVariableChange methodsFor: 'private'!

primitiveExecute
	self changeClass addClassVarName: variable asSymbol! !

!AddClassVariableChange methodsFor: 'converting'!

asUndoOperation
	^RemoveClassVariableChange remove: variable from: self changeClass! !

!AddClassVariableChange methodsFor: 'printing'!

changeString
	^'Add class variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' addClassVarNamed: ';
		nextPutAll: variable;
		nextPut: $!!! !

AddClassVariableChange class
	instanceVariableNames: ''!


RefactoryVariableChange subclass: #RemoveClassVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RemoveClassVariableChange methodsFor: 'private'!

primitiveExecute
	Object notifySignal handle: [:ex | ex proceed]
		do: [self changeClass removeClassVarName: variable asSymbol]! !

!RemoveClassVariableChange methodsFor: 'converting'!

asUndoOperation
	^AddClassVariableChange add: variable to: self changeClass! !

!RemoveClassVariableChange methodsFor: 'printing'!

changeString
	^'Remove class variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' removeClassVarNamed: ';
		nextPutAll: variable;
		nextPut: $!!! !

RemoveClassVariableChange class
	instanceVariableNames: ''!


RefactoryVariableChange subclass: #AddPoolVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!AddPoolVariableChange methodsFor: 'private'!

primitiveExecute
	| dictionary |
	dictionary := variable isString 
				ifTrue: [Smalltalk at: variable asSymbol]
				ifFalse: [variable].
	self changeClass addSharedPool: dictionary! !

!AddPoolVariableChange methodsFor: 'converting'!

asUndoOperation
	^RemovePoolVariableChange remove: variable from: self changeClass! !

!AddPoolVariableChange methodsFor: 'printing'!

changeString
	^'Add pool variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' addSharedPool: ';
		nextPutAll: variable;
		nextPut: $!!! !

AddPoolVariableChange class
	instanceVariableNames: ''!


RefactoryVariableChange subclass: #AddInstanceVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!AddInstanceVariableChange methodsFor: 'private'!

primitiveExecute
	self changeClass addInstVarName: variable! !

!AddInstanceVariableChange methodsFor: 'converting'!

asUndoOperation
	^RemoveInstanceVariableChange remove: variable from: self changeClass! !

!AddInstanceVariableChange methodsFor: 'printing'!

changeString
	^'Add instance variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' addInstVarNamed: ';
		nextPutAll: variable;
		nextPut: $!!! !

AddInstanceVariableChange class
	instanceVariableNames: ''!


RefactoryVariableChange subclass: #RemovePoolVariableChange
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!RemovePoolVariableChange methodsFor: 'converting'!

asUndoOperation
	^AddPoolVariableChange add: variable to: self changeClass! !

!RemovePoolVariableChange methodsFor: 'private'!

primitiveExecute
	| dictionary |
	dictionary := variable isString 
				ifTrue: [Smalltalk at: variable asSymbol]
				ifFalse: [variable].
	self changeClass removeSharedPool: dictionary! !

!RemovePoolVariableChange methodsFor: 'printing'!

changeString
	^'Remove pool variable named, <1s>, from <2s>' 
		expandMacrosWith: variable
		with: self displayClassName!

printOn: aStream 
	aStream
		nextPutAll: self displayClassName;
		nextPutAll: ' removeSharedPool: ';
		nextPutAll: variable;
		nextPut: $!!! !

RemovePoolVariableChange class
	instanceVariableNames: ''!


RefactoryClassChange subclass: #AddMethodChange
	instanceVariableNames: 'source selector protocol '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!AddMethodChange methodsFor: 'converting'!

asUndoOperation
	^(self changeClass includesSelector: self selector) 
		ifTrue: 
			[| oldProtocol |
			oldProtocol := BrowserEnvironment new whichProtocolIncludes: self selector
						in: self changeClass.
			oldProtocol isNil ifTrue: [oldProtocol := #accessing].
			AddMethodChange 
				compile: (self methodSourceFor: self selector)
				in: self changeClass
				classified: oldProtocol]
		ifFalse: [RemoveMethodChange remove: selector from: self changeClass]! !

!AddMethodChange methodsFor: 'initialize-release'!

class: aClass protocol: aProtocol source: aString 
	self changeClass: aClass.
	protocol := aProtocol.
	source := aString!

class: aClass source: aString 
	self changeClass: aClass.
	source := aString.
	protocol := BrowserEnvironment new whichProtocolIncludes: self selector
				in: aClass.
	protocol isNil ifTrue: [protocol := #accessing]! !

!AddMethodChange methodsFor: 'private'!

controller
	^nil!

parseTree
	^BRParser parseMethod: source onError: [:str :pos | ^nil]!

primitiveExecute
	^self changeClass 
		compile: source
		classified: protocol
		notifying: self controller! !

!AddMethodChange methodsFor: 'accessing'!

selector
	selector isNil ifTrue: 
			[selector := BRParser parseMethodPattern: source.
			selector isNil ifTrue: [selector := #unknown]].
	^selector! !

!AddMethodChange methodsFor: 'printing'!

changeString
	^self displayClassName , '>>' , self selector!

printOn: aStream 
	aStream
		nextPut: $!!;
		nextPutAll: self displayClassName;
		nextPutAll: ' methodsFor: ''';
		nextPutAll: protocol;
		nextPutAll: '''!!';
		cr;
		cr;
		nextPutAll: source;
		nextPutAll: '!! !!'! !

!AddMethodChange methodsFor: 'comparing'!

= anAddMethodChange 
	super = anAddMethodChange ifFalse: [^false].
	^self parseTree = anAddMethodChange parseTree!

hash
	^self parseTree hash! !

AddMethodChange class
	instanceVariableNames: ''!



!AddMethodChange class methodsFor: 'instance creation'!

compile: aString in: aClass 
	^self new class: aClass source: aString!

compile: aString in: aBehavior classified: aProtocol 
	^self new 
		class: aBehavior
		protocol: aProtocol
		source: aString! !

AddMethodChange subclass: #InteractiveAddMethodChange
	instanceVariableNames: 'controller definedSelector '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!InteractiveAddMethodChange methodsFor: 'accessing'!

definedSelector
	^definedSelector! !

!InteractiveAddMethodChange methodsFor: 'private'!

controller
	^controller!

controller: aController 
	controller := aController!

primitiveExecute
	^definedSelector := super primitiveExecute! !

InteractiveAddMethodChange class
	instanceVariableNames: ''!



!InteractiveAddMethodChange class methodsFor: 'instance creation'!

compile: aString in: aBehavior classified: aProtocol for: aController 
	^(self 
		compile: aString
		in: aBehavior
		classified: aProtocol)
		controller: aController;
		yourself!

compile: aString in: aClass for: aController 
	^(self compile: aString in: aClass)
		controller: aController;
		yourself! !

InlineMethodRefactoring subclass: #InlineMethodFromComponentRefactoring
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Refactorings'!



!InlineMethodFromComponentRefactoring methodsFor: 'performing'!

abstractVariableReferences
	| refactoring |
	refactoring := AbstractVariablesRefactoring 
				abstractVariablesIn: inlineParseTree
				from: inlineClass
				toAll: (Array with: class).
	self performComponentRefactoring: refactoring.
	inlineParseTree := refactoring parseTree!

addArgumentToSelector: aSymbol 
	^aSymbol isInfix 
		ifTrue: [#value:value:]
		ifFalse: [(aSymbol , 'value:') asSymbol]!

addSelfReferenceToInlineParseTree
	| variableName rewriter newArguments |
	variableName := self newNameForSelf.
	rewriter := ParseTreeRewriter rename: 'self' to: variableName.
	(rewriter executeTree: inlineParseTree) 
		ifTrue: [inlineParseTree := rewriter tree].
	newArguments := inlineParseTree arguments asOrderedCollection.
	newArguments addFirst: (BRVariableNode named: variableName).
	inlineParseTree
		arguments: newArguments;
		selector: (self addArgumentToSelector: inlineParseTree selector).
	sourceMessage receiver replaceWith: (BRVariableNode named: variableName)!

addSelfReferenceToSourceMessage
	| newArguments |
	newArguments := sourceMessage arguments asOrderedCollection.
	newArguments addFirst: sourceMessage receiver copy.
	sourceMessage
		arguments: newArguments;
		selector: (self addArgumentToSelector: sourceMessage selector)!

checkSuperMessages
	inlineParseTree superMessages isEmpty 
		ifFalse: 
			[self 
				refactoringError: 'Cannot inline method since it sends a super message']!

findSelectedMessage
	sourceParseTree := class parseTreeFor: sourceSelector.
	sourceParseTree isNil 
		ifTrue: [self refactoringError: 'Could not parse sources'].
	sourceMessage := sourceParseTree whichNodeIsContainedBy: sourceInterval.
	sourceMessage isNil 
		ifTrue: 
			[self 
				refactoringError: 'The selection doesn''t appear to be a message send'].
	sourceMessage isCascade 
		ifTrue: [sourceMessage := sourceMessage messages last].
	sourceMessage isMessage 
		ifFalse: 
			[self 
				refactoringError: 'The selection doesn''t appear to be a message send']!

inlineClass
	| imps |
	inlineClass notNil ifTrue: [^inlineClass].
	imps := self allImplementorsOf: self inlineSelector.
	imps size = 1 ifTrue: [^inlineClass := imps first].
	imps isEmpty 
		ifTrue: 
			[self 
				refactoringError: 'Nobody defines a method named ' , self inlineSelector].
	inlineClass := BrowserApplicationModel basicNew 
				choose: 'Which implementation should be inlined?'
				fromList: imps
				values: imps
				lines: 5
				cancel: [nil].
	inlineClass isNil 
		ifTrue: [self refactoringError: 'No implementor selected'].
	^inlineClass!

newNameForSelf
	| variableName index originalName nonMetaClass |
	nonMetaClass := inlineClass isMeta 
				ifTrue: [inlineClass soleInstance]
				ifFalse: [inlineClass].
	variableName := originalName := (nonMetaClass name first isVowel 
						ifTrue: ['an']
						ifFalse: ['a']) , nonMetaClass name.
	index := 1.
	
	[variableName := self safeVariableNameBasedOn: variableName.
	inlineParseTree allDefinedVariables includes: variableName] 
			whileTrue: 
				[variableName := originalName , index printString.
				index := index + 1].
	^variableName!

performRefactoring
	self abstractVariableReferences.
	self renameSelfReferences.
	super performRefactoring!

renameSelfReferences
	self addSelfReferenceToSourceMessage.
	self addSelfReferenceToInlineParseTree.!

safeVariableNameBasedOn: aString 
	"Creates an unused variable name containing aString"

	| baseString newString i allTempVars |
	allTempVars := inlineParseTree allTemporaryVariables.
	baseString := aString copy.
	baseString at: 1 put: baseString first asLowercase.
	newString := baseString.
	i := 0.
	
	[(allTempVars includes: newString) 
		or: [(self whichClass: class defines: newString) notNil]] 
			whileTrue: 
				[i := i + 1.
				newString := baseString , i printString].
	^newString! !

!InlineMethodFromComponentRefactoring methodsFor: 'testing'!

isOverridden
	^(self inlineClass allSubclasses 
		detect: [:each | each includesSelector: self inlineSelector]
		ifNone: [nil]) notNil! !

InlineMethodFromComponentRefactoring class
	instanceVariableNames: ''!


AddClassChange subclass: #InteractiveAddClassChange
	instanceVariableNames: 'controller definedClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Support'!



!InteractiveAddClassChange methodsFor: 'private'!

controller
	^controller!

controller: aController 
	controller := aController!

primitiveExecute
	definedClass := super primitiveExecute! !

!InteractiveAddClassChange methodsFor: 'accessing'!

definedClass
	^definedClass! !

InteractiveAddClassChange class
	instanceVariableNames: ''!



!InteractiveAddClassChange class methodsFor: 'instance creation'!

definition: aString for: aController 
	^(self definition: aString)
		controller: aController;
		yourself! !

AbstractCondition subclass: #ConjunctiveCondition
	instanceVariableNames: 'left right failed '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Conditions'!

ConjunctiveCondition comment:
'ConjunctiveCondition represents and-ing two AbstractConditions together.

Instance Variables:
	failed	<Symbol>	which condition failed (#leftFailed, #rightFailed, or #unknownFailed)
	left	<AbstractCondition>	the condition on the left side of the and
	right	<AbstractCondition>	the condition on the right side of the and'!


!ConjunctiveCondition methodsFor: 'initialize-release'!

left: aCondition right: aCondition2 
	left := aCondition.
	right := aCondition2.
	failed := #unknownFailed! !

!ConjunctiveCondition methodsFor: 'checking'!

check
	left check
		ifFalse: 
			[failed := #leftFailed.
			^false].
	right check
		ifFalse: 
			[failed := #rightFailed.
			^false].
	^true! !

!ConjunctiveCondition methodsFor: 'printing'!

printOn: aStream 
	aStream print: left;
		nextPutAll: ' & ';
		print: right! !

!ConjunctiveCondition methodsFor: 'private'!

errorBlockFor: aBoolean 
	^aBoolean
		ifTrue: [nil]
		ifFalse: 
			[failed == #leftFailed ifTrue: [left errorBlock] ifFalse: [right errorBlock]]!

errorMacro
	^errorMacro isNil
		ifTrue: [self longMacro]
		ifFalse: [super errorMacro]!

errorStringFor: aBoolean 
	^aBoolean
		ifTrue: [self neitherFailed]
		ifFalse: [self perform: failed]!

leftFailed
	^left errorStringFor: false!

longMacro
	^'(' , left errorMacro , ') <1?AND:OR> (' , right errorMacro , ')'!

neitherFailed
	^(left errorStringFor: true) , ' AND ' , (right errorStringFor: true)!

rightFailed
	^right errorStringFor: false!

unknownFailed
	^(left errorStringFor: false) , ' OR ' , (right errorStringFor: false)! !

ConjunctiveCondition class
	instanceVariableNames: ''!


Refactoring initialize!

RefactoringManager initialize!


