"       NAME           Progress Widget
        AUTHOR         brant@cs.uiuc.edu
        FUNCTION       create percent done bars (as specs or views)
        ST-VERSIONS    VW2.0
        PREREQUISITES  none
        DISTRIBUTION   world
        VERSION        1.0
        DATE           10-Apr-95

This code adds a new tool to the Pallette window which allows you to create 
percent done widgets. These widgets have several properties that can be set 
(direction -- vertical, horizontal, or both, starting position -- center, 
upper left, etc., colors, ...).
 
For more information:
	http://st-www.cs.uiuc.edu/users/brant/Applications/ProgressWidget.html

					John Brant
"!

'From VisualWorks(R) Release 2.0 of 4 August 1994 on 10 January 1995 at 6:51:24 pm'!



WidgetSpec subclass: #ProgressWidgetSpec
	instanceVariableNames: 'direction position area reverse '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Widgets'!
ProgressWidgetSpec comment:
'This class is the Spec for the ProgressWidgetView.

Instance Variables:
	direction		<Symbol> #horizontal, #vertical, #both
	position		<Symbol> location of the origin (#topLeft, #topRight, #bottomRight, #bottomLeft)
	area			<Boolean> two dimensional bars go by area or by distance
	reverse		<Boolean> bar grow from outside inward'!


!ProgressWidgetSpec methodsFor: 'accessing'!

area
	^area!

area: aValue
	area := aValue!

direction
	^direction!

direction: aDirection
	direction := aDirection!

position
	^position!

position: aPosition
	position := aPosition!

reverse
	^reverse!

reverse: aBoolean 
	reverse := aBoolean! !

!ProgressWidgetSpec methodsFor: 'initialize'!

initialize
	super initialize.
	direction := #horizontal.
	position := #topLeft.
	isOpaque := true.
	area := true.
	reverse := false! !

!ProgressWidgetSpec methodsFor: 'private'!

defaultModel
	^ValueHolder with: 0.5!

dispatchTo: policy with: builder 
	^policy progress: self into: builder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ProgressWidgetSpec class
	instanceVariableNames: ''!


!ProgressWidgetSpec class methodsFor: 'interface specs'!

basicsEditSpec
	"UIPainter new openOnClass: self andSelector: #basicsEditSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: ' ' 
			#min: #(#Point 300 243 ) 
			#max: #(#Point 300 243 ) 
			#bounds: #(#Rectangle 565 290 865 533 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0.5 110 0 2 0.5 254 0 ) 
					#orientation: #vertical ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame -33 1 110 0 -31 1 254 0 ) 
					#orientation: #vertical ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0.5 109 0 -33 1 113 0 ) ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0.5 253 0 -33 1 257 0 ) ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 0 0.5 4 0 0.5 0 ) 
					#label: 'Progress Bar' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 55 0 0 1 ) 
					#label: 'Aspect:' ) 
				#(#LabelSpec 
					#layout: #(#AlignmentOrigin 10 0 87 0 0 1 ) 
					#label: 'ID:' ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 86 0 28 0 -10 1 53 0 ) 
					#model: #model 
					#menu: #fieldMenu 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 86 0 60 0 -10 1 85 0 ) 
					#model: #name 
					#menu: #fieldMenu ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 2 0.5 110 0 0.5 0.5 ) 
					#model: #position 
					#select: #topLeft ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -30 1 110 0 0.5 0.5 ) 
					#model: #position 
					#select: #topRight ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -15 0.75 182 0 0.5 0.5 ) 
					#model: #position 
					#select: #center ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 2 0.5 254 0 0.5 0.5 ) 
					#model: #position 
					#select: #bottomLeft ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -30 1 254 0 0.5 0.5 ) 
					#model: #position 
					#select: #bottomRight ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 115 ) 
					#model: #direction 
					#label: 'Horizontal' 
					#select: #horizontal ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 143 ) 
					#model: #direction 
					#label: 'Vertical' 
					#select: #vertical ) 
				#(#RadioButtonSpec 
					#layout: #(#Point 10 171 ) 
					#model: #direction 
					#label: 'Both' 
					#select: #both ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 28 192 ) 
					#model: #area 
					#label: 'Area' ) 
				#(#CheckBoxSpec 
					#layout: #(#Point 10 216 ) 
					#model: #reverse 
					#label: 'Reverse' ) ) ) )! !

!ProgressWidgetSpec class methodsFor: 'resources'!

paletteIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 3 bitsPerPixel: 4 palette: (MappedPalette withColors: ((Array new: 5) at: 1 put: ColorValue black; at: 2 put: ColorValue blue; at: 3 put: (ColorValue scaledRed: 3699 scaledGreen: 3699 scaledBlue: 3699); at: 4 put: ColorValue white; at: 5 put: (ColorValue scaledRed: 6605 scaledGreen: 6605 scaledBlue: 6605); yourself)) usingBits: (ByteArray fromPackedString: '@@@@@@@@@@@@@@@@@@@@@@L3L3L3L3L3L3L3L2@@@@@CQDQDQDQDQDQDQDP @@@@@4QDQDQDQDQDQDQDH@@@@@MDQDQDQDQDQDQDQB@@@@@CQDQDQDQDQDQDQDP @@@@@4QDQDQDQDQDQDQDH@@@@@MDP@@@@@@@@@@DQB@@@@@CQD@QDQDQDQQDMDP @@@@@4Q@DQDQDQDTQCQDH@@@@@MDPADTQAQDEDP4QB@@@@@CQD@QDQPQEAQDMDP @@@@@4Q@DQEADTDTQCQDH@@@@@MDPADQPQEAEDP4QB@@@@@CQD@QDQDQDQQDMDP @@@@@4Q@DQDQDQDTQCQDH@@@@@MDP3L3L3L3L3L4QB@@@@@CQDQDQDQDQDQDQDP @@@@@4QDQDQDQDQDQDQDH@@@@@MDQDQDQDQDQDQDQB@@@@@CQDQDQDQDQDQDQDP @@@@@4QDQDQDQDQDQDQDH@@@@@MDQDQDQDQDQDQDQB@@@@@CQDQDQDQDQDQDQDP @@@@@"H"H"H"H"H"H"H"H@@@@@@@@@@@@@@@@@@@@@@@@@@b'))!

paletteMonoIcon
	"UIMaskEditor new openOnClass: self andSelector: #paletteMonoIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 26@26 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 143 255 248 192 143 255 0 192 143 17 0 192 143 221 0 192 143 187 0 192 143 187 0 192 143 255 0 192 143 255 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 128 0 0 192 255 255 255 192 255 255 255 192])! !

!ProgressWidgetSpec class methodsFor: 'private-interface building'!

addBindingsTo: env for: inst channel: aChannel 
	super
		addBindingsTo: env
		for: inst
		channel: aChannel.
	env at: #direction put: (self
			adapt: inst
			forAspect: #direction
			channel: aChannel).
	env at: #position put: (self
			adapt: inst
			forAspect: #position
			channel: aChannel).
	env at: #area put: (self
			adapt: inst
			forAspect: #area
			channel: aChannel).
	env at: #reverse put: (self
			adapt: inst
			forAspect: #reverse
			channel: aChannel)!

componentName
	^'Percent done bar'!

slices
	^#(	(Basics basicsEditSpec)
		(Color propSpec ColorToolModel) 
		(Position propSpec PositionToolModel) )! !


!UILookPolicy methodsFor: 'building'!

progress: progressSpec into: builder 
	| component mdl direction |
	mdl := progressSpec modelInBuilder: builder.
	component := ProgressWidgetView new model: mdl.
	direction := progressSpec direction.
	direction == #horizontal ifTrue: [component beHorizontal].
	direction == #vertical ifTrue: [component beVertical].
	direction == #both ifTrue: [component beTwoDimensional].
	component area: progressSpec area.
	component position: progressSpec position.
	component reverse: progressSpec reverse.
	builder component: component.
	self
		setDispatcherOf: component
		fromSpec: progressSpec
		builder: builder.
	builder wrapWith: self borderedWrapperClass new.
	builder wrapper border: self inputFieldBorder.
	builder wrapper inset: 0.
	builder applyLayout: progressSpec layout.
	builder wrapWith: (self
			simpleWidgetWrapperOn: builder
			spec: progressSpec
			state: WidgetState new)! !


DependentPart subclass: #ProgressWidgetView
	instanceVariableNames: 'axis lastValue position reverse area '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Widgets'!
ProgressWidgetView comment:
'This class implements a simple progress done widget. It displays a progress bar and the text ("XX%") in the center. The bar can be vertical, horizontal or both and is specified by the properties tool. The starting point (e.g., top left corner) can also be specified.

Instance Variables:
	axis			<Point> 1@0 for horizontal, 0@1 for vertical, 1@1 for both
	lastValue 		<Number> value for the pixmap
	position		<Symbol> location of the origin (#topLeft, #topRight, #bottomRight, #bottomLeft)
	reverse		<Boolean> bar grow from outside inward
	area			<Boolean> two dimensional bars go by area or by distance'!


!ProgressWidgetView methodsFor: 'displaying'!

displayOn: graphicsContext 
	| string origin extent stringOrigin |
	origin := self barOrigin.
	extent := self barExtent.
	graphicsContext paint: self bgColor.
	graphicsContext displayRectangle: self bounds.
	graphicsContext paint: self fgColor.
	graphicsContext displayRectangle: (origin extent: extent).
	string := (lastValue printString , '%') asText allBold asComposedText.
	stringOrigin := (self bounds extent - string bounds extent / 2.0) rounded.
	string displayOn: graphicsContext at: stringOrigin.
	graphicsContext paint: self bgColor.
	graphicsContext clippingRectangle: (origin extent: extent).
	string displayOn: graphicsContext at: stringOrigin! !

!ProgressWidgetView methodsFor: 'updating'!

update: aspectSymbol
	| currentValue |
	currentValue := lastValue.
	self setLastValue.
	lastValue ~~ currentValue
		ifTrue:
			[self invalidate.
			self repairDamage]! !

!ProgressWidgetView methodsFor: 'accessing'!

barExtent
	^(self bounds extent - (self bounds extent * axis * (1 @ 1 - (self value @ self value)))) rounded!

barOrigin
	| extent origin |
	extent := self barExtent.
	origin := 0 @ 0.
	position = #topRight | (position == #topLeft) ifFalse: [origin := 0 @ (self bounds extent y - extent y)].
	position == #topRight | (position == #bottomRight) ifTrue: [origin := self bounds extent x - extent x @ origin y].
	position == #center ifTrue: [origin := (self bounds extent - extent / 2.0) rounded].
	^origin!

bgColor
	^reverse
		ifTrue: [self foregroundColor]
		ifFalse: [self backgroundColor]!

fgColor
	^reverse ifFalse: [self foregroundColor]
		ifTrue: [self backgroundColor]!

percent
	model isNil ifTrue: [^0].
	^(model value max: 0.0)
		min: 1.0!

value
	| value |
	value := self percent.
	reverse ifTrue: [value := 1.0 - value].
	^axis = (1 @ 1) & area
		ifTrue: [value sqrt]
		ifFalse: [value]! !

!ProgressWidgetView methodsFor: 'private'!

setLastValue
	lastValue := (self percent * 100.0) rounded!

setModel: aModel 
	super setModel: aModel.
	self setLastValue! !

!ProgressWidgetView methodsFor: 'initialize-release'!

area: aBoolean
	area := aBoolean!

axis: aPoint
	axis = aPoint ifFalse:
		[axis := aPoint.
		self invalidate]!

beHorizontal
	self axis: 1@0!

beTwoDimensional
	self axis: 1@1!

beVertical
	self axis: 0@1!

initialize
	super initialize.
	lastValue := 0.
	self beVertical.
	self position: #topLeft.
	area := true.
	reverse := false!

position: aPosition
	position := aPosition!

reverse: aBoolean 
	reverse := aBoolean! !

!ProgressWidgetView methodsFor: 'display box accessing'!

preferredBounds
	"Answer the Screen's bounding box."

	^Screen default bounds! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ProgressWidgetView class
	instanceVariableNames: ''!


!ProgressWidgetView class methodsFor: 'dialogs'!

progressOpenOn: aModel label: aLabel
	"A simple window that displays aLabel and the progress view on aModel."

	| wrapper topView upperView lowerView size graphic |
	(aLabel isKindOf: VisualComponent)
		ifTrue: [graphic := aLabel]
		ifFalse: [graphic := aLabel asText asComposedText].
	wrapper := CompositePart new.
	upperView := CompositePart new.
	lowerView := CompositePart new.
	upperView add: graphic in: (LayoutFrame
			leftFraction: 0.5
			offset: (graphic bounds extent // 2) x negated
			rightFraction: 0.5
			offset: (graphic bounds extent // 2) x
			topFraction: 0.5
			offset: (graphic bounds extent // 2) y negated
			bottomFraction: 0.5
			offset: (graphic bounds extent // 2) y).
	lowerView add: ((ProgressWidgetView model: aModel) beHorizontal; yourself) in: (0 @ 0 corner: 1 @ 1).
	wrapper add: upperView in: ((LayoutFrame new) leftFraction: 0; rightFraction: 1; topFraction: 0.0; bottomFraction: 0.0 offset: graphic bounds extent y + 10; yourself).
	wrapper add: lowerView borderedIn: ((LayoutFrame new) leftFraction: 0; rightFraction: 1; topFraction: 0.0 offset: graphic bounds extent y + 10; bottomFraction: 1).
	topView := ScheduledWindow new.
	topView damageRepairPolicy: DoubleBufferingWindowDisplayPolicy new.
	topView label: ''.
	topView component: wrapper.
	size := (graphic bounds extent x + 20 max: 150)
				@ (graphic bounds extent y + 10 * 2 max: 50).
	topView minimumSize: size; maximumSize: size.
	topView openDisplayAt: Screen default bounds extent // 2 - (size // 2).
	^topView controller! !

!ProgressWidgetView class methodsFor: 'examples'!

example
	"ProgressWidgetView example"

	| windowController aModel |
	aModel := 0.0 asValue.
	windowController := self progressOpenOn: aModel label: 'This is a test' asText allBold.
	1 to: 10
		do:
			[:i |
			aModel value: i / 10.0.
			(Delay forMilliseconds: 200) wait].
	windowController closeAndUnschedule!

example1
	"ProgressWidgetView example1"

	| windowController aModel view messages positions reverse |
	messages := #(#beHorizontal #beVertical #beTwoDimensional).
	positions := #(#topLeft #topRight #bottomLeft #bottomRight #center).
	reverse := #(true false).
	messages do: [:msg | positions do: [:pos | reverse
				do: 
					[:bool | 
					aModel := 0.0 asValue.
					view := ProgressWidgetView new.
					view initialize.
					view model: aModel.
					view perform: msg.
					view position: pos.
					view reverse: bool.
					windowController := self exampleOpenWith: view label: 'This is a test' asText allBold.
					aModel value: 0.0.
					1 to: 10
						do: 
							[:i | 
							aModel value: i / 10.0.
							(Delay forMilliseconds: 200) wait].
					windowController closeAndUnschedule]]]!

exampleOpenWith: aComponent label: aLabel 
	| wrapper topView upperView lowerView size graphic |
	(aLabel isKindOf: VisualComponent)
		ifTrue: [graphic := aLabel]
		ifFalse: [graphic := aLabel asText asComposedText].
	wrapper := CompositePart new.
	upperView := CompositePart new.
	lowerView := CompositePart new.
	upperView add: graphic in: (LayoutFrame
			leftFraction: 0.5
			offset: (graphic bounds extent // 2) x negated
			rightFraction: 0.5
			offset: (graphic bounds extent // 2) x
			topFraction: 0.5
			offset: (graphic bounds extent // 2) y negated
			bottomFraction: 0.5
			offset: (graphic bounds extent // 2) y).
	lowerView add: aComponent in: (0 @ 0 corner: 1 @ 1).
	wrapper add: upperView in: ((LayoutFrame new) leftFraction: 0; rightFraction: 1; topFraction: 0.0; bottomFraction: 0.0 offset: graphic bounds extent y + 10; yourself).
	wrapper add: lowerView borderedIn: ((LayoutFrame new) leftFraction: 0; rightFraction: 1; topFraction: 0.0 offset: graphic bounds extent y + 10; bottomFraction: 1).
	topView := ScheduledWindow new.
	topView damageRepairPolicy: DoubleBufferingWindowDisplayPolicy new.
	topView label: ''.
	topView component: wrapper.
	size := (graphic bounds extent x + 20 max: 150)
				@ ((graphic bounds extent x + 20 max: 150) + (graphic bounds extent y + 10)).
	topView minimumSize: size; maximumSize: size.
	topView openDisplayAt: Screen default bounds extent // 2 - (size // 2).
	^topView controller! !

UIPalette activeSpecsList add: #ProgressWidgetSpec!

