'From VisualWorks(R), Release 2.5 of September 26, 1995 on August 17, 1996 at 12:55:40 pm'!


!VisualLauncher methodsFor: 'refactoring browser drag and drop'!

refactoringBrowserDragEnter: aDragContext 
	^(self canAcceptBrowseDropFrom: aDragContext)
		ifTrue: [(self builder componentAt: #refactoringBrowser) widget isInTransition: true.
			#dropEffectMove]
		ifFalse: [#dropEffectNone]!

refactoringBrowserDragLeave: aDragContext 
	(self canAcceptBrowseDropFrom: aDragContext)
		ifTrue: [(self builder componentAt: #refactoringBrowser) widget isInTransition: false].
	^#dropEffectNone!

refactoringBrowserDrop: aDragContext 
	| dict state class |
	(self canAcceptBrowseDropFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	dict := aDragContext sourceData clientData.
	(dict includesKey: #navigatorState)
		ifTrue: [state := dict at: #navigatorState]
		ifFalse: 
			[state := NavigatorState new.
			state categories: (Array with: (dict at: #category ifAbsent: [nil])).
			class := Smalltalk at: (dict at: #class ifAbsent: [''])
						ifAbsent: [nil].
			class notNil ifTrue: [(dict at: #meta ifAbsent: [false])
					ifTrue: [class := class class]].
			state selectedClasses: (Array with: class).
			state protocols: (Array with: (dict at: #protocol ifAbsent: [nil])).
			state selectors: (Array with: (dict at: #selector ifAbsent: [nil]))].
	(RefactoringBrowser open navigator) setState: state; changedCategory.
	(self builder componentAt: #refactoringBrowser) widget isInTransition: false.
	^#dropEffectNone! !


!VisualLauncher class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'VisualWorks' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 400 247 892 386 ) 
			#flags: 4 
			#menu: #newMenuBar ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#properties: 
					#(#PropertyListDictionary #dragEnterSelector 
						#fileDragEnter: #dropSelector 
						#fileDrop: #dragExitSelector 
						#fileDragLeave: #dragOverSelector 
						#fileDragOver: ) 
					#layout: #(#Rectangle 0 0 32 32 ) 
					#name: #fileListButton 
					#model: #openFileList 
					#tabable: false 
					#label: #fileListIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#properties: 
					#(#PropertyListDictionary #dragEnterSelector 
						#browseDragEnter: #dropSelector 
						#browseDrop: #dragExitSelector 
						#browseDragLeave: #dragOverSelector 
						#browseDragOver: ) 
					#layout: #(#Rectangle 32 0 64 32 ) 
					#name: #browserButton 
					#model: #browseAllClasses 
					#tabable: false 
					#label: #allClassesIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#properties: 
					#(#PropertyListDictionary #dragEnterSelector 
						#canvasDragEnter: #dropSelector 
						#canvasDrop: #dragExitSelector 
						#canvasDragLeave: #dragOverSelector 
						#canvasDragOver: ) 
					#layout: #(#Rectangle 112 0 144 32 ) 
					#name: #canvasButton 
					#model: #toolsNewCanvas 
					#tabable: false 
					#label: #newCanvasIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 144 0 176 32 ) 
					#model: #browseApplications 
					#tabable: false 
					#label: #finderIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 176 0 208 32 ) 
					#model: #openDataModelBrowser 
					#tabable: false 
					#label: #dbToolIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 224 0 256 32 ) 
					#model: #openHelpBrowser 
					#tabable: false 
					#label: #helpIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 64 0 96 32 ) 
					#model: #toolsNewWorkspace 
					#tabable: false 
					#label: #workspaceIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ArbitraryComponentSpec 
					#layout: #(#LayoutFrame 0 0 32 0 2 1 0 1 ) 
					#name: #textViewID 
					#flags: 9 
					#component: #textView ) 
				#(#ActionButtonSpec 
					#layout: #(#Rectangle 272 0 304 32 ) 
					#name: #extFinderButton 
					#flags: 56 
					#model: #openExternalFinder 
					#tabable: false 
					#label: #extFinderIcon 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -32 1 0 0 0 1 32 0 ) 
					#model: #openSmalllint 
					#label: #CGLint24 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#properties: 
					#(#PropertyListDictionary #dragEnterSelector 
						#refactoringBrowserDragEnter: #dropSelector 
						#refactoringBrowserDrop: #dragExitSelector 
						#refactoringBrowserDragLeave: #dragOverSelector 
						#browseDragOver: ) 
					#layout: #(#LayoutFrame -64 1 0 0 -32 1 32 0 ) 
					#name: #refactoringBrowser 
					#model: #openRefactoringBrowser 
					#label: #CGRefactoringBrowser24 
					#hasCharacterOrientedLabel: false ) ) ) )! !

UISettings lookAndFeelAccept!

