'From VisualWorks, Release 3.0 of February 5, 1998 on October 14, 1998 at 7:30:47 pm'!

!SimpleDialog methodsFor: 'RefactoringBrowser'!

addMultiList: model lines: maxLines validation: valid

	| height layout field grid font scrollW max fullMax |

	height := builder window displayBox height.
	layout := LayoutFrame new.
	layout leftOffset: 16.
	layout rightFraction: 1 offset: -16.
	layout topOffset: height.
	field := SequenceViewSpec model: model menu: nil layout: layout.
	field multipleSelections: true.
	builder add: field.
	builder wrapper widget controller setDispatcher:
		(UIDispatcher new doubleClick: [valid value ifTrue: [accept value: true]]).
	"builder wrapper widget setValidTargetIndex: model selectionIndex."
	scrollW := builder wrapper decorator scrollerComponent.
	scrollW preferredBoundsBlock:
				[:sw | | rect |
				rect := sw component preferredBounds
						translatedBy: sw translation.
				rect height: maxLines*sw scrollGrid y.
				rect].

	font := builder wrapper widget textStyle defaultFont.
	font := Screen default defaultFontPolicy findFont: font.
	max := model list inject: 0 into: [:i :str | i max: str size].
		"Instead of exactly measuring every string, we
		assume that $o will be a fairly representative
		character.  Actually, $o will probably be wider
		than the average, but this will usually be OK."
	max := (font widthOf: $o) * max.

		"Don't let the dialog get too wide."
	fullMax := 350.
	max > fullMax
		ifTrue:
			[max := fullMax.
			builder wrapper decorator useHorizontalScrollBar.
			builder wrapper widget measureWidth: true].

	grid := builder wrapper preferredBounds height.
	layout bottomOffset: height+grid.
	self addGap: grid.
	self minWidth: max + 48.
	^builder wrapper! !

!SimpleDialog methodsFor: 'RefactoringBrowser'!

chooseMultiple: messageString fromList: list values: listValues buttons: buttons values: buttonValues lines: maxLines cancel: cancelBlock for: aVisualOrNil
	"Ask the user a question.  Let the user pick from a row of buttons made up
	to match the labels collection.  Return the response from the corresponding
	item from the values collection."

	"aVisualOrNil, if not nil, may be either a VisualPart or a
	ScheduledWindow.  It controls the look and feel and color choices
	used by the dialog, and supplies the dialog's master window, which
	is used by some window systems to create a visual connection between
	the dialog and the window that created it."

	"SimpleDialog new
		chooseMultiple: 'Which one do you want?'
		fromList: #('first' 'second' 'third' 'fourth') values: #(1 2 3 4)
		buttons: #() values: #()
		lines: 8
		cancel: [#noChoice]
		for: Dialog defaultParentWindow"

	| result spec okValue sequence wrappers listW |
	wrappers := OrderedCollection new.
	result := ValueHolder new.
	sequence := MultiSelectionInList new.
	sequence list: list.
	spec := (self class interfaceSpecFor: #emptySpec).
	okValue := Object new.
	self initializeBuilderFor: aVisualOrNil.
	builder add: spec window.
	builder add: spec component.
	self initializeWindowFor: aVisualOrNil.

	self setInitialGap.
	self addMessage: messageString centered: false.
	self addGap: 8.
	listW := self
			addMultiList: sequence
			lines: (maxLines min: list size+2)
			validation: [true].
	self addGap: 4.
	wrappers add: (self addOK: [sequence selectionIndex ~= 0]).
	buttons isEmpty
		ifFalse:
			[self addGap: 4.
			wrappers add: (self addDivider).
			self addGap: 4.
			wrappers add:
					(self addLabels: buttons
						values: buttonValues
						default: okValue
						storeInto: result
						takeKeyboard: true
						equalize: true)].
	self addGap: 6.
	self bottomAlignLowerEdge: listW.
	self bottomAlign: wrappers.

	self preOpen.
	builder openDialogWithExtent: builder window displayBox extent.
	^accept value
		ifTrue: [sequence selectionIndexes collect: [:each | listValues at: each]]
		ifFalse: [cancel value ifTrue: [cancelBlock value] ifFalse: [result value]]! !

CompositePart subclass: #OMTClassDiagram
	instanceVariableNames: 'classes navigator '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-OMT-Diagram'!

OMTClassDiagram comment:
'OMTClassDiagram is a VisualComponent that contains all the individual OMTClassView objects. It''s mainly used for laying out the classes.

Instance Variables:
	classes	<Collection of: Behavior>	which classes are being displayed
	navigator	<BrowserNavigator>	the navigator we''re connected to'!


!OMTClassDiagram methodsFor: 'initialize-release'!

classes: aCollection in: aNavigator
	classes := aCollection.
	navigator := aNavigator.
	self layoutClasses!

scrollOffsetHolder: aValueHolder 
	aValueHolder grid: 25 @ 25! !

!OMTClassDiagram methodsFor: 'private'!

findRootOfHierarchy
	^classes detect: [:each | (classes includes: each superclass) not]!

horizontalSpacing
	^10!

layout: rootClass at: aPoint 
	| subclasses xLocation rootClassView bounds top subclassPositions |
	subclasses := rootClass subclasses select: [:each | classes includes: each].
	rootClassView := OMTClassView viewFor: rootClass in: navigator.
	bounds := rootClassView preferredBounds translatedBy: aPoint.
	top := bounds bottom + self verticalSpacing.
	xLocation := aPoint x.
	subclassPositions := subclasses
				collect: 
					[:each | 
					| subclassBounds |
					subclassBounds := self layout: each at: xLocation @ top.
					bounds := bounds merge: subclassBounds.
					xLocation := bounds right + self horizontalSpacing.
					subclassBounds topCenter].
	rootClassView := (BorderedWrapper on: rootClassView at: bounds extent x - rootClassView preferredBounds extent x // 2 @ 0 + aPoint)
				border: BeveledBorder raised; yourself.
	self add: rootClassView.
	subclasses isEmpty ifFalse: [self subclassLinesAt: rootClassView preferredBounds bottomCenter to: subclassPositions].
	^bounds!

layoutClasses
	| rootClass |
	rootClass := self findRootOfHierarchy.
	self layout: rootClass at: self horizontalSpacing @ 10!

subclassLinesAt: aPoint to: pointCollection 
	| vertices interval bottom |
	bottom := aPoint y + 28.
	vertices := Array new: 5.
	vertices at: 1 put: aPoint.
	vertices at: 5 put: (vertices at: 2 put: aPoint + (0 @ 13)).
	vertices at: 3 put: aPoint x + 15 @ bottom.
	vertices at: 4 put: aPoint x - 15 @ bottom.
	self add: (StrokingWrapper on: (Polyline vertices: vertices)).
	pointCollection do: [:each | self add: (StrokingWrapper on: (LineSegment from: each to: each x @ bottom))].
	interval := pointCollection inject: (aPoint x to: aPoint x)
				into: [:int :each | (int first min: each x)
						to: (int last max: each x)].
	(aPoint x - 13 > interval first or: [aPoint x + 13 < interval last])
		ifTrue: [self add: (StrokingWrapper on: (LineSegment from: interval first @ bottom to: interval last @ bottom))]!

verticalSpacing
	^50! !

OMTClassDiagram class
	instanceVariableNames: ''!



!OMTClassDiagram class methodsFor: 'instance creation'!

classes: aCollection in: aBrowser
	^self new classes: aCollection in: aBrowser! !

!BrowserEnvironment methodsFor: 'accessing'!

editor
	^RefactoringBrowser onEnvironment: self!

navigatorClass
	^SystemNavigator!

openEditor
	^RefactoringBrowser openOnEnvironment: self!

selectionIntervalFor: aString 
	| interval |
	self searchStrings isEmpty ifTrue: [^nil].
	interval := self selectionParseTreeIntervalFor: aString.
	interval notNil ifTrue: [^interval].
	self searchStrings do: 
			[:each | 
			| search index |
			search := each isSymbol ifTrue: [each keywords first] ifFalse: [each].
			index := aString indexOfSubCollection: search startingAt: 1.
			index > 0 ifTrue: [^index to: index + search size - 1]].
	^nil!

selectionParseTreeIntervalFor: aString 
	| parseTree answerBlock |
	parseTree := BRParser parseMethod: aString onError: [:str :pos | ^nil].
	answerBlock := [:aNode :answer | ^aNode sourceInterval].
	self searchStrings do: 
			[:each | 
			| matcher tree |
			matcher := ParseTreeSearcher new.
			each isSymbol 
				ifTrue: 
					[matcher matchesTree: (BRLiteralNode value: each) do: answerBlock.
					tree := ParseTreeSearcher buildSelectorTree: each.
					tree notNil ifTrue: [matcher matchesTree: tree do: answerBlock]]
				ifFalse: 
					[tree := BRVariableNode named: each.
					matcher
						matchesTree: tree do: answerBlock;
						matchesArgumentTree: tree do: answerBlock].
			matcher executeTree: parseTree].
	^nil!

superclassOrder: category
	"Answer an ordered collection containing the classes in category (a string).
	The classes are ordered with superclasses first so they can be filed in."

	| list |
	list := (self classNamesFor: category asSymbol)
				collect: [:title | self at: title].
	^SystemUtils sortForLoading: list! !

ControllerWithMenu subclass: #OMTClassController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-OMT-Diagram'!

OMTClassController comment:
'OMTClassController is the controller for the OMTClassView. It both passes input down to its subwidgets, and processes input outside of its subwidgets.'!


!OMTClassController methodsFor: 'private'!

controlActivity
	self controlToNextLevel.
	super controlActivity! !

OMTClassController class
	instanceVariableNames: ''!


Object subclass: #CodeModelLockPolicy
	instanceVariableNames: ''
	classVariableNames: 'WindowHandleCache '
	poolDictionaries: ''
	category: 'Refactory-Browser'!

CodeModelLockPolicy comment:
'CodeModelLockPolicy is an abstract class. It defines the protocol that CodeModels use to check to see if it is locked. The implementation of this class is for a tool that is always unlocked.'!


!CodeModelLockPolicy methodsFor: 'initialize-release'!

initialize!

on: aCodeTool! !

!CodeModelLockPolicy methodsFor: 'accessing'!

isLocked
	^false!

lock!

unlock! !

CodeModelLockPolicy class
	instanceVariableNames: ''!



!CodeModelLockPolicy class methodsFor: 'instance creation'!

on: aCodeTool
	^(self new) initialize; on: aCodeTool; yourself! !

!CodeModelLockPolicy class methodsFor: 'accessing'!

flushCache
	WindowHandleCache := nil! !


!SimpleDialog methodsFor: 'Refactoring Browser'!

chooseMultiple: messageString fromList: list values: listValues buttons: buttons values: buttonValues lines: maxLines cancel: cancelBlock 
	^self
		chooseMultiple: messageString
		fromList: list
		values: listValues
		buttons: buttons
		values: buttonValues
		lines: maxLines
		cancel: cancelBlock
		for: nil! !

BrowserDialog subclass: #CategoryDialog
	instanceVariableNames: 'categoryList nameHolder organizer '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!



!CategoryDialog methodsFor: 'initialize-release'!

initialize
	super initialize.
	self categoryList selectionIndexHolder onChangeSend: #changedSelection to: self.
	self nameHolder onChangeSend: #changedName to: self!

organizer: aClassOrganizer 
	organizer := aClassOrganizer.
	self categoryList list: organizer categories asList! !

!CategoryDialog methodsFor: 'accessing'!

categoryName
	^self categoryList selection!

currentCategory: aCategoryName 
	self categoryList selection: aCategoryName! !

!CategoryDialog methodsFor: 'actions'!

addCategory
	| category index |
	category := self nameHolder value asSymbol.
	organizer addCategory: category before: self categoryList selection.
	index := self categoryList selectionIndex.
	index == 0
		ifTrue: [self categoryList list add: category]
		ifFalse: [self categoryList list add: category beforeIndex: index].
	self categoryList selection: category!

down
	| list index |
	list := self categoryList list.
	index := self categoryList selectionIndex.
	organizer addCategory: (list at: index + 1)
		before: (list at: index).
	list swap: index with: index + 1.
	self categoryList selectionIndex: index + 1!

up
	| list index |
	list := self categoryList list.
	index := self categoryList selectionIndex.
	organizer addCategory: (list at: index)
		before: (list at: index - 1).
	list swap: index with: index - 1.
	self categoryList selectionIndex: index - 1! !

!CategoryDialog methodsFor: 'aspects'!

categoryList
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^categoryList isNil
		ifTrue:
			[categoryList := SelectionInList new]
		ifFalse:
			[categoryList]!

nameHolder
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^nameHolder isNil
		ifTrue:
			[nameHolder := String new asValue]
		ifFalse:
			[nameHolder]! !

!CategoryDialog methodsFor: 'changing'!

changedName
	self nameHolder value isEmpty
		ifTrue: [self disable: #addCategory]
		ifFalse: [self enable: #addCategory]!

changedSelection
	| index |
	index := self categoryList selectionIndex.
	index > 1
		ifTrue: [self enable: #up]
		ifFalse: [self disable: #up].
	index < self categoryList list size & (index > 0)
		ifTrue: [self enable: #down]
		ifFalse: [self disable: #down].
	index > 0
		ifTrue: [self enable: #accept]
		ifFalse: [self disable: #accept]! !

!CategoryDialog methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	self changedSelection.
	self changedName!

postOpenWith: aBuilder 
	super postOpenWith: aBuilder.

	"Reset the selection so that the list will scroll to the selected entry."
	self categoryList selection: self categoryList selection! !

CategoryDialog class
	instanceVariableNames: ''!



!CategoryDialog class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Category Dialog' 
			#bounds: #(#Rectangle 359 339 654 591 ) 
			#isEventDriven: true ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0 5 0 -55 1 -75 1 ) 
					#name: #categoryList 
					#model: #categoryList 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 5 0 -5 1 50 0 ) 
					#name: #up 
					#isOpaque: true 
					#model: #up 
					#label: #upImage 
					#hasCharacterOrientedLabel: false ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 -120 1 -5 1 -75 1 ) 
					#name: #down 
					#isOpaque: true 
					#model: #down 
					#label: #downImage 
					#hasCharacterOrientedLabel: false ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 5 0 -70 1 -55 1 -40 1 ) 
					#name: #nameHolder 
					#model: #nameHolder ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -50 1 -70 1 -5 1 -40 1 ) 
					#name: #addCategory 
					#flags: 40 
					#model: #addCategory 
					#label: 'Add' ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -5 1 0.5 1 ) 
					#name: #accept 
					#flags: 40 
					#model: #accept 
					#label: 'OK' ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -5 1 0.5 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' ) 
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 -36 1 0 1 -34 1 ) ) ) ) )! !


!LimitedEnvironment methodsFor: 'accessing'!

selectionIntervalFor: aString 
	| interval |
	interval := super selectionIntervalFor: aString.
	^interval notNil 
		ifTrue: [interval]
		ifFalse: [environment selectionIntervalFor: aString]! !


!ProtocolEnvironment methodsFor: 'accessing'!

navigatorClass
	^BrowserNavigator! !


!ClassEnvironment methodsFor: 'accessing'!

navigatorClass
	^self categories size = 1
		ifTrue: [BrowserNavigator]
		ifFalse: [SystemNavigator]! !

CompositeView subclass: #OMTClassView
	instanceVariableNames: 'extent '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-OMT-Diagram'!

OMTClassView comment:
'OMTClassView is the view that displays a class in the OMT diagram.

Instance Variables:
	extent	<Point>	our extent - based on the class name length'!


!OMTClassView methodsFor: 'bounds accessing'!

preferredBounds
	^0 @ 0 corner: extent! !

!OMTClassView methodsFor: 'control defaults'!

subViewWantingControl
	"Answer the subcomponent of the receiver that wants control."

	^self componentWantingControl! !

!OMTClassView methodsFor: 'controller accessing'!

defaultControllerClass
	^OMTClassController! !

!OMTClassView methodsFor: 'private'!

extent: aPoint
	extent := aPoint! !

OMTClassView class
	instanceVariableNames: ''!



!OMTClassView class methodsFor: 'defaults'!

height
	^140!

minWidth
	^100! !

!OMTClassView class methodsFor: 'instance creation'!

viewFor: aClass in: aBrowser
	| model view instVarView methodView label offsetBlock textHeightBlock |
	model := OMTClassModel new on: aClass in: aBrowser.
	view := self model: model.
	(view controller) menuHolder: model classMenuHolder; performer: model.
	label := model name asText allBold asComposedText.
	offsetBlock := [model name asText allBold asComposedText width // 2].
	textHeightBlock := [model name asText allBold asComposedText height].
	view add: label in: ((LayoutFrame new) leftFraction: 0.5 offset: [offsetBlock value negated]; topOffset: 0; rightFraction: 0.5 offset: offsetBlock; bottomOffset: textHeightBlock; yourself).
	instVarView := SequenceView new.
	instVarView optimizeForText.
	instVarView model: model instVarListHolder listHolder.
	instVarView selectionChannel: model instVarListHolder selectionIndexHolder.
	instVarView controller menuHolder: model instVarMenuHolder.
	instVarView controller performer: model.
	view add: (LookPreferences edgeDecorator on: instVarView)
		in: ((LayoutFrame new) leftOffset: 2; topOffset: [textHeightBlock value]; rightFraction: 1 offset: -2; bottomFraction: 0.5 offset: [textHeightBlock value // 2]; yourself).
	methodView := SequenceView new.
	methodView optimizeForText.
	methodView model: model methodListHolder listHolder.
	methodView selectionChannel: model methodListHolder selectionIndexHolder.
	methodView controller menuHolder: model methodMenuHolder.
	methodView controller performer: model.
	view add: (LookPreferences edgeDecorator on: methodView)
		in: ((LayoutFrame new) leftOffset: 2; topFraction: 0.5 offset: [textHeightBlock value // 2 + 2]; rightFraction: 1 offset: -2; bottomFraction: 1 offset: -2; yourself).
	view extent: (aClass name asText allBold asComposedText width + 4 max: self minWidth)
			@ self height.
	^view! !


!AndEnvironment methodsFor: 'accessing'!

navigatorClass
	environment navigatorClass == ClassSelectorNavigator 
		ifTrue: [^ClassSelectorNavigator].
	andedEnvironment navigatorClass == ClassSelectorNavigator 
		ifTrue: [^ClassSelectorNavigator].
	^super navigatorClass!

selectionIntervalFor: aString 
	| interval |
	interval := super selectionIntervalFor: aString.
	interval notNil ifTrue: [^interval].
	^andedEnvironment selectionIntervalFor: aString! !

CodeModelLockPolicy subclass: #StateLockPolicy
	instanceVariableNames: 'locked '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!

StateLockPolicy comment:
'StateLockPolicy is a CodeModelLockPolicy that has an explicit locked/unlocked state. The (un)locked state can be set by using lock and unlock methods.

Instance Variables:
	locked	<Boolean>	contains true if the model is locked and shouldn''t be updated'!


!StateLockPolicy methodsFor: 'initialize-release'!

initialize
	super initialize.
	locked := false! !

!StateLockPolicy methodsFor: 'accessing'!

isLocked
	^locked!

lock
	locked := true!

unlock
	locked := false! !

StateLockPolicy class
	instanceVariableNames: ''!


Model subclass: #OMTClassModel
	instanceVariableNames: 'class instVarNames methods classMenuHolder instVarMenuHolder methodMenuHolder navigator '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-OMT-Diagram'!

OMTClassModel comment:
'OMTClassModel is the model for the OMTClassView.

Instance Variables:
	class	<Behavior>	the class we''re for
	classMenuHolder	<ValueHolder on: Menu>	the menu for the class
	instVarMenuHolder	<ValueHolder on: Menu>	the menu for the inst var list
	instVarNames	<SelectionInList on: String>	the list of inst var names
	methodMenuHolder	<ValueHolder on: Menu>	the menu for the methods
	methods	<SelectionInList on: Symbol>	the list of selectors
	navigator	<Navigator>	the navigator we''re associated with'!


!OMTClassModel methodsFor: 'initialize-release'!

on: aClass in: aNavigator
	navigator := aNavigator.
	class := aClass.
	instVarNames := SelectionInList new.
	methods := SelectionInList new.
	self updateInstVars.
	self updateMethods.
	instVarNames selectionIndexHolder onChangeSend: #changedInstVar to: self.
	methods selectionIndexHolder onChangeSend: #changedMethod to: self! !

!OMTClassModel methodsFor: 'accessing'!

environment
	^navigator environment!

instVarListHolder
	^instVarNames!

methodListHolder
	^methods!

name
	^class name!

navigator
	^navigator! !

!OMTClassModel methodsFor: 'actions-methods'!

implementors
	self navigator browseImplementorsOf: methods selection!

removeMethod
	self navigator removeMethodsSafe: (Array with: methods selection) from: class.
	self updateMethods!

renameMethod
	self navigator renameMethod: methods selection in: class.
	self updateMethods!

senders
	self navigator browseReferencesTo: methods selection! !

!OMTClassModel methodsFor: 'actions-instVars'!

abstractInstVar
	self navigator abstractInstVar: instVarNames selection in: class!

addInstVar
	self navigator addInstVarIn: class.
	self updateInstVars!

convertInstVarToValueHolder
	self navigator valueHolderForInstVar: instVarNames selection in: class!

instVarRefs
	| instVarName |
	instVarName := instVarNames selection.
	self navigator browseInstVarRefsTo: instVarName in: class!

removeInstVar
	self navigator removeInstVar: instVarNames selection fromClass: class.
	self updateInstVars!

renameInstVar
	self navigator renameInstVar: instVarNames selection in: class.
	self updateInstVars! !

!OMTClassModel methodsFor: 'actions-class'!

classRefs
	self navigator browseReferencesTo: (Smalltalk associationAt: self nonMetaClass name ifAbsent: [^self])!

removeClass
	self navigator removeClassesSafe: (Array with: self nonMetaClass)!

renameClass
	self navigator renameClass: self nonMetaClass! !

!OMTClassModel methodsFor: 'menu'!

classMenuHolder
	classMenuHolder isNil ifTrue: [classMenuHolder := self class classMenu asValue].
	^classMenuHolder!

instVarMenuHolder
	instVarMenuHolder isNil
		ifTrue:
			[instVarMenuHolder := nil asValue.
			self changedInstVar].
	^instVarMenuHolder!

methodMenuHolder
	methodMenuHolder isNil
		ifTrue:
			[methodMenuHolder := nil asValue.
			self changedMethod].
	^methodMenuHolder! !

!OMTClassModel methodsFor: 'change'!

changedInstVar
	instVarMenuHolder value: (instVarNames selection isNil
			ifTrue: [self class noInstVarMenu]
			ifFalse: [self class instVarMenu])!

changedMethod
	methodMenuHolder value: (methods selection isNil
			ifTrue: [nil]
			ifFalse: [self class methodMenu])!

updateInstVars
	| oldName |
	oldName := instVarNames selection.
	instVarNames list: (List withAll: class instVarNames asSortedCollection).
	instVarNames selection: oldName!

updateMethods
	| oldSelector |
	oldSelector := methods selection.
	methods list: (List withAll: (self environment selectorsForClass: class) asSortedCollection).
	methods selection: oldSelector! !

!OMTClassModel methodsFor: 'private-class functions'!

nonMetaClass
	^class isMeta
		ifTrue: [class soleInstance]
		ifFalse: [class]! !

OMTClassModel class
	instanceVariableNames: ''!



!OMTClassModel class methodsFor: 'resources'!

classMenu
	"UIMenuEditor new openOnClass: self andSelector: #classMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem
				#label: 'references...' )
			#(#MenuItem
				#label: 'rename as...' )
			#(#MenuItem
				#label: 'remove...' ) ) #(1 2 ) #(#classRefs #renameClass #removeClass ) ) decodeAsLiteralArray!

instVarMenu
	"UIMenuEditor new openOnClass: self andSelector: #instVarMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'references...' ) 
			#(#MenuItem 
				#label: 'add...' ) 
			#(#MenuItem 
				#label: 'rename as...' ) 
			#(#MenuItem 
				#label: 'remove...' ) 
			#(#MenuItem 
				#label: 'refactorings' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#label: 'abstract' ) 
						#(#MenuItem 
							#label: 'convert to value holder' ) ) #(2 ) #(#abstractInstVar #convertInstVarToValueHolder ) ) ) ) #(1 3 1 ) #(#instVarRefs #addInstVar #renameInstVar #removeInstVar nil ) ) decodeAsLiteralArray!

menu
	"UIMenuEditor new openOnClass: self andSelector: #menu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem
				#label: 'senders...' )
			#(#MenuItem
				#label: 'implementors...' )
			#(#MenuItem
				#label: 'rename as...' )
			#(#MenuItem
				#label: 'remove...' ) ) #(2 2 ) #(#senders #implementors #renameMethod #removeMethod ) ) decodeAsLiteralArray!

methodMenu
	"UIMenuEditor new openOnClass: self andSelector: #methodMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#label: 'senders' ) 
			#(#MenuItem 
				#label: 'implementors...' ) 
			#(#MenuItem 
				#label: 'rename as...' ) 
			#(#MenuItem 
				#label: 'remove...' ) ) #(2 2 ) #(#senders #implementors #renameMethod #removeMethod ) ) decodeAsLiteralArray!

noInstVarMenu
	"UIMenuEditor new openOnClass: self andSelector: #noInstVarMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem
				#label: 'add...' ) ) #(1 ) #(#addInstVar ) ) decodeAsLiteralArray! !


!RestrictedEnvironment methodsFor: 'accessing'!

navigatorClass
	^self numberSelectors = 1
		ifTrue: [BrowserNavigator]
		ifFalse: [ClassSelectorNavigator]! !


!BrowserApplicationModel methodsFor: 'error handling'!

handleError: aBlock 
	^Refactoring preconditionSignal handle: 
			[:ex | 
			ex willProceed 
				ifTrue: 
					[(Dialog confirm: (ex errorString last == $? 
								ifTrue: [ex errorString]
								ifFalse: [ex errorString , '\Do you want to proceed?' withCRs])) 
						ifTrue: [ex proceed]]
				ifFalse: 
					[ex parameter notNil 
						ifTrue: [(Dialog confirm: ex errorString) ifTrue: [ex parameter value]]
						ifFalse: [Dialog warn: ex errorString]].
			ex returnWith: nil]
		do: [self showWaitCursorWhile: aBlock]! !

BrowserApplicationModel subclass: #RefactoringBrowser
	instanceVariableNames: 'navigator tools environment currentBuffer policyClass horizontal '
	classVariableNames: 'PatchLevel Version '
	poolDictionaries: ''
	category: 'Refactory-Browser'!

RefactoringBrowser comment:
'RefactoringBrowser is the glue for the browser application. It''s main responsibility is maintaining the buffers for the different code tools.

Instance Variables:

	navigator	<Navigator>	the navigator that displays the environment
	tools	<SequenceableCollection of: CodeModel>	the buffers for all the different code tools
	environment	<BrowserEnvironment>	contains the items that we are browsing
	currentBuffer	<ValueHolder on: CodeModel>	the current buffer that is being displayed by the browser. For multi-window applications, this value is not-updated.
	policyClass	<CodeModelLockPolicy class>	the class of the lock policy for this browser (state or window)
	horizontal	<Boolean>	are we displaying a horizontal navigator'!


!RefactoringBrowser methodsFor: 'initialize-release'!

initializeOnEnvironment: anEnvironment
	policyClass := StateLockPolicy.
	tools := OrderedCollection new.
	self environment: anEnvironment.
	currentBuffer := (CodeModel navigator: navigator) asValue.
	currentBuffer value lockPolicyClass: policyClass.
	tools add: currentBuffer value.
	horizontal := true!

release
	navigator release.
	tools do: [:each | each release].
	super release! !

!RefactoringBrowser methodsFor: 'accessing'!

beHorizontal
	horizontal := true!

beVertical
	horizontal := false!

codeTool
	^self currentTool!

currentTool
	^self currentBuffer value!

environment
	^environment!

environment: anEnvironment 
	environment := anEnvironment.
	environment navigatorClass == navigator class ifTrue: [^self].
	navigator release.
	navigator := environment navigatorClass on: self.
	tools do: [:each | each navigator: navigator]!

navigator
	^navigator!

policyClass: aLockPolicyClass
	policyClass := aLockPolicyClass.
	tools do: [:each | each lockPolicyClass: policyClass]!

preferredSpec
	^self class browserType! !

!RefactoringBrowser methodsFor: 'browsing'!

browseGlobals
	| searchString association |
	searchString := self request: 'Enter a class or global:'.
	(searchString isNil or: [searchString isEmpty]) ifTrue: [^self].
	searchString := searchString asSymbol.
	association := Smalltalk associationAt: searchString
				ifAbsent: [self findPoolAssociationFor: searchString].
	association isNil ifTrue: [^self].
	self navigator browseReferencesTo: association!

browseImplementors
	| searchString |
	searchString := Dialog request: 'Enter a method name:'.
	searchString isEmpty ifTrue: [^self].
	Cursor wait showWhile: 
			[self class
				openOnEnvironment: (self environment implementorsMatching: searchString)]!

browseStringMatches
	| searchString |
	searchString := Dialog request: 'Enter a string search for ("*browser*"):'.
	(searchString isNil or: [searchString isEmpty])
		ifTrue: [^self].
	Cursor wait showWhile: [self class openOnEnvironment: (self environment matches: searchString)]!

browseSymbols
	| searchString |
	searchString := Dialog request: 'Enter a symbol:'.
	(searchString isNil or: [searchString isEmpty])
		ifTrue: [^self].
	self navigator browseReferencesTo: searchString asSymbol!

browseVariables
	Cursor wait
		showWhile: 
			[| searchString env |
			searchString := Dialog request: 'Enter variable to search for ("*browser*"):'.
			(searchString isNil or: [searchString isEmpty])
				ifTrue: [^self].
			env := RestrictedEnvironment onEnvironment: self environment.
			Smalltalk
				allBehaviorsDo: 
					[:each | 
					(each instVarNames contains: [:name | searchString match: name])
						ifTrue: [env addClass: each].
					(each classVarNames contains: [:name | searchString match: name])
						ifTrue: [env addClass: each; addClass: each class]].
			self class openOnEnvironment: env]! !

!RefactoringBrowser methodsFor: 'actions'!

findAllReferencePaths
	| block |
	block := self promptForReferencePathBlock.
	block isNil ifTrue: [^self].
	self showWaitCursorWhile: 
			[| paths |
			paths := ReferenceFinder new findAllPaths: block.
			paths isEmpty 
				ifTrue: [self warn: 'No paths found']
				ifFalse: [paths inspect]]!

findReferencePath
	| block |
	block := self promptForReferencePathBlock.
	block isNil ifTrue: [^self].
	self showWaitCursorWhile: 
			[| path |
			path := ReferenceFinder new findPath: block.
			path notNil ifTrue: [path inspect] ifFalse: [self warn: 'No paths found']]!

navigatorSelectBuffer
	| buffer |
	buffer := Dialog
				choose: 'Select buffer'
				fromList: tools
				values: tools
				lines: 5
				cancel: [nil].
	buffer notNil ifTrue: [buffer bringWindowToTop]!

newBuffer
	| newBuffer |
	newBuffer := CodeModel navigator: navigator.
	newBuffer lockPolicyClass: policyClass.
	tools add: newBuffer.
	self bufferChangeRequest.
	currentBuffer value: newBuffer.
	self changedBuffer.
	currentBuffer value tool updateContents.
	self enable: #removeBuffer!

newWindow
	| newBuffer |
	newBuffer := CodeModel navigator: navigator.
	newBuffer lockPolicyClass: policyClass.
	tools add: newBuffer.
	newBuffer open.
	newBuffer tool updateContents!

removeBuffer
	currentBuffer value updateRequest ifFalse: [^self].
	tools remove: currentBuffer value.
	currentBuffer value release.
	currentBuffer value: tools first.
	self changedBuffer.
	tools size == 1 ifTrue: [self disable: #removeBuffer]!

selectBuffer
	| buffer |
	buffer := Dialog
				choose: 'Select buffer'
				fromList: tools
				values: tools
				lines: 5
				cancel: [nil].
	buffer isNil ifTrue: [^self].
	currentBuffer value: buffer.
	self changedBuffer!

spawnBrowser
	| newBrowser |
	newBrowser := self class openOnEnvironment: self environment.
	(newBrowser navigator) setState: self navigator getState; changedCategory.
	self navigator isHierarchy ifTrue: [newBrowser navigator beHierarchy]! !

!RefactoringBrowser methodsFor: 'aspects'!

currentBuffer
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^currentBuffer isNil
		ifTrue:
			[currentBuffer := nil asValue]
		ifFalse:
			[currentBuffer]! !

!RefactoringBrowser methodsFor: 'events'!

noticeOfWindowClose: aWindow
	navigator closed.
	self release.
	^super noticeOfWindowClose: aWindow!

requestForWindowClose
	^super requestForWindowClose and: 
			[builder isNil or: 
					[builder window isOpen not or: 
							[(tools inject: true
								into: [:bool :each | bool and: [each isLocked not or: [each isEditing not]]])
									or: [Dialog confirm: 'Modified buffered exists.\Exit anyway?' withCRs]]]]!

windowEvent: anEvent from: aWindow 
	super windowEvent: anEvent from: aWindow.
	(anEvent key == #newGraphicsDevice or: [anEvent key == #reopen])
		ifTrue: [self reInstallInterface]! !

!RefactoringBrowser methodsFor: 'changing'!

changeRequest
	"The receiver wants to change; check with all dependents that it is OK."

	^super changeRequest and: [navigator changeRequest]! !

!RefactoringBrowser methodsFor: 'interface opening'!

openInterface
	self openInterface: self class browserType.
	self class isMultiWindow ifTrue: [self newWindow].
	^builder!

postOpenWith: aBuilder
	| envPrintString |
	envPrintString := self environment printString.
	aBuilder window label: 'Browser - ' , (envPrintString copyFrom: 1 to: (self maxLabelLength min: envPrintString size)).
	builder window application: self.
	builder window sendWindowEvents: #(#newGraphicsDevice #reopen).
	^super postOpenWith: aBuilder!

preBuildWith: aBuilder 
	| spec |
	spec := navigator spec: self isHorizontal not.
	aBuilder
		subCanvasAt: #NavigatorTool
		at: #windowSpec
		put: spec.
	^super preBuildWith: aBuilder! !

!RefactoringBrowser methodsFor: 'menu'!

bufferMenu
	| menu removeItem interval groupItems groupValues |
	menu := Menu new.
	menu addItemLabel: '&Create buffer' value: #newBuffer.
	removeItem := MenuItem labeled: '&Remove buffer'.
	tools size = 1 ifTrue: [removeItem disable].
	menu addItem: removeItem value: #removeBuffer.
	menu addItemGroup: (Array with: (MenuItem labeled: '&Spawn browser'))
		values: #(#spawnBrowser).
	interval := 1 to: (tools size min: 9).
	groupItems := interval
				collect: 
					[:i | 
					| item |
					item := MenuItem labeled: '&' , i printString , ' ' , (tools at: i) printString.
					(tools at: i)
						== currentBuffer value
						ifTrue: [item beOn]
						ifFalse: [item beOff].
					item].
	groupValues := interval collect: [:i | 
				[currentBuffer value: (tools at: i).
				self changedBuffer]].
	tools size > 9
		ifTrue: 
			[groupItems := groupItems copyWith: (MenuItem labeled: '&More buffers...').
			groupValues := groupValues copyWith: #selectBuffer].
	menu addItemGroup: groupItems values: groupValues.
	^menu!

menu
	^[self menuBar]!

menuBar
	^(Menu new)
		addItem: ((MenuItem labeled: '&Buffers') submenu: [self bufferMenu]);
		addItem: ((MenuItem labeled: 'B&rowse') submenu: [self class browseMenu]);
		addItem: ((MenuItem labeled: '&Operations') submenu: [self operationsMenu]);
		addItem: ((MenuItem labeled: 'Ca&tegory') submenu: navigator categoryMenu);
		addItem: ((MenuItem labeled: '&Class') submenu: navigator classMenu);
		addItem: ((MenuItem labeled: '&Protocol') submenu: navigator protocolMenu);
		addItem: ((MenuItem labeled: '&Selector') submenu: navigator selectorMenu);
		addItem: ((MenuItem labeled: 'Too&l') 
					submenu: [currentBuffer value menu value]);
		yourself!

navigatorBufferMenu
	| menu interval groupItems groupValues obsoleteTools |
	menu := Menu new.
	menu addItemLabel: '&Create window' value: #newWindow.
	obsoleteTools := tools reject: [:each | each builder notNil and: [each builder window isOpen]].
	obsoleteTools do: [:each | each release].
	tools removeAll: obsoleteTools.
	interval := 1 to: (tools size min: 9).
	groupItems := interval collect: [:i | MenuItem labeled: ('&<1p> <2p>' expandMacrosWith: i with: (tools at: i))].
	groupValues := interval collect: [:i | [(tools at: i) bringWindowToTop]].
	tools size > 9
		ifTrue: 
			[groupItems := groupItems copyWith: (MenuItem labeled: '&More buffers...').
			groupValues := groupValues copyWith: #navigatorSelectBuffer].
	menu addItemGroup: groupItems values: groupValues.
	^menu!

navigatorMenuBar
	^(Menu new)
		addItem: ((MenuItem labeled: '&Buffers') submenu: [self navigatorBufferMenu]);
		addItem: ((MenuItem labeled: 'B&rowse') submenu: [self class browseMenu]);
		addItem: ((MenuItem labeled: '&Operations') submenu: [self operationsMenu]);
		addItem: ((MenuItem labeled: 'Ca&tegory') submenu: navigator categoryMenu);
		addItem: ((MenuItem labeled: '&Class') submenu: navigator classMenu);
		addItem: ((MenuItem labeled: '&Protocol') submenu: navigator protocolMenu);
		addItem: ((MenuItem labeled: '&Selector') submenu: navigator selectorMenu);
		yourself!

operationsMenu
	| manager item menu |
	manager := RefactoringManager instance.
	menu := Menu new.
	item := MenuItem labeled: (manager hasUndoableOperations 
						ifTrue: ['&Undo ' , manager undoChange name]
						ifFalse: ['&Undo']).
	menu addItem: item
		value: 
			[self changeRequest 
				ifTrue: 
					[manager undoOperation.
					navigator updateCategoryList]].
	item := MenuItem labeled: (manager hasRedoableOperations 
						ifTrue: ['&Redo ' , manager redoChange name]
						ifFalse: ['&Redo']).
	menu addItem: item
		value: 
			[self changeRequest 
				ifTrue: 
					[manager redoOperation.
					navigator updateCategoryList]].
	manager hasUndoableOperations ifFalse: [(menu menuItemAt: 1) disable].
	manager hasRedoableOperations ifFalse: [(menu menuItemAt: 2) disable].
	^menu! !

!RefactoringBrowser methodsFor: 'testing'!

isHorizontal
	^horizontal! !

!RefactoringBrowser methodsFor: 'private'!

bufferChangeRequest
	currentBuffer value state: navigator getState.
	^true!

changedBuffer
	| buffer |
	buffer := currentBuffer value.
	buffer isNil ifTrue: [^self].
	tools do: [:each | each lock].
	buffer unlock.
	buffer resetBuilder.
	self installSubcanvasIn: #codeTool using: buffer.
	buffer tool updateDisplay!

findPoolAssociationFor: aSymbol 
	| pools poolName |
	pools := OrderedCollection new.
	Smalltalk associationsDo: 
			[:assoc | 
			((assoc value isKindOf: Dictionary) 
				and: [assoc value includesKey: aSymbol]) ifTrue: [pools add: assoc key]].
	pools isEmpty 
		ifTrue: 
			[self warn: ('No variables named, <1s>, were found' expandMacrosWith: aSymbol).
			^nil].
	poolName := pools size = 1 
				ifTrue: [pools first]
				ifFalse: 
					[self 
						choose: 'The variable is defined in multiple pools.<n>Which reference do you want?' 
								expandMacros
						fromList: pools
						values: pools
						lines: 5
						cancel: [^nil]].
	^(Smalltalk at: poolName) associationAt: aSymbol!

maxLabelLength
	^40!

prompt: promptString initially: initialString 
	^Dialog request: ('<1s><n>the accept or CR' expandMacrosWith: promptString)
		initialAnswer: initialString
		for: self interfaceWindow!

promptForReferencePathBlock
	| source block |
	source := self request: 'Find what?'
				initialAnswer: '[:each | each == 10000]'.
	source isEmpty ifTrue: [^nil].
	block := self class compilerClass evaluate: source.
	(block respondsTo: #value:) 
		ifFalse: 
			[self warn: 'Source did not evaluate to a block'.
			^nil].
	^block!

reInstallInterface
"	| spec window |
	window := builder window.
	self resetBuilder.
	window component release.
	currentBuffer value on: navigator.
	builder := UIBuilder new.
	builder setWindow: window.
	builder source: self.
	spec := self class interfaceSpecFor: #windowSpec.
	self preBuildWith: builder.
	builder add: spec.
	self postBuildWith: builder.
	builder doFinalHookup.
	self postOpenWith: builder.
	^builder"! !

RefactoringBrowser class
	instanceVariableNames: 'horizontal multiWindow '!



!RefactoringBrowser class methodsFor: 'class initialization'!

initialize
	horizontal := true.
	multiWindow := false.
	self version: 3.0.
	self patchLevel: 0! !

!RefactoringBrowser class methodsFor: 'instance creation'!

onEnvironment: anEnvironment 
	| browser |
	browser := self new.
	browser initializeOnEnvironment: anEnvironment.
	horizontal
		ifTrue: [browser beHorizontal]
		ifFalse: [browser beVertical].
	browser policyClass: StateLockPolicy.
	^browser! !

!RefactoringBrowser class methodsFor: 'interface specs'!

horizontalNavigator
	"UIPainter new openOnClass: self andSelector: #horizontalNavigator"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'System Browser'
			#min: #(#Point 527 139 )
			#bounds: #(#Rectangle 205 272 828 411 )
			#flags: 4
			#menu: #navigatorMenuBar )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 )
					#name: #navigator
					#flags: 0
					#majorKey: #NavigatorTool
					#minorKey: #windowSpec
					#clientKey: #navigator ) ) ) )!

verticalNavigator
	"UIPainter new openOnClass: self andSelector: #verticalNavigator"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'System Browser'
			#min: #(#Point 40 20 )
			#bounds: #(#Rectangle 300 224 468 676 )
			#flags: 4
			#menu: #navigatorMenuBar )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 )
					#name: #navigator
					#flags: 0
					#majorKey: #NavigatorTool
					#minorKey: #windowSpec
					#clientKey: #navigator ) ) ) )!

verticalWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalWindowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'System Browser'
			#min: #(#Point 470 314 )
			#bounds: #(#Rectangle 165 181 798 661 )
			#flags: 4
			#menu: #menuBar )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 0.25 0 1 )
					#name: #navigator
					#flags: 0
					#majorKey: #NavigatorTool
					#minorKey: #windowSpec
					#clientKey: #navigator )
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 3 0.25 2 0 -2 1 -2 1 )
					#name: #codeTool
					#flags: 0
					#majorKey: #CodeModel
					#minorKey: #windowSpec
					#clientKey: #codeTool )
				#(#DividerSpec
					#layout: #(#LayoutFrame 0 0.25 0 0 2 0.25 0 1 )
					#orientation: #vertical ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'System Browser'
			#min: #(#Point 472 312 )
			#bounds: #(#Rectangle 130 222 763 702 )
			#flags: 4
			#menu: #menuBar )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -1 0.333333 )
					#name: #navigator
					#flags: 0
					#majorKey: #NavigatorTool
					#minorKey: #windowSpec
					#clientKey: #navigator )
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 2 0 2 0.333333 -2 1 -2 1 )
					#name: #codeTool
					#flags: 0
					#majorKey: #CodeModel
					#minorKey: #windowSpec
					#clientKey: #codeTool )
				#(#DividerSpec
					#layout: #(#LayoutFrame 0 0 -1 0.333333 0 1 0 0.333333 ) ) ) ) )! !

!RefactoringBrowser class methodsFor: 'accessing'!

beHorizontal
	"self beHorizontal"

	horizontal := true!

beMultiWindow
	multiWindow := true!

beSingleWindow
	multiWindow := false!

beVertical
	"self beVertical"

	horizontal := false!

browserType
	horizontal isNil ifTrue: [self beHorizontal].
	^horizontal
		ifTrue: [self isMultiWindow
				ifTrue: [#horizontalNavigator]
				ifFalse: [#windowSpec]]
		ifFalse: [self isMultiWindow
				ifTrue: [#verticalNavigator]
				ifFalse: [#verticalWindowSpec]]!

isMultiWindow
	multiWindow isNil ifTrue: [multiWindow := false].
	^multiWindow!

patchLevel
	^PatchLevel!

patchLevel: anObject
	PatchLevel := anObject!

version
	^Version!

version: anObject
	Version := anObject! !

!RefactoringBrowser class methodsFor: 'interface opening'!

open
	^self openOnEnvironment: BrowserEnvironment new!

openHorizontal
	^self openOnEnvironment: BrowserEnvironment new spec: #windowSpec!

openMultiOnEnvironment: anEnvironment spec: aSpec
	| browser |
	anEnvironment isEmpty ifTrue: [^Dialog warn: 'Nobody'].
	browser := self new.
	browser initializeOnEnvironment: anEnvironment.
	aSpec == #horizontalNavigator
		ifTrue: [browser beHorizontal]
		ifFalse: [browser beVertical].
	browser policyClass: WindowLockPolicy.
	browser openInterface: aSpec.
	browser newWindow.
	^browser!

openMultiWindowHorizontal
	^self openMultiOnEnvironment: BrowserEnvironment new spec: #horizontalNavigator!

openMultiWindowVertical
	^self openMultiOnEnvironment: BrowserEnvironment new spec: #verticalNavigator!

openOnEnvironment: anEnvironment
	^self isMultiWindow
		ifTrue: [self openMultiOnEnvironment: anEnvironment spec: self browserType]
		ifFalse: [self openOnEnvironment: anEnvironment spec: self browserType]!

openOnEnvironment: anEnvironment spec: aSpec 
	| browser |
	anEnvironment isEmpty ifTrue: [^Dialog warn: 'Nobody'].
	browser := self onEnvironment: anEnvironment.
	aSpec == #windowSpec
		ifTrue: [browser beHorizontal]
		ifFalse: [browser beVertical].
	browser openInterface: aSpec.
	browser currentBuffer value tool updateContents.
	^browser!

openOnSelection
	| dialog |
	dialog := ClassSelectionDialog new.
	dialog open ifFalse: [^self].
	^self openOnEnvironment: dialog selectedEnvironment!

openVertical
	^self openOnEnvironment: BrowserEnvironment new spec: #verticalWindowSpec! !

!RefactoringBrowser class methodsFor: 'resources'!

browseMenu
	"MenuEditor new openOnClass: self andSelector: #browseMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'References to &class or global...' 
				#value: #browseGlobals ) 
			#(#MenuItem 
				#rawLabel: 'References to &symbol' 
				#value: #browseSymbols ) 
			#(#MenuItem 
				#rawLabel: 'Class defining &variable...' 
				#value: #browseVariables ) 
			#(#MenuItem 
				#rawLabel: '&Implementors matching...' 
				#value: #browseImplementors ) 
			#(#MenuItem 
				#rawLabel: 'Methods with strings &matching...' 
				#value: #browseStringMatches ) 
			#(#MenuItem 
				#rawLabel: 'Find reference &path to...' 
				#value: #findReferencePath ) 
			#(#MenuItem 
				#rawLabel: 'Find &all reference paths to...' 
				#value: #findAllReferencePaths ) 
			#(#MenuItem 
				#rawLabel: 'Re&write' 
				#value: #openRewriter ) ) #(2 2 1 2 1 ) nil ) decodeAsLiteralArray! !

BrowserApplicationModel subclass: #CodeTool
	instanceVariableNames: 'codeModel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

CodeTool comment:
'CodeTool is an abstact class represents the tools that can appear when a user has selected an item (e.g., a class) using the navigator. These tools are dynamically switched depending on current selection.

Instance Variables:
	codeModel	<CodeModel> contains the CodeModel that the CodeTool is in
'!


!CodeTool methodsFor: 'initialize-release'!

codeModel: aCodeModel 
	codeModel := aCodeModel! !

!CodeTool methodsFor: 'accessing'!

categories
	^codeModel categories!

category
	^codeModel category!

className
	^codeModel className!

classNames
	^codeModel classNames!

environment
	^self navigator environment!

isMeta
	^codeModel isMeta!

menu
	"Return a menu that can be placed into a window. Menus that use symbol must be converted to use
	blocks since they will have a different model when they are placed into a window."

	^(Menu new) addItemLabel: '&update display' value: [self updateDisplay];
		yourself!

methods
	^codeModel methods!

navigator
	^codeModel navigator!

nonMetaClass
	^codeModel nonMetaClass!

nonMetaClasses
	^codeModel nonMetaClasses!

protocol
	^codeModel protocol!

protocols
	^codeModel protocols!

saveState
	self subcanvases do: [:each | each saveState]!

selectedClass
	^codeModel selectedClass!

selectedClasses
	^codeModel selectedClasses!

selector
	^codeModel selector!

selectors
	^codeModel selectors! !

!CodeTool methodsFor: 'testing'!

isEditing
	"Return true if your contents have changed and haven't been accepted."

	^self subcanvases contains: [:each | each isEditing]! !

!CodeTool methodsFor: 'updating'!

updateContents!

updateDisplay
	self subcanvases do: [:each | each updateDisplay]! !

CodeTool class
	instanceVariableNames: ''!



!CodeTool class methodsFor: 'instance creation'!

codeModel: aCodeModel 
	^self new codeModel: aCodeModel!

on: aCodeModel 
	^self new codeModel: aCodeModel! !

CodeTool subclass: #OMTClassTool
	instanceVariableNames: 'view '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-OMT-Diagram'!

OMTClassTool comment:
'OMTClassTool is the CodeTool for an OMT diagram.

Instance Variables:
	view	<OMTClassDiagram>	the diagram view'!


!OMTClassTool methodsFor: 'initialize-release'!

codeModel: aCodeModel 
	| selectedClass |
	super codeModel: aCodeModel.
	selectedClass := self selectedClass.
	view := selectedClass isNil
				ifTrue: [CompositePart new]
				ifFalse: 
					[OMTClassDiagram
						classes: selectedClass withAllSuperclasses , selectedClass allSubclasses
						in: aCodeModel navigator]! !

!OMTClassTool methodsFor: 'accessing'!

omtDiagram
	^view! !

OMTClassTool class
	instanceVariableNames: ''!



!OMTClassTool class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Unlabeled Canvas'
			#bounds: #(#Rectangle 197 105 775 568 ) )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#ArbitraryComponentSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 )
					#name: #omtDiagram
					#flags: 11
					#component: #omtDiagram ) ) ) )! !

Navigator subclass: #BrowserNavigator
	instanceVariableNames: 'browser '
	classVariableNames: 'LastMoveMethodProtocol '
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

BrowserNavigator comment:
'BrowserNavigator is the part of the browser that selects which methods to view. It is normally at the top of the browser. From the navigator you select the categories, classes, protocols, and selectors that you want to view.

Instance variables:
	browser	<RefactoringBrowser>	the browser that the navigator is in

Class Variables:
	LastMoveMethodProtocol	<String | nil>	the last move location entered by the user'!


!BrowserNavigator methodsFor: 'initialize-release'!

initializeSendersImplementorsMenu
	| groups newGroup newMenu |
	groups := selectorMenuHolder value visibleMenuItemGroups 
				asOrderedCollection.
	self environment isSystem 
		ifFalse: 
			[newGroup := OrderedCollection 
						with: ((MenuItem labeled: 'Local Senders') submenu: [self localSendersMenu])
						with: ((MenuItem labeled: 'Local Implementors') 
								submenu: [self localImplementorsMenu]).
			groups addFirst: newGroup].
	newGroup := OrderedCollection 
				with: ((MenuItem labeled: 'Senders') submenu: [self globalSendersMenu])
				with: ((MenuItem labeled: 'Implementors') 
						submenu: [self globalImplementorsMenu]).
	groups addFirst: newGroup.
	newMenu := Menu new.
	groups do: [:each | newMenu addItemGroup: each].
	selectorMenuHolder value: newMenu!

on: aBrowser 
	browser := aBrowser.
	self initializeSendersImplementorsMenu.
	self environment isSystem ifFalse: [self addGlobalToMenus]!

spawnClass
	self showWaitCursorWhile: 
			[(self environment forClasses: self nonMetaClasses) openEditor]!

spawnMethod
	self showWaitCursorWhile: 
			[(self environment forClass: self selectedClass selectors: self selectors)
				openEditor]!

spawnProtocol
	self showWaitCursorWhile: 
			[(self environment forClass: self selectedClass protocols: self protocols)
				openEditor]! !

!BrowserNavigator methodsFor: 'accessing'!

environment
	^browser environment! !

!BrowserNavigator methodsFor: 'accessing-browser'!

spec: verticalBoolean 
	^[self getSpec: verticalBoolean]
		valueNowOrOnUnwindDo: [self changed]! !

!BrowserNavigator methodsFor: 'changing'!

changed: anAspectSymbol with: aParameter
	CodeModelLockPolicy flushCache.
	^super changed: anAspectSymbol with: aParameter!

changeRequest
	CodeModelLockPolicy flushCache.
	^super changeRequest! !

!BrowserNavigator methodsFor: 'browsing'!

browseGlobalImplementorsOf: aSelector 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new implementorsOf: aSelector) openEditor]!

browseGlobalInstVarReadersTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new instVarReadersTo: instVar in: aClass) openEditor]!

browseGlobalInstVarRefsTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new instVarRefsTo: instVar in: aClass) openEditor]!

browseGlobalInstVarWritersTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new instVarWritersTo: instVar in: aClass) openEditor]!

browseGlobalReferencesTo: aLiteral 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new referencesTo: aLiteral) openEditor]!

browseGlobalReferencesTo: aLiteral in: aClass 
	self showWaitCursorWhile: 
			[(BrowserEnvironment new referencesTo: aLiteral in: aClass) openEditor]!

browseImplementorsOf: aSelector 
	self
		showWaitCursorWhile: [(self environment implementorsOf: aSelector) openEditor]!

browseInstVarReadersTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(self environment instVarReadersTo: instVar in: aClass) openEditor]!

browseInstVarRefsTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(self environment instVarRefsTo: instVar in: aClass) openEditor]!

browseInstVarWritersTo: instVar in: aClass 
	self showWaitCursorWhile: 
			[(self environment instVarWritersTo: instVar in: aClass) openEditor]!

browseReferencesTo: aLiteral 
	self
		showWaitCursorWhile: [(self environment referencesTo: aLiteral) openEditor]!

browseReferencesTo: aLiteral in: aClass 
	self showWaitCursorWhile: 
			[(self environment referencesTo: aLiteral in: aClass) openEditor]!

spawnHierarchy: aClass 
	| classes newBrowser |
	classes := (Set new) addAll: aClass withAllSuperclasses;
				yourself.
	classes addAll: aClass class withAllSuperclasses.
	classes addAll: aClass allSubclasses.
	classes addAll: aClass class allSubclasses.
	newBrowser := (ClassEnvironment onEnvironment: BrowserEnvironment new classes: classes)
				openEditor.
	(newBrowser navigator) setState: self getState;
		changedCategory.
	newBrowser navigator beHierarchy! !

!BrowserNavigator methodsFor: 'menus'!

addGlobal: globalSelector local: localSelector for: aName in: aMenu 
	| newName dots item mb |
	dots := aName last == $..
	newName := dots ifTrue: [aName copyFrom: 1 to: aName size - 3] ifFalse: [aName].
	item := aMenu menuItemAt: (aMenu labels indexOf: aName).
	item label: newName.
	item value: nil.
	mb := MenuBuilder new.
	mb add: (dots ifTrue: ['&local...'] ifFalse: ['&local']) -> localSelector.
	mb add: (dots ifTrue: ['&global...'] ifFalse: ['&global']) -> globalSelector.
	item submenu: (self initializeMenu: mb menu)!

addGlobalToMenus
	#(#('class' #(#('references...' #classRefs #globalClassRefs))) #('instance variables' #(#('references...' #instVarRefs #globalInstVarRefs) #('readers...' #instVarReaders #globalInstVarReaders) #('writers...' #instVarWriters #globalInstVarWriters))) #('class variables' #(#('references...' #classVarRefs #globalClassVarRefs))))
		do: 
			[:each | 
			| submenu |
			submenu := (classMenuHolder value menuItemAt: (classMenuHolder value labels indexOf: each first)) submenu.
			each last do: [:elmt | self
					addGlobal: elmt last
					local: (elmt at: 2)
					for: elmt first
					in: submenu]]!

globalImplementorsMenu
	^self implementorSenderMenuFor: #browseGlobalImplementorsOf:!

globalSendersMenu
	^self implementorSenderMenuFor: #browseGlobalReferencesTo:!

implementorSenderMenuFor: aSymbol 
	| menuBuilder literals |
	self selector isNil ifTrue: [^Menu new].
	menuBuilder := MenuBuilder new.
	menuBuilder 
		add: self selector asString -> [self perform: aSymbol with: self selector].
	literals := self sentSelectors.
	literals isEmpty ifFalse: [menuBuilder line].
	literals size > 10 
		ifTrue: 
			[menuBuilder
				add: 'More Symbols' -> 
								[| message |
								message := self choose: 'Select a message:' from: literals.
								message notNil ifTrue: [self perform: aSymbol with: message]];
				line].
	(1 to: (literals size min: 10)) do: 
			[:i | 
			menuBuilder 
				add: (literals at: i) -> [self perform: aSymbol with: (literals at: i)]].
	^menuBuilder menu!

localImplementorsMenu
	^self implementorSenderMenuFor: #browseImplementorsOf:!

localSendersMenu
	^self implementorSenderMenuFor: #browseReferencesTo:! !

!BrowserNavigator methodsFor: 'private-category'!

addCategory
	| newCategory categoryName |
	self changeRequest ifFalse: [^self].
	categoryName := Dialog
				request: 'Enter new category'
				initialAnswer: ''
				for: self interfaceWindow.
	(categoryName isNil or: [categoryName isEmpty])
		ifTrue: [^self].
	newCategory := categoryName asSymbol.
	self addCategory: newCategory before: self category.
	self newCategoryList: (Array with: newCategory).
	self changedCategory!

addCategory: newCategory before: aCategory
	"Insert newCategory into the class organization before aCategory."

	Cursor wait
		showWhile:
			[Smalltalk organization addCategory: newCategory before: aCategory.
			ChangeSet current reorganizeSystem]!

fileOutCategory
	| fileName fileManager |
	fileName := Dialog requestNewFileName: 'File out on' default: (self filterFilename: self category , '.st').
	fileName = '' ifTrue: [^nil].
	fileManager := SourceCodeStream on: fileName asFilename writeStream.
	[self categories do: [:each | self environment fileOutCategory: each on: fileManager]]
		valueNowOrOnUnwindDo: [fileManager close]!

hardcopyCategory
	"Print the category."

	| stream |
	stream := TextStream on: (String new: 1000).
	self categories do: [:each | self environment writeCategory: each on: stream].
	self hardcopyStream: stream!

removeCategory
	| index |
	self changeRequest ifFalse: [^self].
	(self categories
		contains: [:each | (BrowserEnvironment new classNamesFor: each) isEmpty not])
			ifTrue: 
				[(Dialog
					confirm: 'Are you certain that you want to remove all classes in the selected categories?'
					for: self interfaceWindow) ifFalse: [^self]].
	index := self categoryList list indexOf: self category.
	self categories do: [:each | self removeCategory: each].
	self
		newCategoryList: (Array with: (self categoryList list
						at: (index == 1 ifTrue: [index + 1] ifFalse: [index - 1]))).
	self changedCategory!

removeCategory: aCategory
	Cursor wait
		showWhile:
			[| classes |
			classes := self environment superclassOrder: aCategory.
			classes reverseDo: [:cls | cls removeFromSystem].
			(Smalltalk organization listAtCategoryNamed: aCategory) isEmpty
				ifTrue:
					[Smalltalk organization removeCategory: aCategory.
					ChangeSet current reorganizeSystem]]!

renameCategory
	| newCategory categoryName |
	self changeRequest ifFalse: [^self].
	categoryName := Dialog
				request: 'Enter new category'
				initialAnswer: self category
				for: self interfaceWindow.
	(categoryName isNil or: [categoryName isEmpty])
		ifTrue: [^self].
	newCategory := categoryName asSymbol.
	self renameCategory: self category to: newCategory.
	self newCategoryList: (Array with: newCategory)!

renameCategory: aCategory to: newCategory
	Cursor wait showWhile: [(Smalltalk organization renameCategory: aCategory to: newCategory)
			ifTrue: [ChangeSet current reorganizeSystem]]!

spawnCategory
	Cursor wait
		showWhile: [(self environment forCategories: self categories) openEditor]! !

!BrowserNavigator methodsFor: 'private-class'!

abstractClassVar
	| classVars |
	self changeRequest ifFalse: [^self].
	classVars := self selectClassVariables.
	classVars isEmpty ifTrue: [^self].
	classVars do: 
			[:each | 
			self handleError: 
					[(AbstractClassVariableRefactoring variable: each class: self nonMetaClass) 
						execute]].
	self changedClass!

abstractInstVar
	| instVars |
	self changeRequest ifFalse: [^self].
	instVars := self selectInstanceVariables.
	instVars isEmpty ifTrue: [^self].
	instVars do: [:each | self abstractInstVar: each in: self selectedClass].
	self changedClass!

abstractInstVar: instVar in: class 
	self handleError: 
			[(AbstractInstanceVariableRefactoring variable: instVar class: class)
				execute]!

addClassVar
	self changeRequest ifFalse: [^self].
	self addClassVarIn: self nonMetaClass.
	self changedClass!

addClassVarIn: aClass 
	| newName |
	newName := self requestClassVarName: ''.
	newName isNil ifTrue: [^self].
	self handleError: 
			[(AddClassVariableRefactoring variable: newName class: aClass) execute]!

addInstVar
	self changeRequest ifFalse: [^self].
	self addInstVarIn: self selectedClass.
	self changedClass!

addInstVarIn: aClass 
	| newName |
	newName := self requestInstVarName: ''.
	newName isNil ifTrue: [^self].
	self handleError: 
			[(AddInstanceVariableRefactoring variable: newName class: aClass) execute]!

changeClassCategory
	| state |
	self changeRequest ifFalse: [^self].
	state := self getState.
	self changeClassCategoryFor: self nonMetaClasses.
	self setState: state updateClasses: true.
	self changed: #category with: self category!

changeClassCategoryFor: classCollection 
	| dialog newCategory oldCategory changeClasses |
	classCollection isEmpty ifTrue: [^self].
	oldCategory := self environment whichCategoryIncludes: classCollection first name.
	dialog := CategoryDialog new.
	dialog organizer: Smalltalk organization.
	dialog currentCategory: oldCategory.
	dialog open ifFalse: [^self].
	newCategory := dialog categoryName asSymbol.
	changeClasses := classCollection
				select: [:each | (self environment whichCategoryIncludes: each name) ~= newCategory].
	changeClasses isEmpty ifTrue: [^self].
	changeClasses do: 
			[:each | 
			Smalltalk organization classify: each name under: newCategory.
			ChangeSet current changeClass: each]!

checkProtocols
	self changeRequest ifFalse: [^self].
	Cursor wait showWhile: 
			[(self nonMetaClasses inject: false
				into: 
					[:changed :class | 
					changed | (self checkProtocolsFor: class)
						| (self checkProtocolsFor: class class)])
					ifTrue: [self setState: self getState updateClasses: true]
					ifFalse: [Dialog warn: 'No changes made.']]!

classRefs
	self browseReferencesTo: (self environment associationAt: self className)!

classVarRefs
	| classVar association |
	classVar := self selectClassVarSupers: true subs: false.
	classVar isNil ifTrue: [^self].
	association := self findAssociationForClassVariable: classVar.
	self browseReferencesTo: association in: self nonMetaClass!

convertToSibling
	| name subclasses |
	name := self request: 'Enter name for new parent class'.
	name isEmpty ifTrue: [^self].
	subclasses := self selectSubclassesOf: self nonMetaClass.
	subclasses isNil ifTrue: [^self].
	self handleError: 
			[(ChildrenToSiblingsRefactoring name: name
				class: self nonMetaClass
				subclasses: subclasses) execute.
			self selectClasses: (Array with: name asSymbol)
				meta: self isMeta
				categories: self categories]!

createClassVarAccessors
	| classVars |
	self changeRequest ifFalse: [^self].
	classVars := self selectClassVariables.
	classVars isEmpty ifTrue: [^self].
	classVars do: 
			[:each | 
			self handleError: 
					[(CreateAccessorsForVariableRefactoring 
						variable: each
						class: self nonMetaClass
						classVariable: true) execute]].
	self changedClass!

createInstVarAccessors
	| instVars |
	self changeRequest ifFalse: [^self].
	instVars := self selectInstanceVariables.
	instVars isEmpty ifTrue: [^self].
	instVars do: 
			[:each | 
			self handleError: 
					[(CreateAccessorsForVariableRefactoring 
						variable: each
						class: self selectedClass
						classVariable: false) execute]].
	self changedClass!

createSubclass
	| class |
	self changeRequest ifFalse: [^self].
	class := self createSubclassOf: self nonMetaClass.
	class isNil ifTrue: [^self].
	self selectClass: class.
	self updateCategoryList!

createSubclassOf: aClass 
	| name subclasses dialog |
	name := self requestClassName.
	name isNil ifTrue: [^nil].
	subclasses := self selectSubclassesOf: aClass.
	subclasses isNil ifTrue: [^nil].
	dialog := CategoryDialog new.
	dialog organizer: Smalltalk organization.
	dialog currentCategory: (self environment whichCategoryIncludes: aClass name).
	dialog open ifFalse: [^nil].
	^self handleError: 
			[(AddClassRefactoring addClass: name
				superclass: aClass
				subclasses: subclasses
				category: dialog categoryName) execute.
			Smalltalk at: name asSymbol ifAbsent: [nil]]!

fileOutClass
	| fileName fileManager |
	fileName := Dialog requestNewFileName: 'File out on'
				default: (self filterFilename: self nonMetaClass name , '.st').
	fileName = '' ifTrue: [^nil].
	fileManager := SourceCodeStream on: fileName asFilename writeStream.
	
	[fileManager timeStamp.
	self nonMetaClasses do: [:each | each fileOutSourceOn: fileManager]]
			valueNowOrOnUnwindDo: [fileManager close]!

findAllReferencesToInstances
	self showWaitCursorWhile: 
			[| paths |
			paths := ReferenceFinder findAllPathsToInstanceOf: self selectedClass.
			paths isEmpty 
				ifTrue: [self warn: 'No reference paths exist']
				ifFalse: [paths inspect]]!

findAssociationForClassVariable: classVar 
	| association definingClass name |
	definingClass := self nonMetaClass.
	
	[definingClass notNil and: 
			[name := definingClass classPool keys
						detect: [:each | each asString = classVar asString]
						ifNone: [nil].
			association := definingClass classPool associationAt: name ifAbsent: [nil].
			association isNil]] 
			whileTrue: [definingClass := definingClass superclass].
	^association!

findReferencePathToInstance
	self showWaitCursorWhile: 
			[| path |
			path := ReferenceFinder findPathToInstanceOf: self selectedClass.
			path notNil 
				ifTrue: [path inspect]
				ifFalse: [self warn: 'No reference paths exist']]!

forClasses: aCollection showVariableMenu: generatorBlock collect: valueBlock 
	"Construct a menu of variable names supplied by the generatorBlock, 
	with lines between classes in the superclass chain. Show the menu, 
	returning the variable chosen by the user, or nil if no variable was chosen."

	| variables labels tab listW sd spec buttons |
	variables := OrderedCollection new.
	labels := SelectionInList new.
	tab := String with: Character tab.
	aCollection
		do: 
			[:eachClass | 
			| varList |
			varList := generatorBlock value: eachClass.
			varList isEmpty
				ifFalse: 
					[labels list add: (Text string: eachClass name emphasis: #italic).
					labels selectionIndex: labels list size + 1.	"we know this will be legal"
					variables add: nil.
					(generatorBlock value: eachClass)
						do: 
							[:var | 
							labels list add: tab , (valueBlock value: var).
							variables addLast: var]]].
	variables isEmpty ifTrue: [^nil].	"Nothing to choose from"
	sd := SimpleDialog new.
	spec := sd class interfaceSpecFor: #emptySpec.
	sd builder add: spec window.
	sd builder add: spec component.
	sd setInitialGap.
	sd addMessage: 'Select variable:' withCRs centered: false.
	sd addGap: 8.
	listW := sd
				addList: labels
				lines: (20 min: variables size + 2)
				validation: [labels selectionIndex > 0].
	listW widget setValidTargetIndex: labels selectionIndex.
	sd addGap: 4.
	buttons := sd addOK: [labels selectionIndex ~= 0].
	sd addGap: 6.
	sd bottomAlignLowerEdge: listW.
	sd bottomAlign: (Array with: buttons).
	labels selectionIndexHolder compute: [:v | (v > 0 and: [(variables at: v) isNil])
			ifTrue: 
				[labels selectionIndex: 0.
				listW widget targetIndex: 0]].
	sd preOpen.
	sd builder openDialogWithExtent: sd builder window displayBox extent.
	^sd accept value
		ifTrue: [variables at: labels selectionIndex]
		ifFalse: [nil]!

globalClassRefs
	self browseGlobalReferencesTo: (self environment associationAt: self className)!

globalClassVarRefs
	| classVar association |
	classVar := self selectClassVarSupers: true subs: false.
	classVar isNil ifTrue: [^self].
	association := self findAssociationForClassVariable: classVar.
	self browseGlobalReferencesTo: association in: self nonMetaClass!

globalInstVarReaders
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseGlobalInstVarReadersTo: instVar in: self selectedClass]!

globalInstVarRefs
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseGlobalInstVarRefsTo: instVar in: self selectedClass]!

globalInstVarWriters
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseGlobalInstVarWritersTo: instVar in: self selectedClass]!

inspectAllInstances
	(self nonMetaClass allInstancesWeakly: true) inspect!

instVarReaders
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseInstVarReadersTo: instVar in: self selectedClass]!

instVarRefs
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseInstVarRefsTo: instVar in: self selectedClass]!

instVarWriters
	| instVar |
	instVar := self selectInstVarSupers: true subs: false.
	instVar notNil
		ifTrue: [self browseInstVarWritersTo: instVar in: self selectedClass]!

printOutClass
	"Print the class."

	| stream |
	stream := TextStream on: (String new: 1000).
	self nonMetaClasses do: [:each | each printOutOn: stream].
	self hardcopyStream: stream!

protectInstVar
	| instVars |
	self changeRequest ifFalse: [^self].
	instVars := self selectInstanceVariables.
	instVars isEmpty ifTrue: [^self].
	instVars do: [:each | self protectInstVar: each in: self selectedClass].
	self changedClass!

protectInstVar: instVar in: class 
	self handleError: 
			[(ProtectInstanceVariableRefactoring variable: instVar class: class) 
				execute]!

pullUpClassVar
	| classVar |
	self changeRequest ifFalse: [^self].
	classVar := self selectSubclassClassVar.
	classVar isNil ifTrue: [^self].
	self handleError: 
			[(PullUpClassVariableRefactoring variable: classVar class: self nonMetaClass)
				execute.
			self changedClass]!

pullUpInstVar
	| instVar |
	self changeRequest ifFalse: [^self].
	instVar := self selectSubclassInstVar.
	instVar isNil ifTrue: [^self].
	self handleError: 
			[(PullUpInstanceVariableRefactoring variable: instVar class: self selectedClass)
				execute.
			self changedClass]!

pushDownClassVar
	| classVar |
	self changeRequest ifFalse: [^self].
	classVar := self selectClassVarSupers: false subs: false.
	classVar isNil ifTrue: [^self].
	self handleError: 
			[(PushDownClassVariableRefactoring variable: classVar
				class: self nonMetaClass) execute.
			self changedClass]!

pushDownInstVar
	| instVar |
	self changeRequest ifFalse: [^self].
	instVar := self selectInstVarSupers: false subs: false.
	instVar isNil ifTrue: [^self].
	self handleError: 
			[(PushDownInstanceVariableRefactoring variable: instVar
				class: self selectedClass) execute.
			self changedClass]!

removeClass
	| notRemoved |
	self changeRequest ifFalse: [^self].
	(self
		confirm: 'Are you certain that you want to remove all selected classes?')
			ifFalse: [^self].
	notRemoved := self nonMetaClasses reject: [:each | self removeClass: each].
	self newClassList: (notRemoved collect: [:each | each name]).
	self changedClass!

removeClass: aClass 
	(Smalltalk includesKey: aClass name) ifFalse: [^true].
	(aClass subclasses isEmpty 
		or: [self confirm: aClass name , ' has subclasses. Remove anyway?']) 
			ifFalse: [^false].
	self 
		showWaitCursorWhile: [self performChange: (RemoveClassChange remove: aClass)].
	^true!

removeClassesSafe: classCollection 
	self handleError: 
			[(RemoveClassRefactoring 
				classNames: (classCollection collect: [:each | each name])) execute]!

removeClassSafe
	self changeRequest ifFalse: [^self].
	self removeClassesSafe: self nonMetaClasses.
	self newClassList: self classNames.
	self changedClass!

removeClassVar
	| classVar |
	self changeRequest ifFalse: [^self].
	classVar := self selectClassVarSupers: false subs: false.
	classVar isNil ifTrue: [^self].
	self handleError: 
			[(RemoveClassVariableRefactoring variable: classVar
				class: self nonMetaClass) execute.
			self changedClass]!

removeInstVar
	| instVar |
	self changeRequest ifFalse: [^self].
	instVar := self selectInstVarSupers: false subs: false.
	instVar isNil ifTrue: [^self].
	self removeInstVar: instVar fromClass: self selectedClass.
	self changedClass!

removeInstVar: instVar fromClass: cls 
	self handleError: 
			[(RemoveInstanceVariableRefactoring variable: instVar class: cls) execute]!

renameClass
	self changeRequest ifFalse: [^self].
	self renameClass: self nonMetaClass!

renameClass: aClass 
	| aString newName |
	aString := self request: 'Enter new ClassName' initialAnswer: aClass name.
	aString isEmpty ifTrue: [^self].
	newName := aString asSymbol.
	self handleError: 
			[(RenameClassRefactoring rename: aClass to: newName) execute.
			self selectClasses: (Array with: aString asSymbol)
				meta: self isMeta
				categories: self categories.
			self changedClass]!

renameClassVar
	| classVar |
	self changeRequest ifFalse: [^self].
	classVar := self selectClassVarSupers: false subs: false.
	classVar isNil ifTrue: [^self].
	self renameClassVar: classVar in: self nonMetaClass.
	self changedClass!

renameClassVar: oldName in: aClass 
	| newName |
	newName := self requestClassVarName: oldName.
	newName isNil ifTrue: [^self].
	self handleError: 
			[(RenameClassVariableRefactoring rename: oldName
				to: newName
				in: aClass) execute]!

renameInstVar
	| instVar |
	self changeRequest ifFalse: [^self].
	instVar := self selectInstVarSupers: false subs: false.
	instVar isNil ifTrue: [^self].
	self renameInstVar: instVar in: self selectedClass.
	self changedClass!

renameInstVar: oldName in: aClass 
	| newName |
	newName := self requestInstVarName: oldName.
	newName isNil ifTrue: [^self].
	self handleError: 
			[(RenameInstanceVariableRefactoring rename: oldName
				to: newName
				in: aClass) execute]!

requestClassName
	| name |
	name := self request: 'Enter a class name:'.
	^name isEmpty ifTrue: [nil] ifFalse: [name]!

requestClassVarName: oldName 
	| name |
	name := self request: 'Enter a class variable name:' initialAnswer: oldName.
	(name isEmpty or: [oldName asString = name asString]) ifTrue: [^nil].
	^name!

requestInstVarName: oldName 
	| name |
	name := self request: 'Enter a instance variable name:' initialAnswer: oldName.
	(name isEmpty or: [oldName = name]) ifTrue: [^nil].
	^name!

selectClassVariables
	| variables |
	variables := self nonMetaClass classVarNames asSortedCollection.
	variables isEmpty ifTrue: [^#()].
	^SimpleDialog new 
		chooseMultiple: 'Choose variables:'
		fromList: variables
		values: variables
		buttons: #()
		values: #()
		lines: 8
		cancel: [#()]!

selectClassVarSupers: superBoolean subs: subBoolean
	| classes |
	classes := OrderedCollection with: self nonMetaClass.
	superBoolean ifTrue: [classes addAllFirst: self nonMetaClass allSuperclasses reverse].
	subBoolean ifTrue: [classes addAllLast: self nonMetaClass allSubclasses].
	^self
		forClasses: classes
		showVariableMenu: [:class | class classPool keys asSortedCollection]
		collect: [:name | name]!

selectInstanceVariables
	| variables |
	variables := self selectedClass instVarNames asSortedCollection.
	variables isEmpty ifTrue: [^#()].
	^SimpleDialog new 
		chooseMultiple: 'Choose variables:'
		fromList: self selectedClass instVarNames
		values: self selectedClass instVarNames
		buttons: #()
		values: #()
		lines: 8
		cancel: [#()]!

selectInstVarSupers: superBoolean subs: subBoolean
	| classes |
	classes := OrderedCollection with: self selectedClass.
	superBoolean ifTrue: [classes addAllFirst: self selectedClass allSuperclasses reverse].
	subBoolean ifTrue: [classes addAllLast: self selectedClass allSubclasses].
	^self
		forClasses: classes
		showVariableMenu: [:class | class instVarNames]
		collect: [:cname | cname]!

selectSubclassClassVar
	| varNames |
	varNames := (self selectedClass allSubclasses inject: Set new
				into: 
					[:set :each | 
					set addAll: each classVarNames;
						yourself])
					asSortedCollection.
	varNames isEmpty ifTrue: [^nil].
	^self choose: 'Select class variable:' from: varNames!

selectSubclassInstVar
	| varNames |
	varNames := (self selectedClass allSubclasses inject: Set new
				into: 
					[:set :each | 
					set addAll: each instVarNames;
						yourself])
					asSortedCollection.
	varNames isEmpty ifTrue: [^nil].
	^self choose: 'Select instance variable:' from: varNames!

spawnHierarchy
	self spawnHierarchy: self nonMetaClass!

valueHolderForInstVar: aName in: aClass
	self handleError: [(ValueHolderRefactoring variable: aName class: aClass) execute]!

valueHolderInstVar
	| instVar |
	self changeRequest ifFalse: [^self].
	instVar := self selectInstVarSupers: false subs: false.
	instVar isNil ifTrue: [^self].
	self valueHolderForInstVar: instVar in: self selectedClass.
	self changedClass! !

!BrowserNavigator methodsFor: 'private-protocol'!

addProtocol
	| newProtocol |
	self changeRequest ifFalse: [^self].
	newProtocol := Dialog
				request: 'Enter new protocol'
				initialAnswer: (LastProtocol notNil
						ifTrue: [LastProtocol]
						ifFalse: [#'new protocol name'])
				for: self interfaceWindow.
	(newProtocol isNil or: [newProtocol isEmpty])
		ifTrue: [^self].
	newProtocol := newProtocol asSymbol.
	self
		addProtocol: newProtocol
		before: self protocol
		for: self selectedClass.
	self newProtocolList: (Array with: newProtocol).
	self changedProtocol!

addProtocol: aNewProtocol before: aSymbolOrNil for: aClass 
	Cursor wait showWhile: 
			[aClass organization addCategory: aNewProtocol before: aSymbolOrNil.
			self
				logProtocolChange: aClass name , ' organization addCategory: ' , aNewProtocol printString
						, ' before: ' , aSymbolOrNil printString.
			aClass reorganize]!

fileOutProtocol
	| fileName fileManager |
	fileName := Dialog requestNewFileName: 'File out as'
				default: (self filterFilename: self className , '-' , self protocol , '.st').
	fileName = '' ifTrue: [^nil].
	fileManager := SourceCodeStream on: fileName asFilename writeStream.
	
	[fileManager timeStamp.
	self protocols do: 
			[:each | 
			fileManager
				fileOutMessages: (self environment selectorsFor: each in: self selectedClass)
				for: self selectedClass]]
			valueNowOrOnUnwindDo: [fileManager close]!

printOutProtocol
	"Print out protocol."

	| stream |
	stream := TextStream on: (String new: 1000).
	self protocols
		do: [:each | self selectedClass printOutCategory: each on: stream].
	self hardcopyStream: stream!

removeProtocol
	self changeRequest ifFalse: [^self].
	(self protocols contains: 
			[:each | 
			(self selectedClass organization listAtCategoryNamed: each) isEmpty not])
		ifTrue: 
			[(Dialog
				confirm: 'Are you certain that you want to\remove the selected protocols and their methods?'
						withCRs
				for: self interfaceWindow) ifFalse: [^self]].
	self protocols
		do: [:each | self removeProtocol: each in: self selectedClass].
	self newProtocolList: #().
	self changedProtocol!

removeProtocol: aProtocol in: aClass
	Cursor wait
		showWhile:
			[(self environment selectorsFor: aProtocol in: aClass)
				do: [:each | self removeMethod: each in: aClass].
			aClass organization removeCategory: aProtocol.
			self logProtocolChange: aClass name , ' organization removeCategory: ' , aProtocol storeString.
			aClass reorganize]!

renameProtocol
	| newProtocol |
	self changeRequest ifFalse: [^self].
	newProtocol := Dialog request: 'Enter new protocol' initialAnswer: self protocol.
	newProtocol isEmpty ifTrue: [^self].
	newProtocol := newProtocol asSymbol.
	self renameProtocol: self protocol
		to: newProtocol
		in: self selectedClass.
	self newProtocolList: (Array with: newProtocol).
	self changedProtocol!

renameProtocol: oldProtocol to: newProtocol in: aClass 
	Cursor wait showWhile: 
			[(aClass organization renameCategory: oldProtocol to: newProtocol) ifTrue: 
					[self
						logProtocolChange: aClass printString , ' organization renameCategory: '
								, oldProtocol printString , ' to: ' , newProtocol printString.
					aClass reorganize]]! !

!BrowserNavigator methodsFor: 'private-selector'!

addParameter
	| newSelector |
	self changeRequest ifFalse: [^self].
	newSelector := self addParameterTo: self selector in: self selectedClass.
	newSelector isNil ifTrue: [^self].
	self newSelectorList: (Array with: newSelector).
	self changedSelector!

addParameterTo: aSelector in: aClass 
	| initializer newSelector initialAnswer |
	initialAnswer := aSelector numArgs == 0 
				ifTrue: [aSelector , ':']
				ifFalse: [aSelector].
	newSelector := self request: 'Enter new selector:'
				initialAnswer: initialAnswer.
	newSelector isEmpty ifTrue: [^nil].
	newSelector := newSelector asSymbol.
	initializer := self request: 'Enter default value for parameter:'
				initialAnswer: 'nil'.
	initializer isEmpty ifTrue: [^nil].
	^self handleError: 
			[(AddParameterRefactoring 
				addParameterToMethod: aSelector
				in: aClass
				newSelector: newSelector
				initializer: initializer) execute.
			newSelector]!

fileOutMessage
	| fileName sel fileManager |
	sel := self selector isKeyword 
				ifTrue: 
					[(self selector keywords inject: (WriteStream on: (String new: 20))
						into: 
							[:sum :each | 
							sum
								nextPutAll: (each copyFrom: 1 to: each size - 1);
								yourself]) 
							contents]
				ifFalse: [self selector].
	fileName := Dialog requestNewFileName: 'File out as'
				default: (self filterFilename: self selectedClass name , '-' , sel , '.st').
	fileName = '' ifTrue: [^nil].
	fileManager := SourceCodeStream on: fileName asFilename writeStream.
	
	[fileManager timeStamp.
	fileManager fileOutMessages: self selectors for: self selectedClass] 
			valueNowOrOnUnwindDo: [fileManager close]!

inlineSelfSends
	self handleError: 
			[(InlineAllSendersRefactoring sendersOf: self selector
				in: self selectedClass) execute.
			self newSelectorList: self selectors.
			self changedSelector]!

moveMethod
	| newProtocol |
	self changeRequest ifFalse: [^self].
	newProtocol := Dialog request: 'Enter new protocol or\class>protocol to copy' withCRs
				initialAnswer: LastMoveMethodProtocol
				for: self interfaceWindow.
	newProtocol isEmpty ifTrue: [^self].
	LastMoveMethodProtocol := newProtocol.
	self selectors do: 
			[:each | 
			self moveMethod: each
				to: newProtocol
				in: self selectedClass].
	self newProtocolList: self protocols.
	self changedSelector!

moveMethod: aSelector to: aProtocol in: aClass 
	Cursor wait showWhile: 
			[| moved classPart destClassName destClass protStart newProtocol |
			newProtocol := aProtocol.
			moved := false.
			(newProtocol includes: $>)
				ifTrue: 
					["copy to another class"

					classPart := newProtocol copyUpTo: $>.
					destClassName := classPart copyUpTo: Character space.
					destClass := self environment at: destClassName asSymbol ifAbsent: [nil].
					destClass isBehavior ifFalse: [^nil].
					classPart size = destClassName size ifFalse: 
							[(classPart size - destClassName size = 6
								and: [(classPart copyFrom: classPart size - 5 to: classPart size) = ' class'])
									ifTrue: [destClass := destClass class]
									ifFalse: [^nil]].
					protStart := classPart size + 2.
					[(newProtocol at: protStart) = $ ] whileTrue: [protStart := protStart + 1].
					newProtocol := (newProtocol copyFrom: protStart to: newProtocol size) asSymbol.
					destClass == aClass ifFalse: 
							[moved := true.
							destClass compile: (aClass sourceCodeAt: aSelector)
								classified: newProtocol
								notifying: nil]]
				ifFalse: 
					["move within this class"

					destClass := aClass.
					newProtocol := newProtocol asSymbol].
			moved ifFalse: 
					[(destClass organization categories includes: newProtocol)
						ifFalse: [destClass organization addCategory: newProtocol].
					destClass organization classify: aSelector under: newProtocol.
					self
						logProtocolChange: destClass name , ' organization classify: ' , aSelector printString
								, ' under: ' , newProtocol printString.
					destClass reorganize]]!

moveMethodToOtherObject
	| variable |
	self changeRequest ifFalse: [^self].
	variable := self selectVariableForMoveMethod.
	variable notNil ifTrue: 
			[self handleError: 
					[(MoveMethodRefactoring selector: self selector
						class: self selectedClass
						variable: variable) execute.
					self changedSelector]]!

printOutMessage
	"Print the method."

	| stream |
	stream := TextStream on: (String new: 1000).
	self selectors
		do: [:each | self selectedClass printMethod: each on: stream].
	self hardcopyStream: stream!

pushDownSelector
	self changeRequest ifFalse: [^self].
	self handleError: 
			[(PushDownMethodRefactoring pushDown: self selectors from: self selectedClass)
				execute.
			self newSelectorList: self selectors.
			self changedSelector]!

pushUpSelector
	self changeRequest ifFalse: [^self].
	self handleError: 
			[(PushUpMethodRefactoring pushUp: self selectors from: self selectedClass)
				execute.
			self newSelectorList: self selectors.
			self changedSelector]!

removeMethod
	(self changeRequest and: 
			[self confirm: 'Are you certain that you want to remove all selected methods?'])
		ifFalse: [^self].
	self selectors
		do: [:each | self removeMethod: each in: self selectedClass].
	self newSelectorList: #().
	self changedSelector!

removeMethod: aSelector in: aClass 
	self showWaitCursorWhile: 
			[self performChange: (RemoveMethodChange remove: aSelector from: aClass)]!

removeMethodSafe
	self changeRequest ifFalse: [^self].
	self removeMethodsSafe: self selectors from: self selectedClass.
	self newSelectorList: self selectors.
	self changedSelector!

removeMethodsSafe: sels from: cls 
	self
		handleError: [(RemoveMethodRefactoring removeMethods: sels from: cls) execute]!

renameMethod
	| newSelector |
	self changeRequest ifFalse: [^self].
	newSelector := self renameMethod: self selector in: self selectedClass.
	newSelector isNil ifTrue: [^self].
	self newSelectorList: (Array with: newSelector).
	self changedSelector!

renameMethod: aSelector in: aClass 
	| selector tree dialog args newArgs map |
	tree := aClass parseTreeFor: aSelector.
	tree isNil 
		ifTrue: 
			[self warn: 'Could not parse the method'.
			^nil].
	args := tree argumentNames.
	dialog := MethodNameDialog methodNameFor: args initial: aSelector.
	dialog open ifFalse: [^nil].
	selector := dialog methodName.
	newArgs := dialog arguments asOrderedCollection.
	map := Array new: args size.
	1 to: args size do: [:i | map at: i put: (args indexOf: (newArgs at: i))].
	^self handleError: 
			[(RenameMethodRefactoring 
				renameMethod: aSelector
				in: aClass
				to: selector
				permuation: map) execute.
			selector asSymbol]!

selectVariableForMoveMethod
	| parseTree nameList ignoreList |
	parseTree := self selectedClass parseTreeFor: self selector.
	parseTree isNil ifTrue: [^self warn: 'Could not parse sources'].
	nameList := OrderedCollection new.
	nameList add: '---- Arguments ----';
		addAll: (parseTree arguments collect: [:each | each name]) asSortedCollection;
		add: '---- Instance Variables ----'.
	ignoreList := OrderedCollection with: 1 with: nameList size.
	nameList addAll: self selectedClass allInstVarNames asSortedCollection.
	^self choose: 'Select variable to move method into:'
		fromList: nameList
		values: nameList
		ignore: ignoreList
		initialSelection: nil
		lines: 8
		cancel: [nil]! !

!BrowserNavigator methodsFor: 'private'!

checkProtocolFor: aSelector in: aClass 
	| protocol |
	protocol := aClass organization categoryOfElement: aSelector.
	^protocol isNil
		ifTrue: 
			[(Dialog confirm: aSelector asString
						, ' is not classified under a protocol.\Do you want to classify it?' withCRs)
				ifTrue: 
					[protocol := Dialog
								request: 'Enter a protocol name for ' asText
										, (aSelector asText emphasizeAllWith: #(#italic)) , ':'.
					protocol isEmpty ifFalse: 
							[self moveMethod: aSelector
								to: protocol
								in: aClass]].
			true]
		ifFalse: [false]!

checkProtocolMatchFor: aSelector in: aClass 
	| protocol superClass superProtocol patchClass |
	protocol := aClass organization categoryOfElement: aSelector.
	protocol isNil ifTrue: [^false].
	superClass := aClass superclass whichClassIncludesSelector: aSelector.
	superClass isNil ifTrue: [^false].
	superProtocol := superClass organization categoryOfElement: aSelector.
	superProtocol == protocol ifTrue: [^false].
	superProtocol isNil ifTrue: [^false].
	patchClass := Dialog
				choose: (aSelector printString , ' is classified under "' , protocol , '" in '
						, aClass name , '\and under "' , superProtocol , '" in ' , superClass name
						, '. Patch?') withCRs
				labels: (Array with: aClass name asString
						with: superClass name asString
						with: 'neither')
				values: (Array with: aClass
						with: superClass
						with: nil)
				default: aClass.
	patchClass isNil ifTrue: [^false].
	patchClass == aClass
		ifTrue: 
			[self moveMethod: aSelector
				to: superProtocol
				in: aClass]
		ifFalse: 
			[self moveMethod: aSelector
				to: protocol
				in: superClass].
	^true!

checkProtocolsFor: aClass 
	^(self environment selectorsForClass: aClass) inject: false
		into: 
			[:bool :each | 
			bool | (self checkProtocolFor: each in: aClass)
				| (self checkProtocolMatchFor: each in: aClass)]!

choose: aString from: aCollection
	^Dialog
		choose: aString
		fromList: aCollection
		values: aCollection
		lines: 20
		cancel: [nil]!

filterFilename: fName
	"Filter out uglyness in file names"

	^Filename defaultClass suggest: (Filename defaultClass filterSeps: fName)!

getSpec: verticalBoolean 
	| selectors protocols category categories class nonMeta classes |
	categories := self environment categories asList.
	self categoryList list: categories.
	categories size == 1 ifFalse: 
			[^verticalBoolean
				ifTrue: [self class verticalCategoryWindowSpec]
				ifFalse: [self class categoryWindowSpec]].
	category := categories first.
	self categoryHolder value: category.
	classes := (self environment classNamesFor: category) asList.
	self classList list: classes.
	classes size == 1 ifFalse: 
			[^verticalBoolean
				ifTrue: [self class verticalCategoryWindowSpec]
				ifFalse: [self class categoryWindowSpec]].
	self classHolder value: classes first.
	class := self environment at: classes first.
	((nonMeta := self environment includesClass: class)
		and: [self environment includesClass: class class]) ifTrue: 
				[self meta value: false.
				self protocolList list: (self environment protocolsFor: class) asList.
				^verticalBoolean
					ifTrue: [self class verticalClassWindowSpec]
					ifFalse: [self class classWindowSpec]].
	protocols := (self environment
				protocolsFor: (nonMeta ifTrue: [class] ifFalse: [class class])) asList.
	self meta value: nonMeta not.
	self protocolList list: protocols.
	protocols size == 1 ifFalse: 
			[^verticalBoolean
				ifTrue: [self class verticalClassWindowSpec]
				ifFalse: [self class classWindowSpec]].
	self protocolHolder value: protocols first.
	selectors := (self environment selectorsFor: protocols first
				in: (nonMeta ifTrue: [class] ifFalse: [class class])) asList.
	self selectorList list: selectors.
	selectors size == 1 ifFalse: 
			[^verticalBoolean
				ifTrue: [self class verticalProtocolWindowSpec]
				ifFalse: [self class protocolWindowSpec]].
	self selectorHolder value: selectors first.
	^verticalBoolean
		ifTrue: [self class verticalSelectorWindowSpec]
		ifFalse: [self class selectorWindowSpec]!

hardcopyStream: aStream
	Cursor wait showWhile: [aStream contents asText asParagraph hardcopy]!

sentSelectors
	| method |
	method := self selectedClass compiledMethodAt: self selector
				ifAbsent: [nil].
	method isNil ifTrue: [^#()].
	^method allSymbolLiterals asSortedCollection: [:a :b | a < b]! !

!BrowserNavigator methodsFor: 'category drag and drop'!

canAcceptDropInCategoryListFrom: aDC 
	^#(#category #class) includes: aDC key!

categoryDragEnter: aDragContext 
	(self canAcceptDropInCategoryListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	aDragContext dropTarget clientData: (self initialDropStateFor: #categoryList).
	^#dropEffectMove!

categoryDragOver: aDragContext 
	^(self canAcceptDropInCategoryListFrom: aDragContext)
		ifTrue: 
			[self showDropFeedbackForList: #categoryList in: aDragContext.
			(aDragContext sourceData clientData at: #category)
				== (self dropSelection: aDragContext)
				ifTrue: [#dropEffectNone]
				ifFalse: [#dropEffectMove]]
		ifFalse: [#dropEffectNone]!

categoryDrop: aDragContext 
	(self canAcceptDropInCategoryListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	^
	[| dropCategory |
	dropCategory := self dropSelection: aDragContext.
	dropCategory == (aDragContext sourceData clientData at: #category ifAbsent: [dropCategory])
		ifTrue: [#dropEffectNone]
		ifFalse: [aDragContext key == #class
				ifTrue: [self moveClassTo: dropCategory using: aDragContext sourceData clientData]
				ifFalse: [self moveCategoryTo: dropCategory using: aDragContext sourceData clientData]]]
		valueNowOrOnUnwindDo: 
			[self restoreListStateFrom: aDragContext clientData.
			aDragContext clientData: nil.
			self updateCategoryList]!

categoryWantToDrag: aController 
	^self category notNil!

doCategoryDrag: aController 
	self category isNil ifTrue: [^self].
	self doDragAndDrop: #category for: aController!

moveCategoryTo: dropCategory using: aDictionary 
	| categoryNames |
	categoryNames := self dropCategoriesFrom: aDictionary.
	categoryNames isEmpty ifTrue: [^#dropEffectNone].
	categoryNames do: 
			[:each | 
			dropCategory = each
				ifFalse: [Smalltalk organization addCategory: each before: dropCategory]].
	^#dropEffectMove!

moveClassTo: dropCategory using: aDictionary 
	| classNames |
	classNames := self dropClassNamesFrom: aDictionary.
	classNames isEmpty ifTrue: [^#dropEffectNone].
	classNames
		do: [:each | Smalltalk organization classify: each under: dropCategory].
	^#dropEffectMove! !

!BrowserNavigator methodsFor: 'class drag and drop'!

canAcceptDropInClassListFrom: aDC 
	^#(#protocol #selector) includes: aDC key!

canExtract: aDragContext 
	| dropClassName |
	dropClassName := self dropSelection: aDragContext.
	^dropClassName notNil and: 
			[dropClassName
				~~ (aDragContext sourceData clientData at: #class ifAbsent: [dropClassName])
					or: 
						[(aDragContext sourceData clientData at: #meta ifAbsent: [self isMeta])
							~~ self isMeta]]!

classDragEnter: aDragContext 
	(self canAcceptDropInClassListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	aDragContext dropTarget clientData: (self initialDropStateFor: #classList).
	^#dropEffectCopy!

classDragOver: aDragContext 
	^(self canAcceptDropInClassListFrom: aDragContext)
		ifTrue: 
			[self showDropFeedbackForList: #classList in: aDragContext.
			(self canExtract: aDragContext)
				ifTrue: [^#dropEffectCopy]
				ifFalse: [^#dropEffectNone]]
		ifFalse: [#dropEffectNone]!

classDrop: aDragContext 
	(self canAcceptDropInClassListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	^
	[| dropClassName |
	dropClassName := self dropSelection: aDragContext.
	(self canExtract: aDragContext)
		ifTrue: [aDragContext key == #selector
				ifTrue: [self dropSelectorIn: dropClassName using: aDragContext sourceData clientData]
				ifFalse: [self dropProtocolIn: dropClassName using: aDragContext sourceData clientData]]
		ifFalse: [#dropEffectNone]]
		valueNowOrOnUnwindDo: 
			[self restoreListStateFrom: aDragContext clientData.
			aDragContext clientData: nil.
			self updateCategoryList]!

classWantToDrag: aController 
	^self className notNil!

copySelector: each from: fromClass to: class classified: protocol 
	((class includesSelector: each)
		and: [(Dialog confirm: ('Do you want to replace <1s> in <2p>' expandMacrosWith: each with: class)) not])
		ifFalse: [class
				compile: (fromClass sourceCodeAt: each)
				classified: protocol
				notifying: nil]!

doClassDrag: aController 
	self className isNil ifTrue: [^self].
	self selectedClass isNil ifTrue: [^Dialog warn: ('Class <1s> no longer exists.' expandMacrosWith: self className)
			for: self interfaceWindow].
	self doDragAndDrop: #class for: aController!

dropProtocolIn: dropClassName using: aDictionary 
	| protocols fromClass meta class classNames |
	class := Smalltalk at: dropClassName ifAbsent: [nil].
	protocols := self dropProtocolsFrom: aDictionary.
	classNames := self dropClassNamesFrom: aDictionary.
	(protocols isEmpty or: [classNames size ~~ 1]) ifTrue: [^#dropEffectNone].
	fromClass := Smalltalk at: classNames first ifAbsent: [nil].
	meta := self dropMetaFrom: aDictionary.
	class isNil ifTrue: [^#dropEffectNone].
	meta ifTrue: [fromClass := fromClass class].
	self isMeta ifTrue: [class := class class].
	fromClass == class ifTrue: [^#dropEffectNone].
	protocols do: 
			[:each | 
			(fromClass organization listAtCategoryNamed: each) do: 
					[:sel | 
					self copySelector: sel
						from: fromClass
						to: class
						classified: each]].
	^#dropEffectCopy!

dropSelectorIn: dropClassName using: aDictionary 
	| selectors fromClass meta class classNames |
	class := Smalltalk at: dropClassName ifAbsent: [nil].
	selectors := self dropSelectorsFrom: aDictionary.
	classNames := self dropClassNamesFrom: aDictionary.
	(selectors isEmpty or: [classNames size ~~ 1]) ifTrue: [^#dropEffectNone].
	fromClass := Smalltalk at: classNames first ifAbsent: [nil].
	meta := self dropMetaFrom: aDictionary.
	fromClass isNil | class isNil ifTrue: [^#dropEffectNone].
	meta ifTrue: [fromClass := fromClass class].
	self isMeta ifTrue: [class := class class].
	selectors do: 
			[:each | 
			self copySelector: each
				from: fromClass
				to: class
				classified: (fromClass whichCategoryIncludesSelector: each)].
	^#dropEffectCopy! !

!BrowserNavigator methodsFor: 'protocol drag and drop'!

canAcceptDropInProtocolListFrom: aDC 
	^#(#selector #protocol) includes: aDC key!

canDropInProtocol: aDC 
	| aDict |
	aDict := aDC sourceData clientData.
	^(aDC key == #selector and: [(aDict at: #protocol ifAbsent: [self dropSelection: aDC])
			~~ (self dropSelection: aDC) or: [(aDict at: #class ifAbsent: [self className])
				~~ self className or: [(aDict at: #meta ifAbsent: [self isMeta])
					~~ self isMeta]]])
		or: [aDC key == #protocol and: [(aDict at: #protocol ifAbsent: [self dropSelection: aDC])
					~~ (self dropSelection: aDC) and: [(aDict at: #class ifAbsent: [nil])
						== self className and: [(aDict at: #meta ifAbsent: [nil])
							== self isMeta]]]]!

doProtocolDrag: aController 
	self protocol notNil ifTrue: [self doDragAndDrop: #protocol for: aController]!

dropProtocolUsing: aDragContext 
	| dataProtocols protocol |
	dataProtocols := self dropProtocolsFrom: aDragContext sourceData clientData.
	protocol := self dropSelection: aDragContext.
	dataProtocols isEmpty | protocol isNil ifTrue: [^#dropEffectNone].
	dataProtocols do: 
			[:each | 
			each == protocol ifFalse: 
					[self addProtocol: each
						before: protocol
						for: self selectedClass]].
	^#dropEffectMove!

dropSelectorUsing: aDragContext 
	| dataClass protocol dataSelectors classNames |
	dataSelectors := self dropSelectorsFrom: aDragContext sourceData clientData.
	classNames := self dropClassNamesFrom: aDragContext sourceData clientData.
	(dataSelectors isEmpty or: [classNames size ~~ 1])
		ifTrue: [^#dropEffectNone].
	dataClass := Smalltalk at: classNames first ifAbsent: [nil].
	protocol := self dropSelection: aDragContext.
	(dataClass isNil | protocol isNil or: [self changeRequest])
		ifFalse: [^#dropEffectNone].
	(self dropMetaFrom: aDragContext sourceData clientData)
		ifTrue: [dataClass := dataClass class].
	dataSelectors do: 
			[:each | 
			dataClass == self selectedClass
				ifTrue: 
					[self moveMethod: each
						to: protocol
						in: dataClass]
				ifFalse: 
					[self moveMethod: each
						to: ('<1p>><2s>' expandMacrosWith: self selectedClass with: protocol)
						in: dataClass]].
	^dataClass == self selectedClass
		ifTrue: [#dropEffectMove]
		ifFalse: [#dropEffectCopy]!

protocolDragEnter: aDragContext 
	(self canAcceptDropInProtocolListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	aDragContext dropTarget clientData: (self initialDropStateFor: #protocolList).
	^#dropEffectMove!

protocolDragOver: aDragContext 
	^(self canAcceptDropInProtocolListFrom: aDragContext)
		ifTrue: 
			[self showDropFeedbackForList: #protocolList in: aDragContext.
			(self canDropInProtocol: aDragContext)
				ifTrue: 
					[((aDragContext sourceData clientData at: #class ifAbsent: [self className])
						== self className and: 
								[(aDragContext sourceData clientData at: #meta ifAbsent: [self isMeta])
									== self isMeta])
						ifTrue: [#dropEffectMove]
						ifFalse: [#dropEffectCopy]]
				ifFalse: [#dropEffectNone]]
		ifFalse: [#dropEffectNone]!

protocolDrop: aDragContext 
	(self canAcceptDropInProtocolListFrom: aDragContext)
		ifFalse: [^#dropEffectNone].
	^[aDragContext key == #protocol
		ifTrue: [self dropProtocolUsing: aDragContext]
		ifFalse: [self dropSelectorUsing: aDragContext]]
		valueNowOrOnUnwindDo: 
			[self restoreListStateFrom: aDragContext clientData.
			aDragContext clientData: nil.
			self updateCategoryList]!

protocolWantToDrag: aController 
	^self protocol notNil! !

!BrowserNavigator methodsFor: 'selector drag and drop'!

doSelectorDrag: aController 
	self selector isNil ifTrue: [^self].
	(self selectedClass includesSelector: self selector)
		ifFalse: [^Dialog warn: ('Selector <1s> no longer exists.' expandMacrosWith: self selector)
				for: self interfaceWindow].
	self doDragAndDrop: #selector for: aController!

selectorWantToDrag: aController 
	^self selector notNil! !

!BrowserNavigator methodsFor: 'drag and drop support'!

doDragAndDrop: aSymbol for: aController 
	| ds dm data |
	data := DragDropData new.
	data key: aSymbol.
	data contextWindow: self builder window.
	data contextWidget: aController view.
	data contextApplication: self.
	data clientData: IdentityDictionary new.
	data clientData at: #navigatorState put: self getState.
	data clientData at: #selector put: self selector.
	data clientData at: #class put: self className.
	data clientData at: #protocol put: self protocol.
	data clientData at: #meta put: self isMeta.
	data clientData at: #category put: self category.
	ds := DropSource new.
	dm := DragDropManager withDropSource: ds withData: data.
	dm doDragDrop!

dragLeave: aDragContext 
	self restoreListStateFrom: aDragContext dropTarget clientData.
	aDragContext dropTarget clientData: nil.
	^#dropEffectNone!

dropCategoriesFrom: aDictionary 
	| state categoryName |
	state := aDictionary at: #navigatorState ifAbsent: [nil].
	^state isNil
		ifTrue: 
			[categoryName := aDictionary at: #category ifAbsent: [nil].
			categoryName isNil ifTrue: [#()] ifFalse: [Array with: categoryName]]
		ifFalse: [state categories]!

dropClassNamesFrom: aDictionary 
	| state className |
	state := aDictionary at: #navigatorState ifAbsent: [nil].
	^state isNil
		ifTrue: 
			[className := aDictionary at: #class ifAbsent: [nil].
			className isNil ifTrue: [#()] ifFalse: [Array with: className]]
		ifFalse: [state classNames]!

dropMetaFrom: aDictionary 
	| state |
	state := aDictionary at: #navigatorState ifAbsent: [nil].
	^state isNil
		ifTrue: [aDictionary at: #meta ifAbsent: [false]]
		ifFalse: [state isMeta]!

dropProtocolsFrom: aDictionary 
	| state protocol |
	state := aDictionary at: #navigatorState ifAbsent: [nil].
	^state isNil
		ifTrue: 
			[protocol := aDictionary at: #protocol ifAbsent: [nil].
			protocol isNil ifTrue: [#()] ifFalse: [Array with: protocol]]
		ifFalse: [state protocols]!

dropSelection: aDragContext 
	| controller index |
	controller := aDragContext clientData at: #controller.
	index := controller view targetIndex.
	index == 0 ifTrue: [^nil].
	^controller view sequence at: index!

dropSelectorsFrom: aDictionary 
	| state selector |
	state := aDictionary at: #navigatorState ifAbsent: [nil].
	^state isNil
		ifTrue: 
			[selector := aDictionary at: #selector ifAbsent: [nil].
			selector isNil ifTrue: [#()] ifFalse: [Array with: selector]]
		ifFalse: [state selectors]!

initialDropStateFor: aSymbol 
	| dict controller component |
	component := self builder componentAt: aSymbol.
	component isNil ifTrue: [^nil].
	controller := component widget controller.
	dict := IdentityDictionary new.
	dict at: #controller put: controller.
	dict at: #targetIndex put: controller view targetIndex.
	dict at: #hasFocus put: controller view hasFocus.
	controller view hasFocus: true.
	^dict!

restoreListStateFrom: aDictionary 
	| controller |
	aDictionary isNil ifTrue: [^self].
	controller := aDictionary at: #controller.
	controller view targetIndex: (aDictionary at: #targetIndex).
	controller view hasFocus: (aDictionary at: #hasFocus)!

showDropFeedbackForList: aSymbol in: aDragContext 
	| component |
	component := self builder componentAt: aSymbol.
	component notNil ifTrue: [component widget showDropFeedbackIn: aDragContext allowScrolling: true]! !

!BrowserNavigator methodsFor: 'change management'!

logProtocolChange: aString
	"Add aString, which is an executable account of the last protocol change (rename,
	remove, selector move) to the changes file."

	SourceFileManager default logChange: aString! !

!BrowserNavigator methodsFor: 'private-querying'!

selectSubclassesOf: aClass 
	| subclasses |
	subclasses := aClass subclasses asSortedCollection: [:a :b | a name < b name].
	subclasses isEmpty ifTrue: [^#()].
	^SimpleDialog new
		chooseMultiple: 'Choose subclasses:'
		fromList: subclasses
		values: subclasses
		buttons: #()
		values: #()
		lines: 8
		cancel: [nil]! !

BrowserNavigator class
	instanceVariableNames: ''!



!BrowserNavigator class methodsFor: 'instance creation'!

on: aBrowser
	^self new on: aBrowser! !

!BrowserNavigator class methodsFor: 'resources'!

categoryMenu
	"UIMenuEditor new openOnClass: self andSelector: #categoryMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem
				#label: 'file out as...'
				#accessCharacterPosition: 6 )
			#(#MenuItem
				#label: 'hardcopy'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'spawn'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'add...'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'rename as...'
				#accessCharacterPosition: 3 )
			#(#MenuItem
				#label: 'remove...'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'update'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'find class...'
				#accessCharacterPosition: 1 ) ) #(3 3 1 1 ) #(#fileOutCategory #hardcopyCategory #spawnCategory #addCategory #renameCategory #removeCategory #updateCategoryList #findClass ) ) decodeAsLiteralArray!

classMenu
	"MenuEditor new openOnClass: self andSelector: #classMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'file &out as...' 
				#value: #fileOutClass ) 
			#(#MenuItem 
				#rawLabel: '&hardcopy' 
				#value: #printOutClass ) 
			#(#MenuItem 
				#rawLabel: '&spawn' 
				#value: #spawnClass ) 
			#(#MenuItem 
				#rawLabel: 'spawn &hierarchy...' 
				#value: #spawnHierarchy ) 
			#(#MenuItem 
				#rawLabel: '&class' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 're&ferences...' 
							#value: #classRefs ) 
						#(#MenuItem 
							#rawLabel: '&create subclass...' 
							#value: #createSubclass ) 
						#(#MenuItem 
							#rawLabel: 're&name as...' 
							#value: #renameClass ) 
						#(#MenuItem 
							#rawLabel: '&remove...' 
							#value: #removeClass ) 
						#(#MenuItem 
							#rawLabel: '&safe remove' 
							#value: #removeClassSafe ) 
						#(#MenuItem 
							#rawLabel: '&move to...' 
							#value: #changeClassCategory ) 
						#(#MenuItem 
							#rawLabel: '&other' 
							#submenu: #(#Menu #(
									#(#MenuItem 
										#rawLabel: '&convert to sibling' 
										#nameKey: #convertToSibling 
										#value: #convertToSibling ) 
									#(#MenuItem 
										#rawLabel: '&inspect all instances...' 
										#value: #inspectAllInstances ) 
									#(#MenuItem 
										#rawLabel: 'find &reference path to an instance...' 
										#value: #findReferencePathToInstance ) 
									#(#MenuItem 
										#rawLabel: 'find all reference path&s to an instance...' 
										#value: #findAllReferencesToInstances ) 
									#(#MenuItem 
										#rawLabel: 'check &protocols...' 
										#value: #checkProtocols ) ) #(1 4 ) nil ) ) ) #(1 4 1 1 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&instance variables' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 're&ferences...' 
							#value: #instVarRefs ) 
						#(#MenuItem 
							#rawLabel: 'readers...' 
							#nameKey: #readers 
							#value: #instVarReaders ) 
						#(#MenuItem 
							#rawLabel: 'writers...' 
							#nameKey: #writers 
							#value: #instVarWriters ) 
						#(#MenuItem 
							#rawLabel: '&add...' 
							#value: #addInstVar ) 
						#(#MenuItem 
							#rawLabel: 're&name as...' 
							#value: #renameInstVar ) 
						#(#MenuItem 
							#rawLabel: '&remove...' 
							#value: #removeInstVar ) 
						#(#MenuItem 
							#rawLabel: 'push &down...' 
							#value: #pushDownInstVar ) 
						#(#MenuItem 
							#rawLabel: 'pull &up...' 
							#value: #pullUpInstVar ) 
						#(#MenuItem 
							#rawLabel: '&create accessors...' 
							#value: #createInstVarAccessors ) 
						#(#MenuItem 
							#rawLabel: 'a&bstract...' 
							#value: #abstractInstVar ) 
						#(#MenuItem 
							#rawLabel: 'protect/concrete...' 
							#value: #protectInstVar ) 
						#(#MenuItem 
							#rawLabel: 'convert to &value holder...' 
							#value: #valueHolderInstVar ) ) #(3 3 2 4 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: 'class &variables' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 're&ferences...' 
							#value: #classVarRefs ) 
						#(#MenuItem 
							#rawLabel: '&add...' 
							#value: #addClassVar ) 
						#(#MenuItem 
							#rawLabel: 're&name as...' 
							#value: #renameClassVar ) 
						#(#MenuItem 
							#rawLabel: '&remove...' 
							#value: #removeClassVar ) 
						#(#MenuItem 
							#rawLabel: 'push &down...' 
							#value: #pushDownClassVar ) 
						#(#MenuItem 
							#rawLabel: 'pull &up...' 
							#value: #pullUpClassVar ) 
						#(#MenuItem 
							#rawLabel: '&create accessors...' 
							#value: #createClassVarAccessors ) 
						#(#MenuItem 
							#rawLabel: 'a&bstract...' 
							#value: #abstractClassVar ) ) #(1 3 2 2 ) nil ) ) ) #(4 3 ) nil ) decodeAsLiteralArray!

protocolMenu
	"UIMenuEditor new openOnClass: self andSelector: #protocolMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem
				#label: 'file out as...'
				#accessCharacterPosition: 6 )
			#(#MenuItem
				#label: 'hardcopy'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'spawn'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'add...'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'rename as...'
				#accessCharacterPosition: 3 )
			#(#MenuItem
				#label: 'remove...'
				#accessCharacterPosition: 1 )
			#(#MenuItem
				#label: 'find method...'
				#accessCharacterPosition: 1 ) ) #(3 3 1 ) #(#fileOutProtocol #printOutProtocol #spawnProtocol #addProtocol #renameProtocol #removeProtocol #findMethodAndSelectAlphabetic ) ) decodeAsLiteralArray!

selectorMenu
	"MenuEditor new openOnClass: self andSelector: #selectorMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&move' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'to &protocol...' 
							#value: #moveMethod ) 
						#(#MenuItem 
							#rawLabel: 'to &component...' 
							#value: #moveMethodToOtherObject ) ) #(2 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: 're&name...' 
				#value: #renameMethod ) 
			#(#MenuItem 
				#rawLabel: '&remove...' 
				#value: #removeMethod ) 
			#(#MenuItem 
				#rawLabel: 's&afe remove' 
				#value: #removeMethodSafe ) 
			#(#MenuItem 
				#rawLabel: 'other' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'file &out as...' 
							#value: #fileOutMessage ) 
						#(#MenuItem 
							#rawLabel: '&hardcopy' 
							#value: #printOutMessage ) 
						#(#MenuItem 
							#rawLabel: '&spawn' 
							#value: #spawnMethod ) 
						#(#MenuItem 
							#rawLabel: 'add parameter...' 
							#value: #addParameter ) 
						#(#MenuItem 
							#rawLabel: '&inline all self sends' 
							#value: #inlineSelfSends ) 
						#(#MenuItem 
							#rawLabel: 'push &up' 
							#nameKey: #pushUpSelector 
							#value: #pushUpSelector ) 
						#(#MenuItem 
							#rawLabel: 'push do&wn' 
							#nameKey: #pushDownSelector 
							#value: #pushDownSelector ) ) #(3 2 2 ) nil ) ) ) #(4 1 ) nil ) decodeAsLiteralArray! !

!BrowserNavigator class methodsFor: 'class initialization'!

initialize
	"self initialize"

	LastMoveMethodProtocol := ''! !

!BrowserNavigator class methodsFor: 'interface specs'!

categoryWindowSpec
	"UIPainter new openOnClass: self andSelector: #categoryWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 237 591 825 742 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dragOverSelector 
						#classDragOver: #dragStartSelector 
						#doClassDrag: #dropSelector 
						#classDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 27 0 -1 0.333333 -25 1 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dragOverSelector 
						#protocolDragOver: #dragStartSelector 
						#doProtocolDrag: #dropSelector 
						#protocolDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 1 0.333333 2 0 -1 0.666666 -2 1 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 1 0.666666 2 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -23 1 0 0.166667 -3 1 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.166667 -23 1 -22 0.333333 -3 1 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.333333 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 1 -1 0.333333 -2 1 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 0.333333 -23 1 -2 0.333333 -3 1 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

classWindowSpec
	"UIPainter new openOnClass: self andSelector: #classWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 219 330 807 481 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#DividerSpec 
					#layout: #(#LayoutFrame 0 0 52 0 0 1 53 0 ) ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 1 0.5 27 0 -2 1 50 0 ) ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.5 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 1 0.5 2 0 -2 1 25 0 ) 
					#name: #classHolder 
					#model: #classHolder 
					#menu: #classMenu 
					#isReadOnly: true ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 28 0 -1 0.75 49 0 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 1 0.75 28 0 -22 1 49 0 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dragOverSelector 
						#protocolDragOver: #dragStartSelector 
						#doProtocolDrag: #dropSelector 
						#protocolDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 54 0 -1 0.5 -2 1 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 1 0.5 54 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 28 0 -2 1 49 0 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' 
					#isDefault: false ) ) ) )!

protocolWindowSpec
	"UIPainter new openOnClass: self andSelector: #protocolWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 607 382 1195 533 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.5 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 27 0 -1 0.5 52 0 ) 
					#name: #classHolder 
					#model: #classNameHolder 
					#menu: #classMenu 
					#isReadOnly: true 
					#type: #object ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 54 0 -1 0.5 79 0 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 1 0.5 2 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )!

selectorWindowSpec
	"UIPainter new openOnClass: self andSelector: #selectorWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 226 306 814 457 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 -1 0.25 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.25 -2 1 -1 0.5 ) 
					#name: #classHolder 
					#model: #classNameHolder 
					#menu: #classMenu 
					#isReadOnly: true 
					#type: #object ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.5 -2 1 -1 0.75 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.75 -2 1 -2 1 ) 
					#name: #selectorHolder 
					#model: #selectorHolder 
					#menu: #selectorMenu 
					#isReadOnly: true ) ) ) )!

verticalCategoryWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalCategoryWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 312 318 531 798 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dragOverSelector 
						#classDragOver: #dragStartSelector 
						#doClassDrag: #dropSelector 
						#classDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 27 0 -2 1 -25 0.333333 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dragOverSelector 
						#protocolDragOver: #dragStartSelector 
						#doProtocolDrag: #dropSelector 
						#protocolDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 1 0.333333 -2 1 -1 0.666666 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 1 0.666666 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -23 0.333333 0 0.5 -2 0.333333 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -23 0.333333 -22 1 -2 0.333333 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 0.333333 -2 1 -1 0.333333 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 -23 0.333333 -2 1 -3 0.333333 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

verticalClassWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalClassWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 326 286 546 766 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 27 0 -2 1 52 0 ) 
					#name: #classHolder 
					#model: #classHolder 
					#menu: #classMenu 
					#isReadOnly: true ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 54 0 -2 1 78 0 ) ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0 55 0 -1 0.5 77 0 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 1 0.5 55 0 -22 1 77 0 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dragOverSelector 
						#protocolDragOver: #dragStartSelector 
						#doProtocolDrag: #dropSelector 
						#protocolDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 80 0 -2 1 39 0.5 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 41 0.5 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 55 0 -2 1 77 0 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

verticalProtocolWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalProtocolWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 766 345 964 725 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 25 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true 
					#type: #string ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 27 0 -2 1 52 0 ) 
					#name: #classHolder 
					#model: #classNameHolder 
					#menu: #classMenu 
					#isReadOnly: true 
					#type: #object ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 54 0 -2 1 79 0 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 81 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) ) ) )!

verticalSelectorWindowSpec
	^self selectorWindowSpec! !

BrowserNavigator subclass: #SystemNavigator
	instanceVariableNames: 'hierarchy viewCategory hierarchyClass '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

SystemNavigator comment:
'SystemNavigator is the navigator used by the browser to browse the whole system (or something that has multiple categories, classes, etc.).

Instance Variables:
	hierarchy	<SelectionInList on: Behavior>	the hierarchy list of classes
	hierarchyClass	<Behavior>	which class is the hierarchy list for, it is displayed in bold
	viewCategory	<ValueHolder on: Symbol>	are we viewing a category or hierarchy?'!


!SystemNavigator methodsFor: 'initialize-release'!

initialize
	super initialize.
	self viewCategory value: true! !

!SystemNavigator methodsFor: 'accessing'!

beHierarchy
	self viewCategory value: false.
	self changedViewCategory! !

!SystemNavigator methodsFor: 'accessing-category'!

changedViewCategory
	self viewCategory value
		ifTrue:
			[self updateClassCategory.
			self showAll: #(#categoryList #classList).
			self hide: #hierarchy]
		ifFalse:
			[self updateHierarchy.
			self show: #hierarchy.
			self hideAll: #(#categoryList #classList)]!

updateClassCategory
	| classes |
	hierarchyClass isNil ifTrue: [^self].
	hierarchyClass := nil.
	classes := self hierarchy selections collect: [:each | each name].
	classes isEmpty ifTrue: [^self newClassList: #()].
	self selectClasses: classes
		meta: self isMeta
		categories: #()!

updateHierarchy
	| names |
	names := self classList selections.
	names isEmpty
		ifTrue: 
			[self updateHierarchyFor: #Object.
			self hierarchy selections: #().
			^self].
	self updateHierarchyFor: (names detect: [:each | true] ifNone: [nil])! !

!SystemNavigator methodsFor: 'accessing-class'!

classNames
	^self viewCategory value
		ifTrue: [super classNames]
		ifFalse: [self hierarchy selections collect: [:each | each name]]!

newClassListNoUpdate: initialSelection 
	super newClassListNoUpdate: initialSelection.
	self isHierarchy ifTrue: [self updateHierarchy]!

selectClass: aClass 
	| newClass |
	super selectClass: aClass.
	self isHierarchy ifFalse: [^self].
	newClass := aClass isMeta ifTrue: [aClass soleInstance] ifFalse: [aClass].
	self updateHierarchyFor: newClass name! !

!SystemNavigator methodsFor: 'testing'!

isHierarchy
	^self viewCategory value not! !

!SystemNavigator methodsFor: 'menu'!

hierarchyMenu
	^self classMenu! !

!SystemNavigator methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	| block |
	super postBuildWith: aBuilder.
	self postBuildWidget: #hierarchy.
	self newCategoryList: #().
	block := 
			[:view :index | 
			| each string |
			each := view sequence at: index.
			string := each name.
			each == hierarchyClass ifTrue: [string := string asText allBold].
			Label with: string
				attributes: view textStyle
				offset: ((self numSuperclasses: each) * 10) @ 0].
	((builder componentAt: #hierarchy) widget)
		visualBlock: (self createVisualBlockFrom: block);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: block)! !

!SystemNavigator methodsFor: 'aspects'!

hierarchy
	^hierarchy isNil
		ifTrue: [hierarchy := BRMultiSelectionInList new]
		ifFalse: [hierarchy]!

viewCategory
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^viewCategory isNil
		ifTrue:
			[viewCategory := nil asValue]
		ifFalse:
			[viewCategory]! !

!SystemNavigator methodsFor: 'private-class'!

commonSuperclassOf: classCollection 
	classCollection isEmpty ifTrue: [^Object].
	^classCollection inject: classCollection first
		into: 
			[:root :each | 
			(self rootOf: root) == (self rootOf: each)
				ifTrue: [root commonSuperclass: each]
				ifFalse: [^nil]]!

rootOf: aClass 
	| class |
	class := aClass.
	[class superclass isNil] whileFalse: [class := class superclass].
	^class!

selectClasses: classNames meta: aBoolean categories: categoryNames 
	| classes rootClass |
	super selectClasses: classNames
		meta: aBoolean
		categories: categoryNames.
	self isHierarchy ifFalse: [^self].
	classes := classNames collect: [:each | Smalltalk at: each ifAbsent: [Object]].
	rootClass := self commonSuperclassOf: classes.
	rootClass isNil ifTrue: 
			[self viewCategory value: true.
			^self selectClasses: classNames
				meta: aBoolean
				categories: categoryNames].
	self meta: aBoolean.
	self updateHierarchyFor: rootClass name.
	self hierarchy selections: classes! !

!SystemNavigator methodsFor: 'private'!

addSubclassesFor: aClass to: aList 
	(aClass subclasses asSortedCollection: [:a :b | a name < b name]) do: 
			[:each | 
			each isMeta ifFalse: 
					[aList add: each.
					self addSubclassesFor: each to: aList]]!

getSpec: verticalBoolean 
	^verticalBoolean
		ifTrue: [self class verticalWindowSpec]
		ifFalse: [self class windowSpec]!

numSuperclasses: aClass 
	| i class |
	i := 0.
	class := aClass.
	[(class := class superclass) isNil]
		whileFalse: [i := i + 1].
	^i!

updateHierarchyFor: aClassName 
	| list class |
	class := Smalltalk at: aClassName ifAbsent: [Object].
	hierarchyClass := class.
	list := class withAllSuperclasses reverse.
	self addSubclassesFor: class to: list.
	(self hierarchy) list: list asList;
		selections: (Array with: class)! !

!SystemNavigator methodsFor: 'category drag and drop'!

canAcceptDropInCategoryListFrom: aDC 
	^(super canAcceptDropInCategoryListFrom: aDC) 
		and: [self viewCategory value]! !

!SystemNavigator methodsFor: 'class drag and drop'!

canAcceptDropInClassListFrom: aDC 
	^(super canAcceptDropInClassListFrom: aDC) and: [self viewCategory value]! !

SystemNavigator class
	instanceVariableNames: ''!



!SystemNavigator class methodsFor: 'interface specs'!

verticalWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 436 380 624 861 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 3 0 0 0.5 22 0 ) 
					#name: #viewCategory 
					#model: #viewCategory 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedViewCategory ) 
					#label: 'category' 
					#select: true ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 3 0 -3 1 22 0 ) 
					#name: #viewCategory 
					#model: #viewCategory 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedViewCategory ) 
					#label: 'hierarchy' 
					#select: false ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doClassDrag: #dragOkSelector 
						#classWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 25 0 -2 1 -25 0.5 ) 
					#name: #hierarchy 
					#flags: 29 
					#model: #hierarchy 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#doubleClickSelector: #updateCategoryList 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #hierarchyMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#categoryWantToDrag: #dragEnterSelector 
						#categoryDragEnter: #dragOverSelector 
						#categoryDragOver: #dragStartSelector 
						#doCategoryDrag: #dropSelector 
						#categoryDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 25 0 -2 1 -1 0.25 ) 
					#name: #categoryList 
					#model: #categoryList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedCategory 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #categoryMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dragOverSelector 
						#classDragOver: #dragStartSelector 
						#doClassDrag: #dropSelector 
						#classDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 1 0.25 -2 1 -25 0.5 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -22 0.5 0 0.5 -1 0.5 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -22 0.5 -22 1 -1 0.5 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dragOverSelector 
						#protocolDragOver: #dragStartSelector 
						#doProtocolDrag: #dropSelector 
						#protocolDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 1 0.5 -2 1 -1 0.75 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 1 0.75 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 23 0 ) ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 0.5 -2 1 -1 0.5 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 -23 0.5 -2 1 -3 0.5 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 283 329 871 480 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doClassDrag: #dragOkSelector 
						#classWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.5 -25 1 ) 
					#name: #hierarchy 
					#flags: 29 
					#model: #hierarchy 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#doubleClickSelector: #updateCategoryList 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #hierarchyMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 1 -1 0.25 -2 1 ) ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 1 0.25 -23 1 -1 0.5 -2 1 ) ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#categoryWantToDrag: #dragEnterSelector 
						#categoryDragEnter: #dropSelector 
						#categoryDrop: #dragStartSelector 
						#doCategoryDrag: #dragOverSelector 
						#categoryDragOver: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.25 -25 1 ) 
					#name: #categoryList 
					#model: #categoryList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedCategory 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #categoryMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -23 1 0 0.125 -3 1 ) 
					#name: #viewCategory 
					#model: #viewCategory 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedViewCategory ) 
					#label: 'category' 
					#select: true ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.125 -23 1 -2 0.25 -3 1 ) 
					#name: #viewCategory 
					#model: #viewCategory 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedViewCategory ) 
					#label: 'hierarchy' 
					#select: false ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dropSelector 
						#classDrop: #dragStartSelector 
						#doClassDrag: #dragOverSelector 
						#classDragOver: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 1 0.25 2 0 -1 0.5 -25 1 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.25 -23 1 0 0.375 -3 1 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.375 -23 1 -22 0.5 -3 1 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#protocolWantToDrag: #dragEnterSelector 
						#protocolDragEnter: #dropSelector 
						#protocolDrop: #dragStartSelector 
						#doProtocolDrag: #dragOverSelector 
						#protocolDragOver: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 1 0.5 2 0 -1 0.75 -2 1 ) 
					#name: #protocolList 
					#model: #protocolList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedProtocol 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 1 0.75 2 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 0.5 -23 1 -2 0.5 -3 1 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )! !

CodeTool subclass: #IconViewer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

IconViewer comment:
'IconViewer is a simple CodeTool that displayes images/icons. When a method for an icon is selected, this will display the icon instead of the text for the icon.'!


!IconViewer methodsFor: 'updating'!

updateContents
	| image |
	self selectedClass isNil ifTrue: [^self].
	(self selectedClass isMeta & self selector notNil and: 
			[(self selectedClass compiledMethodAt: self selector) resourceType = #image
				& (self selector numArgs = 0) and: 
						[image := self errorSignal handle: [:ex | ex returnWith: nil]
									do: [self nonMetaClass perform: self selector].
						image isKindOf: PixelArray]])
		ifTrue: [(builder componentAt: #icon) widget label: image]
		ifFalse: [(builder componentAt: #icon) widget label: nil]! !

!IconViewer methodsFor: 'interface opening'!

postBuildWith: aBuilder
	super postBuildWith: aBuilder.
	self updateContents! !

IconViewer class
	instanceVariableNames: ''!



!IconViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Unlabeled Canvas'
			#bounds: #(#Rectangle 416 282 857 674 ) )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#LabelSpec
					#layout: #(#Point 1 1 )
					#name: #icon
					#hasCharacterOrientedLabel: false )
				#(#GroupBoxSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) ) ) ) )! !

CodeTool subclass: #ClassNavigatorTool
	instanceVariableNames: 'currentSubcanvas subcanvas '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

ClassNavigatorTool comment:
'ClassNavigatorTool is a code tool that is used to browse classes. It has radio buttons to switch between different aspects of class properties (definition, comment, etc.). When a radio button is pressed, it switches its subcanvas to the tool specified by the radio button.

Instance Variables:
	currentSubcanvas	<ValueHolder on: Symbol>	which radio button is selected
	subcanvas	<CodeTool>	the specific tool for the selected radio button'!


!ClassNavigatorTool methodsFor: 'initialize-release'!

codeModel: aCodeModel 
	super codeModel: aCodeModel.
	subcanvas := self class classDefinitionToolClass codeModel: codeModel!

initialize
	super initialize.
	self currentSubcanvas value: #definition!

release
	subcanvas release.
	super release! !

!ClassNavigatorTool methodsFor: 'accessing'!

menu
	| menu |
	menu := Menu new.
	#(#definition #comment #hierarchy #organization)
		do: 
			[:each | 
			| menuItem |
			menuItem := MenuItem labeled: '&' , each asString.
			currentSubcanvas value == each
				ifTrue: [menuItem beOn]
				ifFalse: [menuItem beOff].
			menu addItem: menuItem value: [self updateRequest
					ifTrue: 
						[currentSubcanvas value: each.
						self updateContents]]].
	menu addItemGroup: (Array with: ((MenuItem labeled: 'too&l')
				submenu: subcanvas menu)).
	^menu! !

!ClassNavigatorTool methodsFor: 'updating'!

updateContents
	| selection |
	selection := self currentSubcanvas value.
	selection == #definition ifTrue: [self definitionSubcanvas].
	selection == #comment ifTrue: [self commentSubcanvas].
	selection == #hierarchy ifTrue: [self hierarchySubcanvas].
	selection == #organization ifTrue: [self organizationSubcanvas]! !

!ClassNavigatorTool methodsFor: 'interface opening'!

preBuildWith: aBuilder
	aBuilder subCanvasAt: #classTool at: #windowSpec put: (subcanvas class windowSpec).
	^super preBuildWith: aBuilder! !

!ClassNavigatorTool methodsFor: 'aspects'!

currentSubcanvas
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^currentSubcanvas isNil
		ifTrue:
			[currentSubcanvas := nil asValue]
		ifFalse:
			[currentSubcanvas]! !

!ClassNavigatorTool methodsFor: 'private'!

commentSubcanvas
	self createSubcanvasWith: self class classCommentToolClass!

createSubcanvasWith: aClass 
	(subcanvas isNil or: [subcanvas class ~~ aClass])
		& codeModel notNil & (builder notNil and: [(builder componentAt: #subcanvas) topComponent notNil])
		ifTrue: 
			[subcanvas := aClass on: codeModel.
			self installSubcanvasIn: #subcanvas using: subcanvas].
	subcanvas notNil ifTrue: [subcanvas updateContents]!

definitionSubcanvas
	self createSubcanvasWith: self class classDefinitionToolClass!

hierarchySubcanvas
	codeModel notNil & (builder notNil and: [(builder componentAt: #subcanvas) topComponent notNil])
		ifTrue: 
			[subcanvas := OMTClassTool on: codeModel.
			self installSubcanvasIn: #subcanvas using: subcanvas].
	subcanvas notNil ifTrue: [subcanvas updateContents]!

organizationSubcanvas
	self createSubcanvasWith: self class organizationToolClass!

subcanvas
	^subcanvas!

subcanvases
	^(OrderedCollection withAll: super subcanvases)
		add: self subcanvas; yourself! !

ClassNavigatorTool class
	instanceVariableNames: ''!



!ClassNavigatorTool class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Class Tool' 
			#bounds: #(#Rectangle 138 184 696 643 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#RadioButtonSpec 
					#layout: #(#Point 5 0 ) 
					#model: #currentSubcanvas 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #definitionSubcanvas 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'definition' 
					#select: #definition ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 0 0 0.333333 0 ) 
					#model: #currentSubcanvas 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #commentSubcanvas 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'comment' 
					#select: #comment ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 0 0 0.666666 0 ) 
					#model: #currentSubcanvas 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #hierarchySubcanvas 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'hierarchy' 
					#select: #hierarchy ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 23 0 0 1 0 1 ) 
					#name: #subcanvas 
					#flags: 0 
					#majorKey: #classTool 
					#minorKey: #windowSpec 
					#clientKey: #subcanvas ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -5 1 0 0 1 0 ) 
					#name: #organization 
					#model: #currentSubcanvas 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #organizationSubcanvas 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'organization' 
					#select: #organization ) ) ) )! !

!ClassNavigatorTool class methodsFor: 'accessing'!

classCommentToolClass
	^ClassCommentTool!

classDefinitionToolClass
	^BrowserClassTool!

organizationToolClass
	^OrganizationEditor! !

CodeTool subclass: #ResourceTool
	instanceVariableNames: 'subcanvas visual '
	classVariableNames: 'OpenTypes ResourceEditors ResourceViewers '
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

ResourceTool comment:
'ResourceTool is the CodeTool that is used to edit resouce methods (e.g., menu methods). From the ResourceTool you can launch the specific editor for the resource or view the method either graphically or textually.

Instance Variables:
	subcanvas	<CodeTool> contains the specific viewer for the method or a BrowserCodeTool
	visual	<ValueHolder on: Boolean> should the method be displayed textually or visually

Class Variables:
	OpenTypes	<Collection of: Symbol>	the resource types are openable
	ResourceEditors	<Dictionary key: Symbol value: Symbol> maps the method resource type to the VW editor''s class name for that resource type
	ResourceViewers	<Dictionary key: Symbol value: CodeTool class> maps the method resource type to a specific CodeTool for that resource type'!


!ResourceTool methodsFor: 'initialize-release'!

codeModel: aCodeModel 
	super codeModel: aCodeModel.
	self createSubcanvas!

initialize
	super initialize.
	self visual value: true.
	self visual onChangeSend: #changedVisual to: self!

release
	self visual retractInterestsFor: self.
	subcanvas release.
	super release! !

!ResourceTool methodsFor: 'accessing'!

menu
	| menu visualItem textItem |
	menu := Menu new.
	visualItem := MenuItem labeled: '&visual'.
	textItem := MenuItem labeled: '&text'.
	visual value
		ifTrue: 
			[visualItem beOn.
			textItem beOff]
		ifFalse: 
			[visualItem beOff.
			textItem beOn].
	menu addItem: visualItem value: [self updateRequest ifTrue: [self visual value: true]].
	menu addItem: textItem value: [self updateRequest ifTrue: [self visual value: false]].
	menu addItemGroup: (Array with: ((MenuItem labeled: 'too&l')
				submenu: subcanvas menu)).
	^menu!

method
	| selector class |
	selector := self selector.
	class := self selectedClass.
	^selector notNil
		ifTrue: [class compiledMethodAt: selector ifAbsent: [nil]]
		ifFalse: [nil]! !

!ResourceTool methodsFor: 'actions'!

editSpec
	| editorClass method editorClassName |
	method := self method.
	method isNil ifTrue: [^self].
	editorClassName := ResourceEditors at: method resourceType ifAbsent: [nil].
	editorClassName isNil ifTrue: [^self].
	editorClass := Smalltalk at: editorClassName ifAbsent: [nil].
	editorClass isNil ifTrue: [^self].
	editorClass new openOnClass: self nonMetaClass andSelector: self selector!

openApplication
	self nonMetaClass openWithSpec: self selector! !

!ResourceTool methodsFor: 'updating'!

changedVisual
	self updateSubcanvas!

updateContents
	self updateSubcanvas!

updateSubcanvas
	self createSubcanvas.
	self installSubcanvasIn: #subcanvas using: subcanvas.
	subcanvas updateContents! !

!ResourceTool methodsFor: 'aspects'!

subcanvas
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^subcanvas isNil
		ifTrue:
			[subcanvas := IconViewer new]
		ifFalse:
			[subcanvas]!

visual
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^visual isNil
		ifTrue:
			[visual := nil asValue]
		ifFalse:
			[visual]! !

!ResourceTool methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	| method |
	method := self method.
	method notNil ifTrue: [(OpenTypes includes: method resourceType)
			ifTrue: [self show: #open; enable: #open]].
	^super postBuildWith: aBuilder!

preBuildWith: aBuilder
	aBuilder
		subCanvasAt: #subcanvas
		at: #windowSpec
		put: subcanvas class windowSpec.
	^super preBuildWith: aBuilder! !

!ResourceTool methodsFor: 'private'!

createSubcanvas
	| method viewClass |
	method := self method.
	viewClass := method notNil & visual value
				ifTrue: [ResourceViewers at: method resourceType ifAbsent: [BrowserCodeTool]]
				ifFalse: [BrowserCodeTool].
	subcanvas notNil ifTrue: [subcanvas release].
	subcanvas := viewClass on: codeModel!

subcanvases
	^(OrderedCollection withAll: super subcanvases)
		add: self subcanvas; yourself! !

ResourceTool class
	instanceVariableNames: ''!



!ResourceTool class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Unlabeled Canvas' 
			#bounds: #(#Rectangle 286 195 794 645 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#ActionButtonSpec 
					#layout: #(#Point 50 0 ) 
					#model: #editSpec 
					#label: 'Edit' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#Point 125 0 ) 
					#name: #open 
					#flags: 56 
					#model: #openApplication 
					#label: 'Open' 
					#defaultable: true ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin -10 0.666666 0 0 1 0 ) 
					#model: #visual 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'visual' 
					#select: true ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutOrigin 10 0.666666 0 0 ) 
					#model: #visual 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#requestValueChangeSelector: #updateRequest ) 
					#label: 'text' 
					#select: false ) 
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 30 0 0 1 0 1 ) 
					#name: #subcanvas 
					#flags: 0 
					#majorKey: #subcanvas 
					#minorKey: #windowSpec 
					#clientKey: #subcanvas ) ) ) )! !

!ResourceTool class methodsFor: 'class initialization'!

initialize
	"self initialize"

	ResourceViewers := Dictionary new.
	ResourceViewers at: #image put: IconViewer; at: #menu put: MenuViewer; at: #canvas put: CanvasViewer.
	ResourceEditors := Dictionary new.
	ResourceEditors at: #image put: #UIMaskEditor; at: #menu put: #MenuEditor; at: #canvas put: #UIPainter.
	OpenTypes := #(#canvas)! !

CodeTool subclass: #CanvasViewer
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

CanvasViewer comment:
'CanvasViewer is a class to view canvases graphically instead of textually. This is used when you are viewing a canvas method.'!


!CanvasViewer methodsFor: 'updating'!

updateContents
	self updateDisplay!

updateDisplay
	"Update the subcanvas with the current spec. Use a builder that is editing so that the canvas can be 
	built properly."

	builder notNil ifTrue: [(builder componentAt: #subcanvas) widget
			client: self
			spec: self spec
			builder: ((UIBuilder new) isEditing: true; yourself)].
	super updateDisplay! !

!CanvasViewer methodsFor: 'private'!

disableSpec: aFullSpec 
	aFullSpec component collection do: [:each | (each isKindOf: NamedSpec)
			ifTrue: [each initiallyDisabled: true]]!

spec
	| class selector method specArray spec |
	class := self selectedClass.
	selector := self selector.
	specArray := selector notNil
				ifTrue: 
					[method := class compiledMethodAt: selector ifAbsent: [nil].
					(method notNil and: [method resourceType == #canvas])
						ifTrue: [self errorSignal handle: [:ex | ex returnWith: self class emptySpec]
								do: [self nonMetaClass perform: selector]]
						ifFalse: [self class emptySpec]]
				ifFalse: [self class emptySpec].
	spec := specArray decodeAsLiteralArray.
	spec isNil ifTrue: [^nil].
	self disableSpec: spec.
	^spec! !

CanvasViewer class
	instanceVariableNames: ''!



!CanvasViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Unlabeled Canvas'
			#bounds: #(#Rectangle 492 279 895 651 ) )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 )
					#name: #subcanvas
					#flags: 43 ) ) ) )! !

CodeModelLockPolicy subclass: #WindowLockPolicy
	instanceVariableNames: 'codeTool '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!

WindowLockPolicy comment:
'WindowLockPolicy is a CodeModelLockPolicy that unlocks the model only when its screen is the topmost window of it type.

On unix machines this policy is slow. It asks the Screen for an ordering of its windows, and on unix machines the primitive that returns this information is slow, but on OS/2 and Windows it is quite usable.
'!


!WindowLockPolicy methodsFor: 'initialize-release'!

on: aCodeTool
	codeTool := aCodeTool! !

!WindowLockPolicy methodsFor: 'accessing'!

getWindowHandle
	| possibleWindows |
	possibleWindows := Screen default stackedWindows select: [:each | (each respondsTo: #model)
					and: [each model class = codeTool class and: [each model navigator == codeTool navigator]]].
	possibleWindows isEmpty ifTrue: [^self].
	WindowHandleCache := possibleWindows last key!

isLocked
	WindowHandleCache isNil ifTrue: [self getWindowHandle].
	^codeTool builder isNil or: [codeTool builder window isNil or: [codeTool builder window key ~~ WindowHandleCache]]! !

WindowLockPolicy class
	instanceVariableNames: ''!



!NotEnvironment methodsFor: 'accessing'!

navigatorClass
	environment navigatorClass == ClassSelectorNavigator 
		ifTrue: [^ClassSelectorNavigator].
	^super navigatorClass! !

BrowserNavigator subclass: #ClassSelectorNavigator
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

ClassSelectorNavigator comment:
'ClassSelectorNavigator is a navigator that displays classes and selectors in list widgets, while the other two (application/category and protocol) are displayed in text widgets.'!


!ClassSelectorNavigator methodsFor: 'initialize-release'!

on: aBrowser
	super on: aBrowser.
"	self categoryHolder value: nil.
	self protocolHolder value: nil."
	self meta: false.
	self updateLabels.
	self changedCategory! !

!ClassSelectorNavigator methodsFor: 'accessing-category'!

newCategoryList: initialSelection
	self changedCategory! !

!ClassSelectorNavigator methodsFor: 'accessing-class'!

changedClass
	self updateLabels.
	super changedClass.!

newClassListNoUpdate: initialSelections 
	| newList |
	newList := (List withAll: self environment classNames) sort;
				yourself.
	classList list: newList.
	classList selections: initialSelections.
	self updateClassMenu! !

!ClassSelectorNavigator methodsFor: 'accessing-class/inst switch'!

changedMeta
	self updateLabels.
	super changedMeta! !

!ClassSelectorNavigator methodsFor: 'accessing-protocol'!

newProtocolList: aProtocol 
	^self updateSelectorList! !

!ClassSelectorNavigator methodsFor: 'accessing-selector'!

changedSelector
	self updateLabels.
	super changedSelector!

newSelectorList: initialSelections 
	selectorList 
		list: ((self selectedClass notNil and: [self classNames size == 1]) 
				ifTrue: 
					[(List withAll: (self environment selectorsForClass: self selectedClass))
						sort;
						yourself]
				ifFalse: [List new]).
	selectorList selections: initialSelections.
	self updateSelectorMenu! !

!ClassSelectorNavigator methodsFor: 'accessing-browser'!

spec: verticalBoolean 
	self categoryList list: self environment categories asList.
	^verticalBoolean
		ifTrue: [self class verticalWindowSpec]
		ifFalse: [self class windowSpec]! !

!ClassSelectorNavigator methodsFor: 'private'!

getSpec: verticalBoolean 
	^verticalBoolean
		ifTrue: [self class verticalWindowSpec]
		ifFalse: [self class windowSpec]!

setState: aNavigatorState updateClasses: aBoolean 
	super setState: aNavigatorState updateClasses: aBoolean.
	aNavigatorState selectedClass notNil
		ifTrue: [self newSelectorList: aNavigatorState selectors].
	self updateLabels!

updateLabels
	| class |
	class := self selectedClass.
	class notNil
		ifTrue: 
			[self protocolList list: (self environment protocolsFor: class) asList.
			self protocolHolder value: (self environment whichProtocolIncludes: self selector in: class)]
		ifFalse: [self protocolHolder value: nil].
	self categoryHolder value: (class isNil
			ifTrue: [nil]
			ifFalse: [self environment whichCategoryIncludes: self className]).
	self updateCategoryMenu.
	self updateProtocolMenu! !

!ClassSelectorNavigator methodsFor: 'private-class'!

clearToClass
	self changeRequest ifFalse: [^self].
	self newSelectorList: #().
	self changedSelector! !

ClassSelectorNavigator class
	instanceVariableNames: ''!



!ClassSelectorNavigator class methodsFor: 'interface specs'!

verticalWindowSpec
	"UIPainter new openOnClass: self andSelector: #verticalWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 399 378 614 787 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -2 1 27 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dragOverSelector 
						#classDragOver: #dragStartSelector 
						#doClassDrag: #dropSelector 
						#classDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 29 0 -2 1 -25 0.5 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -22 0.5 0 0.5 -3 0.5 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.5 -22 0.5 -22 1 -3 0.5 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 1 0.5 -2 1 26 0.5 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 2 0 28 0.5 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 0.5 -2 1 -1 0.5 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 1 -23 0.5 -2 1 -3 0.5 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Navigator' 
			#bounds: #(#Rectangle 301 317 889 468 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 2 0 2 0 -1 0.5 27 0 ) 
					#name: #categoryHolder 
					#model: #categoryHolder 
					#menu: #categoryMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragOkSelector 
						#classWantToDrag: #dragEnterSelector 
						#classDragEnter: #dragOverSelector 
						#classDragOver: #dragStartSelector 
						#doClassDrag: #dropSelector 
						#classDrop: #dragExitSelector 
						#dragLeave: ) 
					#layout: #(#LayoutFrame 2 0 29 0 -1 0.5 -25 1 ) 
					#name: #classList 
					#model: #classList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedClass 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 3 0 -22 1 0 0.25 -3 1 ) 
					#name: #instance 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#LayoutFrame 2 0.25 -22 1 -22 0.5 -3 1 ) 
					#name: #class 
					#model: #meta 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedMeta 
						#requestValueChangeSelector: #changeRequest ) 
					#label: 'class' 
					#select: true ) 
				#(#InputFieldSpec 
					#layout: #(#LayoutFrame 1 0.5 2 0 -2 1 27 0 ) 
					#name: #protocolHolder 
					#model: #protocolHolder 
					#menu: #protocolMenu 
					#isReadOnly: true ) 
				#(#SequenceViewSpec 
					#properties: 
					#(#PropertyListDictionary #dragStartSelector 
						#doSelectorDrag: #dragOkSelector 
						#selectorWantToDrag: ) 
					#layout: #(#LayoutFrame 1 0.5 29 0 -2 1 -2 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: #changedSelector 
						#requestValueChangeSelector: #changeRequest ) 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#GroupBoxSpec 
					#layout: #(#LayoutFrame 2 0 -23 1 -1 0.5 -2 1 ) ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -22 0.5 -23 1 -2 0.5 -3 1 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )! !

CodeTool subclass: #MenuViewer
	instanceVariableNames: 'selection '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

MenuViewer comment:
'MenuViewer is a class to view menus graphically instead of textually. This is used when you are viewing a menu resource.

Instance Variables:
	selection	<ValueHolder on: Symbol>	contains the last selection from the menu'!


!MenuViewer methodsFor: 'accessing'!

menu
	^
	[| class selector method |
	class := self selectedClass.
	selector := self selector.
	selector notNil
		ifTrue: 
			[method := class compiledMethodAt: selector ifAbsent: [nil].
			(method notNil and: [method resourceType == #menu])
				ifTrue: [self errorSignal handle: [:ex | ex returnWith: Menu new]
						do: [self initializeMenu: (self nonMetaClass perform: selector)]]
				ifFalse: [Menu new]]
		ifFalse: [Menu new]]! !

!MenuViewer methodsFor: 'aspects'!

selection
	"This method was generated by UIDefiner.  Any edits made here
	may be lost whenever methods are automatically defined.  The
	initialization provided below may have been preempted by an
	initialize method."

	^selection isNil
		ifTrue:
			[selection := nil asValue]
		ifFalse:
			[selection]! !

!MenuViewer methodsFor: 'private'!

initializeMenu: aMenu
	aMenu values: (aMenu values collect: [:each | [self selection value: each]]).
	aMenu menuItems do: [:each | each submenu notNil ifTrue: [each submenu: (self initializeMenu: each submenu)]].
	^aMenu! !

MenuViewer class
	instanceVariableNames: ''!



!MenuViewer class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Unlabeled Canvas'
			#bounds: #(#Rectangle 171 191 653 550 ) )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#MenuButtonSpec
					#layout: #(#LayoutFrame -50 0.5 10 0 50 0.5 40 0 )
					#name: #menu
					#model: #selection
					#label: 'Menu'
					#menu: #menu )
				#(#InputFieldSpec
					#layout: #(#LayoutFrame 10 0 65 0 -10 1 90 0 )
					#name: #selection
					#flags: 0
					#model: #selection
					#alignment: #center
					#type: #object ) ) ) )! !

Object subclass: #ReferenceFinder
	instanceVariableNames: 'backlinks objectsLeft testBlock foundBlock '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!



!ReferenceFinder methodsFor: 'accessing'!

findAllPaths: aBlock 
	| paths |
	paths := OrderedCollection new.
	foundBlock := [:path | paths add: path].
	testBlock := aBlock.
	self find.
	^paths!

findPath: aBlock 
	foundBlock := [:path | ^path].
	testBlock := aBlock.
	self find.
	^nil! !

!ReferenceFinder methodsFor: 'private'!

addBacklinkFrom: newObject to: anObject 
	backlinks last at: newObject put: anObject!

addBacklinkLevel
	backlinks add: self identityDictionaryClass new!

backlinkFor: anObject 
	| toObject |
	backlinks do: 
			[:each | 
			toObject := each at: anObject ifAbsent: [nil].
			toObject notNil ifTrue: [^toObject]].
	^nil!

computePathFor: anObject 
	| path object |
	path := OrderedCollection new.
	object := anObject.
	[object isNil] whileFalse: 
			[path add: object.
			object := self backlinkFor: object].
	^path reverse!

find
	objectsLeft := OrderedCollection with: Smalltalk.
	backlinks := OrderedCollection new.
	self addBacklinkLevel.
	backlinks last at: Smalltalk put: nil.
	self searchForObject!

hasSearched: newObject 
	^(backlinks detect: [:each | each includesKey: newObject] ifNone: [nil]) 
		notNil!

identityDictionaryClass
	^IdentityDictionary!

printToDoNotice
	Transcript
		show: 'Level ';
		show: backlinks size printString;
		show: ' with ';
		show: objectsLeft size printString;
		show: ' objects to search';
		cr!

processLinkTo: newObject from: anObject 
	newObject class instSize + newObject basicSize = 0 
		ifTrue: 
			[^(testBlock value: newObject) 
				ifTrue: 
					[(self computePathFor: anObject)
						add: newObject;
						yourself]
				ifFalse: [nil]].
	(self hasSearched: newObject) 
		ifFalse: 
			[(testBlock value: newObject) 
				ifTrue: 
					[^(self computePathFor: anObject)
						add: newObject;
						yourself].
			objectsLeft add: newObject.
			self addBacklinkFrom: newObject to: anObject].
	^nil!

searchForObject
	
	[| objects |
	self printToDoNotice.
	objects := objectsLeft.
	objectsLeft := OrderedCollection new.
	self addBacklinkLevel.
	objects do: 
			[:each | 
			| path |
			(path := self searchVariablesIn: each) notNil 
				ifTrue: [foundBlock value: path].
			(path := self searchIndicesIn: each) notNil 
				ifTrue: [foundBlock value: path]].
	objectsLeft isEmpty] 
			whileFalse: []!

searchIndicesIn: anObject 
	1 to: anObject basicSize
		do: 
			[:i | 
			| path |
			(path := self processLinkTo: (anObject basicAt: i) from: anObject) notNil 
				ifTrue: [^path]].
	^nil!

searchVariablesIn: anObject 
	1 to: anObject class instSize
		do: 
			[:i | 
			| path |
			(path := self processLinkTo: (anObject instVarAt: i) from: anObject) 
				notNil ifTrue: [^path]].
	^nil! !

ReferenceFinder class
	instanceVariableNames: ''!



!ReferenceFinder class methodsFor: 'accessing'!

findAllPathsTo: anObject 
	"self findAllPathsTo: (Object compiledMethodAt: #printString)"

	^self new findAllPaths: [:each | each == anObject]!

findAllPathsToInstanceOf: aBehavior 
	"self findAllPathsToInstanceOf: RefactoringBrowser"

	^self new findAllPaths: [:each | each class == aBehavior]!

findPathTo: anObject 
	^self new findPath: [:each | each == anObject]!

findPathToInstanceOf: aBehavior 
	^self new findPath: [:each | each class == aBehavior]! !


!CategoryEnvironment methodsFor: 'accessing'!

navigatorClass
	^categories size = 1
		ifTrue: [BrowserNavigator]
		ifFalse: [SystemNavigator]! !

BrowserApplicationModel subclass: #CodeModel
	instanceVariableNames: 'navigator tool lockPolicy state '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!

CodeModel comment:
'CodeModel is the application that swaps the subcanvas (CodeTool) on the bottom of a browser. It is also responsible for updating the tool if it is not locked. The codeToolClass method is the method that returns the class of the code tool to create. You can change this method if you want to add your own code tool.

Instance Variables:
	navigator	<Navigator>	contains the navigator connected to the code tool
	tool	<CodeTool>	the current code tool that is being displayed in the subcanvas
	lockPolicy	<CodeModelLockPolicy>	the locking policy for updating the tool
	state	<NavigatorState>	the state returned by navigator that is used to update the navigator when this tool is unlocked '!


!CodeModel methodsFor: 'initialize-release'!

lockPolicyClass: aClass
	lockPolicy := aClass on: self!

navigator: aNavigator 
	navigator notNil ifTrue: [navigator removeDependent: self].
	navigator := aNavigator.
	navigator addDependent: self.
	lockPolicy := StateLockPolicy on: self.
	tool := self codeToolClass on: self.
	self state: navigator getState!

release
	navigator removeDependent: self.
	tool release.
	super release! !

!CodeModel methodsFor: 'accessing'!

codeToolClass
	| method |
	^self protocol notNil
		ifTrue: [(self selectedClass isMeta and: [self selector notNil])
				ifTrue: 
					[method := self selectedClass compiledMethodAt: self selector.
					(#(#image #menu #canvas) includes: method resourceType)
						ifTrue: [ResourceTool]
						ifFalse: [BrowserCodeTool]]
				ifFalse: [BrowserCodeTool]]
		ifFalse: [ClassNavigatorTool]!

lock
	self isLocked ifTrue: [^self].
	lockPolicy lock.
	self saveState!

navigator
	^navigator!

state
	state isNil ifTrue: [state := navigator getState].
	^state!

state: anObject
	^state := anObject!

tool
	^tool!

unlock
	self isLocked ifFalse: [^self].
	navigator setState: self state.
	lockPolicy unlock! !

!CodeModel methodsFor: 'testing'!

isEditing
	^tool notNil and: [tool isEditing]!

isLocked
	^lockPolicy isLocked! !

!CodeModel methodsFor: 'menu'!

menu
	^tool menu!

menuBar
	| menu |
	menu := Menu new.
	menu addItem: ((MenuItem labeled: '&Window') submenu: [self windowMenu]);
		addItem: ((MenuItem labeled: 'Too&l') submenu: [self menu value]).
	^menu!

windowMenu
	| menu navigateItem |
	menu := Menu new.
	navigateItem := MenuItem labeled: '&Navigate to'.
	menu addItem: navigateItem value: #navigate.
	^menu! !

!CodeModel methodsFor: 'actions'!

navigate
	navigator setState: self state! !

!CodeModel methodsFor: 'navigator accessing'!

categories
	^self state categories!

category
	^self state category!

className
	^self state className!

classNames
	^self state classNames!

methods
	^state methods!

nonMetaClass
	^self state nonMetaClass!

nonMetaClasses
	^self state nonMetaClasses!

protocol
	^self state protocol!

protocols
	^self state protocols!

selectedClass
	^self state selectedClass!

selectedClasses
	^self state selectedClasses!

selector
	^self state selector!

selectors
	^self state selectors!

setClass: aClass 
	self state selectedClass: aClass.
	self updateNavigator!

setSelector: aSelector 
	self state selector: aSelector.
	self updateNavigator!

updateNavigator
	CodeModelLockPolicy flushCache.
	self isLocked ifFalse: [navigator setState: self state].
	tool notNil ifTrue: [tool updateContents]! !

!CodeModel methodsFor: 'navigator testing'!

isMeta
	^self state isMeta! !

!CodeModel methodsFor: 'updating'!

update: anAspectSymbol with: aParameter from: aSender 
	| oldTool |
	anAspectSymbol = #closed ifTrue: [^self closeRequest].
	lockPolicy isLocked ifTrue: [^self].
	self state: navigator getState.
	oldTool := tool.
	self protocol isNil
		ifTrue: [tool class == ClassNavigatorTool ifFalse: [tool := ClassNavigatorTool on: self]]
		ifFalse: [tool class == self codeToolClass ifFalse: [tool := self codeToolClass on: self]].
	tool == oldTool
		ifFalse: 
			[self installSubcanvasIn: #subcanvas using: tool.
			oldTool release].
	tool notNil ifTrue: [tool updateContents]!

updateRequest
	^lockPolicy isLocked or: [super updateRequest]! !

!CodeModel methodsFor: 'printing'!

printOn: aStream 
	self state printOn: aStream.
	(tool notNil and: [tool isEditing])
		ifTrue: [aStream nextPut: $*]! !

!CodeModel methodsFor: 'interface opening'!

preBuildWith: aBuilder
	aBuilder subCanvasAt: #Tool at: #windowSpec put: (tool class windowSpec).
	^super preBuildWith: aBuilder! !

!CodeModel methodsFor: 'events'!

noticeOfWindowClose: aWindow
	navigator removeDependent: self.
	self release.
	^super noticeOfWindowClose: aWindow! !

!CodeModel methodsFor: 'private'!

saveState
	tool notNil ifTrue: [tool saveState]!

subcanvases
	| superSubcanvases |
	superSubcanvases := super subcanvases.
	^self tool isNil
		ifTrue: [superSubcanvases]
		ifFalse: 
			[(superSubcanvases asOrderedCollection) add: self tool;
				yourself]! !

CodeModel class
	instanceVariableNames: ''!



!CodeModel class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Code Tool'
			#bounds: #(#Rectangle 161 165 694 567 )
			#flags: 4
			#menu: #menuBar )
		#component:
		#(#SpecCollection
			#collection: #(
				#(#SubCanvasSpec
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 )
					#name: #subcanvas
					#flags: 0
					#majorKey: #Tool
					#minorKey: #windowSpec
					#clientKey: #tool ) ) ) )! !

!CodeModel class methodsFor: 'instance creation'!

navigator: aNavigator
	^self new navigator: aNavigator! !

CodeTool subclass: #BrowserTextTool
	instanceVariableNames: 'menu savedText changed textHolder originalText '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

BrowserTextTool comment:
'BrowserTextTool is an abstract class for all of the CodeTool''s that have a textual display.

Instance Variables:
	changed	<Boolean>	has the text changed?
	menu	<Menu>	the menu for the text widget
	savedText	<String>	if the text has changed and we are switched out, then save the text here
	textHolder	<ValueHolder on: String>	contains the original text'!


!BrowserTextTool methodsFor: 'initialize-release'!

initialize
	super initialize.
	self text: ''.
	menu := self initializeMenu: self class menu.! !

!BrowserTextTool methodsFor: 'accessing'!

doItReceiver
	"Answer the object that should be informed of the result of evaluating a
	text selection."

	^self nonMetaClass!

insertError: aString at: position 
	self textController insertAndSelect: aString , ' ->' at: position!

saveState
	| controller |
	controller := self textController.
	controller isNil ifTrue: [^self].
	(changed := controller textHasChanged) ifTrue: [savedText := controller text]!

text
	| controller |
	controller := self textController.
	^controller notNil
		ifTrue: [controller text]
		ifFalse: ['']!

text: aString 
	self textHolder value: aString.
	originalText := aString.
	changed := false!

textNoChange: aString
	(self textController) selectFrom: 1 to: self textController text size;
		deselect;
		replaceSelectionWith: aString asText;
		selectAt: 1! !

!BrowserTextTool methodsFor: 'accepting'!

accept: aText from: aController
	^self subclassResponsibility!

cancelText
	self text: originalText!

textAccepted: aController 
	self isEnabled ifTrue: [self accept: aController text from: aController]! !

!BrowserTextTool methodsFor: 'refactoring'!

abstractClassVar: aString 
	self performRefactoring: (AbstractClassVariableRefactoring 
				variable: aString asSymbol
				class: (self nonMetaClass whichClassDefinesClassVar: aString))!

abstractInstVar: aString 
	self 
		performRefactoring: (AbstractInstanceVariableRefactoring variable: aString
				class: (self selectedClass whichClassDefinesInstVar: aString))!

createAccessorsForClassVar: aString 
	self performRefactoring: (CreateAccessorsForVariableRefactoring 
				variable: aString asSymbol
				class: (self nonMetaClass whichClassDefinesClassVar: aString)
				classVariable: true)!

createAccessorsForInstVar: aString 
	self performRefactoring: (CreateAccessorsForVariableRefactoring 
				variable: aString
				class: (self selectedClass whichClassDefinesInstVar: aString)
				classVariable: false)!

performRefactoring: aRefactoring 
	aRefactoring isNil ifTrue: [^self].
	self handleError: 
			[aRefactoring execute.
			codeModel navigate.
			self updateContents]!

protectInstVar: aString 
	self 
		performRefactoring: (ProtectInstanceVariableRefactoring variable: aString
				class: (self selectedClass whichClassDefinesInstVar: aString))!

pushUpClassVar: aString 
	self performRefactoring: (PullUpClassVariableRefactoring 
				variable: aString asSymbol
				class: (self nonMetaClass whichClassDefinesClassVar: aString) superclass)!

pushUpInstVar: aString 
	self 
		performRefactoring: (PullUpInstanceVariableRefactoring variable: aString
				class: (self selectedClass whichClassDefinesInstVar: aString) superclass)!

renameClassVar: aString 
	self navigator renameClassVar: aString asSymbol
		in: (self nonMetaClass whichClassDefinesClassVar: aString).
	self updateContents!

renameInstVar: aString 
	self navigator renameInstVar: aString
		in: (self selectedClass whichClassDefinesInstVar: aString).
	self updateContents! !

!BrowserTextTool methodsFor: 'testing'!

isEditing
	"The '== true' below is for people filing in the source with open browsers"

	| controller |
	(super isEditing or: [changed == true])
		ifTrue: [^true].
	controller := self textController.
	^controller notNil and: [controller textHasChanged]!

isEnabled
	^true! !

!BrowserTextTool methodsFor: 'aspects'!

textHolder
	^textHolder isNil ifTrue: [textHolder := '' asValue] ifFalse: [textHolder]! !

!BrowserTextTool methodsFor: 'menu'!

enableMenu
	| collection interval |
	interval := self selectedInterval.
	collection := OrderedCollection new.
	interval isEmpty ifTrue: [collection addAll: self noSelectionItems].
	self isEditing
		ifTrue: [self isEnabled ifFalse: [collection add: 'accept']]
		ifFalse: [collection addAll: self noEditItems].
	collection addAll: self otherMenuItems.
	self enableMenu: menu except: collection!

initializeMenu: aMenu 
	"Hack aMenu so that it can be installed into window, and still send us the messages instead of 
	sending them to the window's model."

	aMenu values: (aMenu values collect: [:each | (#(#find #replace #undo #copySelection #cut #paste #doIt #printIt #inspectIt #hardcopy) includes: each)
				ifTrue: [[self textController perform: each]]
				ifFalse: [each isSymbol
						ifTrue: [each numArgs == 1
								ifTrue: [[self perform: each with: self textController]]
								ifFalse: [each numArgs == 2
										ifTrue: [[self
												perform: each
												with: self textController text
												with: self textController]]
										ifFalse: [[self perform: each]]]]
						ifFalse: [each]]]).
	aMenu menuItems do: [:each | each submenu notNil ifTrue: [each submenu: (self initializeMenu: each submenu)]].
	^aMenu!

menu
	^
	[self enableMenu.
	menu]!

noEditItems
	^#('accept' 'cancel')!

noSelectionItems
	^#('do it' 'print it' 'inspect it')!

otherMenuItems
	^#()! !

!BrowserTextTool methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	(self textController) autoAccept: false;
		continuousAccept: false! !

!BrowserTextTool methodsFor: 'private'!

selectedInterval
	| controller |
	controller := self textController.
	controller isNil ifTrue: [^1 to: 0].
	^controller selectionStartIndex to: controller selectionStopIndex - 1!

selectedText
	| interval |
	interval := self selectedInterval.
	interval isEmpty ifTrue: [^''].
	^self textController text asString copyFrom: interval first to: interval last!

textController
	^self controllerFor: #textEditor! !

!BrowserTextTool methodsFor: 'updating'!

updateDisplay
	| controller |
	super updateDisplay.
	savedText notNil
		ifTrue: 
			[controller := self textController.
			controller view editText: savedText.
			controller textHasChanged: true.
			savedText := nil].
	changed := false!

updateRequest
	^super updateRequest and: 
			[self isEditing not or: 
					[Dialog
						confirm: 'The text showing has been altered.\Do you wish to discard those changes?'
								withCRs]]! !

!BrowserTextTool methodsFor: 'instance variables'!

browseInstVarReaders
	| name |
	name := self selectedVariableName.
	name notNil 
		ifTrue: [self navigator browseGlobalInstVarReadersTo: name in: self selectedClass]!

browseInstVarRefs
	| name |
	name := self selectedVariableName.
	name notNil 
		ifTrue: [self navigator browseGlobalInstVarRefsTo: name in: self selectedClass]!

browseInstVarWriters
	| name |
	name := self selectedVariableName.
	name notNil 
		ifTrue: [self navigator browseGlobalInstVarWritersTo: name in: self selectedClass]!

selectedVariableName
	"Guess the variable name from the selection"

	^self selectedText! !

BrowserTextTool class
	instanceVariableNames: ''!



!BrowserTextTool class methodsFor: 'interface specs'!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Unlabeled Canvas' 
			#bounds: #(#Rectangle 431 495 797 720 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#TextEditorSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 0 1 ) 
					#name: #textEditor 
					#model: #textHolder 
					#callbacksSpec: 
					#(#UIEventCallbackSubSpec 
						#valueChangeSelector: 
						#textAccepted: ) 
					#menu: #menu ) ) ) )! !

!BrowserTextTool class methodsFor: 'resources'!

menu
	"UIMenuEditor new openOnClass: self andSelector: #menu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&find...' 
				#value: #find ) 
			#(#MenuItem 
				#rawLabel: '&replace...' 
				#value: #replace ) 
			#(#MenuItem 
				#rawLabel: '&undo' 
				#value: #undo ) 
			#(#MenuItem 
				#rawLabel: '&copy' 
				#value: #copySelection ) 
			#(#MenuItem 
				#rawLabel: 'cu&t' 
				#value: #cut ) 
			#(#MenuItem 
				#rawLabel: '&paste' 
				#value: #paste ) 
			#(#MenuItem 
				#rawLabel: '&do it' 
				#value: #doIt ) 
			#(#MenuItem 
				#rawLabel: 'pri&nt it' 
				#value: #printIt ) 
			#(#MenuItem 
				#rawLabel: '&inspect it' 
				#value: #inspectIt ) 
			#(#MenuItem 
				#rawLabel: '&accept' 
				#value: 
				#accept:from: ) 
			#(#MenuItem 
				#rawLabel: 'cancel' 
				#value: #cancelText ) 
			#(#MenuItem 
				#rawLabel: '&hardcopy' 
				#value: #hardcopy ) ) #(2 1 3 3 2 1 ) nil ) decodeAsLiteralArray! !

BrowserTextTool subclass: #BrowserClassTool
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

BrowserClassTool comment:
'BrowserClassTool is the CodeTool that edits class definitions.'!


!BrowserClassTool methodsFor: 'accepting'!

accept: aText from: aController 
	| class |
	class := self defineClass: aText from: aController.
	class isBehavior ifTrue: [codeModel setClass: class]!

defineClass: aText from: aController 
	^Cursor wait showWhile: 
			[| class name |
			class := Object errorSignal handle: 
							[:ex | 
							ex willProceed 
								ifTrue: 
									[(Dialog confirm: ex errorString , '\Do you want to continue?' withCRs
										for: self interfaceWindow) ifTrue: [ex proceed]]
								ifFalse: [Dialog warn: ex errorString for: self interfaceWindow].
							ex returnWith: nil]
						do: 
							[| change |
							change := InteractiveAddClassChange definition: aText string
										for: aController.
							self performChange: change.
							change definedClass].
			class isBehavior 
				ifTrue: 
					[name := class isMeta 
								ifTrue: [class soleInstance name]
								ifFalse: [class name].
					self navigator newClassList: (Array with: name).
					class]
				ifFalse: [nil]]! !

!BrowserClassTool methodsFor: 'testing'!

isClassVar: aString 
	^self isMeta not and: [self selectedClass classVarNames includes: aString asSymbol]!

isClassVarSelected
	^self isClassVar: self selectedText!

isEnabled
	^self category notNil!

isInstVar: aString 
	^self selectedClass instVarNames includes: aString!

isInstVarSelected
	^self isInstVar: self selectedText! !

!BrowserClassTool methodsFor: 'updating'!

updateContents
	self text: (self selectedClass isNil
			ifTrue: [self category isNil
					ifTrue: ['' asText]
					ifFalse: [(Class template: self category) asText]]
			ifFalse: [self selectedClass definition asText])! !

!BrowserClassTool methodsFor: 'refactorings'!

abstractVariable
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: [self abstractInstVar: string].
	(self isClassVar: string) ifTrue: [self abstractClassVar: string]!

addClassVar
	self navigator addClassVarIn: self selectedClass.
	self updateContents!

addInstVar
	self navigator addInstVarIn: self selectedClass.
	self updateContents!

createAccessors
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: [self createAccessorsForInstVar: string].
	(self isClassVar: string) 
		ifTrue: [self createAccessorsForClassVar: string]!

protectInstVar
	| string |
	string := self selectedText.
	self protectInstVar: string!

pushDownVariable
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: 
			[self performRefactoring: (PushDownInstanceVariableRefactoring variable: string
						class: self selectedClass)].
	(self isClassVar: string) ifTrue: 
			[self performRefactoring: (PushDownClassVariableRefactoring variable: string asSymbol
						class: self nonMetaClass)]!

pushUpVariable
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: [self pushUpInstVar: string].
	(self isClassVar: string) ifTrue: [self pushUpClassVar: string]!

removeVariable
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: 
			[self performRefactoring: (RemoveInstanceVariableRefactoring variable: string class: self selectedClass)].
	(self isClassVar: string) ifTrue: 
			[self performRefactoring: (RemoveClassVariableRefactoring variable: string asSymbol
						class: self nonMetaClass)]!

renameVariable
	| string |
	string := self selectedText.
	(self isInstVar: string) ifTrue: [self renameInstVar: string].
	(self isClassVar: string) ifTrue: [self renameClassVar: string].
	self updateContents! !

!BrowserClassTool methodsFor: 'menu'!

noSelectionItems
	^#('do it' 'print it' 'inspect it' 'push up' 'push down' 'rename as...' 'remove' 'create accessors' 'abstract' 'protect/concrete')!

otherMenuItems
	^(self isEditing or: [self selectedClass isNil]) 
		ifTrue: [#('variables')]
		ifFalse: 
			[self isInstVarSelected 
				ifTrue: [#()]
				ifFalse: 
					[self isClassVarSelected 
						ifTrue: [#('references...' 'readers...' 'writers...' 'protect/concrete')]
						ifFalse: 
							[#('references...' 'readers...' 'writers...' 'protect/concrete' 'rename as...' 'remove' 'push up' 'push down' 'create accessors' 'abstract')]]]! !

BrowserClassTool class
	instanceVariableNames: ''!



!BrowserClassTool class methodsFor: 'resources'!

menu
	"MenuEditor new openOnClass: self andSelector: #menu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&find...' 
				#value: #find ) 
			#(#MenuItem 
				#rawLabel: '&replace...' 
				#value: #replace ) 
			#(#MenuItem 
				#rawLabel: '&undo' 
				#value: #undo ) 
			#(#MenuItem 
				#rawLabel: '&copy' 
				#value: #copySelection ) 
			#(#MenuItem 
				#rawLabel: 'cu&t' 
				#value: #cut ) 
			#(#MenuItem 
				#rawLabel: '&paste' 
				#value: #paste ) 
			#(#MenuItem 
				#rawLabel: '&do it' 
				#value: #doIt ) 
			#(#MenuItem 
				#rawLabel: 'pri&nt it' 
				#value: #printIt ) 
			#(#MenuItem 
				#rawLabel: '&inspect it' 
				#value: #inspectIt ) 
			#(#MenuItem 
				#rawLabel: '&accept' 
				#value: 
				#accept:from: ) 
			#(#MenuItem 
				#rawLabel: 'cancel' 
				#value: #cancelText ) 
			#(#MenuItem 
				#rawLabel: '&variables' 
				#submenu: #(#Menu #(
						#(#MenuItem 
							#rawLabel: 'add &instance variable...' 
							#value: #addInstVar ) 
						#(#MenuItem 
							#rawLabel: 'add &class variable...' 
							#value: #addClassVar ) 
						#(#MenuItem 
							#rawLabel: 'references...' 
							#value: #browseInstVarRefs ) 
						#(#MenuItem 
							#rawLabel: 'readers...' 
							#value: #browseInstVarReaders ) 
						#(#MenuItem 
							#rawLabel: 'writers...' 
							#value: #browseInstVarWriters ) 
						#(#MenuItem 
							#rawLabel: 'rename as...' 
							#value: #renameVariable ) 
						#(#MenuItem 
							#rawLabel: '&remove' 
							#value: #removeVariable ) 
						#(#MenuItem 
							#rawLabel: 'push &up' 
							#value: #pushUpVariable ) 
						#(#MenuItem 
							#rawLabel: 'push &down' 
							#value: #pushDownVariable ) 
						#(#MenuItem 
							#rawLabel: 'create accessors' 
							#value: #createAccessors ) 
						#(#MenuItem 
							#rawLabel: 'abstract' 
							#value: #abstractVariable ) 
						#(#MenuItem 
							#rawLabel: 'protect/concrete' 
							#value: #protectInstVar ) ) #(2 3 2 2 3 ) nil ) ) 
			#(#MenuItem 
				#rawLabel: '&hardcopy' 
				#value: #hardcopy ) ) #(2 1 3 3 2 1 1 ) nil ) decodeAsLiteralArray! !

BrowserTextTool subclass: #OrganizationEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

OrganizationEditor comment:
'OrganizationEditor is used to edit the class categories or the protocols of classes. It is similar to the "edit all" feature of the standard browser.'!


!OrganizationEditor methodsFor: 'accessing'!

organization
	| class |
	class := self selectedClass.
	(class isNil and: [self category isNil])
		ifTrue: [^Smalltalk organization].
	class notNil ifTrue: [^class organization].
	^nil! !

!OrganizationEditor methodsFor: 'accepting'!

accept: aText from: aController 
	| organization class |
	organization := self organization.
	organization notNil ifTrue: 
			[organization changeFromString: self textController text.
			class := self selectedClass.
			class notNil ifTrue: 
					[class reorganize.
					class logOrganizationChange]].
	codeModel navigate.
	self updateContents! !

!OrganizationEditor methodsFor: 'testing'!

isEnabled
	^self category isNil or: [self nonMetaClass notNil]! !

!OrganizationEditor methodsFor: 'updating'!

updateContents
	| organization |
	organization := self organization.
	organization notNil
		ifTrue: [self text: organization printString]
		ifFalse: [self text: '']! !

OrganizationEditor class
	instanceVariableNames: ''!


BrowserTextTool subclass: #BrowserCodeTool
	instanceVariableNames: 'modified messageMenu temporaryMenu noMenu instanceVariableMenu classVariableMenu valueNodeMenu assignmentMenu globalVariableMenu '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

BrowserCodeTool comment:
'BrowserCodeTool is the CodeTool that modifies methods.

Instance Variables:
	modified	<Boolean>	has the been changed since we initially displayed it?'!


!BrowserCodeTool methodsFor: 'initialize-release'!

initialize
	super initialize.
	ChangeSet addDependent: self.
	modified := false.
	self initializeMenus!

initializeMenus
	| menuItem |
	menuItem := MenuItem labeled: '&selection'.
	menuItem submenu: [self selectMenu].
	menu addItem: menuItem.
	temporaryMenu := self initializeMenu: self class temporaryMenu.
	instanceVariableMenu := self 
				initializeMenu: self class instanceVariableMenu.
	classVariableMenu := self initializeMenu: self class classVariableMenu.
	messageMenu := self initializeMenu: self class messageMenu.
	noMenu := self initializeMenu: self class noMenu.
	valueNodeMenu := self initializeMenu: self class valueNodeMenu.
	assignmentMenu := self initializeMenu: self class assignmentMenu.
	globalVariableMenu := self initializeMenu: self class globalVariableMenu!

release
	ChangeSet removeDependent: self.
	super release! !

!BrowserCodeTool methodsFor: 'accepting'!

accept: aText from: aController 
	self overwriteExistingMethod ifFalse: [^self].
	modified := nil.
	
	[| selector change |
	change := InteractiveAddMethodChange 
				compile: aText
				in: self selectedClass
				classified: self protocol
				for: aController.
	self performChange: change.
	selector := change definedSelector.
	selector notNil ifTrue: [codeModel setSelector: selector]] 
			valueNowOrOnUnwindDo: [modified := false]!

explain: fullText from: aController 
	"Try to shed some light on what kind of entity the controller's
	current selection is.
	The selection must be a single token or construct.  Have the controller
	insert the answer after its selection."

	| reply targetClass |
	targetClass := self selectedClass.
	reply := (Explainer new class: targetClass
				selector: self selector
				instance: self nonMetaClass
				context: nil
				methodText: self textController text) explain: aController selection string
					for: self.
	aController insertAndSelect: ' ' , reply at: aController selectionStopIndex!

explainSpecial: string
	^nil!

format
	| selectedClass newText |
	selectedClass := self selectedClass.
	newText := (BRParser parseMethod: self textController text
				onError: [:aString :position | ^self insertError: aString at: position]) 
					printString asText 
				makeSelectorBoldIn: self selectedClass.
	newText isNil ifTrue: [^self].
	newText := newText asText makeSelectorBoldIn: selectedClass.
	self textNoChange: newText! !

!BrowserCodeTool methodsFor: 'refactorings'!

extractMethod
	self updateRequest ifFalse: [^self].
	self performRefactoring: (ExtractMethodRefactoring 
				extract: (self convertToSourceInterval: self selectedInterval)
				from: self selector
				in: self selectedClass)!

extractToTemp
	| newName node |
	self updateRequest ifFalse: [^self].
	node := self findNode.
	(node isNil or: [node isValue not]) 
		ifTrue: [^self warn: 'Could not find the node'].
	newName := self request: 'Enter name forTemporary:'.
	newName isEmpty ifTrue: [^self].
	self performRefactoring: (ExtractToTemporaryRefactoring 
				extract: (self convertToSourceInterval: node sourceInterval)
				to: newName
				from: self selector
				in: self selectedClass)!

inlineTemporary
	| node |
	self updateRequest ifFalse: [^self].
	node := self findNode.
	(node isNil or: [node isAssignment not]) 
		ifTrue: [^self warn: 'Could not find the node'].
	self performRefactoring: (InlineTemporaryRefactoring 
				inline: (self convertToSourceInterval: node sourceInterval)
				from: self selector
				in: self selectedClass)! !

!BrowserCodeTool methodsFor: 'updating'!

update: anAspectSymbol with: aParameter from: aSender 
	(#(#removeSelector:class: #changeSelector:class: #addSelector:class:) includes: anAspectSymbol)
		ifTrue: 
			[modified isNil ifTrue: [^self]. "We're making the modification so don't update the display"
			(aParameter first = self selector and: [aParameter last = self selectedClass])
				ifTrue: 
					[modified := true.
					self updateTextWidget]]
		ifFalse: [super
				update: anAspectSymbol
				with: aParameter
				from: aSender]!

updateContents
	| compiledMethod source |
	modified := false.
	self updateTextWidget.
	self selectedClass isNil ifTrue: [^self text: ''].
	self selector isNil ifTrue: [^self text: self selectedClass sourceCodeTemplate asText].
	compiledMethod := self selectedClass compiledMethodAt: self selector
				ifAbsent: 
					[Dialog warn: 'Method has been removed'.
					^self text: ''].
	source := self selectedClass sourceCodeForMethod: compiledMethod at: self selector.
	self text: (source asText makeSelectorBoldIn: self selectedClass).
	self updateSelection! !

!BrowserCodeTool methodsFor: 'interface opening'!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	self updateTextWidget! !

!BrowserCodeTool methodsFor: 'global variables'!

browseReferencesToGlobal
	| name association |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	association := Smalltalk associationAt: name asSymbol ifAbsent: [^self].
	self navigator browseGlobalReferencesTo: association!

navigateToClass
	| name class |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	class := Smalltalk at: name asSymbol ifAbsent: [^self].
	codeModel
		setSelector: nil;
		setClass: class!

openBrowserForClass
	| name class |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	class := Smalltalk at: name asSymbol ifAbsent: [^self].
	(RefactoringBrowser open navigator)
		selectClass: class;
		changed! !

!BrowserCodeTool methodsFor: 'menu'!

assignmentMenuFor: aParseTree 
	(self isEditing not 
		and: [(aParseTree whoDefines: aParseTree variable name) notNil]) 
			ifTrue: [self enableMenu: assignmentMenu]
			ifFalse: [self disableMenu: assignmentMenu].
	^assignmentMenu!

classVariableMenu
	self isEditing 
		ifTrue: 
			[self enableMenu: classVariableMenu except: #('rename class variable...')]
		ifFalse: [self enableMenu: classVariableMenu].
	^classVariableMenu!

globalVariableMenuFor: anAssociation 
	anAssociation value isBehavior 
		ifTrue: [self enableMenu: globalVariableMenu]
		ifFalse: 
			[self disableMenu: globalVariableMenu except: #('browse references...')].
	^globalVariableMenu!

instanceVariableMenu
	self isEditing 
		ifTrue: 
			[self enableMenu: instanceVariableMenu
				except: #('rename instance variable...')]
		ifFalse: [self enableMenu: instanceVariableMenu].
	^instanceVariableMenu!

messageMenuFor: aNode 
	| disabled |
	disabled := OrderedCollection new.
	self isEditing 
		ifTrue: [disabled addAll: #('extract to temporary...' 'inline message')].
	aNode isUsed ifFalse: [disabled add: 'extract to temporary...'].
	self enableMenu: messageMenu except: disabled.
	^messageMenu!

noMenu
	self disableMenu: noMenu.
	^noMenu!

noSelectionItems
	^#('extract method...' 'explain' 'do it' 'print it' 'inspect it')!

otherMenuItems
	^self isEditing | self selector isNil 
		ifTrue: [#('extract method...')]
		ifFalse: [#()]!

selectMenu
	| node |
	node := self findNode.
	node isNil ifTrue: [^self noMenu].
	node isVariable ifTrue: [^self selectVariableMenuFor: node].
	node isMessage ifTrue: [^self messageMenuFor: node].
	node isAssignment ifTrue: [^self assignmentMenuFor: node].
	node isValue ifTrue: [^self valueNodeMenuFor: node].
	^self noMenu!

selectVariableMenuFor: aNode 
	(aNode whoDefines: aNode name) notNil 
		ifTrue: [^self temporaryMenuFor: aNode].
	(self selectedClass allInstVarNames includes: aNode name) 
		ifTrue: [^self instanceVariableMenu].
	(self nonMetaClass allClassVarNames 
		detect: [:each | each asString = aNode name]
		ifNone: [nil]) notNil 
		ifTrue: [^self classVariableMenu].
	^(Smalltalk includesKey: aNode name asSymbol) 
		ifTrue: 
			[self globalVariableMenuFor: (Smalltalk associationAt: aNode name asSymbol)]
		ifFalse: [self noMenu]!

temporaryMenuFor: aNode 
	self isEditing 
		ifTrue: [self disableMenu: temporaryMenu]
		ifFalse: 
			[aNode parent isNil 
				ifTrue: [self enableMenu: temporaryMenu]
				ifFalse: 
					[aNode parent isMethod 
						ifTrue: 
							[self enableMenu: temporaryMenu
								except: #('convert to instance variable' 'move to inner scope')]
						ifFalse: [self enableMenu: temporaryMenu except: #('remove parameter' 'inline parameter')]]].
	^temporaryMenu!

valueNodeMenuFor: aParseTree 
	(self isEditing not and: [aParseTree isUsed]) 
		ifTrue: [self enableMenu: valueNodeMenu]
		ifFalse: [self disableMenu: valueNodeMenu].
	^valueNodeMenu! !

!BrowserCodeTool methodsFor: 'private'!

convertToSourceInterval: anInterval 
	"Convert the selected interval from our text widget, to the interval in the stored source code.
	For this widget, we don't need to do anything."

	^anInterval!

findNode
	| tree node interval |
	interval := self selectedInterval.
	interval isEmpty ifTrue: [^nil].
	tree := BRParser parseMethod: self text
				onError: [:str :err | ^self parseSelection].
	node := tree whichNodeIsContainedBy: interval.
	node isNil ifTrue: [node := tree bestNodeFor: interval].
	^node!

modifiedTextColor
	^ColorValue red!

parseSelection
	^BRParser parseExpression: self selectedText onError: [:str :pos | ^nil]!

updateSelection
	| controller view interval |
	controller := self textController.
	controller isNil ifTrue: [^self].
	view := controller view.
	interval := self environment selectionIntervalFor: self text.
	interval isNil ifTrue: [^self].
	controller selectFrom: interval first to: interval last.
	view displaySelection: true.
	view selectAndScroll!

updateTextWidget
	| widget prefs |
	builder isNil ifTrue: [^self].
	widget := builder componentAt: #textEditor.
	widget isNil ifTrue: [^self].
	modified 
		= (widget lookPreferences foregroundColor = self modifiedTextColor) 
			ifTrue: [^self].
	prefs := modified 
				ifTrue: [widget lookPreferences foregroundColor: self modifiedTextColor]
				ifFalse: [nil].
	widget lookPreferences: prefs! !

!BrowserCodeTool methodsFor: 'instance variables'!

abstractInstVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self abstractInstVar: name!

createInstVarAccessors
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self createAccessorsForInstVar: name!

protectInstVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self protectInstVar: name!

pushUpInstVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self pushUpInstVar: name!

renameInstVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self renameInstVar: name!

selectedVariableName
	| node |
	node := self findNode.
	^(node notNil and: [node isVariable]) ifTrue: [node name] ifFalse: [nil]! !

!BrowserCodeTool methodsFor: 'messages'!

browseImplementors
	| node |
	node := self findNode.
	(node isNil or: [node isMessage not]) ifTrue: [^self].
	(BrowserEnvironment new implementorsOf: node selector) openEditor!

browseSenders
	| node |
	node := self findNode.
	(node isNil or: [node isMessage not]) ifTrue: [^self].
	(BrowserEnvironment new referencesTo: node selector) openEditor!

inlineMethod
	| node |
	node := self findNode.
	(node isNil or: [node isMessage not]) 
		ifTrue: [^self warn: 'Could not find message send'].
	(node receiver isVariable 
		and: [#('self' 'super') includes: node receiver name]) 
			ifTrue: 
				[self performRefactoring: (InlineMethodRefactoring 
							inline: (self convertToSourceInterval: node sourceInterval)
							inMethod: self selector
							forClass: self selectedClass)]
			ifFalse: 
				[self performRefactoring: (InlineMethodFromComponentRefactoring 
							inline: (self convertToSourceInterval: node sourceInterval)
							inMethod: self selector
							forClass: self selectedClass)]! !

!BrowserCodeTool methodsFor: 'temporary variables'!

bindTight
	self performRefactoring: (MoveVariableDefinitionRefactoring 
				bindTight: (self convertToSourceInterval: self selectedInterval)
				in: self selectedClass
				selector: self selector)!

createInstVar
	self performRefactoring: (TempToInstVarRefactoring 
				class: self selectedClass
				selector: self selector
				variable: self selectedText)!

inlineParameter
	self handleError: 
			[| ref |
			ref := InlineParameterRefactoring 
						inlineParameter: self selectedText
						in: self selectedClass
						selector: self selector.
			ref execute.
			codeModel setSelector: ref newSelector]!

removeParameter
	self handleError: 
			[| ref |
			ref := RemoveParameterRefactoring 
						removeParameter: self selectedText
						in: self selectedClass
						selector: self selector.
			ref execute.
			codeModel setSelector: ref newSelector]!

renameTemporary
	| newName node |
	node := self findNode.
	(node isNil or: [node isVariable not]) 
		ifTrue: [^self warn: 'Could not find the node'].
	newName := self request: 'Enter new name:' initialAnswer: node name.
	newName isEmpty ifTrue: [^self].
	self performRefactoring: (RenameTempRefactoring 
				renameTemporaryFrom: (self convertToSourceInterval: node sourceInterval)
				to: newName
				in: self selectedClass
				selector: self selector)! !

!BrowserCodeTool methodsFor: 'class variables'!

abstractClassVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self abstractClassVar: name!

browseClassVarRefs
	| name association |
	name := self selectedVariableName.
	association := self navigator findAssociationForClassVariable: name.
	self navigator browseGlobalReferencesTo: association in: self nonMetaClass!

createClassVarAccessors
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self createAccessorsForClassVar: name!

pushUpClassVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self pushUpClassVar: name!

renameClassVar
	| name |
	name := self selectedVariableName.
	name isNil ifTrue: [^self].
	self renameClassVar: name! !

!BrowserCodeTool methodsFor: 'testing'!

overwriteExistingMethod
	| newSelector |
	newSelector := BRParser parseMethodPattern: self text.
	(newSelector notNil and: 
			[newSelector ~= self selector 
				and: [self selectedClass includesSelector: newSelector]]) 
		ifTrue: 
			[(self confirm: ('<1s> is already defined in <2p>.<n>Overwrite?' 
						expandMacrosWith: newSelector
						with: self selectedClass)) 
				ifFalse: [^false]].
	^true! !

BrowserCodeTool class
	instanceVariableNames: ''!



!BrowserCodeTool class methodsFor: 'resources'!

assignmentMenu
	"UIMenuEditor new openOnClass: self andSelector: #assignmentMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'inline temporary' 
				#value: #inlineTemporary ) ) #(1 ) nil ) decodeAsLiteralArray!

classVariableMenu
	"UIMenuEditor new openOnClass: self andSelector: #classVariableMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 're&ferences...' 
				#value: #browseClassVarRefs ) 
			#(#MenuItem 
				#rawLabel: 're&name class variable...' 
				#value: #renameClassVar ) 
			#(#MenuItem 
				#rawLabel: 'push &up' 
				#value: #pushUpClassVar ) 
			#(#MenuItem 
				#rawLabel: 'create accessors' 
				#value: #createClassVarAccessors ) 
			#(#MenuItem 
				#rawLabel: 'abstract' 
				#value: #abstractClassVar ) ) #(1 1 1 2 ) nil ) decodeAsLiteralArray!

globalVariableMenu
	"MenuEditor new openOnClass: self andSelector: #globalVariableMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'navigate to' 
				#value: #navigateToClass ) 
			#(#MenuItem 
				#rawLabel: 'open browser on...' 
				#value: #openBrowserForClass ) 
			#(#MenuItem 
				#rawLabel: 'browse references...' 
				#value: #browseReferencesToGlobal ) ) #(2 1 ) nil ) decodeAsLiteralArray!

instanceVariableMenu
	"MenuEditor new openOnClass: self andSelector: #instanceVariableMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 're&ferences...' 
				#value: #browseInstVarRefs ) 
			#(#MenuItem 
				#rawLabel: '&readers...' 
				#value: #browseInstVarReaders ) 
			#(#MenuItem 
				#rawLabel: '&writers...' 
				#value: #browseInstVarWriters ) 
			#(#MenuItem 
				#rawLabel: 're&name instance variable...' 
				#value: #renameInstVar ) 
			#(#MenuItem 
				#rawLabel: 'push &up' 
				#value: #pushUpInstVar ) 
			#(#MenuItem 
				#rawLabel: 'create accessors' 
				#value: #createInstVarAccessors ) 
			#(#MenuItem 
				#rawLabel: 'abstract' 
				#value: #abstractInstVar ) 
			#(#MenuItem 
				#rawLabel: 'protect/concrete' 
				#value: #protectInstVar ) ) #(3 1 1 3 ) nil ) decodeAsLiteralArray!

menu
	"UIMenuEditor new openOnClass: self andSelector: #menu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&find...' 
				#value: #find ) 
			#(#MenuItem 
				#rawLabel: '&replace...' 
				#value: #replace ) 
			#(#MenuItem 
				#rawLabel: '&undo' 
				#value: #undo ) 
			#(#MenuItem 
				#rawLabel: '&copy' 
				#value: #copySelection ) 
			#(#MenuItem 
				#rawLabel: 'cu&t' 
				#value: #cut ) 
			#(#MenuItem 
				#rawLabel: '&paste' 
				#value: #paste ) 
			#(#MenuItem 
				#rawLabel: '&do it' 
				#value: #doIt ) 
			#(#MenuItem 
				#rawLabel: 'pri&nt it' 
				#value: #printIt ) 
			#(#MenuItem 
				#rawLabel: '&inspect it' 
				#value: #inspectIt ) 
			#(#MenuItem 
				#rawLabel: '&accept' 
				#value: 
				#accept:from: ) 
			#(#MenuItem 
				#rawLabel: 'cancel' 
				#value: #cancelText ) 
			#(#MenuItem 
				#rawLabel: 'f&ormat' 
				#value: #format ) 
			#(#MenuItem 
				#rawLabel: 'e&xplain' 
				#value: 
				#explain:from: ) 
			#(#MenuItem 
				#rawLabel: '&extract method...' 
				#value: #extractMethod ) ) #(2 1 3 3 2 2 1 ) nil ) decodeAsLiteralArray!

messageMenu
	"UIMenuEditor new openOnClass: self andSelector: #messageMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&senders...' 
				#value: #browseSenders ) 
			#(#MenuItem 
				#rawLabel: 'implementors...' 
				#value: #browseImplementors ) 
			#(#MenuItem 
				#rawLabel: 'inline message' 
				#value: #inlineMethod ) 
			#(#MenuItem 
				#rawLabel: '&extract to temporary...' 
				#value: #extractToTemp ) ) #(2 2 ) nil ) decodeAsLiteralArray!

noMenu
	"MenuEditor new openOnClass: self andSelector: #noMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '-empty-' 
				#enabled: false 
				#value: #yourself ) ) #(1 ) nil ) decodeAsLiteralArray!

temporaryMenu
	"MenuEditor new openOnClass: self andSelector: #temporaryMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'con&vert to instance variable' 
				#value: #createInstVar ) 
			#(#MenuItem 
				#rawLabel: '&remove parameter' 
				#value: #removeParameter ) 
			#(#MenuItem 
				#rawLabel: '&inline parameter' 
				#value: #inlineParameter ) 
			#(#MenuItem 
				#rawLabel: 're&name...' 
				#value: #renameTemporary ) 
			#(#MenuItem 
				#rawLabel: 'move to inner &scope' 
				#value: #bindTight ) ) #(5 ) nil ) decodeAsLiteralArray!

valueNodeMenu
	"UIMenuEditor new openOnClass: self andSelector: #valueNodeMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&extract to temporary...' 
				#value: #extractToTemp ) ) #(1 ) nil ) decodeAsLiteralArray! !

BrowserTextTool subclass: #ClassCommentTool
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Code Tools'!

ClassCommentTool comment:
'ClassCommentTool is the CodeTool that edits class comments.'!


!ClassCommentTool methodsFor: 'accepting'!

accept: aText from: aController 
	self nonMetaClass comment: aText string.
	self text: aText! !

!ClassCommentTool methodsFor: 'testing'!

isEnabled
	^self nonMetaClass notNil! !

!ClassCommentTool methodsFor: 'updating'!

updateContents
	| tmp |
	self className isNil ifTrue: [^self text: '' asText].
	tmp := self nonMetaClass comment asText.
	tmp isEmpty ifFalse: [^self text: tmp].
	self text: self defaultComment! !

!ClassCommentTool methodsFor: 'private'!

defaultComment
	| commentStream class vars typer |
	class := self nonMetaClass.
	typer := (RefactoryTyper new)
				runOn: class;
				yourself.
	commentStream := WriteStream on: String new.
	commentStream
		emphasis: #bold;
		nextPutAll: class name;
		nextPutAll: ' has not been commented.';
		emphasis: nil;
		nextPutAll: '  The comment should state the purpose of the class and also explain any unobvious aspects of the implementation.';
		cr;
		cr.
	self printSubclassResponsibilitiesFor: class on: commentStream.
	vars := class instVarNames.
	vars isEmpty 
		ifFalse: 
			[commentStream
				nextPutAll: 'Instance Variables:';
				cr.
			self 
				printVariables: vars
				types: typer
				on: commentStream].
	vars := class classVarNames.
	vars isEmpty 
		ifFalse: 
			[commentStream
				nextPutAll: 'Class Variables:';
				cr.
			self 
				printVariables: vars
				types: typer
				on: commentStream].
	^commentStream contents!

generateDefaultComment
	self textNoChange: self defaultComment!

printSubclassResponsibilitiesFor: class on: commentStream 
	| protocols selectors |
	selectors := class whichSelectorsReferTo: 'subclassResponsibility' asSymbol.
	selectors isEmpty ifTrue: [^self].
	commentStream
		nextPutAll: 'Subclasses must implement the following messages:';
		cr.
	protocols := (selectors
				collect: [:each | BrowserEnvironment new whichProtocolIncludes: each in: class])
					asSet asSortedCollection.
	selectors := selectors asSortedCollection.
	protocols do: 
			[:protocol | 
			commentStream tab;
				nextPutAll: protocol;
				cr.
			selectors do: 
					[:sel | 
					protocol == (BrowserEnvironment new whichProtocolIncludes: sel in: class)
						ifTrue: 
							[commentStream tab;
								tab;
								nextPutAll: sel;
								cr]]].
	commentStream cr!

printVariables: vars types: aRefactoryTyper on: commentStream 
	vars asSortedCollection do: 
			[:each | 
			commentStream
				tab;
				nextPutAll: each;
				tab;
				nextPut: $<.
			aRefactoryTyper printTypeFor: each on: commentStream.
			commentStream
				nextPutAll: '>	description of ';
				nextPutAll: each;
				cr].
	commentStream cr! !

ClassCommentTool class
	instanceVariableNames: ''!



!ClassCommentTool class methodsFor: 'resources'!

menu
	"MenuEditor new openOnClass: self andSelector: #menu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: '&find...' 
				#value: #find ) 
			#(#MenuItem 
				#rawLabel: '&replace...' 
				#value: #replace ) 
			#(#MenuItem 
				#rawLabel: '&undo' 
				#value: #undo ) 
			#(#MenuItem 
				#rawLabel: '&copy' 
				#value: #copySelection ) 
			#(#MenuItem 
				#rawLabel: 'cu&t' 
				#value: #cut ) 
			#(#MenuItem 
				#rawLabel: '&paste' 
				#value: #paste ) 
			#(#MenuItem 
				#rawLabel: '&do it' 
				#value: #doIt ) 
			#(#MenuItem 
				#rawLabel: 'pri&nt it' 
				#value: #printIt ) 
			#(#MenuItem 
				#rawLabel: '&inspect it' 
				#value: #inspectIt ) 
			#(#MenuItem 
				#rawLabel: '&accept' 
				#value: 
				#accept:from: ) 
			#(#MenuItem 
				#rawLabel: 'cancel' 
				#value: #cancelText ) 
			#(#MenuItem 
				#rawLabel: 'default co&mment' 
				#value: #generateDefaultComment ) 
			#(#MenuItem 
				#rawLabel: '&hardcopy' 
				#value: #hardcopy ) ) #(2 1 3 3 2 1 1 ) nil ) decodeAsLiteralArray! !

RefactoringBrowser initialize!

BrowserNavigator initialize!

ResourceTool initialize!


