'From VisualWorks, Release 3.0 of February 5, 1998 on October 14, 1998 at 7:30:36 pm'!

!Behavior methodsFor: 'RefactoringBrowser'!

whichSelectorsRead: instVarName 
	"Answer a set of selectors whose methods read the argument, instVarName, 
	as a named instance variable."

	| instVarIndex |
	instVarIndex := self allInstVarNames indexOf: instVarName ifAbsent: [^Set new].
	^methodDict keys
		select: [:sel | (methodDict at: sel) readsField: instVarIndex]! !


!ChangeSet methodsFor: 'RefactoringBrowser'!

changed: anAspectSymbol with: aParameter 
	"Allow objects to depend on the ChangeSet class instead of a particular instance 
	of ChangeSet (which may be switched using projects)."

	ChangeSet changed: anAspectSymbol with: aParameter.
	super changed: anAspectSymbol with: aParameter! !

MultiSelectionSequenceView subclass: #BRMultiSelectionView
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!



!BRMultiSelectionView methodsFor: 'updating'!

updateSelectionChannel
	| indx range |
	range := self visibleIntervalForBounds: self bounds.
	indx := selectionChannel value detect: [:each | true] ifNone: [self zeroIndex].
	((selectionChannel value
		contains: [:each | each between: range first and: range last])
			or: [indx = self zeroIndex]) ifFalse: [self makeVisible: indx].
	super updateSelectionChannel! !

!BRMultiSelectionView methodsFor: 'private'!

retractSelectionIndex: anIndex 
	self selectionChannel removeDependent: self.
	super retractSelectionIndex: anIndex.
	self selectionChannel addDependent: self!

useSweepSelectionIndex: anIndex 
	| save list newList |
	lastSelectionIndex = self zeroIndex ifTrue: 
			[self retractAllSelections.
			^self].
	save := lastSelectionIndex.
	list := self selections copy.
	newList := save to: anIndex by: (save < anIndex ifTrue: [1] ifFalse: [-1]).
	selectionIndex := self zeroIndex.
	list do: 
			[:i | 
			(newList includes: i) ifFalse: 
					[selections remove: i ifAbsent: [].
					self invalidateElementIndex: i]].
	newList do: 
			[:i | 
			(list includes: i) ifFalse: 
					[selections add: i.
					self invalidateElementIndex: i]].
	lastSelectionIndex := save.
	self selectionChannel value: selections! !

BRMultiSelectionView class
	instanceVariableNames: ''!


ApplicationModel subclass: #BrowserApplicationModel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!

BrowserApplicationModel comment:
'BrowserApplicationModel is an abstact class that extends the standard ApplicationModel. It adds functions to easily change subcanvases and change the properties of the widgets.

Subclasses with subcanvases should override the #subcanvases method so that the new subcanvas is also return in the list of subcanvas open in this application. The subcanvas information is used so that #updateRequest''s can be made of the whole application without the need to write a specific updateRequest in each subclass that defines uses a subcanvas. Also, when installing the same application model several different times, the builder must be nil''ed and the #subcanvases method is also used to nil the builder.'!


!BrowserApplicationModel methodsFor: 'accessing'!

preferredSpec
	^#windowSpec! !

!BrowserApplicationModel methodsFor: 'updating'!

updateRequest
	^super updateRequest and: [self subcanvases inject: true into: [:bool :each | bool and: [each updateRequest]]]! !

!BrowserApplicationModel methodsFor: 'menu accessing'!

disableMenu: aMenu
	^self disableMenu: aMenu except: #()!

disableMenu: aMenu except: aCollection 
	aMenu menuItems
		do: 
			[:each | 
			(aCollection includes: each label)
				ifTrue: [each enable]
				ifFalse: [each disable].
			each submenu notNil ifTrue: [self disableMenu: each submenu except: aCollection]].
	^aMenu!

enableMenu: aMenu
	^self enableMenu: aMenu except: #()!

enableMenu: aMenu except: aCollection 
	aMenu menuItems
		do: 
			[:each | 
			(aCollection includes: each label)
				ifTrue: [each disable]
				ifFalse: [each enable].
			each submenu notNil ifTrue: [self enableMenu: each submenu except: aCollection]].
	^aMenu!

initializeMenu: aMenu 
	^self initializeMenu: aMenu using: nil!

initializeMenu: aMenu using: aController 
	"Hack aMenu so that it can be installed into window, and still send us the messages instead of 
	sending them to the window's model."

	aMenu values: (aMenu values collect: [:each | (aController notNil and: [#(#find #replace #undo #copySelection #cut #paste #doIt #printIt #inspectIt #hardcopy) includes: each])
				ifTrue: [[aController perform: each]]
				ifFalse: [each isSymbol
						ifTrue: [each numArgs == 1
								ifTrue: [[self perform: each with: aController]]
								ifFalse: [each numArgs == 2
										ifTrue: [[self
												perform: each
												with: aController text
												with: aController]]
										ifFalse: [[self perform: each]]]]
						ifFalse: [each]]]).
	aMenu menuItems do: [:each | each submenu notNil ifTrue: [each submenu: (self initializeMenu: each submenu using: aController)]].
	^aMenu!

menu
	"Return a default menu for all subclasses. This is used when embedding this object inside another app 
	model."

	^
	[| mb |
	mb := MenuBuilder new.
	mb add: 'No menu' -> #yourself.
	mb menu]! !

!BrowserApplicationModel methodsFor: 'subcanvases'!

installSubcanvasIn: aSymbol using: anApplicationModel
	self
		installSubcanvasIn: aSymbol
		using: anApplicationModel
		spec: #windowSpec!

installSubcanvasIn: aSymbol using: anApplicationModel spec: aSpec 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component widget client: anApplicationModel spec: aSpec]!

subcanvases
	^#()! !

!BrowserApplicationModel methodsFor: 'interface opening'!

createSelectedVisualBlockFrom: aBlock 
	^
	[:v :index | 
	| rw |
	rw := ReversingWrapper on: (aBlock value: v value: index).
	rw reverse setValue: true.
	BoundedWrapper on: rw]!

createVisualBlockFrom: block 
	^[:view :index | BoundingWrapper on: (block value: view value: index)]!

resetBuilder
	self builder: nil.
	self subcanvases do: [:each | each resetBuilder]! !

!BrowserApplicationModel methodsFor: 'window properties'!

bringWindowToTop
	| window |
	builder isNil ifTrue: [^self].
	window := builder window.
	(window notNil and: [window isOpen])
		ifTrue: [window isCollapsed
				ifTrue: [window expand]
				ifFalse: [window raise]]!

interfaceWindow
	builder notNil ifTrue: [^builder window].
	^nil!

setLabel: aLabel 
	(builder notNil and: [builder window notNil])
		ifTrue: [builder window label: aLabel]! !

!BrowserApplicationModel methodsFor: 'widget properties'!

controllerFor: aSymbol 
	| wrapper |
	builder isNil ifTrue: [^nil].
	wrapper := builder componentAt: aSymbol.
	wrapper isNil ifTrue: [^nil].
	^wrapper widget controller!

disable: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component disable]!

disableAll: aCollection
	aCollection do: [:each | self disable: each]!

enable: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component enable]!

enableAll: aCollection
	aCollection do: [:each | self enable: each]!

hide: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component beInvisible]!

hideAll: aCollection
	aCollection do: [:each | self hide: each]!

invalidateComponent: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component invalidate]!

show: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component beVisible]!

showAll: aCollection
	aCollection do: [:each | self show: each]! !

!BrowserApplicationModel methodsFor: 'requests'!

choose: aString fromList: aCollection values: valueCollection ignore: ignoreChoices initialSelection: anIndex lines: anInteger cancel: cancelBlock 
	| labels sd spec listW buttons |
	labels := SelectionInList new.
	labels list: aCollection asList.
	anIndex notNil ifTrue: [labels selectionIndex: anIndex].
	sd := SimpleDialog new.
	spec := sd class interfaceSpecFor: #emptySpec.
	sd builder add: spec window.
	sd builder add: spec component.
	sd setInitialGap.
	sd addMessage: aString centered: false.
	sd addGap: 8.
	listW := sd addList: labels
				lines: anInteger
				validation: [labels selectionIndex > 0].
	listW widget setValidTargetIndex: labels selectionIndex.
	sd addGap: 4.
	buttons := sd addOK: [labels selectionIndex ~= 0].
	sd addGap: 6.
	sd bottomAlignLowerEdge: listW.
	sd bottomAlign: (Array with: buttons).
	labels selectionIndexHolder compute: 
			[:v | 
			(v > 0 and: [ignoreChoices includes: v]) ifTrue: 
					[labels selectionIndex: 0.
					listW widget targetIndex: 0]].
	sd preOpen.
	sd builder openDialogWithExtent: sd builder window displayBox extent.
	^sd accept value
		ifTrue: [valueCollection at: labels selectionIndex]
		ifFalse: [cancelBlock value]!

choose: aString fromList: aCollection values: valueCollection lines: anInteger cancel: aBlock 
	^Dialog
		choose: aString
		fromList: aCollection
		values: valueCollection
		lines: anInteger
		cancel: aBlock
		for: self interfaceWindow!

confirm: aString
	^Dialog confirm: aString!

request: aString 
	^Dialog request: aString!

request: aString initialAnswer: anAnswerString
	^Dialog request: aString initialAnswer: anAnswerString!

showWaitCursorWhile: aBlock 
	^Cursor wait showWhile: aBlock!

warn: aString 
	^Dialog warn: aString! !

BrowserApplicationModel class
	instanceVariableNames: ''!



!BrowserApplicationModel class methodsFor: 'interface specs'!

emptySpec
	"UIPainter new openOnClass: self andSelector: #emptySpec"

	<resource: #canvas>
	^#(#FullSpec
		#window:
		#(#WindowSpec
			#label: 'Unlabeled Canvas'
			#bounds: #(#Rectangle 369 270 569 470 ) )
		#component:
		#(#SpecCollection
			#collection: #() ) )! !

SimpleDialog subclass: #BrowserDialog
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!

BrowserDialog comment:
'BrowserDialog is an abstact class that extends the standard SimpleDialog. It adds functions to easily change the properties of the widgets.'!


!BrowserDialog methodsFor: 'widget properties'!

disable: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component disable]!

disableAll: aCollection
	aCollection do: [:each | self disable: each]!

enable: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component enable]!

enableAll: aCollection
	aCollection do: [:each | self enable: each]!

hide: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component beInvisible]!

hideAll: aCollection
	aCollection do: [:each | self hide: each]!

show: aSymbol 
	| component |
	builder isNil ifTrue: [^self].
	component := builder componentAt: aSymbol.
	component notNil ifTrue: [component beVisible]!

showAll: aCollection
	aCollection do: [:each | self show: each]! !

BrowserDialog class
	instanceVariableNames: ''!



!BrowserDialog class methodsFor: 'resources'!

disabledDownIcon
	"UIMaskEditor new openOnClass: self andSelector: #disabledDownIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 0 0 1 0 128 0 3 0 192 0 7 0 224 0 15 0 240 0 31 0 248 0 63 0 252 0 127 0 254 0 255 0 255 1 255 0 255 131 255 0 255 199 255 0 255 239 255 0])!

disabledDownIconMask
	"UIMaskEditor new openOnClass: self andSelector: #disabledDownIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 0 128 0 1 0 64 0 2 0 32 0 4 0 16 0 8 0 8 0 16 0 4 0 32 0 2 0 64 0 1 0 128 0 0 129 0 0 0 66 0 0 0 36 0 0 0 24 0 0])!

disabledUpIcon
	"UIMaskEditor new openOnClass: self andSelector: #disabledUpIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 24 0 0 0 60 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 255 192 0 7 255 224 0 15 255 240 0 31 255 248 0 63 255 252 0 127 255 254 0 255 255 255 0 0 0 0 0])!

disabledUpIconMask
	"UIMaskEditor new openOnClass: self andSelector: #disabledUpIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 24 0 0 0 36 0 0 0 66 0 0 0 129 0 0 1 0 128 0 2 0 64 0 4 0 32 0 8 0 16 0 16 0 8 0 32 0 4 0 64 0 2 0 128 0 1 0 255 255 255 0])!

downIcon
	"UIMaskEditor new openOnClass: self andSelector: #downIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette blackWhite usingBits: #[0 0 0 0 0 0 0 0 128 0 1 0 192 0 3 0 224 0 7 0 240 0 15 0 248 0 31 0 252 0 63 0 254 0 127 0 255 0 255 0 255 129 255 0 255 195 255 0 255 231 255 0])!

downIconMask
	"UIMaskEditor new openOnClass: self andSelector: #downIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[255 255 255 0 255 255 255 0 127 255 254 0 63 255 252 0 31 255 248 0 15 255 240 0 7 255 224 0 3 255 192 0 1 255 128 0 0 255 0 0 0 126 0 0 0 60 0 0 0 24 0 0])!

upIcon
	"UIMaskEditor new openOnClass: self andSelector: #upIcon"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: MonoMappedPalette whiteBlack usingBits: #[0 24 0 0 0 60 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 255 192 0 7 255 224 0 15 255 240 0 31 255 248 0 63 255 252 0 127 255 254 0 255 255 255 0 255 255 255 0])!

upIconMask
	"UIMaskEditor new openOnClass: self andSelector: #upIconMask"

	<resource: #image>
	^CachedImage on: (Image extent: 24@13 depth: 1 bitsPerPixel: 1 palette: CoveragePalette monoMaskPalette usingBits: #[0 24 0 0 0 60 0 0 0 126 0 0 0 255 0 0 1 255 128 0 3 255 192 0 7 255 224 0 15 255 240 0 31 255 248 0 63 255 252 0 127 255 254 0 255 255 255 0 255 255 255 0])! !

!BrowserDialog class methodsFor: 'images'!

downImage
	^OpaqueImageWithEnablement
		figure: self downIcon
		shape: self downIconMask
		inactiveFigure: self disabledDownIcon
		inactiveShape: self disabledDownIconMask!

upImage
	^OpaqueImageWithEnablement
		figure: self upIcon
		shape: self upIconMask
		inactiveFigure: self disabledUpIcon
		inactiveShape: self disabledUpIconMask! !

BrowserApplicationModel subclass: #Navigator
	instanceVariableNames: 'categoryList categoryMenuHolder classList classMenuHolder selectorMenuHolder protocolMenuHolder selectorList metaHolder protocolList '
	classVariableNames: 'LastProtocol SortProtocols '
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

Navigator comment:
'Navigator is an abstract class that defines the interface that displays the classes/methods of an BrowserEnvironment. Its subclasses define what actions can be taken for the different selections.

Subclasses must implement the following messages:
	accessing
		environment

Instance Variables:
	categoryList	<SelectionInList on: Symbol>	the list of categories shown
	categoryMenuHolder	<ValueHolder on: Menu>	the category menu
	classList	<SelectionInList on: Symbol>	the list of class names shown
	classMenuHolder	<ValueHolder on: Menu>	the class menu
	metaHolder	<ValueHolder on: Boolean>	are we looking at the metaclass?
	protocolList	<SelectionInList on: Symbol>	the list of protocols shown
	protocolMenuHolder	<ValueHolder on: Menu>	the protocol menu
	selectorList	<SelectionInList on: Symbol>	the list of selectors shown
	selectorMenuHolder	<ValueHolder on: Menu>	the selector menu

Class Variables:
	LastProtocol	<Symbol | nil>	the last protocol selected by the user
	SortProtocols	<Boolean>	should we sort the protocols?'!


!Navigator methodsFor: 'initialize-release'!

initialize
	super initialize.
	categoryMenuHolder := (self initializeMenu: self class categoryMenu) asValue.
	classMenuHolder := (self initializeMenu: self class classMenu) asValue.
	protocolMenuHolder := (self initializeMenu: self class protocolMenu) asValue.
	selectorMenuHolder := (self initializeMenu: self class selectorMenu) asValue.
	self meta value: false! !

!Navigator methodsFor: 'accessing'!

beHierarchy!

environment
	^self subclassResponsibility!

getState
	| state |
	state := NavigatorState new.
	state categories: self categories.
	state selectedClasses: self selectedClasses.
	state protocols: self protocols.
	state selectors: self selectors.
	^state!

setState: aNavigatorState 
	self setState: aNavigatorState updateClasses: false! !

!Navigator methodsFor: 'accessing-category'!

categories
	^self categoryList selections!

category
	^self categories detect: [:each | true]
		ifNone: [nil]!

changedCategory
	self updateClassList.
	self updateCategoryMenu.
	self changed: #category with: self category!

newCategoryList: initialSelections 
	self newCategoryListNoUpdate: initialSelections.
	self updateClassList!

newCategoryListNoUpdate: initialSelections 
	self categoryList list: (List withAll: self environment categories).
	self categoryList selections: initialSelections.
	self updateCategoryMenu! !

!Navigator methodsFor: 'accessing-class'!

changedClass
	self updateProtocolList.
	self updateClassMenu.
	self changed: #class with: self selectedClass!

classForName: className 
	| class |
	className isNil ifTrue: [^nil].
	class := Smalltalk at: className ifAbsent: [nil].
	class isBehavior ifFalse: [^nil].
	^class!

className
	^self classNames detect: [:each | true]
		ifNone: [nil]!

classNames
	^self classList selections!

newClassList: initialSelections 
	self newClassListNoUpdate: initialSelections.
	self updateProtocolList!

newClassListNoUpdate: initialSelections 
	| newList |
	newList := Set new.
	self categories do: [:each | newList addAll: (self environment classNamesFor: each)].
	classList list: newList asSortedCollection asList.
	classList selections: initialSelections.
	self updateClassMenu!

nonMetaClass
	^self classForName: self className!

nonMetaClasses
	| names classes |
	names := self classNames.
	classes := OrderedCollection new: names size.
	names
		do: 
			[:each | 
			| class |
			class := self classForName: each.
			class notNil ifTrue: [classes add: class]].
	^classes!

selectedClass
	| class |
	class := self nonMetaClass.
	^(class notNil and: [self isMeta]) ifTrue: [class class] ifFalse: [class]!

selectedClasses
	| nonMetaClasses |
	nonMetaClasses := self nonMetaClasses.
	^self isMeta
		ifTrue: [nonMetaClasses collect: [:each | each class]]
		ifFalse: [nonMetaClasses]!

updateClassList
	self newClassList: self classNames! !

!Navigator methodsFor: 'accessing-class/inst switch'!

changedMeta
	self updateProtocolList.
	self changed: #meta with: self isMeta!

isMeta
	^self meta value!

meta: aBoolean
	self meta value: aBoolean! !

!Navigator methodsFor: 'accessing-protocol'!

changedProtocol
	| protocol |
	protocol := self protocol.
	protocol notNil ifTrue: [LastProtocol := protocol].
	self updateSelectorList.
	self updateProtocolMenu.
	self changed: #protocol with: protocol!

newProtocolList: initialSelections 
	self newProtocolListNoUpdate: initialSelections.
	self updateSelectorList!

newProtocolListNoUpdate: initialSelections 
	| class protocols |
	class := self selectedClass.
	protocols := (class notNil and: [self application notNil and: [self classNames size = 1]])
				ifTrue: [self environment protocolsFor: class]
				ifFalse: [#()].
	SortProtocols ifTrue: [protocols := protocols asSortedCollection].
	protocolList list: protocols asList.
	protocolList selections: initialSelections.
	self updateProtocolMenu!

protocol
	^self protocols detect: [:each | true]
		ifNone: [nil]!

protocols
	^self protocolList selections!

updateProtocolList
	self newProtocolList: self protocols! !

!Navigator methodsFor: 'accessing-selector'!

changedSelector
	self updateSelectorMenu.
	self changed: #selector with: self selector!

newSelectorList: initialSelections 
	| protocols class selectors |
	class := self selectedClass.
	class isNil
		ifTrue: [selectors := #()]
		ifFalse: 
			[selectors := Set new.
			protocols := self protocols.
			protocols do: [:each | selectors addAll: (self environment selectorsFor: each in: class)]].
	selectorList list: selectors asSortedCollection asList.
	selectorList selections: initialSelections.
	self updateSelectorMenu!

selector
	^self selectors detect: [:each | true]
		ifNone: [nil]!

selectors
	^self selectorList selections!

updateSelectorList
	self newSelectorList: self selectors! !

!Navigator methodsFor: 'updating'!

updateCategoryList
	self changeRequest ifFalse: [^self].
	self setState: self getState updateClasses: true.
	self changed: #category with: self category!

updateMenus
	self updateCategoryMenu.
	self updateClassMenu.
	self updateProtocolMenu.
	self updateSelectorMenu! !

!Navigator methodsFor: 'menus'!

updateCategoryMenu
	self category isNil
		ifTrue: [self disableMenu: categoryMenuHolder value except: #('add...' 'update' 'find class...')]
		ifFalse: [self enableMenu: categoryMenuHolder value]!

updateClassMenu
	self className isNil
		ifTrue: [self disableMenu: classMenuHolder value]
		ifFalse: [self enableMenu: classMenuHolder value]!

updateProtocolMenu
	self className isNil
		ifTrue: [self disableMenu: protocolMenuHolder value]
		ifFalse: [self protocol isNil
				ifTrue: [self disableMenu: protocolMenuHolder value except: #('add...' 'find method...')]
				ifFalse: [self enableMenu: protocolMenuHolder value]]!

updateSelectorMenu
	self selector isNil
		ifTrue: [self disableMenu: selectorMenuHolder value]
		ifFalse: [self enableMenu: selectorMenuHolder value]! !

!Navigator methodsFor: 'interface opening'!

postBuildWidget: aSymbol 
	| specWrapper |
	specWrapper := builder componentAt: aSymbol.
	specWrapper isNil ifTrue: [^self].
	specWrapper widget changeClassToThatOf: BRMultiSelectionView basicNew!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	#(#categoryList #classList #protocolList #selectorList) do: [:each | self postBuildWidget: each].
	self updateMenus! !

!Navigator methodsFor: 'events'!

closed
	self changed: #closed!

noticeOfWindowClose: aWindow
	self closed.
	^super noticeOfWindowClose: aWindow! !

!Navigator methodsFor: 'aspects'!

categoryHolder
	^self pluggableAdaptorFor: self categoryList!

categoryList
	^categoryList isNil
		ifTrue: [categoryList := BRMultiSelectionInList new]
		ifFalse: [categoryList]!

categoryMenu
	^categoryMenuHolder!

classHolder
	^self pluggableAdaptorFor: self classList!

classList
	^classList isNil
		ifTrue: [classList := BRMultiSelectionInList new]
		ifFalse: [classList]!

classMenu
	^classMenuHolder!

classNameHolder
	^BlockValue block: [:class :meta | class notNil
			ifTrue: [meta
					ifTrue: [class , ' class']
					ifFalse: [class]]
			ifFalse: ['']]
		arguments: (Array with: self classHolder with: self meta)!

meta
	"This method was generated by UIDefiner. Any edits made here 
	may be lost whenever methods are automatically defined. The 
	initialization provided below may have been preempted by an 
	initialize method."

	^metaHolder isNil
		ifTrue: [metaHolder := nil asValue]
		ifFalse: [metaHolder]!

pluggableAdaptorFor: aModel 
	^(PluggableAdaptor on: aModel)
		getBlock: [:model | model selections detect: [:each | true]
				ifNone: [nil]]
		putBlock: [:model :value | model selections: (Array with: value)]
		updateBlock: [:m :a :p | true]!

protocolHolder
	^self pluggableAdaptorFor: self protocolList!

protocolList
	^protocolList isNil
		ifTrue: [protocolList := BRMultiSelectionInList new]
		ifFalse: [protocolList]!

protocolMenu
	^protocolMenuHolder!

selectorHolder
	^self pluggableAdaptorFor: self selectorList!

selectorList
	^selectorList isNil
		ifTrue: [selectorList := BRMultiSelectionInList new]
		ifFalse: [selectorList]!

selectorMenu
	^selectorMenuHolder! !

!Navigator methodsFor: 'testing'!

isHierarchy
	^false! !

!Navigator methodsFor: 'private-category'!

findClass
	"Prompt for a class and position myself there."

	| testClass |
	self changeRequest ifFalse: [^self].

	[testClass := self pickAClass: 'Find class'.
	testClass = '' ifTrue: [^self].
	testClass isNil and: [(Dialog confirm: 'No matching class, try again?')
			ifFalse: [^self]
			ifTrue: [true]]] whileTrue.
	testClass isBehavior ifFalse: [testClass := testClass class].
	testClass isMeta ifTrue: [testClass := testClass soleInstance].
	self isMeta ifTrue: [testClass := testClass class].
	self selectClass: testClass.
	self changedClass!

pickAClass: prompt 
	| destClassName destClass classes |
	destClassName := Dialog request: prompt for: self interfaceWindow.
	destClassName = '' ifTrue: [^''].
	classes := Cursor execute showWhile: 
					[(self environment classNames select: [:cn | destClassName match: cn])
						asSortedCollection].
	(classes isNil or: [classes isEmpty])
		ifTrue: 
			[classes := (self environment keys select: [:cn | destClassName match: cn])
						asSortedCollection.
			classes isEmpty ifTrue: [^nil].
			(Dialog
				confirm: 'There are no matching class names.\Do you want to browse matching globals?'
						withCRs
				for: self interfaceWindow) ifFalse: [^nil].
			destClassName := Dialog choose: 'Browse the class of which global?'
						fromList: classes
						values: (classes collect: [:glob | (self environment at: glob) class name])
						lines: 10
						cancel: [^'']
						for: self interfaceWindow]
		ifFalse: 
			[destClassName := classes size = 1
						ifTrue: [classes first]
						ifFalse: 
							[Dialog choose: 'Choose a class'
								fromList: classes
								values: classes
								lines: 10
								cancel: [^'']
								for: self interfaceWindow]].
	destClass := self environment at: destClassName asSymbol ifAbsent: [^nil].
	self isMeta ifTrue: [destClass := destClass class].
	^destClass! !

!Navigator methodsFor: 'private-class'!

clearToClass
	self changeRequest ifFalse: [^self].
	self newProtocolList: #().
	self changedProtocol!

selectClass: aClass 
	| names meta |
	aClass isNil
		ifTrue: 
			[names := #().
			meta := self isMeta]
		ifFalse: 
			[meta := aClass isMeta.
			names := Array with: (meta ifTrue: [aClass soleInstance] ifFalse: [aClass]) name].
	self selectClasses: names
		meta: meta
		categories: #().
	self updateProtocolList!

selectClasses: classNames meta: aBoolean categories: categoryNames 
	| categories |
	self meta: aBoolean.
	categories := Set withAll: categoryNames.
	classNames do: [:each | categories add: (self environment whichCategoryIncludes: each)].
	self newCategoryListNoUpdate: categories asList.
	self newClassListNoUpdate: classNames! !

!Navigator methodsFor: 'private-protocol'!

findMethodAndSelectAlphabetic
	| chosenSelector selectorCollection selector |
	self changeRequest ifFalse: [^self].
	selector := Dialog request: 'Find selector:'.
	selector isEmpty ifTrue: [^self].
	selectorCollection := ((self environment selectorsForClass: self selectedClass)
				select: [:each | selector match: each]) asSortedCollection.
	selectorCollection isEmpty ifTrue: 
			[^(Dialog confirm: 'No selectors found.<n>Search again?' expandMacros)
				ifTrue: [self findMethodAndSelectAlphabetic]].
	chosenSelector := selectorCollection size == 1
				ifTrue: [selectorCollection first]
				ifFalse: 
					[Dialog choose: 'Find which selector?'
						fromList: selectorCollection
						values: selectorCollection
						lines: 10
						cancel: [nil]].
	chosenSelector isNil ifTrue: [^self].
	self setSelector: chosenSelector.
	LastProtocol := self protocol.
	self changedSelector!

setSelector: aSelector 
	aSelector isNil ifTrue: [^self].
	self setSelectors: (Array with: aSelector)
		in: (Array with: (self environment whichProtocolIncludes: aSelector in: self selectedClass))!

setSelectors: selectorCollection in: protocolCollection 
	| protocols class selectors |
	class := self selectedClass.
	class isNil
		ifTrue: [selectors := (protocols := #())]
		ifFalse: 
			[selectors := selectorCollection.
			protocols := protocolCollection asOrderedCollection.
			selectorCollection do: 
					[:each | 
					| protocol |
					protocol := self environment whichProtocolIncludes: each in: class.
					(protocols includes: protocol) ifFalse: [protocols add: protocol]]].
	self newProtocolListNoUpdate: protocols.
	self newSelectorList: selectors! !

!Navigator methodsFor: 'private'!

setState: aNavigatorState updateClasses: aBoolean 
	"Set the current selections to be that of aNavigatorState. If aBoolean is true then update the 
	application and class lists, otherwise only update them if their values have changed."

	aNavigatorState classNames isEmpty
		ifTrue: 
			[self newCategoryListNoUpdate: aNavigatorState categories.
			self newClassList: #()]
		ifFalse: 
			[(aBoolean not and: 
					[self isMeta == aNavigatorState isMeta and: 
							[aNavigatorState classNames = self classNames
								and: [aNavigatorState categories = self categories]]])
				ifFalse: 
					[self selectClasses: aNavigatorState classNames
						meta: aNavigatorState isMeta
						categories: aNavigatorState categories].
			self setSelectors: aNavigatorState selectors in: aNavigatorState protocols]! !

Navigator class
	instanceVariableNames: ''!



!Navigator class methodsFor: 'class initialization'!

initialize
	"self initialize"

	LastProtocol := ''.
	SortProtocols := false! !

MultiSelectionInList subclass: #BRMultiSelectionInList
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Browser'!



!BRMultiSelectionInList methodsFor: 'initialize-release'!

initialize
	super initialize.
	self selectionIndexHolder: self newSelections asValue! !

!BRMultiSelectionInList methodsFor: 'accessing'!

zeroIndex
	^self newSelections! !

!BRMultiSelectionInList methodsFor: 'selections in list'!

selections
	| list oc |
	oc := OrderedCollection new.
	list := listHolder value.
	selectionIndexHolder value
		do: [:i | (i between: 1 and: list size) ifTrue: [oc add: (list at: i)]].
	^oc!

selections: aCollection 
	| s l index |
	s := self newSelections.
	l := listHolder value.
	aCollection do: 
			[:val | 
			((index := l indexOf: val ifAbsent: []) notNil and: [(s includes: index) not])
				ifTrue: [s add: index]].
	self selectionIndexes: s! !

!BRMultiSelectionInList methodsFor: 'updating'!

update: anAspectd with: aParameter from: anObject 
	anObject == selectionIndexHolder ifTrue: [^self changed: #selectionIndex].
	anObject == listHolder ifFalse: [^self].
	selectionIndexHolder setValue: self newSelections.
	self changed: #list.
	selectionIndexHolder changed: #value! !

!BRMultiSelectionInList methodsFor: 'utility'!

clearAll
	selectionIndexHolder value: self newSelections!

selectAll
	selectionIndexHolder
		value: (self selectionClass withAll: (1 to: listHolder value size))! !

!BRMultiSelectionInList methodsFor: 'private'!

newSelections
	^self selectionClass new!

selectionClass
	^OrderedCollection! !

BRMultiSelectionInList class
	instanceVariableNames: ''!


Object subclass: #NavigatorState
	instanceVariableNames: 'categories classNames meta protocols selectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Navigator'!

NavigatorState comment:
'NavigatorState is a memento that the navigator uses to hold its state. It is held by each CodeModel so that when switching between the different code models, the navigator can easily be updated to the proper selection.

Instance Variables:
	categories	<Collection of: Symbol>	the selected categories
	classNames	<Collection of: Symbol>	the selected class'' names
	meta	<Boolean>	are the selected classes metaclasses?
	protocols	<Collection of: Symbol>	the selected protocols
	selectors 	<Collection of: Symbol>	the selected method names'!


!NavigatorState methodsFor: 'initialize-release'!

initialize
	categories := classNames := protocols := selectors := #().
	meta := false! !

!NavigatorState methodsFor: 'accessing'!

categories
	^categories!

categories: symbolCollection
	categories := symbolCollection!

category
	^self categories detect: [:each | true]
		ifNone: [nil]!

category: aCategory 
	^categories := aCategory isNil ifTrue: [#()] ifFalse: [Array with: aCategory]!

className
	^self classNames detect: [:each | true]
		ifNone: [nil]!

className: aName 
	classNames := aName isNil ifTrue: [#()] ifFalse: [Array with: aName]!

classNames
	^classNames!

classNames: aCollection 
	classNames := aCollection!

isMeta: aBoolean
	meta := aBoolean!

methods
	| class methods |
	class := self selectedClass.
	class isNil ifTrue: [^#()].
	methods := OrderedCollection new: self selectors size.
	self selectors do: 
			[:each | 
			| method |
			method := class compiledMethodAt: each ifAbsent: [nil].
			method notNil ifTrue: [methods add: method]].
	^methods!

nonMetaClass
	| classes |
	classes := self nonMetaClasses.
	^classes isEmpty ifTrue: [nil] ifFalse: [classes first]!

nonMetaClasses
	| classes |
	classes := OrderedCollection new: classNames size.
	classNames do: 
			[:each | 
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			class notNil ifTrue: [classes add: class]].
	^classes!

protocol
	^self protocols detect: [:each | true]
		ifNone: [nil]!

protocol: aSymbol 
	protocols := aSymbol isNil ifTrue: [#()] ifFalse: [Array with: aSymbol]!

protocols
	^protocols!

protocols: symbolCollection 
	protocols := symbolCollection!

selectedClass
	| class |
	class := self nonMetaClass.
	class isNil ifTrue: [^nil].
	^meta
		ifTrue: [class class]
		ifFalse: [class]!

selectedClass: aClass 
	aClass isNil ifTrue: 
			[meta := false.
			^classNames := nil].
	self className: ((meta := aClass isMeta)
				ifTrue: [aClass soleInstance name]
				ifFalse: [aClass name]).
	^aClass!

selectedClasses
	| classes |
	classes := self nonMetaClasses.
	^meta
		ifTrue: [classes collect: [:each | each class]]
		ifFalse: [classes]!

selectedClasses: classCollection 
	classNames := classCollection
				collect: [:each | (each isMeta ifTrue: [each soleInstance] ifFalse: [each]) name].
	classCollection isEmpty ifTrue: 
			[meta := false.
			^self].
	meta := classCollection first isMeta!

selector
	^self selectors detect: [:each | true]
		ifNone: [nil]!

selector: aSymbol 
	selectors := aSymbol isNil ifTrue: [#()] ifFalse: [Array with: aSymbol]!

selectors
	^selectors!

selectors: symbolCollection 
	selectors := symbolCollection! !

!NavigatorState methodsFor: 'testing'!

isMeta
	^meta! !

!NavigatorState methodsFor: 'printing'!

printOn: aStream 
	| class |
	class := self selectedClass.
	class notNil
		ifTrue: 
			[aStream nextPutAll: class name.
			self selector notNil
				ifTrue: 
					[aStream nextPutAll: '>>';
						nextPutAll: self selector]
				ifFalse: 
					[self protocol notNil ifTrue: 
							[aStream nextPut: $>;
								nextPutAll: self protocol]]]
		ifFalse: 
			[categories isEmpty
				ifTrue: [aStream nextPutAll: '(nothing selected)']
				ifFalse: [aStream nextPutAll: self category]]! !

!NavigatorState methodsFor: 'comparing'!

= anObject 
	self class == anObject class ifFalse: [^false].
	^self categories = anObject categories and: 
			[self selectedClasses = anObject selectedClasses and: 
					[self protocols = anObject protocols
						and: [self selectors = anObject selectors]]]!

hash
	^self category hash bitXor: (self selectedClass hash
				bitXor: (self protocol hash bitXor: self selector hash))! !

NavigatorState class
	instanceVariableNames: ''!



!NavigatorState class methodsFor: 'instance creation'!

new
	^super new initialize! !

BrowserDialog subclass: #ClassSelectionDialog
	instanceVariableNames: 'environmentEditor '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

ClassSelectionDialog comment:
'ClassSelectionDialog is a dialog interface for selecting classes to perform some action on (e.g., rewrite tool, browsing, etc.).

Instance Variables:
	environmentEditor	<EnvironmentEditor>	the part that is actually selecting the classes'!


!ClassSelectionDialog methodsFor: 'accessing'!

environmentEditor
	environmentEditor isNil
		ifTrue: 
			[environmentEditor := EnvironmentEditor new.
			environmentEditor environment: ClassEnvironment new].
	^environmentEditor!

selectedEnvironment
	^self environmentEditor selectedEnvironment! !

!ClassSelectionDialog methodsFor: 'interface opening'!

openInterface
	^self openInterface: (self selectedEnvironment isSelector
				ifTrue: [#selectorWindowSpec]
				ifFalse: [#windowSpec])! !

ClassSelectionDialog class
	instanceVariableNames: ''!



!ClassSelectionDialog class methodsFor: 'interface specs'!

selectorWindowSpec
	"UIPainter new openOnClass: self andSelector: #selectorWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Method Selection' 
			#min: #(#Point 40 20 ) 
			#bounds: #(#Rectangle 232 631 668 953 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -40 1 ) 
					#name: #environmentEditor 
					#flags: 0 
					#majorKey: #EnvironmentEditor 
					#minorKey: #windowSpec 
					#clientKey: #environmentEditor ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -5 1 0.5 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -5 1 0.5 1 ) 
					#name: #accept 
					#model: #accept 
					#label: 'OK' 
					#defaultable: true ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Class Selection' 
			#bounds: #(#Rectangle 286 176 722 413 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SubCanvasSpec 
					#layout: #(#LayoutFrame 0 0 0 0 0 1 -40 1 ) 
					#name: #environmentEditor 
					#flags: 0 
					#majorKey: #EnvironmentEditor 
					#minorKey: #classWindowSpec 
					#clientKey: #environmentEditor ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.666666 -5 1 0.5 1 ) 
					#name: #cancel 
					#model: #cancel 
					#label: 'Cancel' 
					#defaultable: true ) 
				#(#ActionButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.333333 -5 1 0.5 1 ) 
					#name: #accept 
					#model: #accept 
					#label: 'OK' 
					#defaultable: true ) ) ) )! !

!ClassSelectionDialog class methodsFor: 'instance creation'!

onEnvironment: anEnvironment 
	| dialog |
	dialog := self new.
	dialog environmentEditor environment: anEnvironment copy.
	^dialog! !

Object subclass: #BrowserEnvironment
	instanceVariableNames: 'label searchStrings '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

BrowserEnvironment comment:
'BrowserEnvironment represents the classes/methods that are to be browsed. Not only is this class the superclass of all environments, it also represents browsing everything.

Instance Variables:
	label	<String>	a description of what we''re looking at
	searchStrings	<Collection of: String>	strings to look for whenever we select a method'!


!BrowserEnvironment methodsFor: 'initialize-release'!

initialize!

label: aString
	label := aString! !

!BrowserEnvironment methodsFor: 'accessing'!

addSearchString: aString 
	searchStrings isNil ifTrue: 
			[searchStrings := SortedCollection sortBlock: 
							[:a :b | 
							(a indexOf: $: ifAbsent: [a size]) > (b indexOf: $: ifAbsent: [b size])]].
	searchStrings add: aString!

categories
	^Smalltalk organization categories select: [:each | self includesCategory: each]!

classNamesFor: aCategoryName
	^(Smalltalk organization listAtCategoryNamed: aCategoryName)
		select:
			[:each |
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			class notNil and: [(self includesClass: class)
					or: [self includesClass: class class]]]!

numberClasses
	^self classNames size!

numberSelectors
	| total |
	total := 0.
	self 
		classesDo: [:each | self selectorsForClass: each do: [:sel | total := total + 1]].
	^total!

protocolsFor: aClass
	^aClass organization categories select: [:each | self includesProtocol: each in: aClass]!

searchStrings
	^searchStrings isNil
		ifTrue: [#()]
		ifFalse: [searchStrings]!

searchStrings: aCollection 
	searchStrings := aCollection!

selectorsFor: aProtocol in: aClass
	^(aClass organization listAtCategoryNamed: aProtocol)
		select: [:each | self includesSelector: each in: aClass]!

selectorsForClass: aClass 
	| selectors |
	selectors := Set new: 50.
	self selectorsForClass: aClass do: [:each | selectors add: each].
	^selectors!

selectorsForClass: aClass do: aBlock 
	aClass selectorsAndMethodsDo: 
			[:each :meth | 
			(self includesSelector: each in: aClass) ifTrue: [aBlock value: each]]!

whichCategoryIncludes: aClassName
	^Smalltalk organization categoryOfElement: aClassName!

whichProtocolIncludes: aSelector in: aClass
	^aClass organization categoryOfElement: aSelector! !

!BrowserEnvironment methodsFor: 'accessing-classes'!

associationAt: aKey
	| association class |
	association := Smalltalk associationAt: aKey ifAbsent: [nil].
	class := association value isBehavior
				ifTrue: [association value]
				ifFalse: [association value class].
	^((self includesClass: class) or: [self includesClass: class class])
		ifTrue: [association]
		ifFalse: [nil]!

at: aKey
	^self at: aKey ifAbsent: [Smalltalk keyNotFoundError: aKey]!

at: aKey ifAbsent: aBlock
	| assoc |
	assoc := self associationAt: aKey.
	^assoc isNil
		ifTrue: [aBlock value]
		ifFalse: [assoc value]!

classesDo: aBlock 
	self 
		allClassesDo: [:each | (self includesClass: each) ifTrue: [aBlock value: each]]!

classNames
	| names |
	names := OrderedCollection new.
	Smalltalk keysAndValuesDo: [:key :value | (value isBehavior and: [(self includesClass: value)
				or: [self includesClass: value class]])
			ifTrue: [names add: key]].
	^names!

keys
	| keys |
	keys := Set new.
	Smalltalk
		keysAndValuesDo:
			[:key :value |
			| class |
			class := value isBehavior
						ifTrue: [value]
						ifFalse: [value class].
			(self includesClass: class)
				ifTrue: [keys add: key]].
	^keys! !

!BrowserEnvironment methodsFor: 'testing'!

definesClass: aClass
	^true!

includesCategory: aCategory
	^true!

includesClass: aClass
	^true!

includesProtocol: aProtocol in: aClass
	^true!

includesSelector: aSelector in: aClass
	^true!

isEmpty
	^false!

isSelector
	^false!

isSystem
	^true! !

!BrowserEnvironment methodsFor: 'environments'!

& anEnvironment 
	"If we or anEnvironment includes everything, then just include the other environment (optimization)"

	self isSystem ifTrue: [^anEnvironment].
	anEnvironment isSystem ifTrue: [^self].
	^AndEnvironment onEnvironment: self and: anEnvironment!

forCategories: categoryList 
	^CategoryEnvironment onEnvironment: self categories: categoryList!

forClass: aClass protocols: protocolCollection 
	^ProtocolEnvironment onEnvironment: self
		class: aClass
		protocols: protocolCollection!

forClass: aClass selectors: selectorCollection 
	^(RestrictedEnvironment onMethods: selectorCollection
		forClass: aClass
		in: self) label: aClass name , '>>'
					, (selectorCollection detect: [:each | true] ifNone: ['']);
		yourself!

forClasses: classCollection 
	| classes |
	classes := OrderedCollection new: classCollection size * 2.
	classCollection do: 
			[:each | 
			classes add: each;
				add: each class].
	^ClassEnvironment onEnvironment: self classes: classes!

implementorsMatching: aString 
	^RestrictedEnvironment implementorsMatching: aString in: self!

implementorsOf: aSelector
	^RestrictedEnvironment implementorsOf: aSelector in: self!

instVarReadersTo: instVarName in: aClass 
	| environment |
	environment := RestrictedEnvironment new.
	environment label: 'Readers of ''' , instVarName , ''' in ' , aClass name.
	aClass withAllSuperclasses reverse , aClass allSubclasses do: [:class | (self includesClass: class)
			ifTrue: [(class whichSelectorsRead: instVarName)
					do: [:each | (self includesSelector: each in: class)
							ifTrue: [environment addClass: class selector: each]]]].
	environment searchStrings: (Array with: instVarName).
	^environment!

instVarRefsTo: instVarName in: aClass 
	| environment |
	environment := RestrictedEnvironment new.
	environment label: 'References to ''' , instVarName , ''' in ' , aClass name.
	aClass withAllSuperclasses reverse , aClass allSubclasses do: [:class | (self includesClass: class)
			ifTrue: [(class whichSelectorsAccess: instVarName)
					do: [:each | (self includesSelector: each in: class)
							ifTrue: [environment addClass: class selector: each]]]].
	environment searchStrings: (Array with: instVarName).
	^environment!

instVarWritersTo: instVarName in: aClass 
	| environment |
	environment := RestrictedEnvironment new.
	environment label: 'Writers of ''' , instVarName , ''' in ' , aClass name.
	aClass withAllSuperclasses reverse , aClass allSubclasses do: [:class | (self includesClass: class)
			ifTrue: [(class whichSelectorsWrite: instVarName)
					do: [:each | (self includesSelector: each in: class)
							ifTrue: [environment addClass: class selector: each]]]].
	environment searchStrings: (Array with: instVarName).
	^environment!

matches: aString 
	^RestrictedEnvironment matches: aString in: self!

not
	^NotEnvironment onEnvironment: self!

referencesTo: aLiteral
	^RestrictedEnvironment referencesTo: aLiteral in: self!

referencesTo: aLiteral in: aClass
	^RestrictedEnvironment
		referencesTo: aLiteral
		inClass: aClass
		in: self!

selectMethods: aBlock 
	| env |
	env := RestrictedEnvironment onEnvironment: self.
	self classesDo: 
			[:each | 
			self selectorsForClass: each
				do: 
					[:sel | 
					(aBlock value: (each compiledMethodAt: sel)) 
						ifTrue: [env addClass: each selector: sel]]].
	^env!

| anEnvironment 
	"If we or anEnvironment includes everything, then return it instead of creating 
	an or that will include everything."

	self isSystem ifTrue: [^self].
	anEnvironment isSystem ifTrue: [^anEnvironment].
	^(self not & anEnvironment not) not! !

!BrowserEnvironment methodsFor: 'category'!

writeCategory: aCategory on: aStream
	^Smalltalk organization printOutCategory: aCategory on: aStream! !

!BrowserEnvironment methodsFor: 'file-out'!

fileOutCategory: aCategory on: aStream
	^Smalltalk organization fileOutCategorySource: aCategory on: aStream! !

!BrowserEnvironment methodsFor: 'printing'!

printOn: aStream
	aStream nextPutAll: self label!

storeOn: aStream 
	aStream
		nextPutAll: self class name;
		nextPutAll: ' new'! !

!BrowserEnvironment methodsFor: 'private'!

allClassesDo: aBlock 
	Smalltalk allBehaviorsDo: aBlock!

defaultLabel
	^'Smalltalk'!

label
	^label isNil
		ifTrue: [self defaultLabel]
		ifFalse: [label]! !

!BrowserEnvironment methodsFor: 'copying'!

copyEmpty
	^self class new! !

BrowserEnvironment class
	instanceVariableNames: ''!



!BrowserEnvironment class methodsFor: 'instance creation'!

new
	^super new initialize! !


!Behavior methodsFor: 'RefactoringBrowser'!

whichSelectorsWrite: instVarName 
	"Answer a set of selectors whose methods write the argument, instVarName, 
	as a named instance variable."

	| instVarIndex |
	instVarIndex := self allInstVarNames indexOf: instVarName ifAbsent: [^Set new].
	^methodDict keys select: [:sel | (methodDict at: sel)
			writesField: instVarIndex]! !

BrowserEnvironment subclass: #LimitedEnvironment
	instanceVariableNames: 'environment '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

LimitedEnvironment comment:
'LimitedEnvironment is a wrapper for BrowserEnvironments that limits what is shown. While it does not have any #subclassResponsibility methods, it is an abstract class since it doesn''t provide any useful behavior by itself

Instance Variables:
	environment	<BrowserEnvironment>	the environment we''re wrapping'!


!LimitedEnvironment methodsFor: 'initialize-release'!

onEnvironment: anEnvironment
	environment := anEnvironment! !

!LimitedEnvironment methodsFor: 'testing'!

includesCategory: aCategory
	^environment includesCategory: aCategory!

includesClass: aClass
	^environment includesClass: aClass!

includesProtocol: aProtocol in: aClass
	^(self includesClass: aClass)
		and: [environment includesProtocol: aProtocol in: aClass]!

includesSelector: aSelector in: aClass
	^(self includesClass: aClass)
		and: [environment includesSelector: aSelector in: aClass]!

isEmpty
	^self numberSelectors = 0!

isSystem
	^false! !

!LimitedEnvironment methodsFor: 'private'!

environment
	^environment! !

!LimitedEnvironment methodsFor: 'printing'!

storeOn: aStream 
	aStream
		nextPutAll: '(';
		nextPutAll: self class name;
		nextPutAll: ' onEnvironment: '.
	environment storeOn: aStream.
	aStream nextPut: $)! !

LimitedEnvironment class
	instanceVariableNames: ''!



!LimitedEnvironment class methodsFor: 'instance creation'!

new
	^self onEnvironment: BrowserEnvironment new!

onEnvironment: anEnvironment
	^(self basicNew) initialize; onEnvironment: anEnvironment; yourself! !

LimitedEnvironment subclass: #ClassEnvironment
	instanceVariableNames: 'classes metaClasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

ClassEnvironment comment:
'ClassEnvironment represents a collection of classes to be browsed.

Instance Variables:
	classes	<Collection of: Symbol>	the class names (not metaclasses)
	metaClasses	<Collection of: Symbol>	the class names for the metaclasses that are selected'!


!ClassEnvironment methodsFor: 'initialize-release'!

classes: aCollection 
	aCollection do: [:each | self addClass: each]!

initialize
	super initialize.
	classes := Set new.
	metaClasses := Set new! !

!ClassEnvironment methodsFor: 'testing'!

includesCategory: aCategory
	^(super includesCategory: aCategory)
		and: [(environment classNamesFor: aCategory)
				inject: false into: [:bool :each | bool
					or:
						[| class |
						class := Smalltalk at: each ifAbsent: [nil].
						class notNil and: [(self includesClass: class)
								or: [self includesClass: class class]]]]]!

includesClass: aClass 
	^(aClass isMeta
		ifTrue: [metaClasses includes: aClass soleInstance name]
		ifFalse: [classes includes: aClass name])
			and: [super includesClass: aClass]!

isEmpty
	^classes isEmpty & metaClasses isEmpty! !

!ClassEnvironment methodsFor: 'removing'!

removeClass: aClass 
	aClass isMeta
		ifTrue: [metaClasses remove: aClass soleInstance name ifAbsent: []]
		ifFalse: [classes remove: aClass name ifAbsent: []]! !

!ClassEnvironment methodsFor: 'adding'!

addClass: aClass 
	aClass isMeta
		ifTrue: [metaClasses add: aClass soleInstance name]
		ifFalse: [classes add: aClass name]! !

!ClassEnvironment methodsFor: 'private'!

defaultLabel
	| stream |
	stream := String new writeStream.
	classes do: 
			[:each | 
			stream nextPutAll: each;
				nextPut: $ ].
	^stream contents! !

!ClassEnvironment methodsFor: 'copying'!

postCopy
	classes := classes copy.
	metaClasses := metaClasses copy.
	^super postCopy! !

!ClassEnvironment methodsFor: 'accessing-classes'!

classesDo: aBlock 
	classes
		do: 
			[:each | 
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			(class notNil and: [environment includesClass: class])
				ifTrue: [aBlock value: class]].
	metaClasses
		do: 
			[:each | 
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			(class notNil and: [environment includesClass: class class])
				ifTrue: [aBlock value: class class]]!

classNames
	^(Set withAll: classes) addAll: metaClasses;
		yourself! !

ClassEnvironment class
	instanceVariableNames: ''!



!ClassEnvironment class methodsFor: 'instance creation'!

onEnvironment: anEnvironment classes: aCollection
	^(self onEnvironment: anEnvironment)
		classes: aCollection; yourself! !

LimitedEnvironment subclass: #AndEnvironment
	instanceVariableNames: 'andedEnvironment '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!



!AndEnvironment methodsFor: 'initialize-release'!

andedEnvironment: aBrowserEnvironment 
	andedEnvironment := aBrowserEnvironment! !

!AndEnvironment methodsFor: 'testing'!

includesCategory: aCategory 
	^(self classNamesFor: aCategory) isEmpty not!

includesClass: aClass 
	| doesntHaveSelectors |
	(environment includesClass: aClass) ifFalse: [^false].
	(andedEnvironment includesClass: aClass) ifFalse: [^false].
	doesntHaveSelectors := true.
	environment selectorsForClass: aClass
		do: 
			[:each | 
			doesntHaveSelectors := false.
			(andedEnvironment includesSelector: each in: aClass) ifTrue: [^true]].
	^doesntHaveSelectors!

includesProtocol: aProtocol in: aClass 
	^(self selectorsFor: aProtocol in: aClass) isEmpty not!

includesSelector: aSelector in: aClass 
	^(environment includesSelector: aSelector in: aClass) 
		and: [andedEnvironment includesSelector: aSelector in: aClass]! !

!AndEnvironment methodsFor: 'accessing'!

numberSelectors
	| total |
	total := 0.
	environment 
		classesDo: [:each | self selectorsForClass: each do: [:sel | total := total + 1]].
	^total! !

!AndEnvironment methodsFor: 'private'!

andedEnvironment
	^andedEnvironment! !

!AndEnvironment methodsFor: 'printing'!

storeOn: aStream 
	environment storeOn: aStream.
	aStream nextPutAll: ' & '.
	andedEnvironment storeOn: aStream! !

AndEnvironment class
	instanceVariableNames: ''!



!AndEnvironment class methodsFor: 'instance creation'!

onEnvironment: anEnvironment and: anotherEnvironment 
	^(self onEnvironment: anEnvironment)
		andedEnvironment: anotherEnvironment;
		yourself! !

LimitedEnvironment subclass: #NotEnvironment
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!



!NotEnvironment methodsFor: 'testing'!

includesCategory: aCategory 
	^(self classNamesFor: aCategory) isEmpty not!

includesClass: aClass 
	(environment includesClass: aClass) ifFalse: [^true].
	aClass selectorsAndMethodsDo: 
			[:each :meth | 
			(environment includesSelector: each in: aClass) ifFalse: [^true]].
	^false!

includesProtocol: aProtocol in: aClass 
	^(self selectorsFor: aProtocol in: aClass) isEmpty not!

includesSelector: aSelector in: aClass
	^(environment includesSelector: aSelector in: aClass) not! !

NotEnvironment class
	instanceVariableNames: ''!


LimitedEnvironment subclass: #CategoryEnvironment
	instanceVariableNames: 'categories '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

CategoryEnvironment comment:
'CategoryEnvironment represents browsing some selected categories. All methods/classes not in the categories are not shown in the browser..

Instance Variables:
	categories	<Collection of: Symbol>	the category names to browse'!


!CategoryEnvironment methodsFor: 'initialize-release'!

categories: aCollection
	categories := aCollection!

initialize
	super initialize.
	categories := Set new! !

!CategoryEnvironment methodsFor: 'accessing-classes'!

classNames
	^self categories inject: OrderedCollection new into: [:col :each | col addAll: (self classNamesFor: each); yourself]! !

!CategoryEnvironment methodsFor: 'testing'!

includesCategory: aCategory
	^(categories includes: aCategory)
		and: [super includesCategory: aCategory]!

includesClass: aClass 
	^(super includesClass: aClass)
		and: 
			[| nonMetaClass |
			nonMetaClass := aClass isMeta
						ifTrue: [aClass soleInstance]
						ifFalse: [aClass].
			self categories contains: [:each | (environment classNamesFor: each)
					includes: nonMetaClass name]]!

isEmpty
	^categories isEmpty! !

!CategoryEnvironment methodsFor: 'private'!

defaultLabel
	| stream |
	stream := String new writeStream.
	categories do: [:each | stream nextPutAll: each; nextPut: $ ].
	^stream contents! !

!CategoryEnvironment methodsFor: 'copying'!

postCopy
	categories := categories copy.
	^super postCopy! !

CategoryEnvironment class
	instanceVariableNames: ''!



!CategoryEnvironment class methodsFor: 'instance creation'!

onEnvironment: anEnvironment categories: aCollection
	^(self onEnvironment: anEnvironment)
		categories: aCollection; yourself! !

LimitedEnvironment subclass: #ProtocolEnvironment
	instanceVariableNames: 'class protocols '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

ProtocolEnvironment comment:
'ProtocolEnvironment represents a collection of protocols in a class to be browsed.

Instance Variables:
	class	<Behavior>	the class that contains the protocols
	protocols	<Collection of: Symbol>	the protocols to be browsed'!


!ProtocolEnvironment methodsFor: 'initialize-release'!

class: aClass protocols: aCollection
	class := aClass.
	protocols := aCollection! !

!ProtocolEnvironment methodsFor: 'testing'!

includesCategory: aCategory
	^(super includesCategory: aCategory)
		and: [(environment classNamesFor: aCategory)
				inject: false into: [:bool :each | bool
					or:
						[| aClass |
						aClass := Smalltalk at: each ifAbsent: [nil].
						aClass == class or: [aClass class == class]]]]!

includesClass: aClass
	^aClass == class and: [super includesClass: aClass]!

includesProtocol: aProtocol in: aClass
	^aClass == class and: [(super includesProtocol: aProtocol in: aClass)
			and: [protocols includes: aProtocol]]!

isEmpty
	^protocols isEmpty! !

!ProtocolEnvironment methodsFor: 'private'!

defaultLabel
	| stream |
	stream := String new writeStream.
	stream nextPutAll: class name;
		nextPut: $>.
	protocols do: 
			[:each | 
			stream nextPutAll: each;
				nextPut: $ ].
	^stream contents! !

!ProtocolEnvironment methodsFor: 'copying'!

postCopy
	protocols := protocols copy.
	^super postCopy! !

ProtocolEnvironment class
	instanceVariableNames: ''!



!ProtocolEnvironment class methodsFor: 'instance creation'!

onEnvironment: anEnvironment class: aClass protocols: aCollection
	^(self onEnvironment: anEnvironment)
		class: aClass protocols: aCollection; yourself! !

LimitedEnvironment subclass: #RestrictedEnvironment
	instanceVariableNames: 'classSelectors metaClassSelectors '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

RestrictedEnvironment comment:
'RestrictedEnvironment represents a collection of methods to be browsed.

Instance Variables:
	classDict	<Dictionary key: Behavior value: Symbol>	the methods to browse for each class'!


!RestrictedEnvironment methodsFor: 'initialize-release'!

classes: classArray metaClasses: metaArray 
	"Used to recreate an environment from its storeString"

	classSelectors := Dictionary new.
	metaClassSelectors := Dictionary new.
	classArray 
		do: [:each | classSelectors at: each first put: each last asSet].
	metaArray 
		do: [:each | metaClassSelectors at: each first put: each last asSet]!

initialize
	super initialize.
	classSelectors := IdentityDictionary new.
	metaClassSelectors := IdentityDictionary new!

on: aDict 
	aDict keysAndValuesDo: 
			[:class :selectors | 
			class isMeta 
				ifTrue: [metaClassSelectors at: class soleInstance name put: selectors]
				ifFalse: [classSelectors at: class name put: selectors]]! !

!RestrictedEnvironment methodsFor: 'accessing'!

numberSelectors
	"This doesn't compute the correct result when a method that is included in our method list is not in the
	environment we are wrapping. It is implemented this way for efficiency."

	^(classSelectors inject: 0 into: [:sum :each | sum + each size]) 
		+ (metaClassSelectors inject: 0 into: [:sum :each | sum + each size])! !

!RestrictedEnvironment methodsFor: 'testing'!

includesCategory: aCategory 
	^(super includesCategory: aCategory) and: 
			[(self classNamesFor: aCategory) contains: 
					[:className | 
					(classSelectors includesKey: className) 
						or: [metaClassSelectors includesKey: className]]]!

includesClass: aClass 
	^(aClass isMeta 
		ifTrue: [metaClassSelectors at: aClass soleInstance name ifAbsent: [#()]]
		ifFalse: [classSelectors at: aClass name ifAbsent: [#()]]) isEmpty 
		not and: [super includesClass: aClass]!

includesProtocol: aProtocol in: aClass 
	^(super includesProtocol: aProtocol in: aClass)
		and: [(environment selectorsFor: aProtocol in: aClass)
				contains: [:aSelector | self privateIncludesSelector: aSelector inClass: aClass]]!

includesSelector: aSelector in: aClass 
	^(environment includesSelector: aSelector in: aClass)
		and: [self privateIncludesSelector: aSelector inClass: aClass]!

isEmpty
	^classSelectors isEmpty and: [metaClassSelectors isEmpty]!

isSelector
	^true! !

!RestrictedEnvironment methodsFor: 'adding'!

addClass: aClass 
	aClass isMeta 
		ifTrue: 
			[metaClassSelectors at: aClass soleInstance name put: aClass selectors]
		ifFalse: [classSelectors at: aClass name put: aClass selectors]!

addClass: aClass selector: aSymbol 
	(aClass isMeta 
		ifTrue: 
			[metaClassSelectors at: aClass soleInstance name ifAbsentPut: [Set new]]
		ifFalse: [classSelectors at: aClass name ifAbsentPut: [Set new]]) add: aSymbol! !

!RestrictedEnvironment methodsFor: 'removing'!

removeClass: aClass 
	aClass isMeta 
		ifTrue: [metaClassSelectors removeKey: aClass soleInstance name ifAbsent: []]
		ifFalse: [classSelectors removeKey: aClass name ifAbsent: []]!

removeClass: aClass selector: aSelector 
	(aClass isMeta 
		ifTrue: [metaClassSelectors at: aClass soleInstance name ifAbsent: [^self]]
		ifFalse: [classSelectors at: aClass name ifAbsent: [^self]]) 
			remove: aSelector
			ifAbsent: []! !

!RestrictedEnvironment methodsFor: 'private'!

defaultLabel
	^'some methods'!

privateIncludesSelector: aSelector inClass: aClass 
	^(aClass isMeta 
		ifTrue: [metaClassSelectors at: aClass soleInstance name ifAbsent: [#()]]
		ifFalse: [classSelectors at: aClass name ifAbsent: [#()]]) 
			includes: aSelector! !

!RestrictedEnvironment methodsFor: 'copying'!

postCopy
	| newDict |
	newDict := classSelectors copy.
	newDict keysAndValuesDo: [:key :value | newDict at: key put: value copy].
	classSelectors := newDict.
	newDict := metaClassSelectors copy.
	newDict keysAndValuesDo: [:key :value | newDict at: key put: value copy].
	metaClassSelectors := newDict.
	^super postCopy! !

!RestrictedEnvironment methodsFor: 'accessing-classes'!

classesDo: aBlock 
	classSelectors keysDo: 
			[:each | 
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			(self includesClass: class) ifTrue: [aBlock value: class]].
	metaClassSelectors keysDo: 
			[:each | 
			| class |
			class := Smalltalk at: each ifAbsent: [nil].
			(self includesClass: class class) ifTrue: [aBlock value: class class]]!

classNames
	| names |
	names := Set new: classSelectors size + metaClassSelectors size.
	names
		addAll: classSelectors keys;
		addAll: metaClassSelectors keys.
	^names asOrderedCollection! !

!RestrictedEnvironment methodsFor: 'printing'!

storeOn: aStream 
	| classBlock |
	aStream
		nextPutAll: '((';
		nextPutAll: self class name;
		nextPutAll: ' onEnvironment: '.
	environment storeOn: aStream.
	aStream
		nextPut: $);
		nextPutAll: ' classes: #('.
	classBlock := 
			[:key :value | 
			aStream
				nextPutAll: '#(';
				nextPutAll: key;
				nextPutAll: ' #('.
			value do: 
					[:each | 
					aStream
						nextPutAll: each;
						nextPut: $ ].
			aStream
				nextPutAll: '))';
				cr].
	classSelectors keysAndValuesDo: classBlock.
	aStream nextPutAll: ') metaClasses: #('.
	metaClassSelectors keysAndValuesDo: classBlock.
	aStream nextPutAll: '))'! !

RestrictedEnvironment class
	instanceVariableNames: ''!



!RestrictedEnvironment class methodsFor: 'instance creation'!

implementorsMatching: aString in: anEnvironment 
	| classDict |
	classDict := Dictionary new.
	anEnvironment classesDo: 
			[:class | 
			| selectors |
			selectors := (anEnvironment selectorsForClass: class)
						select: [:each | aString match: each].
			selectors isEmpty ifFalse: [classDict at: class put: selectors]].
	^(self onEnvironment: anEnvironment) on: classDict;
		label: 'Implementors of ' , aString;
		yourself!

implementorsOf: aSelector in: anEnvironment 
	| classDict |
	classDict := Dictionary new.
	anEnvironment classesDo: [:class | ((class includesSelector: aSelector)
			and: [anEnvironment includesSelector: aSelector in: class])
			ifTrue: [classDict at: class put: (Set with: aSelector)]].
	^(self onEnvironment: anEnvironment)
		on: classDict;
		label: 'Implementors of ' , aSelector; yourself!

matches: aString in: anEnvironment 
	| newEnvironment |
	newEnvironment := (self onEnvironment: anEnvironment)
				label: 'Matching: ' , aString;
				searchStrings: (Array with: aString); yourself.
	anEnvironment classesDo: [:each | (anEnvironment selectorsForClass: each)
			do: 
				[:sel | 
				| method |
				method := each compiledMethodAt: sel.
				method allLiterals do: [:lit | lit isString ifTrue: [(aString match: lit)
							ifTrue: [newEnvironment addClass: each selector: sel]]]]].
	^newEnvironment!

onMethods: selectorCollection forClass: aClass in: anEnvironment 
	| env |
	env := self onEnvironment: anEnvironment.
	selectorCollection do: [:each | env addClass: aClass selector: each].
	^env!

referencesTo: aLiteral in: anEnvironment 
	| classDict literalPrintString |
	literalPrintString := aLiteral isVariableBinding
				ifTrue: [aLiteral key asString]
				ifFalse: 
					[aLiteral isString ifTrue: [aLiteral] ifFalse: [aLiteral printString]].
	classDict := Dictionary new.
	anEnvironment classesDo: 
			[:class | 
			| selectors |
			selectors := (class whichSelectorsReferTo: aLiteral)
						select: [:aSelector | anEnvironment includesSelector: aSelector in: class].
			selectors isEmpty ifFalse: [classDict at: class put: selectors]].
	^(self onEnvironment: anEnvironment) on: classDict;
		label: 'References to: ' , literalPrintString;
		searchStrings: (Array with: literalPrintString);
		yourself!

referencesTo: aLiteral inClass: aClass in: anEnvironment 
	| classDict literalPrintString classes |
	literalPrintString := aLiteral isVariableBinding
				ifTrue: [aLiteral key asString]
				ifFalse: 
					[literalPrintString := aLiteral isString ifTrue: [aLiteral] ifFalse: [aLiteral printString]].
	classDict := Dictionary new.
	classes := aClass withAllSuperclasses asOrderedCollection.
	classes addAll: aClass allSubclasses;
		addAll: aClass class withAllSuperclasses;
		addAll: aClass class allSubclasses.
	classes do: 
			[:each | 
			| class selectors classSelectors |
			class := (anEnvironment includesClass: each) ifTrue: [each] ifFalse: [nil].
			class notNil ifTrue: 
					[classSelectors := anEnvironment selectorsForClass: class.
					selectors := (class whichSelectorsReferTo: aLiteral)
								select: [:aSelector | classSelectors includes: aSelector].
					selectors isEmpty ifFalse: [classDict at: class put: selectors].
					classSelectors := anEnvironment selectorsForClass: class class.
					selectors := (class class whichSelectorsReferTo: aLiteral)
								select: [:aSelector | classSelectors includes: aSelector].
					selectors isEmpty ifFalse: [classDict at: class class put: selectors]]].
	^(self onEnvironment: anEnvironment) on: classDict;
		label: 'References to: ' , literalPrintString;
		searchStrings: (Array with: literalPrintString);
		yourself! !

Navigator subclass: #EnvironmentEditor
	instanceVariableNames: 'selectedEnvironment environment '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Refactory-Environments'!

EnvironmentEditor comment:
'EnvironmentEditor is an interface for selecting classes to perform some action on (e.g., rewrite tool, browsing, etc.).

Instance Variables:
	environment	<BrowserEnvironment>	the environment from which selections are made
	selectedEnvironment	<LimitedEnvironment>	the environment that was selected by the user'!


!EnvironmentEditor methodsFor: 'initialize-release'!

environment: anEnvironment 
	self updateDisplayAfter: [selectedEnvironment := anEnvironment]!

initialize
	super initialize.
	environment := BrowserEnvironment new.
	selectedEnvironment := RestrictedEnvironment new.
	self categoryList selectionIndexHolder onChangeSend: #changedCategory to: self.
	self classList selectionIndexHolder onChangeSend: #changedClass to: self.
	self protocolList selectionIndexHolder onChangeSend: #changedProtocol to: self.
	self selectorList selectionIndexHolder onChangeSend: #updateSelectorMenu to: self.
	self meta onChangeSend: #changedMeta to: self! !

!EnvironmentEditor methodsFor: 'accessing'!

environment
	^environment!

menu
	^
	[| menu |
	menu := Menu new.
	(builder componentAt: #categoryList) isVisible ifTrue: 
			[menu addItem: ((MenuItem labeled: 'Ca&tegory')
						submenu: [self initializeMenu: categoryMenuHolder value])].
	(builder componentAt: #classList) isVisible ifTrue: 
			[menu addItem: ((MenuItem labeled: '&Class')
						submenu: [self initializeMenu: classMenuHolder value])].
	(builder componentAt: #protocolList) isVisible ifTrue: 
			[menu addItem: ((MenuItem labeled: '&Protocol')
						submenu: [self initializeMenu: protocolMenuHolder value])].
	(builder componentAt: #selectorList) isVisible ifTrue: 
			[menu addItem: ((MenuItem labeled: '&Selector')
						submenu: [self initializeMenu: selectorMenuHolder value])].
	menu]!

selectedEnvironment
	^selectedEnvironment! !

!EnvironmentEditor methodsFor: 'actions'!

checkAllCategories
	| categoryMatch |
	categoryMatch := Dialog request: 'Select categories matching:' initialAnswer: ''.
	categoryMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: [Cursor wait showWhile: [self categoryList list do: [:each | (categoryMatch match: each)
					ifTrue: [self checkCategory: each]]]]!

checkAllClasses
	| classMatch |
	classMatch := Dialog request: 'Select classes matching:' initialAnswer: ''.
	classMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self classList list
						do: [:each | (classMatch match: each) ifTrue: [self checkClass: each]]]]!

checkAllProtocols
	| protocolMatch |
	protocolMatch := Dialog request: 'Select protocols matching:' initialAnswer: ''.
	protocolMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self protocolList list
						do: [:each | (protocolMatch match: each) ifTrue: [self checkProtocol: each]]]]!

checkAllSelectors
	| selectorMatch |
	selectorMatch := Dialog request: 'Select selectors matching:' initialAnswer: ''.
	selectorMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self selectorList list do: 
							[:each | 
							(selectorMatch match: each)
								ifTrue: [selectedEnvironment addClass: self selectedClass selector: each]]]]!

checkCategory
	self updateDisplayAfter: [self categories do: [:each | self checkCategory: each]]!

checkChangeSet
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[ChangeSet current changedClasses do: 
							[:each | 
							each isMeta
								ifTrue: [selectedEnvironment addClass: each]
								ifFalse: 
									[selectedEnvironment addClass: each;
										addClass: each class]]]]!

checkClass
	self updateDisplayAfter: 
			[self selectedClasses do: [:each | selectedEnvironment addClass: each]]!

checkImplementors
	self updateDisplayAfter: 
			[environment classesDo: 
					[:class | 
					self selectors do: 
							[:selector | 
							(environment includesSelector: selector in: class)
								ifTrue: [selectedEnvironment addClass: class selector: selector]]]]!

checkProtocol
	self updateDisplayAfter: 
			[| class |
			class := self selectedClass.
			self protocols do: 
					[:each | 
					(environment selectorsFor: each in: class)
						do: [:sel | selectedEnvironment addClass: class selector: sel]]]!

checkSelector
	self updateDisplayAfter: 
			[| class |
			class := self selectedClass.
			self selectors
				do: [:each | selectedEnvironment addClass: class selector: each]]!

checkSenders
	self updateDisplayAfter: 
			[environment classesDo: 
					[:class | 
					self selectors do: 
							[:selector | 
							(environment selectorsForClass: class) do: 
									[:each | 
									((class compiledMethodAt: each) refersToLiteral: selector)
										ifTrue: [selectedEnvironment addClass: class selector: each]]]]]!

checkSubclasses
	self updateDisplayAfter: 
			[self selectedClasses
				do: [:each | each allSubclasses do: [:sub | selectedEnvironment addClass: sub]]]!

checkSuperclasses
	self updateDisplayAfter: 
			[self selectedClasses
				do: [:each | each allSuperclasses do: [:sup | selectedEnvironment addClass: sup]]]!

uncheckAllCategories
	| categoryMatch |
	categoryMatch := Dialog request: 'Deselect categories matching:' initialAnswer: ''.
	categoryMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: [Cursor wait showWhile: [self categoryList list do: [:each | (categoryMatch match: each)
					ifTrue: [self uncheckCategory: each]]]]!

uncheckAllClasses
	| classMatch |
	classMatch := Dialog request: 'Deselect classes matching:' initialAnswer: ''.
	classMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self classList list
						do: [:each | (classMatch match: each) ifTrue: [self uncheckClass: each]]]]!

uncheckAllProtocols
	| protocolMatch |
	protocolMatch := Dialog request: 'Deselect protocols matching:' initialAnswer: ''.
	protocolMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self protocolList list
						do: [:each | (protocolMatch match: each) ifTrue: [self uncheckProtocol: each]]]]!

uncheckAllSelectors
	| selectorMatch |
	selectorMatch := Dialog request: 'Deselect selectors matching:' initialAnswer: ''.
	selectorMatch isEmpty ifTrue: [^self].
	self updateDisplayAfter: 
			[Cursor wait showWhile: 
					[self selectorList list do: 
							[:each | 
							(selectorMatch match: each)
								ifTrue: [selectedEnvironment removeClass: self selectedClass selector: each]]]]!

uncheckCategory
	self updateDisplayAfter: [self categories do: [:each | self uncheckCategory: each]]!

uncheckClass
	self updateDisplayAfter: 
			[self selectedClasses do: [:each | selectedEnvironment removeClass: each]]!

uncheckImplementors
	self updateDisplayAfter: 
			[environment classesDo: 
					[:class | 
					self selectors do: 
							[:selector | 
							(environment includesSelector: selector in: class)
								ifTrue: [selectedEnvironment removeClass: class selector: selector]]]]!

uncheckProtocol
	self updateDisplayAfter: 
			[| class |
			class := self selectedClass.
			self protocols do: 
					[:each | 
					(environment selectorsFor: each in: class)
						do: [:sel | selectedEnvironment removeClass: class selector: sel]]]!

uncheckSelector
	self updateDisplayAfter: 
			[| class |
			class := self selectedClass.
			self selectors
				do: [:each | selectedEnvironment removeClass: class selector: each]]!

uncheckSenders
	self updateDisplayAfter: 
			[environment classesDo: 
					[:class | 
					self selectors do: 
							[:selector | 
							(environment selectorsForClass: class) do: 
									[:each | 
									((class compiledMethodAt: each) refersToLiteral: selector)
										ifTrue: [selectedEnvironment removeClass: class selector: each]]]]]!

uncheckSubclasses
	self updateDisplayAfter: 
			[self selectedClasses
				do: [:class | class allSubclasses do: [:each | selectedEnvironment removeClass: each]]]!

uncheckSuperclasses
	self updateDisplayAfter: 
			[self selectedClasses do: 
					[:class | 
					class allSuperclasses do: [:each | selectedEnvironment removeClass: each]]]! !

!EnvironmentEditor methodsFor: 'interface opening'!

postBuildCategoryList: aBuilder 
	| visualBlock |
	visualBlock := 
			[:v :i | 
			(selectedEnvironment includesCategory: (v sequence at: i))
				ifTrue: 
					[(LabelAndIcon with: (v displayStringAt: i) attributes: v textStyle)
						beCheckMark]
				ifFalse: 
					[Label with: (v displayStringAt: i)
						attributes: v textStyle
						offset: 16 @ 0]].
	((aBuilder componentAt: #categoryList) widget)
		visualBlock: (self createVisualBlockFrom: visualBlock);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: visualBlock)!

postBuildClassList: aBuilder 
	| visualBlock |
	visualBlock := 
			[:v :i | 
			| class |
			class := selectedEnvironment at: (v sequence at: i) ifAbsent: [nil].
			(class notNil and: 
					[self meta value
						ifTrue: [selectedEnvironment includesClass: class class]
						ifFalse: [selectedEnvironment includesClass: class]])
				ifTrue: 
					[(LabelAndIcon with: (v displayStringAt: i) attributes: v textStyle)
						beCheckMark]
				ifFalse: 
					[Label with: (v displayStringAt: i)
						attributes: v textStyle
						offset: 16 @ 0]].
	((aBuilder componentAt: #classList) widget)
		visualBlock: (self createVisualBlockFrom: visualBlock);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: visualBlock)!

postBuildProtocolList: aBuilder 
	| visualBlock |
	visualBlock := 
			[:v :i | 
			(selectedEnvironment includesProtocol: (v sequence at: i)
				in: self selectedClass)
					ifTrue: 
						[(LabelAndIcon with: (v displayStringAt: i) attributes: v textStyle)
							beCheckMark]
					ifFalse: 
						[Label with: (v displayStringAt: i)
							attributes: v textStyle
							offset: 16 @ 0]].
	((aBuilder componentAt: #protocolList) widget)
		visualBlock: (self createVisualBlockFrom: visualBlock);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: visualBlock)!

postBuildSelectorList: aBuilder 
	| visualBlock |
	visualBlock := 
			[:v :i | 
			(selectedEnvironment includesSelector: (v sequence at: i)
				in: self selectedClass)
					ifTrue: 
						[(LabelAndIcon with: (v displayStringAt: i) attributes: v textStyle)
							beCheckMark]
					ifFalse: 
						[Label with: (v displayStringAt: i)
							attributes: v textStyle
							offset: 16 @ 0]].
	((aBuilder componentAt: #selectorList) widget)
		visualBlock: (self createVisualBlockFrom: visualBlock);
		selectedVisualBlock: (self createSelectedVisualBlockFrom: visualBlock)!

postBuildWith: aBuilder 
	super postBuildWith: aBuilder.
	self postBuildCategoryList: aBuilder.
	self postBuildClassList: aBuilder.
	self postBuildProtocolList: aBuilder.
	self postBuildSelectorList: aBuilder.
	self categoryList list: (List withAll: environment categories)! !

!EnvironmentEditor methodsFor: 'private'!

checkCategory: aCategory 
	(environment classNamesFor: aCategory)
		do: 
			[:each | 
			| class |
			class := environment at: each ifAbsent: [nil].
			class notNil ifTrue: [selectedEnvironment addClass: class; addClass: class class]]!

checkClass: aName 
	| class |
	class := self classForName: aName.
	class isNil ifTrue: [^self].
	self isMeta ifTrue: [class := class class].
	selectedEnvironment addClass: class!

checkProtocol: aProtocol 
	| class |
	class := self selectedClass.
	(environment selectorsFor: aProtocol in: class)
		do: [:each | selectedEnvironment addClass: class selector: each]!

uncheckCategory: aCategory 
	(environment classNamesFor: aCategory)
		do: 
			[:each | 
			| class |
			class := environment at: each ifAbsent: [nil].
			class notNil ifTrue: [selectedEnvironment removeClass: class; removeClass: class class]]!

uncheckClass: aName 
	| class |
	class := self classForName: aName.
	class isNil ifTrue: [^self].
	self isMeta ifTrue: [class := class class].
	selectedEnvironment removeClass: class!

uncheckProtocol: aProtocol 
	| class |
	class := self selectedClass.
	(environment selectorsFor: aProtocol in: class)
		do: [:each | selectedEnvironment removeClass: class selector: each]!

updateDisplayAfter: aBlock 
	aBlock value.
	builder isNil ifTrue: [^self].
	#(#categoryList #classList #protocolList #selectorList)
		do: [:each | self invalidateComponent: each]! !

!EnvironmentEditor methodsFor: 'changing'!

changedMeta
	super changedMeta.
	self invalidateComponent: #classList! !

!EnvironmentEditor methodsFor: 'menus'!

updateCategoryMenu
	self category isNil
		ifTrue: [self disableMenu: categoryMenuHolder value except: #('add all...' 'remove all...' 'add from change set' 'find class...')]
		ifFalse: [self enableMenu: categoryMenuHolder value]!

updateClassMenu
	self category isNil
		ifTrue: [self disableMenu: classMenuHolder value]
		ifFalse: [self selectedClass isNil
				ifTrue: [self disableMenu: classMenuHolder value except: #('add all...' 'remove all...')]
				ifFalse: [self enableMenu: classMenuHolder value]]!

updateProtocolMenu
	self selectedClass isNil
		ifTrue: [self disableMenu: protocolMenuHolder value]
		ifFalse: [self protocol isNil
				ifTrue: [self disableMenu: protocolMenuHolder value except: #('add all...' 'remove all...' 'find method...')]
				ifFalse: [self enableMenu: protocolMenuHolder value]]!

updateSelectorMenu
	self protocol isNil
		ifTrue: [self disableMenu: selectorMenuHolder value]
		ifFalse: [self selector isNil
				ifTrue: [self disableMenu: selectorMenuHolder value except: #('add all...' 'remove all...')]
				ifFalse: [self enableMenu: selectorMenuHolder value]]! !

EnvironmentEditor class
	instanceVariableNames: ''!



!EnvironmentEditor class methodsFor: 'interface specs'!

classWindowSpec
	"UIPainter new openOnClass: self andSelector: #classWindowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Environment Editor' 
			#bounds: #(#Rectangle 267 482 905 962 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 10 0 25 0 -5 0.5 -10 1 ) 
					#name: #categoryList 
					#model: #categoryList 
					#menu: #categoryMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0.5 25 0 -10 1 -35 1 ) 
					#name: #classList 
					#model: #classList 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 10 0 25 0.5 -5 0.5 -10 1 ) 
					#name: #protocolList 
					#flags: 29 
					#model: #protocolList 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0.5 25 0.5 -10 1 -10 1 ) 
					#name: #selectorList 
					#flags: 29 
					#model: #selectorList 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#LabelSpec 
					#layout: #(#Point 10 0 ) 
					#label: 'Category:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0.5 0 0 ) 
					#label: 'Class:' ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 5 0.5 -10 1 0 1 ) 
					#model: #meta 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.75 -10 1 0 1 ) 
					#model: #meta 
					#label: 'class' 
					#select: true ) ) ) )!

windowSpec
	"UIPainter new openOnClass: self andSelector: #windowSpec"

	<resource: #canvas>
	^#(#FullSpec 
		#window: 
		#(#WindowSpec 
			#label: 'Environment Editor' 
			#bounds: #(#Rectangle 156 214 794 694 ) ) 
		#component: 
		#(#SpecCollection 
			#collection: #(
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 10 0 25 0 -5 0.5 -5 0.5 ) 
					#name: #categoryList 
					#model: #categoryList 
					#menu: #categoryMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0.5 25 0 -10 1 -30 0.5 ) 
					#name: #classList 
					#model: #classList 
					#menu: #classMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 10 0 25 0.5 -5 0.5 -10 1 ) 
					#name: #protocolList 
					#model: #protocolList 
					#menu: #protocolMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#SequenceViewSpec 
					#layout: #(#LayoutFrame 5 0.5 25 0.5 -10 1 -10 1 ) 
					#name: #selectorList 
					#model: #selectorList 
					#menu: #selectorMenu 
					#multipleSelections: true 
					#useModifierKeys: true 
					#selectionType: #highlight ) 
				#(#LabelSpec 
					#layout: #(#Point 10 0 ) 
					#label: 'Category:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0.5 0 0 ) 
					#label: 'Class:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 10 0 0 0.5 ) 
					#label: 'Protocol:' ) 
				#(#LabelSpec 
					#layout: #(#LayoutOrigin 5 0.5 0 0.5 ) 
					#label: 'Selector:' ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 5 0.5 -5 0.5 0 1 ) 
					#model: #meta 
					#label: 'instance' 
					#select: false ) 
				#(#RadioButtonSpec 
					#layout: #(#AlignmentOrigin 0 0.75 -5 0.5 0 1 ) 
					#model: #meta 
					#label: 'class' 
					#select: true ) 
				#(#ActionButtonSpec 
					#layout: #(#LayoutFrame -30 1 -25 0.5 -10 1 -5 0.5 ) 
					#name: #clearToClass 
					#model: #clearToClass 
					#label: '^' ) ) ) )! !

!EnvironmentEditor class methodsFor: 'resources'!

categoryMenu
	"MenuEditor new openOnClass: self andSelector: #categoryMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'add' 
				#nameKey: #checkCategory 
				#value: #checkCategory ) 
			#(#MenuItem 
				#rawLabel: 'remove' 
				#nameKey: #uncheckCategory 
				#value: #uncheckCategory ) 
			#(#MenuItem 
				#rawLabel: 'add all...' 
				#nameKey: #checkAllCategories 
				#value: #checkAllCategories ) 
			#(#MenuItem 
				#rawLabel: 'remove all...' 
				#nameKey: #uncheckAllCategories 
				#value: #uncheckAllCategories ) 
			#(#MenuItem 
				#rawLabel: 'add from change set' 
				#value: #checkChangeSet ) 
			#(#MenuItem 
				#rawLabel: 'find class...' 
				#nameKey: #findClass 
				#value: #findClass ) ) #(2 2 1 1 ) nil ) decodeAsLiteralArray!

classMenu
	"MenuEditor new openOnClass: self andSelector: #classMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'add' 
				#nameKey: #checkClass 
				#value: #checkClass ) 
			#(#MenuItem 
				#rawLabel: 'remove' 
				#nameKey: #uncheckClass 
				#value: #uncheckClass ) 
			#(#MenuItem 
				#rawLabel: 'add all...' 
				#nameKey: #checkAllClasses 
				#value: #checkAllClasses ) 
			#(#MenuItem 
				#rawLabel: 'remove all...' 
				#nameKey: #uncheckAllClasses 
				#value: #uncheckAllClasses ) 
			#(#MenuItem 
				#rawLabel: 'add superclasses' 
				#nameKey: #checkSuperclasses 
				#value: #checkSuperclasses ) 
			#(#MenuItem 
				#rawLabel: 'remove superclasses' 
				#nameKey: #uncheckSuperclasses 
				#value: #uncheckSuperclasses ) 
			#(#MenuItem 
				#rawLabel: 'add subclasses' 
				#nameKey: #checkSubclasses 
				#value: #checkSubclasses ) 
			#(#MenuItem 
				#rawLabel: 'remove subclasses' 
				#nameKey: #uncheckSubclasses 
				#value: #uncheckSubclasses ) ) #(2 2 2 2 ) nil ) decodeAsLiteralArray!

protocolMenu
	"MenuEditor new openOnClass: self andSelector: #protocolMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'add' 
				#nameKey: #checkProtocol 
				#value: #checkProtocol ) 
			#(#MenuItem 
				#rawLabel: 'remove' 
				#nameKey: #uncheckProtocol 
				#value: #uncheckProtocol ) 
			#(#MenuItem 
				#rawLabel: 'add all...' 
				#nameKey: #checkAllProtocols 
				#value: #checkAllProtocols ) 
			#(#MenuItem 
				#rawLabel: 'remove all...' 
				#nameKey: #uncheckAllProtocols 
				#value: #uncheckAllProtocols ) 
			#(#MenuItem 
				#rawLabel: 'find method...' 
				#nameKey: #findMethod 
				#value: #findMethodAndSelectAlphabetic ) ) #(2 2 1 ) nil ) decodeAsLiteralArray!

selectorMenu
	"MenuEditor new openOnClass: self andSelector: #selectorMenu"

	<resource: #menu>
	^#(#Menu #(
			#(#MenuItem 
				#rawLabel: 'add' 
				#nameKey: #checkSelector 
				#value: #checkSelector ) 
			#(#MenuItem 
				#rawLabel: 'remove' 
				#nameKey: #uncheckSelector 
				#value: #uncheckSelector ) 
			#(#MenuItem 
				#rawLabel: 'add all...' 
				#nameKey: #checkAllSelectors 
				#value: #checkAllSelectors ) 
			#(#MenuItem 
				#rawLabel: 'remove all...' 
				#nameKey: #uncheckAllSelectors 
				#value: #uncheckAllSelectors ) 
			#(#MenuItem 
				#rawLabel: 'add all implementors' 
				#nameKey: #checkImplementors 
				#value: #checkImplementors ) 
			#(#MenuItem 
				#rawLabel: 'remove all implementors' 
				#nameKey: #uncheckImplementors 
				#value: #uncheckImplementors ) 
			#(#MenuItem 
				#rawLabel: 'add senders' 
				#nameKey: #checkSenders 
				#value: #checkSenders ) 
			#(#MenuItem 
				#rawLabel: 'remove senders' 
				#nameKey: #uncheckSenders 
				#value: #uncheckSenders ) ) #(2 2 2 2 ) nil ) decodeAsLiteralArray! !

Navigator initialize!


