

!StandardSystemController publicMethodsFor: 'menu messages'!

inspectView

	self view model inspect! !

!StandardSystemController class publicMethodsFor: 'class initialization'!

initializeForAdditions
	"Initialize the menu."

	ScheduledBlueButtonMenu := 
		Menu 
			labels: 'relabel as...\refresh\move\resize\front\back\collapse\close\inspect' withCRs 
			lines: #(1 7 8)
			values: #( #newLabel #display #move #resize #front #back #collapse #close #inspectView).! !

!EtApplicationsChangesBrowser publicMethodsFor: 'ET-Internal'!

printChangesReportToTranscript

	| theClass classSpec appSpec selectedApp selectedClass fullClassSpec |
	self execShortOperation: [
	Transcript cr; show: 'Changes found in config map: ', self parentComponent printString.
	self applications do: [:app |
		(self applicationDictionary at: app) value associationsDo: [:clAssoc |
		theClass := clAssoc key.
	selectedApp := app.
	selectedApp isVersion
		ifTrue: [appSpec := selectedApp versionName]
		ifFalse: [appSpec := selectedApp timeStamp printString.
			selectedApp isScratch
				ifTrue: [appSpec := '<< ', selectedApp versionName, ' >>']].
	selectedClass := theClass.
	(selectedClass isVersionIn: selectedApp)
		ifTrue: [classSpec := selectedClass versionNameIn: selectedApp]
		ifFalse: [classSpec := (selectedClass timeStampIn: selectedApp) printString].
	fullClassSpec := selectedApp printString, ' ', appSpec, ' ', selectedClass name, ' ', classSpec.
	Transcript cr; tab; show: fullClassSpec.
	ParagraphEditor currentSelection: fullClassSpec.]]]! !

!EtApplicationManager publicMethodsFor: 'ET-Internal'!

copyClassSpec

"FIXME - still under development.  Need to find a an unintrusive way to add this.  If you want to add it in, just hook this in via the method hierarchicalClassesListWidget, set the menu selector to be classesMenuHook, instead of classesMenu
"
"classesMenuHook

	^(self classesMenu) addLine;
		add: #copyClassSpec
		label: 'copy full class spec'
		enable: [self isOneClassSelected]; yourself
"

	MyTools copySpecForClass: self selectedClass inApplication: self selectedApplication.! !Object subclass: #MyToolsImplementor
	instanceVariableNames: ''
	classVariableNames: 'SmalltalkFlavour '
	poolDictionaries: ''!

MyToolsImplementor comment: 'I''m the implementation part of the bridge pattern, I or my subclasses have concrete implementations specific to a particular platform.  By convention, concrete methods are prefixed with ''implement'' to denote that they are actually bridged.

Q: How come you denote methods that should be overriden with "self notImplementedYet" as opposed to "self subclassResponsibility"?
A: This provides a friendlier interface to users or porters.  Instead of throwing an unhandled exception, a (somewhat) informative dialog appears.  A friendlier interface could be done via handling the error, but since each flavour implements exception handling differently, this lowest common denominator is a better solution.
'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!MyToolsImplementor class publicMethodsFor: 'bridging'!

implementorToUse
	"FIXME - quick-n-dirty test for which implementor to use."

	ParagraphEditor classPool at: #Keyboard
		ifAbsent: 
			[SmalltalkFlavour := 'VisualWorks v3.x'.
			^Vw31_Implementor].
	"implicit else"
	SmalltalkFlavour := 'VisualWorks v2.5.2'.
	^Vw252_Implementor!

notImplemented

	Dialog warn: 'NOTE:  Not implemented for ', self smalltalkFlavourString.!

notImplementedYet

	Dialog warn: 'NOTE:  Not implemented for ', self smalltalkFlavourString, ' yet.'.!

smalltalkFlavourString

	^SmalltalkFlavour!

smalltalkTypeString

	^self smalltalkFlavourString! !

!MyToolsImplementor class publicMethodsFor: 'class initialization'!

implementAddToLauncher
	
	self notImplementedYet.!

implementInitialize

	"Stub - do nothing by default."! !

!MyToolsImplementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings

	self notImplementedYet.!

implementSetDeleteKey

	"Stub out by default, implement as needed in subclasses."!

implementSetEmacsKeyBindings

	self notImplementedYet.!

implementSetFileBrowserToShowAllFiles

	self notImplementedYet.! !

!MyToolsImplementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus

	self notImplementedYet.! !

!MyToolsImplementor class publicMethodsFor: 'forensics'!

implementMethodToAddWith: aMethod
	"Override as neccessary to return method, method definition, or whatever else is needed.  This concrete implementation is used in the text searching methods."

	^aMethod! !

MyToolsImplementor subclass: #Vw_Implementor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Vw_Implementor comment: 'I implement VW specific code
'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!Vw_Implementor class publicMethodsFor: 'class initialization'!

implementAddToLauncher
	"Snippet to add to the Tools menu for the current VisualLauncher(s)."

	| myToolsItem menuChannelIndex launcherClass launcherControllers launcherWindows menuBar menu toolsItem uiSettingsClass |
	myToolsItem := (MenuItem labeled: 'My Tools') 
		submenu: (Menu labelArray: #('MyTools help' 
									'Find complete string...' 
									'Find substring...' 
									'Find substring, background...' 
									'Add extensions to Refactoring Browser'
									'Build MyTools')
						values: ((OrderedCollection new)
								add: [MyTools helpScreen];
								add: [MyTools findString];
								add: [MyTools findSubString];
								add: [MyTools findSubStringInBackground];
								add: [MyTools extendRefactoringBrowserMenus];
								add: [MyTools build];
								asArray)).	

	"Collect the open launchers"
	launcherClass := Smalltalk at: #VisualLauncher ifAbsent: [Dialog warn: 'WARN:  Can''t find VisualLauncher class!!'].
	launcherControllers := ScheduledControllers scheduledControllers select: 
					[:aSchedualedController | aSchedualedController view class == ApplicationWindow 
						and: [aSchedualedController view model isKindOf: launcherClass]].
	launcherWindows := launcherControllers collect: [:aLauncher | aLauncher view].

	"Need to access the menuChannel indirectly here because the menuChannel accessor is not implemented in all versions of VW."
	menuChannelIndex := MenuBar instVarIndexFor: 'menuChannel'.
	menuChannelIndex = 0 ifTrue: [Dialog warn: 'WARN:  Can''t find menu channel index'].

	launcherWindows do: 
			[:aLauncherWindow | 
			menuBar := aLauncherWindow menuBar.
			menu := (menuBar instVarAt: menuChannelIndex) value.
			toolsItem := menu menuItemLabeled: 'Tools' ifNone: [Dialog warn: 'WARN:  Can''t find Tools menu item'].
			(toolsItem submenu labels includes: 'My Tools')
				ifFalse: [toolsItem submenu addItem: myToolsItem.
						menuBar updateMenu]].

	" watch for changes to UISettings"
	uiSettingsClass := Smalltalk at: #UISettings.
	uiSettingsClass notNil 
		ifTrue: 
			[(uiSettingsClass preferenceModelFor: #hostWindowManagerSelector) 
				onChangeSend: #myAddToToolsMenu
				to: self]!

implementInitialize

	StandardSystemController initializeForAdditions.! !

!Vw_Implementor class publicMethodsFor: 'customization'!

implementSetFileBrowserToShowAllFiles

	FileBrowser defaultPattern: '*'! !

!Vw_Implementor class publicMethodsFor: 'forensics'!

implementMethodSelectorFor: method
	
	self notImplementedYet.! !

Vw_Implementor subclass: #Vw252_Implementor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Vw252_Implementor comment: 'I implement VW 2.5.2 specific code
'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!Vw252_Implementor class publicMethodsFor: 'class initialization'!

implementInitialize

	super implementInitialize.
	self
		implementSetDefaultKeyBindings;
		implementSetDeleteKey! !

!Vw252_Implementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings
	"Set some reasonable key bindings. Only takes effect on newly opened windows"

	(ParagraphEditor classPool at: #Keyboard)
		bindValue: #copyKey: to: (TextConstants at: #Ctrlx);
		bindValue: #pasteKey: to: (TextConstants at: #Ctrlv);
		bindValue: #findDialogKey: to: (TextConstants at: #Ctrlf);
		bindValue: #findKey: to: (TextConstants at: #Ctrla);
		bindValue: #acceptKey: to: (TextConstants at: #Ctrls);
		bindValue: #undoKey: to: (TextConstants at: #Ctrlz)

	"Decided not to override Ctrl-c to Micro$oft copy shortcut.  We could do this and override the interrupt key to somethink like Ctrl-q, but for the default toolkit this probably creates more confusion than good.  The trade-off here is to map Ctrlx to copy instead of cut, leaving the default Smalltalk break key in place."

	"If you want to override Ctrl-c, uncomment below text and comment out above two lines"
	"		InputState interruptKeyValue: (TextConstants at: #Ctrlq);
		bindValue: #copyKey: to: (TextConstants at: #Ctrlc);
		bindValue: #cutKey: to: (TextConstants at: #Ctrlx);
		bindValue: #pasteKey: to: (TextConstants at: #Ctrlv);
"!

implementSetDeleteKey
	"Fix that darn delete key to do what it's supposed to do"

	LookPreferences deleteForward: true!

implementSetEmacsKeyBindings
	" Only takes effect on newly opened windows"

	(ParagraphEditor classPool at: #Keyboard)
		bindValue: #pasteKey: to: (TextConstants at: #Ctrly);
		bindValue: #findDialogKey: to: (TextConstants at: #Ctrls);
		bindValue: #homeKey: to: (TextConstants at: #Ctrla);
		bindValue: #endKey: to: (TextConstants at: #Ctrle);
		bindValue: #deleteKey: to: (TextConstants at: #Ctrld);
		bindValue: #cursorRightKey: to: (TextConstants at: #Ctrlf);
		bindValue: #cursorLeftKey: to: (TextConstants at: #Ctrlb);
		bindValue: #cursorUpKey: to: (TextConstants at: #Ctrlp);
		bindValue: #cursorDownKey: to: (TextConstants at: #Ctrln)! !

!Vw252_Implementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus
	"A non-intrusive way to extend the RB menus."

	RefactoringBrowser allInstances do: 
			[:aBrowser | 
			(aBrowser navigator selectorMenu labels includes: 'send this method') 
				ifFalse: 
					[(aBrowser navigator selectorMenu)
						addSeparator;
						add: 'send this method' -> #sendSelectedMethod;
						add: 'inspect this method' -> #inspectSelectedMethod.
					(aBrowser navigator classMenu)
						addSeparator;
						add: 'copy full class spec' -> #copyFullClassSpec;
						add: 'Find substring...' -> #findSubStringOverClasses]]! !

!Vw252_Implementor class publicMethodsFor: 'forensics'!

implementGetSourceFor: method
	
	^method sourceString.!

implementMethodSelectorFor: method
	
	^method mclass printString, ' ', method selector.! !

Vw_Implementor subclass: #Vw31_Implementor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

Vw31_Implementor comment: 'I implement VW 3.0 specific code.'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!Vw31_Implementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings
	"Set some reasonable key bindings."

	UIFeelPolicy new keyboardDispatchTableWithBellsAndWhistles! !

!Vw31_Implementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus
	"A non-intrusive way to extend the RB menus."

	RefactoringBrowser allInstances do: 
			[:aBrowser | 
			(aBrowser navigator selectorMenu value labels includes: 'send this method') 
				ifFalse: 
					[aBrowser navigator selectorMenu value 
						addItemGroupLabels: #('send this method' 'inspect this method')
						values: #(#sendSelectedMethod #inspectSelectedMethod).
					aBrowser navigator classMenu value 
						addItemGroupLabels: #('copy full class spec' 'Find substring...')
						values: #(#copyFullClassSpec #findSubStringOverClasses)]]! !

!Vw31_Implementor class publicMethodsFor: 'forensics'!

implementGetSourceFor: method

	^method getSource.!

implementMethodSelectorFor: method
	
	^method definition!

implementMethodToAddWith: aMethod

	^aMethod definition! !

Object subclass: #MyToolsBase
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

MyToolsBase comment: 'MyTools v0.3 - Help information

MyTools is YAST (Yet Another Smalltalk Tool) - this is a collection of various tools and helpful snippets.  Why write yet another one?  Primarily because I haven''t seen a toolkit that is open, portable, and extendible by the community.  Secondly, my intention is that if (when? the Java juggernaut beckons) I leave the Smalltalk community, that I find a good home for MyTools so it keeps getting updated.  This toolkit is freely distributable with all source code, with two caveats:  1) It is not distributed/included for profit (if you want to do this, contact me).  2) That any modifications/improvements/updates are sent to me for inclusion in a future version.  I''ll be sure to add/withhold credit as requested.  See notes in help/documentation protocol of MyToolsBase for more information - especially before firing off questions/suggestions to me.  Enjoy.
		Environments tried in:
			* VW 2.5.2
			* VW 3.0
			* ENVY 3.01
Jason Steffler
jagwar@magma.ca

[R] - indicates it''s for the Refactoring Browser
[E] - indicates it''s for ENVY

Menu Items
	* Find complete string
		* Looks for occurances of entire string within the image. (case sensitive, relatively fast)
	* Find substring
		* Allows you to scope the search by specifying class to start in.  Will search all subclasses.  
		* Not case sensitive, relatively slow (why scoping is good) and runs in the foreground.
	* Find substring, background.
		* Same as find substring, but runs in background for those times when you can''t reduce the scope.
      * Add extensions to Refactoring Browser
		* Only addes extensions to currently open refactoring browsers
      * Build MyTools
		* Make MyTools fileouts for the various platforms

Miscellaneous Protocol
	"An easier BOSS interface."
	MyTools bossOutObject: anObject on: ''aFilenameString''.
	MyTools bossInObjectFrom: ''aFilenameString''.

	"Various Customizations"
	MyTools addToLauncher.			"MyTools submenu is dropped on image save for some reason."
	MyTools setDefaultKeyBindings.
	MyTools setEmacsKeyBindings.
	MyTools setDeleteKey.
	MyTools setFileBrowserToShowAllFiles.
	MyTools setUiLookToMotif.
[R]	MyTools extendRefactoringBrowserMenus 	"A non-intrusive way to extend the RB menus."

	"Misc Envy stuff."
[E]	MyTools loadConfigMapsWithRequired.
[E] 	MyTools loadConfigMapsWithRequired: ''ENVY/Manager''.
[E]	MyTools reportOnConfigMapDiffs.	
[E]	MyTools reportOnConfigMapDiffs: #(''ConfigMap1'' ''ConfigMap2'').
[E]	MyTools changeOwnershipsOfUser.		"Use this method with care!!"

Examples
	"There''s a number of examples of snippets of how to do things in the examples protocol on the class side of MyToolsBase"
	MyTools browseAllClassExamples.
	MyTools changeImageColours.		"Not the best choice in the world for the defaults ;-)"
	MyTools openWindowWithTextInIt.
	MyTools openWindowWithCapturedImage.

Your own extensions
	If your extensions are generic, please send them to me for future inclusion in the toolkit.  If your extensions are employer/situation-specific, then your best option is to subclass off of the MyTools proxy class, or if you prefer, you can subclass off of MyToolsBase or MyToolsEnvy, as the case may be.

Extensions to base
	*NOTE* These are the extensions to the base classes.  
		They will show up in the category where the base class is defined.
[E]		They will show up in the default application.
	StandardSystemController>inspectView
	StandardSystemController class>initializeForAdditions
[R]	SystemNavigator>findSubStringOverClasses
[R]	SystemNavigator>inspectSelectedMethod
[R]	SystemNavigator>sendSelectedMethod
[R]	SystemNavigator>copyFullClassSpec
[E]	EtApplicationsChangesBrowser>printChangesReportToTranscript'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!MyToolsBase class publicMethodsFor: 'bossing'!

bossInObjectFrom: aFilenameString 
	"A friendlier BOSS i/f.  Answer the first object in the BOSS File named aFilename"

	| b obj |
	^Cursor read
		showWhile: 
			[b := BinaryObjectStorage onOld: aFilenameString asFilename readStream.
			[obj := b next]
				valueNowOrOnUnwindDo: [b close].
			obj]!

bossOutObject: anObject on: aFilenameString 
	"A friendlier BOSS i/f.  Boss out anObject on a filename."

	| b |
	Cursor write
		showWhile: 
			[b := BinaryObjectStorage onNew: aFilenameString asFilename writeStream.
			[b nextPut: anObject]
				valueNowOrOnUnwindDo: [b close]]! !

!MyToolsBase class publicMethodsFor: 'bridging'!

myBridge

	^MyToolsImplementor implementorToUse.! !

!MyToolsBase class publicMethodsFor: 'building'!

build
	Transcript cr;  show: '---------'; cr; show: 'Starting fileout of MyTools...'.
	self myFileOutForVw.!

myBaseClasses

	^#(#MyToolsImplementor #Vw_Implementor #Vw252_Implementor #Vw31_Implementor #MyToolsBase #MyTools)!

myBaseClassExtensions

	^(Dictionary new)
		at: #StandardSystemController
			put: #(#inspectView #initializeForAdditions) asSet;
		yourself!

myBaseFileName

	^('MyTools-Vw-' , self version , '.st') asFilename!

myFileOutClasses: classes andExtensions: classExtensions onFileName: aFileName 
	"Extensions are filed out first, since the base initialization references an extension."

	| sourceStream firstClass |
	sourceStream := SourceCodeStream write: aFileName encoding: #Source.
	classExtensions notNil 
		ifTrue: 
			[classExtensions keys do: 
					[:anExtension | 
					sourceStream 
						fileOutMessages: (classExtensions at: anExtension)
						for: (Smalltalk at: anExtension)
						logging: true.
					sourceStream 
						fileOutMessages: (classExtensions at: anExtension)
						for: (Smalltalk at: anExtension) class
						logging: true]].
	firstClass := true.
	classes notNil 
		ifTrue: 
			[classes do: 
					[:aClass | 
					firstClass 
						ifTrue: [firstClass := false]
						ifFalse: 
							[sourceStream cr; newPage; cr].
					(Smalltalk at: aClass
						ifAbsent: 
							[Dialog warn: 'Couldn''t find class ' , aClass asString , 'to file out']) 
							fileOutSourceOn: sourceStream]].
	sourceStream
		finishInitializations;
		close!

myFileOutForVw

	| classes classExtensions fileName |
	classes := self myBaseClasses.
	classExtensions := self myBaseClassExtensions.
	fileName := self myBaseFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.

	"The RB extensions are filed out separately to reduce coupling."
	classes := nil.
	classExtensions := self myRefactoringExtensions.
	fileName := self myRefactoringExtensionsFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.
	Transcript
		cr;
		show: '---------'!

myReadInRefactoringExtensionsFileName
	"Have this indirection to allow for the same initialization method to be used in MyToolsBase and MyToolsEnvy."

	^self myRefactoringExtensionsFileName.!

myRefactoringExtensions

	^(Dictionary new)
		at: #SystemNavigator
			put: #(#findSubStringOverClasses #inspectSelectedMethod #sendSelectedMethod  #copyFullClassSpec);
		yourself!

myRefactoringExtensionsFileName

	^('MyTools-VwRefactoringExtensions-' , self version , '.dat') asFilename! !

!MyToolsBase class publicMethodsFor: 'class initialization'!

addToLauncher

	self myBridge implementAddToLauncher!

initialize

	| loadRefactoringExtensions |
	loadRefactoringExtensions := true.
	self myRefactoringExtensions keys do: 
			[:aKey | 
			Smalltalk at: aKey
				ifAbsent: 
					[Dialog warn: 'NOTE:  Refactoring Browser not found, these extensions will not be loaded.'.
					loadRefactoringExtensions := false]].
	loadRefactoringExtensions 
		ifTrue: [self myReadInRefactoringExtensionsFileName fileIn].
	self
		addToLauncher;
		setFileBrowserToShowAllFiles.
	self myBridge implementInitialize! !

!MyToolsBase class publicMethodsFor: 'customization'!

setDefaultKeyBindings

	self myBridge implementSetDefaultKeyBindings.!

setDeleteKey

	self myBridge implementSetDeleteKey.!

setEmacsKeyBindings
	"For those old-timers out there."

	self myBridge implementSetEmacsKeyBindings.!

setFileBrowserToShowAllFiles

	self myBridge implementSetFileBrowserToShowAllFiles.!

setUiLookToMotif
	"to change UI Look"

	(UISettings preferenceModelFor: #defaultLookSelector) 
		value: #MotifLookPolicy! !

!MyToolsBase class publicMethodsFor: 'envy stubbing'!

changeOwnershipsOfUser

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

loadConfigMapsWithRequired 

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

loadConfigMapsWithRequired: configMapNamesToLoad

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

onlyImplementedInEnvy

	Dialog warn: 'NOTE:  Sorry, this function is only implemented in ENVY.'!

reportOnConfigMapDiffs

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

reportOnConfigMapDiffs: configMapsToCompare

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy! !

!MyToolsBase class publicMethodsFor: 'examples'!

browseAllClassExamples

	Browser browseAllClassExamples.!

changeImageColours
	"Not the best selection of colours for sure... ;-)"

	MotifWidgetPolicy defaultColorWidgetColors
	  	matchAt: SymbolicPaint background put: ColorValue pink.
	Screen default updatePaintPreferences.
	ScheduledControllers restore.!

openWindowWithCapturedImage

	| aScheduledWindow |
	aScheduledWindow := ScheduledWindow
	  	model: nil
			label: 'Image'
			minimumSize: 200 @ 200.
	aScheduledWindow component: Image fromUser.
	aScheduledWindow open!

openWindowWithTextInIt

	ComposedTextView open: (ValueHolder with: 'Hello World')! !

!MyToolsBase class publicMethodsFor: 'extensions'!

extendRefactoringBrowserMenus

	self myBridge implementExtendRefactoringBrowserMenus.! !

!MyToolsBase class publicMethodsFor: 'forensics'!

findString

	| searchString |
	searchString := Dialog request: 'String to search for'
				initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	Browser browseAllCallsOn: searchString.!

findSubString
	"Searches in foreground for specified substring (no wildcards needed), and recurses down subclasses."

	| methods startingClass wildCardString allSelectors searchString |
	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
	startingClass withAllSubclasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method.
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: (self myBridge implementMethodSelectorFor: method) ]]]].
	methods isEmpty
	ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
	ifFalse: [MethodListBrowser 
		openListBrowserOn: methods
		label:  'Methods with: ' , wildCardString printString
		initialSelection: searchString]!

findSubStringForClasses: anArrayOfClassNames

	"FIXME - work in progress, needs refactoring.  Searches in foreground for specified substring (no wildcards needed) - no recursion."

	| methods wildCardString allSelectors searchString anArrayOfClasses |
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
"FIXME - refactoring note, this method differs from findSubString method in that it accepts args, and the line below."
	anArrayOfClasses := anArrayOfClassNames collect: [:aClassName | Smalltalk at: aClassName].
	anArrayOfClasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method.
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: (self myBridge implementMethodSelectorFor: method) ]]]].
	methods isEmpty
	ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
	ifFalse: [MethodListBrowser 
		openListBrowserOn: methods
		label:  'Methods with: ' , wildCardString printString
		initialSelection: searchString]!

findSubStringInBackground
	"VW 2.5.2  Searches in background for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - consider refactoring this method and findSubString method - what about high granularity though?"
	| methods startingClass wildCardString allSelectors searchString |

	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

  methods := OrderedCollection new.
  startingClass withAllSubclasses do: 
	[:cls | 
	"For each class we are searching, yield control at a lower priority than the 
	userSchedulingPriority, as well as a lower priority than for each method 
	below, so the methods being searched resume before iterating over the 
	classes."
	[allSelectors := cls selectors.  "Add the instance selectors of the class"
	allSelectors addAll: cls class selectors. "Add the class selectors of the class"
	allSelectors do: 
	  [:selector | 
		[| method source |
		  "Get the selector if it is an instance method, failing that get a 
		  selector if it is a class method, failing that print an error to the 
		  transcript and return false"

		method := cls compiledMethodAt: selector 
				  ifAbsent: [cls class compiledMethodAt: selector
					ifAbsent: [Transcript show: 'missing method: '; show: selector; cr. false]].
		(method == false)
	  ifFalse: 
	    [source := self myBridge implementGetSourceFor: method.
	    (source notNil and: [wildCardString match: source])
	      ifTrue: ["If there is a match, add the method to the 
		OrderedCollection methods, yield control, and fork at a priority slightly lower 
		than the userSchedulingPriority. This allows VW to refresh 
		itself so the user can busy themselves with other tasks."
		methods add: (self myBridge implementMethodSelectorFor: method)]].
		 Processor yield] 
	   forkAt: 49].
	"Check to see if we're on the last class of the OrderedCollection 
	we are checking, and if so open the MethodsBrowser and get a screen 
	refresh so that the user doesn't have to manually refresh the window."
	(cls = startingClass withAllSubclasses last)
	  ifTrue: 
		[methods isEmpty
			ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
			ifFalse: [MethodListBrowser 
				openListBrowserOn: methods
				label:  'Methods with: ' , wildCardString printString
				initialSelection: searchString.
				ScheduledControllers restore]].
	Processor yield]
  forkAt: 48]! !

!MyToolsBase class publicMethodsFor: 'help/documentation'!

helpScreen
	"Open a help screen based on my class comment."

	ComposedTextView open: (ValueHolder with: self comment)
		label: 'MyTools help information'
		icon: (Icon constantNamed: #workspace)
		extent: 500@600!

notesBuilding

^'
The intention is to be able to build for all applicable environments from any one environment.  Obviously, if you are running in a nonENVY environment, you will not be able to build for that though.  If this toolkit is ported to other flavours, I expect the filing out methods will need to be bridged.

For example, if you are running in VW252+ENVY301, build for:  VW252, VW252+ENVY301, VW30, VW30+ENVY301.  
For example, if you are running in VW252, build for: VW252, VW30.
'!

notesChangeHistory

^'
Change history:
0.3
  * Added some ENVY extensions
	* building in ENVY, finding string tweaks, Config map loading, config map diffing, change ownerships, copy class specification [R], storing workspaces in comments of methods
  * Decoupled Refactoring Browser extensions from the base installation

0.2
  * Added help text
  * Added notes in help/documentation protocol of MyToolsBase
  * Refactored design to make it more portable across versions/dialects of Smalltalk (put in proxy, bridge).  However, as noted in the help text, the primary platform for this toolkit is VWNC.  I do not have the spare time to regularly or ever try/test it on other platforms.
  * Added a packaging facility (file out).
  * Added naming convention to indicate that a method is bridged (implement*)
  * Added naming convention to indicate private methods (my*)
  * Added emacs keybindings
  * Added refactoring browser extensions
 
0.1
  * Initial implementation, purely for myself and a few friends on VWNC
'!

notesDevelopmentConsiderations

^'
This toolkit started out in a VWNC environment, which is its primary target.  Though I have tried to keep portability in mind while adding to it, my spare time is too constrained to make efforts to try it out and tweak it in other environments.  I would be happy to include fixes necessitated by other environments if sent to me.  If sending fixes/updates, just change the version indicator (MyToolsBase>version) to be something like: "0.3+JoeSmithAdditions", then use the Tools>MyTools>Build MyTools menu option to get the fileout to send to me (do not change ordering of classes/extensions in building methods, as that will mess up my sdiff - just tack on changes to the end)  Note:  if you are planning on doing large changes/extensions, pls contact me first as this method of adding changes/extensions will probably break down with large deltas.

This toolkit follows an old tradition of accumulating tools in class methods for easy access during gigs.  Constraining the refactoring and writing at a high level of granularity is intended to make it easier to grab a method to print out as a sample for sharing, aid in porting between versions/flavours of Smalltalks, and simplify the toolkit interface.  A number of tools are available in the class methods of MyTools and MyToolsEnvy, but are accessed through the MyTools proxy class for a single point of access.  As part of programming to the lowest common denominator, keep these things in mind:
  * If programming in ENVY, only use public protocols.  
  * Do not use public protocols denoted as private on MyTools* classes (ie: building-private).  Since there should not be many private methods while programming at a high level of granularity, having private protocols is unnecessary clutter.  (Maybe this will change, will have to see how the toolkit evolves)
  * If you need to refactor, please prefix private methods with "my" to indicate they are private
  * To aid portability
	* Use the supplied bridge to implement flavour-specific code.  
	* By convention, concrete methods are prefixed with "implement" to denote that they are actually bridged.

Q: Why do you have the bridge set up the way you do?  Why not have refined abstractions represent the different flavours of Smalltalk and have the concrete implementors represent the different configuration managemnt tools available to Smalltalk?
A: This view of the design is the first one that intuitively suggests itself, but I chose to do it in the vice-versa manner because I expect there to be more variety of differences in the Smalltalks realm.  My intent is to insulate users of the ToolKit by pushing the greater variety to the implementor of the bridge, allowing for a cleaner, easier use interface for the toolkit.  This also avoids additional complexity of implementing a chain of responsibility between abstraction and implementors that would be needed (Proxy would need to point to ENVY implementor if ENVY was present, as ENVY enhancements are on top of the Smalltalk base, and the ENVY class would in turn need to point to the Smalltalk flavour being used to catch interface selectors that it does not implement)

Q: Why is the proxy #MyTools not subclassed off of nil?  That is a much better Smalltalk implementation, otherwise the proxy understands a number of messages that I might want forwarded.
Q: Because doing that does not work with fileouts.  Trying to refile back in will cause an error.  Subclassing off of Object is the best lowest common denominator solution.  By all means, change the subclassing of the proxy to be off of nil after filing back in.

Q: I added a class or class extension to the toolkit, why is it not being filed out?
A: You need to update the filing out methods myFileOutFor* as appropriate.  

Q: If you want this to be portable, how come you have not used collaborator methods?
A: See MyTools notesToDo

Q: How come you denote methods that should be overriden with "self notImplementedYet" as opposed to "self subclassResponsibility"?
A: This provides a friendlier interface to users or porters.  Instead of throwing an unhandled exception, a (somewhat) informative dialog appears.  A friendlier interface could be done via handling the error, but since each flavour implements exception handling differently, this lowest common denominator is a better solution.
'!

notesDevelopmentReminders

^'
If you are updating MyTools, remember:
* denote methods that need further work with a "FIXME" string
* when adding a method 
  * add method to MyToolsBase class comment for the help screen
* when adding a bridged method
  * be sure to add a self subclass responsibility method to superclass
  * add a concrete implementation in other implementors as well, if you know of them
* when adding an ENVY method
  * be sure to stub out in MyToolsBase (see envy stubbing protocol)
* if making a new version of the toolkit, be sure to update the MyToolsBase>version method, as well as the version text in the help text  (MyToolsBase class comment).
'!

notesForFilingOut

^'
Given the desire for portability, there is a need to use the lowest common denominator for exchanging code, which is filing out.  To achive portable fileouts, there is a need to build a matrix of fileout methods that will file out from one environment and massage the fileout for other enviroments.
'!

notesKnownBugs

^' (Last bug number: 1)
1) [RB] When no app selected in RB, and choose copy full class spec, get an error when ask nil isVersion

'!

notesMisc

^'
Miscellaneous Notes
	* To do work-specific extensions, just subclass MyTools and extend as necessary.
	* ENVY
		* Though I have tried to identify the aspects of this toolkit that use/require ENVY, it has all been written in an ENVYized image and its primary target is for ENVYized images, so there may be methods not categorized into the ENVY protocols that I missed.
		* If you are using ENVY, it is a good idea to put <MyTools addToToolsMenu> in the application loaded method to autoinitialize the classes.
		* An easy way to store workspaces for future reference is in the comment of a method.  If you are using EMVY, if you have a workspace(s) that you often use, just put the workspace invocation in the loaded method of the class app.  This allows for developers to store/share whatever workspaces they want, without namespace problems.  To try this facility, do: MyTools workspaceJasonDefault.

Change history:
0.2
  * Refactored design to make it more portable across versions/dialects of Smalltalk
  * Added a building facility (file out).
'!

notesPortability

^'
Though I wrote this toolkit with portability in mind, this is not something I really have the time or access to environments to try out.  Well, maybe I will try it out in Squeak someday.  Anyway, if you want to port this toolkit to another environment, I will be glad to incorporate the changes required in future versions of the toolkit.  Also, I am willing to offer tips and what assistance my spare time allows.  Alternatively, providing the environment (and $) would also help :-).
'!

notesTesting

^'
Since this is something I am doing in my spare time, I just test enough for my own personal purposes.  If there is something that is outside of my typical use scope, then I will probably not pick up on it.  But, here is a list of things that can be used as a basis for testing.  Ideally, it would be nice to get Becks free testing framework to automate some unit tests, but that is another thing my spare time does not allow for.

* Ensure that protocol actually supported in MyToolsBase and MyToolsEnvy is in the help screen (class comment of MyToolsBase)
* In all environments:
  * Try the filein
  * Try the build
  * Check to see if MyTools has been added to the Transcript
  * Try all actions off of the MyTools submenu
  * Exercise all applicable protocol specified in the help screen
'!

notesToDo

^'
...In my copious amounts of spare time :-)

  * Document design (HotDraw, html?)
  * Work the known bugs
  * Add these various notes to submenu off of MyTools submenu
  * Go through code, and address FIXMEs
  * come up with a better implementation of MyToolsImplementor>implmentorToUse
  * Do some sort of sanity check that the code filed in OK
  * Be able to scope text searches by categories/applications in various browsers (done for [R])
  * Look into adding some good public domain code to the toolkit
  * Find out why addition to tools menu is lost on saving the image
  * Move nicer BOSS i/f to bridge
  * Find a way to extend the EtApplicationsManager without having to over-ride the base class side method
  * Think about a way to store workspaces in VW in a convenient manner (with intermixed comments and code)
  * Check that base extensions do file into the default application in VW+ENVY
  * Change cursor to busy during long ops now that bridge negates that
  * Change Launcher & RB menu additions to remove existing additions, and replace with new ones when invoked, rather than just not adding items as it now does.
  * Think about insulating class refs by using collaborator methods.  See example in method
'
"
---
classUiFeelPolicy
	^Smalltalk at: #UIFeelPolicy ifAbsent: [self warnClassNotFound: 'UIFeelPolicy'.].

warnClassNotFound: aClassName
	self classDialog warn: 'Warning:  Class ''', aClassName, ''' was not found.'.
	^nil

	* Use collaborator methods to insulate against referencing nonexistant classes in different flavours of Smalltalk
	  * By convention, these methods are prefixed with 'class' to denote they're a collaboborator method.
		* Since error handling varies a lot from platform to platform, errors with classes not found are simply handled by opening a warning dialog to this effect (self warnClassNotFound: aClass), and then letting the walkback occur.
---
"! !

!MyToolsBase class publicMethodsFor: 'misc'!

copySpecForClass: selectedClass inApplication: selectedApp

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

version
	"If there's a '+' in my version string, that indicates a work-in-progress."

	^'0.3'! !

MyToolsBase initialize!


Object subclass: #MyTools
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

MyTools comment: 'I''m a proxy for the MyTools toolkit, my responsibility is to act as a single point of reference and forward all messages to MyToolsEnvy (if it exists), or to MyToolsBase otherwise.  This way, I insulate the access point to the toolkit regardless of whether I''m loaded in a VW image or a VW+ENVY image.

Ideally, I should be subclassed off of nil, but since filing out and filing back in doesn''t allow for this, subclassing off of Object is the next best thing to do.'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!MyTools class publicMethodsFor: 'forwarding'!

doesNotUnderstand: aMessage 
	| realSubject |
	realSubject := Smalltalk at: #MyToolsEnvy
				ifAbsent: 
					[Smalltalk at: #MyToolsBase
						ifAbsent: [Dialog warn: 'MyToolsBase not found - try reloading MyTools.']].
	^realSubject perform: aMessage selector withArguments: aMessage arguments.! !

MyToolsBase subclass: #MyToolsEnvy
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!

MyToolsEnvy comment: 'I add a number of tools that can be used with Envy.  

Notes on building filenames:
  * There are a number of methods involved with providing the correct filenames for filing in and out, with some of them being redirection methods.  It may look a little convoluted at first, but this was done to avoid having MyToolsEnvy directly access their super class'' methods via super (not all Smalltalks implement super, and this is a bad practice anyway).


'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!MyToolsEnvy class publicMethodsFor: 'building'!

build
	super build.
	self myFileOutForVwEnvy.!

myEnvyClasses

	^super myBaseClasses , #(#MyToolsEnvy #MyToolsApp)!

myEnvyClassExtensions

	^(super myBaseClassExtensions)
		at: #EtApplicationsChangesBrowser
			put: #(#printChangesReportToTranscript) asSet;
		at: #EtApplicationManager put: #(#copyClassSpec) asSet;
		yourself!

myEnvyFileName

	^('MyTools-VwEnvy-' , self version , '.st') asFilename!

myEnvyRefactoringExtensionsFileName

	^('MyTools-VwEnvyRefactoringExtensions-' , self version , '.dat') asFilename!

myFileOutForVw
	| readStream writeStream fileNames stringToSearchFor fileNameTmp1 fileNameTmp2 |
	super myFileOutForVw.

	"Need to massage fileout from VW+ENVY to be readable by VW"
	fileNameTmp1 := 'MyTools-Vw-Tmp1.st' asFilename.
	fileNameTmp2 := 'MyTools-Vw-Tmp2.st' asFilename.
	fileNames := (OrderedCollection new)
				add: self myBaseFileName;
				add: self myRefactoringExtensionsFileName;
				yourself.
	fileNames do: 
			[:aFileName | 
			aFileName moveTo: fileNameTmp1.

			"Stage 1 - define categories."
			readStream := fileNameTmp1 readStream.
			writeStream := fileNameTmp2 writeStream.
			[readStream atEnd] whileFalse: 
					[writeStream
						nextPutAll: (readStream throughAll: 'poolDictionaries: ' , '''''');
						cr;
						tab.
					readStream atEnd 
						ifFalse: [writeStream nextPutAll: 'category: ''Tools-MyTools''']].
			readStream close.
			writeStream close.

			"Stage 2 - massage public method defs to plain vanilla method defs."
			readStream := fileNameTmp2 readStream.
			writeStream := aFileName writeStream.
			"Need to avoid meta corruption.  Set the string to search for by concatenating so when filing out this method, the string to search for isn't replaced, thus corrupting this fileout method for the next time around."
			stringToSearchFor := 'public' , 'Methods' , 'For: '.
			[readStream atEnd] whileFalse: 
					[writeStream nextPutAll: (readStream upToAll: stringToSearchFor).
					readStream atEnd 
						ifFalse: 
							[writeStream nextPutAll: 'methodsFor: '.
							readStream throughAll: stringToSearchFor]].
			readStream close.
			writeStream close.
			fileNameTmp1 delete.
			fileNameTmp2 delete]!

myFileOutForVwEnvy

	| classes fileName classExtensions |
	classes := self myEnvyClasses.
	classExtensions := self myEnvyClassExtensions.
	fileName := self myEnvyFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.

	"The RB extensions are filed out separately to reduce coupling."
	classes := nil.
	classExtensions := self myRefactoringExtensions.
	fileName := self myEnvyRefactoringExtensionsFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.
	Transcript
		cr;
		show: '---------'!

myReadInRefactoringExtensionsFileName
	"Have this indirection to allow for the same initialization method to be used in MyToolsBase and MyToolsEnvy."

	^self myEnvyRefactoringExtensionsFileName.! !

!MyToolsEnvy class publicMethodsFor: 'config map stuff'!

loadConfigMapsWithRequired

	| configMapNamesToLoad |
	configMapNamesToLoad := #('ENVY/Manager').
	self loadConfigMapsWithRequired: configMapNamesToLoad.!

loadConfigMapsWithRequired: configMapNamesToLoad

	Transcript cr; show: 'Loading (with required maps) config maps...'.
	configMapNamesToLoad
		do: 
			[:aConfigMapName | 
			| latestConfigMapEdition |
			latestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) first.
			Transcript cr; show: 'Loading config map: ' , latestConfigMapEdition printString , ' ...'.
			latestConfigMapEdition loadWithRequiredMaps ifFalse: [Dialog warn: 'Loading config map: ' , latestConfigMapEdition printString , ' has failed.']]!

reportOnConfigMapDiffs
	"self reportOnConfigMapDiffs"
	"Simple criteria - compares latest and 2nd latest versions of maps.  Be careful using this if you have multiple streams"

	self reportOnConfigMapDiffs: #( 'Config Map 1' 'Config Map 2' )!

reportOnConfigMapDiffs: configMapsToCompare
	"Simple criteria - compares latest and 2nd latest versions of maps.  Be careful using this if you have multiple streams"

	| browser |
	Transcript cr; show: 'Comparing latest and second latest versions of config maps...'.
	configMapsToCompare do: 
			[:aConfigMapName | 
			| latestConfigMapEdition secondLatestConfigMapEdition |
			latestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) at: 1.
			secondLatestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) at: 2.
			browser := EtApplicationsChangesBrowser 
						forApplications: (secondLatestConfigMapEdition 
								differencesWith: latestConfigMapEdition)
						in: latestConfigMapEdition.
			browser printChangesReportToTranscript]! !

!MyToolsEnvy class publicMethodsFor: 'forensics'!

findSubString
	"Searches in foreground for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - work in progress - need to refactor between me and super class.   The differences are:
		-uses the EtHighlightingMethodsBrowser, which is nice in that it successfully highlights recurring occurances
		-add methods, as opposed to method defs (req't of EtHighlightingMethodsBrowser)"

	| methods startingClass wildCardString allSelectors searchString |
	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
	startingClass withAllSubclasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method. 
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: method]]]].
	methods isEmpty
		ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
		ifFalse: [(EtHighlightingMethodsBrowser 
			on: methods
			labeled: 'Methods with: ' , wildCardString printString
			highlighting: searchString)
			open]!

findSubStringInBackground
	"VW 2.5.2  Searches in background for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - work in progress - need to refactor between me and super class.  The differences are:
		-uses the EtHighlightingMethodsBrowser, which is nice in that it successfully highlights recurring occurances
		-add methods, as opposed to method defs (req't of EtHighlightingMethodsBrowser)"

	| methods startingClass wildCardString allSelectors searchString |

	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

  methods := OrderedCollection new.
  startingClass withAllSubclasses do: 
	[:cls | 
	"For each class we are searching, yield control at a lower priority than the 
	userSchedulingPriority, as well as a lower priority than for each method 
	below, so the methods being searched resume before iterating over the 
	classes."
	[allSelectors := cls selectors.  "Add the instance selectors of the class"
	allSelectors addAll: cls class selectors. "Add the class selectors of the class"
	allSelectors do: 
	  [:selector | 
		[| method source |
		  "Get the selector if it is an instance method, failing that get a 
		  selector if it is a class method, failing that print an error to the 
		  transcript and return false"

		method := cls compiledMethodAt: selector 
				  ifAbsent: [cls class compiledMethodAt: selector
					ifAbsent: [Transcript show: 'missing method: '; show: selector; cr. false]].
		(method == false)
	  ifFalse: 
	    [source := self myBridge implementGetSourceFor: method.
	    (source notNil and: [wildCardString match: source])
	      ifTrue: ["If there is a match, add the method to the 
		OrderedCollection methods, yield control, and fork at a priority slightly lower 
		than the userSchedulingPriority. This allows VW to refresh 
		itself so the user can busy themselves with other tasks."
		methods add: method]].
		 Processor yield] 
	   forkAt: 49].
	"Check to see if we're on the last class of the OrderedCollection 
	we are checking, and if so open the MethodsBrowser and get a screen 
	refresh so that the user doesn't have to manually refresh the window."
	(cls = startingClass withAllSubclasses last)
	  ifTrue: 
		[methods isEmpty
			ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
			ifFalse: [(EtHighlightingMethodsBrowser
				  on: methods
				  labeled: 'Methods with: ' , wildCardString
				  highlighting: searchString) open.
		ScheduledControllers restore]].
	Processor yield]
  forkAt: 48]! !

!MyToolsEnvy class publicMethodsFor: 'help/documentation'!

helpScreen
	"Since the help screen text is on the class comment of MyToolsBase, need to override my inherited method to this effect."

	MyToolsBase helpScreen! !

!MyToolsEnvy class publicMethodsFor: 'misc'!

changeOwnershipsOfUser
	"Use this method with care!!"

	"FIXME - update method to provide a little info before executing (like, needs to be run as the Library Supervisor, as well as prompting the user for users."

	| newUser classNames users |
	Transcript clear.
	newUser := EmUser called: 'New Owner'.
	users := Set withAll: EmUser allUsers.
	users remove: (EmUser called: 'Old Owner') ifAbsent: [self halt].
	users do: 
			[:user | 
			Transcript
				show: 'changing user: ' , user uniqueName;
				cr.
			Tools managerInterface selectSubApplications: 
					[:app | 
					(app groupMembers includes: user) 
						ifTrue: 
							[classNames := app allClassNamesOwnedBy: user.
							(app groupMembers includes: newUser) 
								ifFalse: 
									[app updateEdition: 
											[:editionRecord | 
											editionRecord
												addGroupMember: newUser uniqueName;
												insert]].
							app editionRecord manager = user uniqueName 
								ifTrue: 
									[app 
										updateEdition: [:editionRecord | editionRecord manager: newUser uniqueName]].
							classNames notEmpty 
								ifTrue: 
									[app 
										updateEdition: [:editionRecord | editionRecord ownerOf: classNames to: newUser uniqueName]].
							app updateEdition: 
									[:editionRecord | 
									editionRecord
										removeGroupMember: user uniqueName;
										insert]]]]!

copySpecForClass: selectedClass inApplication: selectedApp

	| classSpec appSpec fullClassSpec |
	selectedApp isVersion
		ifTrue: [appSpec := selectedApp versionName]
		ifFalse: [appSpec := selectedApp timeStamp printString.
			selectedApp isScratch
				ifTrue: [appSpec := '<< ', selectedApp versionName, ' >>']].
	(selectedClass isVersionIn: selectedApp)
		ifTrue: [classSpec := selectedClass versionNameIn: selectedApp]
		ifFalse: [classSpec := (selectedClass timeStampIn: selectedApp) printString].
	fullClassSpec := selectedApp printString, ' ', appSpec, ' ', selectedClass name, ' ', classSpec.
	Transcript cr; show: fullClassSpec.
	ParagraphEditor currentSelection: fullClassSpec.! !

!MyToolsEnvy class publicMethodsFor: 'workspaces'!

workspaceJasonDefault
	"This is an example persistent workspace.  The workspace text is actually stored in my comment in an ENVYized environment.  You need to be careful if copying,  renaming, or filing in/out this method, as any comment text is lost in those operations.  The nice aspect of storing workspaces this way, is you can type text with comments intersperced, which is often useful in workspace code.
	If this is a default method that is used a lot, then it's handy to put its invocation in the loaded method of the application this code is stored in."

	ComposedTextView 
		open: (ValueHolder with: (self class compiledMethodAt: #workspaceJasonDefault) comment)
		label: 'Jason''s default workspace'
		icon: (Icon constantNamed: #workspace)
		extent: 500 @ 600! !

SubApplication subclass: #MyToolsApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''!


MyToolsApp becomeDefault!

!EtApplicationManager publicMethodsFor: 'ET-Internal'!

copyClassSpec

"FIXME - still under development.  Need to find a an unintrusive way to add this.  If you want to add it in, just hook this in via the method hierarchicalClassesListWidget, set the menu selector to be classesMenuHook, instead of classesMenu
"
"classesMenuHook

	^(self classesMenu) addLine;
		add: #copyClassSpec
		label: 'copy full class spec'
		enable: [self isOneClassSelected]; yourself
"

	MyTools copySpecForClass: self selectedClass inApplication: self selectedApplication.! !

!EtApplicationsChangesBrowser publicMethodsFor: 'ET-Internal'!

printChangesReportToTranscript

	| theClass classSpec appSpec selectedApp selectedClass fullClassSpec |
	self execShortOperation: [
	Transcript cr; show: 'Changes found in config map: ', self parentComponent printString.
	self applications do: [:app |
		(self applicationDictionary at: app) value associationsDo: [:clAssoc |
		theClass := clAssoc key.
	selectedApp := app.
	selectedApp isVersion
		ifTrue: [appSpec := selectedApp versionName]
		ifFalse: [appSpec := selectedApp timeStamp printString.
			selectedApp isScratch
				ifTrue: [appSpec := '<< ', selectedApp versionName, ' >>']].
	selectedClass := theClass.
	(selectedClass isVersionIn: selectedApp)
		ifTrue: [classSpec := selectedClass versionNameIn: selectedApp]
		ifFalse: [classSpec := (selectedClass timeStampIn: selectedApp) printString].
	fullClassSpec := selectedApp printString, ' ', appSpec, ' ', selectedClass name, ' ', classSpec.
	Transcript cr; tab; show: fullClassSpec.
	ParagraphEditor currentSelection: fullClassSpec.]]]! !

!MyTools class publicMethodsFor: 'forwarding'!

doesNotUnderstand: aMessage 
	| realSubject |
	realSubject := Smalltalk at: #MyToolsEnvy
				ifAbsent: 
					[Smalltalk at: #MyToolsBase
						ifAbsent: [Dialog warn: 'MyToolsBase not found - try reloading MyTools.']].
	^realSubject perform: aMessage selector withArguments: aMessage arguments.! !

!MyToolsApp class publicMethodsFor: 'class initialization'!

loaded
	MyToolsBase initialize! !

!MyToolsBase class publicMethodsFor: 'bossing'!

bossInObjectFrom: aFilenameString 
	"A friendlier BOSS i/f.  Answer the first object in the BOSS File named aFilename"

	| b obj |
	^Cursor read
		showWhile: 
			[b := BinaryObjectStorage onOld: aFilenameString asFilename readStream.
			[obj := b next]
				valueNowOrOnUnwindDo: [b close].
			obj]!

bossOutObject: anObject on: aFilenameString 
	"A friendlier BOSS i/f.  Boss out anObject on a filename."

	| b |
	Cursor write
		showWhile: 
			[b := BinaryObjectStorage onNew: aFilenameString asFilename writeStream.
			[b nextPut: anObject]
				valueNowOrOnUnwindDo: [b close]]! !

!MyToolsBase class publicMethodsFor: 'bridging'!

myBridge

	^MyToolsImplementor implementorToUse.! !

!MyToolsBase class publicMethodsFor: 'building'!

build
	Transcript cr;  show: '---------'; cr; show: 'Starting fileout of MyTools...'.
	self myFileOutForVw.!

myBaseClasses

	^#(#MyToolsImplementor #Vw_Implementor #Vw252_Implementor #Vw31_Implementor #MyToolsBase #MyTools)!

myBaseClassExtensions

	^(Dictionary new)
		at: #StandardSystemController
			put: #(#inspectView #initializeForAdditions) asSet;
		yourself!

myBaseFileName

	^('MyTools-Vw-' , self version , '.st') asFilename!

myFileOutClasses: classes andExtensions: classExtensions onFileName: aFileName 
	"Extensions are filed out first, since the base initialization references an extension."

	| sourceStream firstClass |
	sourceStream := SourceCodeStream write: aFileName encoding: #Source.
	classExtensions notNil 
		ifTrue: 
			[classExtensions keys do: 
					[:anExtension | 
					sourceStream 
						fileOutMessages: (classExtensions at: anExtension)
						for: (Smalltalk at: anExtension)
						logging: true.
					sourceStream 
						fileOutMessages: (classExtensions at: anExtension)
						for: (Smalltalk at: anExtension) class
						logging: true]].
	firstClass := true.
	classes notNil 
		ifTrue: 
			[classes do: 
					[:aClass | 
					firstClass 
						ifTrue: [firstClass := false]
						ifFalse: 
							[sourceStream cr; newPage; cr].
					(Smalltalk at: aClass
						ifAbsent: 
							[Dialog warn: 'Couldn''t find class ' , aClass asString , 'to file out']) 
							fileOutSourceOn: sourceStream]].
	sourceStream
		finishInitializations;
		close!

myFileOutForVw

	| classes classExtensions fileName |
	classes := self myBaseClasses.
	classExtensions := self myBaseClassExtensions.
	fileName := self myBaseFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.

	"The RB extensions are filed out separately to reduce coupling."
	classes := nil.
	classExtensions := self myRefactoringExtensions.
	fileName := self myRefactoringExtensionsFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.
	Transcript
		cr;
		show: '---------'!

myReadInRefactoringExtensionsFileName
	"Have this indirection to allow for the same initialization method to be used in MyToolsBase and MyToolsEnvy."

	^self myRefactoringExtensionsFileName.!

myRefactoringExtensions

	^(Dictionary new)
		at: #SystemNavigator
			put: #(#findSubStringOverClasses #inspectSelectedMethod #sendSelectedMethod  #copyFullClassSpec);
		yourself!

myRefactoringExtensionsFileName

	^('MyTools-VwRefactoringExtensions-' , self version , '.dat') asFilename! !

!MyToolsBase class publicMethodsFor: 'class initialization'!

addToLauncher

	self myBridge implementAddToLauncher!

initialize

	| loadRefactoringExtensions |
	loadRefactoringExtensions := true.
	self myRefactoringExtensions keys do: 
			[:aKey | 
			Smalltalk at: aKey
				ifAbsent: 
					[Dialog warn: 'NOTE:  Refactoring Browser not found, these extensions will not be loaded.'.
					loadRefactoringExtensions := false]].
	loadRefactoringExtensions 
		ifTrue: [self myReadInRefactoringExtensionsFileName fileIn].
	self
		addToLauncher;
		setFileBrowserToShowAllFiles.
	self myBridge implementInitialize! !

!MyToolsBase class publicMethodsFor: 'customization'!

setDefaultKeyBindings

	self myBridge implementSetDefaultKeyBindings.!

setDeleteKey

	self myBridge implementSetDeleteKey.!

setEmacsKeyBindings
	"For those old-timers out there."

	self myBridge implementSetEmacsKeyBindings.!

setFileBrowserToShowAllFiles

	self myBridge implementSetFileBrowserToShowAllFiles.!

setUiLookToMotif
	"to change UI Look"

	(UISettings preferenceModelFor: #defaultLookSelector) 
		value: #MotifLookPolicy! !

!MyToolsBase class publicMethodsFor: 'envy stubbing'!

changeOwnershipsOfUser

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

loadConfigMapsWithRequired 

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

loadConfigMapsWithRequired: configMapNamesToLoad

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

onlyImplementedInEnvy

	Dialog warn: 'NOTE:  Sorry, this function is only implemented in ENVY.'!

reportOnConfigMapDiffs

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

reportOnConfigMapDiffs: configMapsToCompare

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy! !

!MyToolsBase class publicMethodsFor: 'examples'!

browseAllClassExamples

	Browser browseAllClassExamples.!

changeImageColours
	"Not the best selection of colours for sure... ;-)"

	MotifWidgetPolicy defaultColorWidgetColors
	  	matchAt: SymbolicPaint background put: ColorValue pink.
	Screen default updatePaintPreferences.
	ScheduledControllers restore.!

openWindowWithCapturedImage

	| aScheduledWindow |
	aScheduledWindow := ScheduledWindow
	  	model: nil
			label: 'Image'
			minimumSize: 200 @ 200.
	aScheduledWindow component: Image fromUser.
	aScheduledWindow open!

openWindowWithTextInIt

	ComposedTextView open: (ValueHolder with: 'Hello World')! !

!MyToolsBase class publicMethodsFor: 'extensions'!

extendRefactoringBrowserMenus

	self myBridge implementExtendRefactoringBrowserMenus.! !

!MyToolsBase class publicMethodsFor: 'forensics'!

findString

	| searchString |
	searchString := Dialog request: 'String to search for'
				initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	Browser browseAllCallsOn: searchString.!

findSubString
	"Searches in foreground for specified substring (no wildcards needed), and recurses down subclasses."

	| methods startingClass wildCardString allSelectors searchString |
	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
	startingClass withAllSubclasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method.
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: (self myBridge implementMethodSelectorFor: method) ]]]].
	methods isEmpty
	ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
	ifFalse: [MethodListBrowser 
		openListBrowserOn: methods
		label:  'Methods with: ' , wildCardString printString
		initialSelection: searchString]!

findSubStringForClasses: anArrayOfClassNames

	"FIXME - work in progress, needs refactoring.  Searches in foreground for specified substring (no wildcards needed) - no recursion."

	| methods wildCardString allSelectors searchString anArrayOfClasses |
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
"FIXME - refactoring note, this method differs from findSubString method in that it accepts args, and the line below."
	anArrayOfClasses := anArrayOfClassNames collect: [:aClassName | Smalltalk at: aClassName].
	anArrayOfClasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method.
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: (self myBridge implementMethodSelectorFor: method) ]]]].
	methods isEmpty
	ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
	ifFalse: [MethodListBrowser 
		openListBrowserOn: methods
		label:  'Methods with: ' , wildCardString printString
		initialSelection: searchString]!

findSubStringInBackground
	"VW 2.5.2  Searches in background for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - consider refactoring this method and findSubString method - what about high granularity though?"
	| methods startingClass wildCardString allSelectors searchString |

	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

  methods := OrderedCollection new.
  startingClass withAllSubclasses do: 
	[:cls | 
	"For each class we are searching, yield control at a lower priority than the 
	userSchedulingPriority, as well as a lower priority than for each method 
	below, so the methods being searched resume before iterating over the 
	classes."
	[allSelectors := cls selectors.  "Add the instance selectors of the class"
	allSelectors addAll: cls class selectors. "Add the class selectors of the class"
	allSelectors do: 
	  [:selector | 
		[| method source |
		  "Get the selector if it is an instance method, failing that get a 
		  selector if it is a class method, failing that print an error to the 
		  transcript and return false"

		method := cls compiledMethodAt: selector 
				  ifAbsent: [cls class compiledMethodAt: selector
					ifAbsent: [Transcript show: 'missing method: '; show: selector; cr. false]].
		(method == false)
	  ifFalse: 
	    [source := self myBridge implementGetSourceFor: method.
	    (source notNil and: [wildCardString match: source])
	      ifTrue: ["If there is a match, add the method to the 
		OrderedCollection methods, yield control, and fork at a priority slightly lower 
		than the userSchedulingPriority. This allows VW to refresh 
		itself so the user can busy themselves with other tasks."
		methods add: (self myBridge implementMethodSelectorFor: method)]].
		 Processor yield] 
	   forkAt: 49].
	"Check to see if we're on the last class of the OrderedCollection 
	we are checking, and if so open the MethodsBrowser and get a screen 
	refresh so that the user doesn't have to manually refresh the window."
	(cls = startingClass withAllSubclasses last)
	  ifTrue: 
		[methods isEmpty
			ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
			ifFalse: [MethodListBrowser 
				openListBrowserOn: methods
				label:  'Methods with: ' , wildCardString printString
				initialSelection: searchString.
				ScheduledControllers restore]].
	Processor yield]
  forkAt: 48]! !

!MyToolsBase class publicMethodsFor: 'help/documentation'!

helpScreen
	"Open a help screen based on my class comment."

	ComposedTextView open: (ValueHolder with: self comment)
		label: 'MyTools help information'
		icon: (Icon constantNamed: #workspace)
		extent: 500@600!

notesBuilding

^'
The intention is to be able to build for all applicable environments from any one environment.  Obviously, if you are running in a nonENVY environment, you will not be able to build for that though.  If this toolkit is ported to other flavours, I expect the filing out methods will need to be bridged.

For example, if you are running in VW252+ENVY301, build for:  VW252, VW252+ENVY301, VW30, VW30+ENVY301.  
For example, if you are running in VW252, build for: VW252, VW30.
'!

notesChangeHistory

^'
Change history:
0.3
  * Added some ENVY extensions
	* building in ENVY, finding string tweaks, Config map loading, config map diffing, change ownerships, copy class specification [R], storing workspaces in comments of methods
  * Decoupled Refactoring Browser extensions from the base installation

0.2
  * Added help text
  * Added notes in help/documentation protocol of MyToolsBase
  * Refactored design to make it more portable across versions/dialects of Smalltalk (put in proxy, bridge).  However, as noted in the help text, the primary platform for this toolkit is VWNC.  I do not have the spare time to regularly or ever try/test it on other platforms.
  * Added a packaging facility (file out).
  * Added naming convention to indicate that a method is bridged (implement*)
  * Added naming convention to indicate private methods (my*)
  * Added emacs keybindings
  * Added refactoring browser extensions
 
0.1
  * Initial implementation, purely for myself and a few friends on VWNC
'!

notesDevelopmentConsiderations

^'
This toolkit started out in a VWNC environment, which is its primary target.  Though I have tried to keep portability in mind while adding to it, my spare time is too constrained to make efforts to try it out and tweak it in other environments.  I would be happy to include fixes necessitated by other environments if sent to me.  If sending fixes/updates, just change the version indicator (MyToolsBase>version) to be something like: "0.3+JoeSmithAdditions", then use the Tools>MyTools>Build MyTools menu option to get the fileout to send to me (do not change ordering of classes/extensions in building methods, as that will mess up my sdiff - just tack on changes to the end)  Note:  if you are planning on doing large changes/extensions, pls contact me first as this method of adding changes/extensions will probably break down with large deltas.

This toolkit follows an old tradition of accumulating tools in class methods for easy access during gigs.  Constraining the refactoring and writing at a high level of granularity is intended to make it easier to grab a method to print out as a sample for sharing, aid in porting between versions/flavours of Smalltalks, and simplify the toolkit interface.  A number of tools are available in the class methods of MyTools and MyToolsEnvy, but are accessed through the MyTools proxy class for a single point of access.  As part of programming to the lowest common denominator, keep these things in mind:
  * If programming in ENVY, only use public protocols.  
  * Do not use public protocols denoted as private on MyTools* classes (ie: building-private).  Since there should not be many private methods while programming at a high level of granularity, having private protocols is unnecessary clutter.  (Maybe this will change, will have to see how the toolkit evolves)
  * If you need to refactor, please prefix private methods with "my" to indicate they are private
  * To aid portability
	* Use the supplied bridge to implement flavour-specific code.  
	* By convention, concrete methods are prefixed with "implement" to denote that they are actually bridged.

Q: Why do you have the bridge set up the way you do?  Why not have refined abstractions represent the different flavours of Smalltalk and have the concrete implementors represent the different configuration managemnt tools available to Smalltalk?
A: This view of the design is the first one that intuitively suggests itself, but I chose to do it in the vice-versa manner because I expect there to be more variety of differences in the Smalltalks realm.  My intent is to insulate users of the ToolKit by pushing the greater variety to the implementor of the bridge, allowing for a cleaner, easier use interface for the toolkit.  This also avoids additional complexity of implementing a chain of responsibility between abstraction and implementors that would be needed (Proxy would need to point to ENVY implementor if ENVY was present, as ENVY enhancements are on top of the Smalltalk base, and the ENVY class would in turn need to point to the Smalltalk flavour being used to catch interface selectors that it does not implement)

Q: Why is the proxy #MyTools not subclassed off of nil?  That is a much better Smalltalk implementation, otherwise the proxy understands a number of messages that I might want forwarded.
Q: Because doing that does not work with fileouts.  Trying to refile back in will cause an error.  Subclassing off of Object is the best lowest common denominator solution.  By all means, change the subclassing of the proxy to be off of nil after filing back in.

Q: I added a class or class extension to the toolkit, why is it not being filed out?
A: You need to update the filing out methods myFileOutFor* as appropriate.  

Q: If you want this to be portable, how come you have not used collaborator methods?
A: See MyTools notesToDo

Q: How come you denote methods that should be overriden with "self notImplementedYet" as opposed to "self subclassResponsibility"?
A: This provides a friendlier interface to users or porters.  Instead of throwing an unhandled exception, a (somewhat) informative dialog appears.  A friendlier interface could be done via handling the error, but since each flavour implements exception handling differently, this lowest common denominator is a better solution.
'!

notesDevelopmentReminders

^'
If you are updating MyTools, remember:
* denote methods that need further work with a "FIXME" string
* when adding a method 
  * add method to MyToolsBase class comment for the help screen
* when adding a bridged method
  * be sure to add a self subclass responsibility method to superclass
  * add a concrete implementation in other implementors as well, if you know of them
* when adding an ENVY method
  * be sure to stub out in MyToolsBase (see envy stubbing protocol)
* if making a new version of the toolkit, be sure to update the MyToolsBase>version method, as well as the version text in the help text  (MyToolsBase class comment).
'!

notesForFilingOut

^'
Given the desire for portability, there is a need to use the lowest common denominator for exchanging code, which is filing out.  To achive portable fileouts, there is a need to build a matrix of fileout methods that will file out from one environment and massage the fileout for other enviroments.
'!

notesKnownBugs

^' (Last bug number: 1)
1) [RB] When no app selected in RB, and choose copy full class spec, get an error when ask nil isVersion

'!

notesMisc

^'
Miscellaneous Notes
	* To do work-specific extensions, just subclass MyTools and extend as necessary.
	* ENVY
		* Though I have tried to identify the aspects of this toolkit that use/require ENVY, it has all been written in an ENVYized image and its primary target is for ENVYized images, so there may be methods not categorized into the ENVY protocols that I missed.
		* If you are using ENVY, it is a good idea to put <MyTools addToToolsMenu> in the application loaded method to autoinitialize the classes.
		* An easy way to store workspaces for future reference is in the comment of a method.  If you are using EMVY, if you have a workspace(s) that you often use, just put the workspace invocation in the loaded method of the class app.  This allows for developers to store/share whatever workspaces they want, without namespace problems.  To try this facility, do: MyTools workspaceJasonDefault.

Change history:
0.2
  * Refactored design to make it more portable across versions/dialects of Smalltalk
  * Added a building facility (file out).
'!

notesPortability

^'
Though I wrote this toolkit with portability in mind, this is not something I really have the time or access to environments to try out.  Well, maybe I will try it out in Squeak someday.  Anyway, if you want to port this toolkit to another environment, I will be glad to incorporate the changes required in future versions of the toolkit.  Also, I am willing to offer tips and what assistance my spare time allows.  Alternatively, providing the environment (and $) would also help :-).
'!

notesTesting

^'
Since this is something I am doing in my spare time, I just test enough for my own personal purposes.  If there is something that is outside of my typical use scope, then I will probably not pick up on it.  But, here is a list of things that can be used as a basis for testing.  Ideally, it would be nice to get Becks free testing framework to automate some unit tests, but that is another thing my spare time does not allow for.

* Ensure that protocol actually supported in MyToolsBase and MyToolsEnvy is in the help screen (class comment of MyToolsBase)
* In all environments:
  * Try the filein
  * Try the build
  * Check to see if MyTools has been added to the Transcript
  * Try all actions off of the MyTools submenu
  * Exercise all applicable protocol specified in the help screen
'!

notesToDo

^'
...In my copious amounts of spare time :-)

  * Document design (HotDraw, html?)
  * Work the known bugs
  * Add these various notes to submenu off of MyTools submenu
  * Go through code, and address FIXMEs
  * come up with a better implementation of MyToolsImplementor>implmentorToUse
  * Do some sort of sanity check that the code filed in OK
  * Be able to scope text searches by categories/applications in various browsers (done for [R])
  * Look into adding some good public domain code to the toolkit
  * Find out why addition to tools menu is lost on saving the image
  * Move nicer BOSS i/f to bridge
  * Find a way to extend the EtApplicationsManager without having to over-ride the base class side method
  * Think about a way to store workspaces in VW in a convenient manner (with intermixed comments and code)
  * Check that base extensions do file into the default application in VW+ENVY
  * Change cursor to busy during long ops now that bridge negates that
  * Change Launcher & RB menu additions to remove existing additions, and replace with new ones when invoked, rather than just not adding items as it now does.
  * Think about insulating class refs by using collaborator methods.  See example in method
'
"
---
classUiFeelPolicy
	^Smalltalk at: #UIFeelPolicy ifAbsent: [self warnClassNotFound: 'UIFeelPolicy'.].

warnClassNotFound: aClassName
	self classDialog warn: 'Warning:  Class ''', aClassName, ''' was not found.'.
	^nil

	* Use collaborator methods to insulate against referencing nonexistant classes in different flavours of Smalltalk
	  * By convention, these methods are prefixed with 'class' to denote they're a collaboborator method.
		* Since error handling varies a lot from platform to platform, errors with classes not found are simply handled by opening a warning dialog to this effect (self warnClassNotFound: aClass), and then letting the walkback occur.
---
"! !

!MyToolsBase class publicMethodsFor: 'misc'!

copySpecForClass: selectedClass inApplication: selectedApp

	"Stub out here to give VW users feedback if they try and exercise the ENVY protocol in VW"
	self onlyImplementedInEnvy!

version
	"If there's a '+' in my version string, that indicates a work-in-progress."

	^'0.3'! !

!MyToolsEnvy class publicMethodsFor: 'building'!

build
	super build.
	self myFileOutForVwEnvy.!

myEnvyClasses

	^super myBaseClasses , #(#MyToolsEnvy #MyToolsApp)!

myEnvyClassExtensions

	^(super myBaseClassExtensions)
		at: #EtApplicationsChangesBrowser
			put: #(#printChangesReportToTranscript) asSet;
		at: #EtApplicationManager put: #(#copyClassSpec) asSet;
		yourself!

myEnvyFileName

	^('MyTools-VwEnvy-' , self version , '.st') asFilename!

myEnvyRefactoringExtensionsFileName

	^('MyTools-VwEnvyRefactoringExtensions-' , self version , '.dat') asFilename!

myFileOutForVw
	| readStream writeStream fileNames stringToSearchFor fileNameTmp1 fileNameTmp2 |
	super myFileOutForVw.

	"Need to massage fileout from VW+ENVY to be readable by VW"
	fileNameTmp1 := 'MyTools-Vw-Tmp1.st' asFilename.
	fileNameTmp2 := 'MyTools-Vw-Tmp2.st' asFilename.
	fileNames := (OrderedCollection new)
				add: self myBaseFileName;
				add: self myRefactoringExtensionsFileName;
				yourself.
	fileNames do: 
			[:aFileName | 
			aFileName moveTo: fileNameTmp1.

			"Stage 1 - define categories."
			readStream := fileNameTmp1 readStream.
			writeStream := fileNameTmp2 writeStream.
			[readStream atEnd] whileFalse: 
					[writeStream
						nextPutAll: (readStream throughAll: 'poolDictionaries: ' , '''''');
						cr;
						tab.
					readStream atEnd 
						ifFalse: [writeStream nextPutAll: 'category: ''Tools-MyTools''']].
			readStream close.
			writeStream close.

			"Stage 2 - massage public method defs to plain vanilla method defs."
			readStream := fileNameTmp2 readStream.
			writeStream := aFileName writeStream.
			"Need to avoid meta corruption.  Set the string to search for by concatenating so when filing out this method, the string to search for isn't replaced, thus corrupting this fileout method for the next time around."
			stringToSearchFor := 'public' , 'Methods' , 'For: '.
			[readStream atEnd] whileFalse: 
					[writeStream nextPutAll: (readStream upToAll: stringToSearchFor).
					readStream atEnd 
						ifFalse: 
							[writeStream nextPutAll: 'methodsFor: '.
							readStream throughAll: stringToSearchFor]].
			readStream close.
			writeStream close.
			fileNameTmp1 delete.
			fileNameTmp2 delete]!

myFileOutForVwEnvy

	| classes fileName classExtensions |
	classes := self myEnvyClasses.
	classExtensions := self myEnvyClassExtensions.
	fileName := self myEnvyFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.

	"The RB extensions are filed out separately to reduce coupling."
	classes := nil.
	classExtensions := self myRefactoringExtensions.
	fileName := self myEnvyRefactoringExtensionsFileName.
	self 
		myFileOutClasses: classes
		andExtensions: classExtensions
		onFileName: fileName.
	Transcript
		cr;
		show: '---------'!

myReadInRefactoringExtensionsFileName
	"Have this indirection to allow for the same initialization method to be used in MyToolsBase and MyToolsEnvy."

	^self myEnvyRefactoringExtensionsFileName.! !

!MyToolsEnvy class publicMethodsFor: 'config map stuff'!

loadConfigMapsWithRequired

	| configMapNamesToLoad |
	configMapNamesToLoad := #('ENVY/Manager').
	self loadConfigMapsWithRequired: configMapNamesToLoad.!

loadConfigMapsWithRequired: configMapNamesToLoad

	Transcript cr; show: 'Loading (with required maps) config maps...'.
	configMapNamesToLoad
		do: 
			[:aConfigMapName | 
			| latestConfigMapEdition |
			latestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) first.
			Transcript cr; show: 'Loading config map: ' , latestConfigMapEdition printString , ' ...'.
			latestConfigMapEdition loadWithRequiredMaps ifFalse: [Dialog warn: 'Loading config map: ' , latestConfigMapEdition printString , ' has failed.']]!

reportOnConfigMapDiffs
	"self reportOnConfigMapDiffs"
	"Simple criteria - compares latest and 2nd latest versions of maps.  Be careful using this if you have multiple streams"

	self reportOnConfigMapDiffs: #( 'Config Map 1' 'Config Map 2' )!

reportOnConfigMapDiffs: configMapsToCompare
	"Simple criteria - compares latest and 2nd latest versions of maps.  Be careful using this if you have multiple streams"

	| browser |
	Transcript cr; show: 'Comparing latest and second latest versions of config maps...'.
	configMapsToCompare do: 
			[:aConfigMapName | 
			| latestConfigMapEdition secondLatestConfigMapEdition |
			latestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) at: 1.
			secondLatestConfigMapEdition := (EmConfigurationMap editionsFor: aConfigMapName) at: 2.
			browser := EtApplicationsChangesBrowser 
						forApplications: (secondLatestConfigMapEdition 
								differencesWith: latestConfigMapEdition)
						in: latestConfigMapEdition.
			browser printChangesReportToTranscript]! !

!MyToolsEnvy class publicMethodsFor: 'forensics'!

findSubString
	"Searches in foreground for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - work in progress - need to refactor between me and super class.   The differences are:
		-uses the EtHighlightingMethodsBrowser, which is nice in that it successfully highlights recurring occurances
		-add methods, as opposed to method defs (req't of EtHighlightingMethodsBrowser)"

	| methods startingClass wildCardString allSelectors searchString |
	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

	methods := OrderedCollection new.
	startingClass withAllSubclasses do: 
			[:cls | 
			allSelectors := cls selectors.	"Add the instance selectors of the class"
			allSelectors addAll: cls class selectors.	"Add the class selectors of the class"
			allSelectors do: 
					[:selector | 
					"Get the selector if it is an instance method, failing that get a selector if it is a class method, failing that print an error to the transcript and return false"
					| method source |
					method := cls compiledMethodAt: selector
								ifAbsent: 
									[cls class compiledMethodAt: selector
										ifAbsent: 
											[Transcript
												show: 'missing method: ';
												show: selector;
												cr.
											false]].
					method == false 
						ifFalse: 
							[source := self myBridge implementGetSourceFor: method. 
							(source notNil and: [wildCardString match: source]) 
								ifTrue: [methods add: method]]]].
	methods isEmpty
		ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
		ifFalse: [(EtHighlightingMethodsBrowser 
			on: methods
			labeled: 'Methods with: ' , wildCardString printString
			highlighting: searchString)
			open]!

findSubStringInBackground
	"VW 2.5.2  Searches in background for specified substring (no wildcards needed), and recurses down subclasses."
	"FIXME - work in progress - need to refactor between me and super class.  The differences are:
		-uses the EtHighlightingMethodsBrowser, which is nice in that it successfully highlights recurring occurances
		-add methods, as opposed to method defs (req't of EtHighlightingMethodsBrowser)"

	| methods startingClass wildCardString allSelectors searchString |

	startingClass := Dialog request: 'Class?' initialAnswer: ParagraphEditor currentSelection string.
	startingClass isEmpty ifTrue: [^nil].
	startingClass := Smalltalk at: startingClass asSymbol
				ifAbsent: 
					[Dialog warn: 'Class ' , startingClass , ' wasn''t found.'.
					^nil].
	searchString := Dialog request: 'String to search for' initialAnswer: ParagraphEditor currentSelection string.
	searchString isEmpty ifTrue: [^nil].
	wildCardString := '*' , searchString , '*'.

  methods := OrderedCollection new.
  startingClass withAllSubclasses do: 
	[:cls | 
	"For each class we are searching, yield control at a lower priority than the 
	userSchedulingPriority, as well as a lower priority than for each method 
	below, so the methods being searched resume before iterating over the 
	classes."
	[allSelectors := cls selectors.  "Add the instance selectors of the class"
	allSelectors addAll: cls class selectors. "Add the class selectors of the class"
	allSelectors do: 
	  [:selector | 
		[| method source |
		  "Get the selector if it is an instance method, failing that get a 
		  selector if it is a class method, failing that print an error to the 
		  transcript and return false"

		method := cls compiledMethodAt: selector 
				  ifAbsent: [cls class compiledMethodAt: selector
					ifAbsent: [Transcript show: 'missing method: '; show: selector; cr. false]].
		(method == false)
	  ifFalse: 
	    [source := self myBridge implementGetSourceFor: method.
	    (source notNil and: [wildCardString match: source])
	      ifTrue: ["If there is a match, add the method to the 
		OrderedCollection methods, yield control, and fork at a priority slightly lower 
		than the userSchedulingPriority. This allows VW to refresh 
		itself so the user can busy themselves with other tasks."
		methods add: method]].
		 Processor yield] 
	   forkAt: 49].
	"Check to see if we're on the last class of the OrderedCollection 
	we are checking, and if so open the MethodsBrowser and get a screen 
	refresh so that the user doesn't have to manually refresh the window."
	(cls = startingClass withAllSubclasses last)
	  ifTrue: 
		[methods isEmpty
			ifTrue: [Dialog warn: 'No occurances of: ', wildCardString, ' were found.']
			ifFalse: [(EtHighlightingMethodsBrowser
				  on: methods
				  labeled: 'Methods with: ' , wildCardString
				  highlighting: searchString) open.
		ScheduledControllers restore]].
	Processor yield]
  forkAt: 48]! !

!MyToolsEnvy class publicMethodsFor: 'help/documentation'!

helpScreen
	"Since the help screen text is on the class comment of MyToolsBase, need to override my inherited method to this effect."

	MyToolsBase helpScreen! !

!MyToolsEnvy class publicMethodsFor: 'misc'!

changeOwnershipsOfUser
	"Use this method with care!!"

	"FIXME - update method to provide a little info before executing (like, needs to be run as the Library Supervisor, as well as prompting the user for users."

	| newUser classNames users |
	Transcript clear.
	newUser := EmUser called: 'New Owner'.
	users := Set withAll: EmUser allUsers.
	users remove: (EmUser called: 'Old Owner') ifAbsent: [self halt].
	users do: 
			[:user | 
			Transcript
				show: 'changing user: ' , user uniqueName;
				cr.
			Tools managerInterface selectSubApplications: 
					[:app | 
					(app groupMembers includes: user) 
						ifTrue: 
							[classNames := app allClassNamesOwnedBy: user.
							(app groupMembers includes: newUser) 
								ifFalse: 
									[app updateEdition: 
											[:editionRecord | 
											editionRecord
												addGroupMember: newUser uniqueName;
												insert]].
							app editionRecord manager = user uniqueName 
								ifTrue: 
									[app 
										updateEdition: [:editionRecord | editionRecord manager: newUser uniqueName]].
							classNames notEmpty 
								ifTrue: 
									[app 
										updateEdition: [:editionRecord | editionRecord ownerOf: classNames to: newUser uniqueName]].
							app updateEdition: 
									[:editionRecord | 
									editionRecord
										removeGroupMember: user uniqueName;
										insert]]]]!

copySpecForClass: selectedClass inApplication: selectedApp

	| classSpec appSpec fullClassSpec |
	selectedApp isVersion
		ifTrue: [appSpec := selectedApp versionName]
		ifFalse: [appSpec := selectedApp timeStamp printString.
			selectedApp isScratch
				ifTrue: [appSpec := '<< ', selectedApp versionName, ' >>']].
	(selectedClass isVersionIn: selectedApp)
		ifTrue: [classSpec := selectedClass versionNameIn: selectedApp]
		ifFalse: [classSpec := (selectedClass timeStampIn: selectedApp) printString].
	fullClassSpec := selectedApp printString, ' ', appSpec, ' ', selectedClass name, ' ', classSpec.
	Transcript cr; show: fullClassSpec.
	ParagraphEditor currentSelection: fullClassSpec.! !

!MyToolsEnvy class publicMethodsFor: 'workspaces'!

workspaceJasonDefault
	"This is an example persistent workspace.  The workspace text is actually stored in my comment in an ENVYized environment.  You need to be careful if copying,  renaming, or filing in/out this method, as any comment text is lost in those operations.  The nice aspect of storing workspaces this way, is you can type text with comments intersperced, which is often useful in workspace code.
	If this is a default method that is used a lot, then it's handy to put its invocation in the loaded method of the application this code is stored in."

	ComposedTextView 
		open: (ValueHolder with: (self class compiledMethodAt: #workspaceJasonDefault) comment)
		label: 'Jason''s default workspace'
		icon: (Icon constantNamed: #workspace)
		extent: 500 @ 600! !

!MyToolsImplementor class publicMethodsFor: 'bridging'!

implementorToUse
	"FIXME - quick-n-dirty test for which implementor to use."

	ParagraphEditor classPool at: #Keyboard
		ifAbsent: 
			[SmalltalkFlavour := 'VisualWorks v3.x'.
			^Vw31_Implementor].
	"implicit else"
	SmalltalkFlavour := 'VisualWorks v2.5.2'.
	^Vw252_Implementor!

notImplemented

	Dialog warn: 'NOTE:  Not implemented for ', self smalltalkFlavourString.!

notImplementedYet

	Dialog warn: 'NOTE:  Not implemented for ', self smalltalkFlavourString, ' yet.'.!

smalltalkFlavourString

	^SmalltalkFlavour!

smalltalkTypeString

	^self smalltalkFlavourString! !

!MyToolsImplementor class publicMethodsFor: 'class initialization'!

implementAddToLauncher
	
	self notImplementedYet.!

implementInitialize

	"Stub - do nothing by default."! !

!MyToolsImplementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings

	self notImplementedYet.!

implementSetDeleteKey

	"Stub out by default, implement as needed in subclasses."!

implementSetEmacsKeyBindings

	self notImplementedYet.!

implementSetFileBrowserToShowAllFiles

	self notImplementedYet.! !

!MyToolsImplementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus

	self notImplementedYet.! !

!MyToolsImplementor class publicMethodsFor: 'forensics'!

implementMethodToAddWith: aMethod
	"Override as neccessary to return method, method definition, or whatever else is needed.  This concrete implementation is used in the text searching methods."

	^aMethod! !

!StandardSystemController class publicMethodsFor: 'class initialization'!

initializeForAdditions
	"Initialize the menu."

	ScheduledBlueButtonMenu := 
		Menu 
			labels: 'relabel as...\refresh\move\resize\front\back\collapse\close\inspect' withCRs 
			lines: #(1 7 8)
			values: #( #newLabel #display #move #resize #front #back #collapse #close #inspectView).! !

!StandardSystemController publicMethodsFor: 'menu messages'!

inspectView

	self view model inspect! !

!SystemNavigator publicMethodsFor: 'mytools - extensions'!

copyFullClassSpec

	MyTools copySpecForClass:  (Smalltalk at: self className) inApplication: self application.!

findSubStringOverClasses

	MyTools findSubStringForClasses: self classNames.!

inspectSelectedMethod

	"Only works on class methods, obviously, but can't find a hook to disable when viewing instance methods."
	((Smalltalk at: self className) perform: self selector) inspect.!

sendSelectedMethod

	"Only works on class methods, obviously, but can't find a hook to disable when viewing instance methods."
	(Smalltalk at: self className) perform: self selector.! !

!Vw252_Implementor class publicMethodsFor: 'class initialization'!

implementInitialize

	super implementInitialize.
	self
		implementSetDefaultKeyBindings;
		implementSetDeleteKey! !

!Vw252_Implementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings
	"Set some reasonable key bindings. Only takes effect on newly opened windows"

	(ParagraphEditor classPool at: #Keyboard)
		bindValue: #copyKey: to: (TextConstants at: #Ctrlx);
		bindValue: #pasteKey: to: (TextConstants at: #Ctrlv);
		bindValue: #findDialogKey: to: (TextConstants at: #Ctrlf);
		bindValue: #findKey: to: (TextConstants at: #Ctrla);
		bindValue: #acceptKey: to: (TextConstants at: #Ctrls);
		bindValue: #undoKey: to: (TextConstants at: #Ctrlz)

	"Decided not to override Ctrl-c to Micro$oft copy shortcut.  We could do this and override the interrupt key to somethink like Ctrl-q, but for the default toolkit this probably creates more confusion than good.  The trade-off here is to map Ctrlx to copy instead of cut, leaving the default Smalltalk break key in place."

	"If you want to override Ctrl-c, uncomment below text and comment out above two lines"
	"		InputState interruptKeyValue: (TextConstants at: #Ctrlq);
		bindValue: #copyKey: to: (TextConstants at: #Ctrlc);
		bindValue: #cutKey: to: (TextConstants at: #Ctrlx);
		bindValue: #pasteKey: to: (TextConstants at: #Ctrlv);
"!

implementSetDeleteKey
	"Fix that darn delete key to do what it's supposed to do"

	LookPreferences deleteForward: true!

implementSetEmacsKeyBindings
	" Only takes effect on newly opened windows"

	(ParagraphEditor classPool at: #Keyboard)
		bindValue: #pasteKey: to: (TextConstants at: #Ctrly);
		bindValue: #findDialogKey: to: (TextConstants at: #Ctrls);
		bindValue: #homeKey: to: (TextConstants at: #Ctrla);
		bindValue: #endKey: to: (TextConstants at: #Ctrle);
		bindValue: #deleteKey: to: (TextConstants at: #Ctrld);
		bindValue: #cursorRightKey: to: (TextConstants at: #Ctrlf);
		bindValue: #cursorLeftKey: to: (TextConstants at: #Ctrlb);
		bindValue: #cursorUpKey: to: (TextConstants at: #Ctrlp);
		bindValue: #cursorDownKey: to: (TextConstants at: #Ctrln)! !

!Vw252_Implementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus
	"A non-intrusive way to extend the RB menus."

	RefactoringBrowser allInstances do: 
			[:aBrowser | 
			(aBrowser navigator selectorMenu labels includes: 'send this method') 
				ifFalse: 
					[(aBrowser navigator selectorMenu)
						addSeparator;
						add: 'send this method' -> #sendSelectedMethod;
						add: 'inspect this method' -> #inspectSelectedMethod.
					(aBrowser navigator classMenu)
						addSeparator;
						add: 'copy full class spec' -> #copyFullClassSpec;
						add: 'Find substring...' -> #findSubStringOverClasses]]! !

!Vw252_Implementor class publicMethodsFor: 'forensics'!

implementGetSourceFor: method
	
	^method sourceString.!

implementMethodSelectorFor: method
	
	^method mclass printString, ' ', method selector.! !

!Vw31_Implementor class publicMethodsFor: 'customization'!

implementSetDefaultKeyBindings
	"Set some reasonable key bindings."

	UIFeelPolicy new keyboardDispatchTableWithBellsAndWhistles! !

!Vw31_Implementor class publicMethodsFor: 'extensions'!

implementExtendRefactoringBrowserMenus
	"A non-intrusive way to extend the RB menus."

	RefactoringBrowser allInstances do: 
			[:aBrowser | 
			(aBrowser navigator selectorMenu value labels includes: 'send this method') 
				ifFalse: 
					[aBrowser navigator selectorMenu value 
						addItemGroupLabels: #('send this method' 'inspect this method')
						values: #(#sendSelectedMethod #inspectSelectedMethod).
					aBrowser navigator classMenu value 
						addItemGroupLabels: #('copy full class spec' 'Find substring...')
						values: #(#copyFullClassSpec #findSubStringOverClasses)]]! !

!Vw31_Implementor class publicMethodsFor: 'forensics'!

implementGetSourceFor: method

	^method getSource.!

implementMethodSelectorFor: method
	
	^method definition!

implementMethodToAddWith: aMethod

	^aMethod definition! !

!Vw_Implementor class publicMethodsFor: 'class initialization'!

implementAddToLauncher
	"Snippet to add to the Tools menu for the current VisualLauncher(s)."

	| myToolsItem menuChannelIndex launcherClass launcherControllers launcherWindows menuBar menu toolsItem uiSettingsClass |
	myToolsItem := (MenuItem labeled: 'My Tools') 
		submenu: (Menu labelArray: #('MyTools help' 
									'Find complete string...' 
									'Find substring...' 
									'Find substring, background...' 
									'Add extensions to Refactoring Browser'
									'Build MyTools')
						values: ((OrderedCollection new)
								add: [MyTools helpScreen];
								add: [MyTools findString];
								add: [MyTools findSubString];
								add: [MyTools findSubStringInBackground];
								add: [MyTools extendRefactoringBrowserMenus];
								add: [MyTools build];
								asArray)).	

	"Collect the open launchers"
	launcherClass := Smalltalk at: #VisualLauncher ifAbsent: [Dialog warn: 'WARN:  Can''t find VisualLauncher class!!'].
	launcherControllers := ScheduledControllers scheduledControllers select: 
					[:aSchedualedController | aSchedualedController view class == ApplicationWindow 
						and: [aSchedualedController view model isKindOf: launcherClass]].
	launcherWindows := launcherControllers collect: [:aLauncher | aLauncher view].

	"Need to access the menuChannel indirectly here because the menuChannel accessor is not implemented in all versions of VW."
	menuChannelIndex := MenuBar instVarIndexFor: 'menuChannel'.
	menuChannelIndex = 0 ifTrue: [Dialog warn: 'WARN:  Can''t find menu channel index'].

	launcherWindows do: 
			[:aLauncherWindow | 
			menuBar := aLauncherWindow menuBar.
			menu := (menuBar instVarAt: menuChannelIndex) value.
			toolsItem := menu menuItemLabeled: 'Tools' ifNone: [Dialog warn: 'WARN:  Can''t find Tools menu item'].
			(toolsItem submenu labels includes: 'My Tools')
				ifFalse: [toolsItem submenu addItem: myToolsItem.
						menuBar updateMenu]].

	" watch for changes to UISettings"
	uiSettingsClass := Smalltalk at: #UISettings.
	uiSettingsClass notNil 
		ifTrue: 
			[(uiSettingsClass preferenceModelFor: #hostWindowManagerSelector) 
				onChangeSend: #myAddToToolsMenu
				to: self]!

implementInitialize

	StandardSystemController initializeForAdditions.! !

!Vw_Implementor class publicMethodsFor: 'customization'!

implementSetFileBrowserToShowAllFiles

	FileBrowser defaultPattern: '*'! !

!Vw_Implementor class publicMethodsFor: 'forensics'!

implementMethodSelectorFor: method
	
	self notImplementedYet.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!




!MyToolsApp class publicMethodsFor: 'class initialization'!

loaded
	MyToolsBase initialize! !
