"	NAME		Polyline-outlineIntersects-fix
	AUTHOR		geidel@wior360.wiwi.uni-karlsruhe.de (Joachim Geidel)
	CONTRIBUTOR	geidel@wior360.wiwi.uni-karlsruhe.de (Joachim Geidel)
	FUNCTION 	 OWST R4.1 Patch for Polyline>>outlineIntersects:
	ST-VERSIONS	R4.1
	PREREQUISITES	 
	CONFLICTS	 Polyline>>outlineIntersects:
	DISTRIBUTION	world
	VERSION	R	2
	DATE		25 Nov 1992
SUMMARY
Polyline>>outlineIntersects: answers false whenever a Polyline has only
points which have the same horizontal or vertical coordinate. This
results from the first test in the method which checks if the bounds of
the Polyline intersect aRectangle. If the Polyline is a horizontal or
vertical line, the bounds have height resp. width 0, and the test fails.
This is often wrong, of course, as the Polyline can still intersect the
outline of the rectangle. The following method avoids this behaviour by
skipping the first test if the Polyline has only horizontally or
vertically aligned points."

'From Objectworks\Smalltalk(R), Release 4.1 of 15 April 1992 on 25
November 1992 at 11:01:49 am'!

!Polyline methodsFor: 'testing'!

outlineIntersects: aRectangle
	"Answer true if the receiver intersects the supplied rectangle."

	"Eliminate the trivial failures"
	"But avoid incorrect answer when the receiver is only a horizontal or
vertical 
	line segment."
	"But avoid incorrect answer when the receiver's vertices are horizontally or 
	vertically aligned."
	self bounds extent > (0 @ 0) ifTrue: [(super outlineIntersects: aRectangle)
			ifFalse: [^false]].
	^self class vertices: vertices intersectsRectangle: aRectangle! !



