Drawing subclass: #AnimatedDrawing
	instanceVariableNames: 'animationProcess '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Animation'!
AnimatedDrawing comment:
'AnimatedDrawing is a Drawing that can animate figure. To create an animated drawing, simply subclass this class, and override the #step method. 

Instance Variables:
	animationProcess	<Process>	the process that runs the animation (if it runs at a different priority than the UI process, then locking will be needed)

'!


!AnimatedDrawing methodsFor: 'accessing'!

animationBlock
	^
	[| delay |
	delay := Delay forMilliseconds: self delayTime.
	
	[delay wait.
	self canAnimate 
		ifTrue: 
			[self step.
			self repairDamage]] 
			repeat]!

container: aVisualComponent 
	super container: aVisualComponent.
	aVisualComponent isNil 
		ifTrue: [self stopAnimation]
		ifFalse: [self startAnimation]!

delayTime
	^10 "ms"!

startAnimation
	animationProcess isNil 
		ifTrue: [animationProcess := self startAnimationProcess]!

startAnimationProcess
	^self animationBlock fork!

step!

stopAnimation
	animationProcess isNil ifTrue: [^self].
	animationProcess terminate.
	animationProcess := nil! !

!AnimatedDrawing methodsFor: 'initialize-release'!

release
	self stopAnimation.
	super release! !

!AnimatedDrawing methodsFor: 'testing'!

canAnimate
	^self controller currentTool isIdle! !

