'From VisualWorks(R), Release 2.5.1 of September 26, 1995 on January 8, 1998 at 8:19:59 am'!



!Object methodsFor: 'user interface'!

draw
	| figure drawing |
	drawing := Drawing new.
	figure := ObjectFigure object: self.
	drawing
		add: figure;
		edit! !


CachedFigure subclass: #ObjectFigure
	instanceVariableNames: 'object inEdges outEdges '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Drawing Inspector'!
ObjectFigure comment:
'ObjectFigure is a Figure that represents an object in a DrawingInspector.  ObjectFigures are wrappers for all other classes of Objects in Smalltalk so that they can be inspected inside a DrawingInspector.

Instance Variables :

object  <Object>	The object for which this is the wrapper.'!


!ObjectFigure methodsFor: 'accessing'!

handles
	| yloc variableNames xloc height refHandles classHandle dependentHandle referencedObject |
	yloc := 'a' asComposedText height * 3 // 2.
	height := 'a' asComposedText height.
	(self shouldDisplayAsString 
		or: [(variableNames := self allSlotNames) isEmpty]) 
			ifTrue: [^Array with: (Handle on: self at: #origin)].
	refHandles := OrderedCollection new.
	variableNames do: 
			[:varName | 
			referencedObject := self instVar: varName.
			referencedObject notNil 
				ifTrue: 
					[| xloc1 |
					xloc1 := varName asComposedText width.
					refHandles 
						add: (self handleFor: referencedObject offset: (xloc1 + 6) @ yloc)].
			yloc := yloc + height].
	xloc := object class name asComposedText width.
	classHandle := self handleFor: object class offset: (xloc + 4) @ 8.
	dependentHandle := self handleFor: object dependents
				offset: (self extent x // 2) @ 0.
	^refHandles , (Array with: classHandle with: dependentHandle)!

inspectObject
	self object inspect!

localInspectObject
	| inspector |
	inspector := Inspector inspect: object.
	self drawing add: (ViewAdapterFigure 
				view: (inspector allButOpenInterface: #windowSpec) window component
				in: (10 @ 10 corner: 250 @ 250))!

menuAt: aPoint 
	| mb |
	mb := MenuBuilder new.
	mb
		add: 'inspect...' -> #inspectObject;
		add: 'local inspect' -> #localInspectObject;
		line;
		add: 'other' -> (super menuAt: aPoint).
	^mb menu!

object
	^object!

origin: aPoint 
	bounds := aPoint extent: self extent!

title
	^object class name! !

!ObjectFigure methodsFor: 'connection'!

connectFromPoint: myPoint to: aFigure at: figurePoint 
	| newFigure |
	newFigure := super 
				connectFromPoint: myPoint
				to: aFigure
				at: figurePoint.
	self addOutEdge: newFigure.
	aFigure addInEdge: newFigure.
	newFigure
		addDependent: self;
		addDependent: aFigure.
	newFigure model: (ObjectConnectionModel new 
				start: self
				offset: myPoint
				stop: aFigure).
	^newFigure!

createStartConnectionConstraintFor: newFigure at: myPoint 
	PositionConstraint 
		send: #startPoint:
		to: newFigure
		with: (MessageSend 
				receiver: self
				selector: #offOrigin:
				argument: myPoint)! !

!ObjectFigure methodsFor: 'damage control'!

deletionUpdateFrom: aFigure 
	self removeDependent: aFigure.
	aFigure removeDependent: self.
	inEdges remove: aFigure ifAbsent: [].
	outEdges remove: aFigure ifAbsent: []! !

!ObjectFigure methodsFor: 'displaying'!

delete
	self reconnectIndirectReferences.
	super delete!

displayFigureOn: aGraphicsContext 
	self shouldDisplayAsString 
		ifTrue: [self displayName displayOn: aGraphicsContext at: self origin]
		ifFalse: [super displayFigureOn: aGraphicsContext]!

displayName
	| name |
	name := object printString.
	name size > 50 ifTrue: [name := (name copyFrom: 1 to: 50) , '...'].
	^name asComposedText!

fillCache
	| title vars aGC rect |
	title := self title asComposedText.
	vars := self variableLabels asComposedText.
	cache := Pixmap 
				extent: 0 @ title height + (title extent max: vars extent) + 4.
	aGC := cache graphicsContext.
	aGC medium background: LookPreferences defaultForWindows backgroundColor.
	aGC clear.
	title displayOn: aGC at: 0 @ 0.
	aGC paint: ColorValue white.
	rect := 0 @ title height extent: cache extent - (0 @ title height) - 1.
	aGC displayRectangle: rect.
	aGC paint: ColorValue black.
	aGC displayRectangularBorder: rect.
	vars displayOn: aGC at: 2 @ title height.
	^cache asImage! !

!ObjectFigure methodsFor: 'edges'!

addInEdge: anEdge 
	inEdges add: anEdge!

addOutEdge: anEdge 
	outEdges add: anEdge!

createIndirectReferenceFrom: aLineFigure to: outLineFigure 
	| stopFigure startFigure edge |
	startFigure := aLineFigure model start.
	stopFigure := outLineFigure model stop.
	edge := startFigure 
				connectFromPoint: aLineFigure model offset
				to: stopFigure
				at: stopFigure origin.
	edge lineColor: ColorValue gray.
	edge lineWidth: 2.
	self drawing add: edge!

reconnectIndirectReferences
	"When an object is deleted, reconnect each input to each output."

	| fromFigures toFigures |
	fromFigures := (inEdges collect: [:each | each model start]) asSet.
	toFigures := (outEdges collect: [:each | each model stop]) asSet.
	fromFigures remove: self ifAbsent: [].
	toFigures remove: self ifAbsent: [].
	inEdges do: 
			[:aLineFigure | 
			(fromFigures includes: aLineFigure model start) 
				ifTrue: 
					[fromFigures remove: aLineFigure model start.
					outEdges do: 
							[:outLineFigure | 
							(toFigures includes: outLineFigure model stop) 
								ifTrue: 
									[self createIndirectReferenceFrom: aLineFigure to: outLineFigure]]]]! !

!ObjectFigure methodsFor: 'initialize-release'!

initialize
	super initialize.
	inEdges := Set new.
	outEdges := Set new! !

!ObjectFigure methodsFor: 'private'!

allSlotNames
	| showing max |
	showing := 20.
	max := object basicSize.
	^object class allInstVarNames , (object class isVariable 
				ifTrue: 
					[(max <= showing 
						ifTrue: [1 to: max]
						ifFalse: [(1 to: showing // 3 * 2) , (max - (showing // 3) to: max)]) 
							collect: [:i | i printString]]
				ifFalse: [#()])!

handleFor: anObject offset: aPoint 
	| handle |
	handle := Handle 
				on: self
				at: #offOrigin:
				offset: aPoint.
	handle model: (ObjectHandleModel for: anObject offset: aPoint).
	handle toolState: (Tool stateFor: 'Object Figure Handle').
	^handle!

instVar: aString 
	| index |
	index := aString first isDigit 
				ifTrue: [Integer readFromString: aString]
				ifFalse: [object class allInstVarNames indexOf: aString].
	^aString first isDigit 
		ifTrue: [object basicAt: index]
		ifFalse: [object instVarAt: index]!

setObject: anObject origin: aPoint 
	object := anObject.
	self fillCache.
	self origin: aPoint!

variableLabels
	| aStream |
	aStream := WriteStream on: String new.
	self allSlotNames do: 
			[:each | 
			aStream
				nextPutAll: each;
				cr].
	aStream isEmpty ifTrue: [^object printString] ifFalse: [aStream skip: -1].
	^aStream contents! !

!ObjectFigure methodsFor: 'testing'!

shouldDisplayAsString
	^object isLiteral or: [#(#Point #Rectangle) includes: object class name]! !

!ObjectFigure methodsFor: 'transforming'!

computePreferredBounds
	^bounds isNil 
		ifTrue: [0 @ 0 extent: self extent]
		ifFalse: [bounds origin extent: self extent]!

extent
	^self shouldDisplayAsString 
		ifTrue: [self displayName extent]
		ifFalse: [self cache extent]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ObjectFigure class
	instanceVariableNames: ''!


!ObjectFigure class methodsFor: 'instance creation'!

object: anObject 
	^self object: anObject at: 0 @ 0!

object: anObject at: aPoint 
	| figure |
	figure := self new.
	^figure
		setObject: anObject origin: aPoint;
		yourself! !


Model subclass: #ObjectHandleModel
	instanceVariableNames: 'object offset '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Drawing Inspector'!
ObjectHandleModel comment:
'ObjectHandleModel contains information for the ObjectFigure''s handles. It contains the object of the figure that is to be created as well as its offset.

Instance Variables:
	object	<Object>	the object that this handle is for. An ObjectFigure will be created for this object, it the handle is clicked on.
	offset	<Point>	the offset from our owner for this handle
'!


!ObjectHandleModel methodsFor: 'accessing'!

object
	^object!

object: anObject
	object := anObject!

offset
	^offset!

offset: anObject
	offset := anObject! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ObjectHandleModel class
	instanceVariableNames: ''!


!ObjectHandleModel class methodsFor: 'instance creation'!

for: anObject offset: aPoint 
	^(self new)
		object: anObject;
		offset: aPoint;
		yourself! !


!Tool class methodsFor: 'tool states'!

initializeObjectFigureHandleStates
	"This method was automatically generated by the HotDraw ToolStateMachineEditor.
	To edit this method, evaluate the comment below"

	"| states transitions stateTable |
	states := ((OrderedCollection new) add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Object Figure Handle'; instVarAt: 3 put: (Text string: '[:tool :event | 
| handle object cursorPoint figure |
cursorPoint := tool cursorPointFor: event.
handle := tool figureAtEvent: event.
object := handle model object.
figure := tool drawing components detect: [:each | each class = ObjectFigure and: [each object == object]] 
	ifNone: [nil].
figure isNil ifTrue: [
		figure := ObjectFigure object: object at: cursorPoint.
		tool drawing add: figure.
		tool drawing add: 
			(handle owner 
				connectFromPoint: handle model offset 
				to: figure 
				at: cursorPoint).
		tool valueAt: #figure put: figure]
	ifFalse: [tool drawing add: (handle owner 
			connectFromPoint: handle model offset 
			to: figure at: cursorPoint).
		tool changeToState: (Tool stateFor: ''End State'') event: event]
]' runs: (RunArray runs: #(770) values: #(nil))); instVarAt: 4 put: (Point x: 196 y: 46); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Object Figure Move'; instVarAt: 3 put: (Text string: '[:tool :event | 
(tool valueAt: #figure) translateTo: (tool cursorPointFor: event)]' runs: (RunArray runs: #(83) values: #(nil))); instVarAt: 4 put: (Point x: 87 y: 156); instVarAt: 5 put: false; instVarAt: 6 put: false; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'Cancel Figure Creation'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 329 y: 156); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); add: (ToolStateModel basicNew instVarAt: 1 put: nil; instVarAt: 2 put: 'End State'; instVarAt: 3 put: '[:tool :event | ]'; instVarAt: 4 put: (Point x: 302 y: 280); instVarAt: 5 put: false; instVarAt: 6 put: true; yourself); yourself).
	stateTable := Dictionary new.
	states do: [:each | stateTable at: each name put: each].

	transitions := OrderedCollection new.
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Object Figure Handle'); to: (stateTable at: 'Object Figure Move'); type: (TransitionType basicNew instVarAt: 1 put: #mouseMove; yourself); points: ((OrderedCollection new) add: (Point x: 240 y: 76); add: (Point x: 162 y: 156); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Object Figure Move'); to: (stateTable at: 'Object Figure Move'); type: (TransitionType basicNew instVarAt: 1 put: #mouseMove; yourself); points: ((OrderedCollection new) add: (Point x: 146 y: 187); add: (Point x: 145 y: 229); add: (Point x: 100 y: 233); add: (Point x: 132 y: 186); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Object Figure Move'); to: (stateTable at: 'End State'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonRelease; yourself); points: ((OrderedCollection new) add: (Point x: 173 y: 186); add: (Point x: 316 y: 281); yourself); yourself).
	transitions add: (ToolStateTransitionModel new from: (stateTable at: 'Object Figure Handle'); to: (stateTable at: 'Cancel Figure Creation'); type: (TransitionType basicNew instVarAt: 1 put: #redButtonRelease; yourself); points: ((OrderedCollection new) add: (Point x: 281 y: 76); add: (Point x: 381 y: 156); yourself); yourself).
	ToolStateMachineEditor openWithStates: states connections: transitions"

	Tool states at: 'Object Figure Handle' put: (ToolState name: 'Object Figure Handle' command: [:tool :event | 
| handle object cursorPoint figure |
cursorPoint := tool cursorPointFor: event.
handle := tool figureAtEvent: event.
object := handle model object.
figure := tool drawing components detect: [:each | each class = ObjectFigure and: [each object == object]] 
	ifNone: [nil].
figure isNil ifTrue: [
		figure := ObjectFigure object: object at: cursorPoint.
		tool drawing add: figure.
		tool drawing add: 
			(handle owner 
				connectFromPoint: handle model offset 
				to: figure 
				at: cursorPoint).
		tool valueAt: #figure put: figure]
	ifFalse: [tool drawing add: (handle owner 
			connectFromPoint: handle model offset 
			to: figure at: cursorPoint).
		tool changeToState: (Tool stateFor: 'End State') event: event]
]).
	Tool states at: 'Object Figure Move' put: (ToolState name: 'Object Figure Move' command: [:tool :event | 
(tool valueAt: #figure) translateTo: (tool cursorPointFor: event)]).
	(Tool stateFor: 'Object Figure Handle') redButtonRelease: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Cancel Figure Creation'); yourself).
	(Tool stateFor: 'Object Figure Handle') mouseMove: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Object Figure Move'); yourself).
	(Tool stateFor: 'Object Figure Move') redButtonRelease: ((SimpleTransitionTable new) goto: (Tool stateFor: 'End State'); yourself).
	(Tool stateFor: 'Object Figure Move') mouseMove: ((SimpleTransitionTable new) goto: (Tool stateFor: 'Object Figure Move'); yourself).! !


Model subclass: #ObjectConnectionModel
	instanceVariableNames: 'fromFigure offset toFigure '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'HotDraw-Drawing Inspector'!
ObjectConnectionModel comment:
'ObjectConnectionModel contains the extra information needed for connections between lines. Instead of creating a subclass of LineFigure to hold this information, we store it as the model of the line.

Instance Variables:
	fromFigure	<ObjectFigure>	our originator
	offset	<Point>	offset in the fromFigure of our start
	toFigure	<ObjectFigure>	our destination'!


!ObjectConnectionModel methodsFor: 'accessing'!

offset
	^offset!

start
	^fromFigure!

stop
	^toFigure! !

!ObjectConnectionModel methodsFor: 'initialize-release'!

start: aFigure offset: anOffset stop: anotherFigure
	fromFigure := aFigure.
	offset := anOffset.
	toFigure := anotherFigure! !


