"
 The CodePrinter is used for printing out a pretty version of your code with comments. You can
 selectively pick any classes, methods, and class definitions and print to either a Latex or RTF file.
 Extra support is provided on the UNIX environment for creating dvi and postscript files along with
 the ability to send output to a printer.

 Version: 1.0
 Author:  Joseph W. Yoder
 Email:   j-yoder@uiuc.edu
 Web Site: http://www-cat.ncsa.uiuc.edu/~yoder/Reserach/CodePrinter
"

| signal formattedStreams classDescription filenameFormatted codePrinting oldChangeSet noChanges |

"Initialize the filename to use below"

formattedStreams := 'Formatted-Streams.st'.
classDescription := 'ClassDescription-formatted.st'.
filenameFormatted := 'Filename-formattedstream.st'.
codePrinting := 'Code-Printing.st'.


noChanges := Dialog confirm: 'Do you wish to file-in without modifying current change set?'.
[
noChanges ifTrue: 
	[oldChangeSet := ChangeSet current. 
	ChangeSet newChanges: ChangeSet new].

signal := Signal new.
signal handle: [:ex | ex return]
	do: 
		[| directory ctx name |
"Try to find the directory of the file-in. If this is not working, you can replace these lines with an assignment of the directory."
		ctx := thisContext.
		[ctx isNil or: [(ctx receiver isKindOf: Filename) or: [ctx receiver isKindOf: FileBrowser]]]
			whileFalse: [ctx := ctx sender].
		ctx isNil
			ifTrue: 
				[name := Dialog request: 'Enter directory that contains the sources:'.
				name isEmpty ifTrue: [signal raise].
				directory := name asFilename.
				directory exists
					ifFalse: 
						[Dialog warn: 'Directory does not exist'.
						signal raise]]
			ifFalse: [directory := ((ctx receiver isKindOf: Filename) ifTrue: [ctx receiver] ifFalse: [ctx receiver fileName asFilename]) directory].

"Start the installation process"
	(#(#RefactoringBrowser #Refactoring #BrowserEnvironment) contains: [:each | Smalltalk includesKey: each])
                               ifFalse:[Dialog warn: 'Cannot install the code printer until the Refactory browser in installed.'.
                                                signal raise].
                                                                         
                (directory construct: formattedStreams) fileIn.
                (directory construct: classDescription) fileIn.
                (directory construct: filenameFormatted) fileIn.
                (directory construct: codePrinting) fileIn.]]


			valueNowOrOnUnwindDo: [
				noChanges ifTrue: [ChangeSet newChanges: oldChangeSet]]!

Transcript cr; show: 'To start using the tool, execute the following command: ''CodeSelector open''.'; cr!