'From VisualWave(R), Release 2.0a of December 11, 1996 on May 5, 1998 at 3:26:47 am'!



!ClassDescription methodsFor: 'formatted fileIn/Out'!

definitionAsTable
	| table |
	table := OrderedCollection new.
	table add: (Association key: 'class name' value: self name).
	table add: (Association key: 'superclass' value: (superclass == nil
				ifTrue: ['']
				ifFalse: [superclass name])).
	table add: (Association key: 'instance variable names' value: self instanceVariablesString).
	table add: (Association key: 'class variable names' value: self classVariablesString).
	table add: (Association key: 'pool dictionaries' value: self sharedPoolsString).
	table add: (Association key: 'category' value: self category asString).
	^table!

fileOutMethodChunk: aSelector on: aFileStream 
	| source parser length |
	Cursor write
		showWhile: 
			[source := (self sourceMethodAt: aSelector) asString.
			(parser := self parserClass new) parseSelector: source.
			length := parser endOfLastToken min: source size.
			["The parser counts subsequent white space as part of a 
			token, so we subtract the length of that white space."
			(source at: length) isSeparator]
				whileTrue: [length := length - 1].
			aFileStream printMethod: (source copyFrom: 1 to: length)
				withBody: (source copyFrom: length + 1 to: source size)]!

fileOutOn: aFileStream 
	aFileStream printClassDefinitionFor: self name from: self definitionAsTable.
	aFileStream printClassComment: self comment.
	self organization categories do: 
		[:heading |
		aFileStream anotherProtocol.
		self fileOutProtocol: heading on: aFileStream]!

fileOutProtocol: aString on: aFileStream 
	self fileOutProtocolChunk: aString on: aFileStream.
	(self organization listAtCategoryNamed: aString)
		do: 
			[:sel | 
			aFileStream anotherMethod.
			self fileOutMethodChunk: sel on: aFileStream]!

fileOutProtocolChunk: aString on: aFileStream 
	aFileStream printProtocolHeader: aString!

latexOutMessage: aString 
	LatexStream for: self name , '-' , aString
		do: 
			[:fileStream | 
			fileStream beginDocument.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			fileStream line: '\begin{center}'.
			fileStream line: '{\Large \bf ' , self name , '}'.
			fileStream line: '\end{center}'.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			self fileOutMethodChunk: aString on: fileStream.
			fileStream endDocument]!

latexOutProtocol: aString 
	LatexStream for: self name , '-' , aString
		do: 
			[:fileStream | 
			fileStream beginDocument.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			fileStream line: '\begin{center}'.
			fileStream line: '{\Large \bf ' , self name , '}'.
			fileStream line: '\end{center}'.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			self fileOutProtocol: aString on: fileStream.
			fileStream endDocument]!

rtfOutMessage: aString 
	RTFStream for: self name , '-' , aString
		do: 
			[:fileStream | 
			fileStream beginDocument.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			fileStream line: '\begin{center}'.
			fileStream line: '{\Large \bf ' , self name , '}'.
			fileStream line: '\end{center}'.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			self fileOutMethodChunk: aString on: fileStream.
			fileStream endDocument]!

rtfOutProtocol: aString 
	RTFStream for: self name , '-' , aString
		do: 
			[:fileStream | 
			fileStream beginDocument.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			fileStream line: '\begin{center}'.
			fileStream line: '{\Large \bf ' , self name , '}'.
			fileStream line: '\end{center}'.
			fileStream line: ''.
			fileStream line: '\addvspace{3ex}'.
			fileStream line: '\noindent'.
			self fileOutProtocol: aString on: fileStream.
			fileStream endDocument]! !
