| signal uninstall dragdropLauncher launcher oldChangeSet noChanges widgets fixes base |

"Initialize the filename to use below"

uninstall := 'Uninstall-old.st'.
base := #('BRParser.st' 'BrowserEnvironments.st' 'Refactorings.st' 'BrowserInterface.st' 'Smalllint.st').
dragdropLauncher := 'DragDropLauncher.st'.
launcher := 'Launcher.st'.
widgets := 'ProgressWidget.st'.
fixes := #().


ObjectMemory versionId first < 30 ifFalse: 
	[^Dialog warn: 'For VisualWorks 3.0 and later you should use the parcels'].

noChanges := Dialog confirm: 'Do you wish to file-in without modifying current change set?'.
[
noChanges ifTrue: 
	[oldChangeSet := ChangeSet current. 
	ChangeSet newChanges: ChangeSet new].

signal := Signal new.
signal handle: [:ex | ex return]
	do: 
		[| directory ctx name |
"Try to find the directory of the file-in. If this is not working, you can replace these lines with an assignment of the directory."
		ctx := thisContext.
		[ctx isNil or: [(ctx receiver isKindOf: Filename) or: [ctx receiver isKindOf: FileBrowser]]]
			whileFalse: [ctx := ctx sender].
		ctx isNil
			ifTrue: 
				[name := Dialog request: 'Enter directory that contains the sources:'.
				name isEmpty ifTrue: [signal raise].
				directory := name asFilename.
				directory exists
					ifFalse: 
						[Dialog warn: 'Directory does not exist'.
						signal raise]]
			ifFalse: [directory := ((ctx receiver isKindOf: Filename) ifTrue: [ctx receiver] ifFalse: [ctx receiver fileName asFilename]) directory].

"Start the installation process"
		(#(#RefactoringBrowser #Refactoring #BrowserEnvironment #BRParser) contains: [:each | Smalltalk includesKey: each])
			ifTrue: [(Dialog confirm: 'Uninstall previous version of the RefactoringBrowser?')
					ifTrue: [((directory construct: uninstall) fileIn) ifFalse: [Dialog warn: 'Cannot install new version until old version is removed'. signal raise]]
					ifFalse: 
						[Dialog warn: 'Cannot install new version over old version'.
						signal raise]].


		(Smalltalk includesKey: #ProgressWidgetView) ifFalse: [(directory construct: widgets) fileIn].

		base do: [:each | (directory construct: each) fileIn].

		(Dialog confirm: 'Do you want to add the RefactoryBrowser to the launcher?')
			ifTrue:
				[(directory construct: launcher) fileIn.
				(Dialog confirm: 'Do you want drag & drop support in the launcher') 
					ifTrue: [(directory construct: dragdropLauncher) fileIn]].

		fixes do: [:each | (directory construct: each) fileIn].

		(Dialog confirm: 'Do you want to mark the RefactoryBrowser classes as system classes?')
			ifTrue: [(Smalltalk at: #BrowserApplicationModel) withAllSubclasses, (Smalltalk at: #BrowserDialog) withAllSubclasses, (Array with: (Smalltalk at: #OMTClassModel)) do: [:each |
					each class compile: 'markedAsSystemClass' classified: #private notifying: nil]]]] 

			valueNowOrOnUnwindDo: [
				noChanges ifTrue: [ChangeSet newChanges: oldChangeSet]]!
